// FUGA Fliegende Untertassen greifen an
// von Dennis Busch

// "all_text.cpp"
// Enthaelt die Stringtabellen fuer Deutsch / Englisch

int game_language;

enum game_text_id
{
  // Fuer die Score Anzeige und im Spiel
  txt_remaining_small=0, txt_remaining_medium, txt_remaining_big,
  txt_attack_wave, txt_survivalbonus, txt_accuracybonus, txt_wave, txt_score, txt_hitratio, txt_game_over, txt_win_the_game,

  // Fuer den Hauptmenue Bildschirm
  txt_main_menue,
  txt_sub_title, txt_moreinfo, txt_moreinfo2, txt_moreinfo3, txt_version, txt_poweredby,
  txt_start_game, txt_difficulty, txt_instructions,
  txt_top_ten, txt_name, txt_points,
  txt_credits, txt_end,
  txt_easy, txt_normal, txt_hard,
  txt_music,
  txt_swapstereo,
  txt_on,
  txt_off,

  txt_with_your_score,
  txt_made_it_to_place,
  txt_enter_name,

  txt_mouse_to_continue,

  // Fuer die Instructionsscreens
  txt_story, txt_mission,
  txt_inst_line00, txt_inst_line01, txt_inst_line02, txt_inst_line03,
  txt_inst_line04, txt_inst_line05, txt_inst_line06, txt_inst_line07,
  txt_inst_line08, txt_inst_line09, txt_inst_line10, txt_inst_line11,
  txt_inst_line12, txt_inst_line13, txt_inst_line14, txt_inst_line15,
  txt_inst_line16, txt_inst_line17, txt_inst_line18, txt_inst_line19,
  txt_inst_line20, txt_inst_line21, txt_inst_line22, txt_inst_line23,
  txt_inst_line24, txt_inst_line25, txt_inst_line26, txt_inst_line27,
  txt_inst_line28, txt_inst_line29, txt_inst_line30, txt_inst_line31,
  txt_inst_line32, txt_inst_line33, txt_inst_line34, txt_inst_line35,
  txt_inst_line36, txt_inst_line37, txt_inst_line38, txt_inst_line39,
  txt_inst_line40, txt_inst_line41, txt_inst_line42, txt_inst_line43,
  txt_inst_line44, txt_inst_line45, txt_inst_line46, txt_inst_line47, txt_inst_line48
};
const int _game_msg_count=txt_inst_line48+1;

// Deutsche Stringtabelle
char *ger_text[] =
{
  "Uebrige Kleine",
  "Uebrige Mittlere",
  "Uebrige Grosse",
  "Angriffswelle",
  "Ueberlebensbonus",
  "Genauigkeitsbonus",
  "Welle",
  "Punkte",
  "Trefferquote",
  "Spiel vorbei!",
  "Du hast das Spiel gewonnen!",
  "Hauptmenue",
  "Fliegende Untertassen greifen an",
  "http://www.dennisbusch.de",
  "http://alleg.sourceforge.net/",
  "http://dumb.sf.net/",
  "Freeware V.1.20g",
  "powered by:",
  "Spiel starten",
  "Schwierigkeit",
  "Spielanleitung",
  "Top 10",
  "Name:",
  "Punkte:",
  "Credits",
  "Spiel beenden",
  "Leicht",
  "Normal",
  "Schwer",
  "\"Musik\"",
  "Stereo vertauschen",
  "An",
  "Aus",
  "Mit deiner Punktzahl von",
  "Belegst du in den Top-Ten den Platz",
  "Verrate mir deinen Namen:",
  "Bitte <linke Maustaste> klicken",
  "Die Geschichte",
  "Die Mission",
  "Es ist das Jahr 2400 und ein paar zerquetschte...", // Instruktionen Zeile 00
  "Da kam es, wie es kommen musste...",
  "Doch vorher noch dieses:",
  "Die Erde ist schon seit 300 Jahren voellig verwuestet.",
  "Keiner weiss mehr was genau damals geschah, jedoch",
  "ist seit damals die Weltbevoelkerung inzwischen wieder",
  "auf ein paar hundert Personen angewachsen.",
  "Diese haben sich auch eine prunkvolle Stadt gebaut.",
  "Mann nennt sie... \"Die Stadt\"",
  "Da dieses Volk ohne Kriege aufgewachsen ist , ist es",
  "eigentlich nicht in der Lage sich vernuenftig gegen",
  "aeussere Bedrohungen zu verteidigen und so nimmt die",
  "Katastrophe ihren Lauf.",
  "Fliegende Untertassen greifen \"DieStadt\" an.",
  "Und die Menschen koennen nur tatenlos zusehen, wie",
  "sie plattgemacht wird.",
  "Doch es gab da einen Menschen, der das alles kommen",
  "sah. Sie nennen ihn... \"DerMensch\"",
  "\"DerMensch\" hatte vor langer Zeit in einer alten",
  "Hoehle ein Relikt aus laengst vergangener Zeit gefunden.",
  "Es war ein uraltes, aber noch funktionsfaehiges",
  "Atari2600 VideoSpielSystem. Das Cartridge, welches",
  "noch immer darin steckte, lehrte \"DerMensch\", dass",
  "man eine Stadt am besten gegen ausserdirdische",
  "verteidigt, indem man zwei popelige Kanonen",
  "an den Stadtraendern aufstellt. Und so baute",
  "\"DerMensch\" diese zwei Kanonen und er sah,",
  "dass es gut war...",                                   // Instruktionen Zeile 27
  "Du bist \"DerMensch\" und hast somit die Gewalt ueber",// Instruktionen Zeile 28
  "zwei ueberaus popelige Kanonen, mit denen du die",
  "Angriffswellen der ausserirdischen abwehren musst.",
  "Ich versuche es mal so praezise wie moeglich auszudruecken:",
  "\"Toete ALLES!\"",
  "Spielbedienung:",
  "Mausbewegung = Zielcursor bewegen",
  "Linke Taste  = Projektil aus linker Kanone abfeuern",
  "Rechte Taste = Projektil aus rechter Kanone abfeuern",
  "Punkteverteilung:",
  "Kleines UFO = +10 Punkte",
  "Mittleres UFO = +30 Punkte",
  "Grosses UFO = +50 Punkte",
  "Gebaeudeteil ueberlebt Welle = +25 Punkte",
  "Am Wellenende gibts Bonuspunkte basierend auf Trefferquote.",
  "Alle +Punkte x2 im Normal-Modus.",
  "Alle +Punkte x3 im Hard-Modus.",
  "Gebaeude wird bebombt = -50 Punkte",
  "Spiel vorbei, wenn beide Kanonen zerstoert.",
  "Spiel gewonnen, wenn 30 Angriffswellen abgewehrt.",
  "Viel Spass..."                                         // Instruktionen Zeile 47
};

// Englische Stringtabelle
char *eng_text[] =
{
  "Smalls left",
  "Mediums left",
  "Bigs left",
  "Attackwave",
  "Survivalbonus",
  "Accuracybonus",
  "Wave",
  "Score",
  "Hit-ratio",
  "Game Over!",
  "You've won the game!",
  "MainMenu",
  "Flying Saucers attack",
  "http://www.dennisbusch.de",
  "http://alleg.sourceforge.net/",
  "http://dumb.sf.net/",
  "Freeware V.1.20g",
  "powered by:",
  "Start Game",
  "Difficulty",
  "Instructions",
  "Top 10",
  "Name:",
  "Score:",
  "Credits",
  "End Game",
  "Easy",
  "Normal",
  "Hard",
  "\"Music\"",
  "Swap stereo",
  "On",
  "Off",
  "With your score of",
  "You've entered Top-Ten at position",
  "Give me your name:",
  "Click <left mousebutton> please",
  "The Story",
  "The Mission",
  "It is the year twothousandfourhundredsomething (who cares?)...", // Instruktionen Zeile 00
  "It happened just as it had to...",
  "But wait a minute:",
  "Earth is already laid to waste for about 300 years now.",
  "Nobody knows exactly what had happened back there, but",
  "since then worldpopulation has grown to",
  "a few hundred people again.",
  "They have built themselves a splendid city.",
  "They call it... \"TheCity\"",
  "Since these people have grown up without wars,",
  "they are not really able to defend themselves",
  "against exterior threats and so",
  "the disaster did all start.",
  "Flying Saucers are attacking \"TheCity\"",
  "And people can only watch it crumble without",
  "doing anything.",
  "But there was one human, who saw it all coming.",
  "They call him... \"TheHuman\"",
  "A long time ago \"TheHuman\" had found",
  "an old relic from an even longer time ago in an even older cave.",
  "It was a VERY OLD, but still functional",
  "Atari2600 VideoGameSystem. The cartridge, that",
  "was still in it, taught \"TheHuman\", that",
  "the best way to defend a city against an alien threat,",
  "was to post two lousy cannons",
  "at the citys borders. And so",
  "\"TheHuman\" built these two cannons",
  "and he saw it was good...",                                 // Instruktionen Zeile 27
  "You are \"TheHuman\" and by that you have the power",// Instruktionen Zeile 28
  "to control two of the lousiest cannons in universe using",
  "them to defend yourself against the alien attackwaves.",
  "Trying to express it in a more precise way:",
  "\"Kill EVERYTHING!\"",
  "Gamecontrols:",
  "Mousemovement = Move Crosshair",
  "Left Button   = Fire bullet from left cannon",
  "Right Button  = Fire bullet from right cannon",
  "Scoresystem:",
  "Small UFO = +10 Points",
  "Medium UFO = +30 Points",
  "Big UFO = +50 Points",
  "Buildingpart survives wave = +25 points",
  "You get end of wave bonus based on your Hit-ratio.",
  "All +Points x2 in Normal-Mode.",
  "All +Points x3 in Hard-Mode.",
  "Building gets bombed = -50 Points",
  "Game Over if both cannons are destroyed.",
  "To win the game you have to repulse 30 attackwaves.",
  "Have fun..."                                         // Instruktionen Zeile 45
};

char *game_text[sizeof(ger_text)/sizeof(char *)];

int set_game_language(int which)
{
  int i;
  switch (which)
  {
    case 0:
      //game_text=ger_text; // funktioniert mit MSVC++ nicht
      for(i=0; i<_game_msg_count; i++)
      {
        game_text[i]=ger_text[i];
      }
      game_language=0;
      return 0;
    break;
    case 1:
      //game_text=eng_text; // funktioniert mit MSVC++ nicht
      for(i=0; i<_game_msg_count; i++)
      {
        game_text[i]=eng_text[i];
      }
      game_language=1;
      return 0;
    break;
  }

  // Wenn nichts richtiges gewaehlt wird,
  // setze ich Standardmaessig auf Englisch
  //game_text=eng_text;
  for(i=0; i<_game_msg_count; i++)
  {
    game_text[i]=eng_text[i];
  }
  game_language=1;
  return 0;
};
