// Systemwichtige Routinen V.6

// neu in V.6: Unterstuetzung von Soundkarteninitialisierung
//             unterhaelt eine globale Variable bool can_do_sound
//             diese ist True wenn Sounds gespielt werden koennen
// neu in V.5: Sprachuntersttzung Deutsch / English
//             wird jetzt ber Stringtabellen verwaltet.
//             ==> gewaltige Einsparung von Codezeilen und Aufwand
//
// neu in V.4: Sprachuntersttzung Deutsch / English
//               function set_language(int which);

// neu in V.3: "DEBUG.TXT" wird jedesmal nach debug_add geschlossen
//              damit die Infos auch bei einem Absturz lesbar sind
// neu in V.2: Verwaltung einer "DEBUG.TXT"
// neu in V.1: Starten und Beenden von Allegro und seinen Grafikmodi
// Autor: Dennis Busch



#include <iostream>    // fr cout cin etc.
#include <string.h>      // hauptschlich nur wegen memset()
#include <stdio.h>       // fr printf ... etc.
#include <stdlib.h>      // fr random etc.
//#include <conio.h>       // fr clrscr(); DOS-spezifisch
#include <time.h>        // fr die Abfrage der Systemzeit

#include "message.cpp"   // Enthlt alle mglichen Nachrichten
#include "allegro.h"     // ohne Allegro von Shawn Hargreaves luft hier gar nichts

// Globales :
bool DO_DEBUG;       // TRUE wenn Debug aktiv sonst FALSE

FILE *debug_file;    // die "DEBUG.TXT" ...
char debug_msg[256]; // mit sprintf() fllen dann add_debug(debug_msg) aufrufen
bool debug_ok;       // True wenn die "DEBUG.TXT" erfolgreich angelegt wurde
bool language_set;   // True wenn Sprache schon eingestellt wurde
bool can_do_sound;   // True wenn Soundkarte initialisiert werden konnte.

char *messages[sizeof(ger_messages)/sizeof(char *)];

// Forward Deklarationen :

int init();
int init_gfx(int,int,int);
void shutdown();

int init_debug();
void shut_debug();
void debug_add(char *what);
void set_language(int which);

int dice(int sides)
{
  static bool seeded;

  int val;

  if (!seeded)
  {
    srand(time(NULL));
    seeded=TRUE;
  }

  val = rand() % (100000);
  val = (val % sides);
  return val;
};

/* init()
   Initialisiert wirklich alles was wichtig ist:
   Allegro,Timer,Mouse,Keyboard.
   Gibt 0 zurck wenn alles Ok! ist.
*/
int  init(){
  //char command;
  //clrscr();

  if (!language_set) set_language(LANG_ENGLISH);

  init_debug();

  sprintf(debug_msg,messages[msg_init_startup]); debug_add(debug_msg);

  sprintf(debug_msg,messages[msg_init_allegro]); debug_add(debug_msg);
  if (allegro_init()!=0){
    sprintf(debug_msg,messages[msg_fail_allegro]); debug_add(debug_msg);
    return 1;
  } else{
    sprintf(debug_msg,messages[msg_ok_allegro]); debug_add(debug_msg);
  }

  sprintf(debug_msg,messages[msg_init_timer]); debug_add(debug_msg);
  if (install_timer()!=0){
    sprintf(debug_msg,messages[msg_fail_timer]); debug_add(debug_msg);
    return 3;
  } else{
    sprintf(debug_msg,messages[msg_ok_timer]); debug_add(debug_msg);
  }

  sprintf(debug_msg,messages[msg_init_mouse]); debug_add(debug_msg);
  if (install_mouse()==-1){
    sprintf(debug_msg,messages[msg_fail_mouse]); debug_add(debug_msg);
    return 2;
  } else{
    sprintf(debug_msg,messages[msg_ok_mouse]); debug_add(debug_msg);
  }

  sprintf(debug_msg,messages[msg_init_keyboard]); debug_add(debug_msg);
  if (install_keyboard()!=0){
    sprintf(debug_msg,messages[msg_fail_keyboard]); debug_add(debug_msg);
    return 4;
  } else{
    sprintf(debug_msg,messages[msg_ok_keyboard]); debug_add(debug_msg);
  }

  sprintf(debug_msg,messages[msg_init_sfx]); debug_add(debug_msg);
  if (install_sound(DIGI_AUTODETECT,MIDI_NONE,".\\")!=0){
    sprintf(debug_msg,messages[msg_fail_sfx]); debug_add(debug_msg);
    sprintf(debug_msg,allegro_error); debug_add(debug_msg);
    can_do_sound=FALSE;
  } else{
    sprintf(debug_msg,messages[msg_ok_sfx]); debug_add(debug_msg);
    can_do_sound=TRUE;
  }

  sprintf(debug_msg,messages[msg_ok_startup]); debug_add(debug_msg);

  //clrscr();
  return 0;
};





/* init_gfx()
   Versucht den Grafikmodus zu setzten:
   a = x-Resolution
   b = y-Resolution
   c_depth = Farbtiefe (8, 15, 16, 24) bit
   Gibt ebenfalls 0 zurck wenn alles geklappt hat.
*/
int  init_gfx(int a,int b,int c_depth){
  //char command;
  //clrscr();

  sprintf(debug_msg,"%s (%ix%ix%ibpp)",messages[msg_init_gfx],a,b,c_depth);
  debug_add(debug_msg);

  set_color_depth(c_depth);
  if (!(set_gfx_mode(GFX_AUTODETECT,a,b,a,b))==0)
  {
    sprintf(debug_msg,messages[msg_fail_gfx]);
    debug_add(debug_msg);
    return -1;
  } 
  else 
  {
    sprintf(debug_msg,messages[msg_ok_gfx]);
    debug_add(debug_msg);
  }
  return 0;
};





/* shutdown()
   Beendet alles !
*/
void shutdown()
{
  //sprintf(debug_msg,"a"); debug_add(debug_msg);

  remove_mouse();

  //sprintf(debug_msg,"b"); debug_add(debug_msg);

  remove_keyboard();

  //sprintf(debug_msg,"c"); debug_add(debug_msg);

  remove_timer();

  //sprintf(debug_msg,"d"); debug_add(debug_msg);
  
  shut_debug();

  //allegro_message("e");

  allegro_exit();
};




/* init_debug()
   Legt eine "DEBUG.TXT" an.
   Gibt 0 zurck bei Erfolg und setzt debug_ok auf TRUE.
*/
int init_debug(){
  if (DO_DEBUG){
    debug_ok=TRUE;
    debug_file = fopen("DEBUG.TXT","wt");
    if (debug_file==0)
    {
      debug_ok=FALSE;
      return 1;
    } 
    else 
    {
      sprintf(debug_msg,messages[msg_debug_created]);
      fclose(debug_file);
      debug_add(debug_msg);
      return 0;
    }
  }
  return 1;
};



/* shut_debug()
   Schliet die "DEBUG.TXT".
   Wird von "shutdown()" aufgerufen.
*/
void shut_debug(){
  if (DO_DEBUG){
    if (debug_ok){
      sprintf(debug_msg,messages[msg_debug_finished]);
      debug_add(debug_msg);
    }
  }
};




/* add_debug(char *what)
   Fgt einen String in die "DEBUG.TXT" ein.
*/
void debug_add(char *what){
  if (DO_DEBUG){
    char time_string[50];
    time_t time_stamp;
    time(&time_stamp);
    if (debug_ok){
      debug_file = fopen("DEBUG.TXT","at");
      sprintf(time_string,"%s",asctime(localtime(&time_stamp)));
      //fputs(time_string,debug_file);
      //fputs(what,debug_file);
      fprintf(debug_file,"%s",time_string);
      fseek(debug_file,-2,SEEK_CUR);
      fprintf(debug_file," --> %s\n",what);
      fclose(debug_file);
    }
  }
};




/* set_language(int which)
   Setzt alle Nachrichten in char *messages auf die angegebene Sprache
   0=Deutsch 1=English
*/
void set_language(int which)
{
  int i;

  if (which==LANG_GERMAN)
  { //Deutsch
    //messages=ger_messages; // funktioniert mit MSVC++ nicht
    for(i=0; i<_sys_msg_count; i++)
    {
      messages[i]=ger_messages[i];
    }
    language_set=TRUE;
  }

  if (which==LANG_ENGLISH)
  { // English
    //messages=eng_messages; // funktioniert mit MSVC++ nicht
    for(i=0; i<_sys_msg_count; i++)
    {
      messages[i]=eng_messages[i];
    }
    language_set=TRUE;
  }
};

