// FUGA Fliegende Untertassen greifen an
// von Dennis Busch

// "game.cpp"
// Enthaelt die globalen Variablen und Spielschleife

enum difficulty_level
{
  EASY=1, MEDIUM, HARD
};

// Variablen fuer das System
BITMAP *backbuffer=NULL;  // Hintergrundpuffer fuer verstecktes Zeichnen
BITMAP *background=NULL;  // zweiter Hintergrundpuffer fuer Hintergrundgrafik
bool screen_shot;
bool first_time_draw;     // TRUE wenn erstmals der Hintergrund gezeichnet werden muss
bool tunnel_redraw;
bool building_redraw;
bool need_restore_background;
bool play_sounds;
bool already_locked=FALSE;
bool game_minimized=FALSE;

int game_count=0; // wird "cycles_per_second" mal pro Sekunde um 1 erhoeht und
                  // nach jedem Zyklus um 1 erniedrigt und jedesmal
                  // wenn er 0 erreicht
                  // (also wenn gerade so viele oder
                  // mehr Zyklen als "cycles per second" stattgefunden haben)
                  // wird das Bild neu gezeichnet.
int game_over_count; // Wird runtergezaehlt bei game_over oder win_the_game und wenn es 0 ist, dann ist wirklich game_over
int next_wave_delay; // Wird runtergezaehlt und solange >0 wird die Next_Wave Textzeile angezeigt

// Variablen fuer den Spieler
bool gameover;
bool win_the_game;      // TRUE wenn der Spieler alle Angriffswellen abgewehrt hat
int lgun_x,lgun_y;      // Koordinaten fuer linke Kanone
int rgun_x,rgun_y;      // Koordinaten fuer rechte Kanone
int lgun_load, rgun_load; // Kontrollvariablen (immer wenn 0, dann Kanone Schussbereit)
bool lgun_alive, rgun_alive; // TRUE, wenn Kanonen noch heil sind
float lgun_heat, rgun_heat;  // Hitze der Kanonen

float ld_x;     // X Distanz zwischen Maus und linker Kanone (Ankathete)
float ld_y;     // Y Distanz zwischen Maus und linker Kanone (Gegenkathete)
float rd_x;     // entsprechend...
float rd_y;     // ...fuer rechte Kanone

float lgun_angle;       // Winkel der linken Kanone in Grad
float rgun_angle;       // Winkel der rechten Kanone in Grad

char topten_current_name[21];
int topten_current_pos;

// Gegner
c_enemy all_enemies[max_enemies];
int enemy_spawn; // Wird permanent runtergezaehlt und jedes mal bei 0 kommt eine neuer Gegner

// Forward Deklarationen
void reset_all_vars();
void update_guns();
int get_free_enemy();
void fire_cannon(int which);

void draw_building(BITMAP *where, int which);
void draw_tunnels(BITMAP *where);
void draw_score_overlay(BITMAP *where);
void update_screen();
void game_cycle();

void perform_attack_wave();
void next_attack_wave();

int starmin_x=0,starmax_x=639,starmin_y=0,starmax_y=260;
const int stars=100;
const float starbase_speed=0.1;
const int starmax_speed=20;
int starfast_col=16;
int starslow_col=26;
struct star
{
  float x,y,px,py;
  int col;
  float speed;
};
star all_stars[stars];

void init_starfield();
void move_stars();
void draw_stars(BITMAP *where);
void restore_stars_background(BITMAP* towhere, BITMAP *fromwhere);

void init_starfield()
{
  int i;
  star p;
  for (i=0; i<stars; i++)
  {
    p.x=starmin_x + dice(starmax_x+1-starmin_x);
    p.y=starmin_y + dice(starmax_y+1-starmin_y);
    p.speed= starbase_speed * (dice(starmax_speed)+1);
    p.col=starslow_col-p.speed*(abs(starfast_col-starslow_col)/(starmax_speed*starbase_speed));
    all_stars[i]=p;
  }
};

void move_stars()
{
  int i;
  star p;
  for (i=0; i<stars; i++)
  {
    p=all_stars[i];
    p.x=p.x-p.speed;
    if (p.x<starmin_x)
    {
      p.x=starmax_x;
    }
    all_stars[i]=p;
  }
};

void draw_stars(BITMAP *where)
{
  int i;
  star p;
  for (i=0; i<stars; i++)
  {
    p=all_stars[i];
    p.px=p.x;
    p.py=p.y;    
    putpixel(where,p.x,p.y,p.col);
    all_stars[i]=p;
  }
};

void restore_stars_background(BITMAP* towhere, BITMAP *fromwhere)
{
  int i;
  star p;
  for (i=0; i<stars; i++)
  {
    p=all_stars[i];
    putpixel(towhere,p.px,p.py,getpixel(fromwhere,p.px,p.py));
  }
}

// reset_all_vars()
// setzt alle Variablen auf Grundeinstellung fuer neues Spiel
void reset_all_vars()
{
  int i;
  screen_shot=FALSE;
  first_time_draw=TRUE;

  shots_fired=0; 
  shots_hit=0; 

  survival_bonus=0;
  accuracy_bonus=0;
  score=0;
  target_score=0;
  hit_ratio = 0.0;
  game_count=0;

  gameover=FALSE;
  win_the_game=FALSE;
  game_minimized=FALSE;

  game_over_count=show_next_wave;

  lgun_x=25;
  lgun_y=295;
  rgun_x=614;
  rgun_y=295;

  lgun_load=0;
  rgun_load=0;

  lgun_alive=TRUE;
  rgun_alive=TRUE;

  lgun_heat=0.0;
  rgun_heat=0.0;

  building_x[0]=183;
  building_x[1]=263;
  building_x[2]=337;
  building_x[3]=417;

  tunnel_x[0]=263; tunnel_y[0]=131;
  tunnel_x[1]=223; tunnel_y[1]=131;
  tunnel_x[2]=183; tunnel_y[2]=131;
  tunnel_x[3]=143; tunnel_y[3]=131;
  tunnel_x[4]=103; tunnel_y[4]=131;
  tunnel_x[5]=63;  tunnel_y[5]=131;
  tunnel_x[6]=23;  tunnel_y[6]=131;
  tunnel_x[7]=0;   tunnel_y[7]=91;
  tunnel_x[8]=0;   tunnel_y[8]=51;
  tunnel_x[9]=0;   tunnel_y[9]=11;
  tunnel_x[10]=0;  tunnel_y[10]=0;

  tunnel_one_length=0;
  tunnel_two_length=0;

  smalls_on_screen=0;
  mediums_on_screen=0;
  bigs_on_screen=0;

  smalls_to_kill=0;
  mediums_to_kill=0;
  bigs_to_kill=0;

  attack_wave=debug_wave;
  next_wave_delay=0;
  enemy_spawn=enemy_delay;

  switch (difficulty)
  {
    case EASY:
      building_height[0]=4;
      building_current_height[0]=4;
      building_height[1]=6;
      building_current_height[1]=6;
      building_height[2]=6;
      building_current_height[2]=6;
      building_height[3]=4;
      building_current_height[3]=4;
    break;
    case MEDIUM:
      building_height[0]=2;
      building_current_height[0]=2;
      building_height[1]=4;
      building_current_height[1]=4;
      building_height[2]=4;
      building_current_height[2]=4;
      building_height[3]=2;
      building_current_height[3]=2;
    break;
    case HARD:
      building_height[0]=1;
      building_current_height[0]=1;
      building_height[1]=2;
      building_current_height[1]=2;
      building_height[2]=2;
      building_current_height[2]=2;
      building_height[3]=1;
      building_current_height[3]=1;
      
      building_height[2]=0;
      building_current_height[2]=0;
      tunnel_two_length = tunnel_length;
      rgun_alive = FALSE;
    break;
  }

  // set_mouse_range(lgun_x,0,rgun_x,rgun_y);
  set_mouse_sprite((BITMAP *)fugadata[GFX_CURSOR].dat);
  set_mouse_sprite_focus(20,20);

  anim_top=-1;
  shot_top=-1;
  enemy_top=-1;

  for (i=0; i<max_anims; i++)
  { 
    all_anims[i].in_use=FALSE; 
    x_anim[i]=0; 
    y_anim[i]=0;
    all_anims[i].number=i;
    push_anim(i);
  }
  for (i=0; i<max_shots; i++)
  { 
    all_shots[i].in_use=FALSE;
    all_shots[i].number=i;
    push_shot(i);
  }
  for (i=0; i<max_enemies; i++) 
  {
    all_enemies[i].in_use=FALSE;
    all_enemies[i].number=i;
    push_enemy(i);
  }

  starfast_col=_COL_16;
  starslow_col=_COL_26;
};

// recalc_hit_ratio()
void recalc_hit_ratio()
{
  if(shots_fired>0)
    hit_ratio=shots_hit/shots_fired;
  else 
    hit_ratio=0.00;

  if(hit_ratio>1.0) hit_ratio=1.0; // schmutziger Fix
};

// gain_score
// Erhoeht den Score
void gain_score(int how_much)
{
  if(target_score+how_much<max_score) target_score+=how_much;
  else target_score=max_score;
};

void drain_score(int how_much)
{
  target_score-=how_much;
  if (target_score<0) target_score=0;
};

// update_guns
// aktualisiert die Winkel der Kanonen
void update_guns()
{
  int mx = mouse_x < lgun_x ? lgun_x : (mouse_x > rgun_x ? rgun_x : mouse_x);
  int my = mouse_y < rgun_y ? mouse_y : rgun_y;

  if (mouse_needs_poll()) poll_mouse();

  // Distanzen berechnen
  if (mx>lgun_x) ld_x=mx-lgun_x; else ld_x=lgun_x-mx;
  if (my>lgun_y) ld_y=my-lgun_y; else ld_y=lgun_y-my;

  if (mx>rgun_x) rd_x=mx-rgun_x; else rd_x=rgun_x-mx;
  if (my>rgun_y) rd_y=my-rgun_y; else rd_y=rgun_y-my;

  if (ld_x!=0)
  {
    lgun_angle=atan(ld_y/ld_x)*to_deg;
  } else lgun_angle=90;

  if (rd_x!=0)
  {
    rgun_angle=atan(rd_y/rd_x)*to_deg;
  } else rgun_angle=90;

  if (lgun_load>0) lgun_load--;
  if (rgun_load>0) rgun_load--;

  if ((lgun_alive==FALSE)&&(rgun_alive==FALSE)) gameover=TRUE;
};

// get_free_anim
// Findet die naechste freie Animation, returnt dessen Nummer oder -1,wenn keine frei ist
int get_free_anim()
{
  if (anim_top!=-1) 
    return anim_stack[anim_top];
  else return -1;
};

// Startet an der angegebenen Stelle eine einweg Animation
void start_new_anim(int which,int x,int y, int start, int num, int typ, int time)
{
  if (which!=-1)
  { 
    x_anim[which] = x;
    y_anim[which] = y;
    all_anims[which].set_anim(start,num,typ,time,which);
    pop_anim();
  }
};

// get_free_shot
// Findet das naechste gerade nicht benutzte Geschoss und returnt dessen nummer oder -1 wenn keines frei ist
int get_free_shot()
{
  if (shot_top!=-1)
    return shot_stack[shot_top];
  else return -1;
};

void start_new_shot(int a, int b, float angle, float sp, int own, int typ)
{
  int num=get_free_shot();
  if (num!=-1)
  {
    all_shots[num].spawn_new(a,b,angle,sp,own,typ,num);
    pop_shot();
  }
};

// get_free_enemy
// Findet den naechsten gerade nicht benutzten Gegner und returnt dessen nummer oder -1 wenn kein Gegner frei ist
int get_free_enemy()
{
  if (enemy_top!=-1)
    return enemy_stack[enemy_top];
  else return -1;
};

// fire_cannon
// 0 links / 1 rechts
// Erzeugt an der jeweiligen Kanone ein neues Geschoss
void fire_cannon(int which)
{
  int wx, wy;
  bool can_shoot=TRUE;
  float wangle;
  
    switch (which)
    {
      case 0: wx = lgun_x;
              wy = lgun_y;
              wangle = (360-lgun_angle)*to_rad;
              lgun_load=reload_time;
              if((lgun_alive==FALSE)||(lgun_heat>=max_heat-heat_deadzone)) can_shoot=FALSE;
              if(can_shoot)
              {
                shots_fired+=1.0;
                recalc_hit_ratio();
                start_a_sound(SOUND_GUN_SHOT,255,10,1000,FALSE);
                lgun_heat+=heat_gain;
                if(lgun_heat>max_heat) lgun_heat=max_heat;
              }
      break;
      case 1: wx = rgun_x;
              wy = rgun_y;
              wangle = (180+rgun_angle)*to_rad;
              rgun_load=reload_time;
              if((rgun_alive==FALSE)||(rgun_heat>=max_heat-heat_deadzone)) can_shoot=FALSE;
              if(can_shoot)
              {
                shots_fired+=1.0;
                recalc_hit_ratio();
                start_a_sound(SOUND_GUN_SHOT,255,245,1000,FALSE);
                rgun_heat+=heat_gain;
                if(rgun_heat>max_heat) rgun_heat=max_heat;
              }
      break;
    }

  if (can_shoot) start_new_shot(wx,wy,wangle,bullet_speed,PLAYER,CANNONBALL);
};

// collide_bitmaps
// Testet ob sich die angegebenen Bitmaps mit den angegebenen
// relativen Koordinaten schneiden
bool collide_bitmaps(BITMAP *bmp_a, BITMAP *bmp_b, int rel_x, int rel_y)
{
  int i,j;
  int col_x, col_y;

  if (abs(rel_x)>((bmp_a->w/2)+(bmp_b->w/2))) return FALSE;  // sind sowieso zu weit voneinander weg
  if (abs(rel_y)>((bmp_a->h/2)+(bmp_b->h/2))) return FALSE;  // sind sowieso zu weit voneinander weg 

  for (i=0; i<=bmp_a->w ; i++)
    for (j=0; j<=bmp_a->h; j++)
    {
      col_x = int(bmp_b->w/2-bmp_a->w/2)+i+abs(rel_x);
      col_y = int(bmp_b->h/2-bmp_a->h/2)+j+abs(rel_y);

      if ((getpixel(bmp_b,col_x,col_y)>0)&&
          (getpixel(bmp_a,i,j)>0)) return TRUE;
    }
  

  return FALSE;
};

// perform_collision
// Wird !*NUR*! aus der Klasse c_shot heraus aufgerufen.
// Prueft, ob das angegebene Geschoss und der angegebene Gegner
// kollidieren und passt dann entsprechend deren Members an.
void perform_collision(int type,int a /*with*/, int b)
{
  BITMAP *bmp_a=NULL; // Diese beiden Bitmap dienen zum Pixelvergleich
  BITMAP *bmp_b=NULL; // der Bitmaps des Geschosses und des damit kollidierenden Objekts
                  // beide nutzen selber keinen Speicher, sonder zeigen nur
                  // in das Datenfile auf das entsprechende Bitmap
  int rel_x, rel_y;
  int i,j;

  switch (type)
  {
    case SHOT_TO_ENEMY:     // nur Spielerschuss auf Gegner
      if (!all_shots[a].in_use) return;
      if (!all_enemies[b].in_use) return;
      if (all_enemies[b].state!=ALIVE) return;

      bmp_a = (BITMAP *)fugadata[all_shots[a].anim.current_frame].dat;
      bmp_b = (BITMAP *)fugadata[all_enemies[b].anim.current_frame].dat;

      rel_x = int(all_enemies[b].x-all_shots[a].x);
      rel_y = int(all_enemies[b].y-all_shots[a].y);

      if (collide_bitmaps(bmp_a,bmp_b,rel_x,rel_y)/*&&all_shots[a].in_use*/)
      {
        shots_hit+=1.0;
        recalc_hit_ratio();
        start_new_anim(get_free_anim(),int(all_shots[a].x),int(all_shots[a].y),GFX_SHOT_HIT000,10,c_anim_once_fwd,1);
        all_shots[a].in_use=FALSE;
        push_shot(a);
        all_enemies[b].drain_energy_and_die();
        start_a_sound(SOUND_SHOT_HIT,200,128,1000,FALSE);
      }

    break;
    case SHOT_TO_SHOT:      // nur Spielerschuss auf Bombe oder Infiltrator
      if (!all_shots[a].in_use) return;
      if (!all_shots[b].in_use) return;
      if (all_shots[b].type==CANNONBALL) return;
      if (all_shots[b].type>=SMALL_JUNK1) return;

      bmp_a = (BITMAP *)fugadata[all_shots[a].anim.current_frame].dat;
      bmp_b = (BITMAP *)fugadata[all_shots[b].anim.current_frame].dat;

      rel_x = int(all_shots[b].x-all_shots[a].x);
      rel_y = int(all_shots[b].y-all_shots[a].y);

      if (collide_bitmaps(bmp_a,bmp_b,rel_x,rel_y))
      {
        shots_hit+=1.0;
        recalc_hit_ratio();
        start_new_anim(get_free_anim(),int(all_shots[a].x),int(all_shots[a].y),GFX_SHOT_HIT000,10,c_anim_once_fwd,1);
        start_new_anim(get_free_anim(),int(all_shots[b].x),int(all_shots[b].y),GFX_SHOT_HIT000,10,c_anim_once_fwd,2);
        all_shots[a].in_use=FALSE;
        all_shots[b].in_use=FALSE;
        push_shot(a);
        push_shot(b);
        start_a_sound(SOUND_SHOT_HIT,200,128,1000,FALSE);
      }
    break;
    case SHOT_TO_CANNON:    // nur Gelenkte Rakete auf Kanonen
      // reserviert
    break;

    case SHOT_TO_BUILDING:  // nur Bombe auf Gebaeude
      for (i=0; i<4; i++)
      {
        rel_x = int(all_shots[a].x);
        rel_y = int(all_shots[a].y);

        if ((rel_x>building_x[i])&&(rel_x<building_x[i]+40))
        {
          if (building_current_height[i]>0)
          {
            if (rel_y>building_y+20-building_current_height[i]*20)
            {
              all_shots[a].in_use=FALSE;
              push_shot(a);
              building_redraw=TRUE;
              for (j=0; j<4; j++)
              {
                start_new_shot(rel_x,rel_y,(225+j*30)*to_rad,3,WORLD,BUILDING_JUNK1+j);
              };
              drain_score(50);
              start_new_anim(get_free_anim(),rel_x,rel_y,GFX_BIG_EXPLOSION007,9,c_anim_once_fwd,1);
              building_current_height[i]--;
              i=5;
              start_a_sound(SOUND_BOMB_HIT,255,128,1000,FALSE);
            }
          }
        }
      }
    break;
    case SHOT_TO_TUNNEL:  // nur Infiltrator auf Tunnel
      rel_x = int(all_shots[a].x);
      rel_y = int(all_shots[a].y);

      // Tunnel 1 checken
      for (j=0; j<tunnel_length; j++)
      {
        if ((lgun_alive==FALSE)&&
            (rel_x>=tunnel_x[j])&&(rel_x<tunnel_x[j]+40)&&
            (rel_y>300+tunnel_y[j])&&(rel_y<300+tunnel_y[j]+40))
        {
          start_new_anim(get_free_anim(),rel_x,rel_y,GFX_SHOT_HIT000,10,c_anim_once_fwd,2);
          all_shots[a].in_use=FALSE;
          push_shot(a);
        }
        if (j<tunnel_one_length)
        {
          // Bewegungsrichtung anpassen
          if ((j<=5)&&(rel_x>=tunnel_x[j]+19)&&(rel_x<=tunnel_x[j]+20)&&(rel_y>=300+tunnel_y[j]+21)&&(rel_y<=300+tunnel_y[j]+22)) all_shots[a].change_angle(180*to_rad);
          if ((j==6)&&(rel_x>=tunnel_x[j]+6)&&(rel_x<=tunnel_x[j]+7)&&(rel_y>=300+tunnel_y[j]+21)&&(rel_y<=300+tunnel_y[j]+22)) all_shots[a].change_angle(270*to_rad);
          if ((j==7)&&(rel_x>=tunnel_x[j]+27)&&(rel_x<=tunnel_x[j]+29)&&(rel_y>=300+tunnel_y[j]+39)&&(rel_y<=300+tunnel_y[j]+40)) all_shots[a].change_angle(255*to_rad);
          if ((j==8)&&(rel_x>=tunnel_x[j]+15)&&(rel_x<=tunnel_x[j]+22)&&(rel_y>=300+tunnel_y[j]+39)&&(rel_y<=300+tunnel_y[j]+40)) all_shots[a].change_angle(258*to_rad);
          if ((j==9)&&(rel_x>=tunnel_x[j]+8)&&(rel_x<=tunnel_x[j]+11)&&(rel_y>=300+tunnel_y[j]+39)&&(rel_y<=300+tunnel_y[j]+40)) all_shots[a].change_angle(270*to_rad);
          if ((j==10)&&(rel_x>=tunnel_x[j]+10)&&(rel_x<=tunnel_x[j]+11)&&(rel_y>=300+tunnel_y[j]+0)&&(rel_y<=300+tunnel_y[j]+1)) all_shots[a].change_angle(270*to_rad);
        }
        if (j>=tunnel_one_length)
        {
          if (j==tunnel_length-1) i=10; else i=40; // dreckiger kleiner Hack
          if ((rel_x>tunnel_x[j])&&(rel_x<tunnel_x[j]+40)&&
              (rel_y>300+tunnel_y[j])&&(rel_y<300+tunnel_y[j]+i))
          {
            if (j==tunnel_length-1) // Ende des Tunnels, daher Kanone mit killen
            {
              lgun_alive=FALSE;
              // Kanone hochgehen lassen
              for (i=0; i<4; i++)
              {
                start_new_shot(lgun_x,lgun_y,(285+i*15)*to_rad,6,WORLD,GUN_JUNK1+i);
              }
              start_new_anim(get_free_anim(),lgun_x,lgun_y,GFX_BIG_EXPLOSION000,16,c_anim_once_fwd,2);
              start_a_sound(SOUND_BIG_EXPLODE,255,128,1000,FALSE);
            }
            // Dreckteile rumschleudern
            for (i=0; i<4; i++)
            {
              start_new_shot(rel_x,rel_y,(225+i*30)*to_rad,3,WORLD,MUD_BALL);
            }
            start_new_anim(get_free_anim(),rel_x,rel_y,GFX_BIG_EXPLOSION000,16,c_anim_once_fwd,1);
            if (tunnel_one_length<tunnel_length) tunnel_one_length++;
            all_shots[a].in_use=FALSE;
            push_shot(a);
            tunnel_redraw=TRUE;
            start_a_sound(SOUND_BOMB_HIT,255,128,1000,FALSE);
          }
        }
      }
      // Tunnel 2 checken
      for (j=0; j<tunnel_length; j++)
      {
        if ((rgun_alive==FALSE)&&
            (rel_x>=600-tunnel_x[j])&&(rel_x<600-tunnel_x[j]+40)&&
            (rel_y>300+tunnel_y[j])&&(rel_y<300+tunnel_y[j]+40))
        {
          start_new_anim(get_free_anim(),rel_x,rel_y,GFX_SHOT_HIT000,10,c_anim_once_fwd,2);
          all_shots[a].in_use=FALSE;
          push_shot(a);
        }
        if (j<tunnel_two_length)
        {
          // Bewegungsrichtung anpassen
          if ((j<=5)&&(rel_x>=600-tunnel_x[j]+40-21)&&(rel_x<=600-tunnel_x[j]+40-18)&&(rel_y>=300+tunnel_y[j]+21)&&(rel_y<=300+tunnel_y[j]+22)) all_shots[a].change_angle(0*to_rad);
          if ((j==6)&&(rel_x>=600-tunnel_x[j]+40-7)&&(rel_x<=600-tunnel_x[j]+40-6)&&(rel_y>=300+tunnel_y[j]+21)&&(rel_y<=300+tunnel_y[j]+22)) all_shots[a].change_angle(270*to_rad);
          if ((j==7)&&(rel_x>=600-tunnel_x[j]+40-30)&&(rel_x<=600-tunnel_x[j]+40-27)&&(rel_y>=300+tunnel_y[j]+39)&&(rel_y<=300+tunnel_y[j]+40)) all_shots[a].change_angle(285*to_rad);
          if ((j==8)&&(rel_x>=600-tunnel_x[j]+40-22)&&(rel_x<=600-tunnel_x[j]+40-15)&&(rel_y>=300+tunnel_y[j]+39)&&(rel_y<=300+tunnel_y[j]+40)) all_shots[a].change_angle(282*to_rad);
          if ((j==9)&&(rel_x>=600-tunnel_x[j]+40-11)&&(rel_x<=600-tunnel_x[j]+40-8)&&(rel_y>=300+tunnel_y[j]+39)&&(rel_y<=300+tunnel_y[j]+40)) all_shots[a].change_angle(270*to_rad);
          if ((j==10)&&(rel_x>=600-tunnel_x[j]+40-11)&&(rel_x<=600-tunnel_x[j]+40-10)&&(rel_y>=300+tunnel_y[j]+0)&&(rel_y<=300+tunnel_y[j]+1)) all_shots[a].change_angle(270*to_rad);
        }
        if (j>=tunnel_two_length)
        {
          if (j==tunnel_length-1) i=10; else i=40; // dreckiger kleiner Hack
          if ((rel_x>600-tunnel_x[j])&&(rel_x<600-tunnel_x[j]+40)&&
              (rel_y>300+tunnel_y[j])&&(rel_y<300+tunnel_y[j]+i))
          {
            if (j==tunnel_length-1) // Ende des Tunnels, daher Kanone mit killen
            {
              rgun_alive=FALSE;
              // Kanone 2 hochgehen lassen
              for (i=0; i<4; i++)
              {
                start_new_shot(rgun_x,rgun_y,(255-i*15)*to_rad,6,WORLD,GUN_JUNK1+i);
              }
              start_new_anim(get_free_anim(),rgun_x,rgun_y,GFX_BIG_EXPLOSION000,16,c_anim_once_fwd,2);
              start_a_sound(SOUND_BIG_EXPLODE,255,128,1000,FALSE);
            }
            // Dreckteile rumschleudern
            for (i=0; i<4; i++)
            {
              start_new_shot(rel_x,rel_y,(225+i*30)*to_rad,3,WORLD,MUD_BALL);
            }
            start_new_anim(get_free_anim(),rel_x,rel_y,GFX_BIG_EXPLOSION000,16,c_anim_once_fwd,1);
            if (tunnel_two_length<tunnel_length) tunnel_two_length++;
            all_shots[a].in_use=FALSE;
            push_shot(a);
            tunnel_redraw=TRUE;
            start_a_sound(SOUND_BOMB_HIT,255,128,1000,FALSE);
          }
        }

      }
    break;
  } // switch
};

// draw_building
// Malt das angegebene Gebaeude auf das angegebene Bitmap
void draw_building(BITMAP *where, int which)
{
  BITMAP *what=NULL;

  int i;
  for (i=0; i<=building_current_height[which]; i++)
  {
    if (i<building_current_height[which])
      what = (BITMAP *)fugadata[GFX_BUILDING].dat;
    if ((i==building_current_height[which])&&(i<building_height[which]))
      what = (BITMAP *)fugadata[GFX_BUILDING_DESTROYED].dat;
    if ((i==building_current_height[which]-1)&&(i==building_height[which]-1))
      what = (BITMAP *)fugadata[GFX_BUILDING_TOP].dat;
    if (i==building_height[which]) return;
    draw_sprite(where,what,building_x[which],building_y-i*what->h);
  }

};

// draw_tunnels
// Malt die beiden Tunnel auf das angegebene Bitmap
void draw_tunnels(BITMAP *where)
{
  int i;
  // Tunnel 1
  for (i=0; i<tunnel_one_length; i++)
  {
    draw_sprite(where,(BITMAP *)fugadata[GFX_TUNNEL_PART000+i].dat,tunnel_x[i],300+tunnel_y[i]);
  }

  // Tunnel 2
  for (i=0; i<tunnel_two_length; i++)
  {
    draw_sprite_h_flip(where,(BITMAP *)fugadata[GFX_TUNNEL_PART000+i].dat,600-tunnel_x[i],300+tunnel_y[i]);
  }
};

// draw_score_overlay
// Malt die spielrelevanten Infos auf das angegebene Bitmap
void draw_score_overlay(BITMAP *where)
{
   text_mode(-1);
   // Verbleibende Feinde
   textprintf(where,TINY_FONT_BORDER,10,0,_COL_31,"%s: %i",game_text[txt_remaining_small],smalls_to_kill);
   textprintf(where,TINY_FONT_FILL,10,0,_COL_33,"%s: %i",game_text[txt_remaining_small],smalls_to_kill);
   textprintf(where,TINY_FONT_BORDER,10,15,_COL_31,"%s: %i",game_text[txt_remaining_medium],mediums_to_kill);
   textprintf(where,TINY_FONT_FILL,10,15,_COL_86,"%s: %i",game_text[txt_remaining_medium],mediums_to_kill);
   textprintf(where,TINY_FONT_BORDER,10,30,_COL_31,"%s: %i",game_text[txt_remaining_big],bigs_to_kill);
   textprintf(where,TINY_FONT_FILL,10,30,_COL_122,"%s: %i",game_text[txt_remaining_big],bigs_to_kill);

   // Wavenummer
   textprintf_centre(where,BIG_FONT_BORDER,320,20,_COL_31,"%s: %i",game_text[txt_wave],attack_wave);
   textprintf_centre(where,BIG_FONT_FILL,320,20,_COL_15,"%s: %i",game_text[txt_wave],attack_wave);

   // Score und Hitratio
   textprintf_centre(where,TINY_FONT_BORDER,320,0,_COL_31,"%s: %3.0f%%",game_text[txt_hitratio],hit_ratio*100);
   textprintf_centre(where,TINY_FONT_FILL,320,0,_COL_15,"%s: %3.0f%%",game_text[txt_hitratio],hit_ratio*100);
   textprintf_right(where,SMALL_FONT_BORDER,630,0,_COL_31,"%s",game_text[txt_score]);
   textprintf_right(where,SMALL_FONT_FILL,630,0,_COL_71,"%s",game_text[txt_score]);
   textprintf_right(where,BIG_FONT_BORDER,630,20,_COL_31,"%6i",score);
   textprintf_right(where,BIG_FONT_FILL,630,20,_COL_71,"%6i",score);

   // Hitzeanzeige
   int heat_col;
   heat_col=_COL_96;
   if (lgun_heat>=heat_fastfallofzone) heat_col=_COL_71;
   if (lgun_heat>=max_heat-heat_deadzone) heat_col=_COL_32;
   if (lgun_alive) rectfill(backbuffer,lgun_x-15,lgun_y-20,lgun_x-15+4,lgun_y-20-int(lgun_heat),heat_col);
   heat_col=_COL_96;
   if (rgun_heat>=heat_fastfallofzone) heat_col=_COL_71;
   if (rgun_heat>=max_heat-heat_deadzone) heat_col=_COL_32;
   if (rgun_alive) rectfill(backbuffer,rgun_x+15,rgun_y-20,rgun_x+15+4,rgun_y-20-int(rgun_heat),heat_col);

   // eventuell GameOver Schriftzug
   if (gameover)
   {
     textprintf_centre(where,BIG_FONT_BORDER,320,100,_COL_31,"%s",game_text[txt_game_over]);
     textprintf_centre(where,BIG_FONT_FILL,320,100,_COL_15,"%s",game_text[txt_game_over]);
   }
   // eventuell WinGame Schriftzug
   if (win_the_game)
   {
     textprintf_centre(where,BIG_FONT_BORDER,320,140,_COL_31,"%s",game_text[txt_win_the_game]);
     textprintf_centre(where,BIG_FONT_FILL,320,140,_COL_71,"%s",game_text[txt_win_the_game]);
   }
   // eventuell NextWave Schriftzug
   if ((next_wave_delay>0)&&(attack_wave<=total_waves)&&(!win_the_game))
   {
     textprintf_centre(where,BIG_FONT_BORDER,320,180,_COL_31,"%s %i",game_text[txt_attack_wave],attack_wave);
     textprintf_centre(where,BIG_FONT_FILL,320,180,_COL_71,"%s %i",game_text[txt_attack_wave],attack_wave);
   }
   // eventuell SurvivalBonus Schriftzug
   if ((next_wave_delay>0)&&(survival_bonus>0)&&(attack_wave>1))
   {
     textprintf_centre(where,SMALL_FONT_BORDER,320,210,_COL_31,"%s %i",game_text[txt_survivalbonus],survival_bonus*difficulty);
     textprintf_centre(where,SMALL_FONT_FILL,320,210,_COL_15,"%s %i",game_text[txt_survivalbonus],survival_bonus*difficulty);
   }   
   // eventuell AccuracyBonus Schriftzug
   if ((next_wave_delay>0)&&(accuracy_bonus>0)&&(attack_wave>1))
   {
     textprintf_centre(where,SMALL_FONT_BORDER,320,224,_COL_31,"%s %i",game_text[txt_accuracybonus],accuracy_bonus*difficulty);
     textprintf_centre(where,SMALL_FONT_FILL,320,224,_COL_15,"%s %i",game_text[txt_accuracybonus],accuracy_bonus*difficulty);
   }   

};

// update_screen()
// Malt das ganze Spielgeschehen neu
void update_screen()
{
  int i,j;
  need_restore_background=TRUE;

  // Maus verstecken und Bildflaeche loeschen
  show_mouse(NULL);

  if (first_time_draw)
  {
    //clear(background);
    blit((BITMAP *)fugadata[GFX_INGAME_BACK].dat,background,0,0,0,0,640,480);
    need_restore_background=FALSE;
    tunnel_redraw=TRUE;
    building_redraw=TRUE;
    first_time_draw=FALSE;
  }

  if (DEBUG_MODE)
  {
    //clear(background);
    blit((BITMAP *)fugadata[GFX_INGAME_BACK].dat,background,0,0,0,0,640,480);
    need_restore_background=TRUE;
    tunnel_redraw=TRUE;
    building_redraw=TRUE;
  }

  // Tunnel
  if ((tunnel_redraw)||(building_redraw))
  {
    blit((BITMAP *)fugadata[GFX_INGAME_BACK].dat,background,0,lgun_y,0,lgun_y,640,480-lgun_y);
    draw_sprite(background,(BITMAP *)fugadata[GFX_GROUND].dat,0,300);
    draw_sprite_h_flip(background,(BITMAP *)fugadata[GFX_GROUND].dat,320,300);

    for (i=0; i<4; i++) draw_building(background,i);
    draw_tunnels(background);
    blit(background,backbuffer,0,0,0,0,640,480);
    need_restore_background=FALSE;
    tunnel_redraw=FALSE;
    building_redraw=FALSE;
  }

  // Hintergrund wiederherstellen
  if (need_restore_background)
  {
    // Fuer die Kanonen
    blit(background,backbuffer,0,lgun_y-40,0,lgun_y-40,110,50);
    blit(background,backbuffer,540,rgun_y-40,540,rgun_y-40,110,50);

    // Fuer die Gegner
    for (i=0; i<max_enemies; i++) all_enemies[i].restore_background(background,backbuffer);

    // Fuer die Projektile
    for (i=0; i<max_shots; i++) all_shots[i].restore_background(background,backbuffer);

    // Fuer die Animationen
    for (i=0; i<max_anims; i++) all_anims[i].restore_background(background,backbuffer);

    // Fuer ScoreOverlay
    //rectfill(backbuffer,0,0,640,45,0);
    blit(background,backbuffer,0,0,0,0,640,45);
    if (next_wave_delay+1==1)
      //rectfill(backbuffer,210,180,430,255,0);
      blit(background,backbuffer,180,180,180,180,280,75);

    // Fuer Hitzeanzeige (wird auch im Scoreoverlay gemalt)
    blit(background,backbuffer,lgun_x-15,lgun_y-20-int(max_heat),lgun_x-15,lgun_y-20-int(max_heat),4,int(max_heat));
    blit(background,backbuffer,rgun_x+15,rgun_y-20-int(max_heat),rgun_x+15,rgun_y-20-int(max_heat),4,int(max_heat));

    // Fuer das Starfield
    restore_stars_background(backbuffer,background);
  }

  // Starfield malen
  draw_stars(backbuffer);

  // Kanonen
  if (lgun_alive) pivot_sprite(backbuffer,(BITMAP *)fugadata[GFX_GUN].dat,lgun_x,lgun_y,0,3,ftofix(256-lgun_angle*128/180));
  if (rgun_alive) pivot_sprite(backbuffer,(BITMAP *)fugadata[GFX_GUN].dat,rgun_x,rgun_y,0,3,ftofix(128+rgun_angle*128/180));
  if (lgun_alive) draw_sprite(backbuffer,(BITMAP *)fugadata[GFX_GUNBASE].dat,lgun_x-25,lgun_y-15);
  if (rgun_alive) draw_sprite_h_flip(backbuffer,(BITMAP *)fugadata[GFX_GUNBASE].dat,rgun_x-14,rgun_y-15);  

  // Gegner
  for (i=0; i<max_enemies; i++) all_enemies[i].draw(backbuffer);

  // Projektile
  for (i=0; i<max_shots; i++) all_shots[i].draw(backbuffer);

  // Sonstige Animationen (Rauch,Explosionen etc.)
  for (i=0; i<max_anims; i++) all_anims[i].draw(backbuffer,x_anim[i],y_anim[i]);

  // Score etc. daruebermalen
  draw_score_overlay(backbuffer);

  // Und noch ein paar Debug Infos, die spaeter entfernt werden sollten
  //*
  if (DEBUG_MODE)
  {
  text_mode(-1);
  line(backbuffer,lgun_x,lgun_y,mouse_x,mouse_y,_COL_15);
  line(backbuffer,rgun_x,rgun_y,mouse_x,mouse_y,_COL_15);
  textprintf(backbuffer,font,10,10,_COL_15,"ldeg %f, rdeg %f",lgun_angle,rgun_angle);
  textprintf(backbuffer,font,10,20,_COL_15,"lrad %f, rrad %f",lgun_angle*to_rad,rgun_angle*to_rad);
  textprintf(backbuffer,font,10,30,_COL_15,"lv %f, %f / rv %f, %f",cos(lgun_angle*to_rad),sin(lgun_angle*to_rad),cos(rgun_angle*to_rad),sin(rgun_angle*to_rad));
  textprintf(backbuffer,font,10,50,_COL_15,"ld_x %f, ld_y %f",ld_x,ld_y);
  textprintf(backbuffer,font,10,60,_COL_15,"rd_x %f, rd_y %f",rd_x,rd_y);
  textprintf(backbuffer,font,10,70,_COL_15,"Wave: %i",attack_wave);
  textprintf(backbuffer,font,10,80,_COL_15,"SOS: %i / STK: %i",smalls_on_screen,smalls_to_kill);
  textprintf(backbuffer,font,10,90,_COL_15,"MOS: %i / MTK: %i",mediums_on_screen,mediums_to_kill);
  textprintf(backbuffer,font,10,100,_COL_15,"BOS: %i / BTK : %i",bigs_on_screen,bigs_to_kill);
  textprintf(backbuffer,font,10,110,_COL_15,"animStackTop: %i",anim_top);
  textprintf(backbuffer,font,10,120,_COL_15,"shotStackTop: %i",shot_top);
  textprintf(backbuffer,font,10,130,_COL_15,"enmyStackTop: %i",enemy_top);
  textprintf(backbuffer,font,10,140,_COL_15,"DUMB plyr: %x",music_player);
  textprintf(backbuffer,font,10,150,_COL_15,"DUMB duh : %x",ingame_music);
  }

  // Mausanzeigen und finalen Blit performen
  show_mouse(backbuffer);

  if (screen_shot)
  {
    FILE *shotfile=NULL;
    shotfile = fopen("shot.raw","wb");
    char col;
    if (shotfile!=NULL)
    {
      for (i=0; i<480; i++)
        for (j=0; j<640; j++)
        {
          col = getpixel(backbuffer,j,i);
          fwrite(&col,sizeof(char),1,shotfile);
        };
      fclose(shotfile);
    }
    screen_shot=FALSE;
  }

  acquire_screen();
  blit(backbuffer,screen,0,0,0,0,640,480);
  release_screen();
};

// wird fuer game_cycle gebraucht
void game_count_up()
{
  if (!game_minimized) game_count++;
}
END_OF_FUNCTION(game_count_up);

// game_cycle()
// Die Hauptspielschleife
void game_cycle()
{
  int i;

  reset_all_vars();
  init_starfield();

  if (!already_locked)
  {
    LOCK_VARIABLE(game_minimized);
    LOCK_VARIABLE(game_count);
    LOCK_FUNCTION(game_count_up);
    if(install_int_ex(game_count_up, BPS_TO_TIMER(cycles_per_second))<0) gameover=TRUE;
    already_locked=TRUE;
  }

  while(game_over_count>0)
  {
    while((game_count>0)&&(!game_minimized))
    {
    // Musik Pollen (mu sein, da sonst der Player unttig bleibt)
      if ((can_do_sound)&&(MUSIC_ON)) 
      { 
        if (gameover) 
          al_duh_set_volume(music_player,float(game_over_count)*(mus_volume/float(show_next_wave)));
        al_poll_duh(music_player);
      }
    
    // Kanonenstatus neu berechnen
      update_guns();

    // User Input abfragen
    // Tasten
      if (keyboard_needs_poll()) poll_keyboard();
      if (key[KEY_ESC]) gameover=TRUE;
      if (key[KEY_F12]) screen_shot=TRUE;

    // Maus
      if (mouse_needs_poll()) poll_mouse();
      if ((mouse_b & 1)&&(lgun_load==0)) fire_cannon(0);
      if ((mouse_b & 2)&&(rgun_load==0)) fire_cannon(1);

    // Projektile bewegen und kollisionschecks
      for (i=0; i<max_shots; i++) all_shots[i].move_coll();

    // Gegner bewegen
      if (next_wave_delay==0) perform_attack_wave();

    // Animationen vorantreiben
      for (i=0; i<max_anims; i++) all_anims[i].advance();
    
    // Starfield bewegen
      move_stars();

      game_count--;

    // Kanonen abkhlen
      if ((game_count%heat_fallcycles)==0)
      {
        if (lgun_alive)
        {
          if (lgun_heat<=heat_fastfallofzone) lgun_heat-=heat_fastfalloff;
          else lgun_heat-=heat_falloff;
          if (lgun_heat<0) lgun_heat=0;
        }
        if (rgun_alive)
        {
          if (rgun_heat<=heat_fastfallofzone) rgun_heat-=heat_fastfalloff;
          else rgun_heat-=heat_falloff;
          if (rgun_heat<0) rgun_heat=0;
        }
      }
    
    // Score anpassen
      if (score<target_score) i = 1;
      else i = 0;

      switch(i)
      {
        case 1:
          score+=score_gaindrain_speed;
          if (score>target_score) score=target_score;
        break;
        case 0:
          score-=score_gaindrain_speed;
          if (score<target_score) score=target_score;
        break;
      } 

      if ((gameover)||(win_the_game)) game_over_count--;
      if (next_wave_delay>0) next_wave_delay--;
    }

    // Bild aktualisieren
    update_screen();
  }
  show_mouse(NULL);
};

// perform_attack_wave
// Erzeugt je nachdem neue Gegner und sorgt dafuer, da alle
// Gegner sich bewegen
void perform_attack_wave()
{
  int i;
  int enemy_num=-1;
  int what_to_spawn=-1;

  if (enemy_spawn>0) enemy_spawn--;

  if (enemy_spawn<=0)
  {
    enemy_spawn=0;
    enemy_num = get_free_enemy();
  }

  if (enemy_num!=-1)
  {
    // Per Zufall ein zu spawnendes Ufo auswaehlen
    switch (dice(3))
    {
      case 0:   // Wenn noch eins da ist, dann bitte ein grosses, sonst mittel, sonst klein
        if (smalls_on_screen<smalls_to_kill) what_to_spawn=SMALL_UFO;
        if (mediums_on_screen<mediums_to_kill) what_to_spawn=MEDIUM_UFO;
        if (bigs_on_screen<bigs_to_kill) what_to_spawn=BIG_UFO;
      break;
      case 1:   // Wenn noch eins da ist, dann bitte ein mittleres, sonst klein
        if (smalls_on_screen<smalls_to_kill) what_to_spawn=SMALL_UFO;
        if (mediums_on_screen<mediums_to_kill) what_to_spawn=MEDIUM_UFO;
      break;
      case 2:   // Wenn noch eins da ist, dann bitte ein kleines
        if (smalls_on_screen<smalls_to_kill) what_to_spawn=SMALL_UFO;
      break;
    }

    // ...das zufaellig gewaehlte Ufo an einer von 4 zufaelligen Positionen starten
    if (what_to_spawn!=-1)
    { 
      switch (dice(4))
      {
        case 0:
          all_enemies[enemy_num].spawn_new(-10,30,5,what_to_spawn,enemy_num);
        break;
        case 1:
          all_enemies[enemy_num].spawn_new(650,30,175,what_to_spawn,enemy_num);
        break;
        case 2:
          all_enemies[enemy_num].spawn_new(-10,140,355,what_to_spawn,enemy_num);
        break;
        case 3:
          all_enemies[enemy_num].spawn_new(650,140,185,what_to_spawn,enemy_num);
        break;
      }
      pop_enemy();
      enemy_spawn=enemy_delay;
    }
  }

  for (i=0; i<max_enemies; i++) all_enemies[i].move();

  // Wenn genug Ufos gekillt wurden, dann neue Angriffswelle
  if ((smalls_to_kill==0)&&(mediums_to_kill==0)&&(bigs_to_kill==0))
    next_attack_wave();
};

int get_survivalbonus()
{
  return (building_current_height[0]+building_current_height[1]+building_current_height[2]+building_current_height[3])*25;
}

// next_attack_wave
// bereitet die naechste Angriffswelle vor
void next_attack_wave()
{
  if (attack_wave<=total_waves){
    survival_bonus = get_survivalbonus();
    accuracy_bonus = int(accuracy_basebonus*hit_ratio);
    start_a_sound(SOUND_NEXT_WAVE,255,128,1000,FALSE);
    next_wave_delay=show_next_wave;
    attack_wave++;
    switch(difficulty)
    {
      case EASY:
        if(attack_wave%3==0)
        {
          smalls_to_kill=attack_wave;
          mediums_to_kill=0;
          bigs_to_kill=0;
        }
        else
        {
          smalls_to_kill=attack_wave;
          mediums_to_kill=attack_wave/3;
          bigs_to_kill=attack_wave/4;
        }
      break;
      case MEDIUM:
        if(attack_wave%3==0) 
        {
          smalls_to_kill=0;
          mediums_to_kill=attack_wave;
          bigs_to_kill=0;
        }
        else
        {
          smalls_to_kill=attack_wave;
          mediums_to_kill=attack_wave/2+difficulty;
          bigs_to_kill=attack_wave/3;
        }
      break;
      case HARD:
        if(attack_wave%3==0) 
        {
          smalls_to_kill=0;
          mediums_to_kill=0;
          bigs_to_kill=attack_wave/2;
        }
        else
        {
          smalls_to_kill=attack_wave;
          mediums_to_kill=attack_wave/2+difficulty;
          bigs_to_kill=attack_wave/3+difficulty;
        }
      break;
    }
    //smalls_to_kill=attack_wave+difficulty*4/*4*/;
    //mediums_to_kill=int(smalls_to_kill/2);
    //bigs_to_kill=int(mediums_to_kill/2);
    if (attack_wave>1)
    {
      gain_score(survival_bonus*difficulty);
      gain_score(accuracy_bonus*difficulty);
    }
  }
  if (attack_wave>total_waves)
  { 
     win_the_game=TRUE;
     attack_wave--;
     smalls_to_kill=0;
     mediums_to_kill=0;
     bigs_to_kill=0;
     score=target_score;
  } 
};

// start_a_sound
// Checkt ob sound gespielt werden kann und spielt, dann den sound von
// type aus der enum sound_type
void start_a_sound(int type, int ivol, int the_pan, int freq, int loop)
{
  int pan;
  int fvol=ivol*sfx_volume;
  if (SWAP_STEREO) 
    pan = 255-the_pan;
  else
    pan = the_pan;

  if (can_do_sound)
  {
    switch (type)
    {
      case SOUND_GUN_SHOT:
        play_sample((SAMPLE *)fugadata[SFX_GUN_SHOT].dat,fvol,pan,freq,loop);
      break;
      case SOUND_SHOT_HIT:
        play_sample((SAMPLE *)fugadata[SFX_SHOT_HIT].dat,fvol,pan,freq,loop);
      break;
      case SOUND_SMALL_EXPLODE:
        play_sample((SAMPLE *)fugadata[SFX_SMALL_EXPLODE].dat,fvol,pan,freq,loop);
      break;
      case SOUND_MEDIUM_EXPLODE:
        play_sample((SAMPLE *)fugadata[SFX_MEDIUM_EXPLODE].dat,fvol,pan,freq,loop);
      break;
      case SOUND_BIG_EXPLODE:
        play_sample((SAMPLE *)fugadata[SFX_BIG_EXPLODE].dat,fvol,pan,freq,loop);
      break;
      case SOUND_BOMB_HIT:
        play_sample((SAMPLE *)fugadata[SFX_BOMB_HIT].dat,fvol,pan,freq,loop);
      break;
      case SOUND_NEXT_WAVE:
        play_sample((SAMPLE *)fugadata[SFX_NEXT_WAVE].dat,fvol,pan,freq,loop);
      break;
    }
  }
};
