// FUGA Fliegende Untertassen greifen an
// von Dennis Busch http://www.dennisbusch.de

/*
Warnung:
Dieser Code ist schlecht, mllig, quick and dirty, spaghettihaft und entgegen
jeglichem gesunden Menschenverstand geschrieben.
Ich weise jegliche Verantwortung fr etwaige aus dem Betrachten dieses Codes
hervorgehende Augen- und/oder Hirnschden von mir.
Diesen Code anzusehen geschieht auf eigene Gefahr.
Und nimm dir diesen Code unter KEINEN Umstnden als Beispiel fr guten Programmierstil.
*/

// v1.20h update info re-release (3rd of Oct. 2014 and 6th of Oct. 2014)
//    -replaced third-party sound effects with selfmade effects
//    -put the project under a new LICENSE (MIT and CC BY-SA 4.0)
//    -removed mouse range restrictions in menues and in game

// v1.20g update info	-rekompiliert mit VS2008 unter Windows7
//						-standardmaessig laeuft das Spiel jetzt im Fenstermodus und 32bpp (wegen Farbproblem in Win7)
//            -Absturz beim Beenden behoben

// v1.20f update info   -nutzt jetzt Allegro4.2.2
//						-Spiel strzt nicht mehr einfach ab, wenn die .DAT Datei nicht geladen werden konnte
//						-luft jetzt auch unter WinXP 64bit

// v1.20 update info...-InGame "Musik" hinzugefgt
//                     -MenueFONT und InGameFONTs angepasst
//                     -Maus Untersttzung fr Mens eingefgt
//                     -Titelbild abgedunkelt und verfrbt als Top10,Anleitungshintergrund
//                     -ingame Hintergrundbild mit sidescrolling-Starfield hinzugefgt
//                     -neue Top3 Standard-Scores
//                     -seltenen Spielobjekt(Schuss) verschwindet BUG entfernt
//                     -Inkorrekter Programm-Shutdown BUG behoben
//                     -nutzt jetzt Allegro v4.1.8(wip) und DUMB v0.9.2

// v1.10 update info...-FONT auf ein besser lesbares angepasst
//                     -veralteten Creditsscreen entfernt
//                     -SCORE Abzug/Vergabe gendert (basiert auf Schwierigkeitsgrad)
//                     -Diverse Spielobjekt-Geschwindigkeiten angepasst (Gameplay Finetuning)
//                     -Schwierigkeitsgrade angepasst(auf Schwer hat man nur eine Kanone)
//                     -EndWave Ueberlebensboni eingefhrt
//                     -Trefferquote und Trefferquotenbonus eingefhrt
//                     -Schwierigkeitsgrad, Trefferquote und erreichte Welle werden mit in Top10 aufgenommen
//                     -Kanonenberhitzung eingefhrt
//                     -""Sie haben das Spiel gewonnen" Angriffswelle trotzdem +1"-BUG entfernt
//                     -"TaskSwitch"-BUG entfernt?
//                     -Freie Gegner,Schsse, Animationen werden jetzt schneller gefunden, dank QuickAndDirty Stacks
//                     -einen dummen JOKE MODUS eingefhrt ;)
//                     -Stereo Kanle knnen jetzt vertauscht werden

// v1.05 patch info...-kompiliert jetzt auch unter VisualC++6.0 mit Allegro4.0x
//                    -kollisionsbug gefixt (alle Gegner haben jetzt 1,2 bzw.3 Hitpoints)
//                    -Geschwindigkeit der Spielerkugeln leicht erhht
//                    -Schwierigkeitsgrade verndert

// "fugamain.cpp"
// Enthaelt Initialisierung und deinitialisierung

#include <math.h>
#include "aldumb.h"   // DUMB (Dynamic Universal Music Bibliotheque)
#include "allegro.h"  // Allegro Game Programming Library

#ifdef PI
#undef PI
#endif

#ifndef PI
const float PI = 3.14159;
#endif

bool DEBUG_MODE=FALSE;
bool JOKE_MODE=FALSE;
bool SWAP_STEREO=FALSE;
bool MUSIC_ON=TRUE;
const int debug_wave = 0;

enum redraw_loc
{
  language_select_screen=0,
  main_menu_screen,
  manual_screen1,
  manual_screen2,
  enter_top10_screen,
  top10_screen,
  in_game_screen
};
int global_screen_state = language_select_screen; // merkt sich den momentanen screen fr task-switching

enum mouse_menu_position
{ 
  start_game=1,
  select_difficulty,
  show_instructions,
  show_top10,
  music_option,
  stereo_option,
  end_game
};
int mouse_menu_state = start_game;
bool menu_state_changed = true;

/*
BEGIN_GFX_DRIVER_LIST
  GFX_DRIVER_VGA
  GFX_DRIVER_VESA3
  GFX_DRIVER_VESA2L
  GFX_DRIVER_VESA2B
  GFX_DRIVER_VESA1
END_GFX_DRIVER_LIST

BEGIN_COLOR_DEPTH_LIST
  COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST

BEGIN_DIGI_DRIVER_LIST
  DIGI_DRIVER_SOUNDSCAPE
  DIGI_DRIVER_AUDIODRIVE
  DIGI_DRIVER_WINSOUNDSYS
  DIGI_DRIVER_SB
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST
*/

#include "FUGADAT2.H"
DATAFILE *fugadata;
#include "system.cpp"
#include "all_text.cpp"

// Variablen fr DUMB
DUH *ingame_music=NULL;
AL_DUH_PLAYER *music_player=NULL;
const int mus_channels = 2;
const float mus_volume = 1.0;
const float sfx_volume = 0.7; //( 0.0 <= sfx_volume <= 1.0)
const long mus_buffer = 4096;
const int mus_freq = 44100;
// Ende Variablen fr DUMB

FONT *TINY_FONT=NULL;
FONT *TINY_FONT_FILL=NULL;
FONT *TINY_FONT_BORDER=NULL;
FONT *SMALL_FONT=NULL;
FONT *SMALL_FONT_FILL=NULL;
FONT *SMALL_FONT_BORDER=NULL;
FONT *BIG_FONT=NULL;
FONT *BIG_FONT_FILL=NULL;
FONT *BIG_FONT_BORDER=NULL;

// color constants (introduced to ease up porting from indexed 8bpp mode to 32bpp mode)
// they will be set after loading the palette and the images
int _COL_15 = 0;
int _COL_16 = 0;
int _COL_22 = 0;
int _COL_25 = 0;
int _COL_26 = 0;
int _COL_31 = 0;
int _COL_32 = 0;
int _COL_33 = 0;
int _COL_64 = 0;
int _COL_71 = 0;
int _COL_79 = 0;
int _COL_86 = 0;
int _COL_96 = 0;
int _COL_122 = 0;
int _COL_135 = 0;

const float to_deg = 180/PI; // hiermit multiplizieren um von rad auf deg zu kommen
const float to_rad = PI/180; // hiermit multiplizieren um von deg auf rad zu kommen
const float pan_adjust=255/640; // hiermit multiplizieren um von 0-640 auf 0-255 umzuwandeln

// Variablen, die die Spielgeschwindigkeit und das Gameplay beeinflussen
const int fix_sp=2;                    // an diesem Speed orientiert sich alles.
const int cycles_per_second=50/fix_sp; // Anzahl der Spielzyklen pro Sekunde -->NICHT MEHR NDERN!!!<--
const int reload_time = 24/fix_sp;     // Nachladezeit in Spielzyklen
const int enemy_delay = 60/fix_sp;     // Zeit zwischen zwei Gegnerspawns in Spielzyklen //60
const int enemy_move_time = 26/fix_sp; // Zeit in Spielzyklen, bevor ein Gegner eine neue Flugrichtung einschlaegt
const int show_next_wave = 150/fix_sp; // solange soll next_wave angezeigt werden

const int max_shots   = 200;    // maximale Anzahl an Geschossen gleichzeitig im Spiel // 200
const int max_enemies = 25;     // maximale Anzahl an Gegnern gleichzeitig im Spiel // 25
const int max_anims   = 300;    // maximale Anzahl (Zusatz-)Animationen gleichzeitig im Spiel (Geschosse und Gegner haben jeweils ihre eigene Animation)
const int enemy_min_y = 20;     // Hoeher als dieser y-Wert duerfen die Gegner nicht fliegen
const int enemy_max_y = 150;    // Niedriger als dieser...
const int total_waves = 30;     // hoechst-Levelzahl
const int max_score = 99999;    // hoechstpunktzahl

const float bullet_speed = 5.0;      // SpielerSchuss Geschwindigkeit // 0.5
const float bombstart_speed = 0.8;   // Bombenstart Geschwindigkeit // 0.8
const float infiltrator_speed = 1.0; // Infiltrator Startgeschwindigkeit // 1.0
const float max_fallspeed = 2.1;     // maximale Fallgeschwindigkeit // 2.1
const float grav_constant = 0.0327;  // auf Spielumgebung angepasste Gravitationskonstante

const float heat_gain = 1.84;//1.84;    // Hitzeentwicklung pro Schuss
const int heat_fallcycles = 5;   // Alle x Zyklen wird nimmt Hitze ab
const float heat_falloff = 0.072;// Hitzeabkhlung
const float heat_deadzone = 1.72;// Hitzetodeszone (liegt die Hitze ber max_heat-heat_deadzone, kann nicht geschossen werden)
const float heat_fastfallofzone = 15.0; // Hitze in dieser Zone khlt schneller runter
const float heat_fastfalloff = 0.09;
const float max_heat = 20.0;     // Maximalhitze

const int score_gaindrain_speed = 10;
int survival_bonus;             // Angriffswellenueberlebensbonus
int target_score;               // Zielpunktestand
int score;                      // Punktestand

const int accuracy_basebonus = 100; // Genauigkeitsgrundbonus
int accuracy_bonus;             // Genauigkeitsbonus am Ende der Welle
float shots_fired;              // Abgegebene Schsse
float shots_hit;                // Treffer
float hit_ratio;                // Trefferquote (wird am Ende mit Score multipliziert um Endscore zu bekommen

// Highscoreliste (Top 10)
char topten_name[10][21];
int topten_score[10];
int topten_difficulty[10];
float topten_hit_ratio[10];
int topten_wave[10];

// Gebaeude
int building_height[4];         // Ausgangshoehe in Stockwerken
int building_current_height[4]; // aktuelle Hoehe (je nach Zerstoerung)
int building_x[4];              // Linke Seitenkoordinaten der Gebauede
const int building_y=411;       // Dachleiste des 1.Stocks

// Die Tunnel
const int tunnel_length=11;     // Dieser Wert darf nicht mehr geaendert werden!
int tunnel_one_length;
int tunnel_two_length;
int tunnel_x[tunnel_length];    // Koordinaten der Tunnelteile
int tunnel_y[tunnel_length];

// Variablen fuer Angriffswellen
int difficulty;  // Schwierigkeitsgrad (1EASY,2MEDIUM,3HARD)
int attack_wave; // Nr. der Angriffswelle
int smalls_to_kill;  // diese 3 werden...
int mediums_to_kill; // am Anfang der Angriffswelle je nach difficulty...
int bigs_to_kill;    // und attack_wave bestueckt, wenn sie 0 erreichen dann naechste welle

int smalls_on_screen;
int mediums_on_screen;
int bigs_on_screen;

// Quick And Dirty Stacks zum Merken der freien Animationen,Schsse und Gegner
int anim_stack[max_anims];
int anim_top=-1;
int shot_stack[max_shots];
int shot_top=-1;
int enemy_stack[max_enemies];
int enemy_top=-1;
void push_anim(int which) {if (which==-1) return; if (anim_top+1<max_anims) { anim_top++; anim_stack[anim_top]=which; } };
int pop_anim() { if (anim_top>=0) { anim_top--; return anim_stack[anim_top+1]; } else return -1;};
void push_shot(int which) {if (which==-1) return; if (shot_top+1<max_shots) { shot_top++; shot_stack[shot_top]=which; } };
int pop_shot() { if (shot_top>=0) { shot_top--; return shot_stack[shot_top+1]; } else return -1;};
void push_enemy(int which){if (enemy_top+1<max_enemies) { enemy_top++; enemy_stack[enemy_top]=which; } };
int pop_enemy(){ if (enemy_top>=0) { enemy_top--; return enemy_stack[enemy_top+1]; } else return -1;};


// Forward Deklaration der Kollisionsdetektionsfunktion
// da diese von der Klasse c_shot bereits benoetigt wird.
// Die genaue Deklaration erfolgt spaeter in game.cpp,
// weil diese Funktion wiederum Variablen aus game.cpp benoetigt
enum collision_type{ SHOT_TO_ENEMY, SHOT_TO_SHOT, SHOT_TO_CANNON, SHOT_TO_BUILDING, SHOT_TO_TUNNEL };
void perform_collision(int type,int a /*with*/, int b);

// Forward Deklaration von get_free_shot, da diese Funktion von der
// enemy Klasse gebraucht wird.
// Die genaue Deklaration erfolgt spaeter in game.cpp,
int get_free_shot();

#include "c_anim.cpp"

// Forward Deklaration von get_free_anim, da diese Funktion
// von shot und enemy Klassen gebraucht wird
c_anim all_anims[max_anims];
int x_anim[max_anims];
int y_anim[max_anims];
int get_free_anim();
void start_new_anim(int which, int x,int y, int start, int num, int typ, int time);
void start_new_shot(int a,int b, float angle, float sp, int own, int typ);

#include "c_shots.cpp"
// Projektile muessen schon hier deklariert werden, weil enemy darauf zugreifen muss
c_shot all_shots[max_shots];

// Forward Deklaration von start_a_sound,gain_score und drain_score da diese von
// der enemy Klasse gebraucht werden
// Eigentliche Implementationen in game.cpp
enum sound_type
{
  SOUND_GUN_SHOT, SOUND_SHOT_HIT, SOUND_SMALL_EXPLODE, SOUND_MEDIUM_EXPLODE,
  SOUND_BIG_EXPLODE, SOUND_BOMB_HIT, SOUND_NEXT_WAVE
};
void start_a_sound(int type, int ivol, int the_pan, int freq, int loop);
void gain_score(int how_much);
void drain_score(int how_much);

#include "c_enemy.cpp"
#include "game.cpp"

int runlevel;

int fuga_start()
{
  runlevel=0;
  // Allegrosystem initialisieren
  if (init()==0) runlevel=1; else return 1;

  // Grafikmodus setzen
  set_color_depth(32);
  // fixes color problem in Windows 7
  set_color_conversion(COLORCONV_TOTAL |
                       COLORCONV_KEEP_TRANS);
  if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0)==0) runlevel=2; else return 2;

  // Backbuffer erzeugen
  sprintf(debug_msg,messages[msg_create_backbuffer]); debug_add(debug_msg);
  backbuffer=NULL;
  backbuffer = create_bitmap(640,480);
  if (backbuffer!=NULL){
    clear(backbuffer);
    sprintf(debug_msg,messages[msg_ok_backbuffer]); debug_add(debug_msg);
    runlevel=3;
  } else
  {
    sprintf(debug_msg,messages[msg_not_enough_memory]); debug_add(debug_msg);
    return 3;
  }

  // noch einen Backbuffer erzeugen (fr Hintergrundgrafik)
  sprintf(debug_msg,messages[msg_create_backbuffer]); debug_add(debug_msg);
  background=NULL;
  background = create_bitmap(640,480);
  if (background!=NULL){
    clear(background);
    sprintf(debug_msg,messages[msg_ok_backbuffer]); debug_add(debug_msg);
    runlevel=4;
  } else
  {
    sprintf(debug_msg,messages[msg_not_enough_memory]); debug_add(debug_msg);
    return 4;
  }

  // DUMB fr packfiles bereit machen
  if (can_do_sound)
  { 
     dumb_register_dat_it(DUMB_DAT_IT);
  }

  // Datenfile laden
  fugadata=NULL;
  sprintf(debug_msg,messages[msg_load_data]); debug_add(debug_msg);
  packfile_password("..!-:)");

  // load and set palette before loading datafile
  DATAFILE* pal = load_datafile_object("FUGADAT2.DAT", "GFX_GAMEPAL");
  if(pal != NULL)
  {
    set_palette((RGB*)pal->dat);

    // set color constants

  }

  fugadata = load_datafile("FUGADAT2.DAT");
  if (fugadata!=NULL)
  {
    sprintf(debug_msg,messages[msg_ok_load_data]); debug_add(debug_msg);
    // Palette anpassen
    //RGB p[256]=(RGB [])fugadata[GFX_GAMEPAL].dat;
    //void *p=find_datafile_object(fugadata,"GFX_GAMEPAL")->dat;
    //RGB *pal=(RGB *)p;
    //set_palette(pal);
    //RGB black = {0,0,0};
    //set_color(0,&black);

    runlevel=5;
  } else
  {
    sprintf(debug_msg,messages[msg_fail_load_data]); debug_add(debug_msg);
    return 5;
  }
  return 0;
};

int fuga_shut()
{
  if (can_do_sound) 
  { 
     // DUMB beenden
     al_stop_duh(music_player);
     // unload_duh darf NICHT benutzt werden, da das DUH Object durch unload_datafile schon entladen wird
     dumb_exit();
  }

  if (runlevel>=5)
  {
    sprintf(debug_msg,messages[msg_unload_data]); debug_add(debug_msg);
    unload_datafile(fugadata);
    sprintf(debug_msg,messages[msg_ok_unload_data]); debug_add(debug_msg);
  }
 
  if (runlevel>=4)
  {
    sprintf(debug_msg,messages[msg_clean_up_mem]); debug_add(debug_msg);
    destroy_bitmap(background);
    sprintf(debug_msg,messages[msg_ok_clean_up_mem]); debug_add(debug_msg);
  }

  if (runlevel>=3)
  {
    sprintf(debug_msg,messages[msg_clean_up_mem]); debug_add(debug_msg);
    destroy_bitmap(backbuffer);
    sprintf(debug_msg,messages[msg_ok_clean_up_mem]); debug_add(debug_msg);
  }

  sprintf(debug_msg,"2"); debug_add(debug_msg);

  //if (runlevel>=2) set_gfx_mode(GFX_TEXT,80,25,0,0);

  sprintf(debug_msg,"1"); debug_add(debug_msg);

  if (runlevel>=0)
  {
    shutdown();
  }
  return 0;
};

// Wartet darauf, dass der User Leertaste drueckt
void wait_for_space()
{
  if (keyboard_needs_poll()) poll_keyboard();
  while(key[KEY_SPACE])
  {
    if (keyboard_needs_poll()) poll_keyboard();
  }
  clear_keybuf();
  char command='#';
  while(command!=32)
  {
    if (keypressed()) command=readkey();
  }
};

// Prft ob Maus geklickt wird
bool mouse_click(int button)
{
  if (mouse_needs_poll()) poll_mouse();
  if (mouse_b & button) 
    return true;
  else 
    return false;
}

// Prft ob Maus in bestimmtem Bereich
bool mouse_in(int x,int y,int x2,int y2)
{
  if (mouse_needs_poll()) poll_mouse();
  if (mouse_x<x) return false;
  if (mouse_x>x2) return false;
  if (mouse_y<y) return false;
  if (mouse_y>y2) return false;
  return true;
}

void wait_for_mouse()
{
  while(!mouse_click(1));
  while(mouse_click(1));
}

// Zeigt den Bildschirm mit den zwei Flaggen an und laesst eine
// Sprache auswaehlen
void redraw_language_screen()
{
  //clear(backbuffer);
  blit((BITMAP *)fugadata[GFX_TITLE_SCREEN_DARK].dat,backbuffer,0,0,0,0,640,480);

  text_mode(-1);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,50,_COL_22,"-1 Waehle deine Sprache-");
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,50,_COL_15,"-1 Waehle deine Sprache-");
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,80,_COL_22,"-2 Select your language-");
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,80,_COL_15,"-2 Select your language-");

  rect(backbuffer,279,169,360,230,_COL_15);
  rect(backbuffer,279,309,360,370,_COL_15);

  draw_sprite(backbuffer,(BITMAP *)fugadata[GFX_GER_FLAG].dat,280,170);
  draw_sprite(backbuffer,(BITMAP *)fugadata[GFX_BRI_FLAG].dat,280,310);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,185,_COL_22,"1");
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,185,_COL_15,"1");

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,325,_COL_22,"2");
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,325,_COL_15,"2");

  blit(backbuffer,screen,0,0,0,0,640,480);
};
void show_language_select_screen()
{
  global_screen_state=language_select_screen;
  char command='#';
  int w=((BITMAP *)fugadata[GFX_GER_FLAG].dat)->w;
  int h=((BITMAP *)fugadata[GFX_GER_FLAG].dat)->h;
  
  //set_mouse_range(280,170,280+w,310+h);
  show_mouse(NULL);
  redraw_language_screen();
  show_mouse(screen);

  while((command!='1')&&(command!='2'))
  {
    if (keypressed())
      command=readkey();
    if (mouse_click(1)&&(mouse_in(280,170,280+w,170+h)))
      command='1';
    if (mouse_click(1)&&(mouse_in(280,310,280+w,310+h)))
      command='2';  
  }

  switch(command)
  {
    case '1': set_game_language(0);
    break;
    case '2': set_game_language(1);
  }

  while(mouse_click(1)); // warten bis Maus losgelassen wird

  show_mouse(NULL);
};

void redraw_title_screen()
{
  BITMAP *bmp_title=NULL;

  bmp_title = (BITMAP *)fugadata[GFX_TITLE_SCREEN].dat;
  blit(bmp_title,backbuffer,0,0,0,0,640,480);
  blit((BITMAP *)fugadata[DB_LOGO64].dat,backbuffer,0,0,640-64-20,480-64-20,64,64);

  draw_sprite(backbuffer,(BITMAP *)fugadata[DUMB_LOGO].dat,20,480-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-((BITMAP *)fugadata[DUMB_LOGO].dat)->h-40);
  draw_sprite(backbuffer,(BITMAP *)fugadata[ALLEGRO_LOGO].dat,20,480-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-20);

  textprintf(backbuffer,TINY_FONT_BORDER,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-((BITMAP *)fugadata[DUMB_LOGO].dat)->h-40,_COL_79,"%s",game_text[txt_poweredby]);
  textprintf(backbuffer,TINY_FONT_FILL,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-((BITMAP *)fugadata[DUMB_LOGO].dat)->h-40,_COL_64,"%s",game_text[txt_poweredby]);

  textprintf(backbuffer,TINY_FONT_BORDER,20,460,_COL_79,"%s",game_text[txt_moreinfo2]);
  textprintf(backbuffer,TINY_FONT_FILL,20,460,_COL_64,"%s",game_text[txt_moreinfo2]);

  textprintf(backbuffer,TINY_FONT_BORDER,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-20,_COL_79,"%s",game_text[txt_moreinfo3]);
  textprintf(backbuffer,TINY_FONT_FILL,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-20,_COL_64,"%s",game_text[txt_moreinfo3]);

  textprintf_right(backbuffer,TINY_FONT_BORDER,620,460,_COL_79,"%s",game_text[txt_moreinfo]);
  textprintf_right(backbuffer,TINY_FONT_FILL,620,460,_COL_64,"%s",game_text[txt_moreinfo]);
  
  switch(game_language)
  {
    case 0: // Deutsch
      bmp_title=(BITMAP *)fugadata[GFX_GER_TITLE].dat;
    break;
    case 1: // Englisch
      bmp_title=(BITMAP *)fugadata[GFX_BRI_TITLE].dat;
    break;
  }

  draw_sprite(backbuffer,bmp_title,int(320-bmp_title->w/2),0);

  if(DEBUG_MODE) textprintf(backbuffer,font,0,0,_COL_15,"DEBUG");
  if(JOKE_MODE) textprintf(backbuffer,font,0,8,_COL_15,"JOKE MODE");
  // if(SWAP_STEREO) textprintf_right(backbuffer,font,640,0,15,"SWAP STEREO");
  textprintf_centre(backbuffer,TINY_FONT_BORDER,320,bmp_title->h,_COL_79,"%s",game_text[txt_sub_title]);
  textprintf_centre(backbuffer,TINY_FONT_FILL,320,bmp_title->h,_COL_64,"%s",game_text[txt_sub_title]);

  textprintf_centre(backbuffer,TINY_FONT_BORDER,320,bmp_title->h+14,_COL_79,"%s",game_text[txt_version]);
  textprintf_centre(backbuffer,TINY_FONT_FILL,320,bmp_title->h+14,_COL_64,"%s",game_text[txt_version]);
  blit(backbuffer,screen,0,0,0,0,640,480);
};

void redraw_menue_text()
{
  int col;
  BITMAP *bmp_title=NULL;
  bmp_title = (BITMAP *)fugadata[GFX_TITLE_SCREEN].dat;
  blit(bmp_title,backbuffer,135,240,135,240,370,210);

  // powered by Info
  textprintf(backbuffer,TINY_FONT_BORDER,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-((BITMAP *)fugadata[DUMB_LOGO].dat)->h-40,_COL_79,"%s",game_text[txt_poweredby]);
  textprintf(backbuffer,TINY_FONT_FILL,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-((BITMAP *)fugadata[DUMB_LOGO].dat)->h-40,_COL_64,"%s",game_text[txt_poweredby]);

  textprintf(backbuffer,TINY_FONT_BORDER,20,460,_COL_79,"%s",game_text[txt_moreinfo2]);
  textprintf(backbuffer,TINY_FONT_FILL,20,460,_COL_64,"%s",game_text[txt_moreinfo2]);

  textprintf(backbuffer,TINY_FONT_BORDER,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-20,_COL_79,"%s",game_text[txt_moreinfo3]);
  textprintf(backbuffer,TINY_FONT_FILL,20,460-((BITMAP *)fugadata[ALLEGRO_LOGO].dat)->h-20,_COL_64,"%s",game_text[txt_moreinfo3]);
  //

  //textprintf_centre(backbuffer,BIG_FONT_BORDER,320,240,159,"%s",game_text[txt_main_menue]);
  //textprintf_centre(backbuffer,BIG_FONT_FILL,320,240,136,"%s",game_text[txt_main_menue]);
  
  col = (mouse_menu_state==start_game) ? _COL_16 : _COL_25;
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,270,_COL_31,"%s",game_text[txt_start_game]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,270,col,"%s",game_text[txt_start_game]);
  
  col = (mouse_menu_state==select_difficulty) ? _COL_16 : _COL_25;
  switch(difficulty)
  {
    case EASY:
      textprintf_centre(backbuffer,BIG_FONT_BORDER,320,300,_COL_31,"%s-%s",game_text[txt_difficulty],game_text[txt_easy]);
      textprintf_centre(backbuffer,BIG_FONT_FILL,320,300,col,"%s-%s",game_text[txt_difficulty],game_text[txt_easy]);
    break;
    case MEDIUM:
      textprintf_centre(backbuffer,BIG_FONT_BORDER,320,300,_COL_31,"%s-%s",game_text[txt_difficulty],game_text[txt_normal]);  
      textprintf_centre(backbuffer,BIG_FONT_FILL,320,300,col,"%s-%s",game_text[txt_difficulty],game_text[txt_normal]); 
      
    break;
    case HARD:
      textprintf_centre(backbuffer,BIG_FONT_BORDER,320,300,_COL_31,"%s-%s",game_text[txt_difficulty],game_text[txt_hard]); 
      textprintf_centre(backbuffer,BIG_FONT_FILL,320,300,col,"%s-%s",game_text[txt_difficulty],game_text[txt_hard]); 
    break;
  }
  col = (mouse_menu_state==show_instructions) ? _COL_16 : _COL_25;
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,330,_COL_31,"%s",game_text[txt_instructions]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,330,col,"%s",game_text[txt_instructions]);
  
  col = (mouse_menu_state==show_top10) ? _COL_16 : _COL_25;
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,360,_COL_31,"%s",game_text[txt_top_ten]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,360,col,"%s",game_text[txt_top_ten]);
 
  col = (mouse_menu_state==music_option) ? _COL_16 : _COL_25;
  textprintf_centre(backbuffer,TINY_FONT_BORDER,320,390,_COL_31,"%s-%s",game_text[txt_music],(MUSIC_ON)?game_text[txt_on]:game_text[txt_off]);
  textprintf_centre(backbuffer,TINY_FONT_FILL,320,390,col,"%s-%s",game_text[txt_music],(MUSIC_ON)?game_text[txt_on]:game_text[txt_off]);

  col = (mouse_menu_state==stereo_option) ? _COL_16 : _COL_25;
  textprintf_centre(backbuffer,TINY_FONT_BORDER,320,402,_COL_31,"%s-%s",game_text[txt_swapstereo],(SWAP_STEREO)?game_text[txt_on]:game_text[txt_off]);
  textprintf_centre(backbuffer,TINY_FONT_FILL,320,402,col,"%s-%s",game_text[txt_swapstereo],(SWAP_STEREO)?game_text[txt_on]:game_text[txt_off]);

  col = (mouse_menu_state==end_game) ? _COL_16 : _COL_25;
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,420,_COL_31,"%s",game_text[txt_end]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,420,col,"%s",game_text[txt_end]);
  
  show_mouse(NULL);
  blit(backbuffer,screen,135,240,135,240,370,210);
  show_mouse(screen);
};

void check_and_update_menu_state()
{
  int new_menu_state = -1;
  if (mouse_y>=270) new_menu_state=start_game;
  if (mouse_y>=300) new_menu_state=select_difficulty;
  if (mouse_y>=330) new_menu_state=show_instructions;
  if (mouse_y>=360) new_menu_state=show_top10;
  if (mouse_y>=390) new_menu_state=music_option;
  if (mouse_y>=402) new_menu_state=stereo_option;
  if (mouse_y>=420) new_menu_state=end_game;
  if (new_menu_state!=mouse_menu_state) menu_state_changed=true;
  if (menu_state_changed) 
  {
     mouse_menu_state=new_menu_state;
     redraw_menue_text();
     menu_state_changed=false;
  }
};


void redraw_instructions_page1()
{
  int i;
  //clear_to_color(backbuffer,135);
  //rect(backbuffer,0,0,SCREEN_W-1,SCREEN_H-1,130);
  blit((BITMAP *)fugadata[GFX_TITLE_SCREEN_DARK].dat,backbuffer,0,0,0,0,640,480);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,10,_COL_135,"%s",game_text[txt_story]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,10,_COL_71,"%s",game_text[txt_story]);

  for (i=0; i<28; i++)
  {
    textprintf_centre(backbuffer,TINY_FONT_BORDER,320,50+i*14,_COL_31,"%s",game_text[txt_inst_line00+i]);
    textprintf_centre(backbuffer,TINY_FONT_FILL,320,50+i*14,_COL_15,"%s",game_text[txt_inst_line00+i]);
  }

  textprintf_centre(backbuffer,SMALL_FONT_BORDER,320,460,_COL_31,"%s",game_text[txt_mouse_to_continue]);
  textprintf_centre(backbuffer,SMALL_FONT_FILL,320,460,_COL_71,"%s",game_text[txt_mouse_to_continue]);
  blit(backbuffer,screen,0,0,0,0,640,480);
};
void redraw_instructions_page2()
{
  int i,col;
  //clear_to_color(backbuffer,135);
  //rect(backbuffer,0,0,SCREEN_W-1,SCREEN_H-1,130);
  blit((BITMAP *)fugadata[GFX_TITLE_SCREEN_DARK].dat,backbuffer,0,0,0,0,640,480);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,10,_COL_135,"%s",game_text[txt_mission]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,10,_COL_71,"%s",game_text[txt_mission]);

  for (i=0; i<5; i++)
  {
    col=_COL_15;
    if (i==4) col=_COL_33;
    textprintf_centre(backbuffer,TINY_FONT_BORDER,320,50+i*14,_COL_31,"%s",game_text[txt_inst_line28+i]);
    textprintf_centre(backbuffer,TINY_FONT_FILL,320,50+i*14,col,"%s",game_text[txt_inst_line28+i]);
  }

  for (i=0; i<16; i++)
  {
    col = _COL_15;
    if ((i==0)||(i==4)) col=_COL_71;
    if (i==5) col = _COL_33;
    if (i==6) col = _COL_86;
    if (i==7) col = _COL_122;
    textprintf(backbuffer,TINY_FONT_BORDER,20,150+i*14,_COL_31,"%s",game_text[txt_inst_line33+i]);
    textprintf(backbuffer,TINY_FONT_FILL,20,150+i*14,col,"%s",game_text[txt_inst_line33+i]);
  }

  textprintf_centre(backbuffer,SMALL_FONT_BORDER,320,460,_COL_31,"%s",game_text[txt_mouse_to_continue]);
  textprintf_centre(backbuffer,SMALL_FONT_FILL,320,460,_COL_71,"%s",game_text[txt_mouse_to_continue]);
  blit(backbuffer,screen,0,0,0,0,640,480);
};
void show_instruction_screens()
{
  show_mouse(NULL);
  global_screen_state = manual_screen1;
  redraw_instructions_page1();
  wait_for_mouse();

  global_screen_state = manual_screen2;
  redraw_instructions_page2();
  wait_for_mouse();
};

void reset_top_ten()
{
  int i;
  for (i=0; i<10; i++)
  {
    sprintf(topten_name[i],"....................");
    topten_score[i]=0;
    topten_difficulty[i]=EASY;
    topten_hit_ratio[i]=0.00;
    topten_wave[i]=1;
  }
  // Voreingestellter 1.Platz
    sprintf(topten_name[0],"Dennis.Busch........");
  topten_score[0]=49000;
  topten_difficulty[0]=HARD;
  topten_hit_ratio[0]=0.85;
  topten_wave[0]=25;

  // Voreingestellter 2.Platz
    sprintf(topten_name[1],"Dennis.Busch........");
  topten_score[1]=35000;
  topten_difficulty[1]=MEDIUM;
  topten_hit_ratio[1]=0.65;
  topten_wave[1]=28;
  
  // Voreingestellter 3.Platz
    sprintf(topten_name[2],"Dennis.Busch........");
  topten_score[2]=14000;
  topten_difficulty[2]=EASY;
  topten_hit_ratio[2]=0.60;
  topten_wave[2]=30;

  sprintf(debug_msg,"Score reset."); debug_add(debug_msg);
};

void save_top_ten()
{
  FILE *scorefile;
  int i;

  scorefile = fopen("TOPTEN2.DAT","wb");

  if (scorefile!=NULL)
  {
    for (i=0; i<10; i++)
    {
      fwrite(topten_name[i],sizeof(char),20,scorefile);
      fwrite(&topten_score[i],sizeof(int),1,scorefile);
      fwrite(&topten_difficulty[i],sizeof(int),1,scorefile);
      fwrite(&topten_hit_ratio[i],sizeof(float),1,scorefile);
      fwrite(&topten_wave[i],sizeof(int),1,scorefile);
    }
    sprintf(debug_msg,"Score save."); debug_add(debug_msg);
    fclose(scorefile);
  }
};

void load_top_ten()
{
  FILE *scorefile;
  int i;

  scorefile = fopen("TOPTEN2.DAT","rb");

  if (scorefile!=NULL)
  {
    for (i=0; i<10; i++)
    {
      fread(topten_name[i],sizeof(char),20,scorefile);
      fread(&topten_score[i],sizeof(int),1,scorefile);
      fread(&topten_difficulty[i],sizeof(int),1,scorefile);
      fread(&topten_hit_ratio[i],sizeof(float),1,scorefile);
      fread(&topten_wave[i],sizeof(int),1,scorefile);
    }
    sprintf(debug_msg,"Score load."); debug_add(debug_msg);
    fclose(scorefile);
  } else
  {
    reset_top_ten();
  }
};

void redraw_top_ten_screen()
{
  int i;
  int spacing=35;

  //clear_to_color(backbuffer,135);
  //rect(backbuffer,0,0,SCREEN_W-1,SCREEN_H-1,130);
  blit((BITMAP *)fugadata[GFX_TITLE_SCREEN_DARK].dat,backbuffer,0,0,0,0,640,480);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,15,_COL_135,"%s",game_text[txt_top_ten]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,15,_COL_71,"%s",game_text[txt_top_ten]);

  textprintf(backbuffer,BIG_FONT_BORDER,10,50,_COL_135,"%s",game_text[txt_name]);
  textprintf(backbuffer,BIG_FONT_FILL,10,50,_COL_86,"%s",game_text[txt_name]);

  textprintf(backbuffer,BIG_FONT_BORDER,490,50,_COL_135,"%s",game_text[txt_points]);
  textprintf(backbuffer,BIG_FONT_FILL,490,50,_COL_86,"%s",game_text[txt_points]);
  for (i=0; i<10; i++)
  {
    textprintf_right(backbuffer,BIG_FONT_BORDER,48,84+i*spacing,_COL_31,"%i.",i+1);
    textprintf_right(backbuffer,BIG_FONT_FILL,48,84+i*spacing,_COL_33,"%i.",i+1);
    
    textprintf(backbuffer,SMALL_FONT_BORDER,50,80+i*spacing,_COL_31,"%s",topten_name[i]);
    textprintf(backbuffer,SMALL_FONT_FILL,50,80+i*spacing,_COL_15,"%s",topten_name[i]);

    textprintf(backbuffer,TINY_FONT_BORDER,50,75+i*spacing+19,_COL_31,
      "%s:%6s  %s:%3.0f%%  %s: %2i",
      game_text[txt_difficulty],
      game_text[txt_easy-1+topten_difficulty[i]],
      game_text[txt_hitratio],
      topten_hit_ratio[i]*100,
      game_text[txt_wave],topten_wave[i]);
    textprintf(backbuffer,TINY_FONT_FILL,50,75+i*spacing+19,_COL_71,
      "%s:%6s  %s:%3.0f%%  %s: %2i",
      game_text[txt_difficulty],
      game_text[txt_easy-1+topten_difficulty[i]],
      game_text[txt_hitratio],
      topten_hit_ratio[i]*100,
      game_text[txt_wave],topten_wave[i]);
    textprintf(backbuffer,BIG_FONT_BORDER,490,80+i*spacing,_COL_31,"%i",topten_score[i]);
    textprintf(backbuffer,BIG_FONT_FILL,490,80+i*spacing,_COL_71,"%i",topten_score[i]);
  }

  textprintf_centre(backbuffer,SMALL_FONT_BORDER,320,460,_COL_31,"%s",game_text[txt_mouse_to_continue]);
  textprintf_centre(backbuffer,SMALL_FONT_FILL,320,460,_COL_71,"%s",game_text[txt_mouse_to_continue]);
  blit(backbuffer,screen,0,0,0,0,640,480);
}
void show_top_ten_screen()
{
  show_mouse(NULL);
  global_screen_state = top10_screen;
  redraw_top_ten_screen();
  wait_for_mouse();
};

void redraw_enter_topscreen()
{
  //clear_to_color(backbuffer,135);
  //rect(backbuffer,0,0,SCREEN_W-1,SCREEN_H-1,130);
  blit((BITMAP *)fugadata[GFX_TITLE_SCREEN_DARK].dat,backbuffer,0,0,0,0,640,480);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,15,_COL_135,"%s",game_text[txt_top_ten]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,15,_COL_71,"%s",game_text[txt_top_ten]);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,50,_COL_31,"%s %i",game_text[txt_with_your_score],score);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,50,_COL_86,"%s %i",game_text[txt_with_your_score],score);
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,80,_COL_31,"%s %i",game_text[txt_made_it_to_place],topten_current_pos+1);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,80,_COL_86,"%s %i",game_text[txt_made_it_to_place],topten_current_pos+1);
  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,140,_COL_31,"%s",game_text[txt_enter_name]);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,140,_COL_71,"%s",game_text[txt_enter_name]);
  blit(backbuffer,screen,0,0,0,0,640,480);
};
void redraw_enter_topname()
{
  //rectfill(backbuffer,10,200,630,300,135);
  blit((BITMAP *)fugadata[GFX_TITLE_SCREEN_DARK].dat,backbuffer,10,200,10,200,620,100);

  textprintf_centre(backbuffer,BIG_FONT_BORDER,320,240,_COL_31,"%s",topten_current_name);
  textprintf_centre(backbuffer,BIG_FONT_FILL,320,240,_COL_15,"%s",topten_current_name);
  blit(backbuffer,screen,10,200,10,200,620,100);
};
void enter_top_ten()
{
  global_screen_state = enter_top10_screen;
  int i;
  int pos;        // nummer des erreichten Platzes
  int txt_pos=0;
  bool have_a_score=FALSE;
  char what='#';

  load_top_ten();

  score=target_score;  // Damit auch im Spiel eventuell noch nicht raufgezaehlter Score bercksichtigt wird

  for (i=0; i<10; i++)
  {
    if (score>topten_score[9-i])
    {
      have_a_score=TRUE;
      pos=9-i;
    }
  }
  if (have_a_score)
  {
    topten_current_pos=pos;
    redraw_enter_topscreen();

    for (i=9; i>pos; i--)
    {
      sprintf(topten_name[i],"%s",topten_name[i-1]);
      topten_score[i]=topten_score[i-1];
      topten_difficulty[i]=topten_difficulty[i-1];
      topten_hit_ratio[i]=topten_hit_ratio[i-1];
      topten_wave[i]=topten_wave[i-1];
    }
    topten_score[pos]=score;
    topten_difficulty[pos]=difficulty;
    topten_hit_ratio[pos]=hit_ratio;
    topten_wave[pos]=attack_wave;
    sprintf(topten_current_name,"....................");

    redraw_enter_topname();

    while(what!=13)
    {
      if (keypressed())
      {
        what=readkey();
        if ((what!=13)&&(what!=8))
        {
          if ( ((what>=65)&&(what<=90)) || ((what>=97)&&(what<=122)) || (what==32))
          {
            if (what==32) what='.';
            topten_current_name[txt_pos]=what;
            if (txt_pos+1<20) txt_pos++;
          }
        }
        if (what==8)
        {
          topten_current_name[txt_pos]='.';
          if (txt_pos>0) txt_pos--;
          topten_current_name[txt_pos]='.';
        }
        clear_keybuf();
        redraw_enter_topname();
      }
    }
    sprintf(topten_name[pos],"%s",topten_current_name);
    save_top_ten();
  }
  show_top_ten_screen();
};

void main_menue()
{
  char command='#';
  // erstmals den Titelbildschirm zeichnen
  global_screen_state = main_menu_screen;
  redraw_title_screen();

  // erstmals das Menue zeichnen
  //set_mouse_range(135,270,135+370,240+210);
  position_mouse(320,270);
  redraw_menue_text();

  while(command!=27)
  {
    global_screen_state = main_menu_screen;
    if (keypressed()) command=readkey();
    
    if (mouse_click(1))
    {
      switch(mouse_menu_state)
      {
        case start_game: command='1'; break;
        case select_difficulty: command='2'; break;
        case show_instructions: command='3'; break;
        case show_top10: command='4'; break;
        case music_option: command='m'; break;
        case stereo_option: command='s'; break;
        case end_game: command=27; break;
      }
      while(mouse_click(1));
    }

    switch (command)
    {
      case '1':
        global_screen_state = in_game_screen;
        if ((can_do_sound)&&(MUSIC_ON)) 
        {
          ingame_music = (DUH *)fugadata[MUSIC_INGAMEMUSIC].dat;
          music_player = al_start_duh(ingame_music,mus_channels,0,mus_volume,mus_buffer,mus_freq);
          sprintf(debug_msg,"a) DUMB plyr: %x | DUMB duh: %x | ch: %i | vol: %2.4f | buf: %i | freq: %i",music_player,ingame_music,mus_channels,mus_volume,mus_buffer,mus_freq);
          debug_add(debug_msg);
        }
        game_cycle();
        if ((can_do_sound)&&(MUSIC_ON)) 
        { 
          sprintf(debug_msg,"b) DUMB plyr: %x | DUMB duh: %x | ch: %i | vol: %2.4f | buf: %i | freq: %i",music_player,ingame_music,mus_channels,mus_volume,mus_buffer,mus_freq);
          debug_add(debug_msg);
          if(music_player) al_stop_duh(music_player); music_player=NULL; ingame_music=NULL; 
          sprintf(debug_msg,"c) DUMB plyr: %x | DUMB duh: %x | ch: %i | vol: %2.4f | buf: %i | freq: %i",music_player,ingame_music,mus_channels,mus_volume,mus_buffer,mus_freq);
          debug_add(debug_msg);
        }
        enter_top_ten();
        redraw_title_screen();
        //set_mouse_range(135,270,135+370,240+210);
        position_mouse(320,270);
        redraw_menue_text();
        clear_keybuf();
        command='#';
      break;
      case '2':
        difficulty++;
        if(difficulty>HARD) difficulty=EASY;
        position_mouse(320,300+15);
        redraw_menue_text();
        poll_keyboard();
        while(key[KEY_2]) { clear_keybuf(); poll_keyboard(); };
        command='#';
      break;
      case '3':
        show_instruction_screens();
        redraw_title_screen();
        position_mouse(320,330+15);
        redraw_menue_text();
        command='#';
      break;
      case '4':
        load_top_ten();
        show_top_ten_screen();
        redraw_title_screen();
        position_mouse(320,360+15);
        redraw_menue_text();
        command='#';
      break;
      case 'l':
        show_language_select_screen();
        redraw_title_screen();
        //set_mouse_range(135,270,135+370,240+210);
        redraw_menue_text();
        command='#';
      break;
      case 'd':
        if(DEBUG_MODE) 
          DEBUG_MODE=FALSE;
        else 
          DEBUG_MODE=TRUE;
        redraw_title_screen();
        redraw_menue_text();
        command='#';
      break;
      case 'j':
        if(JOKE_MODE) 
          JOKE_MODE=FALSE;
        else 
          JOKE_MODE=TRUE;
        redraw_title_screen();
        redraw_menue_text();
        command='#';
      break;
      case 'm':
        if(MUSIC_ON) 
          MUSIC_ON=FALSE;
        else 
          MUSIC_ON=TRUE;
        position_mouse(320,390+8);
        redraw_menue_text();
        command='#';
      break;
      case 's':
        if(SWAP_STEREO) 
          SWAP_STEREO=FALSE;
        else 
          SWAP_STEREO=TRUE;
        position_mouse(320,402+8);
        redraw_menue_text();
        command='#';
      break;
    }
    check_and_update_menu_state();
  }
};

/*language_select_screen=0,
  main_menu_screen,
  manual_screen1,
  manual_screen2,
  enter_top10_screen,
  top10_screen,
  in_game_screen*/

void SwitchInCallback()
{
  switch(global_screen_state)
  {
    case language_select_screen:
      redraw_language_screen();
    break;
    case main_menu_screen:
      redraw_title_screen();
      redraw_menue_text();
    break;
    case manual_screen1: 
      redraw_instructions_page1();
    break;
    case manual_screen2: 
      redraw_instructions_page2();
    break;
    case enter_top10_screen:
      redraw_enter_topscreen();
      redraw_enter_topname();
    break;
    case top10_screen:
      redraw_top_ten_screen();
    break;
    case in_game_screen:
      if ((can_do_sound)&&(MUSIC_ON)&&(music_player))
        al_resume_duh(music_player);
      first_time_draw=TRUE;
      update_screen();
    break;
  }
  game_minimized = FALSE;
}

void SwitchOutCallback()
{
  if ((can_do_sound)&&(MUSIC_ON)&&(global_screen_state==in_game_screen)&&(music_player))
  {  
     al_pause_duh(music_player);
     al_poll_duh(music_player);
  }
  game_minimized = TRUE;
}

int main()
{
  DO_DEBUG=TRUE;

  fuga_start();

  if (runlevel>=5){
    TINY_FONT = (FONT *)fugadata[GFX_TINY_FONT].dat;
    TINY_FONT_FILL = (FONT *)fugadata[GFX_TINY_FONT_FILL].dat;
    TINY_FONT_BORDER = (FONT *)fugadata[GFX_TINY_FONT_BORDER].dat;
    SMALL_FONT = (FONT *)fugadata[GFX_SMALL_FONT].dat;
    SMALL_FONT_FILL = (FONT *)fugadata[GFX_SMALL_FONT_FILL].dat;
    SMALL_FONT_BORDER = (FONT *)fugadata[GFX_SMALL_FONT_BORDER].dat;
    BIG_FONT   = (FONT *)fugadata[GFX_BIG_FONT].dat;
    BIG_FONT_FILL = (FONT *)fugadata[GFX_BIG_FONT_FILL].dat;
    BIG_FONT_BORDER = (FONT *)fugadata[GFX_BIG_FONT_BORDER].dat;
    difficulty = EASY;

    set_display_switch_mode(SWITCH_PAUSE);
    set_display_switch_callback(SWITCH_IN,&SwitchInCallback);
    set_display_switch_callback(SWITCH_OUT,&SwitchOutCallback);

    set_mouse_sprite((BITMAP *)fugadata[GFX_CURSOR].dat);
    set_mouse_sprite_focus(20,20);

    // set global color constants (these were introduced to ease up porting from indexed 8bpp mode to 32bpp)
    _COL_15 = makecol(255,255,255);
    _COL_16 = makecol(239,239,239);
    _COL_22 = makecol(155,155,155);
    _COL_25 = makecol(115,115,115);
    _COL_26 = makecol(128,128,128);
    _COL_31 = makecol(35,35,35);
    _COL_32 = makecol(255,47,47);
    _COL_33 = makecol(239,35,35);
    _COL_64 = makecol(255,255,219);
    _COL_71 = makecol(255,247,0);
    _COL_79 = makecol(67,67,0);
    _COL_86 = makecol(119,183,0);
    _COL_96 = makecol(0,255,0);
    _COL_122 = makecol(0,183,183);
    _COL_135 = makecol(0,0,135);

    show_language_select_screen();
    main_menue();

    set_mouse_sprite(NULL); // fixes crash on remove_mouse(); :)
  }

  fuga_shut();

  return 0;
}END_OF_MAIN()
