// FUGA Fliegende Untertassen greifen an
// von Dennis Busch

// "c_shots.cpp"
// Enthaelt die Klasse fuer Projektile

#include <math.h>

enum shot_owner
{
  PLAYER, ENEMY, WORLD
};

enum shot_type
{
  CANNONBALL, BOMB, MISSILE, INFILTRATOR,
  SMALL_JUNK1, SMALL_JUNK2, SMALL_JUNK3, SMALL_JUNK4,
  MEDIUM_JUNK1, MEDIUM_JUNK2, MEDIUM_JUNK3, MEDIUM_JUNK4,
  BIG_JUNK1, BIG_JUNK2, BIG_JUNK3, BIG_JUNK4,
  BUILDING_JUNK1, BUILDING_JUNK2, BUILDING_JUNK3, BUILDING_JUNK4,
  GUN_JUNK1, GUN_JUNK2, GUN_JUNK3, GUN_JUNK4,
  MUD_BALL
};

class c_shot
{
  private:
  float px,py;  // vorherige Position
  bool p_in_use; // TRUE wenn vorher benutzt
  int p_frame;

  float vx,vy;  // Flugrichtung als Vektor
  float speed;  // Geschwindigkeit
  int owner;    // Der Besitzer des Geschosses von enum shot_owner

  public:
  int number;   // Nummer des Geschosses
  float x,y;    // Position des Geschosses
  c_anim anim;  // Die Animation des Geschosses
  int type;     // Der Typ des Geschosses von enum_shot_type
  bool in_use;  // Wenn das Geschoss gerade aktiv ist

  int spawn_new(int a, int b, float angle, float sp, int own, int typ,int num);
  void change_angle(float angle);
  void move_coll();
  void draw(BITMAP *where);
  void restore_background(BITMAP *from,BITMAP *to);
};

// c_shot::spawn_new
// An der durch a,b gegebenen Position wird ein neuer Schuss
// mit der durch den Winkel(in Rad) angegebenen Flugrichtung erzeugt
int c_shot::spawn_new(int a, int b, float angle, float sp, int own, int typ, int num)
{
  if (num==-1) return -1;
  number=num;

  vx = cos(angle);
  vy = sin(angle);

  x = a;
  y = b;

  speed = sp;

  owner = own;
  type = typ;

  if (own==PLAYER)
  {
    x = x+vx*37;
    y = y+vy*37;
    speed = speed*fix_sp;
    start_new_anim(get_free_anim(),int(x),int(y),GFX_CANNON_FIRE000,12,c_anim_once_fwd,1);
  }

  if ((own==ENEMY)||(own==WORLD))
  {
    speed = speed*fix_sp;
  }

  switch(type)
  {
    case CANNONBALL:
      anim.set_anim(GFX_PLY_SHOT000,8,c_anim_fwd,5,-1);
    break;
    case BOMB:
      anim.set_anim(GFX_BOMB000,9,c_anim_fwd,5,-1);
    break;
    /*case MISSILE:
      anim.set_anim(GFX_MISSILE000,5,c_anim_fwd,2,-1);
    break;*/
    case INFILTRATOR:
      anim.set_anim(GFX_INFILTRATOR000,10,c_anim_pingpong,5,-1);
    break;
    case SMALL_JUNK1:
      anim.set_anim(GFX_SMALL_TRASHA000,4,c_anim_fwd,5,-1);
    break;
    case SMALL_JUNK2:
      anim.set_anim(GFX_SMALL_TRASHB000,4,c_anim_fwd,5,-1);
    break;
    case SMALL_JUNK3:
      anim.set_anim(GFX_SMALL_TRASHC000,4,c_anim_fwd,5,-1);
    break;
    case SMALL_JUNK4:
      anim.set_anim(GFX_SMALL_TRASHD000,4,c_anim_fwd,5,-1);
    break;
    case MEDIUM_JUNK1:
      anim.set_anim(GFX_MEDIUM_TRASHA000,4,c_anim_fwd,5,-1);
    break;
    case MEDIUM_JUNK2:
      anim.set_anim(GFX_MEDIUM_TRASHB000,4,c_anim_fwd,5,-1);
    break;
    case MEDIUM_JUNK3:
      anim.set_anim(GFX_MEDIUM_TRASHC000,4,c_anim_fwd,5,-1);
    break;
    case MEDIUM_JUNK4:
      anim.set_anim(GFX_MEDIUM_TRASHD000,4,c_anim_fwd,5,-1);
    break;
    case BIG_JUNK1:
      anim.set_anim(GFX_BIG_TRASHA000,4,c_anim_fwd,5,-1);
    break;
    case BIG_JUNK2:
      anim.set_anim(GFX_BIG_TRASHB000,4,c_anim_fwd,5,-1);
    break;
    case BIG_JUNK3:
      anim.set_anim(GFX_BIG_TRASHC000,4,c_anim_fwd,5,-1);
    break;
    case BIG_JUNK4:
      anim.set_anim(GFX_BIG_TRASHD000,4,c_anim_fwd,5,-1);
    break;
    case BUILDING_JUNK1:
      anim.set_anim(GFX_BUILDING_TRASHA000,4,c_anim_fwd,5,-1);
    break;
    case BUILDING_JUNK2:
      anim.set_anim(GFX_BUILDING_TRASHB000,4,c_anim_fwd,5,-1);
    break;
    case BUILDING_JUNK3:
      anim.set_anim(GFX_BUILDING_TRASHC000,4,c_anim_fwd,5,-1);
    break;
    case BUILDING_JUNK4:
      anim.set_anim(GFX_BUILDING_TRASHD000,4,c_anim_fwd,5,-1);
    break;
    case GUN_JUNK1:
      anim.set_anim(GFX_GUN_TRASHA000,4,c_anim_fwd,5,-1);
    break;
    case GUN_JUNK2:
      anim.set_anim(GFX_GUN_TRASHB000,4,c_anim_fwd,5,-1);
    break;
    case GUN_JUNK3:
      anim.set_anim(GFX_GUN_TRASHC000,4,c_anim_fwd,5,-1);
    break;
    case GUN_JUNK4:
      anim.set_anim(GFX_GUN_TRASHD000,4,c_anim_fwd,5,-1);
    break;
    case MUD_BALL:
      anim.set_anim(GFX_MUD_BALL000,4,c_anim_fwd,5,-1);
    break;
  }

  in_use = TRUE;
  return 0;
};

// c_shot::change_angle
// Passt die Flugrichtung an
void c_shot::change_angle(float angle)
{
  vx=cos(angle);
  vy=sin(angle);
};

// c_shot::move_coll
// Bewegt den Schuss auf dem Spielfeld weiter
void c_shot::move_coll()
{
  if (in_use)
  {
    int j;
    int k;

    if (owner==WORLD) vy=vy+grav_constant*fix_sp; // Bei Trash wird y-Vektor groesser
    if (type==BOMB) vy=vy+grav_constant*fix_sp; // Bei Bomben ebenfalls
    if ((owner==PLAYER)&&(JOKE_MODE)) vy=vy+grav_constant*fix_sp; // lustiger Witzmodus fr Spielerschsse

    if (vy>=max_fallspeed) vy=max_fallspeed; // Maximale Fallgeschwindigkeit beachten

      x = x+vx*speed;
      y = y+vy*speed;

      //Kollisionschecks nur wenn Objekt kein Trash ist (also der Welt gehoert)
      if (owner!=WORLD)
      switch (type)
      {

        case CANNONBALL:
          // mit allen Gegnern
          for(j=0; j<max_enemies; j++)
            perform_collision(SHOT_TO_ENEMY,number,j);
          // mit allen anderen Geschossen
          for(j=0; j<max_shots; j++)
          {
            perform_collision(SHOT_TO_SHOT,number,j);
            if(JOKE_MODE) perform_collision(SHOT_TO_BUILDING,number,0);
          }
        break;
        case BOMB:
          // mit Gebaeuden
          perform_collision(SHOT_TO_BUILDING,number,0);
        break;
        case MISSILE:
          // mit Kanonen
          perform_collision(SHOT_TO_CANNON,number,0);
        break;
        case INFILTRATOR:
          // mit Gebaeuden
          perform_collision(SHOT_TO_TUNNEL,number,0);
        break;
      }

    k = anim.advance();
    BITMAP *what=NULL;

    what = (BITMAP *)fugadata[k].dat;

    if (in_use)
    {
      if (x+what->w/2<=0) in_use=FALSE;
      if (x-what->w/2>=639) in_use=FALSE;
      if (y+what->h/2<=0) in_use=FALSE;
      if (y-what->h/2>=479) in_use=FALSE;
      if (!in_use) push_shot(number);
    }

    // Bei Schrottteilen soll es ordentlich qualmen
    if ((type>=SMALL_JUNK1)&&(type<=MUD_BALL)&&(in_use))
    {
      if (dice(4)==0)
        start_new_anim(get_free_anim(),int(x),int(y),GFX_SMOKE000,8,c_anim_once_fwd,2);
      if (dice(10)==0)
        start_new_anim(get_free_anim(),int(x),int(y),GFX_FLAMELET000,8,c_anim_once_fwd,5);
    }

  }
};

// c_shot::draw
// Malt das Geschoss auf dem angegebenen Bitmap
void c_shot::draw(BITMAP *where)
{
  BITMAP *what=NULL;

  if (in_use)
  {
    p_in_use=TRUE;
    px=x;
    py=y;

    p_frame = anim.current_frame;

    what = (BITMAP *)fugadata[anim.current_frame].dat;

    draw_sprite(where,what,int(x)-int(what->w/2),int(y)-int(what->h/2));
    if (DEBUG_MODE) textprintf(where,font,int(x),int(y),_COL_15,"%i",number);
  }

};

void c_shot::restore_background(BITMAP *from, BITMAP *to)
{
  BITMAP *what=NULL;
  if (p_in_use)
  {
    what = (BITMAP *)fugadata[p_frame].dat;
    blit(from,to,int(px-what->w/2),int(py-what->h/2),
                 int(px-what->w/2),int(py-what->h/2),
                 what->w,what->h);
    p_in_use=FALSE;
  }
};
