// FUGA Fliegende Untertassen greifen an
// von Dennis Busch

// "c_anim.cpp"
// Enthaelt die Klasse zum steuern der Animationen

#include <string.h>
#include "allegro.h"

enum anim_type
{
  c_anim_fwd, c_anim_rew, c_anim_pingpong, c_anim_once_fwd
};

class c_anim
{
  private:
    int px, py;
    bool p_in_use;      // TRUE wenn vorher benutzt
    int p_frame;

    int frame_time;       // Anzahl der Spielzyklen, bevor naechstes Bild gesetzt wird
    int cycle_count;      // Zaehlt die Zyklen runter bis 0 und wird dann auf den Wert von frame_time gesetzt

    int start_frame;      // erstes Bild der Animation
    int direction;        // 0 vorwaerts; 1=rueckwaerts

  public:
    int number;           // Nummer der Animation
    int type;             // 0=vorwaerts; 1=rueckwaerts; 2=ping pong
    int frames;           // Anzahl Einzelbilder der Animation
    int current_frame;    // aktuelles Bild
    bool in_use;

    int set_frame(int a) { if (a>frames) current_frame=start_frame+frames; else current_frame=start_frame+a; return current_frame; };
    int advance();

    void set_anim(int start, int numframes, int typ, int time, int num);

    void draw(BITMAP *where, int x, int y);
    void restore_background(BITMAP *from,BITMAP *to);
};

// Je nach Animationstyp wird entsprechend das naechste Bild gesetzt.
int c_anim::advance()
{
  if ((cycle_count>0)&&(in_use))
  {
    cycle_count--;
    return current_frame;
  }

  if (cycle_count==0)
  {
    if ((type == c_anim_fwd)||(type == c_anim_once_fwd))
    {
      current_frame++;
      if (current_frame==start_frame+frames)
      {
        current_frame=start_frame;
        if (type==c_anim_once_fwd)
        { 
          in_use=FALSE;
          push_anim(number);
          number=-1;
        }
      }
    }
    if (type == c_anim_rew)
    {
      if (current_frame==start_frame) current_frame=start_frame+frames;
      if (current_frame-start_frame>0) current_frame--;
    }
    if (type == c_anim_pingpong)
    {
      switch (direction)
      {

        case 0: {
                  if (current_frame+1<start_frame+frames)
                  {
                    current_frame++;
                    break;
                  } else
                  {
                    direction=1;
                  }
                }
        case 1: {
                  if (current_frame-start_frame>0)
                  {
                    current_frame--;
                    break;
                  } else
                  {
                    current_frame=start_frame+1;
                    direction=0;
                  }
                }
      }
    }

    cycle_count=frame_time;
  }

  return current_frame;
};

// Initialisiert die Animation
// fr = Anzahl Frames
// w,h = Breite, Hoehe
// wh  = Bitmap mit den Bildern
void c_anim::set_anim(int start, int numframes, int typ, int time, int num)
{
  start_frame=start;
  current_frame=start_frame;
  frames=numframes;
  type=typ;
  direction=0;
  number = num;

  frame_time = time;

  frame_time = frame_time/fix_sp;

  cycle_count = 0;

  if (type==c_anim_once_fwd) current_frame--;

  in_use=TRUE;
};

void c_anim::draw(BITMAP *where, int x, int y)
{
  if (in_use)
  {
    p_in_use=TRUE;
    px=x; py=y;

    p_frame=current_frame;

    BITMAP *what=NULL;
    what = (BITMAP *)fugadata[current_frame].dat;
    draw_sprite(where,what,int(x-what->w/2),int(y-what->h/2));
    if (DEBUG_MODE) textprintf(where,font,x,y,_COL_15,"%i",number);
  }
};

void c_anim::restore_background(BITMAP *from, BITMAP *to)
{
  if (p_in_use)
  {
    BITMAP *what=NULL;
    what = (BITMAP *)fugadata[p_frame].dat;

    blit(from,to,int(px-what->w/2),int(py-what->h/2),
                 int(px-what->w/2),int(py-what->h/2),
                 what->w, what->h);
    p_in_use=FALSE;
  }
};
