enum { LANG_GERMAN, LANG_ENGLISH };

// Platzhalter fuer alle Messages:
// -------------------------------
enum MSG_NUMBERS
{
  msg_continue=0,     // 0
  msg_init_startup,   // 1
  msg_ok_startup,     // 2
  
  msg_init_allegro,   // 3
  msg_fail_allegro,   // 4
  msg_ok_allegro,     // 5

  msg_init_mouse,     // 6
  msg_fail_mouse,     // 7
  msg_ok_mouse,       // ...

  msg_init_timer,
  msg_fail_timer,
  msg_ok_timer,       // 10

  msg_init_keyboard,
  msg_fail_keyboard,
  msg_ok_keyboard,

  msg_init_gfx,
  msg_fail_gfx,       // 15
  msg_ok_gfx,

  msg_init_sfx,
  msg_fail_sfx,
  msg_ok_sfx,

  msg_debug_created,  // 20
  msg_debug_finished,

  msg_load_data,
  msg_fail_load_data,
  msg_ok_load_data,
  msg_unload_data,    // 25
  msg_ok_unload_data,
  msg_not_enough_memory,
  msg_create_backbuffer,
  msg_ok_backbuffer,
  msg_create_restorearea, // 30
  msg_ok_restorearea,
  msg_clean_up_mem,
  msg_ok_clean_up_mem     // 33
};
const int _sys_msg_count=msg_ok_clean_up_mem+1;

// Alle moeglichen Nachrichten (Sprache: Deutsch)
// ---------------------------
char *ger_messages[] =
{
  "...weiter mit Leertaste...",

  "Startup wird eingeleitet...",
  "Startup erfolgreich.",

  "Allegro wird initialisiert...",
  "Fehler: Allegro konnte nicht gestartet werden!",
  "Allegro wurde initialisiert.",

  "Maus wird initialisiert...",
  "Fehler: Kein Maustreiber geladen!",
  "Maus wurde initialisiert.",

  "Timer wird initialisiert...",
  "Fehler: Timer konnte nicht gestartet werden!",
  "Timer wurde initialisiert.",

  "Tastatur-Handler wird initialisiert...",
  "Fehler: Tastatur-Handler konnte nicht initialisiert werden!",
  "Tastatur-Handler wurde initialisiert.",

  "Umschalten auf Grafikmodus...",
  "Fehler: Grafikmodus konnte nicht gesetzt werden!",
  "Grafikmodus bereit.",

  "Soundkarte wird initialisiert...",
  "Fehler: Keine geeignete Soundkarte gefunden!",
  "Soundkarte bereit.",

  "DEBUG.TXT wurde erfolgreich erstellt.",
  "DEBUG SESSION beendet.",

  "Datenfiles werden geladen...",
  "Fehler: Ein Datenfile konnte nicht geladen werden!",
  "Datenfiles bereit.",
  "Datenfiles werden entladen...",
  "Datenfiles entladen.",
  "Fehler: Nicht genug Speicher!",
  "Hintergrundpuffer wird initialisiert...",
  "Hintergrundpuffer steht.",
  "Wiederherstellbereich wird initialisiert...",
  "Wiederherstellbereich steht.",
  "Speicher wird freigeraeumt...",
  "Speicher ist frei."
};

// Alle moeglichen Nachrichten (Sprache: English)
// ---------------------------
char *eng_messages[] =
{
  "...proceed with spacebar...",

  "Initialising startup...",
  "Startup successful.",

  "Initialising Allegro...",
  "Error: Allegro couldn't be started!",
  "Allegro initialised.",

  "Initialising mouse...",
  "Error: No mousedriver loaded!",
  "Mouse initialised.",

  "Initialising timer...",
  "Error: Timer couldn't be started!",
  "Timer initialised.",

  "Initialising keyboard-handler...",
  "Error: Keyboard-handler failed!",
  "Keyboard-handler initialised.",

  "Switching to graphicsmode...",
  "Error: Graphicsmode couldn't be set!",
  "Graphicsmode ready.",

  "Initializing soundcard...",
  "Error: No compatible soundcard found!",
  "Soundcard ready.",

  "DEBUG.TXT successfully created.",
  "DEBUG SESSION closed.",

  "Loading datafiles...",
  "Error: One of the datafiles cannot be loaded!",
  "Datafiles ready.",
  "Unloading datafiles...",
  "Datafiles unloaded.",
  "Error: Not enough memory!",
  "Creating backbuffer...",
  "Backbuffer ready.",
  "Creating restore area...",
  "Restore area ready.",
  "Freeing up memory...",
  "Memory is free."
};
