// FUGA Fliegende Untertassen greifen an
// von Dennis Busch

// "c_enemy.cpp"
// Enthaelt die Steuerungsklassen fuer Gegner

enum enemy_type
{
  SMALL_UFO, MEDIUM_UFO, BIG_UFO
};

enum enemy_state
{
  ALIVE, EXPLODING, DEAD
};

float available_angles[9];

class c_enemy
{
  private:
  float px, py; // vorherige Position
  bool p_in_use; // TRUE wenn vorher benutzt
  int p_frame;

  float vx,vy;  // Flugrichtung als Vektor

  int new_angle_delay; // Immer wenn 0, dann neuen Flugwinkel erzeugen

  int speed;    // Geschwindigkeit
  int type;     // Gegnertyp von enum enemy_type
  int energy;   // verbleibende Energie
  int ammo;     // verbleibende Munition
  bool ammo_dropped[5]; // fuer jedes Gebauede 0-3 TRUE, wenn schon eine Bombe oder Infiltrator hierauf geworfen wurde
                        // 4 ist bei grossen Ufos fuer die Missile

  public:
  int number;   // Nummer des Gegners
  float x,y;    // Position
  c_anim anim;  // Die Animation des Ufos
  bool in_use;  // True wenn dieser Gegner gerade benutzt wird
  int state;    // Status des Gegners von enum enemy_state

  int spawn_new(int a, int b, float angle, int typ, int num);
  void move();
  int drain_energy_and_die();
  void draw(BITMAP *where);
  void restore_background(BITMAP *from,BITMAP *to);
};


int c_enemy::spawn_new(int a, int b, float angle, int typ, int num)
{
  int i;
  int anim_dir;
  if (typ==-1) return -1;
  number=num;

  x=a;
  y=b;

  vx = cos(angle*to_rad);
  vy = sin(angle*to_rad);

  if (vx>=0) anim_dir=c_anim_fwd;
  if (vx<0) anim_dir=c_anim_rew;

  type=typ;
  switch(type)
  {
    case SMALL_UFO:
      energy=1;
      speed=3;//3
      ammo=1;//1
      anim.set_anim(GFX_SMALL_UFO_FLY000,12,anim_dir,0,-1);
      smalls_on_screen++;
    break;
    case MEDIUM_UFO:
      energy=2;
      speed=2;//2
      ammo=3;//3
      anim.set_anim(GFX_MEDIUM_UFO_FLY000,11,c_anim_pingpong,2,-1);
      mediums_on_screen++;
    break;
    case BIG_UFO:
      energy=3;
      speed=1;//1
      ammo=5;//5
      anim.set_anim(GFX_BIG_UFO_FLY000,8,anim_dir,4,-1);
      bigs_on_screen++;
    break;
  }

  speed=speed*fix_sp;

  for (i=0; i<4; i++) ammo_dropped[i]=FALSE;

  new_angle_delay=enemy_move_time;
  state=ALIVE;
  in_use=TRUE;
  return 0;
};

void c_enemy::move()
{
  int i;
  float next_angle;

  if (in_use)
  {
    int k;
    new_angle_delay--;
    if (new_angle_delay==0)
    {
      // Flugrichtung an zufaelligen Winkel anpassen
      switch(dice(2))
      {
        case 0:
          for (i=0; i<9; i++) available_angles[i]=acos(vx)+i*0.02182;
        break;
        case 1:
          for (i=0; i<9; i++) available_angles[i]=acos(vx)-i*0.02182;
        break;
      }

      next_angle=available_angles[dice(9)];

      if ((y<=enemy_min_y)||(y>=enemy_max_y))
      {
        if (vx>0) next_angle=5*to_rad;
        if (vx<=0) next_angle=185*to_rad;
      }

      vx = cos(next_angle);
      vy = sin(next_angle);

      new_angle_delay=enemy_move_time;
    }

    x = x+speed*vx;
    y = y+speed*vy;

    if (y<=enemy_min_y) new_angle_delay=1;
    if (y>=enemy_max_y) new_angle_delay=1;

    // Verhaltensregeln fuer Bomben und Infiltrator Abwurf
    for (i=0; i<4; i++)
    {
      if (ammo>0)
      {
        if ((x>building_x[i]+19)&&(x<=building_x[i]+21))
        {
          if (ammo_dropped[i]==FALSE)
          {
            if (building_current_height[i]>0)
              start_new_shot(int(x),int(y),90*to_rad,bombstart_speed,ENEMY,BOMB);
            if ((building_current_height[i]==0)&&(i==1)&&(tunnel_one_length<tunnel_length))
              start_new_shot(int(x),int(y),90*to_rad,infiltrator_speed,ENEMY,INFILTRATOR);
            if ((building_current_height[i]==0)&&(i==2)&&(tunnel_two_length<tunnel_length))
              start_new_shot(int(x),int(y),90*to_rad,infiltrator_speed,ENEMY,INFILTRATOR);
            ammo--;
            ammo_dropped[i]=TRUE;
          }
        }
      }
    }
    // Hier noch Verhaltensregeln fuer Raketenabwurf einfuegen


    k = anim.advance();
    BITMAP *what=NULL;

    what = (BITMAP *)fugadata[k].dat;

    if(in_use)
    {
      if (x+what->w/2<=-10) in_use=FALSE;
      if (x-what->w/2>=649) in_use=FALSE;
      if (y+what->h/2<=-10) in_use=FALSE;
      if (y-what->h/2>=489) in_use=FALSE;

      if (in_use==FALSE) switch(type)
      {
        case SMALL_UFO:
          smalls_on_screen--;
        break;
        case MEDIUM_UFO:
          mediums_on_screen--;
        break;
        case BIG_UFO:
          bigs_on_screen--;
        break;
      }
      if (in_use==FALSE) push_enemy(number);
    }
  }
};

int c_enemy::drain_energy_and_die()
{
  int i;

  energy--;

  if (energy<=0)
  {
    switch(type)
    {
      case SMALL_UFO:
        gain_score(10*difficulty);
        smalls_on_screen--;
        smalls_to_kill--;
        for (i=0; i<4; i++)
        {
          if (vx>=0)
            start_new_shot(int(x),int(y),(300+i*10)*to_rad,speed*2/fix_sp,WORLD,SMALL_JUNK1+i);
          if (vx<0)
            start_new_shot(int(x),int(y),(240-i*10)*to_rad,speed*2/fix_sp,WORLD,SMALL_JUNK1+i);
        }
        start_a_sound(SOUND_SMALL_EXPLODE,255,128,1000,FALSE);
      break;
      case MEDIUM_UFO:
        gain_score(30*difficulty);
        mediums_on_screen--;
        mediums_to_kill--;
        for (i=0; i<4; i++)
        {
          if (vx>=0)
            start_new_shot(int(x),int(y),(300+i*10)*to_rad,speed*2/fix_sp,WORLD,MEDIUM_JUNK1+i);
          if (vx<0)
            start_new_shot(int(x),int(y),(240-i*10)*to_rad,speed*2/fix_sp,WORLD,MEDIUM_JUNK1+i);
        }
        start_a_sound(SOUND_MEDIUM_EXPLODE,255,128,1000,FALSE);
      break;
      case BIG_UFO:
        gain_score(50*difficulty);
        bigs_on_screen--;
        bigs_to_kill--;
        for (i=0; i<4; i++)
        {
          if (vx>=0)
            start_new_shot(int(x),int(y),(300+i*10)*to_rad,speed*2/fix_sp,WORLD,BIG_JUNK1+i);
          if (vx<0)
            start_new_shot(int(x),int(y),(240-i*10)*to_rad,speed*2/fix_sp,WORLD,BIG_JUNK1+i);
        }
        start_a_sound(SOUND_BIG_EXPLODE,255,128,1000,FALSE);
      break;
    }
    start_new_anim(get_free_anim(),int(x),int(y),GFX_BIG_EXPLOSION000,16,c_anim_once_fwd,4-speed/fix_sp);
    in_use=FALSE;
    push_enemy(number);
    return type;
  };

  return -1;
};

void c_enemy::draw(BITMAP *where)
{
  BITMAP *what=NULL;
  if (in_use)
  {
    p_in_use=TRUE;
    px=x;
    py=y;

    p_frame = anim.current_frame;

    what = (BITMAP *)fugadata[anim.current_frame].dat;

    draw_sprite(where,what,int(x)-int(what->w/2),int(y)-int(what->h/2));
    if (DEBUG_MODE) textprintf(where,font,int(x),int(y),_COL_15,"%i",number);
    //for(int i=0; i<energy; i++) vline(where,int(x)-int(what->w/2)+i*3,int(y)-int(what->h/2),int(y)-int(what->h/2)+4,15);
  }
};

void c_enemy::restore_background(BITMAP *from, BITMAP *to)
{
  BITMAP *what=NULL;
  if (p_in_use)
  {
    what = (BITMAP *)fugadata[p_frame].dat;
    blit(from,to,int(px-what->w/2),int(py-what->h/2),
                 int(px-what->w/2),int(py-what->h/2),
                 what->w,what->h);
    p_in_use=FALSE;
  }
};
