#include <allegro5/allegro.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_image.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>
#include <time.h>

/* 
 * COLLISION IN SPACE
 * 
 * Autor: Guilherme Sernajoto
 * Data: 28/06/2015
 * 
 * My Best Score: 180
 * 
 * Compilar: gcc code.c -Wall -lallegro -lallegro_primitives -lallegro_image -lallegro_font -lallegro_ttf -lallegro_audio -lallegro_acodec
 */

typedef struct {
	int x;
	int y;
} nave_t;

typedef struct {
	int x;
	int y;
} fundo_t;

typedef struct {
	int x;
	int y;
} ast_t;

const int LARGURA_TELA = 800;
const int ALTURA_TELA = 600;
 
ALLEGRO_DISPLAY *janela = NULL;
ALLEGRO_EVENT_QUEUE *fila_eventos = NULL;
ALLEGRO_AUDIO_STREAM *musicaf = NULL;
ALLEGRO_BITMAP *fundo1 = NULL;
ALLEGRO_BITMAP *fundo2 = NULL;
ALLEGRO_BITMAP *nave = NULL;
ALLEGRO_BITMAP *amarelo60 = NULL;
ALLEGRO_BITMAP *marrom80 = NULL;
ALLEGRO_BITMAP *vermelho100 = NULL;
ALLEGRO_BITMAP *azul75 = NULL;
ALLEGRO_BITMAP *roxo90 = NULL;
ALLEGRO_BITMAP *verde130 = NULL;
ALLEGRO_BITMAP *amarelo602 = NULL;
ALLEGRO_BITMAP *marrom802 = NULL;
ALLEGRO_BITMAP *vermelho1002 = NULL;
ALLEGRO_BITMAP *azul752 = NULL;
ALLEGRO_BITMAP *roxo902 = NULL;
ALLEGRO_BITMAP *verde1302 = NULL;
ALLEGRO_FONT *fonte = NULL;

/* Função que faz a verificação de arquivos e addon's */
bool inicializar(){
	if(!al_init()){
		fprintf(stderr, "Falha ao inicializar a Allegro.\n");
		return false;
	}
	if(!al_install_audio()){
		fprintf(stderr, "Falha ao inicializar áudio.\n");
		return false;
	}
	if(!al_init_acodec_addon()){
		fprintf(stderr, "Falha ao inicializar codecs de áudio.\n");
		return false;
	}
	if(!al_reserve_samples(1)){
		fprintf(stderr, "Falha ao alocar canais de áudio.\n");
		return false;
	}
	al_init_font_addon();
	if(!al_init_ttf_addon()){
		fprintf(stderr, "Falha ao inicializar add-on allegro_ttf.\n");
		return false;
	}
	if(!al_init_image_addon()){
		fprintf(stderr, "Falha ao inicializar add-on allegro_image.\n");
		return false;
	}
	if(!al_install_keyboard()){
		fprintf(stderr, "Falha ao inicializar o teclado.\n");
		return false;
	}
	janela = al_create_display(LARGURA_TELA, ALTURA_TELA);
	al_set_window_title(janela, "Collision in Space");
	if(!janela){
		fprintf(stderr, "Falha ao criar janela.\n");
		return false;
	}
	fonte = al_load_font("mypager.ttf", 30, 0);
	if (!fonte){
		fprintf(stderr, "Falha ao carregar \"fonte mypager.ttf\".\n");
		al_destroy_display(janela);
		return false;
	}
	fila_eventos = al_create_event_queue();
	if(!fila_eventos){
		fprintf(stderr, "Falha ao criar fila de eventos.\n");
		al_destroy_display(janela);
		return false;
	}
	fundo1 = al_load_bitmap("fundo1.png");
	fundo2 = al_load_bitmap("fundo2.png");
	nave = al_load_bitmap("nave.png");
	amarelo60 = al_load_bitmap("amarelo60.png");
	azul75 = al_load_bitmap("azul75.png");
	roxo90 = al_load_bitmap("roxo90.png");
	marrom80 = al_load_bitmap("marrom80.png");
	vermelho100 = al_load_bitmap("vermelho100.png");
	verde130 = al_load_bitmap("verde130.png");
	amarelo602 = al_load_bitmap("amarelo602.png");
	azul752 = al_load_bitmap("azul752.png");
	roxo902 = al_load_bitmap("roxo902.png");
	marrom802 = al_load_bitmap("marrom802.png");
	vermelho1002 = al_load_bitmap("vermelho1002.png");
	verde1302 = al_load_bitmap("verde1302.png");
	if(!fundo1){
		fprintf(stderr, "Falha ao carregar imagem de fundo.\n");
		al_destroy_display(janela);
		al_destroy_event_queue(fila_eventos);
		return false;
	}
	musicaf = al_load_audio_stream("espaco.ogg", 4, 1024);
	if(!musicaf){
		fprintf(stderr, "Falha ao carregar audio.\n");
		al_destroy_event_queue(fila_eventos);
		al_destroy_display(janela);
		return false;
	}
	al_register_event_source(fila_eventos, al_get_keyboard_event_source());
	al_register_event_source(fila_eventos, al_get_display_event_source(janela));
	return true;
}

/* Função que define as cordenadas Y dos asteroides, parametros 6 ponteiros do tipo ast_t */
void posi_asteroides(ast_t *a60, ast_t *a130, ast_t *a80, ast_t *a75, ast_t *a100, ast_t *a90){
	srand((unsigned)time(NULL));
	a60->y = rand() % 540;
	a130->y = rand() % 470;
	a80->y = rand() % 520;
	a75->y = rand() % 525;
	a100->y = rand() % 500;
	a90->y = rand() % 510;
}

/*Função que verifica se existe ou não colisão entre os asteroides e a nave. 
 * Parametros nave_t, ast_t e um int com o tamanho em pixels do asteroide */
int colisao(nave_t nv, ast_t ast, int ta){
	if(((nv.x >= ast.x && nv.x <= ast.x + ta-10) || (nv.x + 50 >= ast.x && nv.x + 50 <= ast.x + ta-10)) && 
		((nv.y >= ast.y && nv.y <= ast.y + ta-10) || (nv.y + 50 >= ast.y && nv.y + 50 <= ast.y + ta-10)))
	return 1;
	return 0;
} 

bool inicializar();

int main(void) {
	bool sair = false;
	int tecla = 0, reset = 0, velo = 3, velon = 4, bs = 0, score = 0, bscore = 0;
	fundo_t bg1, bg2;
	nave_t nv;
	ast_t a60, a80, a100, a75, a90, a130, a602, a802, a1002, a752, a902, a1302;
	
	a60.x = 810; a130.x = 970; a80.x = 1200; a75.x = 1380; a100.x = 1555; a90.x = 1755;
	a602.x = 1945; a1302.x = 2105; a802.x = 2335; a752.x = 2515; a1002.x = 2690; a902.x = 2890;
	posi_asteroides(&a60, &a130, &a80, &a75, &a100, &a90); 
	posi_asteroides(&a602, &a1302, &a802, &a752, &a1002, &a902); 
	nv.x = 1;
	nv.y = 270;
	bg1.x = 0; bg2.x = 980;
	bg1.y = 0; bg2.y = 0;
	
	if(!inicializar()) return -1;
	
	al_draw_bitmap(fundo1, bg1.x, bg1.y, 0);
	al_draw_bitmap(fundo2, bg2.x, bg2.y, 0);
	al_draw_bitmap(nave, nv.x, nv.y, 0);
	al_draw_bitmap(roxo90, a90.x, a90.y, 0);
	al_draw_bitmap(amarelo60, a60.x, a60.y, 0);
	al_draw_bitmap(marrom80, a80.x, a80.y, 0);
	al_draw_bitmap(azul75, a75.x, a75.y, 0);
	al_draw_bitmap(verde130, a130.x, a130.y, 0);
	al_draw_bitmap(vermelho100, a100.x, a100.y, 0);
	al_draw_bitmap(roxo902, a902.x, a902.y, 0);
	al_draw_bitmap(amarelo602, a602.x, a602.y, 0);
	al_draw_bitmap(marrom802, a802.x, a802.y, 0);
	al_draw_bitmap(azul752, a752.x, a752.y, 0);
	al_draw_bitmap(verde1302, a1302.x, a1302.y, 0);
	al_draw_bitmap(vermelho1002, a1002.x, a1002.y, 0);
	al_attach_audio_stream_to_mixer(musicaf, al_get_default_mixer());
	al_set_audio_stream_playmode(musicaf, ALLEGRO_PLAYMODE_LOOP);
	
	while(!sair){
		while(!al_is_event_queue_empty(fila_eventos)){ 
			ALLEGRO_EVENT evento;
			al_wait_for_event(fila_eventos, &evento);
			
			if(evento.type == ALLEGRO_EVENT_KEY_DOWN){
				switch(evento.keyboard.keycode){
					case ALLEGRO_KEY_W:
						tecla = 1;
						break;
					case ALLEGRO_KEY_S:
						tecla = 2;
						break;
					case ALLEGRO_KEY_A:
						tecla = 3;
						break;
					case ALLEGRO_KEY_D:
						tecla = 4;
						break;
				}
			}
			if (evento.type == ALLEGRO_EVENT_KEY_UP){
				switch(evento.keyboard.keycode){
					case ALLEGRO_KEY_W:
						tecla = 0;
						break;
					case ALLEGRO_KEY_S:
						tecla = 0;
						break;
					case ALLEGRO_KEY_A:
						tecla = 0;
						break;
					case ALLEGRO_KEY_D:
						tecla = 0;
						break;
				}
			}
			else if (evento.type == ALLEGRO_EVENT_DISPLAY_CLOSE) sair = true;
		}
		if(tecla){
			switch (tecla){
				case 1:
					if (nv.y >= 4)
						nv.y-=velon;
					break;
				case 2:
					if (nv.y <= 536)
						nv.y+=velon;
					break;
				case 3:
					if (nv.x >= 4)
						nv.x-=velon;
					break;
				case 4:
					if (nv.x <= 736)
						nv.x+=velon;
					break;
			}
		}
		
		if (colisao(nv, a60, 60)) reset = 1;
		else if (colisao(nv, a130, 130)) reset = 1;
		else if (colisao(nv, a80, 80)) reset = 1;
		else if (colisao(nv, a75, 75)) reset = 1;
		else if (colisao(nv, a100, 100)) reset = 1;
		else if (colisao(nv, a90, 90)) reset = 1;
		else if (colisao(nv, a602, 60)) reset = 1;
		else if (colisao(nv, a1302, 130)) reset = 1;
		else if (colisao(nv, a802, 80)) reset = 1;
		else if (colisao(nv, a752, 75)) reset = 1;
		else if (colisao(nv, a1002, 100)) reset = 1;
		else if (colisao(nv, a902, 90)) reset = 1;
		
		al_draw_bitmap(fundo1, bg1.x, bg1.y, 0);
		al_draw_bitmap(fundo2, bg2.x, bg2.y, 0);
		al_draw_bitmap(nave, nv.x, nv.y, 0);
		al_draw_bitmap(roxo90, a90.x, a90.y, 0);
		al_draw_bitmap(amarelo60, a60.x, a60.y, 0);
		al_draw_bitmap(marrom80, a80.x, a80.y, 0);
		al_draw_bitmap(azul75, a75.x, a75.y, 0);
		al_draw_bitmap(verde130, a130.x, a130.y, 0);
		al_draw_bitmap(vermelho100, a100.x, a100.y, 0);
		al_draw_bitmap(roxo902, a902.x, a902.y, 0);
		al_draw_bitmap(amarelo602, a602.x, a602.y, 0);
		al_draw_bitmap(marrom802, a802.x, a802.y, 0);
		al_draw_bitmap(azul752, a752.x, a752.y, 0);
		al_draw_bitmap(verde1302, a1302.x, a1302.y, 0);
		al_draw_bitmap(vermelho1002, a1002.x, a1002.y, 0);
		al_draw_textf(fonte, al_map_rgb(255, 255, 255), 10, 10, ALLEGRO_ALIGN_LEFT, "SCORE: %d", score);
		
		if(score > bscore || bs){
			bscore = score;
			al_draw_textf(fonte, al_map_rgb(255, 0, 0), 280, 10, ALLEGRO_ALIGN_LEFT, "BEST SCORE: %d", bscore);
			bs = 1;
		}
		else al_draw_textf(fonte, al_map_rgb(255, 255, 255), 280, 10, ALLEGRO_ALIGN_LEFT, "BEST SCORE: %d", bscore);
		
		if(reset){
			al_rest(2.0);
			a60.x = 810; a130.x = 970; a80.x = 1200; a75.x = 1380; a100.x = 1555; a90.x = 1755;
			a602.x = 1945; a1302.x = 2105; a802.x = 2335; a752.x = 2515; a1002.x = 2690; a902.x = 2890;
			posi_asteroides(&a60, &a130, &a80, &a75, &a100, &a90); 
			posi_asteroides(&a602, &a1302, &a802, &a752, &a1002, &a902); 
			nv.x = 1;
			nv.y = 270;
			bg1.x = 0; bg2.x = 980;
			bg1.y = 0; bg2.y = 0;
			velo = 3;
			velon = 4;
			reset = 0;
			bs = 0;
			if(score >= bscore) bscore = score;
			score = 0;
		}
		
		if(bg1.x <= -980) bg1.x = 980;
		if(bg2.x <= -980) bg2.x = 980;
		if(a90.x <= -90){
			a60.x = a902.x + 190; a130.x = a60.x + 160; a80.x = a130.x + 230; a75.x = a80.x + 180; a100.x = a75.x + 175; a90.x = a100.x + 200;
			posi_asteroides(&a60, &a130, &a80, &a75, &a100, &a90);
			score+=10;
		}
		if(a902.x <= -90){
			a602.x = a90.x + 190; a1302.x = a602.x + 160; a802.x = a1302.x + 230; a752.x = a802.x + 180; a1002.x = a752.x + 175; a902.x = a1002.x + 200;
			posi_asteroides(&a602, &a1302, &a802, &a752, &a1002, &a902);
			velo += 1;
			velon += 1;
			score+=10;
		}
		bg1.x -= 1; bg2.x -= 1;
		a60.x -= velo; a80.x -= velo; a100.x -= velo; a75.x -= velo; a90.x -= velo; a130.x -= velo;
		a602.x -= velo; a802.x -= velo; a1002.x -= velo; a752.x -= velo; a902.x -= velo; a1302.x -= velo;
		
		al_flip_display();
	}
	al_destroy_display(janela);
	al_destroy_audio_stream(musicaf);
	al_destroy_event_queue(fila_eventos);
	return 0;
}
