#include <math.h>
#include "sine.hpp"



Sine::Sine(double outf, double inf, double ins)
: out_factor(outf), in_factor(inf), in_shift(ins)
{
}

double Sine::elong(double t)
{
    return out_factor*sin(in_factor * t + in_shift);
}

void Sine::Derived(double *outf, double *inf, double *ins)
{
    double outf2, inf2, ins2;
    outf2 = out_factor * in_factor;
    inf2 = in_factor;
    ins2 = in_shift + halfpi;
    *outf = outf2;
    *inf = inf2;
    *ins = ins2;
}

Sine Sine::Derived(void)
{
    double outf2, inf2, ins2;
    Derived(&outf2, &inf2, &ins2);
    Sine hjalp(outf2, inf2, ins2);
    return hjalp;
}


void Sine::set(double poutf, double pinf, double pins)
{
    out_factor = poutf;
    in_factor = pinf;
    in_shift = pins;
}  

void Sine::scale(double sf)
{
    out_factor /= sf;
}

void Sine::shift(double sf)
{
    in_shift += sf;
}

        
