#include <allegro.h>
#include <string>
#include <vector>
#include "onekeymenu.hpp"
#include "dialogs.h"
#include "play.h"
#include "data.h"

extern volatile unsigned int timer_cnt;

Globals gv;

DATAFILE *thedata, *thedata1;
FONT *oldfont, *newfont;

int main() 
{ 
 // Initialize Allegro.        
 allegro_init();      
 install_timer();
 srand(time(NULL));
 // Set the resolution to 640 by 480
 //   order of testing (first working will be selected):
 //       windowed 32 bit
 //       windowed 24 bit
 //       fullscreen 32 bit
 //       fullscreen 24 bit
 rand();rand();rand();rand();rand();
 
 
 bool windowed = false;       
 set_color_depth(32);
 if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
 {
        set_color_depth(24);
        if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0)
        {
            set_color_depth(32);
            if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
            {
                set_color_depth(32);
                if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0) != 0)
                {
                    bailout();
                    allegro_exit();
                    return 0;
                }
            }
        }
        else windowed = true;
           
 }
 else windowed = true;
 if (windowed)
 {
    set_window_title("Blub and Blob at the Space Bar");
    set_window_close_button(1);
    set_window_close_hook(SetEscaping);
 }


 set_uformat(U_ASCII);
 // Installing the keyboard handler.
 install_keyboard();
 int err = install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "");
 
   
 // Load the data, set fonts
 thedata = load_datafile("data.dat");
 thedata1 = load_datafile("data2.dat");
 if (!thedata || !thedata1) 
 {
        allegro_exit();
        return 0;
 }
 gv.soundvol = get_config_int(NULL, "sound", 128);
 gv.midivol = get_config_int(NULL, "midi", 128);
 
 set_palette((RGB*)thedata[fontpal].dat);
 newfont = (FONT*)thedata[thefont].dat;
 oldfont = font;
 font = newfont;
 
 if (gv.midivol > 0)
    play_midi((MIDI*)thedata[startupmusic].dat, 0);
    
 Startup();
 
 
 if (gv.midivol > 0)
    play_midi((MIDI*)thedata[p1conmel].dat, 1);
 // Printing text to the screen.

 Onekeymenu menu1(oldfont, makecol(180, 0, 0), makecol(134, 134, 134), 0, makecol(70, 40, 40));
 menu1.add("Play");
 menu1.add("Help");
 menu1.add("About");
 menu1.add("Song & Music");
 menu1.add("GFX Settings");
 menu1.add("Sound Settings");
 
 menu1.add("Quit");
 menu1.fix_widths(10);
 // Main loop, menu1 is the main menu
 int com;
 do
 {
     blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
     com = menu1.do_menu(255, 150, 500, KEY_SPACE);
     switch (com)
     {
            case 0:
              if (gv.midivol != 0 && midi_pos < 0)
                 play_midi((MIDI*)thedata[p1conmel].dat, 1);
                
              com = Play();
              while (key[KEY_SPACE]);
              break;
            case 1:
              blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
              Help();
              break;
            case 2:
              blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
              About();
              break;
            case 3: // Karaoke
              blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
              RunKaraoke();
              break;
            case 4: // gfx settings
              blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
              Settings();
              break;  
            case 5: // sound settings
              blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
              SoundSettings();
              break;  
     }
 }
 while (com != 6);
 unload_datafile(thedata);
 unload_datafile(thedata1);
 set_config_int(NULL, "midi", gv.midivol);
 set_config_int(NULL, "sound", gv.soundvol);
 
 rest(1000);  

 // Exit program.
 allegro_exit();
 return 0;     
}     

// Some Allegro magic to deal with WinMain().
END_OF_MAIN();

/*
       Bilder:
            lburkar 8
            bubbel 6
            bobbel 6 
            pilen
            spelbakgrunden
            ramen
            startbilden
            bakgrund1
            bakgrund2
            bakgrund3
              
            
*/





