#include <vector>
#include <string>
#include <allegro.h>

using namespace std;

class Snippet
{
   // A small class that holds a snippet of the song lyrics,
   // usually one syllable, and the midi beat position when
   // it is to be shown or highlighted
   public:
   string snip;
   int beat;
   //Snippet(string p_snip, string p_beat);
   Snippet(string p_snip, int p_beat);
};

class Karaoke
{
   // A class that draws a window with text that scrolls
   // as midi music is played. The class monitors midi_pos, that
   // usually counts 1/4 notes in the midi music, so that is the
   // smallest time unit that everything is clocked to
   
   BITMAP *workarea;         // buffer for drawing lyrics
   BITMAP *background;       // pattern for lyric backgr.
   int bgcolour;             // alternative for a pattern
   int first_line_last_beat;
   int lastbeat;             // of the lyrics
   float scrollr;            // ratio how much to be scrolled per beat
   int scrollbeats;          // how many beats scrolling lasts
   int scrollpixels;         // ditto pixels
   int noflines;             // of lyrics, including empty lines
   FONT *myfont;             // a colour font preferably with gradient col.
   PALETTE *hipal, *lopal;   // for hi- & loliting lyrics
   MIDI *mymusic;            // 
   vector<Snippet> snippets; // holds every snippet of lyrics and its corresponding beat
   
   // Add a snippet-beat-pair to snippets
   void Add(string snippet, int beat);
   
   int indent;               // indent of the text in the window
   void FillBackground(void);
   
   public:
   Karaoke(char *filename, FONT *p_thefont, 
           PALETTE *p_hipal, PALETTE *p_lopal, MIDI *p_mymusic);
//   Karaoke(char *lyrics, FONT *p_thefont, 
//           PALETTE *p_hipal, PALETTE *p_lopal, MIDI *p_mymusic, int junk);
   
   // return the width required for the lyrics-font combination
   int Width(void);
   
   // 
   void CreateWindow(int p_w, int p_h, BITMAP *p_background, int p_indent);
   void CreateWindow(int p_w, int p_h, int p_bgcolour, int p_indent);

   // Start the karaoke, opening a window at given coordinate
   void Play(int x, int y);
   bool ok;
};
 
