#include <string>
#include <fstream>
#include <iostream>
#include <allegro.h>
#include <stdlib.h>
#include "karaoke.hpp"


using namespace std;

Karaoke::Karaoke(char *filename, FONT *p_thefont, PALETTE *p_hipal, 
                 PALETTE *p_lopal, MIDI *p_mymusic)
: myfont(p_thefont), hipal(p_hipal), lopal(p_lopal), mymusic(p_mymusic)
{
    ok = myfont && hipal && lopal && mymusic;
    if (!ok) return;
    int ycoord = 0;
    ifstream infil(filename);
    //if (!infil) return -1;
    string fil = "";
    char *rad;
    rad = new char[256];
    ok = bool(rad);
    if (!ok) return;
    
    do
    {
        infil.getline(rad, 255, '\n');
        //cout << rad << endl;
        fil += rad;
        fil += '\n';
    }
    while (!infil.eof());
  noflines = 0;
  long p1 = 0, p2 = 0;
  bool first_line = true;
  string snippet, midibeat;
  do
  {
     if (fil[p1] == 10)
     {
        noflines++;
        Add("\n", lastbeat);
        p1++;
        ycoord += text_height(myfont);
        if (first_line)
        {
           first_line_last_beat = lastbeat;
           first_line = false;
        }
     }
     else
     {
        p2 = fil.find("[", p1);
        if (p2 != string::npos) 
        {
           snippet = fil.substr(p1, p2-p1);
           p1 = p2+1;
           p2 = fil.find("]", p1);
           if (p2 != string::npos)
           {
              midibeat = fil.substr(p1, p2-p1);
              lastbeat = atoi(midibeat.c_str());
              Add(snippet, lastbeat);
              p1 = p2+1;
           }
        }
     }
  }
  while (p2 != string::npos);
  scrollbeats = lastbeat - first_line_last_beat;  
  delete []rad;
  infil.close();
}

//Karaoke::Karaoke(char *lyrics, FONT *p_thefont, PALETTE *p_hipal, 
//                 PALETTE *p_lopal, MIDI *p_mymusic, int junk)
//: myfont(p_thefont), hipal(p_hipal), lopal(p_lopal), mymusic(p_mymusic)
//{
//    ok = myfont && hipal && lopal && mymusic;
//    if (!ok) return;
//    int ycoord = 0;
//    //if (!infil) return -1;
//    string fil = "";
//    char *rad;
//    rad = new char[256];
//    ok = bool(rad);
//    if (!ok) return;
//
//    for (char *i = lyrics; *i != 0; i++)
//    {
//        fil += i;
//        fil += '\n';
//        do
//        {
//            i++;
//        }
//        while (*i != 10 && *i != 0);
//        *i++;
//    }
//     textout(screen, font, fil.c_str(), 10, 10, 0x00ff00);
//     while(!keypressed());
//       
//  noflines = 0;
//  long p1 = 0, p2 = 0;
//  bool first_line = true;
//  string snippet, midibeat;
//  do
//  {
//     if (fil[p1] == 10)
//     {
//        noflines++;
//        Add("\n", lastbeat);
//        p1++;
//        ycoord += text_height(myfont);
//        if (first_line)
//        {
//           first_line_last_beat = lastbeat;
//           first_line = false;
//        }
//     }
//     else
//     {
//        p2 = fil.find("[", p1);
//        if (p2 != string::npos) 
//        {
//           snippet = fil.substr(p1, p2-p1);
//           p1 = p2+1;
//           p2 = fil.find("]", p1);
//           if (p2 != string::npos)
//           {
//              midibeat = fil.substr(p1, p2-p1);
//              lastbeat = atoi(midibeat.c_str());
//              Add(snippet, lastbeat);
//              p1 = p2+1;
//           }
//        }
//     }
//  }
//  while (p2 != string::npos);
//  scrollbeats = lastbeat - first_line_last_beat;  
//  delete []rad;
//}

//void Karaoke::Add(string snippet, string beat) // abandoned
//{
//   Snippet z(snippet, beat);
//   snippets.push_back(z);
//}

void Karaoke::Add(string snippet, int beat)
{
   Snippet z(snippet, beat);
   snippets.push_back(z);
}

//Snippet::Snippet(string p_snip, string p_beat) // abandoned
//{
//   snip = p_snip;
//   beat = atoi(p_beat.c_str());
//}

Snippet::Snippet(string p_snip, int p_beat)
{
   snip = p_snip;
   beat = p_beat;
}

void Karaoke::FillBackground(void)
{
   if (!background)
      clear_to_color(workarea, makecol(180, 100, 0));
   else
   {
      for (int i = 0; i < workarea->h; i += background->h)
         for (int j = 0; j < workarea->w; j += background->w)
            blit(background, workarea, 0, 0, j, i, background->w, background->h);
   }
      
}

void Karaoke::Play(int x, int y)
{
   int midi_pos1 = 1;
   rest(300);
   if (play_midi(mymusic, 0) != 0)
      alert("midi failed", NULL, NULL, "OK", NULL, 0, 0);
   //set_volume(128, 128);
   int txtx, txty;
   vector<Snippet>::const_iterator i;
   text_mode(-1);
   while (midi_pos >= 0 && !key[KEY_SPACE])
   {
      FillBackground();
      i = snippets.begin();
      txtx = 20;
      txty = workarea->h/2;
      if (midi_pos > first_line_last_beat)
         txty -= float(midi_pos - first_line_last_beat) * scrollr; 
      set_palette(*hipal);
      bool still_hi = true; 
      while (txty < workarea->h && i != snippets.end())
      {
          if (still_hi && i->beat > midi_pos)
          {
             // here we turn hi to lo, check where 
             // txty is and adjust scrollspeed
             set_palette(*lopal);
             still_hi = false;
//             float adv, adj;
//             adv = txty / workarea->h;
//             // 0.25 - 0.9
//             // 0.75 - 1.1
//             adj = 0.4*adv+0.8;
//             scrollr *= adj;
             
             
          }
          if (i->snip[0] == char(10))
          {
             txtx = 20;
             txty += text_height(myfont);
          }
          else
          if (txty > -text_height(myfont) && txty < workarea->h)
          {
             //
             textout(workarea, myfont, i->snip.c_str(), txtx, txty, -1);
             txtx += text_length(myfont, i->snip.c_str());
          }
          ++i;
          
      }
      blit(workarea, screen, 0, 0, x, y, workarea->w, workarea->h);
      //textprintf(workarea, myfont, 10, 10, 0xff0000, "%i", i);
   }
   stop_midi();
   ;
   
   
}
//Start:
//skriv hela texten med rtt, s lngt det gr.
//Vid 32 kan texten brja rulla. Rkna rullningshastigheten
//med 272-32 = 240 slag, textens totala hjd - fnstrets hjd = scrollhjd,
//s mycket skall texten scrollas uppt under 240 slag
//float scrollr = scrollhjd/240 slag.
//Efter varje slag scrollas uppt scrollr. 

//void Karaoke::Play(void)
//{
//   if (play_midi(mymusic, 0) != 0)
//      alert("midi failed", NULL, NULL, "OK", NULL, 0, 0);
//   int txtx, txty, dy;
//   
//   dy = text_height(myfont);
//   txtx = indent; txty = 10;
//   
//   set_palette(*lopal);
//   text_mode(-1);
//   vector<Snippet>::const_iterator i;
//   for (i = snippets.begin(); i != snippets.end(); ++i)
//   {
//      if (txty > workarea->h)
//         break;
//      //while (midi_pos < i->beat && !keypressed());
//      if (i->snip[0] == char(10))
//      {
//         txtx = 30;
//         txty += dy;
//      }
//      else
//      {
//         //
//         textout(screen, myfont, i->snip.c_str(), txtx, txty, -1);
//         txtx += text_length(myfont, i->snip.c_str());
//      }
//   }
//   set_palette(*hipal);
//   txtx = 30; txty = 10;
//   for (i = snippets.begin(); i != snippets.end(); ++i)
//   {
//      while (midi_pos < i->beat && !keypressed());
//      if (i->snip[0] == char(10))
//      {
//         txtx = 30;
//         txty += dy;
//      }
//      else
//      {
//         //
//         textout(screen, myfont, i->snip.c_str(), txtx, txty, -1);
//         txtx += text_length(myfont, i->snip.c_str());
//      }
//   }
//   
//}

int Karaoke::Width(void)
{
   int maxlength = 0;
   string line = "";
   vector<Snippet>::const_iterator i;
   
   for (i = snippets.begin(); i != snippets.end(); ++i)
   {
      if (i->snip[0] == 10)
      {
         if (text_length(myfont, line.c_str()) > maxlength)
            maxlength = text_length(myfont, line.c_str());
         line = "";
      }
      else
         line += i->snip;
   }
   return maxlength;
}

void Karaoke::CreateWindow(int p_w, int p_h, BITMAP *p_background, int p_indent)
{
   workarea = create_bitmap(p_w, p_h);
   if (!workarea)
      alert("workarea failed", NULL, NULL, "OK", NULL, 0, 0);
   background = p_background;
   indent = p_indent;
   scrollpixels = (noflines-1) * text_height(myfont);
   scrollr = float(scrollpixels) / scrollbeats;
   //scrollr *= 0.9;
}

void Karaoke::CreateWindow(int p_w, int p_h, int p_bgcolour, int p_indent)
{
   workarea = create_bitmap(p_w, p_h);
   if (!workarea)
      alert("workarea failed", NULL, NULL, "OK", NULL, 0, 0);
   background = NULL;
   bgcolour = p_bgcolour;
   indent = p_indent;
   scrollpixels = noflines * text_height(myfont) - 1.5*p_h;
   
   scrollr = float(scrollpixels) / scrollbeats;
   //scrollr *= 0.9;
}



