#include <allegro.h>
#include <almp3.h>
#include "dialogs.h"
#include "karaoke.hpp"
#include "onekeymenu.hpp"
#include "classes.h"
#include "play.h"
#include "data.h"
#include "data2.h"

#define DATASZ  (1<<15) /* (32768) amount of data to read from disk each time */
#define BUFSZ   (1<<16) /* (65536) size of audiostream buffer */

extern Globals gv;
extern DATAFILE *thedata;
extern DATAFILE *thedata1;
extern FONT *oldfont;
using namespace std;
void Help(void)
{
    char *text1 =
    "The topic of this game is about the dangers of playing around with "
    "alcoholic beverages. Blub and Blob are about to travel to space and they know "
    "that a real astronaut doesn't touch the booze. So they want to get rid "
    "of all beer they have. You have to help them. Shoot away the pints and bottles "
    "with the space bar while Blub helps you by aiming the arrow. "
    "When three or more of same kind are connected, they are sucked away and will be "
    "lost in space forever. "
    "Unfortunately there will be some messing, which might affect Blub and Blob "
    "in their noble task.\n\n"
    "This is the main help page. Submenus might have their own help pages, that "
    "tell about the functions in the menus.\n\n"
    "Just remember: Space Bar Rules!";
    
    DIALOG dlg1[] =
    {
       /* (proc)         (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
       { d_box_proc,     112, 64,  424, 312, 0,   0xaaaaaa,   0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc, 120, 72,  408, 264, -1,   0xddffdd,   0,    0,      0,   0,   (void*)text1, NULL, NULL },
       { d_button_proc,  312, 344, 40,  16,  -1,   0xddffdd, 32, D_EXIT,   0,   0,   (void*)"ok",       NULL, NULL },
       { NULL,           0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL }
    };    
    clear_keybuf();
    set_palette((RGB*)thedata[fontpal].dat);
    while (popup_dialog(dlg1, -1) != 2);
    while (key[KEY_SPACE]);

    char *text2 =
    "Scoring and stuff:\n\n"
    "The more items you blow away in one turn, the more you score per item. OTOH don't "
    "waste too much time bonus on building big clusters. Only completed levels score "
    "time and level bonuses.\n\n"
    "Normally you have 3 to 5 seconds time to fire the pint. If you wait too long, "
    "the pint may explode and flush the beer all over poor Blub and Blob. If they "
    "get drunk, they won't act properly. Blub might accidentally fire off the gun by himself.\n\n"
    "This is the main help page. Submenus might have their own help pages, that "
    "tell about the functions in the menus.\n\n"
    "Just remember: Space Bar Rules!";
    
    DIALOG dlg2[] =
    {
       /* (proc)         (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
       { d_box_proc,     112, 64,  424, 312, 0,   0xaaaaaa,   0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc, 120, 72,  408, 264, -1,   0xddffdd,   0,    0,      0,   0,   (void*)text2, NULL, NULL },
       { d_button_proc,  312, 344, 40,  16,  -1,   0xddffdd, 32, D_EXIT,   0,   0,   (void*)"ok",       NULL, NULL },
       { NULL,           0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL }
    };    
    clear_keybuf();
    while (popup_dialog(dlg2, -1) != 2);
    while (key[KEY_SPACE]);
    
}

void Startup(void)
{
    int i;
    blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
    for (i = 1; i < 30 && !key[KEY_SPACE]; i++)
    {
        rest(100);
    }
    Help();
    // bar at 202, title at 0, blob 119, 234, blub 412, 236
    draw_sprite(screen, (BITMAP*)thedata[bar].dat, 0, 202);
    draw_sprite(screen, (BITMAP*)thedata[title].dat, 0, 0);
    draw_sprite(screen, (BITMAP*)thedata[milkyblob].dat, 119, 234);
    draw_sprite(screen, (BITMAP*)thedata[milkyblub].dat, 412, 236);
    
    while (!key[KEY_SPACE]);
    while (key[KEY_SPACE]);
    stop_midi();
    
}
    
    
void About(void)
{
    char *text =
    "Code, graphics, vocals, music and lyrics: Johan Halmen\n"
    "Participated in the One Switch Competition, spring 2005,\n"
    "arranged by Retro Remakes\n"
    "http://www.retroremakes.com\n\n"
    "Thanks to all freeware contributors\n"
    "Thanks to everyone on aa.c, especially 1050.";
    
    DIALOG dlg[] =
    {
       /* (proc)         (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
       { d_box_proc,     112, 64,  424, 312, 0,   0xaaaaaa,   0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc, 120, 72,  408, 264, -1,   0xddffdd,   0,    0,      0,   0,   (void*)text, NULL, NULL },
       { d_bitmap_proc,  134, 237,  380, 99, 0,   0xaaaaaa,   0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_button_proc,  312, 344, 40,  16,  -1,   0xddffdd, 32, D_EXIT,   0,   0,   (void*)"ok",       NULL, NULL },
       { NULL,           0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL }
    };    
    dlg[2].dp = (void*)thedata[retro].dat;
    
    clear_keybuf();
    text_mode(-1);
    set_palette((RGB*)thedata[fontpal].dat);
    while (popup_dialog(dlg, -1) != 3);
    while (key[KEY_SPACE]);
    
    
}

void Settings(void)
{
    Onekeymenu menu(oldfont, makecol(180, 0, 0), makecol(134, 134, 134), 0, makecol(70, 40, 40));
    
    menu.add("32 bit windowed");
    menu.add("24 bit windowed");
    menu.add("32 bit fullscreen");
    menu.add("24 bit fullscreen");
    menu.add("Help");
    menu.add("Cancel");
    
    menu.fix_widths(10);
    while (key[KEY_SPACE]);
    int command, succ;
    
    set_palette((RGB*)thedata[fontpal].dat);
    do
    {
        command = menu.do_menu(200, 100, 500, KEY_SPACE);
        switch (command)
        {
            case 0 :
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                   break;
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Depth 24!");
                    break;
                }
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Fullscreen!");
                    break;
                }
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Fullscreen 24!");
                    break;
                }
            case 1 : 
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                   break;
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Depth 32!");
                    break;
                }
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Fullscreen!");
                    break;
                }
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Fullscreen 32!");
                    break;
                }
            case 2 :
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                   break;
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Depth 24!");
                    break;
                }
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Windowed!");
                    break;
                }
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Windowed 24!");
                    break;
                }
            case 3 :
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                   break;
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Depth 32!");
                    break;
                }
                set_color_depth(24);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Windowed!");
                    break;
                }
                set_color_depth(32);
                succ = set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0);
                if (succ == 0)
                {
                    Message("Windowed 32!");
                    break;
                }
                
            case 4 :
                HelpSettings1();
                clear_keybuf();
                while (key[KEY_SPACE]);
                break;
        }
    }
    while (command == 4);
    while (key[KEY_SPACE]);
}

void HelpSettings1(void)
{
    char *text =
    "Set the graphics.\nDon't count on it, though.\n"
    "You might experience sound troubles etc.";
    
    DIALOG dlg[] =
    {
       /* (proc)         (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
       { d_box_proc,     112, 64,  424, 312, 0,   0xaaaaaa,   0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc, 120, 72,  408, 264, -1,   0xddffdd,   0,    0,      0,   0,   (void*)text, NULL, NULL },
       { d_button_proc,  312, 344, 40,  16,  -1,   0xddffdd, 32, D_EXIT,   0,   0,   (void*)"ok",       NULL, NULL },
       { NULL,           0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL }
    };    
    
    clear_keybuf();
    while (key[KEY_SPACE]);
    text_mode(-1);
    set_palette((RGB*)thedata[fontpal].dat);
    popup_dialog(dlg, -1);
}

            
            
void bailout(void)
{
    allegro_message("Unable to set the graphic mode. Tried with 32/24 bit fullscreen/windowed.");
}
    
void RunKaraoke(void)
{
    MIDI *midi;
    char *text =
    "Listen to a mp3 file, where the bartender sings the song.\n\n"
    "Sing along with a midi file and a scrolling lyrics page, you "
    "can choose between two pitches and either with or without "
    "the trombone melody line.";
    
    DIALOG dlg[] =
    {
       /* (proc)         (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)               (dp2) (dp3) */
       { d_box_proc,     112, 64,  424, 312, 0,   0xaaaaaa,   0,    0,      0,   0,   NULL,              NULL, NULL },
       { d_textbox_proc, 120, 72,  408, 264, -1,   0xddffdd,   0,    0,      0,   0,   (void*)text, NULL, NULL },
       { d_button_proc,  312, 344, 40,  16,  -1,   0xddffdd, 32, D_EXIT,   0,   0,   (void*)"ok",       NULL, NULL },
       { NULL,           0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,              NULL, NULL }
    };    
    stop_midi();
    while (key[KEY_SPACE]);
    Onekeymenu menu2(oldfont, makecol(180, 0, 0), makecol(134, 134, 134), 0, makecol(70, 40, 40));
    menu2.add("Listen to mp3");
    menu2.add("Karaoke, pitch 1 with melody");
    menu2.add("Karaoke, pitch 1 without melody");
    menu2.add("Karaoke, pitch 2 with melody");
    menu2.add("Karaoke, pitch 2 without melody");
    menu2.add("Help");
    menu2.add("Return");
    menu2.fix_widths(10);
    
    int command;
    do
    {
        command = menu2.do_menu(200, 100, 500, KEY_SPACE);
        switch(command)
        {
            case 0 :
                blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
                PlaySongTrack();
                break;
            case 1 :
                midi = (MIDI*)thedata[p1conmel].dat;
                blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
                PlayKaraoke(midi);
                break;
            case 2 :
                midi = (MIDI*)thedata[p1senzamel].dat;
                blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
                PlayKaraoke(midi);
                break;
            case 3 :
                midi = (MIDI*)thedata[p2conmel].dat;
                blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
                PlayKaraoke(midi);
                break;
            case 4 :
                midi = (MIDI*)thedata[p2senzamel].dat;
                blit((BITMAP*)thedata[spacey].dat, screen, 0, 0, 0, 0, 640, 480);
                PlayKaraoke(midi);
                break;
            case 5 :
                text_mode(-1);
                clear_keybuf();
                set_palette((RGB*)thedata[fontpal].dat);
                popup_dialog(dlg, -1);
                break;
       }
       while (key[KEY_SPACE]);
    }
    while (command != 6);
    
                
}    

void PlaySongTrack(void)
{
    
   //DATAFILE *karadata;
   //karadata = load_datafile("data2.dat");
   // 384*280
   blit((BITMAP *)thedata1[lyricsimage].dat, screen, 0, 0, 128, 50, 384, 280);
   Frame(screen, 128, 50, 511, 329, makecol(80, 220, 40));
   //unload_datafile(karadata);
    
    MP3FILE *mp3;
    mp3 = open_mp3_file("vocals.mp3");
    while(key[KEY_SPACE]);
    play_mp3_file(mp3, BUFSZ, 255, 128);
    
  while ((!key[KEY_SPACE])) 
  {
      if ((mp3) && (poll_mp3_file(mp3) != ALMP3_OK)) 
      {
        close_mp3_file(mp3);
        mp3 = NULL;
      }
    
  }
  close_mp3_file(mp3);
    
    
//   DATAFILE *karadata;
//   karadata = load_datafile("data2.dat");
//    ALMP3_MP3 *songtrack;
//    songtrack = almp3_create_mp3((ALMP3_MP3 *)karadata[vocals].dat, 32768);
//    while (key[KEY_SPACE]);
//    almp3_play_mp3(songtrack, 400000, 255, 128);
//    do
//    {
//        almp3_poll_mp3(songtrack);
//        rest(200);
//    }
//    while (!key[KEY_SPACE]); 
//    //almp3_is_playing_mp3(songtrack) && !
//    almp3_stop_mp3(songtrack);
//    almp3_destroy_mp3(songtrack); 
//    unload_datafile(karadata);
}

MP3FILE *open_mp3_file(char *filename) {
  MP3FILE *p = NULL;
  PACKFILE *f = NULL;
  ALMP3_MP3STREAM *s = NULL;
  char data[DATASZ];
  int len;

  if (!(p = (MP3FILE *)malloc(sizeof(MP3FILE))))
    goto error;
  if (!(f = pack_fopen(filename, F_READ)))
    goto error;
  if ((len = pack_fread(data, DATASZ, f)) <= 0)
    goto error;
  if (len < DATASZ) {
    if (!(s = almp3_create_mp3stream(data, len, TRUE)))
      goto error;
  }
  else {
    if (!(s = almp3_create_mp3stream(data, DATASZ, FALSE)))
      goto error;
  }
  p->f = f;
  p->s = s;
  return p;

  error:
  pack_fclose(f);
  free(p);
  return NULL;
}

int play_mp3_file(MP3FILE *mp3, int buflen, int vol, int pan) {
  return almp3_play_mp3stream(mp3->s, buflen, vol, pan);
}

void close_mp3_file(MP3FILE *mp3) {
  if (mp3) {
    pack_fclose(mp3->f);
    almp3_destroy_mp3stream(mp3->s);
    free(mp3);
  }
}


int poll_mp3_file(MP3FILE *mp3) {
  char *data;
  long len;

  data = (char *)almp3_get_mp3stream_buffer(mp3->s);
  if (data) {
    len = pack_fread(data, DATASZ, mp3->f);
    if (len < DATASZ)
      almp3_free_mp3stream_buffer(mp3->s, len);
    else
      almp3_free_mp3stream_buffer(mp3->s, -1);
  }

  return almp3_poll_mp3stream(mp3->s);
}



void PlayKaraoke(MIDI *midi)
{
   // DATAFILE *karadata;
   // karadata = load_datafile("data2.dat");
   while (key[KEY_SPACE]);
   if (thedata1 != NULL)
   {
        Karaoke *myKaraoke =
              new Karaoke("lyrics.txt", 
                          (FONT*)thedata1[myfont].dat,
                          (PALETTE*)thedata1[litepal].dat,
                          (PALETTE*)thedata1[darkpal].dat,
                          midi);
        if (!myKaraoke)
        {
            alert("myKaraoke not ok", NULL, NULL, "Ok", NULL, 0, 0);
            // unload_datafile(karadata);
            return;
        }
        int width = myKaraoke->Width();
        
        myKaraoke->CreateWindow(width + 40, 400, (BITMAP*)thedata1[backgr2].dat, 20);
        Frame(screen, 320 - width / 2 - 20, 40, 320 + width / 2 + 20, 440, makecol(180, 100, 20));
        myKaraoke->Play(320 - width / 2 - 20, 40);
        delete myKaraoke;
        // unload_datafile(karadata); 
  }
  
                    
            
}

void SoundSettings(void)
{
//    char *menuitems[7] =
//    {" Music full",
//     " Music medium",
//     " Music off",
//     " Sound fx full",
//     " Sound fx medium",
//     " Sound fx off",
//     " Return"};

    Onekeymenu menu1(oldfont, makecol(180, 0, 0), makecol(134, 134, 134), 0, makecol(70, 40, 40));
    
    menu1.add("Music full");
    menu1.add("Music medium");
    menu1.add("Music off");
    menu1.add("Sound fx full");
    menu1.add("Sound fx medium");
    menu1.add("Sound fx off");
    menu1.add("Return");
    menu1.fix_widths(10);
    //menuitems[0][0] = (char)0xbb;
    int command;
    do
    {
        while (key[KEY_SPACE]);
        command = menu1.do_menu(200, 100, 500, KEY_SPACE);
        switch (command)
        {
            case 0 :
                gv.midivol = 255;
//                menuitems[0][0] = 0xbb;
//                menuitems[0][1] = 0x20;
//                menuitems[0][2] = 0x20;
                break;
            case 1 :
                gv.midivol = 128;
//                menuitems[0][0] = 0x20;
//                menuitems[0][1] = 0xbb;
//                menuitems[0][2] = 0x20;
                break;
            case 2 :
                gv.midivol = 0;
//                menuitems[0][0] = 0x20;
//                menuitems[0][1] = 0x20;
//                menuitems[0][2] = 0xbb;
                break;
            case 3 :
                gv.soundvol = 255;
//                menuitems[0][0] = 0xbb;
//                menuitems[0][1] = 0x20;
//                menuitems[0][2] = 0x20;
                break;
            case 4 :
                gv.soundvol = 128;
//                menuitems[0][0] = 0x20;
//                menuitems[0][1] = 0xbb;
//                menuitems[0][2] = 0x20;
                break;
            case 5 :
                gv.soundvol = 0;
//                menuitems[0][0] = 0x20;
//                menuitems[0][1] = 0x20;
//                menuitems[0][2] = 0xbb;
                break;
        }
        if (command != 6)
        {
            set_volume(gv.soundvol, gv.midivol);
            if (command == 3 || command == 4)
               play_sample((SAMPLE*)thedata[sweepout].dat, 255, 128, 1000, 0);
            if (command < 2 && midi_pos < 0)
               play_midi((MIDI*)thedata[p1conmel].dat, 1);
        }
    }
    while (command != 6);
    while (key[KEY_SPACE]);
    if (gv.midivol == 0)
       stop_midi();
}

    
