#include <math.h>
#include <allegro.h>
#include <string>
#include "classes.h"
#include "data.h"
#include "data2.h"
#include "play.h"
#include "sine.hpp"
#include "onekeymenu.hpp"

extern DATAFILE *thedata;
extern DATAFILE *thedata1;
extern FONT *oldfont;
extern Globals gv;

volatile unsigned int timer_cnt;
volatile unsigned int timer_cnt2;
volatile int startbonus;

bool Place::NewBall(int n)
{
    who = new Ball(n);
    if (!who)
        return false;
    who->Set(this->x, this->y);
    return true;
}

Place::Place(void)
{
    who = NULL;
}

double Place::distance(Ball *ball)
{
    return sqrt(((double)x - ball->x) * ((double)x - ball->x) + ((double)y - ball->y) * ((double)y - ball->y));
}

void Frame(BITMAP *bm, int x1, int y1, int x2, int y2, int col)
{
    int r, g, b, r1, g1, b1;
    int help;
    int j[5];
    j[2] = col;
    
    // leave the x1, y1, x2, y2 rectangle empty
    x1--; y1--; x2++; y2++;
    
    r = getr(col);
    g = getg(col);
    b = getb(col);
    
    help = 255 - r;
    help /= 3;
    r1 = r + help;
    help = 255 - g;
    help /= 3;
    g1 = g + help;
    help = 255 - b;
    help /= 3;
    b1 = b + help;
    j[1] = makecol(r1, g1, b1);
    
    help = 255 - r;
    help /= 3;
    help *= 2;
    r1 = r + help;
    help = 255 - g;
    help /= 3;
    help *= 2;
    g1 = g + help;
    help = 255 - b;
    help /= 3;
    help *= 2;
    b1 = b + help;
    j[0] = makecol(r1, g1, b1);
    
    r1 = r / 3;
    g1 = g / 3;
    b1 = b / 3;
    j[4] = makecol(r1, g1, b1);
    
    r1 = r / 3;
    r1 *= 2;
    g1 = g / 3;
    g1 *= 2;
    b1 = b / 3;
    b1 *= 2;
    j[3] = makecol(r1, g1, b1);
    
    for (int i = 0; i < 5; i++)
    {
        line(bm, x1-i,  y1-i, x2+i, y1-i, j[4-i]);
        line(bm, x1-i,  y1-i, x1-i, y2+i, j[4-i]);
        line(bm, x1-i,  y2+i, x2+i, y2+i, j[i]);
        line(bm, x2+i,  y1-i, x2+i, y2+i, j[i]);
    }
}

Ball::Ball(int p_type)
: type(p_type)
{
    sprite = create_sub_bitmap((BITMAP*)thedata[beers].dat, 30*(type/3), 30*(type%3), 30, 30);
    x = 0.;
    y = 0.;
}

void Ball::Set(int xp, int yp)
{
    x = (double)xp;
    y = (double)yp;
}

void Ball::Draw(BITMAP *where)
{
    draw_sprite(where, sprite, (int)x-15, (int)y-15);
}

bool Ball::Move(void)
{
    x += dx;
    y += dy;
    return true;
    
}

//void Ball::Init(void)
//{
//    int i, j;
//    for (i = 0; i < 3; i++)
//       for (j = 0; j < 3; j++)
//       {
//       }
//} 

Game::Game(Place *p_field, int x, int y)
: field(p_field), x0(x), y0(y), osc1(1, 1, 0), osc2(0, 2, 0), osc3(0, 3, 0),
  deriv1(0, 0, 0), deriv2(0, 0, 0), deriv3(0, 0, 0), temp(0, 0, 0)
{
    score = new Digits((BITMAP*)thedata[digs].dat);
    bonus = new Digits((BITMAP*)thedata[digs].dat);
    score->zeros = true;
    bonus->zeros = true;
    buffer = create_bitmap(240, 400);
    actionfield = (BITMAP*)thedata[background].dat;
    dtime = 0;
    
    gv.kill = 0;
    // thedata2 = load_datafile("data2.dat");
}

Game::~Game()
{
    delete score;
    //destroy_bitmap(actionfield);
    destroy_bitmap(buffer);
    // unload_datafile(thedata2);
}

void Game::ClearField(void)
{
    for (int i = 0; i < 90; i++)
       if (field[i].who)
       {
            delete field[i].who;
            field[i].who = NULL;
       }
}

void Game::Explode(void)
{
    delete nearest->who;
    nearest->who = NULL;
    play_sample((SAMPLE*)thedata[pour].dat, 255, 128, 1000, 0);
    
    int disty = 360 - nearest->y;
    int distx = 120 - nearest->x;
    int x[7] = {55-30, 58-25, 70-20, 77-15, 61-10, 101-5, 77};
    int y[7] = {22, 28, 38, 31, 50, 38, 32};
    
    
    for (int i = 0; i < 7; i++)
    {
        blit(actionfield, buffer, 0, 0, 0, 0, 240, 400);
        DrawWheel();
        //if (loaded)
        //loaded->Draw(buffer);
        DrawBlob();
        DrawBlub();
        queued->Draw(buffer);
        DrawBalls();
        draw_sprite(buffer, (BITMAP*)thedata[expl1 + i].dat, 
                            loaded->x + i * distx / 6 - x[i], 
                            loaded->y + i * disty / 6 - y[i]);
        vsync();
        blit(buffer, screen, 0, 0, x0, y0, 240, 400); 


        //DrawItems();
        rest(150);
        
    }
    unsobriety++;
}

ResultType Game::Play(int p_startbonus, int completionbonus, int delaytime)
{
    int the_time, pointsaddition;
    startbonus = p_startbonus;
    bool empty, full;
    
    belching = false;
    
    install_int(my_timer, 20);
    install_int(my_timer2, 1000);
    
    //FillBackground();
    draw_sprite(screen, actionfield, x0, y0);
    // playfieldframe
    Frame(screen, x0, y0, x0+239, y0+399, makecol(40, 240, 20));
    //pointframe
    Frame(screen, 460, 65, 610, 105, makecol(20, 240, 40));
    //pointlabelframe
    Frame(screen, 460, 40, 557, 53, makecol(20, 240, 40));
    //bonusframe
    Frame(screen, 460, 150, 580, 190, makecol(20, 240, 40));
    //bonuslabelframe
    Frame(screen, 460, 125, 553, 138, makecol(20, 240, 40));
    
    blit((BITMAP*)thedata[pointlbl].dat, screen, 0, 0, 460, 40, ((BITMAP*)thedata[pointlbl].dat)->w, ((BITMAP*)thedata[pointlbl].dat)->h);
    blit((BITMAP*)thedata[bonuslbl].dat, screen, 0, 0, 460, 125, ((BITMAP*)thedata[bonuslbl].dat)->w, ((BITMAP*)thedata[bonuslbl].dat)->h);
    // DrawFellows();
    queued = ShowNext();
    rest(500);
    unsobriety = 0;
    SetOscillators();
    do
    {
        loaded = LoadNext(queued);
        queued = ShowNext();
        // DrawItems();
        //DrawBalls();
        
        Aim();
        if (gv.kill) break;
        Fly();
        
        if (gv.kill) break;
        if (gv.escaping) break;
        if (timer_cnt > 200 && rand()%10 < 3) //
        {
            Explode();
            SetOscillators();
            //delete loaded;
        }
        else
        {
            pointsaddition = CheckConstel();
            points += pointsaddition;
            PrintScore();
        }
        empty = true;
        for (int i = 0; i < 83 && empty; i++)
           if (field[i].who != NULL)
              empty = false;
        full = false;
        for (int i = 83; i < 90 && !full; i++)
           if (field[i].who != NULL)
              full = true;
         
    }
    while (!full && !empty && !key[KEY_ESC] && !gv.kill);
    bonus->Print(screen, 460, 150, startbonus, 4);
    // unsobriety += 5;
    remove_int(my_timer);
    remove_int(my_timer2);
    if (key[KEY_ESC])
    {
       gv.kill = true; 
       return aborted;
    }
    if (gv.escaping)
       return stuck; 
    if (full)
       return stuck;
    else
       return cleared;
}

void Game::PrintScore(void)
{
    score->Print(screen, 460, 65, points, 5);
}

void Game::FillBackground(void)
{
//   if (!bg)
//      clear_to_color(workarea, makecol(180, 100, 0));
//   else
      
      //double galax
      //blit((BITMAP*)thedata[background].dat, actionfield, 0, 0, 0, 0, 240, 400);
      return;
      
      
//      for (int i = 0; i < actionfield->h; i += bg->h)
//         for (int j = 0; j < actionfield->w; j += bg->w)
//            blit(bg, actionfield, 0, 0, j, i, bg->w, bg->h);
      
}

void Game::DrawItems(void)
{
    blit(actionfield, buffer, 0, 0, 0, 0, 240, 400);
    DrawWheel();
    //if (loaded)
    loaded->Draw(buffer);
    DrawBlob();
    DrawBlub();
    if (timer_cnt > 20) queued->Draw(buffer);
    DrawBalls();
    blit(buffer, screen, 0, 0, x0, y0, 240, 400); 
    bonus->Print(screen, 460, 150, startbonus, 4);
    //
}       

void Game::DrawBalls(void)
{
    for (int i = 0; i < 90; i++)
    {
    
//            while(key[KEY_SPACE]);
//        while(!key[KEY_SPACE]);

       if (field[i].who != NULL)
          field[i].who->Draw(buffer);
            
          
    }
    
}       

void Game::DrawWheel(void)
{
    fixed angle;
    
    theangle = osc1.elong(dtime) + osc2.elong(dtime) + osc3.elong(dtime);
    theangle *= 1.2;
    angle = ftofix(theangle*40.743665431525205956834243423364);
    rotate_sprite(buffer, (BITMAP*)thedata[wheelie].dat, wheelx-41, wheely-52, angle);
    
    
}

void Game::DrawBlub(void)
{
    BITMAP *blub;
    static bool first;
    
    int unsober, pick;
    unsober = 0;
    if (unsobriety > 0) unsober++;
    if (unsobriety > 5) unsober++;
    if (unsobriety > 10) unsober++;
       
    pick = 0;
    if (timer_cnt < 20)
    {
        pick = 1;
        first = true;
    }
    else
    {
        if (first && unsober >= 2 && rand() % 3 == 0)
           play_sample((SAMPLE*)thedata[snark].dat, 255, 128, 1000, 0);
        first = false;
    }
    
    switch (unsober)
    {
        case 0 :
            blub = (BITMAP*)thedata[bub1+pick].dat;
            break;
        case 1 :
            blub = (BITMAP*)thedata[bub3+pick].dat;
            break;
        default :
            blub = (BITMAP*)thedata[bub5+pick].dat;
            break;
    }
    draw_sprite(buffer, blub, 5, 330);
}
    
void Game::DrawBlob(void)
{
    BITMAP *blob;
    int unsober;
    int delta;
    unsober = 0;
    if (unsobriety > 0) unsober++;
    if (unsobriety > 5) unsober++;
    if (unsobriety > 10) unsober++;
    unsober *= 2;
    if (unsober > 4) unsober = 4;
    int sign = 0;
    if (deriv1.elong(dtime) + deriv2.elong(dtime) + deriv3.elong(dtime) < 0)
       sign = 1;
    unsober += sign;
    if (!belching)
    {
        delta = 0;
        switch (unsober)
        {
            case 0 :
                blob = (BITMAP*)thedata[bob1].dat;
                break;
            case 1 :
                blob = (BITMAP*)thedata[bob2].dat;
                break;
            case 2 :
                blob = (BITMAP*)thedata[bob3].dat;
                break;
            case 3 :
                blob = (BITMAP*)thedata[bob4].dat;
                break;
            case 4 :
                blob = (BITMAP*)thedata[bob5].dat;
                break;
            case 5 :
                blob = (BITMAP*)thedata[bob6].dat;
                break;
        }
    }
    else
    {
        delta = 10;
        blob = (BITMAP*)thedata[belchingblob].dat;
        if (timer_cnt - belchtime > 20)
           belching = false;
    }
    draw_sprite(buffer, blob, 140, 335-delta);
}

void Game::DrawFellows(void)
{
    BITMAP *blub, *blob;
    int unsober;
    unsober = unsobriety / 5;
    switch (unsober)
    {
        case 0 :
            blub = (BITMAP*)thedata[bub1].dat;
            blob = (BITMAP*)thedata[bob1].dat;
            break;
        case 1 :
            blub = (BITMAP*)thedata[bub3].dat;
            blob = (BITMAP*)thedata[bob3].dat;
            break;
        default :
            blub = (BITMAP*)thedata[bub5].dat;
            blob = (BITMAP*)thedata[bob5].dat;
            break;
    }
    draw_sprite(screen, blub, x0+5, y0+330);
    draw_sprite(screen, blob, x0+140, y0+330);

}

void Game::SetOscillators(void)
{
    /*
    
    sobriety == 0:
        only osc1
    sobriety 1-5:
        osc1 - 0.75-0.5, osc2 0.25-0.5
    sobriety 6-10:
        osc1 - 0.5-0.3, osc2&osc3 0.25-0.35
    sobriety > 10:
        shift changes
    */
    
    double a1, a2;
    
    if (unsobriety == 0)
    {
        osc1.set(1, 1, (double)rand()/RAND_MAX*2);
        osc2.set(0, 2, 0);
        osc3.set(0, 3, 0);
    }
    else if (unsobriety < 6)
    {
        a1 = 0.75 -0.25 * (unsobriety-1) / 4.;
        a2 = 0.25 * (unsobriety - 1) / 4. + 0.25;
        osc1.set(a1, 1, (double)rand()/RAND_MAX*2);
        osc2.set(a2, 2, (double)rand()/RAND_MAX*2);
        osc3.set(0, 3, 0);
    }
    else if (unsobriety < 11)
    {
        a1 = 0.5 - 0.2*(unsobriety-6)/4.;
        a2 = 0.25 + 0.1 *(unsobriety-6)/4.;
        osc1.set(a1, 1, (double)rand()/RAND_MAX*2);
        osc2.set(a2, 2, (double)rand()/RAND_MAX*2);
        osc3.set(a2, 3, (double)rand()/RAND_MAX*2);
    }
    else
    {
        osc2.shift(0.05);
        osc3.shift(-0.05);
    }
         
        
//    osc1.set(1, 1, (double)rand()/RAND_MAX*2);
//    if (unsobriety >= 5)
//       osc2.set((double)rand()/RAND_MAX, 2, (double)rand()/RAND_MAX);
//    else
//       osc2.set(0, 2, 0);
//       
//    if (unsobriety >= 10)
//       osc3.set((double)rand()/RAND_MAX, 3, (double)rand()/RAND_MAX);
//    else
//       osc3.set(0, 3, 0);
//       
//    // Scale the oscillators:
//    double a, sum, max = 0.;
//    for (a = 0.; a < twopi; a += 0.05)
//    {
//        sum = osc1.elong(a) + osc2.elong(a) + osc3.elong(a);
//        if (max < sum) max = sum;
//    }
//    osc1.scale(sum);
//    osc2.scale(sum);
//    osc3.scale(sum);
    
    
    temp = osc1.Derived();
    deriv1 = temp.Derived();
    temp = osc2.Derived();
    deriv2 = temp.Derived();
    temp = osc3.Derived();
    deriv3 = temp.Derived();
}
    
void Game::Aim(void)
{
    
    bool newbelch;
    int belchstart;
    belchstart = 10 + rand() % 20;
    newbelch = ((rand() % 15) < unsobriety);
    while (key[KEY_SPACE]);
    do
    {
        if (!belching && unsobriety > 0 && timer_cnt > belchstart)
        {
            if (newbelch)
            {
                belching = true;
                belchtime = timer_cnt;
                play_sample((SAMPLE*)thedata[belch].dat, 255, 128, 1000, 0);
            }
        }
                
        DrawItems();
        timer_cnt2 = 1;
        while(timer_cnt2>0);
        dtime += 0.03; // TIMETHIS
        if (key[KEY_ESC])
           gv.kill = true;
    }
    while (!key[KEY_SPACE] && !gv.kill && !belching);
    //unsobriety++;
    //SetOscillators();
    // play_sample(const SAMPLE *spl, int vol, int pan, int freq, int loop);
    play_sample((SAMPLE*)thedata[launch].dat, 255, 128, 1000, 0);
}


void Game::Fly(void)
{
    int hold;
    char *esca = "Escape?";
    Onekeymenu escape(oldfont, makecol(180, 0, 0), makecol(134, 134, 134), 0, makecol(70, 40, 40));
    escape.add("Yes");
    escape.add("No");
    if (gv.kill) return;
    bool hit = false;
    bool space_hanging = true;
    gv.escaping = false;
    loaded->dx = sin(theangle)*5.;
    loaded->dy = -cos(theangle)*5.;
    do
    {
        if (space_hanging)
           if (!key[KEY_SPACE])
              space_hanging = false;
        if (!space_hanging)
           if (key[KEY_SPACE])
              gv.escaping = true;
        if (gv.escaping)
        {
            hold = timer_cnt;
            if (escape.do_menu2((char*)esca, 254, 100, 500, (int)KEY_SPACE) == 1)
               gv.escaping = false;
            timer_cnt = hold;
        }
        DrawItems();
        timer_cnt2 = 1;
        while(timer_cnt2 > 0);
        loaded->Move();
        if (loaded->x < 15)
        {
            loaded->x = 30 - loaded->x;
            loaded->dx = -loaded->dx;
        }
        if (loaded->x > 225)
        {
           loaded->x = 450 - loaded->x;
           loaded->dx = -loaded->dx;
        }
        hit = CheckHits();
    }
    while (loaded->y > 14 && !hit && !gv.kill && !gv.escaping);
    
    FixBall(loaded);
}

bool Game::CheckHits(void)
{
        
        for (int i = 0; i < 90; i++)
        {
            if (field[i].who != NULL)
            {
                //field[i].who->Draw(screen);
                if (field[i].distance(loaded) < 30)
                {
                    return true;
                    //break;
                }
            }
        }   
        return false;
}    

void Game::FixBall(Ball *ball)
{
    
    double dist = 999999.;
    int i, i1;
    i1 = 111;
    nearest = &field[0];
    for (i = 0; i < 90; i++)
    {
        // find all empty places
        if (field[i].who == NULL)
        {
            if (field[i].distance(ball) < dist)
            {
                dist = field[i].distance(ball);
                nearest = &field[i];
                i1 = i;
            }
        }
    }
    nearest->who = ball;
    ball->x = nearest->x;
    ball->y = nearest->y;
}
/*
             o * * o * o o o
              * o * o o o o
             o * o * o o o o
              * * o o o o o
             o o o o o o o o
              o o o o o o o
             o o o o o o o o
              o o o o o o o
             



*/

                
int Game::CheckConstel(void)
{
    int countpoints;
    ResetFlags(similar_f);
    similar = 0;
    SetRecursivelyAll(nearest, nearest->who->type);
    if (similar >= 3)
    {
       //PopAway();
        play_sample((SAMPLE*)thedata[sweepout].dat, 255, 128, 1000, 0);
        similar = 0;
        SetFlags(leftover_f);
        Place *p = field;
        for (int i = 0; i < 8; i++)
        {
             ResetRecursivelyDown(p);
             p++;
        }
//        ResetRecursivelyDown(&(field[1]));
//        ResetRecursivelyDown(&(field[2]));
//        ResetRecursivelyDown(&(field[3]));
//        ResetRecursivelyDown(&(field[4]));
//        ResetRecursivelyDown(&(field[5]));
//        ResetRecursivelyDown(&(field[6]));
//        ResetRecursivelyDown(&(field[7]));
        
        
        PopAway();
        countpoints = similar * (similar - 1);
        return countpoints;
    }
    
    
    return 0;
}

void Game::ResetFlags(Flags f)
{
    for (int i = 0; i < 90; i++)
    {
       field[i].flags = field[i].flags & ~f;
       
    }
}

void Game::SetFlags(Flags f)
{
    for (int i = 0; i < 90; i++)
    {
          field[i].flags = field[i].flags | f;
    }
}

void Game::PopAway(void)
{
    //while (!key[KEY_SPACE]);
    similar = 0;
    for (int i = 0; i < 90; i++)
    {
       if (field[i].who)
       {
          if ((field[i].flags & similar_f) || (field[i].flags & leftover_f))
          {
                similar++;
                delete field[i].who;
                field[i].who = NULL;
                field[i].flags = similar_f;
                // field[i].flag = true;
          }
          else
                field[i].flags = 0;
       }
       else
           field[i].flags = 0;
    }
    //ResetFlags();
    
    blit(actionfield, buffer, 0, 0, 0, 0, 240, 400);
    DrawWheel();
    //loaded->Draw(buffer);
    DrawBlob();
    DrawBlub();
    queued->Draw(buffer);
    DrawBalls();
    
    //blit(buffer, screen, 0, 0, x0, y0, 240, 400); 
    for (int j = 0; j < 3; j++)
    {
        blit(buffer, screen, 0, 0, x0, y0, 240, 400);
        for (int i = 0; i < 90; i++)
        {
            if (field[i].flags)
            {
                draw_sprite(screen, (BITMAP*)thedata1[fume1+j].dat, x0+field[i].x-20, y0+field[i].y-20);
            }
        }
        rest(200);
        Frame(screen, x0, y0, x0+240, y0+400, makecol(40, 240, 20));
    }
        
}

void Game::ResetRecursivelyDown(Place *place)
{
    if (place == NULL) 
    {
        //Message("place null");
        return;
    }
    if (place->who == NULL)
    {
        //Message("who null");
        return;
    }
    if (!(place->flags & leftover_f))
    {
        //Message("left null");
        return;
    }
    if (place->flags & similar_f)
    {
        //Message("sim null");
        return;
    }
    //Message("ok");
    place->flags = place->flags & ~leftover_f;
    //circlefill(screen, x0 + place->x, y0 + place->y, 6, 0xff00ff);
    //rest(500);
    ResetRecursivelyDown(place->dl);
    ResetRecursivelyDown(place->dr);
    ResetRecursivelyDown(place->l);
    ResetRecursivelyDown(place->r);
    ResetRecursivelyDown(place->ul);
    ResetRecursivelyDown(place->ur);
}


void Game::SetRecursivelyAll(Place *place, int type)
{
    if (place == NULL) return;
    if (place->who == NULL) return;
    if (place->who->type != type) return;
    if (place->flags & similar_f) return;
    similar++;
    place->flags = place->flags | similar_f;
    //circlefill(screen, x0 + place->x, y0 + place->y, 10, 0xffff00);
//    delete place->who;
//    place->who = NULL;
    SetRecursivelyAll(place->ul, type);
    SetRecursivelyAll(place->ur, type);
    SetRecursivelyAll(place->l, type);
    SetRecursivelyAll(place->r, type);
    SetRecursivelyAll(place->dl, type);
    SetRecursivelyAll(place->dr, type);
    
    
}
    
Ball *Game::LoadNext(Ball *queued)
{
    // Here we place the loaded pint into the wheel
    queued->Set(wheelx, wheely+15);
    return queued;
    
}

void my_timer(void)
{
    timer_cnt++;
    timer_cnt2--;
}

void my_timer2(void)
{
    startbonus-=10;
    if (startbonus < 0) startbonus = 0;
}

Ball *Game::ShowNext(void)
{
    int used[90], n, i;
    for (i = 0, n = 0; i < 90; i++)
    {
        if (field[i].who != NULL)
        {
            used[n] = field[i].who->type;
            n++;
        }
    }
    
    
    Ball *z = new Ball(used[rand() % n]);
    if (z == NULL)
       Message("No first ball");
    z->Set(74, 384);
    timer_cnt = 0;
    
    //draw_sprite(screen, z->sprite, x0 + 58, y0 + 365);
    return z;
}


