/************************************************************************/
/*                                                                      */
/*                        S Q L w r a p . h                             */
/*                                                                      */
/*   Content: Module of SQL wrapping functions                          */
/*   Programmer: Eric Pietrocupo                                        */
/*   Starting Date: April, 22nd, 2012                                   */
/*                                                                      */
/*   This is a brapper library for SQLite related to SQLobject. This    */
/*   file contains procedure to be used for non-dataobject operations.  */
/*   The database pointer is shared by sqlwrap and sqlobject.           */
/*                                                                      */
/************************************************************************/

#ifndef SQLWRAP_H_INCLUDED
#define SQLWRAP_H_INCLUDED

/*----------------------------------------------------------------------*/
/*-                                Constants                           -*/
/*----------------------------------------------------------------------*/


#define SQL_QUERYSTR_LEN 1024
#define SQL_PRIMARY_KEY "pk"

// alliases
#define SQLerrormsg_activate     SQLactivate_errormsg
#define SQLerrormsg_deactivate   SQLdeactivate_errormsg


/*----------------------------------------------------------------------*/
/*-                      Global Variables                              -*/
/*----------------------------------------------------------------------*/

extern bool SQLerrormsg_active;
extern sqlite3 *SQLdb;
extern sqlite3_stmt *SQLstatement;
//extern const char *SQLtail;
extern int SQLerror;
extern bool SQLisopen;

/*----------------------------------------------------------------------*/
/*-                        Procedures                                  -*/
/*----------------------------------------------------------------------*/



int SQLcommit ( void );
int SQLexec ( const char *querystr );
int SQLcount ( const char *field, const char* table, const char* condition );
   // return the count, not the error value. this might not be required.

int SQLbegin_transaction ( void );
int SQLcommit_transaction ( void );

int SQLbackup ( const char *filename); // duplicate current database on a another file.
int SQLopentemp_from_dataobj ( const char *filename, const char *objectname );
int SQLclosetemp ( void );

int SQLopen ( const char* filename );
int SQLclose ( void );
void SQLactivate_errormsg (void);
void SQLdeactivate_errormsg (void);



int SQLprepare (const char *querystr );
int SQLpreparef ( const char *format, ... );
int SQLstep (void);
int SQLfinalize (void);
void SQLerrormsg ( void );
int SQLcolumn_int ( int colID );
const char* SQLcolumn_text ( int colID);
const void* SQLcolumn_blob ( int colID );

int SQLbind_blob ( const void* buffer, int size, int index );

// using an non-default database

/*int SQLcommit ( sqlite3 *exSQLdb );
int SQLopen ( sqlite3 **exSQLdb, const char* filename );
int SQLclose ( sqlite3 *exSQLdb );

int SQLprepare (sqlite3 *exSQLdb, sqlite3_stmt **exSQLstatement, const char *querystr );
int SQLpreparef (sqlite3 *exSQLdb, sqlite3_stmt **exSQLstatement, const char *format, ... );
int SQLstep (sqlite3_stmt *exSQLstatement);
int SQLfinalize (sqlite3 *exSQLdb, sqlite3_stmt *exSQLstatement);
void SQLerrormsg ( sqlite3 *exSQLdb );
int SQLcolumn_int ( sqlite3_stmt *exSQLstatement, int colID );
const char* SQLcolumn_text ( sqlite3_stmt *exSQLstatement, int colID);*/






#endif // SQLWRAP_H_INCLUDED
