#ifndef OBJECTS_H
#define OBJECTS_H

/*
 * x - vector x
 * y - vector y
 * m - magnitude (length of the vector)
 */
typedef struct vector {
        float x; 
        float y;
        float m;
} vector;

/*
 * x1 - beginning x
 * y1 - beginning y
 * x2 - end x
 * y2 - end y
 * l  - live
 */

typedef struct line {
        float x1;
        float y1;
        float x2;
        float y2;
        int l;
} line;


/*
 * x - top left pos
 * y - top left pos
 * l - live
 * s - score
 * c - colour
 * h - hits
 * bl - array of lines froming a square
 */
typedef struct block {
        float x;
        float y;
        int l;
        int s;
        int c;
        int h;
        line bl[4];
} block;

/*
 * x - middle x
 * y - middle y
 * a - angle
 * m - length (magnitude)
 * l - struct line
 */
typedef struct paddle {
        float x;
        float y;
        float a;
        float m;
        line l;
} paddle;

/*
 * x  - pos x
 * y  - pos y
 * ns - normal speed
 * s  - speed
 * a  - angle
 * w  - width
 * h  - height
 * l  - live
 * t  - type(0 = normal ball, 1 = multi-ball)
 * c  - collided
 * cp - index of the paddle the ball collided with
 * v  - struct vector 
 */
typedef struct ball {
        float x;
        float y;
        float ns;
        float s;
        float w;
        float h;
        int l;
        int t;
        int c;
        int cp;
        vector v;
} ball;

typedef struct player {
        int score;
        int lives;
        int level;
        int new_game;
        int dead;
        int death_counter;
        int skill_multi;
        int skill_net;
        int skill_slow;
        int skill_boost;
        int song_started;
} player;

/* ball functions */
void ini_balls(ball *b, int n, float s);
void update_balls(ball *b, int n);
void mod_vectors(ball *b, float rx1, float ry1, float rx2, float ry2);
void spawn_multi_ball(ball *b, int n);
void set_ball_speed(ball *b, int n, float s);

/* block functions */
void ini_blocks(block *b, int n);

/* paddle functions */
void ini_paddles(paddle *p, int n);
void update_angle(paddle *p, float mod, int n);
void update_positions(paddle *p, int n);
void move_paddles(paddle *p, float mod);

/* line */
void ini_lines(line *l);
void set_live(line *l, int n);

/* player functions */
void ini_player(player *p);
void update_multi_skill(player *p);
void update_net_skill(player *p, line *l);
void update_slow_skill(player *p, ball *b, int n);
void update_boost_skill(player *p);

/* other functions */
float radians(float degrees);
float degrees(float radians);
float map(float x, float in_min, float in_max, float out_min, float out_max);

#endif
