#include <stdio.h>
#include <math.h>
#include "objects.h"
#include "vector.h"
#include "collisions.h"

/* init blocks */
void ini_blocks(block *b, int n)
{
        size_t i;
        
        for(i = 0; i < n; i++) {
                b[i].x = 0;
                b[i].y = 0;
                b[i].l = 0;
                b[i].c = 1;
        }
}

/* init lines */
void ini_lines(line *l)
{

        /* top left corner, bottom to top */
        l[0].x1 = 0;
        l[0].y1 = 118;
        l[0].x2 = 96;
        l[0].y2 = 40;
        l[0].l = 1;

        /* top right corner, bottom to top */
        l[1].x1 = 800;
        l[1].y1 = 118;
        l[1].x2 = 704;
        l[1].y2 = 40;
        l[1].l = 1;

        /* lower left corner, bottom to top */
        l[2].x1 = 96;
        l[2].y1 = 560;
        l[2].x2 = 0;
        l[2].y2 = 482;
        l[2].l = 1;

        /* lower right corner, bottom to top */
        l[3].x1 = 704;
        l[3].y1 = 560;
        l[3].x2 = 800;
        l[3].y2 = 482;
        l[3].l = 1;

        /* bottom line, left to right */
        l[4].x1 = 95;
        l[4].y1 = 559;
        l[4].x2 = 705;
        l[4].y2 = 559;
        l[4].l = 0;

        /* top line, left to right */
        l[5].x1 = 95;
        l[5].y1 = 41;
        l[5].x2 = 705;
        l[5].y2 = 41;
        l[5].l = 0;

        /* left line, bottom to top */
        l[6].x1 = 1;
        l[6].y1 = 482;
        l[6].x2 = 1;
        l[6].y2 = 118;
        l[6].l = 0;

        /* right line, bottom to top */
        l[7].x1 = 800;
        l[7].y1 = 482;
        l[7].x2 = 800;
        l[7].y2 = 118;
        l[7].l = 0;
} /* end ini_lines*/

/* modifies the live parameter for lindes 4 - 7 */
void set_live(line *l, int n)
{
        size_t i;
        
        /* iterate trough 4 - 7 */
        for(i = 4; i < 8; i++) {
               l[i].l = n; 
        }

} /* end set_live */

/* init balls */
void ini_balls(ball *b, int n, float s)
{
        size_t i;

        for(i = 0; i < n; i++) {
                
                b[i].w = 2;
                b[i].h = 2;
                b[i].c = 0;
                b[i].ns = s;
                
                /* 0 is the player ball */
                if(i < 1) {
                        b[i].x = 390;
                        b[i].y = 528;
                        b[i].s = b[i].ns;
                        b[i].l = 1;
                        b[i].t = 0;
                        b[i].v.x = -0.1;
                        b[i].v.y = 0.3;
                } else {
                        b[i].x = 0;
                        b[i].y = 0;
                        b[i].s = b[i].ns;
                        b[i].l = 0;
                        b[i].t = 1;
                        b[i].v.x = 0.0;
                        b[i].v.y = 0.0;
                }
        }
} /* end ini_ball */

/* spawn the multi balls */
void spawn_multi_ball(ball *b, int n)
{
        size_t i;
        
        /* multi-balls are indexed 1 - 3 */
        for(i = 1; i < n; i++) {
                
                /* only spawn non-live balls */
                if(!b[i].l) {
                        
                        /* multi-balls should originate from the player ball */
                        b[i].l = 1;
                        b[i].x = b[0].x;
                        b[i].y = b[0].y;
                        
                        /* mod vectors of the multi-balls */
                        switch(i) {
                                case 1:
                                        b[i].v.x = b[0].v.x + 0.1;
                                        b[i].v.y = b[0].v.y + 0.1;
                                        break;
                                case 2:
                                        b[i].v.x = b[0].v.x - 0.1;
                                        b[i].v.y = b[0].v.y + 0.1;
                                        break;
                                case 3:
                                        b[i].v.x = b[0].v.x - 0.1;
                                        b[i].v.y = b[0].v.y - 0.1;
                                        break;
                        }
                }
        }
} /* end spawn_multi_ball */

/* set the speed of all balls to s */
void set_ball_speed(ball *b, int n, float s)
{
        size_t i;
        
        for(i = 0; i < n; i++) {
                
                /* only slow live balls */
                if(b[i].l) 
                        b[i].s = s;
        }
} /* end set_ball_speed */

/* update the position of all balls */
void update_balls(ball *b, int n)
{
        size_t i;
        
        /* iterate through all balls */
        for(i = 0; i < n; i++) {
                
                /* only update live balls */
                if(b[i].l) {
                
                         /* get the magnitude of the balls vector */
                        b[i].v.m = get_magnitude(&b[i].v);
                        
                        /* 
                         * normalize the vectors x and y by dividing them 
                         * with the length, this is so that the length of 
                         * the vector should not affect the speed 
                         */
                        b[i].x += b[i].s * (b[i].v.x / b[i].v.m);
                        
                        /* negates the y since y goes up in vector math */
                        b[i].y += -1 * (b[i].s * (b[i].v.y / b[i].v.m));
                }
        }
} /* end update_ball_vectors */

/* modify ball vectors on collision */
void mod_vectors(ball *b, float rx1, float ry1, float rx2, float ry2)
{
        /* create surface and reflection vectors */
        vector v, r;
        
        /* ini vectors */
        v.x = rx2 - rx1;
        v.y = -1 * (ry2 - ry1);
        r.x = 0.0;
        r.y = 0.0;

        /* reflect vector a against b updating vector r */
        reflect(b, &v, &r);

        /* set ball vectors to the reflection vector */
        b->v.x = r.x;
        b->v.y = r.y;
        //puts("vectors reflected");

} /* end mod_vectors */

/* init paddles */
void ini_paddles(paddle *p, int n)
{
        int width = 800;
        int height = 600;
        size_t i;

        /* set the length of all paddles */
        for(i = 0; i < n; i++) {
                p[i].m = 40;
        }
        
        /* bottom paddle */
        p[0].x = width / 2;
        p[0].y = 532;
        p[0].a = 0;

        /* top paddle */
        p[1].x = width / 2;
        p[1].y = 68;
        p[1].a = 0;

        /* left paddle */
        p[2].x = 28;
        p[2].y = 280;
        p[2].a = 270;

        /* right paddle */
        p[3].x = 772;
        p[3].y = 280;
        p[3].a = 270;
} /* end ini_paddles */

/* updates the angle of the paddles */
void update_angle(paddle *p, float mod, int n)
{
        size_t i;

        for(i = 0; i < n; i++) {

                /* top and bottom paddles */
                if(i <= 1) {

                        /*
                         * less than 0 should by 360 and
                         * greater than 360 should be 0
                         */
                        if(p[i].a + mod <= 0)
                                p[i].a = 360;
                        else if(p[i].a + mod > 360)
                                p[i].a = 0;

                        p[i].a += mod;

                        /* angle boundries */
                        if(p[i].a <= 41 && p[i].a >= 40)
                                p[i].a = 40;
                        else if(p[i].a >= 319 && p[i].a <= 320)
                                p[i].a = 320;

                /* left and right paddle */
                } else {

                        p[i].a += mod;

                        /* angle boundries */
                        if(p[i].a >= 229 && p[i].a <= 230)
                                p[i].a = 230;
                        else if(p[i].a <= 311 && p[i].a >= 310)
                                p[i].a = 310;
                }
        }
} /* end update_angle */

/* updates px and py bsed on the angle */
void update_positions(paddle *p, int n)
{
        size_t i;

        /* all paddles are updated the same way */
        for(i = 0; i < n; i++) {
                p[i].l.x1 = p[i].x + p[i].m * cos(radians(p[i].a));
                p[i].l.y1 = p[i].y + p[i].m * sin(radians(p[i].a));
                p[i].l.x2 = p[i].x - p[i].m * cos(radians(p[i].a));
                p[i].l.y2 = p[i].y - p[i].m * sin(radians(p[i].a));
        }
} /* end update_positions */

/* update the cords of the paddles */
void move_paddles(paddle *p, float mod)
{
        /*
         * top paddle follows bottom paddle, left paddle is mapped to bottom
         * paddle and right paddle is opposite of the left paddle
         */
        p[0].x += mod;
        p[1].x = p[0].x;
        p[2].y = map(p[0].x, 128, 672, 150, 450);
        p[3].y = 600 - p[2].y;

        /* left stop */
        if(p[0].x <= 128)
                p[0].x = 128;

        /* right stop */
        if(p[0].x >= 672)
                p[0].x = 672;
} /* end move_paddles */

/* init player */
void ini_player(player *p)
{
        p->score = 0;
        p->lives = 3;
        p->level = 1;
        p->new_game = 0;
        p->skill_multi = 0;
        p->skill_net = 0;
        p->skill_slow = 0;
        p->skill_boost = 0;
        p->song_started = 0;
} /* end ini_player */

/* handle updating the multi skill */
void update_multi_skill(player *p)
{

        p->skill_multi--;
        
        /* skill off cooldown */
        if(p->skill_multi <= 0)
                p->skill_multi = 0;
} /* end update_multi_skill */

/* handle updating the net skill */
void update_net_skill(player *p, line *l)
{
        p->skill_net--;
        
        /* kill safety nets */
        if(p->skill_net == 2900)
                set_live(l, 0);
        
        /* Skill off cooldown */
        if(p->skill_net <= 0)
                p->skill_net = 0;
} /* end update_net_skill */

/* update the slow skill */
void update_slow_skill(player *p, ball *b, int n)
{
        p->skill_slow--;
        
        /* speed back to normal */
        if(p->skill_slow == 400)
                set_ball_speed(b, n, b[0].ns);
        
        /* Skill off cooldown */
        if(p->skill_slow <= 0)
                p->skill_slow = 0;
}

/* update the score boost skill */
void update_boost_skill(player *p)
{
        p->skill_boost--;
        
        /* Skill off cooldown */
        if(p->skill_boost <= 0)
                p->skill_boost = 0;
} /* end update_boost_skill */

/* maps the min and max */
float map(float x, float in_min, float in_max, float out_min, float out_max)
{
        return (x - in_min) * (out_max - out_min) / (in_max - in_min) + out_min;
}

/* converts radians to degrees */
float degrees(float radians)
{
        float degrees = radians * (180 / M_PI); 
        
        return degrees;
}

/* converts degrees to radians */
float radians(float degrees)
{
        float radians = degrees * (M_PI / 180);
        
        return radians; 
}