#include <allegro5/allegro.h>
#include <stdio.h>
#include "visuals.h"
#include "objects.h"
#include "collisions.h"
#include "levels.h"
#include "audio.h"

/* constants */

/* enum states and keys*/
enum STATE {MENU, PLAYING, PREPARE, DEATH, ESCAPED, GAMEOVER};
enum KEYS {UP, DOWN, LEFT, RIGHT, SPACE, ENTER, ONE};

/* function prototypes */
void new_game(player *p, ball *b, line *l, paddle *pl, int nb, int np, float bs);
void init_board(player *p, ball *b, line *l, paddle *pl, int nb, int np, float bs);

int main()
{
        float w = 800;
        float h = 600;
        int redraw = 1;
        int keys[] = {0,0,0,0,0};
        int state = MENU;
        int fps = 60;
        int done = 0;
        int hi_score = 0;
        int death_counter = 0;
        int escape_counter = 0;
        int bonus_counter = 0;
        float mod_x = 0.0;
        float mod_angle = 0.0;
        float paddle_speed = 1.0;
        float ball_speed = 1.5;
        int n_balls = 4;
        int n_paddles = 4;
        int n_lines = 8;
        int n_blocks = 180;
                
        /* Game objects */
        ball balls[n_balls];
        player player;
        paddle paddles[n_paddles];
        line lines[n_lines];
        block blocks[n_blocks];
        
        /* Allegro objects */
        ALLEGRO_DISPLAY *display = NULL;
        ALLEGRO_EVENT_QUEUE *event_queue = NULL;
        ALLEGRO_TIMER *timer = NULL;
        
        /* Init allegro */
        al_init();
        display = al_create_display(w, h);
        al_install_keyboard();
        al_install_mouse();
        ini_allegro_addon();
        ini_allegro_colors();
        ini_allegro_fonts();
        ini_allegro_audio();
        ini_allegro_sounds();
        
        /* init game objects */
        ini_balls(balls, n_balls, ball_speed);
        ini_player(&player);
        ini_paddles(paddles, n_paddles);
        ini_lines(lines);
        ini_blocks(blocks, n_blocks);
        
        /* Hide the mouse */
        al_hide_mouse_cursor(display);
        
        /* event queue and timers */
        event_queue = al_create_event_queue();
        timer = al_create_timer(1.0 / fps);
        al_register_event_source(event_queue, 
                al_get_keyboard_event_source());
        al_register_event_source(event_queue, 
                al_get_display_event_source(display));
        al_register_event_source(event_queue, 
                al_get_timer_event_source(timer)); 
        al_register_event_source(event_queue, 
                al_get_mouse_event_source());
        al_start_timer(timer);

        /* Game loop*/
        while(!done) {
                ALLEGRO_EVENT ev;
                al_wait_for_event(event_queue, &ev);

                /* Do processing here*/
                if(ev.type == ALLEGRO_EVENT_TIMER) {
                        
                        if(state == MENU) {
                        
                        } else if(state == DEATH) {
                                
                                /* kill the song */
                                if(song_playing())
                                        stop_song();
                                
                                death_counter--;
                                
                                if(death_counter <= 0) {
                                        
                                        player.lives--;
                                        
                                        /* 
                                         * game lost, set state to gameover, 
                                         * else prepare board for play 
                                         */
                                        if(player.lives <= 0) {
                                                
                                                /* updates hi score */
                                                if(player.score > hi_score)
                                                        hi_score = player.score;
                                                
                                                state = GAMEOVER;
                                        } else {
                                                init_board(&player, balls, lines, paddles, n_balls, n_paddles, ball_speed);
                                                state = PREPARE;
                                        }
                                }
                        
                        } else if(state == ESCAPED) {
                                
                                /* kill the song */
                                if(song_playing())
                                        stop_song();
                                
                                escape_counter--;
                                
                                /* kills the remaining blocks */
                                if(blocks[escape_counter].l) {
                                        blocks[escape_counter].l = 0;
                                        player.score += blocks[escape_counter].c;
                                        ply_sound(3);
                                }

                                if(escape_counter <= 0) {
                                        
                                        /*
                                         * Increase the level, setup the level 
                                         * and put the game in prepare
                                         */
                                        player.level++;
                                        
                                        /* 
                                         * start over with increased 
                                         * ball speed 
                                         */
                                        if(player.level > 10) {
                                                
                                                /* null level */
                                                player.level = 1;
                                                
                                                /* increatse speed by 0.5 */
                                                ball_speed += 0.5;

                                                /* cap speed at 4 */
                                                if(ball_speed > 4)
                                                        ball_speed = 4;
                                        }

                                        setup_level(blocks, n_blocks, player.level);
                                        init_board(&player, balls, lines, paddles, n_balls, n_paddles, ball_speed);
                                        state = PREPARE;
                                }
                                
                                
                        } else if(state == PREPARE) {

                                /* new game */
                                if(player.new_game) {
                                        new_game(&player, balls, lines, paddles, 
                                                n_balls, n_paddles, ball_speed);
                                        player.new_game = 0;
                                        setup_level(blocks, n_blocks, player.level);
                                }
                                
                                update_angle(paddles, mod_angle, n_paddles);
                                update_positions(paddles, n_paddles);
                                move_paddles(paddles, mod_x);
                                
                                /* start the song if it is not playing */
                                if(!song_playing())
                                        ply_sound(4);
                                
                        } else if(state == PLAYING) {

                                /* Update game objects*/
                                update_balls(balls, n_balls);
                                update_angle(paddles, mod_angle, n_paddles);
                                update_positions(paddles, n_paddles);
                                move_paddles(paddles, mod_x);
                                update_multi_skill(&player);
                                update_net_skill(&player, lines);
                                update_slow_skill(&player, balls, n_balls);
                                update_boost_skill(&player);
                                
                                /* check for collisions after update */
                                col_paddles(balls, paddles);
                                col_lines(balls, lines);
                                col_blocks(balls, blocks, &player, n_balls, n_blocks);
                                
                                /* 
                                 * if player ball is out of board, set 
                                 * state to DEATH 
                                 */
                                if(out_of_board(balls, n_balls)) {
                                        death_counter = 100;
                                        state = DEATH;
                                }
                                
                                /*
                                 * if player ball hit the escape pad, set 
                                 * state to ESCAPED
                                 */
                                if(hit_escape(balls, n_balls)) {
                                        escape_counter = 180;
                                        state = ESCAPED;
                                } 
                                
                        } else if(state == GAMEOVER) {
     
                        }
                        
                        /* set redraw flag */
                        redraw = 1;

                /* key down events */ 
                } else if(ev.type == ALLEGRO_EVENT_KEY_DOWN) {
                        
                        /* switch on which key is being pressed */
                        switch(ev.keyboard.keycode) {
                                
                                /* key space, down event */
                                case ALLEGRO_KEY_SPACE:
                                        if(state == MENU) {
                                                
                                                player.new_game = 1;
                                                state = PREPARE;
                                                
                                        } else if(state == PREPARE) {
                                                
                                                state = PLAYING;
                                                
                                        } else if(state == PLAYING) {
                                                
                                                  
                                        } else if(state == GAMEOVER) {
                                                state = MENU; 
                                        }
                                        break;
                                
                                /* escape always ends the game */
                                case ALLEGRO_KEY_ESCAPE:
                                        if(state == PLAYING || state == MENU || 
                                                state == GAMEOVER || 
                                                        state == PREPARE)
                                                done = 1;
                                        
                                        break;
                                        
                                /* key left, down event */        
                                case ALLEGRO_KEY_LEFT:
                                        keys[LEFT] = 1;
                                        break;
                                        
                                /* key right, down event */
                                case ALLEGRO_KEY_RIGHT:
                                        keys[RIGHT] = 1;
                                        break;
                                
                                /* key up, down event */
                                case ALLEGRO_KEY_UP:
                                        keys[UP] = 1;
                                        break;
                                
                                /* key down, down event */
                                case ALLEGRO_KEY_DOWN:
                                        keys[DOWN] = 1;
                                        break;
                                        
                                /* key one, down event */
                                case ALLEGRO_KEY_1:
                                        
                                        /* key 1 function during playing */
                                        if(state == PLAYING) {
                                                
                                                /* active if off cooldown */
                                                if(player.skill_slow == 0) {
                                                        set_ball_speed(balls, n_balls, 0.5);
                                                        player.skill_slow = 500;
                                                }
                                        }
                                        break;
                                
                                /* key two, down event */
                                case ALLEGRO_KEY_2:
                                        
                                        /* key 2 function during playing */
                                        if(state == PLAYING) {
                                        
                                                /* active if off cooldown */
                                                if(player.skill_boost == 0) {
                                                        player.skill_boost = 1000;
                                                }
                                        }
                                        break;
                                
                                /* key three, down event */
                                case ALLEGRO_KEY_3:
                                        
                                        /* key 3 function during playing */
                                        if(state == PLAYING) {
                                        
                                                /* active if off cooldown */
                                                if(player.skill_multi == 0) {
                                                        spawn_multi_ball(balls, n_balls);
                                                        player.skill_multi = 4000;
                                                }
                                        }
                                        break;
                                
                                /* key three, down event */
                                case ALLEGRO_KEY_4:
                                
                                        /* key 1 function during playing */
                                        if(state == PLAYING) {
                                                
                                                /* active if off cooldown */
                                                if(player.skill_net == 0) {
                                                        set_live(lines, 1);
                                                        player.skill_net = 3000;
                                                }
                                        }
                                        break;
                                
                                
                        } /* end switch keycode */
                
                /* end key down */
                
                /* key up events */
                } else if(ev.type == ALLEGRO_EVENT_KEY_UP) {
                        
                        /* switch on which key is being pressed */
                        switch(ev.keyboard.keycode) {
                                
                                /* key left, up event */
                                case ALLEGRO_KEY_LEFT:
                                        keys[LEFT] = 0;
                                        break;
                                
                                /* key right, up event */
                                case ALLEGRO_KEY_RIGHT:
                                        keys[RIGHT] = 0;
                                        break;
                                        
                                /* key up, up event */
                                case ALLEGRO_KEY_UP:
                                        keys[UP] = 0;
                                        break;

                                /* key down, up event */
                                case ALLEGRO_KEY_DOWN:
                                        keys[DOWN] = 0;
                                        break;
                        } /* end switch keycode */
                
                /* end key up */
                
                } else if(ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE) {    
                        
                        /* ext if red cross has been clicked */
                        done = 1;
                }
                
                /* process key states */
                if(keys[UP]) {
                        
                        /* key UP function during playing */
                        if(state == PLAYING)
                                mod_angle = -1 * 0.5;
                        
                }
                
                if(keys[DOWN]) {
                        
                        /* key DOWN function during playing */
                        if(state == PLAYING)
                                mod_angle = 0.5;
                }

                if(!keys[UP] && !keys[DOWN]) {
                        mod_angle = 0.0;
                }
                
                if(keys[LEFT]) {
                        
                        /* key LEFT function during playing */
                        if(state == PLAYING)
                                mod_x = -1 * paddle_speed;
                } 
                
                if(keys[RIGHT]) {
                        
                        /* key RIGHT function during playing */
                        if(state == PLAYING)
                                mod_x = paddle_speed;
                } 
                
                if(!keys[LEFT] && !keys[RIGHT]) {
                        mod_x = 0.0;
                }

                /* end key states */
                
                /* Do all graphics here*/
                if(redraw && al_is_event_queue_empty(event_queue)) {
                        
                        /* switch redraw flag */
                        redraw = 0;
                        
                        if(state == MENU) {
                                /* draw menu */
                                draw_menu(hi_score);
                                
                        } else if(state == DEATH || state == PREPARE || 
                                  state == ESCAPED || state == PLAYING) {
                                
                                /* Draw game objects*/
                                draw_balls(balls, n_balls);
                                draw_paddles(paddles, n_paddles);
                                draw_lines(lines, n_lines);
                                
                                /* Draw background */
                                draw_rim();
                                draw_player_stats(&player);
                                draw_player_skills(&player);
                                draw_escape();
                                draw_blocks(blocks, n_blocks);
                                //draw_grid();
                                
                        } else if(state == GAMEOVER) {
                                
                                /* draw game over */
                                draw_gameover();
                        }
                        
                        /* double buffering */
                        al_flip_display();
                        
                        /* set the background colours */
                        if(state == MENU)
                                al_clear_to_color(al_map_rgb(112, 146, 190));
                        
                        else if(state == GAMEOVER)
                                al_clear_to_color(al_map_rgb(195, 195, 195));
                        
                        else
                                al_clear_to_color(al_map_rgb(0, 0, 0));
                } /* end graphics*/
        } /* end game loop */

        al_destroy_display(display);
        al_destroy_timer(timer);
        al_destroy_event_queue(event_queue);
        destroy_audio();
        
        return 0;
} /* end main */

/* initializes all game objects for a new game */
void new_game(player *p, ball *b, line *l, paddle *pl, int nb, int np, float bs)
{
        bs = 1.5;
        ini_balls(b, nb, bs);
        ini_player(p);
        ini_paddles(pl, np);
        ini_lines(l);
}

/* initializes the board */
void init_board(player *p, ball *b, line *l, paddle *pl, int nb, int np, float bs)
{
        ini_balls(b, nb, bs);
        ini_paddles(pl, np);
        ini_lines(l);        
        p->skill_multi = 0;
        p->skill_net = 0;
        p->skill_slow = 0;
        p->skill_boost = 0;
}