#ifndef COLLISIONS_H
#define COLLISIONS_H
#include <stdio.h>
#include <math.h>
#include "objects.h"
#include <allegro5/allegro_primitives.h>

/* collision functions */
int isect(float x1, float y1, float x2, float y2, 
           float x3, float y3, float x4, float y4);     

/* paddle functions */
void col_paddles(ball *b, paddle *p);

/* block functions */
void col_blocks(ball *b, block *bl, player *p, int n, int nb);

/* line functions */
void col_lines(ball *b, line *l);

/* board function */
int out_of_board(ball *b, int n);
int hit_escape(ball *b, int n);

/* other functions*/
int closest_block(float bx, float by, block *bl, int n);
float distance(float x1, float y1, int x2, int y2);
#endif
