#include "visuals.h"

/* declare font */
ALLEGRO_FONT *FONT18;
ALLEGRO_FONT *FONT36;
ALLEGRO_FONT *FONT72;

/* declare colors */
ALLEGRO_COLOR BLACK;
ALLEGRO_COLOR WHITE;
ALLEGRO_COLOR DARK_RED;
ALLEGRO_COLOR RED;
ALLEGRO_COLOR LIGHT_RED;
ALLEGRO_COLOR GREEN;
ALLEGRO_COLOR ORANGE;
ALLEGRO_COLOR YELLOW;
ALLEGRO_COLOR GREY;
ALLEGRO_COLOR BROWN;
ALLEGRO_COLOR MAGENTA;

/* init allegro addons */
void ini_allegro_addon()
{
    al_init_primitives_addon();
    al_init_font_addon();
    al_init_ttf_addon();
    al_init_image_addon();
}

/* init allegro colors */
void ini_allegro_colors()
{
        BLACK = al_map_rgb(0, 0, 0);
        WHITE = al_map_rgb(255, 255, 255);
        DARK_RED = al_map_rgb(64, 0, 0); 
        RED = al_map_rgb(136, 0, 21);
        LIGHT_RED = al_map_rgb(255, 106, 111);
        GREEN = al_map_rgb(34, 177, 76);
        ORANGE = al_map_rgb(255, 127, 39);
        YELLOW = al_map_rgb(255,242,0);
        GREY = al_map_rgb(85, 85, 85);
        BROWN = al_map_rgb(185, 122, 87);
        MAGENTA = al_map_rgb(255, 0, 255);
}

/* init allegro font */
void ini_allegro_fonts()
{
    FONT18 = al_load_font("digital.ttf", 18, 0);
    FONT36 = al_load_font("digital.ttf", 36, 0);
    FONT72 = al_load_font("digital.ttf", 72, 0);
}

/* draw all balls */
void draw_balls(ball *b, int n)
{
        size_t i;
        
        for(i = 0; i < n; i++) {
                
                /* draw only live balls */
                if(b[i].l) {
                        
                        /* players ball is white */
                        if(b[i].t == 0) {
                                al_draw_filled_circle(rd(b[i].x), rd(b[i].y),
                                        b[i].w, WHITE);
                        
                        /* multi ball is green */
                        } else {
                                al_draw_filled_circle(rd(b[i].x), rd(b[i].y),
                                        b[i].w, ORANGE);
                        }
                }
        }
} /* end draw balls*/

/* draw all the paddles */
void draw_paddles(paddle *p, int n)
{
        size_t i;
        
        for(i = 0; i < n; i++) {
                al_draw_line(rd(p[i].l.x1), rd(p[i].l.y1), 
                        rd(p[i].l.x2), rd(p[i].l.y2), WHITE, 1);
                al_draw_filled_circle(rd(p[i].x), rd(p[i].y), 2, RED);
                al_draw_filled_circle(rd(p[i].l.x1), rd(p[i].l.y1), 2, GREEN);
                al_draw_filled_circle(rd(p[i].l.x2), rd(p[i].l.y2), 2, GREEN);
        }
} /* end draw_paddles */

/* draw the top and bottom rim */
void draw_rim()
{
        /* top rim */
        al_draw_filled_rectangle(0, 0, 800, 40, RED);
        
        /* bottom rim */
        al_draw_filled_rectangle(0, 560, 800, 600, RED);
        
        /* top lines */
        al_draw_line(0, 1, 800, 1, WHITE, 1);
        al_draw_line(0, 40, 800, 40, WHITE, 1);
        
        /* bottom lines */
        al_draw_line(0, 560, 800, 560, WHITE, 1);
        al_draw_line(0, 600, 800, 600, WHITE, 1);
}

/* draw player stats and skill cooldowns */
void draw_player_stats(player *p)
{
        al_draw_textf(FONT36, WHITE, 5, -5, ALLEGRO_ALIGN_LEFT,
                "SCORE: %i", p->score);
                
        al_draw_textf(FONT36, WHITE, 400, -5, ALLEGRO_ALIGN_CENTRE,
                "LIVES: %i", p->lives);
                
        al_draw_textf(FONT36, WHITE, 661, -5, ALLEGRO_ALIGN_LEFT,
                "LEVEL: %i", p->level);
}

/* draw all lines */
void draw_lines(line *l, int n)
{
        size_t i;
        
        /* iterate through all lines */
        for(i = 0; i < n; i++) {
                
                /* only draw live ones */
                if(l[i].l) {
                        
                        if(i < 4) {
                                al_draw_line(l[i].x1, l[i].y1, l[i].x2, l[i].y2,
                                        WHITE, 1);
                        } else {
                                al_draw_line(l[i].x1, l[i].y1, l[i].x2, l[i].y2,
                                        BROWN, 2);
                        }
                }
        }
} /* end draw_lines */

/* draw all skills */
void draw_player_skills(player *p)
{
        
        /* white if off cooldown */
        if(p->skill_slow == 0) {
                al_draw_text(FONT36, WHITE, 5, 555, ALLEGRO_ALIGN_LEFT, 
                        "1: SLOW");
        } else {
                al_draw_text(FONT36, GREY, 5, 555, ALLEGRO_ALIGN_LEFT, 
                        "1: SLOW");
        }
        
        /* white if off cooldown */
        if(p->skill_boost == 0) {
                al_draw_text(FONT36, WHITE, 225, 555, ALLEGRO_ALIGN_LEFT, 
                        "2: BOOST");
        } else {
                al_draw_text(FONT36, GREY, 225, 555, ALLEGRO_ALIGN_LEFT, 
                        "2: BOOST");
        }
        
        /* white if off cooldown */
        if(p->skill_multi == 0) {
                al_draw_text(FONT36, WHITE, 475, 555, ALLEGRO_ALIGN_LEFT, 
                        "3: MULTI");
        } else {
                al_draw_text(FONT36, GREY, 475, 555, ALLEGRO_ALIGN_LEFT, 
                        "3: MULTI");
        }
        
        /* white if off cooldown */
        if(p->skill_net == 0) {
                al_draw_text(FONT36, WHITE, 705, 555, ALLEGRO_ALIGN_LEFT, 
                        "4: NET");
        } else {
                al_draw_text(FONT36, GREY, 705, 555, ALLEGRO_ALIGN_LEFT, 
                        "4: NET");
        }
} /* end draw skills*/

/* draw escape pad */
void draw_escape()
{
        int w = 800;
        int h = 600;
        
        al_draw_rectangle(w / 2 - 30, h / 2 - 10, w / 2 + 30, h / 2 + 10, 
                WHITE, 1);
        
        al_draw_text(FONT18, GREEN, w / 2, h / 2 - 13, ALLEGRO_ALIGN_CENTRE, 
                        "ESCAPE");
}

/* draw all blocks */
void draw_blocks(block *b, int n)
{
        size_t i;
        
        /* iterate through all blocks */
        for(i = 0; i < n; i++) {
                
                /* only draw live blocks */
                if(b[i].l) {
                        
                        /* switch on colour */
                        switch(b[i].c) {
                                case 1:
                                        /* Draw a brown block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 DARK_RED);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                                case 2:
                                        /* Draw a red block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 RED);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                                case 3:
                                        /* Draw a light red block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 LIGHT_RED);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                                case 4:
                                        /* Draw a orange block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 ORANGE);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                                case 5:
                                        /* Draw a light red block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 YELLOW);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                                case 6:
                                        /* Draw a yellow block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 GREEN);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                                case 7:
                                        /* Draw a grey block */
                                        al_draw_filled_rectangle(b[i].x, 
                                                                 b[i].y, 
                                                                 b[i].x + 32, 
                                                                 b[i].y + 26, 
                                                                 GREY);
                                        
                                        /* with a black rim */
                                        al_draw_rectangle(b[i].x, 
                                                          b[i].y, 
                                                          b[i].x + 32, 
                                                          b[i].y + 26, 
                                                          BLACK,
                                                          1);
                                        break;
                        }
                }
        }
}

/* draw the menu */
void draw_menu(int n)
{
        
                        
        al_draw_text(FONT72, GREY, 403, 55, ALLEGRO_ALIGN_CENTRE, 
                "BREAKOUT");
        al_draw_text(FONT72, BLACK, 400, 50, ALLEGRO_ALIGN_CENTRE, 
                "BREAKOUT");
                        
        al_draw_text(FONT36, BLACK, 400, 150, ALLEGRO_ALIGN_CENTRE, 
                "LEFT ARROW: MOVE PADDLE LEFT");
        al_draw_text(FONT36, BLACK, 400, 190, ALLEGRO_ALIGN_CENTRE, 
                "RIGHT ARROW: MOVE PADDLE RIGHT");
        al_draw_text(FONT36, BLACK, 400, 230, ALLEGRO_ALIGN_CENTRE, 
                "UP/DOWN ARROW: TILTS THE PADDLE");
        
        al_draw_textf(FONT36, WHITE, 400, 300, ALLEGRO_ALIGN_CENTRE, 
                "HI SCORE: %i", n);
                
        al_draw_text(FONT36, BLACK, 400, 530, ALLEGRO_ALIGN_CENTRE, 
                "PRESS SPACE TO PLAY");
}


/* draw the game over */
void draw_gameover()
{
        
                        
        al_draw_text(FONT72, GREY, 403, 105, ALLEGRO_ALIGN_CENTRE, 
                        "GAME OVER");
        al_draw_text(FONT72, BLACK, 400, 100, ALLEGRO_ALIGN_CENTRE, 
                        "GAME OVER");
        al_draw_text(FONT36, BLACK, 400, 530, ALLEGRO_ALIGN_CENTRE, 
                "PRESS SPACE TO CONTINUE");
}

/* draw a grid, for dev */
void draw_grid()
{
        size_t i;
        
        for(i = 40; i <= 560; i += 26) {
                al_draw_line(0, i, 800, i, MAGENTA, 1);
        }
        
        for(i = 0; i <= 800; i += 32) {
                al_draw_line(i, 0, i, 600, MAGENTA, 1);
        }
}

/* round to the nearest whole */
int rd(float n)
{
        return (int)(n + 0.5);
}