#include <stdio.h>
#include <math.h>
#include "vector.h"

void reflect(ball *ball, vector *b, vector *r)
{
        
        /* Create the surface normal and projection vectors */
        vector n, p;
        
        /* get the surface normal vector */
        get_surface_normal(b, &n);
        n.m = get_magnitude(&n);
        p.m = get_magnitude(&p);
        
        /* Get the projection vector */
        project(ball, &n, &p);
        
        /* Double it, scale by 2 */
        scale(&p, 2);

        /*
         * The reflection vector is from the top of the projection
         * vector to the top of vector a. Calculating that is done
         * by vector subtraction
         */
        r->x = ball->v.x + (-1 * p.x);
        r->y = ball->v.y + (-1 * p.y);
        r->m = get_magnitude(r);
}

/* Calculates the surface normal vector of b */
void get_surface_normal(vector *b, vector *n)
{
        n->x = -1 * b->y;
        n->y = b->x;
        n->m = get_magnitude(n);
} /* get_surface_normal */

/* Gets the magnitude of the vector */
float get_magnitude(vector *v)
{
        return sqrt(v->x * v->x + v->y * v->y);
} /* get_magnitude */

/*
 * projects vector a onto vector b creating vector p
 * The idea is to create a scalar used to scale vector b
 * creating the projection vector.
 */
void project(ball *ball, vector *b, vector *p)
{
        float scalar;

        /* Get the scalar */
        scalar = dot(ball, b) / (b->m * b->m);

        /* scale vector p by scalar */
        p->x = scalar * b->x;
        p->y = scalar * b->y;
        
} /* end project

/* Returns the dot product of vector a and b*/
float dot(ball * ball, vector *b)
{
        return ball->v.x * b->x + ball->v.y * b->y;
} /* end dot*/

/* scales vector v by a factor of scalar */
void scale(vector *v, float scalar)
{
        v->x = scalar * v->x;
        v->y = scalar * v->y;
} /* end scale */