#include <stdio.h>
#include "levels.h"


/*
 * array of levels is 15 blocks wide and 12 blocks high, each number above
 * 0 is a live block of that color
 * 
 * 1 - red
 *
 */
int level01[180] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,
                    0,0,0,0,2,0,0,0,0,0,2,0,0,0,0,
                    0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,
                    0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,
                    0,0,0,0,0,3,0,0,0,3,0,0,0,0,0,
                    0,0,0,0,0,3,3,3,3,3,0,0,0,0,0,
                    0,0,0,0,2,0,0,0,0,0,2,0,0,0,0,
                    0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

int level02[180] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
                    0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,
                    0,0,0,0,3,4,4,7,4,4,3,0,0,0,0,
                    0,0,0,0,3,4,0,0,0,4,3,0,0,0,0,
                    0,0,0,0,3,4,0,0,0,4,3,0,0,0,0,
                    0,0,0,0,3,4,4,7,4,4,3,0,0,0,0,
                    0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,
                    0,0,0,0,0,0,0,2,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

int level03[180] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,
                    0,0,0,0,0,4,0,0,0,4,0,0,0,0,0,
                    0,0,0,0,5,0,0,0,0,0,5,0,0,0,0,
                    0,0,0,4,0,6,7,6,7,6,0,4,0,0,0,
                    0,0,3,0,0,7,0,0,0,7,0,0,3,0,0,
                    0,0,3,0,0,7,0,0,0,7,0,0,3,0,0,
                    0,0,0,4,0,6,7,6,7,6,0,4,0,0,0,
                    0,0,0,0,5,0,0,0,0,0,5,0,0,0,0,
                    0,0,0,0,0,4,0,0,0,4,0,0,0,0,0,
                    0,0,0,0,0,0,3,3,3,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

int level04[180] = {1,0,1,0,1,0,1,0,1,0,1,0,1,0,1,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,
                    0,7,0,7,0,0,7,7,7,0,0,7,0,7,0,
                    0,7,0,7,0,0,7,7,7,0,0,7,0,7,0,
                    3,0,3,0,3,0,3,0,3,0,3,0,3,0,3,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    0,2,0,2,0,2,0,2,0,2,0,2,0,2,0,
                    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
                    1,0,1,0,1,0,1,0,1,0,1,0,1,0,1};
                    
int level05[180] = {1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,
                    1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,
                    1,2,3,3,3,3,3,3,3,3,3,3,3,2,1,
                    1,2,3,4,4,4,4,4,4,4,4,4,3,2,1,
                    1,2,3,4,5,5,5,5,5,5,5,4,3,2,1,
                    1,2,3,4,5,6,7,7,7,6,5,4,3,2,1,
                    1,2,3,4,5,6,7,7,7,6,5,4,3,2,1,
                    1,2,3,4,5,5,5,5,5,5,5,4,3,2,1,
                    1,2,3,4,4,4,4,4,4,4,4,4,3,2,1,
                    1,2,3,3,3,3,3,3,3,3,3,3,3,2,1,
                    1,2,2,2,2,2,2,2,2,2,2,2,2,2,1,
                    1,1,1,1,1,1,1,1,1,1,1,1,1,1,1};

int level06[180] = {7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,0,2,2,2,2,2,2,2,2,2,2,2,0,7,
                    7,0,3,3,3,3,3,3,3,3,3,3,3,0,7,
                    7,0,4,4,4,4,4,4,4,4,4,4,4,0,7,
                    7,0,5,5,5,5,5,5,5,5,5,5,5,0,7,
                    7,0,5,5,5,5,5,5,5,5,5,5,5,0,7,
                    7,0,4,4,4,4,4,4,4,4,4,4,4,0,7,
                    7,0,3,3,3,3,3,3,3,3,3,3,3,0,7,
                    7,0,2,2,2,2,2,2,2,2,2,2,2,0,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,1,7,7,7,7,7,7,7,7,7,7,7,7,7};

int level07[180] = {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,
                    0,0,0,1,1,1,2,2,2,1,1,1,0,0,0,
                    0,0,1,2,2,2,3,3,3,2,2,2,1,0,0,
                    0,1,2,3,3,3,0,0,0,3,3,3,2,1,0,
                    0,1,2,3,0,0,0,0,0,0,0,3,2,1,0,
                    1,2,3,0,0,0,6,6,6 ,0,0,0,3,2,1,
                    1,2,3,0,0,0,6,6,6,0,0,0,3,2,1,
                    0,1,2,3,0,0,0,0,0,0,0,3,2,1,0,
                    0,1,2,3,3,3,0,0,0,3,3,3,2,1,0,
                    0,0,1,2,2,2,3,3,3,2,2,2,1,0,0,
                    0,0,0,1,1,1,2,2,2,1,1,1,0,0,0,
                    0,0,0,0,0,0,1,1,1,0,0,0,0,0,0};

int level08[180] = {7,1,2,3,0,0,0,0,0,0,0,3,2,1,7,
                    1,7,1,2,3,0,0,0,0,0,3,2,1,7,1,
                    2,1,7,1,2,3,3,3,3,3,2,1,7,1,2,
                    3,2,1,7,1,2,2,2,2,2,1,7,1,2,3,
                    0,3,2,1,7,1,1,1,1,1,7,1,2,3,0,
                    0,0,3,2,1,7,7,7,7,7,1,2,3,0,0,
                    0,0,3,2,1,7,7,7,7,7,1,2,3,0,0,
                    0,3,2,1,7,1,1,1,1,1,7,1,2,3,0,
                    3,2,1,7,1,2,2,2,2,2,1,7,1,2,3,
                    2,1,7,1,2,3,3,3,3,3,2,1,7,1,2,
                    1,7,1,2,3,0,0,0,0,0,3,2,1,7,1,
                    7,1,2,3,0,0,0,0,0,0,0,3,2,1,7};
                    
int level09[180] = {7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    0,0,1,2,0,0,0,0,0,0,0,2,1,0,0,
                    0,0,1,2,0,0,0,0,0,0,0,2,1,0,0,
                    0,0,1,2,0,0,0,0,0,0,0,2,1,0,0,
                    0,0,1,2,0,0,0,0,0,0,0,2,1,0,0,
                    0,0,1,2,0,0,0,0,0,0,0,2,1,0,0,
                    0,0,1,2,0,0,0,0,0,0,0,2,1,0,0,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,7,7};
                    
int level10[180] = {7,1,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,2,7,7,7,7,7,7,7,7,7,7,7,0,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,3,7,7,7,7,7,7,7,7,7,7,7,7,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,3,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,0,7,7,7,7,7,7,7,7,7,7,7,2,7,
                    7,0,0,0,0,0,0,0,0,0,0,0,0,0,7,
                    7,7,7,7,7,7,7,7,7,7,7,7,7,1,7};
                    
/* sets up the level based on level arrays */
void setup_level(block *b, int n, int l)
{
        size_t i;
        int step_x = 160;
        int step_y = 144;
        /* every level is the same size */
        for(i = 0; i < 180; i++) {
                
                /* switch on l, level */
                switch(l) {
                        
                        /* level 1 */
                        case 1:
                                if(level01[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level01[i] * 10;
                                b[i].c = level01[i]; 
                                if(level01[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 1;
                                break;
                        
                        /* level 2 */
                        case 2:
                                if(level02[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level02[i] * 10;
                                b[i].c = level02[i]; 
                                if(level02[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 1;
                                break;
                        
                        /* level 3 */
                        case 3:
                                if(level03[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level03[i] * 10;
                                b[i].c = level03[i]; 
                                if(level03[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 1;
                                break;

                        /* level 4 */
                        case 4:
                                if(level04[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level04[i] * 10;
                                b[i].c = level04[i]; 
                                if(level04[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 1;
                                break;
                                
                        /* level 5 */
                        case 5:
                                if(level05[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level05[i] * 10;
                                b[i].c = level05[i]; 
                                if(level05[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 1;
                                break;
                        

                        
                        /* level 6 */
                        case 6:
                                if(level06[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level06[i] * 10;
                                b[i].c = level06[i]; 
                                if(level06[i] == 7)
                                        b[i].h = 8;
                                else
                                        b[i].h = 1;
                                break;
                        
                        /* level 7 */
                        case 7:
                                if(level07[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level07[i] * 10;
                                b[i].c = level07[i]; 
                                if(level07[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 2;
                                break;
                        
                        /* level 8 */
                        case 8:
                                if(level08[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level08[i] * 10;
                                b[i].c = level08[i]; 
                                if(level08[i] == 7)
                                        b[i].h = 4;
                                else
                                        b[i].h = 1;
                                break;
                        
                        /* level 9 */
                        case 9:
                                if(level09[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level09[i] * 10;
                                b[i].c = level09[i]; 
                                if(level09[i] == 7)
                                        b[i].h = 10;
                                else
                                        b[i].h = 1;
                                break;
                        
                        /* level 10 */
                        case 10:
                                if(level10[i] > 0) {
                                        b[i].l = 1;
                                } else {
                                        b[i].l = 0;
                                }
                                b[i].s = level10[i] * 10;
                                b[i].c = level10[i]; 
                                if(level10[i] == 7)
                                        b[i].h = 10;
                                else
                                        b[i].h = 1;
                                break;
                }
                                
                /* sets coordinates */
                b[i].x = step_x;
                b[i].y = step_y;
                
                /* top line, left to right */
                b[i].bl[0].x1 = b[i].x;
                b[i].bl[0].y1 = b[i].y;
                b[i].bl[0].x2 = b[i].x + 32;
                b[i].bl[0].y2 = b[i].y;
                b[i].bl[0].l = 1;
                
                /* bottom line, left to right */
                b[i].bl[1].x1 = b[i].x;
                b[i].bl[1].y1 = b[i].y + 26;
                b[i].bl[1].x2 = b[i].x + 32;
                b[i].bl[1].y2 = b[i].y + 26;
                b[i].bl[1].l = 1;
                
                /* left line, bottom to top */
                b[i].bl[2].x1 = b[i].x;
                b[i].bl[2].y1 = b[i].y + 26;
                b[i].bl[2].x2 = b[i].x;
                b[i].bl[2].y2 = b[i].y;
                b[i].bl[2].l = 1;
                
                /* right line, bottom to top */
                b[i].bl[3].x1 = b[i].x + 32;
                b[i].bl[3].y1 = b[i].y + 26;
                b[i].bl[3].x2 = b[i].x + 32;
                b[i].bl[3].y2 = b[i].y;
                b[i].bl[3].l = 1;
                
                if(step_x >= 160 && step_x <= 576) {
                        step_x += 32;
                } else {
                        step_x = 160;
                        step_y += 26;
                }
        }
}