#include "collisions.h"
#include "audio.h"
/*
 * Line intersect collision
 *     x1,y1
 *        \
 *         \
 * x3,y2 --------- x4,y4
 *           \
 *            \
 *           x2,y2
 */
int isect(float x1, float y1, float x2, float y2, 
           float x3, float y3, float x4, float y4)
{
        float ua = 0;
        float ud = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        
        if (ud != 0) {
        
                ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / ud;
                float ub = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / ud;
                
                if (ua <= 0 || ua >= 1 || ub <= 0 || ub >= 1)
                        ua = 0;
        }
        
        if(ua != 0)
                return 1;
        else
                return 0;
} /* end isect */

/* check collisions between balls and paddles */
void col_paddles(ball *b, paddle *p)
{
        size_t i;
        size_t j;
        
        /* iterate through all balls */
        for(i = 0; i < 4; i++)
        {
                
                /* only check live balls */
                if(b[i].l && !b[i].c) {
                
                        /* ball top line */
                        float tx1 = b[i].x - b[i].w;
                        float ty1 = b[i].y - b[i].h;
                        float tx2 = b[i].x + b[i].w;
                        float ty2 = ty1;

                        /* ball bottom line */
                        float bx1 = b[i].x - b[i].w;
                        float by1 = b[i].y + (b[i].h + 1);
                        float bx2 = b[i].x + b[i].w;
                        float by2 = by1;

                        /* ball left line */
                        float lx1 = b[i].x - b[i].w;
                        float ly1 = b[i].y - b[i].h;
                        float lx2 = lx1;
                        float ly2 = b[i].y + b[i].h;

                        /* ball right line */
                        float rx1 = b[i].x + (b[i].w + 1);
                        float ry1 = b[i].y - b[i].h;
                        float rx2 = rx1;
                        float ry2 = b[i].y + b[i].h;

                        /* ball middle */
                        float mx = b[i].x;
                        float my = b[i].y;
                        
                        /* iterate through all paddles */
                        for(j = 0; j < 4; j++) {
                                
                                if(distance(mx, my, p[j].x, p[j].y) < 50) {
                                
                                        /* check all sides of the ball */
                                        if(isect(tx1, ty1, tx2, ty2,
                                                 p[j].l.x1, p[j].l.y1,
                                                 p[j].l.x2, p[j].l.y2) ||
                                           isect(bx1, by1, bx2, by2,
                                                 p[j].l.x1, p[j].l.y1,
                                                 p[j].l.x2, p[j].l.y2) ||
                                           isect(lx1, ly1, lx2, ly2,
                                                 p[j].l.x1, p[j].l.y1,
                                                 p[j].l.x2, p[j].l.y2) ||
                                           isect(rx1, ry1, rx2, ry2,
                                                 p[j].l.x1, p[j].l.y1,
                                                 p[j].l.x2, p[j].l.y2)) {
                                                
                                                /* play plopp low */
                                                ply_sound(2);
                                                
                                                /*
                                                 * set the collided switch in
                                                 * hope to avoid double 
                                                 * collision. also save the 
                                                 * index of the paddle the ball
                                                 * collided with
                                                 */
                                                b[i].c = 1;
                                                b[i].cp = j;
                                                
                                                /* reflect the ball vector */
                                                mod_vectors(&b[i], p[j].l.x1, 
                                                        p[j].l.y1, p[j].l.x2, 
                                                                p[j].l.y2);
                                        }
                                }
                        }
                
                /*
                 * collision has occured, wait until ball is far enough from
                 * the paddle it collided with before switch collided to 0
                 */
                } else if(b[i].l && b[i].c) {

                        /* 
                         * reset the collided switch if the distance from the 
                         * ball and the paddle is long enough 
                         */
                        if(distance(b[i].x, b[i].y, 
                                p[b[i].cp].x, p[b[i].cp].y) > 20) {
                                b[i].c = 0;
                        }
                }
        }
}

/* collision with lines */
void col_lines(ball *b, line *l)
{
        size_t i;
        size_t j;
        
        /* iterate through all balls */
        for(i = 0; i < 4; i++)
        {

                /* only check live balls*/
                if(b[i].l) {

                        /* ball top line */
                        float tx1 = b[i].x - b[i].w;
                        float ty1 = b[i].y - b[i].h;
                        float tx2 = b[i].x + b[i].w;
                        float ty2 = ty1;

                        /* ball bottom line */
                        float bx1 = b[i].x - b[i].w;
                        float by1 = b[i].y + (b[i].h + 1);
                        float bx2 = b[i].x + b[i].w;
                        float by2 = by1;

                        /* ball left line */
                        float lx1 = b[i].x - b[i].w;
                        float ly1 = b[i].y - b[i].h;
                        float lx2 = lx1;
                        float ly2 = b[i].y + b[i].h;

                        /* ball right line */
                        float rx1 = b[i].x + (b[i].w + 1);
                        float ry1 = b[i].y - b[i].h;
                        float rx2 = rx1;
                        float ry2 = b[i].y + b[i].h;

                        /* ball middle */
                        float mx = b[i].x;
                        float my = b[i].y;                        

                        /* iterate through all lines */
                        for(j = 0; j < 8; j++) {
                                
                                /* only check live lines */
                                if(l[j].l) {
                                
                                        /* check all sides of the ball */
                                        if(isect(tx1, ty1, tx2, ty2,
                                                 l[j].x1, l[j].y1,
                                                 l[j].x2, l[j].y2) ||
                                           isect(bx1, by1, bx2, by2,
                                                 l[j].x1, l[j].y1,
                                                 l[j].x2, l[j].y2) ||
                                           isect(lx1, ly1, lx2, ly2,
                                                 l[j].x1, l[j].y1,
                                                 l[j].x2, l[j].y2) ||
                                           isect(rx1, ry1, rx2, ry2,
                                                 l[j].x1, l[j].y1,
                                                 l[j].x2, l[j].y2)) {
                                                
                                                /* play plopp low */
                                                ply_sound(2);
                                                
                                                /* reflect the ball vector */
                                                mod_vectors(&b[i], l[j].x1, 
                                                        l[j].y1, l[j].x2, 
                                                                l[j].y2);
                                        }
                                }
                        }
                }
        }
}

void col_blocks(ball *b, block *bl, player *p, int n, int nb)
{
        size_t i;
        size_t j;
        
        /* index of the closest block */
        int ind;
        
        /* ball top line */
        float tx1, ty1, tx2, ty2;

        /* ball bottom line */
        float bx1, by1, bx2, by2;

        /* ball left line */
        float lx1, ly1, lx2, ly2;

        /* ball right line */
        float rx1, ry1, rx2, ry2;

        /* ball middle */
        float mx, my;
        
        /* block top line */
        float btx1, bty1, btx2, bty2;
        
        /* block bottom line */
        float bbx1, bby1, bbx2, bby2;
        
        /* block left line */
        float blx1, bly1, blx2, bly2;
        
        /* block right line */
        float brx1, bry1, brx2, bry2;
        
        /* block middle */
        float bmx, bmy;
        
        /* iterate through all balls */
        for(i = 0; i < n; i++)
        {
                
                /* only check live balls */
                if(b[i].l) {
                
                        /* ball top line */
                        tx1 = b[i].x - b[i].w;
                        ty1 = b[i].y - b[i].h;
                        tx2 = b[i].x + b[i].w;
                        ty2 = ty1;

                        /* ball bottom line */
                        bx1 = b[i].x - b[i].w;
                        by1 = b[i].y + b[i].h;
                        bx2 = b[i].x + b[i].w;
                        by2 = by1;

                        /* ball left line */
                        lx1 = b[i].x - (b[i].w -1);
                        ly1 = b[i].y - b[i].h;
                        lx2 = lx1;
                        ly2 = b[i].y + b[i].h;

                        /* ball right line */
                        rx1 = b[i].x + b[i].w;
                        ry1 = b[i].y - b[i].h;
                        rx2 = rx1;
                        ry2 = b[i].y + b[i].h;

                        /* ball middle */
                        mx = b[i].x;
                        my = b[i].y;

                        /* get the index of the closest block */
                        j = closest_block(mx, my, bl, nb);
                        
                        /* block top line */
                        btx1 = bl[j].bl[0].x1;
                        bty1 = bl[j].bl[0].y1;
                        btx2 = bl[j].bl[0].x2;
                        bty2 = bl[j].bl[0].y2;

                        /* block bottom line */
                        bbx1 = bl[j].bl[1].x1;
                        bby1 = bl[j].bl[1].y1;
                        bbx2 = bl[j].bl[1].x2;
                        bby2 = bl[j].bl[1].y2;

                        /* block left line */
                        blx1 = bl[j].bl[2].x1;
                        bly1 = bl[j].bl[2].y1;
                        blx2 = bl[j].bl[2].x2;
                        bly2 = bl[j].bl[2].y2;

                        /* block right line */
                        brx1 = bl[j].bl[3].x1;
                        bry1 = bl[j].bl[3].y1;
                        brx2 = bl[j].bl[3].x2;
                        bry2 = bl[j].bl[3].y2;
                        
                        /* block middle */
                        bmx = bl[j].x + 16;
                        bmy = bl[j].y + 13;

                        /* top line of closest block */
                        if(b[i].v.y < 0 && (isect(lx1, ly1, lx2, ly2, 
                                                  btx1, bty1, btx2, bty2) || 
                                            isect(rx1, ry1, rx2, ry2, 
                                                  btx1, bty1, btx2, bty2))) {
                                
                                /* play plopp hi */
                                ply_sound(1);
                                
                                /* decrease to hits of the block */
                                bl[j].h--;
                                
                                /* kill the block and award points */
                                if(bl[j].h <= 0 ) {
                                        //printf("block hits: %i\n", bl[j].h);
                                        bl[j].l = 0;
                                        
                                        /* boost skill x2 score */
                                        if(p->skill_boost > 0)
                                                p->score += bl[j].s * 2;
                                        else
                                                p->score += bl[j].s;
                                }
                                
                                /* 
                                 * set the balls y to just above block top 
                                 * and update the lefter and right lines
                                 */
                                b[i].y = bty1 - (b[i].h + 1);
                                
                                /* ball left line */
                                lx1 = b[i].x - (b[i].w -1);
                                ly1 = b[i].y - b[i].h;
                                lx2 = lx1;
                                ly2 = b[i].y + b[i].h;

                                /* ball right line */
                                rx1 = b[i].x + b[i].w;
                                ry1 = b[i].y - b[i].h;
                                rx2 = rx1;
                                ry2 = b[i].y + b[i].h;
                                
                                /* reflect the vector */
                                mod_vectors(&b[i], btx1, bty1, btx2, bty2);

                        } 
                        
                        /* bottom line of closest block */
                        else if(b[i].v.y > 0 && (isect(lx1, ly1, lx2, ly2, 
                                                  bbx1, bby1, bbx2, bby2) || 
                                            isect(rx1, ry1, rx2, ry2, 
                                                  bbx1, bby1, bbx2, bby2))) {
                                
                                /* play plopp hi */
                                ply_sound(1);
                                
                                /* decrease to hits of the block */
                                bl[j].h--;
                                
                                /* kill the block and award points */
                                if(bl[j].h <= 0 ) {

                                        bl[j].l = 0;
                                        
                                        /* boost skill x2 score */
                                        if(p->skill_boost > 0) 
                                                p->score += bl[j].s * 2;
                                        else
                                                p->score += bl[j].s;
                                }
                                
                                /* 
                                 * set the balls y to just below block bottom 
                                 * and update the lefter and right lines
                                 */
                                b[i].y = bby1 + (b[i].h + 1);
                                
                                /* ball left line */
                                lx1 = b[i].x - (b[i].w -1);
                                ly1 = b[i].y - b[i].h;
                                lx2 = lx1;
                                ly2 = b[i].y + b[i].h;

                                /* ball right line */
                                rx1 = b[i].x + b[i].w;
                                ry1 = b[i].y - b[i].h;
                                rx2 = rx1;
                                ry2 = b[i].y + b[i].h;
                                
                                /* reflect the vector */
                                mod_vectors(&b[i], btx1, bty1, btx2, bty2);
                        }
                        
                        /* right line of closest block */
                        else if(b[i].v.x < 0 && (isect(tx1, ty1, tx2, ty2, 
                                                  brx1, bry1, brx2, bry2) || 
                                            isect(bx1, by1, bx2, by2, 
                                                  brx1, bry1, brx2, bry2))) {
                                
                                /* play plopp hi */
                                ply_sound(1);
                                
                                /* decrease to hits of the block */
                                bl[j].h--;
                                
                                /* kill the block and award points */
                                if(bl[j].h <= 0 ) {
                        
                                        bl[j].l = 0;
                                        
                                        /* boost skill x2 score */
                                        if(p->skill_boost > 0) 
                                                p->score += bl[j].s * 2;
                                        else
                                                p->score += bl[j].s;
                                }
                                
                                /* 
                                 * set the balls x to just right of block right 
                                 * and update the lefter and right lines
                                 */
                                b[i].x = brx1 + (b[i].w + 1);
                                
                                /* ball top line */
                                tx1 = b[i].x - b[i].w;
                                ty1 = b[i].y - b[i].h;
                                tx2 = b[i].x + b[i].w;
                                ty2 = ty1;

                                /* ball bottom line */
                                bx1 = b[i].x - b[i].w;
                                by1 = b[i].y + b[i].h;
                                bx2 = b[i].x + b[i].w;
                                by2 = by1;
                                
                                /* reflect the vector */
                                mod_vectors(&b[i], brx1, bry1, brx2, bry2);
                        }
                        
                        /* left line of closest block */
                        else if(b[i].v.x > 0 && (isect(tx1, ty1, tx2, ty2, 
                                                  blx1, bly1, blx2, bly2) || 
                                            isect(bx1, by1, bx2, by2, 
                                                  blx1, bly1, blx2, bly2))) {

                                /* play plopp hi */
                                ply_sound(1);                 
                                 
                                /* decrease to hits of the block */
                                bl[j].h--;
                                
                                /* kill the block and award points */
                                if(bl[j].h <= 0 ) {

                                        bl[j].l = 0;
                                        
                                        /* boost skill x2 score */
                                        if(p->skill_boost > 0) 
                                                p->score += bl[j].s * 2;
                                        else
                                                p->score += bl[j].s;
                                }
                                
                                /* 
                                 * set the balls x to just right of block right 
                                 * and update the lefter and right lines
                                 */
                                b[i].x = blx1 - (b[i].w + 1);
                                
                                /* ball top line */
                                tx1 = b[i].x - b[i].w;
                                ty1 = b[i].y - b[i].h;
                                tx2 = b[i].x + b[i].w;
                                ty2 = ty1;

                                /* ball bottom line */
                                bx1 = b[i].x - b[i].w;
                                by1 = b[i].y + b[i].h;
                                bx2 = b[i].x + b[i].w;
                                by2 = by1;
                                
                                /* reflect the vector */
                                mod_vectors(&b[i], blx1, bly1, blx2, bly2);
                        }
                }
        }
} /* end col_blocks */

/* returns the index of the closest block */
int closest_block(float bx, float by, block *bl, int n)
{
        size_t i;
        int retval = 0;
        float closest = 10000;
        float dst;
        float bmx, bmy;
        
        /* iterate thrpough all blocks */
        for(i = 0; i < n; i++) {
                
                /* sort out dead blocks */
                if(bl[i].l) {
                        
                        /* get the middle of the current block */
                        bmx = bl[i].x + 16;
                        bmy = bl[i].y + 13;
                        dst = distance(bx, by, bmx, bmy); 
                        
                        /* if it is the closest block, save the index */
                        if( dst < closest) {
                               closest = dst;
                               retval = i;
                        }                             
                }
        }
        
        /* return the index of the closest block */
        return retval;
} /* end closest_block */

/* checks if the balls are out of board */
int out_of_board(ball *b, int n)
{
        size_t i;
        int retval = 0;
        
        /* iterate through all balls */
        for(i = 0; i < n; i++) {
                
                /* only check live balls */
                if(b[i].l) {
                
                        /* board boundries */
                        if(b[i].x < -10 || b[i].x > 810 || 
                                b[i].y < 0 || b[i].y > 600) {
                                
                                /* ball 0 is the player ball, player died */
                                if(i < 1) {
                                        retval = 1;
                                        break;
                                } else {
                                        b[i].l = 0;
                                }
                        }
                }
        }
        
        /* return true if player ball is out of board */
        return retval;
} /* end out_of_board */

/* checks if the balls hit the escape pad */
int hit_escape(ball *b, int n)
{
        size_t i;
        int retval = 0;
        int w = 800;
        int h = 600;
        int x1 = w / 2 - 30;
        int x2 = w / 2 + 30;
        int y1 = h / 2 - 10;
        int y2 = h / 2 + 10;
        
        /* iterate through all balls */
        for(i = 0; i < n; i++) {
                
                /* only check live balls */
                if(b[i].l) {
                
                        /* Escape board */
                        if(b[i].x > x1 && b[i].x < x2 && b[i].y > y1 && b[i].y < y2) {
                                
                                /* ball 0 is the player ball, hit escape */
                                if(i < 1) {
                                        retval = 1;
                                        break;
                                } else {
                                        b[i].l = 0;
                                }
                        }
                }
        }
        
        /* return true if player ball hit the escape pad */
        return retval;
} /* end hit_escape */

/* gets distance to object */
float distance(float x1, float y1, int x2, int y2)
{
        return sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
}