#include <stdio.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>
#include "audio.h"

int counter = 0;

/* declaring sound variables */
ALLEGRO_SAMPLE *bass;
ALLEGRO_SAMPLE *plopp_hi;
ALLEGRO_SAMPLE *plopp_hi_ciss_01;
ALLEGRO_SAMPLE *plopp_hi_ciss_02;
ALLEGRO_SAMPLE *plopp_hi_ciss_03;
ALLEGRO_SAMPLE *plopp_hi_c_01;
ALLEGRO_SAMPLE *plopp_hi_c_02;
ALLEGRO_SAMPLE *plopp_hi_c_03;
ALLEGRO_SAMPLE *plopp_hi_fiss_01;
ALLEGRO_SAMPLE *plopp_hi_fiss_02;
ALLEGRO_SAMPLE *plopp_hi_fiss_03;
ALLEGRO_SAMPLE *plopp_hi_f_01;
ALLEGRO_SAMPLE *plopp_hi_f_02;
ALLEGRO_SAMPLE *plopp_hi_f_03;
ALLEGRO_SAMPLE *plopp_low;
ALLEGRO_SAMPLE *short_bass;
ALLEGRO_SAMPLE *topp;
ALLEGRO_SAMPLE *song01;

/* declare sample instance variables */
ALLEGRO_SAMPLE_INSTANCE *instance;

/* init allegro aound addon */
void ini_allegro_audio()
{
        al_install_audio();
        al_init_acodec_addon();
        al_reserve_samples(10);
}

/* sets all sounds */
void ini_allegro_sounds()
{
        bass = al_load_sample("/audio/bass.ogg");
        plopp_hi = al_load_sample("/audio/plopp_hi.ogg");
        plopp_hi_ciss_01 = al_load_sample("audio/plopp_hi_ciss_01.ogg");
        plopp_hi_ciss_02 = al_load_sample("audio/plopp_hi_ciss_02.ogg");
        plopp_hi_ciss_03 = al_load_sample("audio/plopp_hi_ciss_03.ogg");
        plopp_hi_c_01 = al_load_sample("audio/plopp_hi_c_01.ogg");
        plopp_hi_c_02 = al_load_sample("audio/plopp_hi_c_02.ogg");
        plopp_hi_c_03 = al_load_sample("audio/plopp_hi_c_03.ogg");
        plopp_hi_fiss_01 = al_load_sample("audio/plopp_hi_fiss_01.ogg");
        plopp_hi_fiss_02 = al_load_sample("audio/plopp_hi_fiss_02.ogg");
        plopp_hi_fiss_03 = al_load_sample("audio/plopp_hi_fiss_03.ogg");
        plopp_hi_f_01 = al_load_sample("audio/plopp_hi_f_01.ogg");
        plopp_hi_f_02 = al_load_sample("audio/plopp_hi_f_02.ogg");
        plopp_hi_f_03 = al_load_sample("audio/plopp_hi_f_03.ogg");
        plopp_low = al_load_sample("audio/plopp_low.ogg");
        short_bass = al_load_sample("audio/short_bass.ogg");
        topp = al_load_sample("audio/topp.ogg");
        song01 = al_load_sample("audio/song01.ogg");
        
        /* creater a sample instance */
        instance = al_create_sample_instance(song01);
        
        /* attach instance to mixer */
        al_attach_sample_instance_to_mixer(instance, al_get_default_mixer());
        
        /* set playmode */
        al_set_sample_instance_playmode(instance, ALLEGRO_PLAYMODE_LOOP);
        
}

void ply_sound(int n)
{
        switch(n) {
        case 1:
                if(counter == 0) {
                        al_play_sample(plopp_hi_f_01,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 1) {
                        al_play_sample(plopp_hi_c_01,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 2) {
                        al_play_sample(plopp_hi_ciss_01,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 3) {
                        al_play_sample(plopp_hi_fiss_01,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 4) {
                        al_play_sample(plopp_hi_f_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 5) {
                        al_play_sample(plopp_hi_c_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 6) {
                        al_play_sample(plopp_hi_ciss_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 7) {
                        al_play_sample(plopp_hi_fiss_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 8) {
                        al_play_sample(plopp_hi_f_03,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 9) {
                        al_play_sample(plopp_hi_c_03,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 10) {
                        al_play_sample(plopp_hi_ciss_03,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 11) {
                        al_play_sample(plopp_hi_fiss_03,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 12) {
                        al_play_sample(plopp_hi_f_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 13) {
                        al_play_sample(plopp_hi_c_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 14) {
                        al_play_sample(plopp_hi_ciss_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter++;
                } else if(counter == 15) {
                        al_play_sample(plopp_hi_fiss_02,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                        counter = 0;
                } 
                
                break;
        case 2:
                al_play_sample(short_bass,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                break;
        case 3:
                al_play_sample(topp,1,0,1,ALLEGRO_PLAYMODE_ONCE,NULL);
                break;
        case 4:
                al_play_sample_instance(instance);
        }
}

int song_playing()
{
        return al_get_sample_instance_playing(instance);
}

void stop_song()
{
        al_stop_sample_instance(instance);
}

void destroy_audio()
{
        /* destroy all samples and instances */
        al_destroy_sample(bass);
        al_destroy_sample(plopp_hi);
        al_destroy_sample(plopp_hi_ciss_01);
        al_destroy_sample(plopp_hi_ciss_02);
        al_destroy_sample(plopp_hi_ciss_03);
        al_destroy_sample(plopp_hi_c_01);
        al_destroy_sample(plopp_hi_c_02);
        al_destroy_sample(plopp_hi_c_03);
        al_destroy_sample(plopp_hi_fiss_01);
        al_destroy_sample(plopp_hi_fiss_02);
        al_destroy_sample(plopp_hi_fiss_03);
        al_destroy_sample(plopp_hi_f_01);
        al_destroy_sample(plopp_hi_f_02);
        al_destroy_sample(plopp_hi_f_03);
        al_destroy_sample(plopp_low);
        al_destroy_sample(short_bass);
        al_destroy_sample(topp);
        al_destroy_sample(song01);
        al_destroy_sample_instance(instance);
}
