#include <allegro5/allegro.h>

#include <stdio.h>

#include "m_config.h"

#include "g_header.h"

#include "g_world.h"
#include "e_slider.h"
#include "e_header.h"
#include "i_display.h"
#include "i_input.h"
#include "i_console.h"
#include "i_view.h"
#include "i_sysmenu.h"
#include "i_programs.h"
#include "g_misc.h"
#include "g_motion.h"
#include "g_code.h"
#include "g_method.h"
#include "g_proc_run.h"
#include "g_packet.h"
#include "g_cloud.h"
#include "m_globvars.h"
#include "m_input.h"
#include "c_header.h"
#include "e_editor.h"

#include "s_turn.h"
#include "s_mission.h"
#include "t_template.h"
#include "x_sound.h"

ALLEGRO_EVENT_QUEUE* event_queue; // these queues are initialised in main.c
ALLEGRO_EVENT_QUEUE* fps_queue;

extern struct viewstruct view; // defined in i_view.c. TO DO: think about putting a pointer to this in the worldstruct
extern struct world_initstruct w_init; // this is the world_init generated by world setup menus - declared in s_menu.c
struct gamestruct game;

void run_game(int need_to_initialise, int playing_mission);
void init_main_loop(int need_to_initialise, int playing_mission);
void main_game_loop(void);
void close_any_edit_window(void);

void init_game(void);
void start_game(int phase, int turns, int minutes_each_turn);

// initialises gamestruct
// most of these initialisation values are probably not much use - need to set them properly when starting a game
void init_game(void)
{

 game.phase = GAME_PHASE_PREGAME;
// game.type = GAME_TYPE_INDEFINITE;
 game.turns = 0;
 game.current_turn = 0;
 game.minutes_each_turn = 0;
 game.current_turn_time_left = 0;
 game.pause_soft = 0;
 game.pause_hard = 0;
 game.fast_forward = FAST_FORWARD_OFF;
 game.fast_forward_type = FAST_FORWARD_TYPE_SMOOTH;
 game.force_turn_finish = 0;

 game.game_over_status = GAME_END_BASIC; // ignored until game.phase is set to GAME_PHASE_OVER
 game.game_over_value = 0;

}

// this function initialises gamestruct from some basic values
// it is called when starting from menu as well as when loading a gamefile from disk (but not a saved game)
void start_game(int phase, int turns, int minutes_each_turn)
{

 init_game();

 game.phase = phase;
 game.turns = turns;
 game.current_turn = 0; // begin in pregame
 game.minutes_each_turn = minutes_each_turn;
 game.current_turn_time_left = game.minutes_each_turn * 2000;

}

/*
Call this function before starting the main loop.
need_to_initialise is 1 if starting a new game or from a gamefile, 0 if loading from a saved game (as saved games contain various initialise stuff)
playing_mission is the index of the mission (MISSION_MISSION1 etc) if playing a mission, 0 otherwise
*/
void init_main_loop(int need_to_initialise, int playing_mission)
{

// settings.edit_window = EDIT_WINDOW_CLOSED;
// settings.keyboard_capture = INPUT_WORLD;

 settings.mode_button_available [MODE_BUTTON_PROGRAMS] = 1;
 settings.mode_button_available [MODE_BUTTON_TEMPLATES] = 1;
 settings.mode_button_available [MODE_BUTTON_EDITOR] = 1;
 settings.mode_button_available [MODE_BUTTON_SYSMENU] = 1;
 settings.mode_button_available [MODE_BUTTON_CLOSE] = 1;

// game.editor_mode_button_x = game.option [OPTION_WINDOW_W] - MODE_BUTTON_FROM_EDGE - EDITOR_MODE_BUTTON_SIZE;
// game.editor_mode_button_y = MODE_BUTTON_FROM_EDGE;

 close_editor();

 if (need_to_initialise)
 {
// put in here the things that are already initialised if the game is loaded from disk (need_to_initialise is 1 if loading from disk, 0 otherwise)
  w.playing_mission = playing_mission; // note that if loading from saved game, w.playing_mission is set in f_load.c
  start_game(GAME_PHASE_PREGAME, w_init.game_turns, w_init.game_minutes_each_turn);
  game.pregame_time_left = PREGAME_TIME;
  start_world();
  initialise_view(settings.option [OPTION_WINDOW_W], settings.option [OPTION_WINDOW_H]); // if loading, this function is called from within the load game functions (which is why it's within if (need_to_initialise) here)
  init_consoles(); // this function is called from within the load game functions
  setup_consoles();
  view.camera_x = al_itofix(400);
  view.camera_y = al_itofix(300);
  initialise_control();
 }

// open_sysmenu();
 resize_display_window(settings.option [OPTION_WINDOW_W], settings.option [OPTION_WINDOW_H]);

 init_ex_control();

 flush_game_event_queues();

 game.play_sound = 0;
 game.play_sound_counter = 0;

}


// set need_to_initialise to zero if loading from disk (in which case the world has been initialised by the load function)
void run_game(int need_to_initialise, int playing_mission)
{

// close_any_edit_window(); // closes editor, template window or system window

 init_main_loop(need_to_initialise, playing_mission);

//          settings.edit_window = EDIT_WINDOW_NONE;
//          open_sysmenu();
//          resize_display_window(settings.editor_x_split, settings.option [OPTION_WINDOW_H]);

 main_game_loop();

 if (playing_mission != -1
		&&	game.game_over_status == GAME_END_YOU_WON)
	{
		if (missions.status [playing_mission] != MISSION_STATUS_1STAR)
		{
		 missions.status [playing_mission] = MISSION_STATUS_1STAR; // stars not yet implemented (may not ever be)
		 save_mission_status_file();
		}
		 else
		  missions.status [playing_mission] = MISSION_STATUS_1STAR; // stars not yet implemented (may not ever be)
	}

 deallocate_world(); // must be called at end of game (it frees memory allocated by init_main_loop())

}


void main_game_loop(void)
{

 ALLEGRO_EVENT ev;

 int fps = 0;
 int cps = 0;
 int force_display_update = 0; // display always runs at least once each second
 int playing = 1;

 view.fps = 0;
 view.cycles_per_second = 0;


 int skip_frame = 0; // if game is running too slowly, it will skip frames to save drawing time.
 if (game.phase == GAME_PHASE_PREGAME)
  skip_frame = 1; // display is not updated during pregame phase.

// view.paused = 0; // TO DO: this may not be correct - should be able to load a paused game state

// init_editor(&view);

// al_flush_event_queue(event_queue);
// al_flush_event_queue(fps_queue);


 do // main game loop
 {

// should probably run display at the end of the loop rather than the start
//  - so that the game has run through at least once when loading game
  if (!skip_frame || force_display_update)
  {
   run_display();
   fps ++;
   force_display_update = 0;
  }

  if (game.phase != GAME_PHASE_PREGAME) // no input in pregame phase
   get_ex_control(0); // ex_control needs to be updated even when halted (control will not be updated)

/*
 if (ex_control.mb_press [1] == BUTTON_JUST_PRESSED)
	{
		 struct cloudstruct* cl = new_cloud(CLOUD_VIRTUAL_BREAK, al_itofix(1300 + grand(100)), al_itofix(2500));

   if (cl != NULL)
			{
    cl->timeout = 16;
    cl->angle = 0;
    cl->colour = 0;
    cl->data [0] = 9;
    cl->data [1] = 2;
    cl->x_speed = 0;//pr->x_speed;
    cl->y_speed = 0;//pr->y_speed;
			}
	}*/

  if (game.pause_hard == 0)
  {

   run_markers();
   run_system_code(); // this runs the system program as well as any observer and operator programs. These run even if the game is paused (and can tell if it is) but not if it is halted.

   if (view.focus_proc != NULL
    && view.focus_proc->exists != 1) // will be -1 if proc has just been deallocated
   {
    view.focus_proc = NULL;
    reset_proc_box_height(NULL);
   } // need to find a better place to put this

   if (game.phase <= GAME_PHASE_PREGAME // WORLD or PREGAME
    && game.pause_soft == 0)
   {
    if (run_turns()) // returns 0 if game has left world phase (e.g. because time has run out), 1 if still in world phase
    {
     run_world();
     run_delegate_code(); // this runs client programs (that are not operator programs). These don't run when the game is paused.

     run_clouds();
     run_procs();
     run_packets();

     cps ++;
     w.world_time ++;
    }

    if (game.phase == GAME_PHASE_PREGAME)
     run_pregame();

   }
   w.total_time ++; // total_time is affected by hard pause, but unlike world_time is not affected by soft pause (so it can only be used for things that don't affect gameplay, like console line highlighting)


    run_input(); // this derives control (available to programs) from ex_control. doesn't need to be run for user to be able to use mode buttons and interact with sysmenu/editor/templates etc (as these use ex_control directly)

   view.just_resized = 0; // this can be set to 1 in run_input and run_editor, and if so this needs to be preserved until the client program is run.
    // TO DO: make sure this works correctly when pausing and suspension are fully implemented.


  }

// fps_queue generates an event once each second - used for calculating fps and forcing a display update at least once per second
  if (al_get_next_event(fps_queue, &ev))
  {
   view.fps = fps;
   fps = 0;
   view.cycles_per_second = cps;
   cps = 0;
   if (game.phase != GAME_PHASE_PREGAME)
    force_display_update = 1; // this is checked next time through this loop (see display call above)
  }

  if (!skip_frame)
  {
   switch(settings.edit_window)
   {
    case EDIT_WINDOW_EDITOR:
     run_editor(); break;
    case EDIT_WINDOW_TEMPLATES:
     run_templates(); break;
    case EDIT_WINDOW_SYSMENU:
     playing = run_sysmenu(); break;
    case EDIT_WINDOW_PROGRAMS:
     run_programs_menu(); break;
   }
  }


  if (playing == 0)
   break;

  run_consoles(); // I think it's okay to call this even when halted
//  run_score_boxes(); // not currently used

  skip_frame = 0;

// check for fast-forward (skip). Ignore FF if not in world, or if paused
  if (game.fast_forward > 0
   && game.phase == GAME_PHASE_WORLD
   && game.pause_soft == 0
   && game.pause_hard == 0)
   {
    switch (game.fast_forward_type)
    {
     case FAST_FORWARD_TYPE_SKIPPY:
      if (game.fast_forward == FAST_FORWARD_JUST_STARTED)
       game.fast_forward = FAST_FORWARD_ON; // don't skip this frame (to prevent a delay before "FAST FORWARD" message appears on screen)
        else
         skip_frame = 1;
      break;
     case FAST_FORWARD_TYPE_SMOOTH:
      game.fast_forward = FAST_FORWARD_ON;
      al_flush_event_queue(event_queue);
      break;
     case FAST_FORWARD_TYPE_4X:
      game.fast_forward = FAST_FORWARD_ON;
      if (w.world_time % 4 != 0)
							skip_frame = 1;
      break;
     case FAST_FORWARD_TYPE_8X:
      game.fast_forward = FAST_FORWARD_ON;
      if (w.world_time % 8 != 0)
							skip_frame = 1;
      break;
    }
   }

  if (game.play_sound_counter > 0)
		{
			game.play_sound_counter --;
   if (game.play_sound != 0
				&& game.play_sound_counter == 0)
		 {
			 play_view_sound();
		 }
		}

  if (game.phase == GAME_PHASE_PREGAME)
   skip_frame = 1; // never run display during pregame.

// now check whether the timer has expired during game processing. If it has, don't generate a display this tick (unless force_display_update==1)
  if (al_get_next_event(event_queue, &ev))
  {
   switch(ev.type)
   {
    case ALLEGRO_EVENT_TIMER:
     skip_frame = 1; break;
   }
  }

// wait for the timer so we can go to the next tick (unless we're fast-forwarding or the timer has already expired)
  if (!skip_frame
   && game.fast_forward == FAST_FORWARD_OFF)
  {
   al_wait_for_event(event_queue, &ev);
  }

 } while (TRUE); // end main game loop

// if game has been finished or quit, we can end up here outside the loop

}


// closes editor, template window or system window, if open
// see also mode_button() in m_input.c
void close_any_edit_window(void)
{

 switch(settings.edit_window)
 {
  case EDIT_WINDOW_CLOSED:
   break;
  case EDIT_WINDOW_EDITOR:
   close_editor();
   resize_display_window(settings.option [OPTION_WINDOW_W], settings.option [OPTION_WINDOW_H]);
   break;
  case EDIT_WINDOW_TEMPLATES:
   close_templates();
   resize_display_window(settings.option [OPTION_WINDOW_W], settings.option [OPTION_WINDOW_H]);
   break;
  case EDIT_WINDOW_SYSMENU:
   close_sysmenu();
   resize_display_window(settings.option [OPTION_WINDOW_W], settings.option [OPTION_WINDOW_H]);
   break;
  case EDIT_WINDOW_PROGRAMS:
   close_programs_window();
   resize_display_window(settings.option [OPTION_WINDOW_W], settings.option [OPTION_WINDOW_H]);
   break;
 }

}

