#include <stdlib.h>
#include <stdio.h>
#include <math.h>

#include "global.h"
/*These statements get rid of things that are not
need and are in the allegro library*/
#define alleg_gui_unused

#define alleg_vidmem_unused
#define alleg_flic_unused

#include <allegro.h>



/* Define M_PI in case the compiler doesn't */
#ifndef M_PI
   #define M_PI   3.1415926535897932384626433832795
#endif
#define RAD_2_DEG(x) ((x) * 180 / M_PI)
#define DEG_2_RAD(x)    ((x) * M_PI / 180)

#define MAG(x,y)	(float)sqrt( (float)(x*x)+(float)(y*y) ) 



BITMAP *buffer;
BITMAP *buffer_collision;
DATAFILE *datafile;
DATAFILE *datafile_boss[4];
DATAFILE *datafile_background;
DATAFILE *datafile_music;
BITMAP *buffer_boss;
BITMAP *buffer_boss_scaled;

int bpp=32;
int file_load_failed=0;

int buffer_boss_offset_x=64;
int buffer_boss_offset_y=64;
BITMAP *buffer_boss_show;

int sample_for_shooting_is_playing=FALSE;
int start_sweep_flag=0;

BITMAP *boss_ball;

int alpha =0;

int next_ship_called=0;
int trouble_shoot=0;
float trouble_shoot2=0;



int error_message=1;
int the_color=0;



int load_song_flag=0;

#define LEVEL_1_SONG_LOADED 1
#define LEVEL_2_SONG_LOADED 2
#define LEVEL_3_SONG_LOADED 4
#define LEVEL_4_SONG_LOADED 8
#define LEVEL_5_SONG_LOADED 16


#define SCREEN_W_USE 320
#define SCREEN_H_USE 240


int game_flag=0;
int game_flag2=0;
int game_set_keys_flag[2]={0,0};


float troubleshoot_end_x=0;

#define GAME_EXIT 1
#define GAME_START 2
#define GAME_AT_TITLE 4
#define GAME_AT_CONFIG 8
#define GAME_SELECTION_DO_ONE_SHOT 16
#define GAME_SELECTION_KEY_WAS_PRESSED 32
#define GAME_SELECTION_CONFIG 64
#define GAME_SELECTION_START 128
#define GAME_SELECTION_CONFIG_EXIT 256
#define GAME_SELECTION_CONFIG_PLAYER_1 512
#define GAME_SELECTION_CONFIG_PLAYER_2 1024
#define GAME_SELECTION_SCREEN 2048
#define GAME_SET_FULL_SCREEN 4096
#define GAME_SET_SCREEN_FAILED 8192


#define GAME_DO_UP_ONE_SHOT 1
#define GAME_UP_PRESSED 2
#define GAME_DO_DOWN_ONE_SHOT 4
#define GAME_DOWN_PRESSED 8
#define GAME_SELECTION_DO_CONFIG_PLAYER_1 16
#define GAME_SELECTION_DO_CONFIG_PLAYER_2 32
#define GAME_ANY_KEY_ONE_SHOT 64
#define GAME_ANY_KEY_PRESSED 128

#define GAME_SELECTION_DO_CONFIG_EXIT 256
#define GAME_SELECTION_DO_CONFIG_KEYBOARD 512
#define GAME_SELECTION_DO_CONFIG_JOY 1024


#define GAME_SET_PLAYER_KEY_UP 1
#define GAME_SET_PLAYER_KEY_DOWN 2
#define GAME_SET_PLAYER_KEY_LEFT 4
#define GAME_SET_PLAYER_KEY_RIGHT 8

#define GAME_SET_PLAYER_KEY_FIRE 16
#define GAME_SET_PLAYER_KEY_START 32

#define GAME_SET_PLAYER_JOY_FIRE 64
#define GAME_SET_PLAYER_JOY_START 128



char *key_names[] =
{
   "(none)",         "A",          "B",          "C",
   "D",          "E",          "F",          "G",
   "H",          "I",          "J",          "K",
   "L",          "M",          "N",          "O",
   "P",          "Q",          "R",          "S",
   "T",          "U",          "V",          "W",
   "X",          "Y",          "Z",          "0",
   "1",          "2",          "3",          "4",
   "5",          "6",          "7",          "8",
   "9",          "0_PAD",      "1_PAD",      "2_PAD",
   "3_PAD",      "4_PAD",      "5_PAD",      "6_PAD",
   "7_PAD",      "8_PAD",      "9_PAD",      "F1",
   "F2",         "F3",         "F4",         "F5",
   "F6",         "F7",         "F8",         "F9",
   "F10",        "F11",        "F12",        "ESC",
   "TILDE",      "MINUS",      "EQUALS",     "BACKSPACE",
   "TAB",        "OPENBRACE",  "CLOSEBRACE", "ENTER",
   "COLON",      "QUOTE",      "BACKSLASH",  "BACKSLASH2",
   "COMMA",      "STOP",       "SLASH",      "SPACE",
   "INSERT",     "DEL",        "HOME",       "END",
   "PGUP",       "PGDN",       "LEFT",       "RIGHT",
   "UP",         "DOWN",       "SLASH_PAD",  "ASTERISK",
   "MINUS_PAD",  "PLUS_PAD",   "DEL_PAD",    "ENTER_PAD",
   "PRTSCR",     "PAUSE",      "ABNT_C1",    "YEN",
   "KANA",       "CONVERT",    "NOCONVERT",  "AT",
   "CIRCUMFLEX", "COLON2",     "KANJI",      "EQUALS_PAD",
   "BACKQUOTE",  "SEMICOLON",  "COMMAND",    "UNKNOWN1",
   "UNKNOWN2",   "UNKNOWN3",   "UNKNOWN4",   "UNKNOWN5",
   "UNKNOWN6",   "UNKNOWN7",   "UNKNOWN8",   "LSHIFT",
   "RSHIFT",     "LCONTROL",   "RCONTROL",   "ALT",
   "ALTGR",      "LWIN",       "RWIN",       "MENU",
   "SCRLOCK",    "NUMLOCK",    "CAPSLOCK",   "MAX"
};


    char msg[80];

struct XANDY
{
    float x,y;
};

struct COLOR
{
	int r;
	int b;
	int g;
	int a;
};


struct FRAME
{
	int start;
	int act;
	int act_reverse;
	int total;
	float speed;
	int pos;
	float angle;
	int width;
	int height;
};

#define MAX_DATA 10000

struct SHIP_DATA
{
	int type;
	int value;

};
struct SHIP_DATA ship_data[MAX_DATA];

#define MAX_DATA_BOSS 100

struct BOSS_DATA
{
	int type;
	int value;

};
struct BOSS_DATA boss_data[MAX_DATA_BOSS];


FILE *f1;   /*reads the enemy commands from script*/
FILE *f2;	/*writes the enemy commands to a script for troubleshooting errors in it*/


FILE *f3; /*reads the boss commands from script*/
FILE *f4;	/*writes the boss commands to a script for troubleshooting errors in it*/


fpos_t position[1000];





#define BULLET_MAX 1000

#define BULLET_ACTIVE 1
#define BULLET_ENEMY 2
#define BULLET_PLAYER_1 4
#define BULLET_PLAYER_2 8
#define BULLET_BOSS 16

struct BULLET
{
	struct XANDY force;
	struct XANDY pos;
	struct XANDY pos_old;
	int type;
	
	int flag;
};
struct BULLET bullet[BULLET_MAX];

int continue_preset=5;
int continues=5;

struct KEY
{
	int up;
	int down;
	int left;
	int right;
	int fire;
	int start;
};


struct PLAYER
{
	struct XANDY pos;
	struct XANDY pos_old;
	struct FRAME frame;
	struct KEY key;
	struct KEY joy;
	float shot_timer;
	BITMAP *buffer;
	int start_lives;
	int lives;
	float continue_timer;
	float regen_timer;
	float continue_time_length;
	float regen_time_length;
	int score;
	int flag;
};
struct PLAYER player[2];




#define PLAYER_ACTIVE 1
#define PLAYER_CAN_FIRE 2
#define PLAYER_FIRED 4
#define PLAYER_DO_SHOT 8
#define PLAYER_ALIVE 16
#define PLAYER_DEAD 32
#define PLAYER_LIVES_DONE 64
#define PLAYER_CONTINUE_TIMER_SHOWN 128
#define PLAYER_REGEN_SHOWN 256
#define PLAYER_WAS_ACTIVE 512


#define ENEMY_MAX_ON_SCREEN 100


struct MOD
{
	
	struct XANDY timer;
	struct XANDY inc;
	struct XANDY percent_done;
	struct XANDY speed;
	struct XANDY amplitude;
	struct XANDY pos_old;
};

#define ENEMY_MAX_TYPE 20

struct SHOT
{
	float timer;
	float delay;
	float speed;
	float angle;
	int amount_to_fire;
	int amount_fired;
	int image;
	int flag;
	int type;

};

#define SHOT_AIM 1
#define SHOT_MULTI_2 2
#define SHOT_MULTI_5 4
#define SHOT_SPIN 8
#define ENEMY_FOLLOW_BULLET 16



struct ENEMY_TYPE
{
	struct FRAME frame;
	int health_init;
	struct SHOT shot;
	int points;
	int flag;
	int explosion;


};

struct ENEMY_TYPE enemy_type[ENEMY_MAX_TYPE];


#define ENEMY_ACTIVE 1
#define ENEMY_COMMAND_SET 2
#define ENEMY_MIRROR_H 4
#define ENEMY_MIRROR_V 8
#define ENEMY_COMMAND_POSITION 16
#define ENEMY_COMMAND_WAIT 32
#define ENEMY_DRAW 64
#define ENEMY_COMMAND_FIRE 128
#define ENEMY_COMMAND_X_MOD 256
#define ENEMY_COMMAND_Y_MOD 512
#define ENEMY_ROTATE_SLOW 1024
#define ENEMY_HIT_BY_PLAYER_1 2048
#define ENEMY_FOLLOW_PLAYER 4096


struct ENEMY
{
	struct FRAME frame;

	struct XANDY start_pos_command;
	struct XANDY end_pos_command;
	struct XANDY dist_pos_command;
	struct XANDY pos_command;
	struct XANDY pos_mod;
	struct XANDY pos_old;
	struct XANDY pos;
	struct MOD mod;
	struct XANDY force;
	struct SHOT shot;
	float wait_timer;
	float speed;
	int at_command;
	float command_inc;
	float command_percent_done;
	int type;
	int health;
	int points;
	float show_point_timer;
	int ref;
	int flag;
	int explosion;
};

struct ENEMY  enemy[ENEMY_MAX_ON_SCREEN];



#define ENEMY_DEAD_ACTIVE 1
#define ENEMY_DEAD_HIT_BY_PLAYER_1 2


struct ENEMY_DEAD
{
	struct XANDY pos;
	int points;
	int explode_type;
	float score_timer;
	float explode_timer;
	int flag;
};

struct ENEMY_DEAD enemy_dead[ENEMY_MAX_ON_SCREEN];



#define MAX_PARTICLES 360

struct PARTICLE
{
	struct XANDY start_pos;
	struct XANDY final_pos;
	struct XANDY pos;
	float fade_percent;
	struct COLOR color;

};

#define EXPLOSION_MAX ENEMY_MAX_ON_SCREEN

struct EXPLOSION
{
	struct XANDY pos;
	float start_size;
	float final_size;
	struct PARTICLE p[MAX_PARTICLES];
	float percent;
	float duration;
	float start_time;
	struct COLOR color;

	int type;
	int flag;
};
struct EXPLOSION explosion[EXPLOSION_MAX];

struct EXPLOSION_TYPE
{
	float start_size;
	float final_size;
	float duration;
	struct COLOR color;

};
struct EXPLOSION_TYPE explosion_type[6];



#define EXPLOSION_ACTIVE 1


#define ENEMY_MAX_CALLS 20000

struct ENEMY_CALL
{
	int start_time;
	int start_param;
	int num_param;
	int ref;	
	int flag;

	
};
struct ENEMY_CALL enemy_call[ENEMY_MAX_CALLS];


#define ENEMY_USED 1
#define ENEMY_DONE 2


int last_enemy_read=0;

/*
0T	ship type Tparam
1P	x,y coord P[param 1,param 2]
2L	start or end point left of screen Lparam 	
3R	start or end point right of screen Rparam
4U	start or end point top of screen Uparam
5D	start or end point bottom of screen Dparam
6C	copy of specified reference Creference

M	mirrored copy followed by 
	7V for vertical mirror  MV
	8H for horizantal mirror

9X	cos modulation speed and amplitude C[param 1,param 2]	
10Y	sin modulation speed and amplitude S[param 1,param 2]
11V speed Vparam
12W wait Wparam
13F fire Fparam
14J	number of times to loop,loop back to J[param 1,param 2]
15B fire type Bparam

*/



    #define		COMMAND_SHIP_TYPE   0  
    #define     COMMAND_POS     1
    #define     COMMAND_LEFT     2
    #define     COMMAND_RIGHT     3
    #define     COMMAND_TOP     4
    #define     COMMAND_BOTTOM     5
    #define     COMMAND_COPY     6
    #define     COMMAND_MIRROR_VERTICAL 7    
    #define     COMMAND_MIRROR_HORIZANTAL  8   
    #define     COMMAND_X_MOD     9
    #define     COMMAND_Y_MOD     10
    #define     COMMAND_SPEED     11
    #define     COMMAND_WAIT     12
    #define     COMMAND_FIRE 13
    #define		COMMAND_LOOP 14
    #define		COMMAND_FIRE_TYPE 15
   
char *command_desc[] =
{
   "COMMAND SHIP TYPE",
   "COMMAND POS",
   "COMMAND LEFT",
   "COMMAND RIGHT",
   "COMMAND TOP",
   "COMMAND BOTTOM",
   "COMMAND COPY",
   "COMMAND MIRROR VERTICAL",
   "COMMAND MIRROR HORIZANTAL",
   "COMMAND X MOD",
   "COMMAND Y MOD",
   "COMMAND SPEED",
   "COMMAND WAIT",
   "COMMAND FIRE",
   
};


char *command_boss_desc[] =
{
   "NOT USED",
   "COMMAND POS",
   "COMMAND LEFT",
   "COMMAND RIGHT",
   "COMMAND TOP",
   "COMMAND BOTTOM",
   "NOT USED",
   "NOT USED",
   "NOT USED",
   "COMMAND X MOD",
   "COMMAND Y MOD",
   "COMMAND SPEED",
   "COMMAND WAIT",
   "COMMAND FIRE",
   "COMMAND LOOP",
   "COMMAND FIRE_TYPE",
   
};



struct ELECTRIC_BALL
{

	struct XANDY pos;
	struct XANDY inc;
	struct XANDY line[2][10];
	
	struct COLOR color_line[2][10];
	struct COLOR color;
	struct COLOR trans_ball;
};

struct GEL
{
	struct XANDY pos;
	struct XANDY move;
	int hits;
};

struct POD
{
	struct XANDY pos;
	float leave_time;
	struct COLOR color;
	int health;
	int health_init;
};



struct LOOP
{

	int count;
	int preset;
	int ref;
	int flag;
};


struct WEAPON
{
	struct XANDY pos;
	struct XANDY speed;
	struct XANDY min;
	struct XANDY max;
	int image;
	int flag;

};


#define WEAPON_USED 1
#define WEAPON_PLAYER_1_FOLLOW 2
#define WEAPON_PLAYER_2_FOLLOW 4
#define WEAPON_BACK_FORTH 8
#define WEAPON_DIR_X  16
#define WEAPON_DIR_Y  32
#define WEAPON_PLAYER_FOLLOW 64

#define BOSS_MAX_POD 6
#define BOSS_MAX_LOOP 10
#define BOSS_MAX_WEAPON 8


struct BOSS
{


	struct FRAME frame;

	struct XANDY start_pos_command;
	struct XANDY end_pos_command;
	struct XANDY dist_pos_command;
	struct XANDY pos_command;
	struct XANDY pos_mod;
	struct XANDY pos_old;
	struct XANDY pos;
	struct MOD mod;
	struct XANDY force;
	struct SHOT shot;
	struct XANDY bullet_offset;

	int fire_type;
	float wait_timer;
	float speed;
	int at_command;
	float command_inc;
	float command_percent_done;
	int type;
	int health;
	int points;
	float show_point_timer;
	int ref;
	int flag;
	int explosion;

	struct LOOP loop[10];
	struct WEAPON weapon[8];
	

	struct ELECTRIC_BALL ball;
	struct POD pod[BOSS_MAX_POD];

	int health_init;
	int num_param;

	struct GEL gel_left[30][30];
	struct GEL gel_right[30][30];



	int hit_1;
	int hit_2;

	

	
};
struct BOSS boss[1];

#define LOOP_USED 1



struct BOSS_DEAD
{
	struct XANDY pos;
	int points;
	int explode_type;
	float score_timer;
	float explode_timer;
	int flag;
};

struct BOSS_DEAD boss_dead[1];


#define SQUARE_X_SIZE 4
#define SQUARE_Y_SIZE 4

#define SQUARE_X_TILE 256
#define SQUARE_Y_TILE 256

#define SQUARE_NUM_X SQUARE_X_TILE/SQUARE_X_SIZE
#define SQUARE_NUM_Y SQUARE_Y_TILE/SQUARE_Y_SIZE

V3D_f vtx[4];

struct SQUARES
{
V3D_f v[4];

};

struct BOSS_POLYGON
{
struct XANDY pos;
struct SQUARES square[SQUARE_NUM_X][SQUARE_NUM_Y];
struct XANDY points[SQUARE_NUM_X+1][SQUARE_NUM_Y+1];
};

struct BOSS_POLYGON bp;

MATRIX_f matrix_display;



#define LEVEL_START 1
#define LEVEL_ENEMIES_END 2
#define LEVEL_BOSS_ENTER 4
#define LEVEL_BOSS_LOADING_DONE 8


#define LEVEL_NUM 4

int level=-1;
int level_flag=0;
int level_show_boss_timer=0;
int level_boss_intro_timer=0;


#define PAUSE_GAME 1
#define PAUSE_GAME_HELD 2


int pause_flag=0;

float offset_x=30;
float offset_y=107;

struct LEVEL_TIMER
{
	int boss_start_preset;
	int boss_intro_preset;
};

struct LEVEL_TIMER level_timer[LEVEL_NUM]={	1000,140,
											1000,140,
											1000,140,
											500,140};




BITMAP *buffer_title;

char show_title_text[][20]={"ENTRY",
							"ARRIVAL",
							"ARMS",
							"CELL"};

float show_title_delay=20;
float show_title_length=150;
float show_title_start_timer=0;

volatile frame_count, framecheck,fps;
volatile timeleftm;
volatile timelefts;
volatile timeleftmm;
volatile float timer=0;
volatile float milli=0;
volatile float time_left_title=0;
volatile int anim_counter =0;
volatile int frame=0;
volatile int speed_counter = 0;



      /*function to keep game updating user
      inputs at constant speed*/
      void increment_speed_counter(void)
      {
         speed_counter++;
      }

      END_OF_FUNCTION(increment_speed_counter);

	  void increment_anim_counter(void)
      {
         anim_counter++;
		 frame++;
      }

      END_OF_FUNCTION(increment_anim_counter);



    
  void fps_proc(void)
{
	  if(!(pause_flag&PAUSE_GAME))
	  {
	  timer+=0.01;
	  milli++;
	  
	  }

	  time_left_title+=0.01;
	  if (game_flag&GAME_AT_TITLE) time_left_title=0;

	  


   fps = frame_count;
   frame_count = 0;

         }

END_OF_FUNCTION(fps_proc);

float get_milli_value()
{
	return milli;
}

init_boss(int c)
{

stop_midi();

	/*boss 1*/
	if(level==0)
	{
	boss[0].pos.x=80;
	boss[0].pos.y=0;


	boss[0].speed=5;

	boss[0].flag=0;
	if(!(boss[0].flag&ENEMY_ACTIVE)) boss[0].flag+=ENEMY_ACTIVE;
	
	
	boss[0].health_init=240;
	boss[0].health=boss[c].health_init;
	boss[0].points=20000;
	}
	/*boss 2*/
	if(level==1)
	{
	boss[0].pos.x=100;
	boss[0].pos.y=0;


	boss[0].speed=5;

	boss[0].flag=0;
	if(!(boss[0].flag&ENEMY_ACTIVE)) boss[0].flag+=ENEMY_ACTIVE;
	
	
	boss[0].health_init=350;
	boss[0].health=boss[c].health_init;
	boss[0].points=60000;
	}

	/*boss 3*/
	if(level==2)
	{
	boss[0].pos.x=150;
	boss[0].pos.y=0;


	boss[0].speed=5;

	boss[0].flag=0;
	if(!(boss[0].flag&ENEMY_ACTIVE)) boss[0].flag+=ENEMY_ACTIVE;
	
	
	boss[0].health_init=600;
	boss[0].health=boss[c].health_init;
	boss[0].points=200000;

	


	boss[0].weapon[0].pos.x=0;
	boss[0].weapon[0].pos.y=0;
	
	boss[0].weapon[0].speed.x=0.62;
	boss[0].weapon[0].speed.y=0;
	
	boss[0].weapon[0].min.x=0;
	boss[0].weapon[0].min.y=0;

	boss[0].weapon[0].max.x=134;
	boss[0].weapon[0].max.y=0;

	boss[0].weapon[0].image=1;
	boss[0].weapon[0].flag=WEAPON_BACK_FORTH+WEAPON_USED;


	boss[0].weapon[1].pos.x=288;
	boss[0].weapon[1].pos.y=0;
	
	boss[0].weapon[1].speed.x=0.68;
	boss[0].weapon[1].speed.y=0;
	
	boss[0].weapon[1].min.x=154;
	boss[0].weapon[1].min.y=0;

	boss[0].weapon[1].max.x=288;
	boss[0].weapon[1].max.y=0;

	boss[0].weapon[1].image=1;
	boss[0].weapon[1].flag=WEAPON_BACK_FORTH+WEAPON_USED;


	boss[0].weapon[2].pos.x=16;
	boss[0].weapon[2].pos.y=64;
	
	boss[0].weapon[2].speed.x=0;
	boss[0].weapon[2].speed.y=0;
	
	boss[0].weapon[2].min.x=0;
	boss[0].weapon[2].min.y=0;

	boss[0].weapon[2].max.x=0;
	boss[0].weapon[2].max.y=0;

	boss[0].weapon[2].image=2;
	boss[0].weapon[2].flag=WEAPON_USED;


	boss[0].weapon[3].pos.x=302-32;
	boss[0].weapon[3].pos.y=64;
	
	boss[0].weapon[3].speed.x=0;
	boss[0].weapon[3].speed.y=0;
	
	boss[0].weapon[3].min.x=0;
	boss[0].weapon[3].min.y=0;

	boss[0].weapon[3].max.x=0;
	boss[0].weapon[3].max.y=0;

	boss[0].weapon[3].image=3;
	boss[0].weapon[3].flag=WEAPON_USED;


	boss[0].weapon[4].pos.x=0;
	boss[0].weapon[4].pos.y=64;
	
	boss[0].weapon[4].speed.x=0;
	boss[0].weapon[4].speed.y=0.2;
	
	boss[0].weapon[4].min.x=0;
	boss[0].weapon[4].min.y=64;

	boss[0].weapon[4].max.x=0;
	boss[0].weapon[4].max.y=228;

	boss[0].weapon[4].image=4;
	boss[0].weapon[4].flag=WEAPON_PLAYER_FOLLOW+WEAPON_USED;


	boss[0].weapon[5].pos.x=290;
	boss[0].weapon[5].pos.y=64;
	
	boss[0].weapon[5].speed.x=0;
	boss[0].weapon[5].speed.y=0.2;
	
	boss[0].weapon[5].min.x=290;
	boss[0].weapon[5].min.y=64;

	boss[0].weapon[5].max.x=290;
	boss[0].weapon[5].max.y=228;

	boss[0].weapon[5].image=4;
	boss[0].weapon[5].flag=WEAPON_PLAYER_FOLLOW+WEAPON_USED;

	}

	/*boss 4*/
	if(level==3)
	{
	boss[0].pos.x=80;
	boss[0].pos.y=0;


	boss[0].speed=5;

	boss[0].flag=0;
	if(!(boss[0].flag&ENEMY_ACTIVE)) boss[0].flag+=ENEMY_ACTIVE;
	
	
	boss[0].health_init=1000;
	boss[0].health=boss[c].health_init;
	boss[0].points=500000;

	for(c=0;c<BOSS_MAX_POD;c++)
	{
		boss[0].pod[c].health_init=50;
		boss[0].pod[c].health=boss[0].pod[c].health_init;
	}
	}

		

}

title_input()
{
	int joy_stick_up_pressed[2]={0,0};
	int joy_stick_down_pressed[2]={0,0};
	int joy_stick_left_pressed[2]={0,0};
	int joy_stick_right_pressed[2]={0,0};
	int joy_button_pressed=0;
	int joy_any_key_pressed=0;
	int keyboard_any_key_pressed=0;
	
	
	int c,c2,i=0;
	
	if(key[KEY_T] && key[KEY_I] && key[KEY_N] && key[KEY_O])
    {
                  play_sample(datafile_music[0].dat, 16,(int)( 128+sin(DEG_2_RAD(timer*100))*128),(int)( 2800+sin(DEG_2_RAD(timer*25))*1800), FALSE);
                  continues=10;	
    }
	
	poll_joystick();

	for(c=0;c<num_joysticks&&c<2;c++)
	{
		
		if(joy[c].stick[0].axis[0].d1) 
		{
			joy_stick_left_pressed[c]=1;
			joy_any_key_pressed=1;
		}
		
		if(joy[c].stick[0].axis[0].d2) 
		{
			joy_stick_right_pressed[c]=1;
			joy_any_key_pressed=1;
		}

		if(joy[c].stick[0].axis[1].d1)
		{
			joy_stick_up_pressed[c]=1;
			joy_any_key_pressed=1;
		}

		if(joy[c].stick[0].axis[1].d2) 
		{
			joy_stick_down_pressed[c]=1;
			joy_any_key_pressed=1;
		}

	
	for (c2=0; c2<joy[c].num_buttons; c2++) 
	 if (joy[c].button[c2].b) 
		{
			joy_button_pressed=1+c;
			joy_any_key_pressed=1;
		}
	}

for(c=0;c<KEY_MAX;c++)
if(key[c]) keyboard_any_key_pressed=1;

	if(keyboard_any_key_pressed||joy_any_key_pressed)
	{
		
		if(!(game_flag2&GAME_ANY_KEY_PRESSED))
		{
			game_flag2+=GAME_ANY_KEY_PRESSED;
			if(!(game_flag2&GAME_ANY_KEY_ONE_SHOT)) game_flag2+=GAME_ANY_KEY_ONE_SHOT;
		}
		else
		{
			if(game_flag2&GAME_ANY_KEY_ONE_SHOT) game_flag2-=GAME_ANY_KEY_ONE_SHOT;
		}
	}
	else
	{
		if(game_flag2&GAME_ANY_KEY_PRESSED) game_flag2-=GAME_ANY_KEY_PRESSED;
		if(game_flag2&GAME_ANY_KEY_ONE_SHOT) game_flag2-=GAME_ANY_KEY_ONE_SHOT;
	}
	


	if(key[KEY_ENTER]||joy_button_pressed||key[player[0].key.start]||key[player[1].key.start])
	{
		if(!(game_flag&GAME_SELECTION_KEY_WAS_PRESSED))
		{
			game_flag+=GAME_SELECTION_KEY_WAS_PRESSED;
			if(!(game_flag&GAME_SELECTION_DO_ONE_SHOT)) game_flag+=GAME_SELECTION_DO_ONE_SHOT;
		}
		else
		{
			if(game_flag&GAME_SELECTION_DO_ONE_SHOT) game_flag-=GAME_SELECTION_DO_ONE_SHOT;
		}
	}
	else
	{
		if(game_flag&GAME_SELECTION_KEY_WAS_PRESSED) game_flag-=GAME_SELECTION_KEY_WAS_PRESSED;
		if(game_flag&GAME_SELECTION_DO_ONE_SHOT) game_flag-=GAME_SELECTION_DO_ONE_SHOT;
	}


	
	if( (game_flag&GAME_SELECTION_DO_ONE_SHOT) )
		if(game_flag&GAME_AT_TITLE) 
		{
			if(game_flag&GAME_SELECTION_DO_ONE_SHOT) game_flag-=GAME_SELECTION_DO_ONE_SHOT;
			if(game_flag&GAME_SELECTION_START) 
			{
				if(!(game_flag&GAME_START)) 
				{
                    game_flag+=GAME_START;
					if( ( joy_button_pressed ||key[player[0].key.start]) )
					{
                                          
						if(!(player[0].flag&PLAYER_ACTIVE))player[0].flag+=PLAYER_ACTIVE;
						if(!(pause_flag&PAUSE_GAME_HELD)) pause_flag+=PAUSE_GAME_HELD;
						
					}
					else
					{
						if(!(player[1].flag&PLAYER_ACTIVE))player[1].flag+=PLAYER_ACTIVE;
						if(!(pause_flag&PAUSE_GAME_HELD)) pause_flag+=PAUSE_GAME_HELD;
						
					}
				
				}	
					
				if(game_flag&GAME_AT_TITLE)game_flag-=GAME_AT_TITLE;
			}
		
			if(game_flag&GAME_SELECTION_CONFIG) 
			{
				if(!(game_flag&GAME_AT_CONFIG)) game_flag+=GAME_AT_CONFIG;
				if(game_flag&GAME_AT_TITLE)game_flag-=GAME_AT_TITLE;
			}

			if(game_flag&GAME_SELECTION_SCREEN)
			{
				int c=0;

				for(c=0;c<100;c++)
				{
					rest(10);
					silence();
				}
				

				if(game_flag&GAME_SET_FULL_SCREEN)
				{
				if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCREEN_W, SCREEN_H, 0, 0) != 0)
				{
					
					set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, SCREEN_W, SCREEN_H, 0, 0);
					if(!(game_flag&GAME_SET_SCREEN_FAILED)) game_flag+=GAME_SET_SCREEN_FAILED;
					}
					else game_flag-=GAME_SET_FULL_SCREEN;
					
				}
				else
				{
				if (set_gfx_mode(GFX_AUTODETECT_FULLSCREEN, SCREEN_W, SCREEN_H, 0, 0) != 0)
					{
					set_gfx_mode(GFX_AUTODETECT_WINDOWED, SCREEN_W, SCREEN_H, 0, 0);
					if(!(game_flag&GAME_SET_SCREEN_FAILED)) game_flag+=GAME_SET_SCREEN_FAILED;
					}
					else game_flag+=GAME_SET_FULL_SCREEN;
					
				}
            }
		}
		else
			if(game_flag&GAME_AT_CONFIG)
			{
				if(game_flag&GAME_SELECTION_CONFIG_EXIT)
				{
					if(!(game_flag&GAME_AT_TITLE)) game_flag+=GAME_AT_TITLE;
					if(game_flag&GAME_AT_CONFIG) game_flag-=GAME_AT_CONFIG;
				}

				if(game_flag&GAME_SELECTION_CONFIG_PLAYER_1)
				{
					if(!(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_1)) game_flag2+=GAME_SELECTION_DO_CONFIG_PLAYER_1;
					if(game_flag&GAME_AT_CONFIG) game_flag-=GAME_AT_CONFIG;
				}
				
				if(game_flag&GAME_SELECTION_CONFIG_PLAYER_2)
				{
					if(!(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_2)) game_flag2+=GAME_SELECTION_DO_CONFIG_PLAYER_2;
					if(game_flag&GAME_AT_CONFIG) game_flag-=GAME_AT_CONFIG;
				}
			}
		else
			if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_1)
				{
					if(game_set_keys_flag[0]==0)
					{
						if(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT)
						{
							if(!(game_flag&GAME_AT_CONFIG)) game_flag+=GAME_AT_CONFIG;
							if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_1) game_flag2-=GAME_SELECTION_DO_CONFIG_PLAYER_1;
						}
						
						if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
						{
							if(!(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_UP)) game_set_keys_flag[0]+=GAME_SET_PLAYER_KEY_UP;
							if(game_flag2&GAME_ANY_KEY_ONE_SHOT)game_flag2-=GAME_ANY_KEY_ONE_SHOT;
						}
						
						if(game_flag2&GAME_SELECTION_DO_CONFIG_JOY&&num_joysticks>0)
						{
							if(!(game_set_keys_flag[0]&GAME_SET_PLAYER_JOY_FIRE)) game_set_keys_flag[0]+=GAME_SET_PLAYER_JOY_FIRE;
							if(game_flag2&GAME_ANY_KEY_ONE_SHOT)game_flag2-=GAME_ANY_KEY_ONE_SHOT;
						}
					}
					
				}
		else
			if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_2)
				{
					if(game_set_keys_flag[1]==0)
					{
						if(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT)
						{
							if(!(game_flag&GAME_AT_CONFIG)) game_flag+=GAME_AT_CONFIG;
							if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_2) game_flag2-=GAME_SELECTION_DO_CONFIG_PLAYER_2;
						}
						
						if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
						{
							if(!(game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_UP)) game_set_keys_flag[1]+=GAME_SET_PLAYER_KEY_UP;
							if(game_flag2&GAME_ANY_KEY_ONE_SHOT)game_flag2-=GAME_ANY_KEY_ONE_SHOT;
						}
						
						if(game_flag2&GAME_SELECTION_DO_CONFIG_JOY&&num_joysticks>1)
						{
							if(!(game_set_keys_flag[1]&GAME_SET_PLAYER_JOY_FIRE)) game_set_keys_flag[1]+=GAME_SET_PLAYER_JOY_FIRE;
							if(game_flag2&GAME_ANY_KEY_ONE_SHOT)game_flag2-=GAME_ANY_KEY_ONE_SHOT;
						}
					}
					
				}


if(game_set_keys_flag[0] || game_set_keys_flag[1])			
for(i=0;i<2;i++)
{
if((i==0&&game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_1)||(i==1&&game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_2))
if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
{
	if(keyboard_any_key_pressed==1&&game_flag2&GAME_ANY_KEY_ONE_SHOT)
	{
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_UP)
		{
		for(c=0;c<KEY_MAX;c++)
		if(key[c])player[i].key.up=c;
		game_set_keys_flag[i]-=GAME_SET_PLAYER_KEY_UP;
		if(!(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_DOWN)) game_set_keys_flag[i]+=GAME_SET_PLAYER_KEY_DOWN;
		}
		else
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_DOWN)
		{
		for(c=0;c<KEY_MAX;c++)
		if(key[c])player[i].key.down=c;
		game_set_keys_flag[i]-=GAME_SET_PLAYER_KEY_DOWN;
		if(!(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_LEFT)) game_set_keys_flag[i]+=GAME_SET_PLAYER_KEY_LEFT;
		}
		else
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_LEFT)
		{
		for(c=0;c<KEY_MAX;c++)
		if(key[c])player[i].key.left=c;
		game_set_keys_flag[i]-=GAME_SET_PLAYER_KEY_LEFT;
		if(!(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_RIGHT)) game_set_keys_flag[i]+=GAME_SET_PLAYER_KEY_RIGHT;
		}
		else
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_RIGHT)
		{
		for(c=0;c<KEY_MAX;c++)
		if(key[c])player[i].key.right=c;
		game_set_keys_flag[i]-=GAME_SET_PLAYER_KEY_RIGHT;
		if(!(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_FIRE)) game_set_keys_flag[i]+=GAME_SET_PLAYER_KEY_FIRE;
		}
		else
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_FIRE)
		{
		for(c=0;c<KEY_MAX;c++)
		if(key[c])player[i].key.fire=c;
		game_set_keys_flag[i]-=GAME_SET_PLAYER_KEY_FIRE;
		if(!(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_START)) game_set_keys_flag[i]+=GAME_SET_PLAYER_KEY_START;
		}
		else
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_KEY_START)
		{
		for(c=0;c<KEY_MAX;c++)
		if(key[c])player[i].key.start=c;
		game_set_keys_flag[i]-=GAME_SET_PLAYER_KEY_START;
		
		}

	}
}

else
if(game_flag2&GAME_SELECTION_DO_CONFIG_JOY)
{
	if( joy_button_pressed &&num_joysticks>i&&game_flag2&GAME_ANY_KEY_ONE_SHOT)
	{
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_JOY_FIRE)
		{

			for (c2=0; c2<joy[i].num_buttons; c2++) 
				if (joy[i].button[c2].b) 
					{
						player[i].joy.fire=c2;
					}

		game_set_keys_flag[i]-=GAME_SET_PLAYER_JOY_FIRE;
		
		if(!(game_set_keys_flag[i]&GAME_SET_PLAYER_JOY_START)) game_set_keys_flag[i]+=GAME_SET_PLAYER_JOY_START;
		
		}
		else
		if(game_set_keys_flag[i]&GAME_SET_PLAYER_JOY_START)
		{

			for (c2=0; c2<joy[i].num_buttons; c2++) 
				if (joy[i].button[c2].b) 
					{
						player[i].joy.start=c2;
					}

		game_set_keys_flag[i]-=GAME_SET_PLAYER_JOY_START;
		
		
		
		}

	}
}

}

	if( (key[KEY_UP]||joy_stick_up_pressed[0]||joy_stick_up_pressed[1]) && (!(game_set_keys_flag[0] || game_set_keys_flag[1])) )
	{
		if(!(game_flag2&GAME_UP_PRESSED))
		{
			game_flag2+=GAME_UP_PRESSED;
			if(!(game_flag2&GAME_DO_UP_ONE_SHOT)) game_flag2+=GAME_DO_UP_ONE_SHOT;
		}
		else
		{
			if(game_flag2&GAME_DO_UP_ONE_SHOT) game_flag2-=GAME_DO_UP_ONE_SHOT;
		}
	}
	else
	{
		if(game_flag2&GAME_UP_PRESSED) game_flag2-=GAME_UP_PRESSED;
		if(game_flag2&GAME_DO_UP_ONE_SHOT) game_flag2-=GAME_DO_UP_ONE_SHOT;
	}


	if( (key[KEY_DOWN]||joy_stick_down_pressed[0]||joy_stick_down_pressed[1]) && (!(game_set_keys_flag[0] || game_set_keys_flag[1])) )
	{
		if(!(game_flag2&GAME_DOWN_PRESSED))
		{
			game_flag2+=GAME_DOWN_PRESSED;
			if(!(game_flag2&GAME_DO_DOWN_ONE_SHOT)) game_flag2+=GAME_DO_DOWN_ONE_SHOT;
		}
		else
		{
			if(game_flag2&GAME_DO_DOWN_ONE_SHOT) game_flag2-=GAME_DO_DOWN_ONE_SHOT;
		}
	}
	else
	{
		if(game_flag2&GAME_DOWN_PRESSED) game_flag2-=GAME_DOWN_PRESSED;
		if(game_flag2&GAME_DO_DOWN_ONE_SHOT) game_flag2-=GAME_DO_DOWN_ONE_SHOT;
	}

	


	if(game_flag&GAME_AT_TITLE)
	{
		if(game_flag2&GAME_DO_UP_ONE_SHOT)
		{
			if(game_flag&GAME_SELECTION_START)
			{
				if(game_flag&GAME_SELECTION_START) game_flag-=GAME_SELECTION_START; 
				if(!(game_flag&GAME_SELECTION_SCREEN)) game_flag+=GAME_SELECTION_SCREEN; 
			}
			else
			if(game_flag&GAME_SELECTION_CONFIG)
			{
				if(game_flag&GAME_SELECTION_CONFIG) game_flag-=GAME_SELECTION_CONFIG; 
				if(!(game_flag&GAME_SELECTION_START)) game_flag+=GAME_SELECTION_START; 
			}
			else
			if(game_flag&GAME_SELECTION_SCREEN)
			{
				if(game_flag&GAME_SELECTION_SCREEN) game_flag-=GAME_SELECTION_SCREEN; 
				if(!(game_flag&GAME_SELECTION_CONFIG)) game_flag+=GAME_SELECTION_CONFIG; 
			}


		}

		if(game_flag2&GAME_DO_DOWN_ONE_SHOT)
		{
			if(game_flag&GAME_SELECTION_START)
			{
				if(game_flag&GAME_SELECTION_START) game_flag-=GAME_SELECTION_START; 
				if(!(game_flag&GAME_SELECTION_CONFIG)) game_flag+=GAME_SELECTION_CONFIG; 
			}
			else
			if(game_flag&GAME_SELECTION_CONFIG)
			{
				if(game_flag&GAME_SELECTION_CONFIG) game_flag-=GAME_SELECTION_CONFIG; 
				if(!(game_flag&GAME_SELECTION_SCREEN)) game_flag+=GAME_SELECTION_SCREEN; 
			}
			else
			if(game_flag&GAME_SELECTION_SCREEN)
			{
				if(game_flag&GAME_SELECTION_SCREEN) game_flag-=GAME_SELECTION_SCREEN; 
				if(!(game_flag&GAME_SELECTION_START)) game_flag+=GAME_SELECTION_START; 
			}

			
		}
	}
	else
	if(game_flag&GAME_AT_CONFIG)
	{
		if(game_flag2&GAME_DO_UP_ONE_SHOT)
		{
		
			if(game_flag&GAME_SELECTION_CONFIG_PLAYER_1)
			{
				game_flag-=GAME_SELECTION_CONFIG_PLAYER_1;
				if(!(game_flag&GAME_SELECTION_CONFIG_EXIT)) game_flag+=GAME_SELECTION_CONFIG_EXIT; 
			}
			else
			if(game_flag&GAME_SELECTION_CONFIG_PLAYER_2)
			{
				game_flag-=GAME_SELECTION_CONFIG_PLAYER_2;
				if(!(game_flag&GAME_SELECTION_CONFIG_PLAYER_1)) game_flag+=GAME_SELECTION_CONFIG_PLAYER_1; 
			}


		}
		if(game_flag2&GAME_DO_DOWN_ONE_SHOT)
		{
			if(game_flag&GAME_SELECTION_CONFIG_EXIT)
			{
				game_flag-=GAME_SELECTION_CONFIG_EXIT;
				if(!(game_flag&GAME_SELECTION_CONFIG_PLAYER_1)) game_flag+=GAME_SELECTION_CONFIG_PLAYER_1; 
			}
			else
			if(game_flag&GAME_SELECTION_CONFIG_PLAYER_1)
			{
				game_flag-=GAME_SELECTION_CONFIG_PLAYER_1;
				if(!(game_flag&GAME_SELECTION_CONFIG_PLAYER_2)) game_flag+=GAME_SELECTION_CONFIG_PLAYER_2; 
			}
		
		}

	}
	else
	if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_1||game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_2)
	{
		if(game_flag2&GAME_DO_UP_ONE_SHOT)
		{
		
			if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
			{
				game_flag2-=GAME_SELECTION_DO_CONFIG_KEYBOARD;
				if(!(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT)) game_flag2+=GAME_SELECTION_DO_CONFIG_EXIT; 
			}
			else
			if(game_flag2&GAME_SELECTION_DO_CONFIG_JOY)
			{
				game_flag2-=GAME_SELECTION_DO_CONFIG_JOY;
				if(!(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)) game_flag2+=GAME_SELECTION_DO_CONFIG_KEYBOARD; 
			}


		}
		if(game_flag2&GAME_DO_DOWN_ONE_SHOT)
		{
			if(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT)
			{
				game_flag2-=GAME_SELECTION_DO_CONFIG_EXIT;
				if(!(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)) game_flag2+=GAME_SELECTION_DO_CONFIG_KEYBOARD; 
			}
			else
			if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
			{
				game_flag2-=GAME_SELECTION_DO_CONFIG_KEYBOARD;
				if(!(game_flag2&GAME_SELECTION_DO_CONFIG_JOY)) game_flag2+=GAME_SELECTION_DO_CONFIG_JOY; 
			}
		
		}

	}

}

title_display()
{

			solid_mode();
		


vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=0;
vtx[0].v=0;
vtx[0].c=makecol(55+(int)(sin(DEG_2_RAD(0-timer*8))*35),55+(int)(sin(DEG_2_RAD(timer*8))*35),55+(int)(sin(DEG_2_RAD(45-timer*2))*35));


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=0;
vtx[1].v=240;
vtx[1].c=makecol(55+(int)(sin(DEG_2_RAD(90+timer*2))*35),55+(int)(sin(DEG_2_RAD(180+timer*8))*35),55+(int)(sin(DEG_2_RAD(155+timer*2))*35));

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=320;
vtx[2].v=240;
vtx[2].c=makecol(55+(int)(sin(DEG_2_RAD(180+timer*2))*35),55+(int)(sin(DEG_2_RAD(180-timer*2))*35),55+(int)(sin(DEG_2_RAD(225-timer*8))*35));

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=0;
vtx[3].v=240;
vtx[3].c=makecol(55+(int)(sin(DEG_2_RAD(270+timer*8))*35),55+(int)(sin(DEG_2_RAD(315+timer*8))*35),55+(int)(sin(DEG_2_RAD(0+timer*2))*35));

		

	
		quad3d_f(buffer, POLYTYPE_GRGB, NULL, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);


	if(game_flag&GAME_AT_TITLE)
	{
				sprintf(msg, "SPACE GAME");
				textout_centre_ex(buffer, font, msg,SCREEN_W_USE/2, 20, makecol(220,20,50),-1);
	

		if(game_flag&GAME_SELECTION_START)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 150);

				sprintf(msg, "START");
				textout_ex(buffer, font, msg,120, 150, makecol(220,180,180),-1);
	
				sprintf(msg, "CONFIGURATION");
				textout_ex(buffer, font, msg,120, 180, makecol(128,64,64),-1);

				sprintf(msg, "SCREEN (FULL/WINDOWED)");
				textout_ex(buffer, font, msg,120, 210, makecol(128,64,64),-1);

				
		}

		if(game_flag&GAME_SELECTION_CONFIG)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 180);

				sprintf(msg, "START");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);
	
				sprintf(msg, "CONFIGURATION");
				textout_ex(buffer, font, msg,120, 180, makecol(220,180,180),-1);

				sprintf(msg, "SCREEN (FULL/WINDOWED)");
				textout_ex(buffer, font, msg,120, 210, makecol(128,64,64),-1);
		}

		if(game_flag&GAME_SELECTION_SCREEN)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 210);

				sprintf(msg, "START");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);
	
				sprintf(msg, "CONFIGURATION");
				textout_ex(buffer, font, msg,120, 180, makecol(128,64,64),-1);

				sprintf(msg, "SCREEN (FULL/WINDOWED)");
				textout_ex(buffer, font, msg,120, 210, makecol(220,180,180),-1);

				if(game_flag&GAME_SET_SCREEN_FAILED)
				{
				sprintf(msg, "GAME CHANGE SCREEN FAILED");
				textout_ex(buffer, font, msg,120, 230, makecol(225,64,64),-1);
				}
		}
	

	}


	if(game_flag&GAME_AT_CONFIG)
	{
				sprintf(msg, "CONFIGURATION");
				textout_centre_ex(buffer, font, msg,SCREEN_W_USE/2, 20, makecol(220,20,50),-1);


	if(game_flag&GAME_SELECTION_CONFIG_EXIT)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 100);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(220,180,180),-1);
	
				sprintf(msg, "PLAYER 1");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);

				sprintf(msg, "PLAYER 2");
				textout_ex(buffer, font, msg,120, 200, makecol(128,64,64),-1);
		}

	if(game_flag&GAME_SELECTION_CONFIG_PLAYER_1)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 150);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(128,64,64),-1);
	
				sprintf(msg, "PLAYER 1");
				textout_ex(buffer, font, msg,120, 150, makecol(220,180,180),-1);

				sprintf(msg, "PLAYER 2");
				textout_ex(buffer, font, msg,120, 200, makecol(128,64,64),-1);
		}

	if(game_flag&GAME_SELECTION_CONFIG_PLAYER_2)
		{
				draw_sprite(buffer,datafile[player[1].frame.start].dat, 80, 200);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(128,64,64),-1);
	
				sprintf(msg, "PLAYER 1");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);

				sprintf(msg, "PLAYER 2");
				textout_ex(buffer, font, msg,120, 200, makecol(220,180,180),-1);
		}


	}

if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_1)
						
	{
				sprintf(msg, "PLAYER 1 INPUT SETTINGS");
				textout_centre_ex(buffer, font, msg,SCREEN_W_USE/2, 20, makecol(220,20,50),-1);

				sprintf(msg, "UP [%s]",key_names[player[0].key.up] );
				textout_ex(buffer, font, msg,200, 150, makecol(64,64,128),-1);

				sprintf(msg, "DOWN [%s]",key_names[player[0].key.down] );
				textout_ex(buffer, font, msg,200, 158, makecol(64,64,128),-1);

				sprintf(msg, "LEFT [%s]",key_names[player[0].key.left] );
				textout_ex(buffer, font, msg,200, 166, makecol(64,64,128),-1);

				sprintf(msg, "RIGHT [%s]",key_names[player[0].key.right] );
				textout_ex(buffer, font, msg,200, 174, makecol(64,64,128),-1);

				sprintf(msg, "FIRE [%s]",key_names[player[0].key.fire] );
				textout_ex(buffer, font, msg,200, 182, makecol(64,64,128),-1);

				sprintf(msg, "START [%s]",key_names[player[0].key.start] );
				textout_ex(buffer, font, msg,200, 190, makecol(64,64,128),-1);

				if(num_joysticks>0)
				{
				sprintf(msg, "BUTTON %d",player[0].joy.fire );
				textout_ex(buffer, font, msg,200, 200, makecol(64,64,128),-1);

				sprintf(msg, "BUTTON %d",player[0].joy.start);
				textout_ex(buffer, font, msg,200, 208, makecol(64,64,128),-1);
				}



		
		if(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 100);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(220,180,180),-1);
	
				sprintf(msg, "KEYBOARD");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);

				if(num_joysticks>0) sprintf(msg, "JOY STICK");
				else sprintf(msg, "JOY STICK N/A");
				textout_ex(buffer, font, msg,120, 200, makecol(128,64,64),-1);
		}

	if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 150);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(128,64,64),-1);
	
				sprintf(msg, "KEYBOARD");
				textout_ex(buffer, font, msg,120, 150, makecol(220,180,180),-1);

				if(num_joysticks>0) sprintf(msg, "JOY STICK");
				else sprintf(msg, "JOY STICK N/A");
				textout_ex(buffer, font, msg,120, 200, makecol(128,64,64),-1);
		}

	if(game_flag2&GAME_SELECTION_DO_CONFIG_JOY)
		{
				draw_sprite(buffer,datafile[player[0].frame.start].dat, 80, 200);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(128,64,64),-1);
	
				sprintf(msg, "KEYBOARD");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);

				if(num_joysticks>0) sprintf(msg, "JOY STICK");
				else sprintf(msg, "JOY STICK N/A");
				textout_ex(buffer, font, msg,120, 200, makecol(220,180,180),-1);
		}
	}

if(game_flag2&GAME_SELECTION_DO_CONFIG_PLAYER_2)
						
	{
				sprintf(msg, "PLAYER 2 INPUT SETTINGS");
				textout_centre_ex(buffer, font, msg,SCREEN_W_USE/2, 20, makecol(220,20,50),-1);

				sprintf(msg, "UP [%s]",key_names[player[1].key.up] );
				textout_ex(buffer, font, msg,200, 150, makecol(64,64,128),-1);

				sprintf(msg, "DOWN [%s]",key_names[player[1].key.down] );
				textout_ex(buffer, font, msg,200, 158, makecol(64,64,128),-1);

				sprintf(msg, "LEFT [%s]",key_names[player[1].key.left] );
				textout_ex(buffer, font, msg,200, 166, makecol(64,64,128),-1);

				sprintf(msg, "RIGHT [%s]",key_names[player[1].key.right] );
				textout_ex(buffer, font, msg,200, 174, makecol(64,64,128),-1);

				sprintf(msg, "FIRE [%s]",key_names[player[1].key.fire] );
				textout_ex(buffer, font, msg,200, 182, makecol(64,64,128),-1);

				sprintf(msg, "START [%s]",key_names[player[1].key.start] );
				textout_ex(buffer, font, msg,200, 190, makecol(64,64,128),-1);

				if(num_joysticks>1)
				{
				sprintf(msg, "BUTTON %d",player[1].joy.fire );
				textout_ex(buffer, font, msg,200, 200, makecol(64,64,128),-1);

				sprintf(msg, "BUTTON %d",player[1].joy.start);
				textout_ex(buffer, font, msg,200, 208, makecol(64,64,128),-1);
				}
		
		if(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT)
		{
				draw_sprite(buffer,datafile[player[1].frame.start].dat, 80, 100);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(220,180,180),-1);
	
				sprintf(msg, "KEYBOARD");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);

				if(num_joysticks>1) sprintf(msg, "JOY STICK");
				else sprintf(msg, "JOY STICK N/A");
				textout_ex(buffer, font, msg,120, 200, makecol(128,64,64),-1);
		}

	if(game_flag2&GAME_SELECTION_DO_CONFIG_KEYBOARD)
		{
				draw_sprite(buffer,datafile[player[1].frame.start].dat, 80, 150);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(128,64,64),-1);
	
				sprintf(msg, "KEYBOARD");
				textout_ex(buffer, font, msg,120, 150, makecol(220,180,180),-1);

				if(num_joysticks>1) sprintf(msg, "JOY STICK");
				else sprintf(msg, "JOY STICK N/A");
				textout_ex(buffer, font, msg,120, 200, makecol(128,64,64),-1);
		}

	if(game_flag2&GAME_SELECTION_DO_CONFIG_JOY)
		{
				draw_sprite(buffer,datafile[player[1].frame.start].dat, 80, 200);

				sprintf(msg, "EXIT");
				textout_ex(buffer, font, msg,120, 100, makecol(128,64,64),-1);
	
				sprintf(msg, "KEYBOARD");
				textout_ex(buffer, font, msg,120, 150, makecol(128,64,64),-1);

				if(num_joysticks>1) sprintf(msg, "JOY STICK");
				else sprintf(msg, "JOY STICK N/A");
				textout_ex(buffer, font, msg,120, 200, makecol(220,180,180),-1);
		}
	}

	if(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_UP || game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_UP)
	{
		        sprintf(msg, "PRESS KEYBOARD UP KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}

	if(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_DOWN || game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_DOWN)
	{
		        sprintf(msg, "PRESS KEYBOARD DOWN KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}

	
	if(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_LEFT || game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_LEFT)
	{
		        sprintf(msg, "PRESS KEYBOARD LEFT KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}
	
	if(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_RIGHT || game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_RIGHT)
	{
		        sprintf(msg, "PRESS KEYBOARD RIGHT KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}
	
	if(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_FIRE || game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_FIRE)
	{
		        sprintf(msg, "PRESS KEYBOARD FIRE KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}
	
	if(game_set_keys_flag[0]&GAME_SET_PLAYER_KEY_START || game_set_keys_flag[1]&GAME_SET_PLAYER_KEY_START)
	{
		        sprintf(msg, "PRESS KEYBOARD START KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}
	
	if(game_set_keys_flag[0]&GAME_SET_PLAYER_JOY_FIRE || game_set_keys_flag[1]&GAME_SET_PLAYER_JOY_FIRE)
	{
		        sprintf(msg, "PRESS JOY STICK FIRE KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}
	
	if(game_set_keys_flag[0]&GAME_SET_PLAYER_JOY_START || game_set_keys_flag[1]&GAME_SET_PLAYER_JOY_START)
	{
		        sprintf(msg, "PRESS JOY STICK START KEY");
				textout_centre_ex(buffer, font, msg,120, 60, makecol(220,180,180),-1);
	}


}


title_screen()
{
	int c=0;
	int start=TRUE;
	if(!(game_flag&GAME_AT_TITLE)) game_flag+=GAME_AT_TITLE;
	if(!(game_flag&GAME_SELECTION_START))game_flag+=GAME_SELECTION_START;
	if(!(game_flag&GAME_SELECTION_CONFIG_EXIT))game_flag+=GAME_SELECTION_CONFIG_EXIT;
	if(!(game_flag2&GAME_SELECTION_DO_CONFIG_EXIT))game_flag2+=GAME_SELECTION_DO_CONFIG_EXIT;



	while ( start==TRUE )
    {
        start=FALSE; 
		for(c=0;c<42;c++)
		generate_wave(FALSE, c,0,500,2500,PWM,0,2000);
		update_music();
		
		if(key[player[0].key.start])	start=TRUE;
		if(key[player[1].key.start])	start=TRUE;

		poll_joystick();

		if(num_joysticks>0)
			if(joy[0].button[player[0].joy.start].b)	start=TRUE;
				

		if(num_joysticks>1)
			if(joy[0].button[player[1].joy.start].b)	start=TRUE;
	}

	while ((!(key[KEY_ESC]))&&(!(game_flag&GAME_EXIT))&&(!(game_flag&GAME_START)) )
    {
            /*this while statement keeps the game at a constant speed*/
            while (speed_counter > 0)
            {
	
						start_sweep_flag=TRUE;
						do_sweep(3);

				generate_wave(TRUE, 12,0,500,6500,TRIANGLE,0,1650*2+(sin(DEG_2_RAD((int)(8*timer)%360))*1650*2) );
				generate_wave(TRUE, 15,0,500,6500,TRIANGLE,0,450*2+(sin(DEG_2_RAD((int)(2*timer-36*1)%360))*450*2));
				generate_wave(TRUE, 17,0,500,6500,TRIANGLE,0,1650*2+(sin(DEG_2_RAD((int)(8*timer-36*2)%360))*1650*2));
				generate_wave(TRUE, 19,0,500,6500,TRIANGLE,0,450*2+(sin(DEG_2_RAD((int)(2*timer-36*3)%360))*450*2));
				generate_wave(TRUE, 21,0,500,6500,TRIANGLE,0,1650*2+(sin(DEG_2_RAD((int)(8*timer-36*4)%360))*1650*2));
				generate_wave(TRUE, 24,0,500,6500,TRIANGLE,0,450*2+(sin(DEG_2_RAD((int)(2*timer-36*5)%360))*450*2));
				generate_wave(TRUE, 27,0,500,6500,TRIANGLE,0,1650*2+(sin(DEG_2_RAD((int)(8*timer-36*6)%360))*1650*2));
				generate_wave(TRUE, 29,0,500,6500,TRIANGLE,0,450*2+(sin(DEG_2_RAD((int)(2*timer-36*7)%360))*450*2));
				generate_wave(TRUE, 31,0,500,6500,TRIANGLE,0,1650*2+(sin(DEG_2_RAD((int)(8*timer-36*8)%360))*1650*2));
				generate_wave(TRUE, 33,0,500,6500,TRIANGLE,0,450*2+(sin(DEG_2_RAD((int)(2*timer-36*9)%360))*450*2));
			

				
				
				
				title_input();
                
                
          speed_counter--;
		  
		  update_music();
          
            }

			


			
             
             title_display();
             
             /*draws the buffer to the screen*/
             masked_stretch_blit(buffer, screen, 0, 0,
                          320, 240,
                          0, 0, SCREEN_W, SCREEN_H);
             
             /*clears the buffer*/
             clear_to_color(buffer,makecol(0,0,0));
             
			 
      }

if(key[KEY_ESC]&&(!(game_flag&GAME_EXIT)) ) game_flag+=GAME_EXIT;
timer=0;

				start_sweep_flag=FALSE;
				stop_sweep();

for(c=0;c<42;c++)
generate_wave(FALSE, c,0,500,2500,PWM,0.02/(c*3+1),2000);

if(game_flag&GAME_AT_TITLE) game_flag=GAME_AT_TITLE;
}

show_ending()
{
	int c=0;

	int start=FALSE;

	int blue_good=FALSE;
	int red_good=FALSE;
	int planet_good=FALSE;

	stop_midi();
	
	

	if(player[0].flag&PLAYER_ACTIVE) red_good=TRUE;
	if(player[1].flag&PLAYER_ACTIVE) blue_good=TRUE;

	if(player[0].flag&PLAYER_ACTIVE || player[1].flag&PLAYER_ACTIVE) planet_good=TRUE;

	if(planet_good==TRUE) play_midi(datafile_music[9].dat, TRUE);
	else play_midi(datafile_music[8].dat, TRUE);

	timer=0;
	while(timer<2)
	{
	for(c=0;c<42;c++)
		generate_wave(FALSE, c,0,500,2500,PWM,0,2000);
	update_music();
	}

	
	while ( start==FALSE && (!(key[KEY_ESC])) )
    {
		if(key[player[0].key.start])	start=TRUE;
		if(key[player[1].key.start])	start=TRUE;

		poll_joystick();

		if(num_joysticks>0)
			if(joy[0].button[player[0].joy.start].b)	start=TRUE;
				

		if(num_joysticks>1)
			if(joy[0].button[player[1].joy.start].b)	start=TRUE;

                /*this while statement keeps the game at a constant speed*/
            while (speed_counter > 0)
            {
		    
          speed_counter--;
		  
		  update_music();
          
            }

			
solid_mode();          

rectfill(buffer,0,0,SCREEN_W_USE,SCREEN_H_USE,makecol(128,225,255));

if(planet_good==TRUE) stretch_sprite(buffer,datafile_background[32].dat,25,0,96*1.5,96*1.5);             
else stretch_sprite(buffer,datafile_background[31].dat,25,0,96*1.5,96*1.5); 

circlefill(buffer,160,900,850,makecol(125,155,96));
circlefill(buffer,160,900,849,makecol(120,180,128));

if(player[0].flag&PLAYER_WAS_ACTIVE)
	if(red_good==TRUE)
	{
		stretch_sprite(buffer,datafile_background[23].dat,0,25,96*1.75,96*1.75);
		stretch_sprite(buffer,datafile_background[27].dat,-30,40,96*1.75,96*1.75);
	}
	else
	{
		stretch_sprite(buffer,datafile_background[25].dat,0,25,96*1.75,96*1.75);
		stretch_sprite(buffer,datafile_background[29].dat,-30,40,96*1.75,96*1.75);
	}

if(player[1].flag&PLAYER_WAS_ACTIVE)
	if(blue_good==TRUE)
	{
		stretch_sprite(buffer,datafile_background[24].dat,SCREEN_W_USE-96*1.75,25,96*1.75,96*1.75);
		stretch_sprite(buffer,datafile_background[28].dat,SCREEN_W_USE-96*1.75,40,96*1.75,96*1.75);
	}
	else
	{
		stretch_sprite(buffer,datafile_background[26].dat,SCREEN_W_USE-96*1.75,25,96*1.75,96*1.75);
		stretch_sprite(buffer,datafile_background[30].dat,SCREEN_W_USE-96*1.75,40,96*1.75,96*1.75);
	}




clear_to_color(buffer_title,makecol(255,0,255));

if(planet_good==FALSE)	sprintf(msg, "GAME OVER");
else sprintf(msg, "YOU WIN");

	textout_centre_ex(buffer_title, font, msg,40, 16, makecol(180,(int)(140+(cos(DEG_2_RAD(timer*15))*100)),(int)(100+(sin(DEG_2_RAD(timer*15))*80))),-1);
masked_stretch_blit(buffer_title, buffer, 0,0,80,32, -10, 0+65, 320+20, 240);
             
             
             /*draws the buffer to the screen*/
             
			 masked_stretch_blit(buffer, screen, 0, 0,
                          320, 240,
                          0, 0, SCREEN_W, SCREEN_H);
             
             /*clears the buffer*/
             clear_to_color(buffer,makecol(0,0,0));
            
			 
      }

		level=-1;
		game_flag=0;
		game_flag2=0;
		
		
		
		stop_midi();
			
		if(planet_good==FALSE) 
		{
			player[0].flag=0;
			player[1].flag=0;
			continues=continue_preset;
			player[0].start_lives=3;
			player[0].lives=player[0].start_lives;
			player[1].start_lives=3;
			player[1].lives=player[1].start_lives;
			player[0].score=0;
			player[1].score=0;
		}

			for(c=0;c<BULLET_MAX;c++)
	{
		if(bullet[c].flag&BULLET_ACTIVE)
		{
			bullet[c].flag-=BULLET_ACTIVE;

		}
	}
		
		title_screen();
		timer=-200;
		level_flag=0;
		level_flag=LEVEL_START;
		load_song_flag=0;
		
}

void paused()
{
	
	int start[2]={0,0};
	

	
	poll_joystick();

	
	if(key[player[0].key.start]) start[0]=1;

	if(num_joysticks>0)
	{
		if(joy[0].button[player[0].joy.start].b) start[0]=1;
	}

	if(key[player[1].key.start]) start[1]=1;

	if(num_joysticks>1)
	{
		if(joy[1].button[player[1].joy.start].b) start[1]=1;
	}
	
	if( (!(start[0]||start[1])) && (pause_flag&PAUSE_GAME_HELD) ) pause_flag-=PAUSE_GAME_HELD;

	if( (!(pause_flag&PAUSE_GAME_HELD)) && (pause_flag&PAUSE_GAME) )
	{

		if(start[0]||start[1]) 
		{
			pause_flag-=PAUSE_GAME;
			pause_flag+=PAUSE_GAME_HELD;
			set_volume(255, 70*2);

			if(player[0].flag&PLAYER_DO_SHOT||player[1].flag&PLAYER_DO_SHOT)
			{
				play_sample(datafile_music[0].dat, 16, 128, 1400, TRUE);
				sample_for_shooting_is_playing=TRUE;

			}

		}



	}

	silence();
	


}

/*function for user inputs*/
void input()
{
	int up[2]={0,0};
	int down[2]={0,0};
	int left[2]={0,0};
	int right[2]={0,0};
	int fire[2]={0,0};
	int start[2]={0,0};
	int c=0;

	
	poll_joystick();

	if(key[player[0].key.up]) up[0]=1;
	if(key[player[0].key.down]) down[0]=1;
	if(key[player[0].key.left]) left[0]=1;
	if(key[player[0].key.right]) right[0]=1;
	if(key[player[0].key.fire]) fire[0]=1;
	if(key[player[0].key.start]) start[0]=1;

	if(num_joysticks>0)
	{
		
if(joy[0].stick[0].axis[1].d1)up[0]=1;
if(joy[0].stick[0].axis[1].d2)down[0]=1;
if(joy[0].stick[0].axis[0].d1)left[0]=1;
if(joy[0].stick[0].axis[0].d2)right[0]=1;

if(joy[0].button[player[0].joy.fire].b) fire[0]=1;
if(joy[0].button[player[0].joy.start].b) start[0]=1;

	}

	




	if(key[player[1].key.up]) up[1]=1;
	if(key[player[1].key.down]) down[1]=1;
	if(key[player[1].key.left]) left[1]=1;
	if(key[player[1].key.right]) right[1]=1;
	if(key[player[1].key.fire]) fire[1]=1;
	if(key[player[1].key.start]) start[1]=1;

	if(num_joysticks>1)
	{
		
if(joy[1].stick[0].axis[1].d1)up[1]=1;
if(joy[1].stick[0].axis[1].d2)down[1]=1;
if(joy[1].stick[0].axis[0].d1)left[1]=1;
if(joy[1].stick[0].axis[0].d2)right[1]=1;

if(joy[1].button[player[1].joy.fire].b) fire[1]=1;
if(joy[1].button[player[1].joy.start].b) start[1]=1;

	}		
		


for(c=0;c<2;c++)
{
	if(start[c])
	{
		
		if(continues>0 && (!(player[c].flag&PLAYER_ACTIVE)) )
		{
	    player[c].flag=0;
		player[c].flag+=PLAYER_ACTIVE;
		if(player[c].flag&PLAYER_LIVES_DONE)player[c].flag-=PLAYER_LIVES_DONE;
		
		player[c].regen_timer=timer+player[c].regen_time_length;
		continues--;
		if(player[c].lives<=0)player[c].lives=player[c].start_lives;
		else
			player[c].lives=player[c].start_lives;

		player[c].score=0;

		if(!(pause_flag&PAUSE_GAME_HELD)) pause_flag+=PAUSE_GAME_HELD;
		}

	



	

		
	}



    if(!(player[c].flag&PLAYER_ACTIVE))
	{
		if(player[c].flag&PLAYER_DO_SHOT) player[c].flag-=PLAYER_DO_SHOT;
		
		if(sample_for_shooting_is_playing==TRUE && (!(player[0].flag&PLAYER_DO_SHOT)) && (!(player[1].flag&PLAYER_DO_SHOT)) )
		{
			stop_sample(datafile_music[0].dat);
			play_sample(datafile_music[0].dat, 16, 128, 1000, FALSE);
			
			sample_for_shooting_is_playing=FALSE;
		}
	}
	else
	{
		if(fire[c]&&(!(player[c].flag&PLAYER_DO_SHOT))) 
		{
			player[c].flag+=PLAYER_DO_SHOT;
			if(sample_for_shooting_is_playing==FALSE && (!(player[0].flag&PLAYER_DO_SHOT && player[1].flag&PLAYER_DO_SHOT)) ) 
			{
				play_sample(datafile_music[0].dat, 16, 128, 1400, TRUE);
				sample_for_shooting_is_playing=TRUE;
			}

			
			
			
		
		}
		if( (!(fire[c])) && player[c].flag&PLAYER_DO_SHOT) 
		{
			player[c].flag-=PLAYER_DO_SHOT;
			
			
			if(sample_for_shooting_is_playing==TRUE && (!(player[0].flag&PLAYER_DO_SHOT)) && (!(player[1].flag&PLAYER_DO_SHOT)) )
			{
				stop_sample(datafile_music[0].dat);
				
				play_sample(datafile_music[0].dat, 16, 128, 1000, FALSE);
				sample_for_shooting_is_playing=FALSE;
			}

		}
	}
		


	if(!(right[c] && left[c]) )
	{		
if (left[c]) 
		{

	if(player[c].flag&PLAYER_ACTIVE)
			{
		player[c].pos.x-=2;
			}
	
		}


	



if (right[c]) 
		{
	if(player[c].flag&PLAYER_ACTIVE)
			{
		player[c].pos.x+=2;
			}
	
		}

	}

	if(! (down[c]&& up[c] ) )
	{		
if (up[c]) 
		{

	if(player[c].flag&PLAYER_ACTIVE)
			{
		player[c].pos.y-=2;
			}
	
		}


	



if (down[c]) 
		{
	if(player[c].flag&PLAYER_ACTIVE)
			{
		player[c].pos.y+=2;
			}
	
		}

	}
}

	if(pause_flag==0)
	{
		
		if(start[0]||start[1]) 
		{
			pause_flag+=PAUSE_GAME;
			pause_flag+=PAUSE_GAME_HELD;
			set_volume(1, 32*2);

			stop_sample(datafile_music[0].dat);
			play_sample(datafile_music[0].dat, 16*2, 128, 1000, FALSE);
			
			sample_for_shooting_is_playing=FALSE;
			
		}


	}

	
	if( (!(start[0]||start[1])) && (pause_flag&PAUSE_GAME_HELD) ) pause_flag-=PAUSE_GAME_HELD;

	if( (!(pause_flag&PAUSE_GAME_HELD)) && (pause_flag&PAUSE_GAME) )
	{

		if(start[0]||start[1]) 
		{
			pause_flag-=PAUSE_GAME;
			pause_flag+=PAUSE_GAME_HELD;
			set_volume(255, 70*2);
		}



	}
		

}

update_anim()
{
	int c;


	for(c=0;c<2;c++)
	{
	player[c].frame.pos=player[c].frame.speed*frame;
	player[c].frame.pos=player[c].frame.pos%player[c].frame.total;
	player[c].frame.act=player[c].frame.start+player[c].frame.pos;
	}


	for(c=0;c<ENEMY_MAX_ON_SCREEN;c++)
		if(enemy[c].flag&ENEMY_DRAW)
		{
	enemy[c].frame.pos=enemy[c].frame.speed*frame;
	enemy[c].frame.pos=enemy[c].frame.pos%enemy[c].frame.total;
	enemy[c].frame.act=enemy[c].frame.start+enemy[c].frame.pos;
		}

}



/* --- collide --- */
int sn_collision(BITMAP *s1, int s1x1, int s1y1, BITMAP *s2, int s2x1, int s2y1)
{
    int mask = bitmap_mask_color(s1);
    int s1x2 = s1x1 + s1->w - 1;
    int s1y2 = s1y1 + s1->h - 1;
    int s2x2 = s2x1 + s2->w - 1;
    int s2y2 = s2y1 + s2->h - 1;

    int left = s1x1;
    int right = s1x2;
    int top = s1y1;
    int bottom = s1y2;

    int x, y;

    if(s1x1 > s2x2 || s1x2 < s2x1 || s1y1 > s2y2 || s1y2 < s2y1)
    {
        return FALSE;
    }

    if(s1x1 <= s2x1)    left = s2x1;
    if(s1x2 >= s2x2)    right = s2x2;
    if(s1y1 <= s2y1)    top = s2y1;
    if(s1y2 >= s2y2)    bottom = s2y2;

    for(y = top; y <= bottom; y++)
    {
        for(x = left; x <= right; x++)
        {
            if((getpixel(s1, x - s1x1, y - s1y1) != mask) &&
               (getpixel(s2, x - s2x1, y - s2y1) != mask))
            {
                 return TRUE;
            }
        }
    }

    return FALSE;
}

int sn_collision_color(BITMAP *s1, int s1x1, int s1y1, BITMAP *s2, int s2x1, int s2y1)
{
    int mask = bitmap_mask_color(s1);
    int s1x2 = s1x1 + s1->w - 1;
    int s1y2 = s1y1 + s1->h - 1;
    int s2x2 = s2x1 + s2->w - 1;
    int s2y2 = s2y1 + s2->h - 1;

    int left = s1x1;
    int right = s1x2;
    int top = s1y1;
    int bottom = s1y2;

    int x, y;

    if(s1x1 > s2x2 || s1x2 < s2x1 || s1y1 > s2y2 || s1y2 < s2y1)
    {
        return FALSE;
    }

    if(s1x1 <= s2x1)    left = s2x1;
    if(s1x2 >= s2x2)    right = s2x2;
    if(s1y1 <= s2y1)    top = s2y1;
    if(s1y2 >= s2y2)    bottom = s2y2;

    for(y = top; y <= bottom; y++)
    {
        for(x = left; x <= right; x++)
        {
            if((getpixel(s1, x - s1x1, y - s1y1) != mask) &&
               (getpixel(s2, x - s2x1, y - s2y1) != mask))
            {
                 return getpixel(s1, x - s1x1, y - s1y1);
            }
        }
    }

    return FALSE;
}


get_angle(float to_x, float to_y, float at_x, float at_y, float *to_angle)
{
	struct XANDY sub;
	float at_angle=0;
	int test_angle=0;

	sub.x=to_x-at_x;
	sub.y=to_y-at_y;

	at_angle=180+RAD_2_DEG(atan2(sub.y,sub.x));

	
	
	

	

at_angle-=90;
if(at_angle<0)at_angle=360+at_angle;

if(*to_angle<0) *to_angle=360+*to_angle;
if(*to_angle>=360)*to_angle=*to_angle-360;

test_angle=*to_angle-at_angle;

if(test_angle<180&&test_angle>1)
*to_angle-=1;

if(test_angle>=180&&test_angle<359) *to_angle+=1;

if(test_angle<-1)
{
	if(test_angle>-180&&test_angle>-359) *to_angle+=1;
	else
		*to_angle-=1;
}


	
}

init_shot_boss(int c)
{
	struct SHOT shot_init={
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0 };
	

	if(level==0)
	{
/*boss 1*/
	if(c==0)
		{
		if (boss[0].fire_type==0) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.5;
			shot_init.delay=1;
			shot_init.image=26;
			
			
			}

		if (boss[0].fire_type==1) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.5;
			shot_init.delay=1;
			shot_init.image=26;
			
			
			}

		if (boss[0].fire_type==2) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=0;
			shot_init.speed=1.5;
			shot_init.delay=1;
			shot_init.image=26;
			
			
			}

		if (boss[0].fire_type==3) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=180;
			shot_init.speed=1.5;
			shot_init.delay=1;
			shot_init.image=26;
			
			
			}
		
		if (boss[0].fire_type==4) 
			{
			

			shot_init.flag+=SHOT_MULTI_2;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=2;
			shot_init.delay=3;
			shot_init.image=10;
			
			
			}
		}
	}

	if(level==1)
	{
	/*boss 2*/
	if(c==0)
		{
		if (boss[0].fire_type==0) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.3;
			shot_init.delay=1;
			shot_init.image=5;
			
			
			}

		if (boss[0].fire_type==1) 
			{
			

			shot_init.flag+=SHOT_MULTI_2;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=0;
			shot_init.speed=1.2;
			shot_init.delay=4;
			shot_init.image=27;
			
			
			}
		}
	}

	if(level==2)
	{
/*boss 3*/
if(c==0)
		{
		if (boss[0].fire_type==0) 
			{
			

			
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.5;
			shot_init.delay=1;
			shot_init.image=11;
			
			
			}

		if (boss[0].fire_type==1) 
			{
			

			
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.5;
			shot_init.delay=1;
			shot_init.image=11;
			
			
			}

		if (boss[0].fire_type==2) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=45;
			shot_init.speed=0.75;
			shot_init.delay=1;
			shot_init.image=5;
			
			
			}

		if (boss[0].fire_type==3) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=135;
			shot_init.speed=0.75;
			shot_init.delay=1;
			shot_init.image=5;
			
			
			}
		
		if (boss[0].fire_type==4) 
			{
			

			
			shot_init.type=boss[0].fire_type;

			shot_init.angle=0;
			shot_init.speed=2;
			shot_init.delay=1;
			shot_init.image=26;
			
			
			}
		
		if (boss[0].fire_type==5) 
			{
			

			
			shot_init.type=boss[0].fire_type;

			shot_init.angle=180;
			shot_init.speed=2;
			shot_init.delay=1;
			shot_init.image=26;
			
			
			}
		}
	}

	if(level==3)
	{
	/*boss 4*/
	if(c==0)
		{
		if (boss[0].fire_type==0) 
			{
			

			shot_init.flag+=SHOT_MULTI_2;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.2;
			shot_init.delay=2;
			shot_init.image=28;
			
			
			}

		if (boss[0].fire_type==1) 
			{
			

			shot_init.flag+=SHOT_MULTI_2;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1.2;
			shot_init.delay=2;
			shot_init.image=28;
			
			
			}

		if (boss[0].fire_type==2) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=45;
			shot_init.speed=1;
			shot_init.delay=2;
			shot_init.image=29;
			
			
			}

		if (boss[0].fire_type==3) 
			{
			

			shot_init.flag+=SHOT_MULTI_5;
			shot_init.type=boss[0].fire_type;

			shot_init.angle=135;
			shot_init.speed=1;
			shot_init.delay=2;
			shot_init.image=29;
			
			
			}

		if (boss[0].fire_type==4) 
			{
			

			
			shot_init.type=boss[0].fire_type;

			shot_init.angle=90;
			shot_init.speed=1;
			shot_init.delay=1;
			shot_init.image=30;
			
			
			}
		
		
		}
	}

	boss[0].shot=shot_init;
	


}

generate_bullet_boss_pos(int c,int count,int flag, int type,struct XANDY *pos)
{

	int c1=0;

	if(level==0)
	{
	/*boss 1*/
		if(c==0)
		{
		pos->x=boss[0].pos.x+rand()%15;
		pos->y=boss[0].pos.y+rand()%15;

		
		if(type==0||type==3)
			{

			pos->x+=15;
			pos->y+=30;

			}

		if(type==1||type==2)
			{

			pos->x+=100;
			pos->y+=30;

			}


		if(type==4)
			{

			if(count==1)pos->x+=-10;
			if(count==2)pos->x+=110;
			pos->y+=30;

			}
		}
	}

	if(level==1)
	{

	/*boss 2*/
		if(c==0)
		{
		pos->x=boss[0].pos.x+rand()%15;
		pos->y=boss[0].pos.y+rand()%15;

		
	


		if(type==0)
			{

			if(count>3)pos->x+=20;
			if(count<3)pos->x+=70;
			pos->y+=15;

			}

		if(type==1)
			{

			if(count==1)pos->x+=30;
			if(count==2)pos->x+=60;
			pos->y+=90;

			if(count==1)boss[0].shot.angle=180;
			if(count==2)boss[0].shot.angle=0;

			}

				

		
		}
	}

	if(level==2)
	{
	/*boss 3*/
		if(c==0)
		{
	pos->x=boss[0].weapon[type].pos.x;
	pos->y=boss[0].weapon[type].pos.y;
		}
	}



	if(level==3)
	{
	/*boss 4*/
		if(type==0)
		{
		pos->x=boss[0].pos.x+25;
		if(count==1)pos->x+=65;
		pos->y=boss[0].pos.y+80;
		}
		if(type==1)
		{
		pos->x=boss[0].pos.x+110;
		if(count==1)pos->x+=65;
		pos->y=boss[0].pos.y+80;
		}

		if(type==2)
		{
		pos->x=boss[0].pos.x+40+rand()%2;
		
		pos->y=boss[0].pos.y+40;
		}
		if(type==3)
		{
		pos->x=boss[0].pos.x+110+rand()%2;
		
		pos->y=boss[0].pos.y+40;
		}
		if(type==4)
		{
		boss[0].shot.speed=50+(int)(rand()%100);
		boss[0].shot.speed*=0.01;
		boss[0].shot.delay=100+(int)(rand()%100);
		boss[0].shot.delay*=0.01;
		pos->x=0+rand()%304;
		
		pos->y=5;
		}
	}


}



generate_bullets(int x, int y, int type, int flag, float speed, float angle)
{

	int c,c1=0;
	int bullet_num=0;
	

	for(c=0;c<BULLET_MAX;c++)
	{
		bullet_num=c;
		if(!( bullet[c].flag&BULLET_ACTIVE))
		{
			break;
		}
	}

if(!(bullet[bullet_num].flag&BULLET_ACTIVE)) 
{

	bullet[bullet_num].flag=0;
	bullet[bullet_num].flag+=BULLET_ACTIVE;
	bullet[bullet_num].flag+=flag;

}	
	bullet[bullet_num].force.x=cos(DEG_2_RAD(angle))*speed;
    
	
	bullet[bullet_num].force.y=sin(DEG_2_RAD(angle))*speed;
	


	bullet[bullet_num].pos.x=x;
	
	

	bullet[bullet_num].pos.y=y;

if(bullet[bullet_num].flag&BULLET_ENEMY) bullet[bullet_num].type=enemy_type[type].shot.image;
else if(bullet[bullet_num].flag&BULLET_BOSS) bullet[bullet_num].type=boss[0].shot.image;
	
else bullet[bullet_num].type=type;

	

	




}



check_boss_num_parameters(int command_type)
{
if(command_type==COMMAND_SHIP_TYPE) return 1;//not used for boss
if(command_type==COMMAND_POS) return 2;
if(command_type==COMMAND_LEFT) return 1;
if(command_type==COMMAND_RIGHT) return 1;
if(command_type==COMMAND_TOP) return 1;
if(command_type==COMMAND_BOTTOM) return 1;
if(command_type==COMMAND_COPY) return 1;	//not used for boss
if(command_type==COMMAND_MIRROR_VERTICAL) return 1;	//not used for boss
if(command_type==COMMAND_MIRROR_HORIZANTAL) return 1;	//not used for boss
if(command_type==COMMAND_X_MOD) return 2;
if(command_type==COMMAND_Y_MOD) return 2;
if(command_type==COMMAND_SPEED) return 1;
if(command_type==COMMAND_WAIT) return 1;
if(command_type==COMMAND_FIRE) return 1;
if(command_type==COMMAND_LOOP) return 2;
if(command_type==COMMAND_FIRE_TYPE) return 1;



return 1;
}


check_num_parameters(int command_type)
{
if(command_type==COMMAND_SHIP_TYPE) return 1;
if(command_type==COMMAND_POS) return 2;
if(command_type==COMMAND_LEFT) return 1;
if(command_type==COMMAND_RIGHT) return 1;
if(command_type==COMMAND_TOP) return 1;
if(command_type==COMMAND_BOTTOM) return 1;
if(command_type==COMMAND_COPY) return 1;
if(command_type==COMMAND_MIRROR_VERTICAL) return 1;
if(command_type==COMMAND_MIRROR_HORIZANTAL) return 1;
if(command_type==COMMAND_X_MOD) return 2;
if(command_type==COMMAND_Y_MOD) return 2;
if(command_type==COMMAND_SPEED) return 1;
if(command_type==COMMAND_WAIT) return 1;
if(command_type==COMMAND_FIRE) return 1;



return 1;
}

find_ref(int c)
{
	int c1=0;

	for(c1=0;c1<ENEMY_MAX_CALLS;c1++)
	{
		if(enemy_call[c1].ref==c)return c1;
	}
return 0;
}

draw_particles(int c, float percent)
{
	int c1=0;


	for(c1=0;c1<MAX_PARTICLES;c1++)
	{
	explosion[c].p[c1].pos.x=explosion[c].p[c1].start_pos.x+(explosion[c].p[c1].final_pos.x-explosion[c].p[c1].start_pos.x)*percent;
	explosion[c].p[c1].pos.y=explosion[c].p[c1].start_pos.y+(explosion[c].p[c1].final_pos.y-explosion[c].p[c1].start_pos.y)*percent;

	putpixel(buffer,explosion[c].p[c1].pos.x,explosion[c].p[c1].pos.y,makecol(explosion[c].p[c1].color.r,explosion[c].p[c1].color.g,explosion[c].p[c1].color.b));
	}

}


generate_explosion(int x, int y,int type)
{
	int c=0;
	int c1,c2=0;
	struct XANDY pos={x,y};

	for(c=0;c<EXPLOSION_MAX;c++)
	{
		if(!(explosion[c].flag&EXPLOSION_ACTIVE))
		{
			float sample_pan=0.79*pos.x;
			if(type!=2&&type!=5)play_sample(datafile_music[4].dat, 255, sample_pan, 130, FALSE);
			else play_sample(datafile_music[4].dat, 32*2, sample_pan, 130, FALSE);

			explosion[c].type=type;
			explosion[c].flag+=EXPLOSION_ACTIVE;
			explosion[c].pos.x=pos.x;
			explosion[c].pos.y=pos.y;
			explosion[c].start_time=timer;
			explosion[c].duration=explosion_type[type].duration;
			explosion[c].start_size=explosion_type[type].start_size;
			explosion[c].final_size=explosion_type[type].final_size;
			explosion[c].color.a=explosion_type[type].color.a;
			explosion[c].color.r=explosion_type[type].color.r;
			explosion[c].color.g=explosion_type[type].color.g;
			explosion[c].color.b=explosion_type[type].color.b;


			for(c1=0;c1<MAX_PARTICLES;c1++)
			{
				if(c1%36==0)c2++;
				explosion[c].p[c1].start_pos.x=rand()%3+explosion[c].pos.x+(explosion[c].start_size+c2)*sin(DEG_2_RAD(c1*10));
				explosion[c].p[c1].start_pos.y=rand()%3+explosion[c].pos.y+(explosion[c].start_size+c2)*cos(DEG_2_RAD(c1*10));

				explosion[c].p[c1].final_pos.x=rand()%3+explosion[c].pos.x+(explosion[c].final_size+c2*2)*sin(DEG_2_RAD(c1*10));
				explosion[c].p[c1].final_pos.y=rand()%3+explosion[c].pos.y+(explosion[c].final_size+c2*2)*cos(DEG_2_RAD(c1*10));

				explosion[c].p[c1].color.a=explosion[c].color.a;
				explosion[c].p[c1].color.r=explosion[c].color.r-c2*5;
				explosion[c].p[c1].color.g=explosion[c].color.g-c2*5;
				explosion[c].p[c1].color.b=explosion[c].color.b-c2*5;
			}

			return 1;
				


		}



		
	}

	return 0;
	
}

generate_enemy_dead(int c)
{
int c1;

	for(c1=0;c1<ENEMY_MAX_ON_SCREEN;c1++)
	{
		if(!(enemy_dead[c1].flag&ENEMY_DEAD_ACTIVE)) 
		{
		memset(&enemy_dead[c1],0,sizeof(enemy_dead[c1]));
		generate_explosion(enemy[c].pos.x+enemy[c].frame.width/2,enemy[c].pos.y+enemy[c].frame.height/2,enemy[c].explosion);
		enemy_dead[c1].flag+=ENEMY_DEAD_ACTIVE;
		if(enemy[c].flag&ENEMY_HIT_BY_PLAYER_1) enemy_dead[c1].flag+=ENEMY_DEAD_HIT_BY_PLAYER_1;
		enemy_dead[c1].score_timer=timer+5;
		enemy_dead[c1].points=enemy[c].points;
		enemy_dead[c1].pos=enemy[c].pos;
		enemy_dead[c1].pos.x+=20;
		enemy_dead[c1].pos.y+=20;
		break;
		}
	}
return 0;
}



generate_boss_dead(int c)
{
int c1=c;


		if(!(boss_dead[c1].flag&ENEMY_DEAD_ACTIVE)) 
		{
		memset(&boss_dead[c1],0,sizeof(boss_dead[c1]));
		generate_explosion(160,120,2);
		generate_explosion(50,50,2);
		generate_explosion(270,50,2);
		
		generate_explosion(50,200,2);
		generate_explosion(270,200,2);

		
		generate_explosion(50+50,50+50,2);
		generate_explosion(270-50,50+50,2);
		
		generate_explosion(50+50,200-50,2);
		generate_explosion(270-50,200-50,2);

		
		boss_dead[c1].flag+=ENEMY_DEAD_ACTIVE;
		if(boss[c].flag&ENEMY_HIT_BY_PLAYER_1) boss_dead[c1].flag+=ENEMY_DEAD_HIT_BY_PLAYER_1;
		boss_dead[c1].score_timer=timer+5;
		boss_dead[c1].points=boss[c].points;
		boss_dead[c1].pos=boss[c].pos;
		boss_dead[c1].pos.x+=20;
		boss_dead[c1].pos.y+=20;
		
		}
	
return 0;
}

update_boss_command()
{
	int call_ref=boss[0].at_command;
	int command_type=boss_data[call_ref].type;
	trouble_shoot=command_type;
	
	if(boss[0].command_percent_done>=100)
	{
		boss[0].at_command+=check_boss_num_parameters(command_type);
		boss[0].command_percent_done=0;
		boss[0].command_inc=0;
		if(boss[0].flag&ENEMY_COMMAND_SET) boss[0].flag-=ENEMY_COMMAND_SET;
		if(boss[0].flag&ENEMY_COMMAND_POSITION) boss[0].flag-=ENEMY_COMMAND_POSITION;
		if(boss[0].flag&ENEMY_COMMAND_WAIT) boss[0].flag-=ENEMY_COMMAND_WAIT;

		return 0;
	}


	if(boss[0].at_command>boss[0].num_param-1)
	{
		if(boss[0].flag&ENEMY_ACTIVE) boss[0].flag-=ENEMY_ACTIVE;
		if(boss[0].flag&ENEMY_DRAW) boss[0].flag-=ENEMY_DRAW;
		return 0;
	}

	





if(command_type==COMMAND_POS)
{
	if(!(boss[0].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		boss[0].flag+=ENEMY_COMMAND_SET;
		
		
		boss[0].start_pos_command.x=boss[0].end_pos_command.x;

		boss[0].start_pos_command.y=boss[0].end_pos_command.y;
		
		
		if(boss_data[call_ref].value>=0)	boss[0].end_pos_command.x=boss_data[call_ref].value;
		else
		{
			if(boss_data[call_ref].value==-1) boss[0].end_pos_command.x=rand()%(SCREEN_W_USE-100);
		}

		if(boss_data[call_ref+1].value>=0)	boss[0].end_pos_command.y=boss_data[call_ref+1].value;
		else
		{
			if(boss_data[call_ref+1].value==-1) boss[0].end_pos_command.y=rand()%(SCREEN_H_USE-100);
		}
		
		boss[0].dist_pos_command.x=boss[0].end_pos_command.x-boss[0].start_pos_command.x;
		boss[0].dist_pos_command.y=boss[0].end_pos_command.y-boss[0].start_pos_command.y;
		hypotenuse=MAG(boss[0].dist_pos_command.x,boss[0].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		boss[0].command_inc=(boss[0].speed/hypotenuse)*10;
	}

	if(!(boss[0].flag&ENEMY_COMMAND_POSITION)) boss[0].flag+=ENEMY_COMMAND_POSITION;
	

	
return 0;

}

if(command_type==COMMAND_LEFT)
{
	if(!(boss[0].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		boss[0].flag+=ENEMY_COMMAND_SET;
		
		if(boss[0].start_pos_command.x==0 && boss[0].start_pos_command.y==0&&
			boss[0].end_pos_command.x==0 && boss[0].end_pos_command.y==0)
		{
			boss[0].end_pos_command.x=0-(256);
			
			boss[0].end_pos_command.y=boss_data[call_ref].value;

			boss[0].pos_command=boss[0].end_pos_command;
			
		
			boss[0].at_command++;

			
			if(boss[0].flag&ENEMY_COMMAND_SET) boss[0].flag-=ENEMY_COMMAND_SET;


			return 0;
		}

		boss[0].start_pos_command=boss[0].end_pos_command;
		boss[0].end_pos_command.x=0-(256);
			
		boss[0].end_pos_command.y=boss_data[call_ref].value;
		boss[0].dist_pos_command.x=boss[0].end_pos_command.x-boss[0].start_pos_command.x;
		boss[0].dist_pos_command.y=boss[0].end_pos_command.y-boss[0].start_pos_command.y;
		hypotenuse=MAG(boss[0].dist_pos_command.x,boss[0].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		boss[0].command_inc=(boss[0].speed/hypotenuse)*10;
	}

	if(!(boss[0].flag&ENEMY_COMMAND_POSITION)) boss[0].flag+=ENEMY_COMMAND_POSITION;
	

return 0;

}

if(command_type==COMMAND_RIGHT)
{
		if(!(boss[0].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		boss[0].flag+=ENEMY_COMMAND_SET;

		if(boss[0].start_pos_command.x==0 && boss[0].start_pos_command.y==0&&
			boss[0].end_pos_command.x==0 && boss[0].end_pos_command.y==0)
		{
			boss[0].end_pos_command.x=SCREEN_W_USE;
			
			boss[0].end_pos_command.y=boss_data[call_ref].value;

			boss[0].pos_command=boss[0].end_pos_command;
			
		
			boss[0].at_command++;

			
			if(boss[0].flag&ENEMY_COMMAND_SET) boss[0].flag-=ENEMY_COMMAND_SET;

			return 0;
		}

		boss[0].start_pos_command=boss[0].end_pos_command;
		boss[0].end_pos_command.x=SCREEN_W_USE;
		
		boss[0].end_pos_command.y=boss_data[call_ref].value;
		boss[0].dist_pos_command.x=boss[0].end_pos_command.x-boss[0].start_pos_command.x;
		boss[0].dist_pos_command.y=boss[0].end_pos_command.y-boss[0].start_pos_command.y;
		hypotenuse=MAG(boss[0].dist_pos_command.x,boss[0].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		boss[0].command_inc=(boss[0].speed/hypotenuse)*10;
	}

	if(!(boss[0].flag&ENEMY_COMMAND_POSITION)) boss[0].flag+=ENEMY_COMMAND_POSITION;
	

return 0;

}

if(command_type==COMMAND_TOP)
{
		if(!(boss[0].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		boss[0].flag+=ENEMY_COMMAND_SET;

		if(boss[0].start_pos_command.x==0 && boss[0].start_pos_command.y==0&&
			boss[0].end_pos_command.x==0 && boss[0].end_pos_command.y==0)
		{
		boss[0].end_pos_command.x=boss_data[call_ref].value;
		
			boss[0].end_pos_command.y=0-(256);

			boss[0].pos_command=boss[0].end_pos_command;
			
		

			boss[0].at_command++;

			
			if(boss[0].flag&ENEMY_COMMAND_SET) boss[0].flag-=ENEMY_COMMAND_SET;

			return 0;
		}

		boss[0].start_pos_command=boss[0].end_pos_command;
		boss[0].end_pos_command.x=boss_data[call_ref].value;
		
		boss[0].end_pos_command.y=0-(256);
		boss[0].dist_pos_command.x=boss[0].end_pos_command.x-boss[0].start_pos_command.x;
		boss[0].dist_pos_command.y=boss[0].end_pos_command.y-boss[0].start_pos_command.y;
		hypotenuse=MAG(boss[0].dist_pos_command.x,boss[0].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		boss[0].command_inc=(boss[0].speed/hypotenuse)*10;
	}

	if(!(boss[0].flag&ENEMY_COMMAND_POSITION)) boss[0].flag+=ENEMY_COMMAND_POSITION;
	

return 0;

}

if(command_type==COMMAND_BOTTOM)
{
	
		if(!(boss[0].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		boss[0].flag+=ENEMY_COMMAND_SET;

		if(boss[0].start_pos_command.x==0 && boss[0].start_pos_command.y==0&&
			boss[0].end_pos_command.x==0 && boss[0].end_pos_command.y==0)
		{
		boss[0].end_pos_command.x=boss_data[call_ref].value;
		
			boss[0].end_pos_command.y=SCREEN_H_USE;

			boss[0].pos_command=boss[0].end_pos_command;
			
		
			boss[0].at_command++;

			
			if(boss[0].flag&ENEMY_COMMAND_SET) boss[0].flag-=ENEMY_COMMAND_SET;

			return 0;
		}

		boss[0].start_pos_command=boss[0].end_pos_command;
		boss[0].end_pos_command.x=boss_data[call_ref].value;
		
		boss[0].end_pos_command.y=SCREEN_H_USE;
		boss[0].dist_pos_command.x=boss[0].end_pos_command.x-boss[0].start_pos_command.x;
		boss[0].dist_pos_command.y=boss[0].end_pos_command.y-boss[0].start_pos_command.y;
		hypotenuse=MAG(boss[0].dist_pos_command.x,boss[0].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		boss[0].command_inc=(boss[0].speed/hypotenuse)*10;
	}

	if(!(boss[0].flag&ENEMY_COMMAND_POSITION)) boss[0].flag+=ENEMY_COMMAND_POSITION;
	

return 0;
	

}



if(command_type==COMMAND_X_MOD)
{
	if(!(boss[0].flag&ENEMY_COMMAND_X_MOD)) boss[0].flag+=ENEMY_COMMAND_X_MOD;

	if(boss[0].mod.timer.x==0)boss[0].mod.timer.x=timer;
	else
	{
		float last_mod_deg=(timer-boss[0].mod.timer.x)*boss[0].mod.speed.x;

		if(boss_data[call_ref].value!=0)
		{
			float new_timer_value=timer-(last_mod_deg/boss_data[call_ref].value);

				boss[0].mod.timer.x=new_timer_value;
		}
					


	}

		if(boss_data[call_ref].value==0||boss_data[call_ref+1].value==0)
		{

			boss[0].mod.pos_old.x=boss[0].pos_mod.x;
			boss[0].mod.amplitude.x=0;
		}
	else
		{
	boss[0].mod.speed.x=boss_data[call_ref].value;
	if(boss[0].flag&ENEMY_MIRROR_H) boss[0].mod.speed.x*=-1;
	boss[0].mod.pos_old.x=boss[0].pos_mod.x;
	boss[0].mod.amplitude.x=boss_data[call_ref+1].value;
		}
	

	boss[0].mod.inc.x=1.5;
	
	boss[0].mod.percent_done.x=0;

	boss[0].at_command+=2;
	return 0;
	
	
}

if(command_type==COMMAND_Y_MOD)
{
	if(!(boss[0].flag&ENEMY_COMMAND_Y_MOD)) boss[0].flag+=ENEMY_COMMAND_Y_MOD;

	if(boss[0].mod.timer.y==0)boss[0].mod.timer.y=timer;
	else 
	{
		float last_mod_deg=(timer-boss[0].mod.timer.y+90)*boss[0].mod.speed.y;

			
		if(boss_data[call_ref].value!=0)
		{
			float new_timer_value=timer+90-(last_mod_deg/boss_data[call_ref].value);

				boss[0].mod.timer.y=new_timer_value;
		}				


	}
		if(boss_data[call_ref].value==0||boss_data[call_ref+1].value==0)
		{

			boss[0].mod.pos_old.y=boss[0].pos_mod.y;
			boss[0].mod.amplitude.y=0;
		}
	else
		{
	boss[0].mod.speed.y=boss_data[call_ref].value;
	boss[0].mod.pos_old.y=boss[0].pos_mod.y;
	boss[0].mod.amplitude.y=boss_data[call_ref+1].value;
		}

	boss[0].mod.inc.y=1.5;
	
	boss[0].mod.percent_done.y=0;
	
	boss[0].at_command+=2;
	return 0;
}

if(command_type==COMMAND_SPEED)
{
	
	boss[0].speed=boss_data[call_ref].value;
	boss[0].at_command++;
	return 0;
	
	
}

if(command_type==COMMAND_WAIT)
{
	if(!(boss[0].flag&ENEMY_COMMAND_SET)) 
	{
		boss[0].flag+=ENEMY_COMMAND_SET;
		if(!(boss[0].flag&ENEMY_COMMAND_WAIT)) boss[0].flag+=ENEMY_COMMAND_WAIT;
		boss[0].wait_timer=boss_data[call_ref].value;
		if(boss[0].wait_timer<1)boss[0].wait_timer=1;
		boss[0].command_inc=(1/boss[0].wait_timer)*10;
	}

	return 0;
}

if(command_type==COMMAND_FIRE)
{
	init_shot_boss(0);
	boss[0].shot.amount_to_fire=boss_data[call_ref].value;
	boss[0].shot.timer=timer+boss[0].shot.delay;
	
	
	if(!(boss[0].flag&ENEMY_COMMAND_FIRE)) boss[0].flag+=ENEMY_COMMAND_FIRE;

	
	boss[0].at_command++;
	return 0;
}

if(command_type==COMMAND_LOOP)
{
	int new_loop=TRUE;
	int c=0;

	

	


	for(c=0;c<10;c++)
	{
		if(call_ref==boss[0].loop[c].ref && boss[0].loop[c].flag&LOOP_USED )
		{
			new_loop=FALSE;
			break;
		}	
	}


	if(new_loop==TRUE)
	{
		for(c=0;c<10;c++)
			if(!(boss[0].loop[c].flag&LOOP_USED)) break;
	
		if(!(boss[0].loop[c].flag&LOOP_USED)) boss[0].loop[c].flag+=LOOP_USED;

		boss[0].loop[c].count=0;
		boss[0].loop[c].preset=boss_data[call_ref].value;
		boss[0].loop[c].ref=call_ref;
	}

	
	if(boss[0].loop[c].count>=boss[0].loop[c].preset)
	{
		if(boss[0].loop[c].flag&LOOP_USED) boss[0].loop[c].flag-=LOOP_USED;
		boss[0].at_command+=2;
		return -1;
	}

	if(boss[0].loop[c].preset!=99)boss[0].loop[c].count++;
	
	

	
	
	boss[0].at_command=boss_data[call_ref+1].value-1;
	


	
	return -1;
	
}

if(command_type==COMMAND_FIRE_TYPE)
{
	
	boss[0].fire_type=boss_data[call_ref].value;
	boss[0].at_command++;
	return 0;
	
	
}


return 0;
}



update_boss()
{

	int c=0;
	
	
if(boss[0].flag&ENEMY_COMMAND_SET)
{   
if(boss[0].command_percent_done>=100)
	{	
	boss[0].flag-=ENEMY_COMMAND_SET;
	}
}

if(!(boss[0].flag&ENEMY_COMMAND_SET))
{
	
	update_boss_command();

}

if(!(boss[0].flag&ENEMY_ACTIVE)) return 0;		

if(boss[0].health<=0)
{
	if(boss[0].flag&ENEMY_DRAW) boss[0].flag-=ENEMY_DRAW;
	if(boss[0].flag&ENEMY_ACTIVE) boss[0].flag-=ENEMY_ACTIVE;
	
	if(level!=3)
	{
	if(boss[0].flag&ENEMY_HIT_BY_PLAYER_1) player[0].score+=boss[0].points;
	else	player[1].score+=boss[0].points;
	}
	else
	{
		player[0].score+=boss[0].points;
		player[1].score+=boss[0].points;
	}


	generate_boss_dead(c);
	
	return 0;
}

		
if(boss[0].flag&ENEMY_COMMAND_POSITION)
{
	
	boss[0].command_percent_done+=boss[0].command_inc;
	
	if(boss[0].command_percent_done>100)boss[0].command_percent_done=100;
	if(boss[0].command_percent_done<0)boss[0].command_percent_done=0;

	boss[0].pos_command.x=boss[0].start_pos_command.x+boss[0].dist_pos_command.x*boss[0].command_percent_done*0.01;
	boss[0].pos_command.y=boss[0].start_pos_command.y+boss[0].dist_pos_command.y*boss[0].command_percent_done*0.01;
}

if(boss[0].flag&ENEMY_COMMAND_WAIT) 
{
	boss[0].command_percent_done+=boss[0].command_inc;
	if(boss[0].command_percent_done>100)boss[0].command_percent_done=100;
	if(boss[0].command_percent_done<0)boss[0].command_percent_done=0;
}


if(boss[0].flag&ENEMY_COMMAND_X_MOD)
{
	float pos_old_add=(boss[0].mod.pos_old.x*(100-boss[0].mod.percent_done.x)*0.01);
	float current_amp=(boss[0].mod.amplitude.x*(boss[0].mod.percent_done.x)*0.01);
	
	boss[0].pos_mod.x=(sin(DEG_2_RAD((timer-boss[0].mod.timer.x)*boss[0].mod.speed.x))*current_amp)+pos_old_add;
	
	boss[0].mod.percent_done.x+=boss[0].mod.inc.x;
	if(boss[0].mod.percent_done.x>100)boss[0].mod.percent_done.x=100;
}

if(boss[0].flag&ENEMY_COMMAND_Y_MOD)
{
	float pos_old_add=(boss[0].mod.pos_old.y*(100-boss[0].mod.percent_done.y)*0.01);
	float current_amp=(boss[0].mod.amplitude.y*(boss[0].mod.percent_done.y)*0.01);
	
	boss[0].pos_mod.y=(cos(DEG_2_RAD((timer-boss[0].mod.timer.y+90)*boss[0].mod.speed.y))*current_amp)+pos_old_add;
	
	boss[0].mod.percent_done.y+=boss[0].mod.inc.y;
	if(boss[0].mod.percent_done.y>100)boss[0].mod.percent_done.y=100;
}

	boss[0].pos_old.x=boss[0].pos.x;
	boss[0].pos_old.y=boss[0].pos.y;
	boss[0].pos.x=boss[0].pos_command.x+boss[0].pos_mod.x;
	boss[0].pos.y=boss[0].pos_command.y+boss[0].pos_mod.y;


if(!(boss[0].flag&ENEMY_DRAW))
{
	
if(!(boss[0].pos.x==0 && boss[0].pos.y==0))
	{
	if(!(boss[0].flag&ENEMY_DRAW))boss[0].flag+=ENEMY_DRAW;
	boss[0].pos_old.x=boss[0].pos.x;
	boss[0].pos_old.y=boss[0].pos.y;
	}
}

if(boss[0].shot.flag&SHOT_AIM)
{
int player_select_fire=0;

if(player[1].flag&PLAYER_ALIVE) player_select_fire=1;

if(player[0].flag&PLAYER_ALIVE && player[1].flag&PLAYER_ALIVE) player_select_fire=rand()%2;	

get_angle(boss[0].pos.x+boss[0].frame.width/2,boss[0].pos.y+boss[0].frame.height/2,player[player_select_fire].pos.x+player[player_select_fire].frame.width/2,player[player_select_fire].pos.y+player[player_select_fire].frame.height/2,&boss[0].frame.angle);


boss[0].shot.angle=boss[0].frame.angle+90;
}

if(boss[0].shot.flag&SHOT_SPIN)
{

boss[0].shot.angle=boss[0].frame.angle+90;
}
	
if(boss[0].flag&ENEMY_COMMAND_FIRE&&boss[0].flag&ENEMY_DRAW) 
	{
	int fire=TRUE;
			if(boss[0].shot.amount_to_fire==-1) fire=FALSE;
			if(boss[0].shot.amount_to_fire!=0 && 
				boss[0].shot.amount_fired>=boss[0].shot.amount_to_fire)
			{
				boss[0].flag-=ENEMY_COMMAND_FIRE;
				fire=FALSE;
			}
	
			if(boss[0].shot.timer<timer&&fire==TRUE)
			{
				float sample_pan=0.79*boss[0].pos.x;
				if(sample_pan<0)sample_pan=0;
				if(sample_pan>255)sample_pan=255;

				play_sample(datafile_music[0].dat, 16*2, sample_pan, 1200, FALSE);
				
	

	if(boss[0].shot.flag&SHOT_MULTI_2)
	{

			
			//parameters for function generate_bullet_boss_pos(int c,int count,int flag, int type,struct XANDY *pos)

			generate_bullet_boss_pos(0, 1,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
			generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle);
			
			generate_bullet_boss_pos(0, 2,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
			generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle);
	
	}
	else
	if(boss[0].shot.flag&SHOT_MULTI_5)
	{
		generate_bullet_boss_pos(0, 1,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
		generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle+60);
		
		generate_bullet_boss_pos(0, 2,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
		generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle+30);
		
		generate_bullet_boss_pos(0, 3,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
		generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle);
		
		generate_bullet_boss_pos(0, 4,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
		generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle-30);
		
		generate_bullet_boss_pos(0, 5,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
		generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle-60);
	
	}
	else
	{
				
				generate_bullet_boss_pos(0, 1,boss[0].shot.flag,boss[0].fire_type,&boss[0].bullet_offset);
				generate_bullets(boss[0].bullet_offset.x,boss[0].bullet_offset.y,boss[0].type,BULLET_BOSS,boss[0].shot.speed,boss[0].shot.angle);
	}


				boss[0].shot.timer=timer+boss[0].shot.delay;
				boss[0].shot.amount_fired++;

			}
	}

if(boss[0].flag&ENEMY_ROTATE_SLOW)
	{
		boss[0].frame.angle+=1;
	}

if(boss[0].flag&ENEMY_FOLLOW_PLAYER)
	{

	if(!(boss[0].start_pos_command.x==0 && boss[0].start_pos_command.y==0&&
			boss[0].end_pos_command.x==0 && boss[0].end_pos_command.y==0))
		if(!(boss[0].flag&ENEMY_COMMAND_POSITION))
		{

			float dist_1=MAG(boss[0].pos.x-player[0].pos.x,boss[0].pos.y-player[0].pos.y);
			float dist_2=MAG(boss[0].pos.x-player[1].pos.x,boss[0].pos.y-player[1].pos.y);
			int player_to_follow=0;

			if(player[0].flag&PLAYER_ALIVE&&player[1].flag&PLAYER_ALIVE)
			{
				if(dist_1<dist_2)player_to_follow=0;
				else player_to_follow=1;
			}
			else
			{
				if(player[0].flag&PLAYER_ALIVE) player_to_follow=0;
				if(player[1].flag&PLAYER_ALIVE) player_to_follow=1;
			}


		get_angle(boss[0].pos.x+boss[0].frame.width/2,boss[0].pos.y+boss[0].frame.height/2,player[player_to_follow].pos.x+player[player_to_follow].frame.width/2,player[player_to_follow].pos.y+player[player_to_follow].frame.height/2,&boss[0].frame.angle);

		boss[0].pos_command.x+=0.1*boss[0].speed*sin(DEG_2_RAD(-boss[0].frame.angle));
		boss[0].end_pos_command.x=boss[0].pos_command.x;

		boss[0].pos_command.y+=0.1*boss[0].speed*sin(DEG_2_RAD(90+boss[0].frame.angle));
		boss[0].end_pos_command.y=boss[0].pos_command.y;
		



		}

		
	}


if(level==0)
{

	/*lines for ball for boss 1*/
	boss[0].ball.pos.x=boss[0].pos.x+64+(float)sin(DEG_2_RAD(timer*15))*4;
	boss[0].ball.pos.y=boss[0].pos.y+100+(float)cos(DEG_2_RAD(timer*15))*3;
}

if(level==1)
{

	/*lines for ball for boss 2*/
	boss[0].ball.pos.x=boss[0].pos.x+64+(float)sin(DEG_2_RAD(timer*15))*4;
	boss[0].ball.pos.y=boss[0].pos.y+115+(float)cos(DEG_2_RAD(timer*15))*3;
}
if(level==2)
{
	/*lines for ball for boss 3*/
	boss[0].ball.pos.x=160+(float)sin(DEG_2_RAD(timer*2))*60;
	boss[0].ball.pos.y=90+(float)cos(DEG_2_RAD(timer*15))*3;
}
if(level==3)
{
	int x=0;
	int y=0;
	/*lines for ball for boss 4*/
	//boss[0].ball.pos.x=boss[0].pos.x+64+(float)sin(DEG_2_RAD(timer*15))*4;
	//boss[0].ball.pos.y=boss[0].pos.y+100+(float)cos(DEG_2_RAD(timer*15))*3;
	/*middle right*/
	boss[0].pod[0].pos.x=-5+50+boss[0].pos.x+100+sin(DEG_2_RAD(6*timer* (0+sin(DEG_2_RAD(timer*0.1))) ))*8;
	boss[0].pod[0].pos.y=23+boss[0].pos.y+80+sin(DEG_2_RAD(90+6*timer* (0+sin(DEG_2_RAD(timer*0.08))) ))*8;

	/*top left*/
	boss[0].pod[1].pos.x=-5-60+boss[0].pos.x+100+sin(DEG_2_RAD(6*timer* (0+sin(DEG_2_RAD(60+timer*0.1))) ))*8;
	boss[0].pod[1].pos.y=8+boss[0].pos.y+80+sin(DEG_2_RAD(90+6*timer* (0+sin(DEG_2_RAD(60+timer*0.08))) ))*8;

	/*top right*/
	boss[0].pod[2].pos.x=-5+60+boss[0].pos.x+100+sin(DEG_2_RAD(6*timer* (0+sin(DEG_2_RAD(120+timer*0.1))) ))*8;
	boss[0].pod[2].pos.y=8+boss[0].pos.y+80+sin(DEG_2_RAD(90+6*timer* (0+sin(DEG_2_RAD(120+timer*0.08))) ))*8;

	/*bottom left*/
	boss[0].pod[3].pos.x=-5-40+boss[0].pos.x+100+sin(DEG_2_RAD(6*timer* (0+sin(DEG_2_RAD(180+timer*0.1))) ))*8;
	boss[0].pod[3].pos.y=30+boss[0].pos.y+80+sin(DEG_2_RAD(90+6*timer* (0+sin(DEG_2_RAD(180+timer*0.08))) ))*8;

	/*bottom right*/
	boss[0].pod[4].pos.x=-5+40+boss[0].pos.x+100+sin(DEG_2_RAD(6*timer* (0+sin(DEG_2_RAD(240+timer*0.1))) ))*8;
	boss[0].pod[4].pos.y=30+boss[0].pos.y+80+sin(DEG_2_RAD(90+6*timer* (0+sin(DEG_2_RAD(240+timer*0.08))) ))*8;

	/*middle left*/
	boss[0].pod[5].pos.x=-5-50+boss[0].pos.x+100+sin(DEG_2_RAD(6*timer* (0+sin(DEG_2_RAD(300+timer*0.1))) ))*8;
	boss[0].pod[5].pos.y=23+boss[0].pos.y+80+sin(DEG_2_RAD(90+6*timer* (0+sin(DEG_2_RAD(300+timer*0.08))) ))*8;

	for(x=0;x<25;x++)
		for(y=0;y<18;y++)
		{
			if(boss[0].gel_left[x][y].hits>=10)
			{
				

				boss[0].gel_left[x][y].pos.x+=sin(DEG_2_RAD( sin(DEG_2_RAD(timer*0.5+boss[0].gel_left[x][y].move.x*50))*360))*0.05;

				if(boss[0].gel_left[x][y].pos.x>312) boss[0].gel_left[x][y].pos.x=312;
				if(boss[0].gel_left[x][y].pos.x<0) boss[0].gel_left[x][y].pos.x=0;

				boss[0].gel_left[x][y].pos.y+=sin(DEG_2_RAD(90+ sin(DEG_2_RAD(timer*0.5+boss[0].gel_left[x][y].move.x*50))*360))*0.05;

				if(boss[0].gel_left[x][y].pos.y>232) boss[0].gel_left[x][y].pos.y=232;
				if(boss[0].gel_left[x][y].pos.y<0) boss[0].gel_left[x][y].pos.y=0;

			}

			if(boss[0].gel_right[x][y].hits>=10)
			{
				

				boss[0].gel_right[x][y].pos.x+=sin(DEG_2_RAD( sin(DEG_2_RAD(timer*0.5+boss[0].gel_right[x][y].move.x*50))*360))*0.05;

				if(boss[0].gel_right[x][y].pos.x>312) boss[0].gel_right[x][y].pos.x=312;
				if(boss[0].gel_right[x][y].pos.x<0) boss[0].gel_right[x][y].pos.x=0;

				boss[0].gel_right[x][y].pos.y+=sin(DEG_2_RAD(90+ sin(DEG_2_RAD(timer*0.5+boss[0].gel_right[x][y].move.x*50))*360))*0.05;

				if(boss[0].gel_right[x][y].pos.y>232) boss[0].gel_right[x][y].pos.y=232;
				if(boss[0].gel_right[x][y].pos.y<0) boss[0].gel_right[x][y].pos.y=0;
			}

				

		}

}

/*weapons only used for boss 3*/
	for(c=0;c<8;c++)
	{
		if(boss[0].weapon[c].flag&WEAPON_USED)
		{
			if(boss[0].weapon[c].flag&WEAPON_BACK_FORTH)
				if(boss[0].weapon[c].flag&WEAPON_DIR_X)
				{
					boss[0].weapon[c].pos.x+=boss[0].weapon[c].speed.x;
					if(boss[0].weapon[c].pos.x>boss[0].weapon[c].max.x) boss[0].weapon[c].flag-=WEAPON_DIR_X;
				}
				else
				{
					boss[0].weapon[c].pos.x-=boss[0].weapon[c].speed.x;
					if(boss[0].weapon[c].pos.x<boss[0].weapon[c].min.x) boss[0].weapon[c].flag+=WEAPON_DIR_X;
				}

			if(boss[0].weapon[c].flag&WEAPON_BACK_FORTH)
				if(boss[0].weapon[c].flag&WEAPON_DIR_Y)
				{
					boss[0].weapon[c].pos.y+=boss[0].weapon[c].speed.y;
					if(boss[0].weapon[c].pos.y>boss[0].weapon[c].max.y) boss[0].weapon[c].flag-=WEAPON_DIR_Y;
				}
				else
				{
					boss[0].weapon[c].pos.y-=boss[0].weapon[c].speed.y;
					if(boss[0].weapon[c].pos.y<boss[0].weapon[c].min.y) boss[0].weapon[c].flag+=WEAPON_DIR_Y;
				}

			if(boss[0].weapon[c].flag&WEAPON_PLAYER_FOLLOW)
			{	int player_select_fire=0;

				if(boss_data[boss[0].at_command].type==COMMAND_FIRE_TYPE)
				{
					if(player[1].flag&PLAYER_ALIVE) player_select_fire=1;
					if(player[0].flag&PLAYER_ALIVE && player[1].flag&PLAYER_ALIVE) player_select_fire=rand()%2;
				
					if(boss[0].weapon[c].flag&WEAPON_PLAYER_1_FOLLOW) boss[0].weapon[c].flag-=WEAPON_PLAYER_1_FOLLOW;
					if(boss[0].weapon[c].flag&WEAPON_PLAYER_2_FOLLOW) boss[0].weapon[c].flag-=WEAPON_PLAYER_2_FOLLOW;
				
				if( player_select_fire==0&&player[0].flag&PLAYER_ALIVE) boss[0].weapon[c].flag+=WEAPON_PLAYER_1_FOLLOW;
				if( player_select_fire==1&&player[1].flag&PLAYER_ALIVE) boss[0].weapon[c].flag+=WEAPON_PLAYER_2_FOLLOW;
				
				}

				if(boss[0].weapon[c].flag&WEAPON_PLAYER_1_FOLLOW)
				{
					if(boss[0].weapon[c].pos.x<player[0].pos.x-2) boss[0].weapon[c].pos.x+=boss[0].weapon[c].speed.x;
					if(boss[0].weapon[c].pos.x>player[0].pos.x+2) boss[0].weapon[c].pos.x-=boss[0].weapon[c].speed.x;
					
					if(boss[0].weapon[c].pos.y<player[0].pos.y-2) boss[0].weapon[c].pos.y+=boss[0].weapon[c].speed.y;
					if(boss[0].weapon[c].pos.y>player[0].pos.y+2) boss[0].weapon[c].pos.y-=boss[0].weapon[c].speed.y;
					
				}
				if(boss[0].weapon[c].flag&WEAPON_PLAYER_2_FOLLOW)
				{
					if(boss[0].weapon[c].pos.x<player[1].pos.x-2) boss[0].weapon[c].pos.x+=boss[0].weapon[c].speed.x;
					if(boss[0].weapon[c].pos.x>player[1].pos.x+2) boss[0].weapon[c].pos.x-=boss[0].weapon[c].speed.x;

					if(boss[0].weapon[c].pos.y<player[1].pos.y-2) boss[0].weapon[c].pos.y+=boss[0].weapon[c].speed.y;
					if(boss[0].weapon[c].pos.y>player[1].pos.y+2) boss[0].weapon[c].pos.y-=boss[0].weapon[c].speed.y;
					
				}

				if(boss[0].weapon[c].pos.x<boss[0].weapon[c].min.x) boss[0].weapon[c].pos.x=boss[0].weapon[c].min.x;
				if(boss[0].weapon[c].pos.x>boss[0].weapon[c].max.x) boss[0].weapon[c].pos.x=boss[0].weapon[c].max.x;
				if(boss[0].weapon[c].pos.y<boss[0].weapon[c].min.y) boss[0].weapon[c].pos.y=boss[0].weapon[c].min.y;
				if(boss[0].weapon[c].pos.y>boss[0].weapon[c].max.y) boss[0].weapon[c].pos.y=boss[0].weapon[c].max.y;

			}

				
		}
	}


	
return 1;
}





update_ship_command(int c)
{
	int call_ref=enemy_call[enemy[c].ref].start_param+enemy[c].at_command;
	int command_type=ship_data[call_ref].type;
	trouble_shoot=command_type;
	
	if(enemy[c].command_percent_done>=100)
	{
		enemy[c].at_command+=check_num_parameters(command_type);
		enemy[c].command_percent_done=0;
		enemy[c].command_inc=0;
		if(enemy[c].flag&ENEMY_COMMAND_SET) enemy[c].flag-=ENEMY_COMMAND_SET;
		if(enemy[c].flag&ENEMY_COMMAND_POSITION) enemy[c].flag-=ENEMY_COMMAND_POSITION;
		if(enemy[c].flag&ENEMY_COMMAND_WAIT) enemy[c].flag-=ENEMY_COMMAND_WAIT;

		return 0;
	}


	if(enemy[c].at_command>enemy_call[enemy[c].ref].num_param-1)
	{
		if(enemy[c].flag&ENEMY_ACTIVE) enemy[c].flag-=ENEMY_ACTIVE;
		if(enemy[c].flag&ENEMY_DRAW) enemy[c].flag-=ENEMY_DRAW;
		return 0;
	}

	



if(command_type==COMMAND_SHIP_TYPE)
{
	
	enemy[c].type=ship_data[call_ref].value;
	enemy[c].speed=5;	/*set initial speed*/
	enemy[c].at_command++;
	enemy[c].flag+=enemy_type[enemy[c].type].flag;

	

	enemy[c].frame=enemy_type[enemy[c].type].frame;
	enemy[c].health=enemy_type[enemy[c].type].health_init;
	enemy[c].points=enemy_type[enemy[c].type].points;
	enemy[c].explosion=enemy_type[enemy[c].type].explosion;


return 0;
}

if(command_type==COMMAND_POS)
{
	if(!(enemy[c].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		enemy[c].flag+=ENEMY_COMMAND_SET;
		
		
		enemy[c].start_pos_command.x=enemy[c].end_pos_command.x;

		enemy[c].start_pos_command.y=enemy[c].end_pos_command.y;
		
		
		if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=ship_data[call_ref].value;
		else	enemy[c].end_pos_command.x=SCREEN_W_USE-ship_data[call_ref].value;
		enemy[c].end_pos_command.y=ship_data[call_ref+1].value;
		enemy[c].dist_pos_command.x=enemy[c].end_pos_command.x-enemy[c].start_pos_command.x;
		enemy[c].dist_pos_command.y=enemy[c].end_pos_command.y-enemy[c].start_pos_command.y;
		hypotenuse=MAG(enemy[c].dist_pos_command.x,enemy[c].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		enemy[c].command_inc=(enemy[c].speed/hypotenuse)*10;
	}

	if(!(enemy[c].flag&ENEMY_COMMAND_POSITION)) enemy[c].flag+=ENEMY_COMMAND_POSITION;
	
	
return 0;

}

if(command_type==COMMAND_LEFT)
{
	if(!(enemy[c].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		enemy[c].flag+=ENEMY_COMMAND_SET;
		
		if(enemy[c].start_pos_command.x==0 && enemy[c].start_pos_command.y==0&&
			enemy[c].end_pos_command.x==0 && enemy[c].end_pos_command.y==0)
		{
			if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=0-(((BITMAP *)datafile[enemy[c].frame.start].dat)->w);
			else enemy[c].end_pos_command.x=SCREEN_W_USE;
			enemy[c].end_pos_command.y=ship_data[call_ref].value;

			enemy[c].pos_command=enemy[c].end_pos_command;
			
		
			enemy[c].at_command++;

			
			if(enemy[c].flag&ENEMY_COMMAND_SET) enemy[c].flag-=ENEMY_COMMAND_SET;


			return 0;
		}

		enemy[c].start_pos_command=enemy[c].end_pos_command;
		if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=0-(((BITMAP *)datafile[enemy[c].frame.start].dat)->w);
			else enemy[c].end_pos_command.x=SCREEN_W_USE;
		enemy[c].end_pos_command.y=ship_data[call_ref].value;
		enemy[c].dist_pos_command.x=enemy[c].end_pos_command.x-enemy[c].start_pos_command.x;
		enemy[c].dist_pos_command.y=enemy[c].end_pos_command.y-enemy[c].start_pos_command.y;
		hypotenuse=MAG(enemy[c].dist_pos_command.x,enemy[c].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		enemy[c].command_inc=(enemy[c].speed/hypotenuse)*10;
	}

	if(!(enemy[c].flag&ENEMY_COMMAND_POSITION)) enemy[c].flag+=ENEMY_COMMAND_POSITION;
	
return 0;

}

if(command_type==COMMAND_RIGHT)
{
		if(!(enemy[c].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		enemy[c].flag+=ENEMY_COMMAND_SET;

		if(enemy[c].start_pos_command.x==0 && enemy[c].start_pos_command.y==0&&
			enemy[c].end_pos_command.x==0 && enemy[c].end_pos_command.y==0)
		{
			if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=SCREEN_W_USE;
			else enemy[c].end_pos_command.x=0-(((BITMAP *)datafile[enemy[c].frame.start].dat)->w);
			enemy[c].end_pos_command.y=ship_data[call_ref].value;

			enemy[c].pos_command=enemy[c].end_pos_command;
			
		
			enemy[c].at_command++;

			
			if(enemy[c].flag&ENEMY_COMMAND_SET) enemy[c].flag-=ENEMY_COMMAND_SET;

			return 0;
		}

		enemy[c].start_pos_command=enemy[c].end_pos_command;
		if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=SCREEN_W_USE;
			else enemy[c].end_pos_command.x=0-(((BITMAP *)datafile[enemy[c].frame.start].dat)->w);
		enemy[c].end_pos_command.y=ship_data[call_ref].value;
		enemy[c].dist_pos_command.x=enemy[c].end_pos_command.x-enemy[c].start_pos_command.x;
		enemy[c].dist_pos_command.y=enemy[c].end_pos_command.y-enemy[c].start_pos_command.y;
		hypotenuse=MAG(enemy[c].dist_pos_command.x,enemy[c].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		enemy[c].command_inc=(enemy[c].speed/hypotenuse)*10;
	}

	if(!(enemy[c].flag&ENEMY_COMMAND_POSITION)) enemy[c].flag+=ENEMY_COMMAND_POSITION;

return 0;

}

if(command_type==COMMAND_TOP)
{
		if(!(enemy[c].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		enemy[c].flag+=ENEMY_COMMAND_SET;

		if(enemy[c].start_pos_command.x==0 && enemy[c].start_pos_command.y==0&&
			enemy[c].end_pos_command.x==0 && enemy[c].end_pos_command.y==0)
		{
			if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=ship_data[call_ref].value;
		else	enemy[c].end_pos_command.x=SCREEN_W_USE-ship_data[call_ref].value;
			enemy[c].end_pos_command.y=0-(((BITMAP *)datafile[enemy[c].frame.start].dat)->h);

			enemy[c].pos_command=enemy[c].end_pos_command;
			
		

			enemy[c].at_command++;

			
			if(enemy[c].flag&ENEMY_COMMAND_SET) enemy[c].flag-=ENEMY_COMMAND_SET;

			return 0;
		}

		enemy[c].start_pos_command=enemy[c].end_pos_command;
		if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=ship_data[call_ref].value;
		else	enemy[c].end_pos_command.x=SCREEN_W_USE-ship_data[call_ref].value;
		enemy[c].end_pos_command.y=0-(((BITMAP *)datafile[enemy[c].frame.start].dat)->h);
		enemy[c].dist_pos_command.x=enemy[c].end_pos_command.x-enemy[c].start_pos_command.x;
		enemy[c].dist_pos_command.y=enemy[c].end_pos_command.y-enemy[c].start_pos_command.y;
		hypotenuse=MAG(enemy[c].dist_pos_command.x,enemy[c].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		enemy[c].command_inc=(enemy[c].speed/hypotenuse)*10;
	}

	if(!(enemy[c].flag&ENEMY_COMMAND_POSITION)) enemy[c].flag+=ENEMY_COMMAND_POSITION;

return 0;

}

if(command_type==COMMAND_BOTTOM)
{
	
		if(!(enemy[c].flag&ENEMY_COMMAND_SET))
	{
		float hypotenuse;
		enemy[c].flag+=ENEMY_COMMAND_SET;

		if(enemy[c].start_pos_command.x==0 && enemy[c].start_pos_command.y==0&&
			enemy[c].end_pos_command.x==0 && enemy[c].end_pos_command.y==0)
		{
			if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=ship_data[call_ref].value;
		else	enemy[c].end_pos_command.x=SCREEN_W_USE-ship_data[call_ref].value;
			enemy[c].end_pos_command.y=SCREEN_H_USE;

			enemy[c].pos_command=enemy[c].end_pos_command;
			
		
			enemy[c].at_command++;

			
			if(enemy[c].flag&ENEMY_COMMAND_SET) enemy[c].flag-=ENEMY_COMMAND_SET;

			return 0;
		}

		enemy[c].start_pos_command=enemy[c].end_pos_command;
		if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].end_pos_command.x=ship_data[call_ref].value;
		else	enemy[c].end_pos_command.x=SCREEN_W_USE-ship_data[call_ref].value;
		enemy[c].end_pos_command.y=SCREEN_H_USE;
		enemy[c].dist_pos_command.x=enemy[c].end_pos_command.x-enemy[c].start_pos_command.x;
		enemy[c].dist_pos_command.y=enemy[c].end_pos_command.y-enemy[c].start_pos_command.y;
		hypotenuse=MAG(enemy[c].dist_pos_command.x,enemy[c].dist_pos_command.y);
		if(hypotenuse<1)hypotenuse=1;
		enemy[c].command_inc=(enemy[c].speed/hypotenuse)*10;
	}

	if(!(enemy[c].flag&ENEMY_COMMAND_POSITION)) enemy[c].flag+=ENEMY_COMMAND_POSITION;

return 0;
	

}

if(command_type==COMMAND_COPY)
{
	enemy[c].at_command=0;
	enemy[c].ref=find_ref(ship_data[call_ref].value);
	return 0;
}

if(command_type==COMMAND_MIRROR_VERTICAL)
{
	enemy[c].at_command=0;
	return 0;
}

if(command_type==COMMAND_MIRROR_HORIZANTAL)
{
	enemy[c].at_command=0;
	enemy[c].ref=find_ref(ship_data[call_ref].value);
	if(!(enemy[c].flag&ENEMY_MIRROR_H))enemy[c].flag+=ENEMY_MIRROR_H;
	return 0;
}

if(command_type==COMMAND_X_MOD)
{
	if(!(enemy[c].flag&ENEMY_COMMAND_X_MOD)) enemy[c].flag+=ENEMY_COMMAND_X_MOD;

	if(enemy[c].mod.timer.x==0)enemy[c].mod.timer.x=timer;
	else
	{
		float last_mod_deg=(timer-enemy[c].mod.timer.x)*enemy[c].mod.speed.x;

		if(ship_data[call_ref].value!=0)
		{
			float new_timer_value=timer-(last_mod_deg/ship_data[call_ref].value);

				enemy[c].mod.timer.x=new_timer_value;
		}
					


	}

		if(ship_data[call_ref].value==0||ship_data[call_ref+1].value==0)
		{

			enemy[c].mod.pos_old.x=enemy[c].pos_mod.x;
			enemy[c].mod.amplitude.x=0;
		}
	else
		{
	enemy[c].mod.speed.x=ship_data[call_ref].value;
	if(enemy[c].flag&ENEMY_MIRROR_H) enemy[c].mod.speed.x*=-1;
	enemy[c].mod.pos_old.x=enemy[c].pos_mod.x;
	enemy[c].mod.amplitude.x=ship_data[call_ref+1].value;
		}
	

	enemy[c].mod.inc.x=1.5;
	
	enemy[c].mod.percent_done.x=0;

	enemy[c].at_command+=2;
	return 0;
	
	
}

if(command_type==COMMAND_Y_MOD)
{
	if(!(enemy[c].flag&ENEMY_COMMAND_Y_MOD)) enemy[c].flag+=ENEMY_COMMAND_Y_MOD;

	if(enemy[c].mod.timer.y==0)enemy[c].mod.timer.y=timer;
	else 
	{
		float last_mod_deg=(timer-enemy[c].mod.timer.y+90)*enemy[c].mod.speed.y;

			
		if(ship_data[call_ref].value!=0)
		{
			float new_timer_value=timer+90-(last_mod_deg/ship_data[call_ref].value);

				enemy[c].mod.timer.y=new_timer_value;
		}				


	}
		if(ship_data[call_ref].value==0||ship_data[call_ref+1].value==0)
		{

			enemy[c].mod.pos_old.y=enemy[c].pos_mod.y;
			enemy[c].mod.amplitude.y=0;
		}
	else
		{
	enemy[c].mod.speed.y=ship_data[call_ref].value;
	enemy[c].mod.pos_old.y=enemy[c].pos_mod.y;
	enemy[c].mod.amplitude.y=ship_data[call_ref+1].value;
		}

	enemy[c].mod.inc.y=1.5;
	
	enemy[c].mod.percent_done.y=0;
	
	enemy[c].at_command+=2;
	return 0;
}

if(command_type==COMMAND_SPEED)
{
	
	enemy[c].speed=ship_data[call_ref].value;
	enemy[c].at_command++;
	return 0;
	
	
}

if(command_type==COMMAND_WAIT)
{
	if(!(enemy[c].flag&ENEMY_COMMAND_SET)) 
	{
		enemy[c].flag+=ENEMY_COMMAND_SET;
		if(!(enemy[c].flag&ENEMY_COMMAND_WAIT)) enemy[c].flag+=ENEMY_COMMAND_WAIT;
		enemy[c].wait_timer=ship_data[call_ref].value;
		if(enemy[c].wait_timer<1)enemy[c].wait_timer=1;
		enemy[c].command_inc=(1/enemy[c].wait_timer)*10;
	}

	return 0;
}

if(command_type==COMMAND_FIRE)
{
	enemy[c].shot=enemy_type[enemy[c].type].shot;
	enemy[c].shot.timer=timer+enemy[c].shot.delay;
	enemy[c].shot.amount_fired=0;
	enemy[c].shot.amount_to_fire=ship_data[call_ref].value;
	
	if(!(enemy[c].flag&ENEMY_COMMAND_FIRE)) enemy[c].flag+=ENEMY_COMMAND_FIRE;

	
	enemy[c].at_command++;
	return 0;
}




return 0;
}



update_ship(int c)
{

	
if(enemy[c].flag&ENEMY_COMMAND_SET)
{   
if(enemy[c].command_percent_done>=100)
	{	
	enemy[c].flag-=ENEMY_COMMAND_SET;
	}
}

if(!(enemy[c].flag&ENEMY_COMMAND_SET))
{
update_ship_command(c);
}

if(!(enemy[c].flag&ENEMY_ACTIVE)) return 0;		

if(enemy[c].health<=0)
{
	if(enemy[c].flag&ENEMY_DRAW) enemy[c].flag-=ENEMY_DRAW;
	if(enemy[c].flag&ENEMY_ACTIVE) enemy[c].flag-=ENEMY_ACTIVE;
	
	if(enemy[c].flag&ENEMY_HIT_BY_PLAYER_1) player[0].score+=enemy[c].points;
	else	player[1].score+=enemy[c].points;

	generate_enemy_dead(c);
	
	return 0;
}

		
if(enemy[c].flag&ENEMY_COMMAND_POSITION)
{
	
	enemy[c].command_percent_done+=enemy[c].command_inc;
	
	if(enemy[c].command_percent_done>100)enemy[c].command_percent_done=100;
	if(enemy[c].command_percent_done<0)enemy[c].command_percent_done=0;

	enemy[c].pos_command.x=enemy[c].start_pos_command.x+enemy[c].dist_pos_command.x*enemy[c].command_percent_done*0.01;
	enemy[c].pos_command.y=enemy[c].start_pos_command.y+enemy[c].dist_pos_command.y*enemy[c].command_percent_done*0.01;
}

if(enemy[c].flag&ENEMY_COMMAND_WAIT) 
{
	enemy[c].command_percent_done+=enemy[c].command_inc;
	if(enemy[c].command_percent_done>100)enemy[c].command_percent_done=100;
	if(enemy[c].command_percent_done<0)enemy[c].command_percent_done=0;
}


if(enemy[c].flag&ENEMY_COMMAND_X_MOD)
{
	float pos_old_add=(enemy[c].mod.pos_old.x*(100-enemy[c].mod.percent_done.x)*0.01);
	float current_amp=(enemy[c].mod.amplitude.x*(enemy[c].mod.percent_done.x)*0.01);
	
	enemy[c].pos_mod.x=(sin(DEG_2_RAD((timer-enemy[c].mod.timer.x)*enemy[c].mod.speed.x))*current_amp)+pos_old_add;
	
	enemy[c].mod.percent_done.x+=enemy[c].mod.inc.x;
	if(enemy[c].mod.percent_done.x>100)enemy[c].mod.percent_done.x=100;
}

if(enemy[c].flag&ENEMY_COMMAND_Y_MOD)
{
	float pos_old_add=(enemy[c].mod.pos_old.y*(100-enemy[c].mod.percent_done.y)*0.01);
	float current_amp=(enemy[c].mod.amplitude.y*(enemy[c].mod.percent_done.y)*0.01);
	
	enemy[c].pos_mod.y=(cos(DEG_2_RAD((timer-enemy[c].mod.timer.y+90)*enemy[c].mod.speed.y))*current_amp)+pos_old_add;
	
	enemy[c].mod.percent_done.y+=enemy[c].mod.inc.y;
	if(enemy[c].mod.percent_done.y>100)enemy[c].mod.percent_done.y=100;
}

	enemy[c].pos_old.x=enemy[c].pos.x;
	enemy[c].pos_old.y=enemy[c].pos.y;
	enemy[c].pos.x=enemy[c].pos_command.x+enemy[c].pos_mod.x;
	enemy[c].pos.y=enemy[c].pos_command.y+enemy[c].pos_mod.y;


if(!(enemy[c].flag&ENEMY_DRAW))
{
	
if(!(enemy[c].pos.x==0 && enemy[c].pos.y==0))
	{
	if(!(enemy[c].flag&ENEMY_DRAW))enemy[c].flag+=ENEMY_DRAW;
	enemy[c].pos_old.x=enemy[c].pos.x;
	enemy[c].pos_old.y=enemy[c].pos.y;
	}
}

if(enemy[c].shot.flag&SHOT_AIM)
{
int player_select_fire=0;

if(player[1].flag&PLAYER_ACTIVE) player_select_fire=1;

if(player[0].flag&PLAYER_ACTIVE && player[1].flag&PLAYER_ACTIVE)
{
	float dist_1=MAG( (enemy[c].pos.x-player[0].pos.x) ,(enemy[c].pos.y-player[0].pos.y) );
	float dist_2=MAG( (enemy[c].pos.x-player[1].pos.x) ,(enemy[c].pos.y-player[1].pos.y) );
	

	if(dist_1<dist_2)player_select_fire=0;
		else player_select_fire=1;
}			

get_angle(enemy[c].pos.x+enemy[c].frame.width/2,enemy[c].pos.y+enemy[c].frame.height/2,player[player_select_fire].pos.x+player[player_select_fire].frame.width/2,player[player_select_fire].pos.y+player[player_select_fire].frame.height/2,&enemy[c].frame.angle);


enemy[c].shot.angle=enemy[c].frame.angle+90;
}

if(enemy[c].shot.flag&SHOT_SPIN)
{

enemy[c].shot.angle=enemy[c].frame.angle+90;
}
	
if(enemy[c].flag&ENEMY_COMMAND_FIRE&&enemy[c].flag&ENEMY_DRAW) 
	{
	int fire=TRUE;
			if(enemy[c].shot.amount_to_fire==-1) fire=FALSE;
			if(enemy[c].shot.amount_to_fire!=0 && 
				enemy[c].shot.amount_fired>=enemy[c].shot.amount_to_fire)
			{
				enemy[c].flag-=ENEMY_COMMAND_FIRE;
				fire=FALSE;
			}
	
			if(enemy[c].shot.timer<timer&&fire==TRUE)
			{
				float sample_pan=0.79*enemy[c].pos.x;
				if(sample_pan<0)sample_pan=0;
				if(sample_pan>255)sample_pan=255;

				play_sample(datafile_music[0].dat, 4*2, sample_pan, 1100, FALSE);
				
	

	if(enemy[c].shot.flag&SHOT_MULTI_2)
	{

				struct XANDY bullet_offset={	(((BITMAP *)datafile[enemy[c].shot.image].dat)->w)/2, (((BITMAP *)datafile[enemy[c].shot.image].dat)->h)/2	};
				struct XANDY enemy_offset[2]={0,enemy[c].frame.height/2,enemy[c].frame.width,enemy[c].frame.height/2};

				struct XANDY center_offset[2]={enemy_offset[0].x-bullet_offset.x,enemy_offset[0].y-bullet_offset.y,enemy_offset[1].x-bullet_offset.x,enemy_offset[1].y-bullet_offset.y};
				struct XANDY rotate_offset={sin(DEG_2_RAD(enemy[c].frame.angle))*(enemy_offset[0].y+bullet_offset.y), cos(DEG_2_RAD(enemy[c].frame.angle))*(enemy_offset[0].y+bullet_offset.y)};
			
			generate_bullets(enemy[c].pos.x+center_offset[0].x-rotate_offset.x,enemy[c].pos.y+center_offset[0].y+rotate_offset.y,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle);
			generate_bullets(enemy[c].pos.x+center_offset[1].x-rotate_offset.x,enemy[c].pos.y+center_offset[1].y+rotate_offset.y,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle);
	
	}
	else
	if(enemy[c].shot.flag&SHOT_MULTI_5)
	{
		generate_bullets(enemy[c].pos.x+5,enemy[c].pos.y+enemy[c].frame.height-10,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle+60);
		generate_bullets(enemy[c].pos.x+15,enemy[c].pos.y+enemy[c].frame.height-10,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle+30);
		generate_bullets(enemy[c].pos.x+20,enemy[c].pos.y+enemy[c].frame.height-10,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle);
		generate_bullets(enemy[c].pos.x+25,enemy[c].pos.y+enemy[c].frame.height-10,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle-30);
		generate_bullets(enemy[c].pos.x+35,enemy[c].pos.y+enemy[c].frame.height-10,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle-60);
	
	}
	else
	{
				struct XANDY bullet_offset={	(((BITMAP *)datafile[enemy[c].shot.image].dat)->w)/2, (((BITMAP *)datafile[enemy[c].shot.image].dat)->h)/2	};
				struct XANDY enemy_offset={enemy[c].frame.width/2,enemy[c].frame.height/2};

				struct XANDY center_offset={enemy_offset.x-bullet_offset.x,enemy_offset.y-bullet_offset.y};
				struct XANDY rotate_offset={sin(DEG_2_RAD(enemy[c].frame.angle))*(enemy_offset.y+bullet_offset.y), cos(DEG_2_RAD(enemy[c].frame.angle))*(enemy_offset.y+bullet_offset.y)};
				
				generate_bullets(enemy[c].pos.x+center_offset.x-rotate_offset.x,enemy[c].pos.y+center_offset.y+rotate_offset.y,enemy[c].type,BULLET_ENEMY,enemy[c].shot.speed,enemy[c].shot.angle);
	}


				enemy[c].shot.timer=timer+enemy[c].shot.delay;
				enemy[c].shot.amount_fired++;

			}
	}

if(enemy[c].flag&ENEMY_ROTATE_SLOW)
	{
		enemy[c].frame.angle+=1;
	}

if(enemy[c].flag&ENEMY_FOLLOW_PLAYER)
	{

	if(!(enemy[c].start_pos_command.x==0 && enemy[c].start_pos_command.y==0&&
			enemy[c].end_pos_command.x==0 && enemy[c].end_pos_command.y==0))
		if(!(enemy[c].flag&ENEMY_COMMAND_POSITION))
		{

			float dist_1=MAG( (enemy[c].pos.x-player[0].pos.x) ,(enemy[c].pos.y-player[0].pos.y) );
			float dist_2=MAG( (enemy[c].pos.x-player[1].pos.x) ,(enemy[c].pos.y-player[1].pos.y) );
			int player_to_follow=0;

		

			if(player[0].flag&PLAYER_ACTIVE&&player[1].flag&PLAYER_ACTIVE)
			{
				if(dist_1<dist_2)player_to_follow=0;
				else player_to_follow=1;
			}
			else
			{
				if(player[0].flag&PLAYER_ACTIVE) player_to_follow=0;
				if(player[1].flag&PLAYER_ACTIVE) player_to_follow=1;
			}


		get_angle(enemy[c].pos.x+enemy[c].frame.width/2,enemy[c].pos.y+enemy[c].frame.height/2,player[player_to_follow].pos.x+player[player_to_follow].frame.width/2,player[player_to_follow].pos.y+player[player_to_follow].frame.height/2,&enemy[c].frame.angle);

		enemy[c].pos_command.x+=0.1*enemy[c].speed*sin(DEG_2_RAD(-enemy[c].frame.angle));
		enemy[c].end_pos_command.x=enemy[c].pos_command.x;

		enemy[c].pos_command.y+=0.1*enemy[c].speed*sin(DEG_2_RAD(90+enemy[c].frame.angle));
		enemy[c].end_pos_command.y=enemy[c].pos_command.y;
		



		}

		
	}

return 1;
}




generate_ship(int c)
{
int c1;



	for(c1=0;c1<ENEMY_MAX_ON_SCREEN;c1++)
	{
		if(!(enemy[c1].flag&ENEMY_ACTIVE)) 
		{
		memset(&enemy[c1],0,sizeof(enemy[c1]));
		enemy[c1].flag=0;
		enemy[c1].flag+=ENEMY_ACTIVE;
		enemy[c1].ref=c;
		enemy[c1].health=10;
		return 1;
		}
	}
	
	
return 0;
}



void update_bullets(int c1)
{

	int c=0;
	

	for(c=0;c<BULLET_MAX;c++)
	{
		if(bullet[c].flag&BULLET_ACTIVE)
		{
		bullet[c].pos_old.x=bullet[c].pos.x;
		bullet[c].pos_old.y=bullet[c].pos.y;
		bullet[c].pos.x+=bullet[c].force.x;
		bullet[c].pos.y+=bullet[c].force.y;

		if(bullet[c].pos.x<0||bullet[c].pos.x>SCREEN_W_USE)
			bullet[c].flag=0;
		else
		if(bullet[c].pos.y<0||bullet[c].pos.y>SCREEN_H_USE)
			bullet[c].flag=0;

		}
	}

	
		
}






void update_player(int c)
{

if(!(player[c].flag&PLAYER_WAS_ACTIVE)) player[c].flag+=PLAYER_WAS_ACTIVE;

if(player[c].pos.x>SCREEN_W_USE-16)player[c].pos.x=SCREEN_W_USE-16;
if(player[c].pos.y>SCREEN_H_USE-16)player[c].pos.y=SCREEN_H_USE-16;

if(player[c].pos.x<0)player[c].pos.x=0;
if(player[c].pos.y<0)player[c].pos.y=0;

if( (!(player[c].flag&PLAYER_ALIVE)) && (!(player[c].flag&PLAYER_DEAD)) )
{
	player[c].flag+=PLAYER_DEAD;
	if(player[c].lives>0)
	{
		player[c].lives--;
		
	}
		
	else
	{
		if(!(player[c].flag&PLAYER_LIVES_DONE))
		{
			player[c].flag+=PLAYER_LIVES_DONE;
			if(continues>0)
			{
				player[c].continue_timer=timer+player[c].continue_time_length;
				if(!(player[c].flag&PLAYER_CONTINUE_TIMER_SHOWN)) player[c].flag+=PLAYER_CONTINUE_TIMER_SHOWN;
			}
		}
	}

}
if(player[c].flag&PLAYER_LIVES_DONE && player[c].flag&PLAYER_ACTIVE) player[c].flag-=PLAYER_ACTIVE;


if(player[c].flag&PLAYER_DEAD&& (!(player[c].flag&PLAYER_LIVES_DONE)) && (!(player[c].flag&PLAYER_REGEN_SHOWN)) )
{
	player[c].regen_timer=timer+player[c].regen_time_length;
	
	if(!(player[c].flag&PLAYER_REGEN_SHOWN)) 
	{
		player[c].flag+=PLAYER_REGEN_SHOWN;
		player[c].pos.x=160;
		player[c].pos.y=SCREEN_H_USE-40;
	}
}

if(player[c].flag&PLAYER_REGEN_SHOWN)
{
	if(player[c].regen_timer<timer)
	{
		if(!(player[c].flag&PLAYER_ALIVE)) 
		{
			if(player[c].flag&PLAYER_DEAD) player[c].flag-=PLAYER_DEAD;
			player[c].flag+=PLAYER_ALIVE;
			
		}
			
			player[c].flag-=PLAYER_REGEN_SHOWN;
		
	}
}


if(player[c].flag&PLAYER_CONTINUE_TIMER_SHOWN)
	{

		if(player[c].continue_timer<timer) player[c].flag-=PLAYER_CONTINUE_TIMER_SHOWN;
		else
		if(continues==0||(!(player[c].flag&PLAYER_REGEN_SHOWN)) )player[c].flag-=PLAYER_CONTINUE_TIMER_SHOWN;
	}


if(player[c].flag&PLAYER_ALIVE||player[c].flag&PLAYER_REGEN_SHOWN)
if( (!(player[c].flag&PLAYER_FIRED))&&player[c].flag&PLAYER_DO_SHOT )
		{
			if( (!(player[c].flag&PLAYER_CAN_FIRE)) )
			{
				player[c].flag+=PLAYER_CAN_FIRE;
			    player[c].shot_timer=timer+1;
			}
			if(player[c].shot_timer<timer)
			{
				
				player[c].flag+=PLAYER_FIRED;

				
				
				generate_bullets(player[c].pos.x-2,player[c].pos.y,5,c*4+BULLET_PLAYER_1,2,-90);
				generate_bullets(player[c].pos.x+12,player[c].pos.y,5,c*4+BULLET_PLAYER_1,2,-90);


				if(player[c].flag&PLAYER_FIRED)player[c].flag-=PLAYER_FIRED;
				if(player[c].flag&PLAYER_CAN_FIRE)player[c].flag-=PLAYER_CAN_FIRE;


			}

		
		}



}



draw_boss_0()
{
int x=0;
int y=0;
int c=0;

int j=0;
int k=0;

float intro_span=level_timer[level].boss_intro_preset;

float distort_mul=(level_boss_intro_timer-timer)/intro_span*255;

float distort=(sin(DEG_2_RAD((int)(timer*distort_mul/10)%360))*distort_mul/2);	

float line_x=0;
float line_y=0;

float ball_health_color=( (float)(boss[0].health_init-boss[0].health)/(float)(boss[0].health_init))*120;

trouble_shoot2=level_boss_intro_timer-timer;

if(timer+55<level_boss_intro_timer)
{
if(!(start_sweep_flag))
					{
						start_sweep_flag=TRUE;
						do_sweep(2);
					}
}
else
{
if(start_sweep_flag)
{
	start_sweep_flag=FALSE;
	stop_sweep();
}
}

if(timer+2<level_boss_intro_timer)
	{

					
					
generate_wave(TRUE, 18,0,25000,150,NOISE,0.0005,2600*2+sin(DEG_2_RAD(timer*15+45))*2400*2);
generate_wave(TRUE, 22,0,25000,50,PWM,0.00002,3200*2+sin(DEG_2_RAD(timer*15))*3200*2);
generate_wave(TRUE, 12,0,5000,700,PWM,0.0005,1200*2+sin(DEG_2_RAD(timer*5))*1000*2);
generate_wave(TRUE, 30,0,8000,2700,PWM,0.001,1700*2+sin(DEG_2_RAD(timer*(255-distort_mul)/25))*300*2);
generate_wave(TRUE, 3,0,8000,700,PWM,0.0005,500*2+sin(DEG_2_RAD(timer*8+180))*300*2);

generate_wave(TRUE, 35,0,50000,8700,PWM,0.0005,5000*2);

	}
else
if(timer-10<level_boss_intro_timer)
{
for(c=0;c<42;c++)
generate_wave(FALSE, c,0,500,2500,PWM,0.02/(c*3+1),2000);



}


	
if(boss[0].health<=40)
{
	line_y-=45;
}



if(boss[0].health>0)	draw_sprite(buffer_boss,datafile_boss[0][2].dat,16,0);
if(boss[0].health>0)	draw_sprite(buffer_boss,datafile_boss[0][4].dat,24,8);
if(boss[0].health>10)	draw_sprite(buffer_boss,datafile_boss[0][3].dat,16,24);

if(boss[0].health>0)	draw_sprite(buffer_boss,datafile_boss[0][0].dat,0,0);
if(boss[0].health>40)	draw_sprite(buffer_boss,datafile_boss[0][1].dat,0,22);
if(boss[0].health>0)	draw_sprite(buffer_boss,datafile_boss[0][6].dat,48,0);
if(boss[0].health>40)	draw_sprite(buffer_boss,datafile_boss[0][7].dat,48,22);

	
buffer_boss_offset_x=64;
buffer_boss_offset_y=64;		
	
	clear_to_color(buffer_boss_scaled,makecol(255,0,255));
	masked_stretch_blit(buffer_boss, buffer_boss_scaled, 0,0,64,64, buffer_boss_offset_x, buffer_boss_offset_y, 128, 128);
	

	boss[0].ball.trans_ball.a=sin(DEG_2_RAD(timer*40))*20+20;
	boss[0].ball.color.r=60+10*(sin(DEG_2_RAD(timer*20)));
	boss[0].ball.color.b=160+40*(sin(DEG_2_RAD(timer*10)));
	boss[0].ball.color.g=60+10*(sin(DEG_2_RAD(timer*30)));	

	

drawing_mode(DRAW_MODE_TRANS,0,0,0);




for(x=0;x<SQUARE_NUM_X;x++)
for(y=0;y<SQUARE_NUM_Y;y++)
{
	float c_test=0;

	c_test=(y*3+(32-(fabs(x-32)))*2);



if(timer<level_boss_intro_timer) 
	{
	set_trans_blender(0,255-distort_mul,0,255-distort_mul);
	
	
	}
else
set_trans_blender(255,255,255,255);



j=-1+y%3;
k=-1+(y+1)%3;

for(c=0;c<4;c++)
{
	vtx[c]=bp.square[x][y].v[c];

	vtx[c].x-=0;
	vtx[c].y-=0;

	if(timer<level_boss_intro_timer)
	{

	if(c==0||c==3)vtx[c].x+=j*distort;
	if(c==1||c==2)vtx[c].x+=k*distort;
	}

	get_translation_matrix_f(&matrix_display, -buffer_boss_offset_x+boss[0].pos.x, -buffer_boss_offset_y+boss[0].pos.y, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	
}



quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, buffer_boss_scaled, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);




}

	

	
	set_luminance_blender(100,100,200,boss[0].ball.trans_ball.a);




	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+1+3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+1+3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+2+3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+2+3,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,200));




	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+1,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+1,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+2,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+2,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,200));




	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+1-3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+1-3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+2-3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+2-3,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,200));


	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+1-6,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+1-6,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+2-6,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+2-6,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,200));


	
	

	
	
	set_trans_blender(220,225,225,255-ball_health_color*3);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 10, makecol(boss[0].ball.color.r,boss[0].ball.color.g,boss[0].ball.color.b));
	
	set_trans_blender(20,225,25,16);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 7+(int)(sin(DEG_2_RAD(timer*10))*7), makecol(220,220,250));
	
	set_add_blender(ball_health_color*2,5,10,ball_health_color*3);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y-30, 90, makecol(20+ball_health_color,20,150-ball_health_color ));
	set_add_blender(25,25,215,75);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 8+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 10+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 12+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 13+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 14+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 16+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 18+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 21+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 22+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	

	set_trans_blender(196,196,225,64+boss[0].ball.trans_ball.a/2);
	
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 2+(int)(sin(DEG_2_RAD(timer*20))*1), makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 3, makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 4, makecol(220,220,220));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 6, makecol(220,220,220));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 8, makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 9, makecol(250,250,250));

	set_trans_blender(196,32,32,64);



	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2+3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2+3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3+3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3+3,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4+3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4+3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5+3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5+3,makecol(20,20,180));



	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5,makecol(20,20,180));



	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2-3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2-3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3-3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3-3,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4-3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4-3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5-3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5-3,makecol(20,20,180));

	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2-6,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2-6,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3-6,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3-6,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4-6,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4-6,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5-6,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5-6,makecol(20,20,180));

	
	solid_mode();
	
}



draw_boss_1()
{
int x=0;
int y=0;
int c=0;

int j=0;
int k=0;

float intro_span=level_timer[level].boss_intro_preset;

float distort_mul=(level_boss_intro_timer-timer)/intro_span*255;

float distort=(sin(DEG_2_RAD((int)(timer*distort_mul/10)%360))*distort_mul/2);	

float line_x=0;
float line_y=-20;

float ball_health_color=((float)(boss[0].health_init-boss[0].health)/(float)(boss[0].health_init))*120;


float rotate_timer=0;
float rotate_timer_2=0;

if(boss[0].at_command>=6&&boss[0].at_command<=12)rotate_timer=(int)(timer*50)%256;

rotate_timer_2=(sin(DEG_2_RAD((int)(timer*25)%360)))*20-25;//-15+(int)(timer*2)%30;

trouble_shoot2=level_boss_intro_timer-timer;


if(timer+55<level_boss_intro_timer)
{
if(!(start_sweep_flag))
					{
						start_sweep_flag=TRUE;
						do_sweep(2);
					}
}
else
{
if(start_sweep_flag)
{
	start_sweep_flag=FALSE;
	stop_sweep();
}
}

if(timer+2<level_boss_intro_timer)
	{
	
generate_wave(TRUE, 18,0,25000,150,NOISE,0.0005,2600*2+sin(DEG_2_RAD(timer*15+45))*2400*2);
generate_wave(TRUE, 22,0,25000,50,PWM,0.00002,3200*2+sin(DEG_2_RAD(timer*15))*3200*2);
generate_wave(TRUE, 12,0,5000,700,PWM,0.0005,1200*2+sin(DEG_2_RAD(timer*5))*1000*2);
generate_wave(TRUE, 30,0,8000,2700,PWM,0.001,1700*2+sin(DEG_2_RAD(timer*(255-distort_mul)/25))*300*2);
generate_wave(TRUE, 3,0,8000,700,PWM,0.0005,500*2+sin(DEG_2_RAD(timer*8+180))*300*2);

generate_wave(TRUE, 35,0,50000,8700,PWM,0.0005,5000*2);

	}
else
if(timer-10<level_boss_intro_timer)
{
for(c=0;c<42;c++)
generate_wave(FALSE, c,0,500,2500,PWM,0.02/(c*3+1),2000);

}




buffer_boss_offset_x=64;
buffer_boss_offset_y=64;

	
	draw_sprite(buffer_boss,datafile_boss[1][2].dat,16,0);
	

	
	draw_sprite(buffer_boss,datafile_boss[1][1].dat,16,8);
	
	draw_sprite(buffer_boss,datafile_boss[1][0].dat,0,0);
	draw_sprite(buffer_boss,datafile_boss[1][3].dat,48,0);


	clear_to_color(buffer_boss_scaled,makecol(255,0,255));
	masked_stretch_blit(buffer_boss, buffer_boss_scaled, 0,0,64,64, buffer_boss_offset_x, buffer_boss_offset_y, 128, 128);
	

	boss[0].ball.trans_ball.a=sin(DEG_2_RAD(timer*40))*20+20;
	boss[0].ball.color.r=60+10*(sin(DEG_2_RAD(timer*20)));
	boss[0].ball.color.b=160+40*(sin(DEG_2_RAD(timer*10)));
	boss[0].ball.color.g=60+10*(sin(DEG_2_RAD(timer*30)));	

	

drawing_mode(DRAW_MODE_TRANS,0,0,0);



for(x=24;x<SQUARE_NUM_X;x++)
for(y=0;y<SQUARE_NUM_Y;y++)
{
	float c_test=0;

	c_test=(y*3+(32-(fabs(x-32)))*2);



if(timer<level_boss_intro_timer) 
	{
	set_trans_blender(0,255-distort_mul,255,255-distort_mul);
	
	
	}
else
set_trans_blender(255,255,255,255);

j=-1+y%3;
k=-1+(y+1)%3;

for(c=0;c<4;c++)
{
	vtx[c]=bp.square[x][y].v[c];

	vtx[c].x-=0;
	vtx[c].y-=0;

	if(timer<level_boss_intro_timer)
	{

	if(c==0||c==3)vtx[c].x+=j*distort;
	if(c==1||c==2)vtx[c].x+=k*distort;
	}

	

	get_translation_matrix_f(&matrix_display, -128, 0, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	

	if(x>39)
	{
		get_translation_matrix_f(&matrix_display, -32, -107, 0);
		apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

		get_z_rotate_matrix_f(&matrix_display, rotate_timer_2);
		apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

		get_translation_matrix_f(&matrix_display, 32,107, 0);
		apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);
	}

	get_y_rotate_matrix_f(&matrix_display, rotate_timer);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);


	get_translation_matrix_f(&matrix_display, -buffer_boss_offset_x+boss[0].pos.x+128, -buffer_boss_offset_y+boss[0].pos.y, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	
}



quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, buffer_boss_scaled, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);




}


for(x=0;x<24;x++)
for(y=0;y<SQUARE_NUM_Y;y++)
{
	float c_test=0;

	c_test=(y*3+(32-(fabs(x-32)))*2);



if(timer<level_boss_intro_timer) 
	{
	set_trans_blender(0,255-distort_mul,255,255-distort_mul);
	
	}
else
set_trans_blender(255,255,255,255);



j=-1+y%3;
k=-1+(y+1)%3;

for(c=0;c<4;c++)
{
	vtx[c]=bp.square[x][y].v[c];

	vtx[c].x-=0;
	vtx[c].y-=0;

	if(timer<level_boss_intro_timer)
	{

	if(c==0||c==3)vtx[c].x+=j*distort;
	if(c==1||c==2)vtx[c].x+=k*distort;
	}

	

	get_translation_matrix_f(&matrix_display, -128, 0, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	if(x<24)
	{
		get_translation_matrix_f(&matrix_display, 32, -107, 0);
		apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

		get_z_rotate_matrix_f(&matrix_display, -rotate_timer_2);
		apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

		get_translation_matrix_f(&matrix_display, -32,107, 0);
		apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);
	}


	get_y_rotate_matrix_f(&matrix_display, rotate_timer);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);


	get_translation_matrix_f(&matrix_display, -buffer_boss_offset_x+boss[0].pos.x+128, -buffer_boss_offset_y+boss[0].pos.y, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	
}



quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, buffer_boss_scaled, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);




}

	

	
	set_luminance_blender(100,100,200,boss[0].ball.trans_ball.a);




	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+1+3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+1+3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+2+3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x,boss[0].ball.pos.y+2+3,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,200));




	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+1,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+1,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+2,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x,boss[0].ball.pos.y+2,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,200));




	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+1-3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+1-3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+2-3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x,boss[0].ball.pos.y+2-3,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,200));


	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+1-6,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+1-6,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+2-6,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x,boss[0].ball.pos.y+2-6,makecol(220,220,200));

	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,220));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,220));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,200));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,200));


	
	

	
	
	set_trans_blender(220,225,225,255-ball_health_color*3);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 10, makecol(boss[0].ball.color.r,boss[0].ball.color.g,boss[0].ball.color.b));
	
	set_trans_blender(20,225,25,16);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 7+(int)(sin(DEG_2_RAD(timer*10))*7), makecol(220,220,250));
	
	set_add_blender(ball_health_color*2,5,10,ball_health_color*3);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y-30, 90, makecol(20+ball_health_color,20,150-ball_health_color ));
	set_add_blender(25,25,215,75);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 8+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 10+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 12+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 13+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 14+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 16+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 18+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 21+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 22+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	

	set_trans_blender(196,196,225,64+boss[0].ball.trans_ball.a/2);
	
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 2+(int)(sin(DEG_2_RAD(timer*20))*1), makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 3, makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 4, makecol(220,220,220));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 6, makecol(220,220,220));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 8, makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 9, makecol(250,250,250));

	set_trans_blender(196,32,32,64);



	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2+3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2+3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3+3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3+3,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4+3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4+3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5+3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5+3,makecol(20,20,180));



	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5,makecol(20,20,180));



	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2-3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2-3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3-3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3-3,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4-3,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4-3,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5-3,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5-3,makecol(20,20,180));

	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2-6,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2-6,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3-6,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+102-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3-6,makecol(20,20,180));
	
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4-6,makecol(20,20,250));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4-6,makecol(20,20,250));
		
	line(buffer,boss[0].pos.x+32,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5-6,makecol(20,20,180));
	line(buffer,boss[0].pos.x+95,line_y+boss[0].pos.y+103-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5-6,makecol(20,20,180));

	
	solid_mode();


	
}




draw_boss_2()
{
int x=0;
int y=0;
int c=0;

int j=0;
int k=0;

float intro_span=level_timer[level].boss_intro_preset;

float alpha_mul=255-(level_boss_intro_timer-timer)/intro_span*255;

struct XANDY start={99,77};
struct XANDY end={220,77};

float ball_health_color=((float)(boss[0].health_init-boss[0].health)/(float)(boss[0].health_init))*120;


if(timer+55<level_boss_intro_timer)
{
if(!(start_sweep_flag))
					{
						start_sweep_flag=TRUE;
						do_sweep(2);
					}
}
else
{
if(start_sweep_flag)
{
	start_sweep_flag=FALSE;
	stop_sweep();
}
}

if(timer+2<level_boss_intro_timer)
	{
	

generate_wave(TRUE, 22,0,25000,50,PWM,0.00002,3200*2+sin(DEG_2_RAD(timer*15))*3200*2);


generate_wave(TRUE, 3,0,8000,700,PWM,0.0005,500*2+sin(DEG_2_RAD(timer*8+180))*300*2);

generate_wave(TRUE, 35,0,50000,8700,PWM,0.0005,5000*2);

	}
else
if(timer-10<level_boss_intro_timer)
{
for(c=0;c<42;c++)
generate_wave(FALSE, c,0,500,2500,PWM,0.02/(c*3+1),2000);

}



buffer_boss_offset_x=64;
buffer_boss_offset_y=64;

if(alpha_mul>255)alpha_mul=255;

drawing_mode(DRAW_MODE_TRANS,0,0,0);

if(level_boss_intro_timer>=timer)
{
set_trans_blender(255,255,255,alpha_mul);	


}
else
set_trans_blender(255,255,255,255);	





draw_trans_sprite(buffer,datafile_boss[2][0].dat,0,0);

for(c=0;c<8;c++)
{
	if(boss[0].weapon[c].flag&WEAPON_USED)
	draw_trans_sprite(buffer,datafile_boss[2][boss[0].weapon[c].image].dat,boss[0].weapon[c].pos.x,boss[0].weapon[c].pos.y);
}
	boss[0].ball.trans_ball.a=(sin(DEG_2_RAD(timer*40))*20+20);
	boss[0].ball.color.r=60+10*(sin(DEG_2_RAD(timer*20)));
	boss[0].ball.color.b=160+40*(sin(DEG_2_RAD(timer*10)));
	boss[0].ball.color.g=60+10*(sin(DEG_2_RAD(timer*30)));	


	




	

	
	set_luminance_blender(100,100,200,boss[0].ball.trans_ball.a);




	line(buffer,start.x,start.y+2+3,boss[0].ball.pos.x,boss[0].ball.pos.y+1+3,makecol(220,220,220));
	line(buffer,end.x,start.y+2+3,boss[0].ball.pos.x,boss[0].ball.pos.y+1+3,makecol(220,220,220));
	
	line(buffer,start.x,start.y+2+3,boss[0].ball.pos.x,boss[0].ball.pos.y+2+3,makecol(220,220,200));
	line(buffer,end.x,start.y+2+3,boss[0].ball.pos.x,boss[0].ball.pos.y+2+3,makecol(220,220,200));

	line(buffer,start.x,start.y+3+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,220));
	line(buffer,end.x,start.y+3+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,220));
	
	line(buffer,start.x,start.y+3+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,200));
	line(buffer,end.x,start.y+3+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3+3,makecol(220,220,200));




	line(buffer,start.x,start.y+2,boss[0].ball.pos.x,boss[0].ball.pos.y+1,makecol(220,220,220));
	line(buffer,end.x,start.y+2,boss[0].ball.pos.x,boss[0].ball.pos.y+1,makecol(220,220,220));
	
	line(buffer,start.x,start.y+2,boss[0].ball.pos.x,boss[0].ball.pos.y+2,makecol(220,220,200));
	line(buffer,end.x,start.y+2,boss[0].ball.pos.x,boss[0].ball.pos.y+2,makecol(220,220,200));

	line(buffer,start.x,start.y+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,220));
	line(buffer,end.x,start.y+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,220));
	
	line(buffer,start.x,start.y+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,200));
	line(buffer,end.x,start.y+3,boss[0].ball.pos.x,boss[0].ball.pos.y+3,makecol(220,220,200));




	line(buffer,start.x,start.y+2-3,boss[0].ball.pos.x,boss[0].ball.pos.y+1-3,makecol(220,220,220));
	line(buffer,end.x,start.y+2-3,boss[0].ball.pos.x,boss[0].ball.pos.y+1-3,makecol(220,220,220));
	
	line(buffer,start.x,start.y+2-3,boss[0].ball.pos.x,boss[0].ball.pos.y+2-3,makecol(220,220,200));
	line(buffer,end.x,start.y+2-3,boss[0].ball.pos.x,boss[0].ball.pos.y+2-3,makecol(220,220,200));

	line(buffer,start.x,start.y+3-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,220));
	line(buffer,end.x,start.y+3-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,220));
	
	line(buffer,start.x,start.y+3-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,200));
	line(buffer,end.x,start.y+3-3,boss[0].ball.pos.x,boss[0].ball.pos.y+3-3,makecol(220,220,200));


	line(buffer,start.x,start.y+2-6,boss[0].ball.pos.x,boss[0].ball.pos.y+1-6,makecol(220,220,220));
	line(buffer,end.x,start.y+2-6,boss[0].ball.pos.x,boss[0].ball.pos.y+1-6,makecol(220,220,220));
	
	line(buffer,start.x,start.y+2-6,boss[0].ball.pos.x,boss[0].ball.pos.y+2-6,makecol(220,220,200));
	line(buffer,end.x,start.y+2-6,boss[0].ball.pos.x,boss[0].ball.pos.y+2-6,makecol(220,220,200));

	line(buffer,start.x,start.y+3-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,220));
	line(buffer,end.x,start.y+3-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,220));
	
	line(buffer,start.x,start.y+3-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,200));
	line(buffer,end.x,start.y+3-6,boss[0].ball.pos.x,boss[0].ball.pos.y+3-6,makecol(220,220,200));


	
	

	
	
	set_trans_blender(220,225,225,255-ball_health_color*3);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 10, makecol(boss[0].ball.color.r,boss[0].ball.color.g,boss[0].ball.color.b));
	
	set_trans_blender(20,225,25,16);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 7+(int)(sin(DEG_2_RAD(timer*10))*7), makecol(220,220,250));
	
	set_add_blender(ball_health_color*2,5,10,ball_health_color*3);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y-30, 90, makecol(20+ball_health_color,20,150-ball_health_color ));
	set_add_blender(25,25,215,75);
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 8+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 10+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 12+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 13+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 14+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 16+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 18+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 21+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 22+(int)(sin(DEG_2_RAD(timer*15))*6), makecol(10+ball_health_color*3,25,255-ball_health_color*3));
	

	set_trans_blender(196,196,225,64+boss[0].ball.trans_ball.a/2);
	
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 2+(int)(sin(DEG_2_RAD(timer*20))*1), makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 3, makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 4, makecol(220,220,220));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 6, makecol(220,220,220));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 8, makecol(220,220,250));
	circlefill(buffer, boss[0].ball.pos.x,boss[0].ball.pos.y, 9, makecol(250,250,250));

	set_trans_blender(196,32,32,64);



	line(buffer,start.x,start.y+2+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2+3,makecol(20,20,250));
	line(buffer,end.x,start.y+2+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2+3,makecol(20,20,250));
		
	line(buffer,start.x,start.y+2+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3+3,makecol(20,20,180));
	line(buffer,end.x,start.y+2+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3+3,makecol(20,20,180));
	
	line(buffer,start.x,start.y+3+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4+3,makecol(20,20,250));
	line(buffer,end.x,start.y+3+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4+3,makecol(20,20,250));
		
	line(buffer,start.x,start.y+3+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5+3,makecol(20,20,180));
	line(buffer,end.x,start.y+3+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5+3,makecol(20,20,180));



	line(buffer,start.x,start.y+2,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2,makecol(20,20,250));
	line(buffer,end.x,start.y+2,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2,makecol(20,20,250));
		
	line(buffer,start.x,start.y+2,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3,makecol(20,20,180));
	line(buffer,end.x,start.y+2,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3,makecol(20,20,180));
	
	line(buffer,start.x,start.y+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4,makecol(20,20,250));
	line(buffer,end.x,start.y+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4,makecol(20,20,250));
		
	line(buffer,start.x,start.y+3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5,makecol(20,20,180));
	line(buffer,end.x,start.y+3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5,makecol(20,20,180));



	line(buffer,start.x,start.y+2-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2-3,makecol(20,20,250));
	line(buffer,end.x,start.y+2-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2-3,makecol(20,20,250));
		
	line(buffer,start.x,start.y+2-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3-3,makecol(20,20,180));
	line(buffer,end.x,start.y+2-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3-3,makecol(20,20,180));
	
	line(buffer,start.x,start.y+3-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4-3,makecol(20,20,250));
	line(buffer,end.x,start.y+3-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4-3,makecol(20,20,250));
		
	line(buffer,start.x,start.y+3-3,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5-3,makecol(20,20,180));
	line(buffer,end.x,start.y+3-3,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5-3,makecol(20,20,180));

	
	line(buffer,start.x,start.y+2-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+2-6,makecol(20,20,250));
	line(buffer,end.x,start.y+2-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+2-6,makecol(20,20,250));
		
	line(buffer,start.x,start.y+2-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+3-6,makecol(20,20,180));
	line(buffer,end.x,start.y+2-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+3-6,makecol(20,20,180));
	
	line(buffer,start.x,start.y+3-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+4-6,makecol(20,20,250));
	line(buffer,end.x,start.y+3-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+4-6,makecol(20,20,250));
		
	line(buffer,start.x,start.y+3-6,boss[0].ball.pos.x-7,boss[0].ball.pos.y+5-6,makecol(20,20,180));
	line(buffer,end.x,start.y+3-6,boss[0].ball.pos.x+7,boss[0].ball.pos.y+5-6,makecol(20,20,180));

	
	solid_mode();


	
}

draw_gel(int square_x,int square_y,float x_pos, float y_pos)
{
	int j=0;
	int k=0;
	int j2=0;
	int k2=0;
	int x=0;
	int y=0;
	int c=0;

float distort_x1=0;
float distort_y1=0;

float distort_x2=0;
float distort_y2=0;


	float timer_use=timer;

	for(x=0;x<3;x++)
for(y=0;y<3;y++)
{


j=y;
k=y+1;

j2=x;
k2=x+1;





distort_x1=(sin(DEG_2_RAD((int)(timer_use*2+j*80+square_x*30+square_y*30)%360)))*8;	
distort_x2=(sin(DEG_2_RAD((int)(timer_use*2+k*80+square_x*30+square_y*30)%360)))*8;	

distort_y1=(cos(DEG_2_RAD((int)(timer_use*2+j2*80+square_x*30+square_y*30)%360)))*8;	
distort_y2=(cos(DEG_2_RAD((int)(timer_use*2+k2*80+square_x*30+square_y*30)%360)))*8;	


for(c=0;c<4;c++)
{
	vtx[c].z=0;

	if(c==2||c==3)
	{
	vtx[c].x=(x+1)*16;
	vtx[c].u=(x+1)*16+square_x;
	}
	else
	{
	vtx[c].x=x*16;
	vtx[c].u=x*16+square_x;

	}



	if(c==1||c==2)
	{
	vtx[c].y=(y+1)*16;
	vtx[c].v=(y+1)*16+square_y;

	}
	else
	{
	vtx[c].y=y*16;
	vtx[c].v=(y)*16+square_y;
	}

	if(c==0||c==3)vtx[c].x+=distort_x1;
	if(c==1||c==2)vtx[c].x+=distort_x2;

	if(c==0||c==1)vtx[c].y+=distort_y1;
	if(c==2||c==3)vtx[c].y+=distort_y2;



	

	get_translation_matrix_f(&matrix_display, x_pos,y_pos, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	
}



set_trans_blender(180,220,180,32);
quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, datafile_boss[3][3].dat, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);




}



}

draw_boss_3()
{
int x=0;
int y=0;
int c=0;

int j=0;
int k=0;

int c_test_2=0;
int j2=0;
int k2=0;


float distort_x1=0;	
float distort_x2=0;	

float distort_y1=0;	
float distort_y2=0;	


float intro_span=level_timer[level].boss_intro_preset;



float distort_mul=(level_boss_intro_timer-timer)/intro_span*30;

float timer_use=timer;


if(timer+55<level_boss_intro_timer)
{
if(!(start_sweep_flag))
					{
						start_sweep_flag=TRUE;
						do_sweep(2);
					}
}
else
{
if(start_sweep_flag)
{
	start_sweep_flag=FALSE;
	stop_sweep();
}
}


if(timer+2<level_boss_intro_timer)
	{
	
generate_wave(TRUE, 22,0,25000,50,PWM,0.00002,3200*2+sin(DEG_2_RAD(timer*15))*3200*2);


generate_wave(TRUE, 3,0,8000,700,PWM,0.0005,500*2+sin(DEG_2_RAD(timer*8+180))*300*2);

generate_wave(TRUE, 35,0,50000,8700,PWM,0.0005,5000*2);

	}
else
if(timer-10<level_boss_intro_timer)
{
for(c=0;c<42;c++)
generate_wave(FALSE, c,0,500,2500,PWM,0.02/(c*3+1),2000);

}


trouble_shoot2=level_boss_intro_timer-timer;




buffer_boss_offset_x=0;
buffer_boss_offset_y=0;

solid_mode();

for(x=0;x<12;x++)
for(y=0;y<9;y++)
{
if(boss[0].gel_left[x][y].hits<10) rectfill(buffer_boss,x*6+20,y*10+90,(x+1)*6+20,(y+1)*10+90,makecol(32,160,32));
if(boss[0].gel_right[x][y].hits<10)rectfill(buffer_boss,x*6+155,y*10+90,(x+1)*6+155,(y+1)*10+90,makecol(32,160,32));

}


draw_sprite(buffer_boss,datafile_boss[3][0].dat,0,0);

floodfill(buffer_boss, 0,0,makecol(255,0,255));



drawing_mode(DRAW_MODE_TRANS,0,0,0);

set_trans_blender(100,255,100,(int)(sin(DEG_2_RAD(timer*5))*60+180));


solid_mode();
if(boss[0].hit_1<10)
rectfill(buffer_boss, 65,185,95,192,makecol(85,85,155));
else
rectfill(buffer_boss, 50,180,110,197,makecol(255,0,255));

if(boss[0].hit_2<10)
rectfill(buffer_boss, 165,185,195,192,makecol(85,85,155));
else
rectfill(buffer_boss, 150,180,210,197,makecol(255,0,255));
	


	clear_to_color(buffer_boss_scaled,makecol(255,0,255));
	masked_stretch_blit(buffer_boss, buffer_boss_scaled, 0,0,256,256, buffer_boss_offset_x, buffer_boss_offset_y, 196, 196);
	



	
	
drawing_mode(DRAW_MODE_TRANS,0,0,0);	
for(c=0;c<BOSS_MAX_POD;c++)
if(boss[0].pod[c].health>0)
{
	int c1=0;
boss[0].pod[c].color.a=rand()%5+106+(sin(DEG_2_RAD(c*60+timer*10))*22);
boss[0].pod[c].color.r=(boss[0].pod[c].health_init-boss[0].pod[c].health)+80+(sin(DEG_2_RAD(c*60+timer))*15);
boss[0].pod[c].color.g=rand()%20+120+(sin(DEG_2_RAD(c*60+timer*15))*64);
boss[0].pod[c].color.b=rand()%10+180+(sin(DEG_2_RAD(c*60+timer))*25)-(boss[0].pod[c].health_init-boss[0].pod[c].health) ;




set_trans_blender(255,255,255,boss[0].pod[c].color.a+128);
circlefill(buffer, boss[0].pod[c].pos.x,boss[0].pod[c].pos.y, 10, makecol(boss[0].pod[c].color.r+30,boss[0].pod[c].color.g+30,boss[0].pod[c].color.b+30));

set_trans_blender(25,255,25, 255*(boss[0].pod[c].health_init-boss[0].pod[c].health)/boss[0].pod[c].health_init);
circlefill(buffer, boss[0].pod[c].pos.x,boss[0].pod[c].pos.y, 25, makecol(255,255,255));

for(c1=5;c1>0;c1--)	
circlefill(buffer, boss[0].pod[c].pos.x,boss[0].pod[c].pos.y, 3+c1, makecol(boss[0].pod[c].color.r+c1*3,boss[0].pod[c].color.g+c1*3,boss[0].pod[c].color.b+c1*3));



}





for(x=0;x<SQUARE_NUM_X;x++)
for(y=0;y<SQUARE_NUM_Y;y++)
{







j=y;
k=y+1;

j2=x;
k2=x+1;



if(timer<level_boss_intro_timer) 
{

distort_x1=(sin(DEG_2_RAD((int)(timer_use*3+j*12)%360)))*(7+distort_mul);	
distort_x2=(sin(DEG_2_RAD((int)(timer_use*3+k*12)%360)))*(7+distort_mul);	

distort_y1=(cos(DEG_2_RAD((int)(timer_use*3+j2*12)%360)))*(7+distort_mul);	
distort_y2=(cos(DEG_2_RAD((int)(timer_use*3+k2*12)%360)))*(7+distort_mul);	
}

else
{
distort_x1=(sin(DEG_2_RAD((int)(timer_use*3+j*12)%360)))*7;	
distort_x2=(sin(DEG_2_RAD((int)(timer_use*3+k*12)%360)))*7;	

distort_y1=(cos(DEG_2_RAD((int)(timer_use*3+j2*12)%360)))*7;	
distort_y2=(cos(DEG_2_RAD((int)(timer_use*3+k2*12)%360)))*7;	
}

for(c=0;c<4;c++)
{
	vtx[c]=bp.square[x][y].v[c];

	

	

	if(c==0||c==3)vtx[c].x+=distort_x1;
	if(c==1||c==2)vtx[c].x+=distort_x2;

	if(c==0||c==1)vtx[c].y+=distort_y1;
	if(c==2||c==3)vtx[c].y+=distort_y2;



	

	get_translation_matrix_f(&matrix_display, -buffer_boss_offset_x+boss[0].pos.x, -buffer_boss_offset_y+boss[0].pos.y, 0);
	apply_matrix_f(&matrix_display, vtx[c].x,vtx[c].y,vtx[c].z, &vtx[c].x,&vtx[c].y,&vtx[c].z);

	
}


if(timer<level_boss_intro_timer) 
	{
	
	set_trans_blender(180,220,180,(int)(sin(DEG_2_RAD(timer*40))*30+190-(6.33333*distort_mul) ));
	
	}
else
set_trans_blender(180,220,180,(int)(sin(DEG_2_RAD(timer*40))*30+190));

quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, buffer_boss_scaled, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);




}

	
	solid_mode();

for(x=0;x<12;x++)
for(y=0;y<9;y++)
{
if(boss[0].gel_left[x][y].hits>=10)  draw_gel(x,y,boss[0].gel_left[x][y].pos.x,boss[0].gel_left[x][y].pos.y);
if(boss[0].gel_right[x][y].hits>=10) draw_gel(x,y,boss[0].gel_right[x][y].pos.x,boss[0].gel_right[x][y].pos.y);


}

	
}

void boss_4_collision(int c1)
{
	

	int x=0;
	int y=0;
	struct XANDY pos;
	int c=0;

	pos.x=boss[0].pos.x+80*196/256;
	pos.y=boss[0].pos.y+200*196/256;
if(bullet[c1].flag&BULLET_ACTIVE&&(!(bullet[c1].flag&BULLET_BOSS)))
{
	if	(boss[0].hit_1<10 && sn_collision(boss_ball, pos.x-10, pos.y-10,
		datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
		{
			
		
					
						bullet[c1].flag-=BULLET_ACTIVE;

						if(timer>level_boss_intro_timer+50)boss[0].hit_1++;
		}
		else 
		{
			pos.x=boss[0].pos.x+180*196/256;
			pos.y=boss[0].pos.y+200*196/256;


			if	(bullet[c1].flag&BULLET_ACTIVE&&boss[0].hit_2<10 && sn_collision(boss_ball, pos.x-10, pos.y-10,
			datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
				{
						

						
						bullet[c1].flag-=BULLET_ACTIVE;

						if(timer>level_boss_intro_timer+50)boss[0].hit_2++;
				}
		}
}

	if(bullet[c1].flag&BULLET_ACTIVE&&(!(bullet[c1].flag&BULLET_BOSS)))
	{
		pos.x=boss[0].pos.x;
		pos.y=boss[0].pos.y;
		if(sn_collision_color(buffer_boss_scaled, pos.x, pos.y,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y)!=FALSE)
		{
			
		the_color=sn_collision_color(buffer_boss_scaled, pos.x, pos.y,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y);
		
		
			if(the_color==makecol(32,160,32))
			{
			
			int x1=(float)(0+(-20*196/256+ bullet[c1].pos.x-pos.x)/(6*196/256));
			int y1=(float)(0+(-90*196/256+bullet[c1].pos.y-pos.y)/(10*196/256));

			int x2=(float)(0+(-155*196/256+ bullet[c1].pos.x-pos.x)/(6*196/256));
			int y2=(float)(0+(-90*196/256+bullet[c1].pos.y-pos.y)/(10*196/256));
		
			bullet[c1].flag-=BULLET_ACTIVE;
			
			
			
			for(x=-1;x<1;x++)
				for(y=-1;y<1;y++)
					if(x1+x>=0&&x1+x<30&&y1+y>=0&&y1+y<20)
						if(boss[0].gel_left[x1+x][y1+y].hits<10)
						{
					
						if(timer>level_boss_intro_timer+50)boss[0].gel_left[x1+x][y1+y].hits+=3;
						
							if(boss[0].gel_left[x1+x][y1+y].hits>=10)
							{
							boss[0].gel_left[x1+x][y1+y].pos.x=bullet[c1].pos.x;
							boss[0].gel_left[x1+x][y1+y].pos.y=bullet[c1].pos.y;
							boss[0].gel_left[x1+x][y1+y].move.x=milli;

							}
					
						}

			
			for(x=-1;x<1;x++)
				for(y=-1;y<1;y++)
					if(x2+x>=0&&x2+x<30&&y2+y>=0&&y2+y<20)
						if(boss[0].gel_right[x2+x][y2+y].hits<10)
						{
					
						if(timer>level_boss_intro_timer+50)boss[0].gel_right[x2+x][y2+y].hits+=3;
					
							if(boss[0].gel_right[x2+x][y2+y].hits>=10)
							{
							boss[0].gel_right[x2+x][y2+y].pos.x=bullet[c1].pos.x;
							boss[0].gel_right[x2+x][y2+y].pos.y=bullet[c1].pos.y;
							boss[0].gel_right[x2+x][y2+y].move.x=milli;
							

							}
					
						}


			}


		}


	}

	for(c=0;c<BOSS_MAX_POD;c++)
	if(bullet[c1].flag&BULLET_ACTIVE&&boss[0].pod[c].health>0&&(!(bullet[c1].flag&BULLET_BOSS)))
{
	if	(sn_collision(boss_ball, boss[0].pod[c].pos.x-10, boss[0].pod[c].pos.y-10,
		datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
		{
		
		
						
						bullet[c1].flag-=BULLET_ACTIVE;
						generate_explosion(boss[0].pod[c].pos.x, boss[0].pod[c].pos.y,5);

						if(timer>level_boss_intro_timer+50)boss[0].pod[c].health--;
		}
		
}



					


}

void update_boss_play_0_1_3()
{
	int c,c1=0;
	int check_next_ship=TRUE;

for(c=0;c<2;c++)
if(player[c].flag&PLAYER_ACTIVE)update_player(c);



c=0;
if(boss[c].flag&ENEMY_ACTIVE)
{
	if(update_boss())/*If the boss is still active after updating check bullet collision
						and then player collision with ship*/
	{
		for(c1=0;c1<BULLET_MAX;c1++)
		{
			if(level==3)boss_4_collision(c1);
			else
			{

				if(bullet[c1].flag&BULLET_ACTIVE)
				{
				if(!(bullet[c1].flag&BULLET_BOSS))
					{
					if	(sn_collision(buffer_boss_scaled, boss[0].pos.x-buffer_boss_offset_x, boss[0].pos.y-buffer_boss_offset_y,
						datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
						{
					
							bullet[c1].flag-=BULLET_ACTIVE;
						}
				
				 
					}
				}


				if(bullet[c1].flag&BULLET_ACTIVE)
				{
				if(!(bullet[c1].flag&BULLET_BOSS))
					{
					
					if	(sn_collision(boss_ball, boss[0].ball.pos.x-10, boss[0].ball.pos.y-10,
						datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
						{
							if(bullet[c1].flag&BULLET_PLAYER_1&&(!(boss[0].flag&ENEMY_HIT_BY_PLAYER_1)) )boss[0].flag+=ENEMY_HIT_BY_PLAYER_1;
							else
							if(bullet[c1].flag&BULLET_PLAYER_2&&(boss[0].flag&ENEMY_HIT_BY_PLAYER_1) )boss[0].flag-=ENEMY_HIT_BY_PLAYER_1;
						

							if(timer>level_boss_intro_timer+50)boss[0].health--;
							generate_explosion(boss[0].ball.pos.x, boss[0].ball.pos.y,5);
							bullet[c1].flag-=BULLET_ACTIVE;
						}
				
				 
					}
				}
			}
		}
	

		if(level==3)
		{
		int pod_health_good=FALSE;
		for(c=0;c<BOSS_MAX_POD;c++)
			{
			if(boss[0].pod[c].health>0) pod_health_good=TRUE;
			
			}
		
		

				if(pod_health_good==FALSE)boss[0].health=0;
			}
	}
}



for(c=0;c<2;c++)
if(player[c].flag&PLAYER_ALIVE&&player[c].flag&PLAYER_ACTIVE)
{
		for(c1=0;c1<BULLET_MAX;c1++)
		{

			if(bullet[c1].flag&BULLET_ACTIVE)
			{
			if(bullet[c1].flag&BULLET_BOSS)
				{
				if	(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
					{
						if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
						bullet[c1].flag-=BULLET_ACTIVE;
					}
				
				 
				}
			}
		}





			if(boss[0].flag&ENEMY_ACTIVE)
			{
			
				if	(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,
					buffer_boss_scaled, boss[0].pos.x-buffer_boss_offset_x, boss[0].pos.y-buffer_boss_offset_y))
					{
						if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
					}
				
				 
				
			}


	
}
if(boss_dead[0].flag&ENEMY_DEAD_ACTIVE&&boss_dead[0].score_timer<timer)boss_dead[0].flag-=ENEMY_DEAD_ACTIVE;


update_anim();

for(c=0;c<2;c++)
{
update_bullets(c);
}





}


void update_boss_play_2()
{
	int c,c1=0;
	int check_next_ship=TRUE;

for(c=0;c<2;c++)
if(player[c].flag&PLAYER_ACTIVE)update_player(c);



c=0;
if(boss[c].flag&ENEMY_ACTIVE)
{
	if(update_boss())/*If the boss is still active after updating check bullet collision
						and then player collision with ship*/
	{
		for(c1=0;c1<BULLET_MAX;c1++)
		{

			if(bullet[c1].flag&BULLET_ACTIVE)
			{
			if(bullet[c1].flag&BULLET_PLAYER_1 || bullet[c1].flag&BULLET_PLAYER_2)
				{
				if	(sn_collision(datafile_boss[2][0].dat, 0,0,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
					{
					
						bullet[c1].flag-=BULLET_ACTIVE;
					}
				
				 
				}
			}


			if(bullet[c1].flag&BULLET_ACTIVE)
			{
			if(bullet[c1].flag&BULLET_PLAYER_1 || bullet[c1].flag&BULLET_PLAYER_2)
				{
				if	(sn_collision(boss_ball, boss[0].ball.pos.x-10, boss[0].ball.pos.y-10,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
					{
						if(bullet[c1].flag&BULLET_PLAYER_1&&(!(boss[0].flag&ENEMY_HIT_BY_PLAYER_1)) )boss[0].flag+=ENEMY_HIT_BY_PLAYER_1;
						else
						if(bullet[c1].flag&BULLET_PLAYER_2&&(boss[0].flag&ENEMY_HIT_BY_PLAYER_1) )boss[0].flag-=ENEMY_HIT_BY_PLAYER_1;
						
						generate_explosion(boss[0].ball.pos.x, boss[0].ball.pos.y,5);
						if(timer>level_boss_intro_timer+50)boss[0].health--;
						bullet[c1].flag-=BULLET_ACTIVE;
					}
				
				 
				}
			}
		}
	
	}
}



for(c=0;c<2;c++)
if(player[c].flag&PLAYER_ALIVE)
{
		for(c1=0;c1<BULLET_MAX;c1++)
		{

			if(bullet[c1].flag&BULLET_ACTIVE)
			{
			if(bullet[c1].flag&BULLET_BOSS)
				{
				if	(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
					{
						if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
						bullet[c1].flag-=BULLET_ACTIVE;
					}
				
				 
				}
			}
		}





			if(boss[0].flag&ENEMY_ACTIVE)
			{
			
				if	(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,
					datafile_boss[2][0].dat,0,0))
					{
						if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
					}
				
				 
				
			}


	
}
if(boss_dead[0].flag&ENEMY_DEAD_ACTIVE&&boss_dead[0].score_timer<timer)boss_dead[0].flag-=ENEMY_DEAD_ACTIVE;


update_anim();

for(c=0;c<2;c++)
{
update_bullets(c);
}



}

void update_normal_play()
{
	int c,c1,c2=0;
	int check_next_ship=TRUE;

for(c=0;c<2;c++)
if(player[c].flag&PLAYER_ACTIVE)update_player(c);


if(level_flag&LEVEL_ENEMIES_END) check_next_ship=FALSE;
for(c=next_ship_called;check_next_ship==TRUE;)
{
	if(c>=ENEMY_MAX_CALLS) break;

	if(timer>=enemy_call[c].start_time&&enemy_call[c].flag&ENEMY_USED)
	{
		if(generate_ship(c))	
		{
			next_ship_called=c+1;
			c++;
		}
			else check_next_ship=FALSE;
	}
	else
	{
		if(!(enemy_call[c].flag&ENEMY_USED)) 
		{
			next_ship_called++;
			c++;
		}
			else check_next_ship=FALSE;
	}


}

for(c=0;c<ENEMY_MAX_ON_SCREEN;c++)
if(enemy[c].flag&ENEMY_ACTIVE)
{
	if(update_ship(c))/*If the ship is still active after updating check bullet collision
						and then player collision with ship*/
	{
		for(c1=0;c1<BULLET_MAX;c1++)
		{

			if(bullet[c1].flag&BULLET_ACTIVE)
			{
			if(bullet[c1].flag&BULLET_PLAYER_1 || bullet[c1].flag&BULLET_PLAYER_2)
				{
				if	(sn_collision(datafile[enemy[c].frame.act].dat, enemy[c].pos.x, enemy[c].pos.y,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
					{
						if(bullet[c1].flag&BULLET_PLAYER_1&&(!(enemy[c].flag&ENEMY_HIT_BY_PLAYER_1)) )enemy[c].flag+=ENEMY_HIT_BY_PLAYER_1;
						else
						if(bullet[c1].flag&BULLET_PLAYER_2&&(enemy[c].flag&ENEMY_HIT_BY_PLAYER_1) )enemy[c].flag-=ENEMY_HIT_BY_PLAYER_1;
						

						enemy[c].health--;
						bullet[c1].flag-=BULLET_ACTIVE;
					}
				
				 
				}
			}
		}
	
	}
}


for(c=0;c<2;c++)
if(player[c].flag&PLAYER_ALIVE && player[c].flag&PLAYER_ACTIVE)
{
		for(c1=0;c1<BULLET_MAX;c1++)
		{

			if(bullet[c1].flag&BULLET_ACTIVE)
			{
			if(bullet[c1].flag&BULLET_ENEMY)
				{
				if	(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,
					datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
					{
						if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
						bullet[c1].flag-=BULLET_ACTIVE;
					}
				
				 
				}
			}
		}



		for(c1=0;c1<ENEMY_MAX_ON_SCREEN;c1++)
		{

			if(enemy[c1].flag&ENEMY_ACTIVE)
			{
			
				if	(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,
					datafile[enemy[c1].frame.act].dat, enemy[c1].pos.x, enemy[c1].pos.y))
					{
						if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
					}
				
				 
				
			}
		}

	
}


	




for(c=0;c<ENEMY_MAX_ON_SCREEN;c++)
if(enemy_dead[c].flag&ENEMY_DEAD_ACTIVE&&enemy_dead[c].score_timer<timer)enemy_dead[c].flag-=ENEMY_DEAD_ACTIVE;

	if(level==4)
	{
	int x=0;
	int y=0;
	int get_color=0;

	
	
	for(x=0;x<10;x++)
		for(y=0;y<201;y++)
		{
			if( ((32*y-3060)+(int)(timer*30))>-16 && ((32*y-3060)+(int)(timer*30))<240 )
			{
				get_color=getr(getpixel(datafile_background[21].dat,x,y));
				for(c=0;c<2;c++)
					if(player[c].flag&PLAYER_ALIVE)
						if(get_color==200)
							if(sn_collision(datafile[player[c].frame.act].dat, player[c].pos.x, player[c].pos.y,datafile_background[22].dat,x*32,(32*y-3060)+(int)(timer*30)) )
								{
									if(player[c].flag&PLAYER_ALIVE)player[c].flag-=PLAYER_ALIVE;
								}
			
				for(c1=0;c1<BULLET_MAX;c1++)
					if(bullet[c1].flag&BULLET_ACTIVE)
						{
							if(bullet[c1].flag&BULLET_PLAYER_1 || bullet[c1].flag&BULLET_PLAYER_2)
								{
								if(get_color==200)
									if(sn_collision(datafile_background[22].dat,x*32,(32*y-3060)+(int)(timer*30),datafile[bullet[c1].type].dat, bullet[c1].pos.x,bullet[c1].pos.y))
										{
											bullet[c1].flag-=BULLET_ACTIVE;
										}
								}
						}
			}
		}
	}
	





update_anim();

for(c=0;c<2;c++)
{
update_bullets(c);
}

}

		
read_file_boss()
{

/*Reads AI file.
first letter read is ref. after ref "(" is to
say parameters to follow. ")" is used to say end of
parameters. if another ref is on same line "," is used to seperate.
time for start of AI in program is based in tenths according
to line number.
  
parameter legend
value written to designate command followed by Letter 

parameter not used for boss 0T	ship type Tparam
1P	x,y coord P[param 1,param 2]
2L	start or end point left of screen Lparam 	
3R	start or end point right of screen Rparam
4U	start or end point top of screen Uparam
5D	start or end point bottom of screen Dparam
parameter not used for boss 6C	copy of specified reference Creference

parameter not used for boss M	mirrored copy followed by 
parameter not used for boss	7V for vertical mirror  
parameter not used for boss	8H for horizantal mirror

9X	cos modulation speed and amplitude C[param 1,param 2]	
10Y	sin modulation speed and amplitude S[param 1,param 2]
11V speed Vparam
12W wait Wparam
13F fire Fparam
14J	number of times to loop,loop back to J[param 1,param 2]
15B fire type Bparam 
*/  
int c=0;
char char_read='x';
char char_read2='x';

int word_char_counter=0;

char buf[10];
int value_read;
int parameter=0;
	
int num_parameters=0;

for(;;)
{


for(c=0;c<10;c++)
buf[c]='\0';



	
char_read=fgetc(f3); 
   
	/*should read as "(" to state start of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read!='(') return error_message*100+1;

for(;;)
{
char_read=fgetc(f3);


if(char_read=='P')/*type value=1*/
{

char_read2=fgetc(f3);
/*should read as "[" to state start of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!='[') return error_message*100+3;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_POS;
parameter++;
	}
else
return error_message*100+4; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "," to state next parameter 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=',') return error_message*100+5;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_POS;
parameter++;
	}
else
return error_message*100+5; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "]" to state close of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=']') return error_message*100+6;

char_read=fgetc(f3);
}
else
if(char_read=='L')/*type value=2*/
{
if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_LEFT;
parameter++;
	}
else
return error_message*100+7; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='R')/*type value=3*/
{
if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_RIGHT;
parameter++;
	}
else
return error_message*100+8; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='U')/*type value=4*/
{
if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_TOP;
parameter++;
	}
else
return error_message*100+9; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='D')/*type value=5*/
{
if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_BOTTOM;
parameter++;
	}
else
return error_message*100+10; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='X')/*type value=9*/
{
char_read2=fgetc(f3);
/*should read as "[" to state start of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!='[') return error_message*100+14;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_X_MOD;
parameter++;
	}
else
return error_message*100+15; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "," to state next parameter 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=',') return error_message*100+16;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_X_MOD;
parameter++;
	}
else
return error_message*100+17; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "]" to state close of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=']') return error_message*100+18;
char_read=fgetc(f3);
}
else
if(char_read=='Y')/*type value=10*/
{
char_read2=fgetc(f3);
/*should read as "[" to state start of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!='[') return error_message*100+14;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_Y_MOD;
parameter++;
	}
else
return error_message*100+15;/*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "," to state next parameter 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=',') return error_message*100+16;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_Y_MOD;
parameter++;
	}
else
return error_message*100+17; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "]" to state close of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=']') return error_message*100+18;
char_read=fgetc(f3);
}
else
if(char_read=='V')/*type value=11*/
{
		if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_SPEED;
parameter++;
	}
else
return error_message*100+23; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='W')/*type value=12*/
{
		if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_WAIT;
parameter++;
	}
else
return error_message*100+24; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='F')/*type value=13*/
{
		if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_FIRE;
parameter++;
	}
else
return error_message*100+25; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}
else
if(char_read=='J')/*type value=1*/
{

char_read2=fgetc(f3);
/*should read as "[" to state start of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!='[') return error_message*100+26;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_LOOP;
parameter++;
	}
else
return error_message*100+27; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "," to state next parameter 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=',') return error_message*100+28;

if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_LOOP;
parameter++;
	}
else
return error_message*100+28; /*if value found is not within limits return error_message*100+error*/

char_read2=fgetc(f3);
/*should read as "]" to state close of parameters 
   else quit and return error_message*100+line number failed at*/
if(char_read2!=']') return error_message*100+29;

char_read=fgetc(f3);
}
else
if(char_read=='B')/*type value=13*/
{
		if(fscanf(f3,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

boss_data[parameter].value=value_read;
boss_data[parameter].type=COMMAND_FIRE_TYPE;
parameter++;
	}
else
return error_message*100+30; /*if value found is not within limits return error_message*100+error*/

char_read=fgetc(f3);
}

num_parameters=parameter;




if(char_read==')') 
{
if(num_parameters<=0)return error_message*100+31;
boss[0].num_param=num_parameters;

break;
}										/*if the character read is a close braket
											no more param are read if 0 param have been
											read there is an error next line will return error_message*100+error
											break from loop*/
else
if(char_read!=',') return error_message*100+32;/*-error_message;/*if the character read is not
									   a comma indicating another param
									   return an error*/



}



	

	
	return -1;//file finished;
	

}

	return -2;
 
}


write_file_boss()
{
   
	int c=0;
	int c1=0;

	fseek(f4,0, SEEK_SET);

	for(c=0;c<boss[0].num_param;c++)
	{

			fprintf(f4, "%s", command_boss_desc[boss_data[c].type]);
			for(c1=0;c1<check_boss_num_parameters(boss_data[c].type);c1++)
				{
			
				if(c1==0)fprintf(f4, " = ");
				fprintf(f4, " %d", boss_data[c+c1].value); 
				if(c1!=(check_boss_num_parameters(boss_data[c+c1].type)-1) )fprintf(f4,",");
				}
			c+=c1-1;

			
			fprintf(f4, "\n");
	}
			fprintf(f4, "\n");
		
	
fprintf(f4, "parameters used %d,message %d",boss[0].num_param,error_message);
	
	fclose(f4);
return 0;
}
		
read_file()
{

/*Reads AI file.
first letter read is ref. after ref "(" is to
say parameters to follow. ")" is used to say end of
parameters. if another ref is on same line "," is used to seperate.
time for start of AI in program is based in tenths according
to line number.
  
parameter legend
value written to designate command followed by Letter 

0T	ship type Tparam
1P	x,y coord P[param 1,param 2]
2L	start or end point left of screen Lparam 	
3R	start or end point right of screen Rparam
4U	start or end point top of screen Uparam
5D	start or end point bottom of screen Dparam
6C	copy of specified reference Creference

M	mirrored copy followed by 
	7V for vertical mirror  MV
	8H for horizantal mirror

9X	cos modulation speed and amplitude C[param 1,param 2]	
10Y	sin modulation speed and amplitude S[param 1,param 2]
11V speed Vparam
12W wait Wparam
13F fire Fparam
*/  
int c=0;
char char_read='x';
char char_read2='x';
int line_counter=1;
int enemy_counter=0;
int word_char_counter=0;

char buf[10];
int value_read;
int parameter=0;
	
int last_parameter_value=0;
int num_parameters=0;

for(;;)
{


for(c=0;c<10;c++)
buf[c]=0;


if(fscanf(f1,"%[-0-9]",buf)>0) 
	{

value_read=atoi(buf);
if(value_read<ENEMY_MAX_CALLS&&value_read>-1)
		{
/*valid reference found*/	
if(!(enemy_call[enemy_counter].flag&ENEMY_USED))
			{
enemy_call[enemy_counter].flag+=ENEMY_USED;
enemy_call[enemy_counter].ref=value_read;
enemy_call[enemy_counter].start_time=line_counter;
enemy_call[enemy_counter].start_param=parameter;
enemy_counter++;

			}
		}
	
char_read=fgetc(f1); 
   
	/*should read as "(" to state start of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read!='(') return line_counter*100+1;

for(;;)
{
char_read=fgetc(f1);
if(char_read=='T')/*type value=0*/
{
	
if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_SHIP_TYPE;
parameter++;
	}
else
return line_counter*100+2; /*if value found is not within limits return line_counter*100+error*/
char_read=fgetc(f1);
}
else
if(char_read=='P')/*type value=1*/
{

char_read2=fgetc(f1);
/*should read as "[" to state start of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!='[') return line_counter*100+3;

if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_POS;
parameter++;
	}
else
return line_counter*100+4; /*if value found is not within limits return line_counter*100+error*/

char_read2=fgetc(f1);
/*should read as "," to state next parameter 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!=',') return line_counter*100+5;

if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_POS;
parameter++;
	}
else
return line_counter*100+5; /*if value found is not within limits return line_counter*100+error*/

char_read2=fgetc(f1);
/*should read as "]" to state close of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!=']') return line_counter*100+6;

char_read=fgetc(f1);
}
else
if(char_read=='L')/*type value=2*/
{
if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_LEFT;
parameter++;
	}
else
return line_counter*100+7; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='R')/*type value=3*/
{
if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_RIGHT;
parameter++;
	}
else
return line_counter*100+8; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='U')/*type value=4*/
{
if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_TOP;
parameter++;
	}
else
return line_counter*100+9; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='D')/*type value=5*/
{
if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_BOTTOM;
parameter++;
	}
else
return line_counter*100+10; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='C')/*type value=6*/
{
if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_COPY;
parameter++;
	}
else
return line_counter*100+11; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='M')
{
char_read=fgetc(f1);

	if(char_read=='V')/*type value=7*/
	{
		if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_MIRROR_VERTICAL;
parameter++;
	}
else
return line_counter*100+12; /*if value found is not within limits return line_counter*100+error*/



	}
	else
	if(char_read=='H')/*type value=8*/
	{
		if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_MIRROR_HORIZANTAL;
parameter++;
	}
else
return line_counter*100+13; /*if value found is not within limits return line_counter*100+error*/



	}

char_read=fgetc(f1);
}
else
if(char_read=='X')/*type value=9*/
{
char_read2=fgetc(f1);
/*should read as "[" to state start of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!='[') return line_counter*100+14;

if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_X_MOD;
parameter++;
	}
else
return line_counter*100+15; /*if value found is not within limits return line_counter*100+error*/

char_read2=fgetc(f1);
/*should read as "," to state next parameter 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!=',') return line_counter*100+16;

if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_X_MOD;
parameter++;
	}
else
return line_counter*100+17; /*if value found is not within limits return line_counter*100+error*/

char_read2=fgetc(f1);
/*should read as "]" to state close of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!=']') return line_counter*100+18;
char_read=fgetc(f1);
}
else
if(char_read=='Y')/*type value=10*/
{
char_read2=fgetc(f1);
/*should read as "[" to state start of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!='[') return line_counter*100+14;

if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_Y_MOD;
parameter++;
	}
else
return line_counter*100+15; /*if value found is not within limits return line_counter*100+error*/

char_read2=fgetc(f1);
/*should read as "," to state next parameter 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!=',') return line_counter*100+16;

if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_Y_MOD;
parameter++;
	}
else
return line_counter*100+17; /*if value found is not within limits return line_counter*100+error*/

char_read2=fgetc(f1);
/*should read as "]" to state close of parameters 
   else quit and return line_counter*100+line number failed at*/
if(char_read2!=']') return line_counter*100+18;
char_read=fgetc(f1);
}
else
if(char_read=='V')/*type value=11*/
{
		if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_SPEED;
parameter++;
	}
else
return line_counter*100+23; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='W')/*type value=12*/
{
		if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_WAIT;
parameter++;
	}
else
return line_counter*100+24; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
else
if(char_read=='F')/*type value=13*/
{
		if(fscanf(f1,"%[-0-9]",buf)>0) 
	{
/*valid reference found*/
value_read=atoi(buf);

ship_data[parameter].value=value_read;
ship_data[parameter].type=COMMAND_FIRE;
parameter++;
	}
else
return line_counter*100+25; /*if value found is not within limits return line_counter*100+error*/

char_read=fgetc(f1);
}
if(enemy_counter>0)num_parameters=parameter-enemy_call[enemy_counter-1].start_param;

last_parameter_value=parameter;


if(char_read==')') 
{
if(num_parameters<=0)return -line_counter*100+26;
if(enemy_counter>0)enemy_call[enemy_counter-1].num_param=num_parameters;

break;
}										/*if the character read is a close braket
											no more param are read if 0 param have been
											read there is an error next line will return line_counter*100+error
											break from loop*/
else
if(char_read!=',') return line_counter*100+27;/*-line_counter;/*if the character read is not
									   a comma indicating another param
									   return an error*/

}

}


char_read=fgetc(f1);

	

	if(char_read=='\n')
	{
	line_counter++;
	}
	else
	if (feof(f1)) 
	{
	return 28;
	}

}
 
}


write_file()
{
   
	int c=0;
	int c1=0;
	int c2=0;

	fseek(f2,0, SEEK_SET);

	for(c=0;c<ENEMY_MAX_CALLS;c++)
	{
	if(enemy_call[c].flag&ENEMY_USED)
		{
	fprintf(f2, "enemy_call[%d].flag=%d\n",c, enemy_call[c].flag);
	fprintf(f2, "enemy_call[%d].ref=%d\n",c, enemy_call[c].ref);
	fprintf(f2, "enemy_call[%d].start_time=%d\n",c, enemy_call[c].start_time);
	fprintf(f2, "enemy_call[%d].start_param=%d\n",c, enemy_call[c].start_param);
	for(c1=0;c1<enemy_call[c].num_param;)
			{
			fprintf(f2, "%s", command_desc[ship_data[enemy_call[c].start_param+c1].type]);
			for(c2=0;c2<check_num_parameters(ship_data[enemy_call[c].start_param+c1].type);c2++)
				{
			
				fprintf(f2, " %d", ship_data[enemy_call[c].start_param+c1+c2].value); 
				if(c2!=(check_num_parameters(ship_data[enemy_call[c].start_param+c1].type)-1) )fprintf(f2,",");
				}

			if(c2<=0)return -1; /*if a command has no parameters that is an error*/
			c1+=c2;
			fprintf(f2, "\n");
			}
			fprintf(f2, "\n");
		}
	}
fprintf(f2, "count_used %d",last_enemy_read);
	
	fclose(f2);
return 0;
}

draw_foreground()
{
	int get_color=0;
	int x=0;
	int y=0;
	int c=0;


if(level==1)
{

vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=85+(sin(DEG_2_RAD(timer*0.1))*20);
vtx[0].v=0-(float)(timer*0.5);


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=85+(sin(DEG_2_RAD(timer*0.1))*20);
vtx[1].v=32-(float)(timer*0.5);

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=85+(sin(DEG_2_RAD(timer*0.1))*20)+32;
vtx[2].v=32-(float)(timer*0.5);

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=85+(sin(DEG_2_RAD(timer*0.1))*20)+32;
vtx[3].v=0-(float)(timer*0.5);

		

	

		
		drawing_mode(DRAW_MODE_TRANS,0,0,0);
		set_trans_blender(255,255,255,40+(int)(sin(DEG_2_RAD(timer*0.2))*40) );

vtx[0].c=255;
vtx[1].c=255;
vtx[2].c=255;
vtx[3].c=255;

		quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, datafile_background[1].dat, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);
}
		
		
		
	if(level==2)
	{
		drawing_mode(DRAW_MODE_TRANS,0,0,0);
		set_trans_blender(255,255,215,20 );
		

		
	for(x=0;x<10;x++)
	for(y=0;y<39;y++)
		{
			get_color=getb(getpixel(datafile_background[8].dat,x,y));
			if(get_color==100)
				{
					for(c=0;c<15;c++)
					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),2+c*2,makecol(235,235+c,235+c));

					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),40,makecol(235,235,255));
					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),60,makecol(235,235,255));	
					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),90,makecol(245,245,255));	

				}
			if(get_color==200)
				{
					for(c=0;c<10;c++)
					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),5+c,makecol(255,255,255));
					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),40,makecol(255,255,25));
					circlefill(buffer,x*32+16,(32*y-960)+(int)(timer),55,makecol(225,255,25));
				
				}


		}
	}		











}

draw_background()
{
	int x=0;
	int y=0;

	int get_color=0;

	if(level==0)
	{
		solid_mode();
		

vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[0].v=0-(float)(timer*0.25);
vtx[0].c=makecol(80+(int)(sin(DEG_2_RAD(timer*2))*50),30+(int)(sin(DEG_2_RAD(timer*4))*10),60);


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[1].v=64-(float)(timer*0.25);
vtx[1].c=makecol(30,30,20);

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[2].v=64-(float)(timer*0.25);
vtx[2].c=makecol(20,30,30);

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[3].v=0-(float)(timer*0.25);
vtx[3].c=makecol(80+(int)(cos(DEG_2_RAD(timer*2))*50),30+(int)(sin(DEG_2_RAD(timer*6))*20),80);


	
		quad3d_f(buffer, POLYTYPE_GRGB, NULL, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);

		
		drawing_mode(DRAW_MODE_TRANS,0,0,0);
		set_trans_blender(255,255,255,8+(int)(sin(DEG_2_RAD(timer*6))*8) );

vtx[0].c=255;
vtx[1].c=255;
vtx[2].c=255;
vtx[3].c=255;

		quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, datafile_background[0].dat, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);

		
		
		
		
		get_scaling_matrix_f(&matrix_display, 0.25, 1, 0);
		apply_matrix_f(&matrix_display, vtx[0].x,vtx[0].y,vtx[0].z, &vtx[0].x,&vtx[0].y,&vtx[0].z);
		apply_matrix_f(&matrix_display, vtx[1].x,vtx[1].y,vtx[1].z, &vtx[1].x,&vtx[1].y,&vtx[1].z);
		apply_matrix_f(&matrix_display, vtx[2].x,vtx[2].y,vtx[2].z, &vtx[2].x,&vtx[2].y,&vtx[2].z);
		apply_matrix_f(&matrix_display, vtx[3].x,vtx[3].y,vtx[3].z, &vtx[3].x,&vtx[3].y,&vtx[3].z);

		get_translation_matrix_f(&matrix_display, 80+(int)(cos(DEG_2_RAD(timer*0.25))*160), 0, 0);
		apply_matrix_f(&matrix_display, vtx[0].x,vtx[0].y,vtx[0].z, &vtx[0].x,&vtx[0].y,&vtx[0].z);
		apply_matrix_f(&matrix_display, vtx[1].x,vtx[1].y,vtx[1].z, &vtx[1].x,&vtx[1].y,&vtx[1].z);
		apply_matrix_f(&matrix_display, vtx[2].x,vtx[2].y,vtx[2].z, &vtx[2].x,&vtx[2].y,&vtx[2].z);
		apply_matrix_f(&matrix_display, vtx[3].x,vtx[3].y,vtx[3].z, &vtx[3].x,&vtx[3].y,&vtx[3].z);

		set_trans_blender(255,255,255,5+(int)(cos(DEG_2_RAD(timer*6))*2) );


		quad3d_f(buffer, POLYTYPE_ATEX_MASK_TRANS, datafile_background[0].dat, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);






	}





	if(level==1)
	{
		solid_mode();


vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[0].v=0-(float)(timer*0.25);
vtx[0].c=makecol(200+(int)(sin(DEG_2_RAD(timer*2))*50),200+(int)(sin(DEG_2_RAD(timer*4))*10),255);


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[1].v=64-(float)(timer*0.25);
vtx[1].c=makecol(225,225,255);

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[2].v=64-(float)(timer*0.25);
vtx[2].c=makecol(225,225,255);

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[3].v=0-(float)(timer*0.25);
vtx[3].c=makecol(200+(int)(cos(DEG_2_RAD(timer*2))*50),200+(int)(sin(DEG_2_RAD(timer*6))*20),255);

		

	
		quad3d_f(buffer, POLYTYPE_GRGB, NULL, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);

		
	for(x=0;x<10;x++)
	for(y=0;y<49;y++)
		{
			get_color=getr(getpixel(datafile_background[2].dat,x,y));
			if(get_color==100)
				draw_sprite(buffer,datafile_background[3].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==200)
				draw_sprite(buffer,datafile_background[4].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==220)
				draw_sprite(buffer,datafile_background[5].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==240)
				draw_sprite(buffer,datafile_background[6].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==255)
				draw_sprite(buffer,datafile_background[7].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==20)
				draw_sprite_v_flip(buffer,datafile_background[6].dat,x*32,(32*y-960)+(int)(timer));


		}
	}

	if(level==2)
	{
		solid_mode();
		


vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[0].v=0-(float)(timer*0.25);
vtx[0].c=makecol(100+(int)(sin(DEG_2_RAD(timer*2))*100),155,120+(int)(sin(DEG_2_RAD(timer*4))*120));


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[1].v=64-(float)(timer*0.25);
vtx[1].c=makecol(25,25,55);

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[2].v=64-(float)(timer*0.25);
vtx[2].c=makecol(25,25,55);

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[3].v=0-(float)(timer*0.25);
vtx[3].c=makecol(100+(int)(cos(DEG_2_RAD(timer*2))*100),155,120+(int)(sin(DEG_2_RAD(timer*6))*120));//c_test;//y*3+(32-(fabs(x-32)))*1;

		

	
		quad3d_f(buffer, POLYTYPE_GRGB, NULL, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);

		

		
	for(x=0;x<10;x++)
	for(y=0;y<49;y++)
		{
			get_color=getr(getpixel(datafile_background[8].dat,x,y));
			if(get_color==100)
				draw_sprite(buffer,datafile_background[9].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==200)
				draw_sprite(buffer,datafile_background[10].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==220)
				draw_sprite(buffer,datafile_background[11].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==240)
				draw_sprite_h_flip(buffer,datafile_background[11].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==255)
				draw_sprite(buffer,datafile_background[12].dat,x*32,(32*y-960)+(int)(timer));
			if(get_color==20)
				draw_sprite(buffer,datafile_background[13].dat,x*32,(32*y-960)+(int)(timer));



		}
	}













	if(level==3)
	{
		solid_mode();
		
vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=0;
vtx[0].v=0;
vtx[0].c=makecol((int)(64+sin(DEG_2_RAD(timer*0.6+270))*64),(int)(64+sin(DEG_2_RAD(timer*0.6+270))*64),0);


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=0;
vtx[1].v=0;
vtx[1].c=makecol(10,10,10);

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=0;
vtx[2].v=0;
vtx[2].c=makecol(10,10,10);

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=0;
vtx[3].v=0;
vtx[3].c=makecol((int)(64-sin(DEG_2_RAD(timer*2.2+270))*64),0,(int)(64-sin(DEG_2_RAD(timer*0.6-270))*64));

		

	
		quad3d_f(buffer, POLYTYPE_GRGB, NULL, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);
		
		
if(!(boss[0].flag&ENEMY_DRAW))
		{
		
	for(x=0;x<10;x++)
	for(y=0;y<49;y++)
		{
			get_color=getr(getpixel(datafile_background[14].dat,x,y));
			if(get_color==100)
			{
			if((int)(timer*0.5+y*5+x*5)%20>15)draw_sprite(buffer,datafile_background[15].dat,x*32,(32*y-960)+(int)(timer));
			else draw_sprite(buffer,datafile_background[16].dat,x*32,(32*y-960)+(int)(timer));
			
		
			}


	
		


		}
		
	drawing_mode(DRAW_MODE_MASKED_PATTERN,datafile_background[20].dat,320+(int)(sin(DEG_2_RAD(timer*1))*720),240);
	set_trans_blender(0,0,0,0 );
	if(timer>-64)rectfill(buffer,-10,timer-420,330,timer+64,makecol(0,0,0));
	
	
	drawing_mode(DRAW_MODE_MASKED_PATTERN,datafile_background[20].dat,320+(int)(-sin(DEG_2_RAD(timer*1))*320),240+(int)(-sin(DEG_2_RAD(90+timer*1))*240));
	set_trans_blender(0,0,0,0 );
	if(timer>-64)rectfill(buffer,-10,timer-420,330,timer+64,makecol(0,0,0));



		}
		if(boss[0].flag&ENEMY_DRAW)
		{
		
			for(x=0;x<11;x++)
				for(y=0;y<11;y++)
					rect(buffer,x*32,y*24,((x+1)*32)-1,((y+1)*24)-1,makecol( (10-y)*25,100,(int)(128-(fabs(x-5)*12)) ) );
		}
	}


	if(level==4)
	{
		solid_mode();
		


vtx[0].x=0;
vtx[0].y=0;
vtx[0].z=0;
vtx[0].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[0].v=0-(float)(timer*0.25);
vtx[0].c=makecol(100+(int)(sin(DEG_2_RAD(timer*2))*100),155,120+(int)(sin(DEG_2_RAD(timer*4))*120));


vtx[1].x=0;
vtx[1].y=SCREEN_H_USE;
vtx[1].z=0;
vtx[1].u=85+(sin(DEG_2_RAD(timer))*10);
vtx[1].v=64-(float)(timer*0.25);
vtx[1].c=makecol(25,25,55);

vtx[2].x=SCREEN_W_USE;
vtx[2].y=SCREEN_H_USE;
vtx[2].z=0;
vtx[2].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[2].v=64-(float)(timer*0.25);
vtx[2].c=makecol(25,25,55);

vtx[3].x=SCREEN_W_USE;
vtx[3].y=0;
vtx[3].z=0;
vtx[3].u=85+(sin(DEG_2_RAD(timer))*10)+64;
vtx[3].v=0-(float)(timer*0.25);
vtx[3].c=makecol(100+(int)(cos(DEG_2_RAD(timer*2))*100),155,120+(int)(sin(DEG_2_RAD(timer*6))*120));

		

	
		quad3d_f(buffer, POLYTYPE_GRGB, NULL, &vtx[0],&vtx[1],&vtx[2],&vtx[3]);

		

		
	for(x=0;x<10;x++)
	for(y=0;y<201;y++)
		{
			get_color=getr(getpixel(datafile_background[21].dat,x,y));
			if(get_color==200)
				draw_sprite(buffer,datafile_background[22].dat,x*32,(32*y-3060)+(int)(timer*30));
			


		}
	}

}





/*This function is used to show the graphics*/
void display()
{
	
	int x=0;
	int y=0;
	int c,c1=0;
	

	


	draw_background();
	solid_mode();


for(c=0;c<2;c++)
{
if(player[c].flag&PLAYER_ACTIVE)
if(player[c].flag&PLAYER_ALIVE)
	{
		draw_sprite(buffer,datafile[player[c].frame.act].dat,player[c].pos.x,player[c].pos.y);
	}
else if(player[c].flag&PLAYER_REGEN_SHOWN)
	{
	
	set_trans_blender(0,0,0,160+(int)(sin(DEG_2_RAD(timer*200))*60) );
	draw_trans_sprite(buffer,datafile[player[c].frame.act].dat,player[c].pos.x,player[c].pos.y);
	}
}



for(c=0;c<BULLET_MAX;c++)
{
	if(bullet[c].flag&BULLET_ACTIVE) 
	{
		if(!(bullet[c].flag&BULLET_ENEMY|| bullet[c].flag&BULLET_BOSS))
		{
		
		
			rectfill(buffer,2+ bullet[c].pos.x-2, bullet[c].pos.y-9,2+ bullet[c].pos.x+2, bullet[c].pos.y+8, makecol(212-50,255-50,230-50));
			rectfill(buffer,2+ bullet[c].pos.x-1, bullet[c].pos.y-7,2+ bullet[c].pos.x+1, bullet[c].pos.y+6, makecol(212-10,255-10,230-10));
			line(buffer,2+ bullet[c].pos.x, bullet[c].pos.y-6,2+bullet[c].pos.x, bullet[c].pos.y-3, makecol(112,255,130));
			line(buffer,2+ bullet[c].pos.x, bullet[c].pos.y+2,2+bullet[c].pos.x, bullet[c].pos.y+5, makecol(112,255,130));

			
			
		}
	}

}


for(c=0;c<ENEMY_MAX_ON_SCREEN;c++)
	{
		if(enemy[c].flag&ENEMY_DRAW)
		{
			if(enemy[c].frame.angle==0) draw_sprite(buffer,datafile[enemy[c].frame.act].dat,enemy[c].pos.x,enemy[c].pos.y);
			else rotate_sprite(buffer,datafile[enemy[c].frame.act].dat,enemy[c].pos.x,enemy[c].pos.y,ftofix(enemy[c].frame.angle*256/360));
			
			
		}
	}

if(boss[0].flag&ENEMY_DRAW && level==0)	draw_boss_0();
if(boss[0].flag&ENEMY_DRAW && level==1)	draw_boss_1();
if(boss[0].flag&ENEMY_DRAW && level==2)	draw_boss_2();
if(boss[0].flag&ENEMY_DRAW && level==3)	draw_boss_3();










if(boss_dead[0].flag&ENEMY_DEAD_ACTIVE)
{
	if(boss_dead[0].flag&ENEMY_DEAD_HIT_BY_PLAYER_1)
	{
				sprintf(msg, "%d",boss[0].points);
				textout_ex(buffer, font, msg,boss_dead[0].pos.x, boss_dead[0].pos.y, makecol(220,20,50),-1);
	}
	else
	{
				sprintf(msg, "%d",boss[0].points);
				textout_ex(buffer, font, msg, boss_dead[0].pos.x, boss_dead[0].pos.y, makecol(50,20,220),-1);
	}
}

for(c=0;c<BULLET_MAX;c++)
{
	if(bullet[c].flag&BULLET_ACTIVE) 
	{
		if(bullet[c].flag&BULLET_ENEMY|| bullet[c].flag&BULLET_BOSS)
		{
			draw_sprite(buffer,datafile[bullet[c].type].dat,bullet[c].pos.x,bullet[c].pos.y);
		
		}
		
	}

}

draw_foreground();

drawing_mode(DRAW_MODE_TRANS,0,0,0);
set_trans_blender(255,255,255,255);
for(c=0;c<EXPLOSION_MAX;c++)
if(explosion[c].flag&EXPLOSION_ACTIVE)
{
	if(timer<explosion[c].start_time || (explosion[c].start_time+explosion[c].duration)<timer)
	{
		explosion[c].flag=0;
	}
	else
	{
		float percent=(timer-explosion[c].start_time)/explosion[c].duration;
		
			set_trans_blender(255,255,255,(235-(int)(fabs((-0.5+percent)*472)))*explosion[c].color.a/255 );

			if(percent>=0)
			{
				ellipsefill(buffer,explosion[c].pos.x,explosion[c].pos.y,(int)(1+percent*4),(int)(1),makecol(215,215,235));
				ellipsefill(buffer,explosion[c].pos.x,explosion[c].pos.y,(int)(2+percent*8),(int)(1+percent*1),makecol(210,210,225));
				ellipsefill(buffer,explosion[c].pos.x,explosion[c].pos.y,(int)(3+percent*15),(int)(1+percent*2),makecol(explosion[c].color.r,explosion[c].color.g,explosion[c].color.b));
			}
			draw_particles(c,percent);
	}
}

for(c=0;c<ENEMY_MAX_ON_SCREEN;c++)
if(enemy_dead[c].flag&ENEMY_DEAD_ACTIVE)
{
	


	if(enemy_dead[c].flag&ENEMY_DEAD_HIT_BY_PLAYER_1)
	{
				sprintf(msg, "%d",enemy_dead[c].points);
				textout_ex(buffer, font, msg,enemy_dead[c].pos.x, enemy_dead[c].pos.y, makecol(220,20,50),-1);
	}
	else
	{
				sprintf(msg, "%d",enemy_dead[c].points);
				textout_ex(buffer, font, msg, enemy_dead[c].pos.x, enemy_dead[c].pos.y, makecol(50,20,220),-1);
	}
}


if(player[0].flag&PLAYER_ACTIVE)
{				sprintf(msg, "%d",player[0].score);
				textout_ex(buffer, font, msg, 10, 24, makecol(220,20,50),-1);
}

if(player[1].flag&PLAYER_ACTIVE)
{				sprintf(msg, "%d",player[1].score);
				textout_right_ex(buffer, font, msg, SCREEN_W_USE, 24, makecol(50,20,220),-1);
}


for(c1=0;c1<player[0].lives;c1++)
{
if(player[0].flag&PLAYER_ACTIVE)
{
	set_trans_blender(120,220,90,128);
	draw_trans_sprite(buffer,datafile[player[0].frame.start].dat,c1*25+10,8);	
}

}

for(c1=0;c1<player[1].lives;c1++)
{
if(player[1].flag&PLAYER_ACTIVE)
{
	set_trans_blender(120,220,90,128);
	draw_trans_sprite(buffer,datafile[player[1].frame.start].dat,SCREEN_W_USE-c1*25-23,8);	
}

}

sprintf(msg, "CONTINUES %d",continues);
				textout_centre_ex(buffer, font, msg, SCREEN_W_USE/2, 0, makecol(242,170,38),-1);

if( ( (player[0].flag&PLAYER_LIVES_DONE) || (!(player[0].flag&PLAYER_ACTIVE)) ) && ( (player[1].flag&PLAYER_LIVES_DONE) || (!(player[1].flag&PLAYER_ACTIVE)) ) )
	{

	int show_continue_timer=0;

	if(player[0].continue_timer>player[1].continue_timer) show_continue_timer=player[0].continue_timer-timer;
	else
		show_continue_timer=player[1].continue_timer-timer;

	if( (show_continue_timer/10) >=0 && continues>0)
				{
				sprintf(msg, "CONTINUE %d",1+show_continue_timer/10);
				textout_centre_ex(buffer, font, msg, SCREEN_W_USE/2, 100, makecol(242,170,38),-1);
				}
	
	}


if(!(pause_flag&PAUSE_GAME))
if(timer < show_title_start_timer + show_title_length && level >=0 && level <4)
{
	float ratio_done=1-((timer-show_title_start_timer)/show_title_length);
	


	clear_to_color(buffer_title,makecol(255,0,255));


	

		drawing_mode(DRAW_MODE_TRANS,0,0,0);
		set_trans_blender(255,255,215,ratio_done*255);


	
	if(timer>=show_title_start_timer+show_title_delay)
	{
	sprintf(msg, "%s",show_title_text[level]);
	textout_centre_ex(buffer_title, font, msg,32, 16, makecol(180,(int)(140+(cos(DEG_2_RAD(timer*15))*100)),(int)(100+(sin(DEG_2_RAD(timer*15))*80))),-1);
	}

	


	

	masked_stretch_blit(buffer_title, buffer, 0,0,64,32, 0, 0, 320, 240);
if(level==0 )	rectfill(buffer,0,0,320,240,makecol(15,15,15));
else if(level==1) rectfill(buffer,0,0,320,240,makecol(255,35,35));
else	rectfill(buffer,0,0,320,240,makecol(255,255,215));
	solid_mode();
	


}

if(!(pause_flag&PAUSE_GAME))
if(level==4&&(307-(timer+200))>0)
{
	
	clear_to_color(buffer_title,makecol(255,0,255));


	solid_mode();
	
	
	sprintf(msg, "%.3f",(307-(timer+200))*0.1);
	textout_centre_ex(buffer_title, font, msg,32, 16, makecol(180,(int)(140+(cos(DEG_2_RAD(timer*15))*100)),(int)(100+(sin(DEG_2_RAD(timer*15))*80))),-1);
	

	

	masked_stretch_blit(buffer_title, buffer, 0,0,64,32, 0, -70, 320, 240-70);


}



if(pause_flag&PAUSE_GAME)
	{
	int do_select=rand()%5;
	drawing_mode(DRAW_MODE_TRANS,0,0,0);
	
	
	set_dodge_blender(115,215,65,225);
	
	
	
	clear_to_color(buffer_title,makecol(255,0,255));
	sprintf(msg, "PAUSED");
	textout_centre_ex(buffer_title, font, msg,32, 16, makecol(255,255,255),-1);
	masked_stretch_blit(buffer_title, buffer, 0,0,64,32, 0, 0, 320, 240);
	rectfill(buffer,0,0,320,240,makecol(64,64,20));

	solid_mode();

	}
	


}



check_level()
{
int c=0;
int enemies_on_screen=FALSE;

char buf[256];

if(level_flag&LEVEL_START)
{

	memset(&boss,0,sizeof(boss));

	memset(&boss_data,0,sizeof(boss_data));

	memset(&enemy,0,sizeof(enemy));
	
	memset(&enemy_call,0,sizeof(enemy_call));
	memset(&ship_data,0,sizeof(ship_data));

	
	level_flag-=LEVEL_START;
	next_ship_called=0;

	
	

	_fcloseall( );
	

	level++;

	if(level==0)
	{
		if( (f1=fopen( "level_1.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading level_1.csv", buf);

			return 12;
		}

		if( (f2=fopen( "char_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading char_test.txt", buf);

			return 12;
		}

		if( (f3=fopen( "boss_1.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_1.csv", buf);

			return 12;
		}

		if( (f4=fopen( "boss_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_test.txt", buf);

			return 12;
		}
	}

	if(level==1)
	{
		if( (f1=fopen( "level_2.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading level_2.csv", buf);

			return 12;
		}

		if( (f2=fopen( "char_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading char_test.txt", buf);

			return 12;
		}

		if( (f3=fopen( "boss_2.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_2.csv", buf);

			return 12;
		}

		if( (f4=fopen( "boss_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_test.txt", buf);

			return 12;
		}
	}

	if(level==2)
	{

		if( (f1=fopen( "level_3.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading level_3.csv", buf);

			return 12;
		}

		if( (f2=fopen( "char_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading char_test.txt", buf);

			return 12;
		}

		if( (f3=fopen( "boss_3.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_3.csv", buf);

			return 12;
		}

		if( (f4=fopen( "boss_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_test.txt", buf);

			return 12;
		}
	}

	if(level==3)
	{
		if( (f1=fopen( "level_4.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading level_4.csv", buf);

			return 12;
		}

		if( (f2=fopen( "char_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading char_test.txt", buf);

			return 12;
		}

		if( (f3=fopen( "boss_4.csv", "rt" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_4.csv", buf);

			return 12;
		}

		if( (f4=fopen( "boss_test.txt", "w+" )) == NULL )
		{
			set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
			allegro_message ("Error loading boss_test.txt", buf);

			return 12;
		}
	}

	if(level<4)
	{
	last_enemy_read=read_file();

	write_file();


	error_message=read_file_boss();

	write_file_boss();


	}

	timer=-200;
	
	
	player[0].shot_timer=timer+3;
	player[0].continue_timer=timer+player[0].continue_time_length;
	player[0].regen_timer=timer+player[0].regen_time_length;

	player[1].shot_timer=timer+3;
	player[1].continue_timer=timer+player[1].continue_time_length;
	player[1].regen_timer=timer+player[1].regen_time_length;

	show_title_start_timer=timer;

}


if(level<4)	
	if(timer>=level_timer[level].boss_start_preset)
	{		

		if(!(level_flag&LEVEL_ENEMIES_END))
		{
			for(c=0;c<ENEMY_MAX_ON_SCREEN;c++)
			{
				

				if(enemy[c].flag&ENEMY_DRAW)
				{
					enemies_on_screen=TRUE;
				}
			}

			if(enemies_on_screen==FALSE)
			{

				level_flag+=LEVEL_ENEMIES_END;
				level_show_boss_timer=timer+20;

				
					
					init_boss(0);
				
						
				
			}
		}



		if( (level_flag&LEVEL_ENEMIES_END) && timer>=level_show_boss_timer && (!(level_flag&LEVEL_BOSS_ENTER)) )
		{

			level_flag+=LEVEL_BOSS_ENTER;
			level_boss_intro_timer=timer+level_timer[level].boss_intro_preset;
		
				
		}

		if(level_flag&LEVEL_BOSS_ENTER && (!(level_flag&LEVEL_BOSS_LOADING_DONE)) &&timer>=level_boss_intro_timer)
		{
			level_flag+=LEVEL_BOSS_LOADING_DONE;

			play_midi(datafile_music[7].dat, TRUE);

		}


		if(level_flag&LEVEL_BOSS_ENTER&&boss[0].health<=0&&(!(boss[0].flag&ENEMY_ACTIVE)) )
		{


			
			
			if(timer>boss_dead[0].score_timer+50)
			{
				stop_midi();
				level_flag=0;
				level_flag=LEVEL_START;
			}
		}
		
			
	}
	
if(level==4)
{
	if(timer>111)
	{
		level_flag=0;
		level_flag=LEVEL_START;
	}
}

if( ( (player[0].flag&PLAYER_LIVES_DONE) || (!(player[0].flag&PLAYER_ACTIVE)) ) && ( (player[1].flag&PLAYER_LIVES_DONE) || (!(player[1].flag&PLAYER_ACTIVE)) ) )
	{

		int show_continue_timer=0;

		if(player[0].continue_timer>player[1].continue_timer) show_continue_timer=player[0].continue_timer-timer;
		else
		show_continue_timer=player[1].continue_timer-timer;

		if(!( ( (show_continue_timer/10) >=0 && continues>0) ))
		{
			show_ending();

		}
	}

	


if(level==5)
	{
		show_ending();
	
	}

return 0;


}

start_song()
{
	
						if(level==0&&(!(load_song_flag&LEVEL_1_SONG_LOADED)) )
						{
							load_song_flag+=LEVEL_1_SONG_LOADED;
							play_midi(datafile_music[2].dat, TRUE);

							
							
						}
						if(level==1&&(!(load_song_flag&LEVEL_2_SONG_LOADED)) )
						{
							load_song_flag+=LEVEL_2_SONG_LOADED;
							play_midi(datafile_music[3].dat, TRUE);
							
						
						}
						if(level==2&&(!(load_song_flag&LEVEL_3_SONG_LOADED)) )
						{
							load_song_flag+=LEVEL_3_SONG_LOADED;
							play_midi(datafile_music[5].dat, TRUE);
							
						
						}

						if(level==3&&(!(load_song_flag&LEVEL_4_SONG_LOADED)) )
						{
							load_song_flag+=LEVEL_4_SONG_LOADED;
							play_midi(datafile_music[6].dat, TRUE);
							
						
						}

						if(level==4&&(!(load_song_flag&LEVEL_5_SONG_LOADED)) )
						{
							load_song_flag+=LEVEL_5_SONG_LOADED;
							play_midi(datafile_music[10].dat, TRUE);
							
						
						}

}

sounds()
{
	int c;

	
	if(level!=4)
				if(timer>-190&&timer<-50)
				{
					

					if(!(start_sweep_flag))
					{
						start_sweep_flag=TRUE;
						do_sweep(1);
					}

					generate_wave(TRUE, 2,0,14000,3100,NOISE,0,300*2);
					
					generate_wave(TRUE, 4,200+(sin(DEG_2_RAD((int)(timer*0.9375)%360))*200),50,50,PWM,0.005,200*2);
					generate_wave(TRUE, 1,rand()%1000,50,3250,SQUARE,0.0025,300*2);
					generate_wave(TRUE, 12,0,500,3200,PWM,0.0005,1400*2+(sin(DEG_2_RAD((int)(timer*15)%360))*1400*2));
					generate_wave(TRUE, 18,0,500,3200,PWM,0.0005,600*2+(sin(DEG_2_RAD((int)(timer*15+180)%360))*600*2));
					generate_wave(TRUE, 24,0,500,3200,PWM,0.0005,600*2+(sin(DEG_2_RAD((int)(timer*15+180)%360))*600*2));
				}
				else
				{
					if(start_sweep_flag&&timer>0)
					{
					start_sweep_flag=FALSE;
					stop_sweep();
					}

					if(timer>-50&&timer<0)
					{
						for(c=0;c<42;c++)
							generate_wave(FALSE, c,0,500,2500,PWM,0,2000);

						 
					}
					if(timer>0&&timer<10)start_song();
				}


		if(level==4&&timer<-190) start_song();



 			if(timer<100||timer>400)	update_music();
}



RGB_MAP rgb_table;

/* lighting color mapping table */
COLOR_MAP light_table;

COLOR_MAP trans_table;

COLOR_MAP color_table;


void print_progress(int pos)
{
   /*prints the stars that show the progress of creating the color maps*/
   if ((pos & 3) == 3) {
      printf("*");
      fflush(stdout);
   }
}

int main(int argc, char *argv[])
{
 
 PALLETE pal;
 char buf[256];

 

 int sound =0;
 int c=0;
 int c2=0;
 int x=0;
 int y=0;

 

 
 
     /*This section installs allegro*/
     allegro_init();
     install_keyboard();
     install_mouse();
     install_timer();

     srand(time(NULL));    
 
	 /* I took this section of code from the 3d bouncing cubes example
    that comes with allegro*/
    /* color 0 = black */
   pal[0].r = pal[0].g = pal[0].b = 0;

   /* copy the desktop pallete */
   for (c=1; c<64; c++)
      pal[c] = desktop_pallete[c];

   /* make a red gradient */
   for (c=64; c<96; c++) {
      pal[c].r = (c-64)*2;
      pal[c].g = pal[c].b = 0;
   }

   /* make a green gradient */
   for (c=96; c<128; c++) {
      pal[c].g = (c-96)*2;
      pal[c].r = pal[c].b = 0;
   }

   /* set up a greyscale in the top half of the pallete */
   for (c=128; c<256; c++)
      pal[c].r = pal[c].g = pal[c].b = (c-128)/2;

   /* build rgb_map table */
   printf("Generating rgb_map table:\n");
   printf("<................................................................>\r<");
   create_rgb_table(&rgb_table, pal, print_progress);
   rgb_map = &rgb_table;
   printf("\n\n");

   /* build a lighting table */
   printf("Generating lighting table:\n");
   printf("<................................................................>\r<");
   create_light_table(&light_table, pal, 0, 0, 0, print_progress);
   color_map = &light_table;
   printf("\n");

  

 /*sets the color depth*/
  
   bpp=32;
   set_color_depth(bpp);
   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 1024, 768, 0, 0) != 0) {
      bpp=24;
      set_color_depth(bpp);
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 1024, 768, 0, 0) != 0) { 
		  bpp=16;
      set_color_depth(bpp);
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 1024, 768, 0, 0) != 0) {  
      

		 bpp=32;
   set_color_depth(bpp);
   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0) {
      bpp=24;
      set_color_depth(bpp);
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0) {
		  bpp=15;
      set_color_depth(bpp);
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0) { 
		  bpp=16;
      set_color_depth(bpp);
      if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, 640, 480, 0, 0) != 0) {  
      allegro_message("could not set_gfx_mode(): %s\n",allegro_error);
         return 1;
        }
      }
	 }
	  }
        }
      }
	 }

   /*sets the palette to how it is set by the pointer to pal*/
   set_pallete(pal);

   
    
   
replace_filename(buf, argv[0], "datafile.dat", sizeof(buf));
   datafile = load_datafile(buf);
   if (!datafile) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

replace_filename(buf, argv[0], "datafile_boss_0.dat", sizeof(buf));
   datafile_boss[0] = load_datafile(buf);
   if (!datafile_boss[0]) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

replace_filename(buf, argv[0], "datafile_boss_1.dat", sizeof(buf));
   datafile_boss[1] = load_datafile(buf);
   if (!datafile_boss[1]) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

replace_filename(buf, argv[0], "datafile_boss_2.dat", sizeof(buf));
   datafile_boss[2] = load_datafile(buf);
   if (!datafile_boss[2]) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

replace_filename(buf, argv[0], "datafile_boss_3.dat", sizeof(buf));
   datafile_boss[3] = load_datafile(buf);
   if (!datafile_boss[3]) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

replace_filename(buf, argv[0], "datafile_background.dat", sizeof(buf));
   datafile_background = load_datafile(buf);
   if (!datafile_background) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

   replace_filename(buf, argv[0], "datafile_music.dat", sizeof(buf));
   datafile_music = load_datafile(buf);
   if (!datafile_music) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
     allegro_message ("Error loading %s!\n\n", buf);
      return 12;
   }

   /* install a MIDI sound driver */
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
	   
		   if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL) !=0)
			   install_sound(DIGI_NONE, MIDI_NONE, NULL);
		
      
   }

   

   if(init_stream()==1)
   {
	   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
       allegro_message("Error creating audio stream!\n");
	   return 1;
   }
   
install_joystick(JOY_TYPE_AUTODETECT);
         
		 
     /*fps timer this function is called every millisecond to
     update the time boxes come out of the conveyor*/
    install_int(fps_proc, 1);

    /* sets the game speed to 100 frames per second*/
    install_int_ex(increment_speed_counter, BPS_TO_TIMER(100));
	install_int_ex(increment_anim_counter,BPS_TO_TIMER(30));
    /*locks timer variables explained in allegro manuals*/
    LOCK_VARIABLE(speed_counter);
    LOCK_FUNCTION(increment_speed_counter);

	LOCK_VARIABLE(anim_counter);
    LOCK_FUNCTION(increment_anim_counter);

    LOCK_VARIABLE(frame_count);
    LOCK_VARIABLE(fps);
   LOCK_FUNCTION(fps_proc);
   /*creates a buffer the same size as the screen*/
   buffer = create_bitmap (320,240);
   buffer_collision = create_bitmap (320,240);
   buffer_boss= create_bitmap(256,256);
   buffer_boss_scaled= create_bitmap(256,256);
   buffer_boss_show=create_bitmap(256,256);
   boss_ball= create_bitmap(20,20);
   buffer_title= create_bitmap(80,48);

	



   
 	  		
    /*sets the digital and midi volumes for the game*/
   set_volume(255, 70*2);
 
   


memset(&player,0,sizeof(player));
memset(&boss,0,sizeof(boss));
memset(&boss_dead,0,sizeof(boss_dead));
memset(&boss_data,0,sizeof(boss_data));

memset(&enemy,0,sizeof(enemy));
memset(&enemy_dead,0,sizeof(enemy_dead));
memset(&enemy_type,0,sizeof(enemy_type));
memset(&enemy_call,0,sizeof(enemy_call));
memset(&ship_data,0,sizeof(ship_data));

player[0].buffer=create_bitmap(40,32);
player[1].buffer=create_bitmap(40,32);   



player[0].pos.x=120;
player[0].pos.y=SCREEN_H_USE-50;


player[1].pos.x=200;
player[1].pos.y=SCREEN_H_USE-50;



player[0].frame.start=4;
player[1].frame.start=24;
for(c=0;c<2;c++)
{
	player[c].frame.pos=0;
	player[c].frame.total=1;
	player[c].frame.speed=1;
	player[c].frame.width=((BITMAP *)datafile[player[c].frame.start].dat)->w;
	player[c].frame.height=((BITMAP *)datafile[player[c].frame.start].dat)->h;
	player[c].start_lives=3;
	player[c].lives=player[c].start_lives;
	player[c].continue_time_length=100;
	player[c].regen_time_length=25;
}


player[0].key.up=KEY_W;
player[0].key.down=KEY_S;
player[0].key.left=KEY_A;
player[0].key.right=KEY_D;
player[0].key.fire=KEY_SPACE;
player[0].key.start=KEY_LSHIFT;



	player[0].joy.fire=0;
	player[0].joy.start=1;

player[1].key.up=KEY_UP;
player[1].key.down=KEY_DOWN;
player[1].key.left=KEY_LEFT;
player[1].key.right=KEY_RIGHT;
player[1].key.fire=KEY_RCONTROL;
player[1].key.start=KEY_RSHIFT;

player[1].joy.fire=0;
player[1].joy.start=1;



for(c=0;c<ENEMY_MAX_TYPE;c++)
{

	enemy_type[c].frame.start=0;
	enemy_type[c].frame.pos=0;
	enemy_type[c].frame.total=1;
	enemy_type[c].frame.speed=1;
	enemy_type[c].frame.angle=0;
	
	enemy[c].frame.width=((BITMAP *)datafile[enemy[c].frame.start].dat)->w;
	enemy[c].frame.height=((BITMAP *)datafile[enemy[c].frame.start].dat)->h;

	enemy_type[c].health_init=1;
	enemy_type[c].points=500;
	enemy_type[c].explosion=0;
}

	enemy_type[0].frame.start=0;
	enemy_type[0].frame.pos=0;
	enemy_type[0].frame.total=2;
	enemy_type[0].frame.speed=0.1;
	enemy_type[0].frame.width=((BITMAP *)datafile[enemy_type[0].frame.start].dat)->w;
	enemy_type[0].frame.height=((BITMAP *)datafile[enemy_type[0].frame.start].dat)->h;
	

	enemy_type[0].shot.angle=90;
	enemy_type[0].shot.speed=0.5;
	enemy_type[0].shot.delay=5;
	enemy_type[0].shot.image=5;
	enemy_type[0].shot.flag+=SHOT_AIM;

	enemy_type[1].frame.start=2;
	enemy_type[1].frame.pos=0;
	enemy_type[1].frame.total=2;
	enemy_type[1].frame.speed=0.1;
	enemy_type[1].frame.width=((BITMAP *)datafile[enemy_type[1].frame.start].dat)->w;
	enemy_type[1].frame.height=((BITMAP *)datafile[enemy_type[1].frame.start].dat)->h;
	
	enemy_type[1].health_init=2*3;
	enemy_type[1].points=1000;



	enemy_type[1].shot.angle=90;
	enemy_type[1].shot.speed=1.5;
	enemy_type[1].shot.delay=10;
	enemy_type[1].shot.image=10;

	enemy_type[1].explosion=4;
	


	enemy_type[2].frame.start=6;
	enemy_type[2].frame.pos=0;
	enemy_type[2].frame.total=2;
	enemy_type[2].frame.speed=0.6;
	enemy_type[2].frame.width=((BITMAP *)datafile[enemy_type[2].frame.start].dat)->w;
	enemy_type[2].frame.height=((BITMAP *)datafile[enemy_type[2].frame.start].dat)->h;
	
	enemy_type[2].health_init=1*3;
	enemy_type[2].points=1000;
	enemy_type[2].explosion=3;


	enemy_type[2].shot.angle=90;
	enemy_type[2].shot.speed=1.5;
	enemy_type[2].shot.delay=10;
	enemy_type[2].shot.image=10;
	

	enemy_type[3].frame.start=8;
	enemy_type[3].frame.pos=0;
	enemy_type[3].frame.total=2;
	enemy_type[3].frame.speed=0.6;
	enemy_type[3].frame.width=((BITMAP *)datafile[enemy_type[3].frame.start].dat)->w;
	enemy_type[3].frame.height=((BITMAP *)datafile[enemy_type[3].frame.start].dat)->h;
	
	enemy_type[3].health_init=10*3;
	enemy_type[3].points=5000;

	enemy_type[3].explosion=1;


	enemy_type[3].shot.angle=90;
	enemy_type[3].shot.speed=0.2;
	enemy_type[3].shot.delay=10;
	enemy_type[3].shot.image=11;
	enemy_type[3].shot.flag+=SHOT_AIM;

	enemy_type[4].frame.start=12;
	enemy_type[4].frame.pos=0;
	enemy_type[4].frame.total=2;
	enemy_type[4].frame.speed=0.6;
	enemy_type[4].frame.width=((BITMAP *)datafile[enemy_type[4].frame.start].dat)->w;
	enemy_type[4].frame.height=((BITMAP *)datafile[enemy_type[4].frame.start].dat)->h;
	
	enemy_type[4].health_init=2*3;
	enemy_type[4].points=500;

	enemy_type[4].explosion=3;


	enemy_type[4].shot.angle=90;
	enemy_type[4].shot.speed=1.5;
	enemy_type[4].shot.delay=10;
	enemy_type[4].shot.image=14;

	enemy_type[5].frame.start=15;
	enemy_type[5].frame.pos=0;
	enemy_type[5].frame.total=1;
	enemy_type[5].frame.speed=0.6;
	enemy_type[5].frame.width=((BITMAP *)datafile[enemy_type[5].frame.start].dat)->w;
	enemy_type[5].frame.height=((BITMAP *)datafile[enemy_type[5].frame.start].dat)->h;
	
	enemy_type[5].health_init=2*3;
	enemy_type[5].points=1000;

	enemy_type[5].explosion=3;


	enemy_type[5].shot.angle=90;
	enemy_type[5].shot.speed=0.5;
	enemy_type[5].shot.delay=20;
	enemy_type[5].shot.image=5;
	enemy_type[5].shot.flag+=SHOT_AIM;

	enemy_type[6].frame.start=16;
	enemy_type[6].frame.pos=0;
	enemy_type[6].frame.total=1;
	enemy_type[6].frame.speed=0.6;
	enemy_type[6].frame.width=((BITMAP *)datafile[enemy_type[6].frame.start].dat)->w;
	enemy_type[6].frame.height=((BITMAP *)datafile[enemy_type[6].frame.start].dat)->h;
	
	enemy_type[6].health_init=15*3;
	enemy_type[6].points=7500;


	enemy_type[6].shot.angle=90;
	enemy_type[6].shot.speed=0.25;
	enemy_type[6].shot.delay=20;
	enemy_type[6].shot.image=5;
	enemy_type[6].shot.flag+=SHOT_MULTI_5;

	enemy_type[6].explosion=1;



	enemy_type[7].frame.start=17;
	enemy_type[7].frame.pos=0;
	enemy_type[7].frame.total=2;
	enemy_type[7].frame.speed=0.6;
	enemy_type[7].frame.width=((BITMAP *)datafile[enemy_type[7].frame.start].dat)->w;
	enemy_type[7].frame.height=((BITMAP *)datafile[enemy_type[7].frame.start].dat)->h;
	
	enemy_type[7].health_init=1*3;
	enemy_type[7].points=500;
	enemy_type[7].flag+=ENEMY_ROTATE_SLOW;


	enemy_type[7].shot.angle=90;
	enemy_type[7].shot.speed=1.5;
	enemy_type[7].shot.delay=20;
	enemy_type[7].shot.image=5;



	enemy_type[8].frame.start=19;
	enemy_type[8].frame.pos=0;
	enemy_type[8].frame.total=2;
	enemy_type[8].frame.speed=0.6;
	enemy_type[8].frame.width=((BITMAP *)datafile[enemy_type[8].frame.start].dat)->w;
	enemy_type[8].frame.height=((BITMAP *)datafile[enemy_type[8].frame.start].dat)->h;
	
	enemy_type[8].health_init=10*3;
	enemy_type[8].points=4500;
	enemy_type[8].flag+=ENEMY_ROTATE_SLOW;
	enemy_type[8].shot.flag+=SHOT_SPIN;


	enemy_type[8].shot.angle=90;
	enemy_type[8].shot.speed=0.1;
	enemy_type[8].shot.delay=4;
	enemy_type[8].shot.image=5;

	enemy_type[8].explosion=1;



	enemy_type[9].frame.start=21;
	enemy_type[9].frame.pos=0;
	enemy_type[9].frame.total=1;
	enemy_type[9].frame.speed=0.6;
	enemy_type[9].frame.width=((BITMAP *)datafile[enemy_type[9].frame.start].dat)->w;
	enemy_type[9].frame.height=((BITMAP *)datafile[enemy_type[9].frame.start].dat)->h;
	
	enemy_type[9].health_init=4*3;
	enemy_type[9].points=3500;


	enemy_type[9].shot.angle=90;
	enemy_type[9].shot.speed=0.5;
	enemy_type[9].shot.delay=2;
	enemy_type[9].shot.image=5;
	enemy_type[9].shot.flag+=SHOT_AIM;
	enemy_type[9].shot.flag+=SHOT_MULTI_2;

	enemy_type[9].explosion=4;
	

	enemy_type[10].frame.start=22;
	enemy_type[10].frame.pos=0;
	enemy_type[10].frame.total=2;
	enemy_type[10].frame.speed=0.5;
	enemy_type[10].frame.width=((BITMAP *)datafile[enemy_type[10].frame.start].dat)->w;
	enemy_type[10].frame.height=((BITMAP *)datafile[enemy_type[10].frame.start].dat)->h;
	
	enemy_type[10].health_init=2*3;
	enemy_type[10].points=500;


	enemy_type[10].shot.angle=90;
	enemy_type[10].shot.speed=1.5;
	enemy_type[10].shot.delay=20;
	enemy_type[10].shot.image=5;

	enemy_type[10].explosion=3;


	enemy_type[11].frame.start=25;
	enemy_type[11].frame.pos=0;
	enemy_type[11].frame.total=2;
	enemy_type[11].frame.speed=0.5;
	enemy_type[11].frame.width=((BITMAP *)datafile[enemy_type[11].frame.start].dat)->w;
	enemy_type[11].frame.height=((BITMAP *)datafile[enemy_type[11].frame.start].dat)->h;
	
	enemy_type[11].health_init=1*3;
	enemy_type[11].points=500;


	enemy_type[11].shot.angle=90;
	enemy_type[11].shot.speed=1.5;
	enemy_type[11].shot.delay=20;
	enemy_type[11].shot.image=5;

	enemy_type[11].flag+=ENEMY_FOLLOW_PLAYER;

	enemy_type[11].explosion=4;

	explosion_type[0].duration=4;
	explosion_type[0].start_size=3;
	explosion_type[0].final_size=8;
	explosion_type[0].color.r=255;
	explosion_type[0].color.g=196;
	explosion_type[0].color.b=160;
	explosion_type[0].color.a=255;

	explosion_type[1].duration=7;
	explosion_type[1].start_size=3;
	explosion_type[1].final_size=15;
	explosion_type[1].color.r=155;
	explosion_type[1].color.g=196;
	explosion_type[1].color.b=255;
	explosion_type[1].color.a=255;

	explosion_type[2].duration=50;
	explosion_type[2].start_size=20;
	explosion_type[2].final_size=150;
	explosion_type[2].color.r=255;
	explosion_type[2].color.g=225;
	explosion_type[2].color.b=255;
	explosion_type[2].color.a=255;

	explosion_type[3].duration=1;
	explosion_type[3].start_size=1;
	explosion_type[3].final_size=3;
	explosion_type[3].color.r=255;
	explosion_type[3].color.g=235;
	explosion_type[3].color.b=255;
	explosion_type[3].color.a=255;

	explosion_type[4].duration=2;
	explosion_type[4].start_size=3;
	explosion_type[4].final_size=10;
	explosion_type[4].color.r=175;
	explosion_type[4].color.g=255;
	explosion_type[4].color.b=175;
	explosion_type[4].color.a=255;
	
	explosion_type[5].duration=25;
	explosion_type[5].start_size=1;
	explosion_type[5].final_size=60;
	explosion_type[5].color.r=185;
	explosion_type[5].color.g=255;
	explosion_type[5].color.b=185;
	explosion_type[5].color.a=50;

	

while(milli<1000)
{
for(c=0;c<42;c++)
generate_wave(FALSE, c,0,500,2500,PWM,0.02/(c*3+1),2000);
}

title_screen();







clear(buffer_collision);
clear_to_color(buffer_boss,makecol(255,0,255));
clear_to_color(buffer_boss_scaled,makecol(255,0,255));
clear_to_color(buffer_boss_show,makecol(255,0,255));
clear_to_color(boss_ball,makecol(255,0,255));

circlefill(boss_ball,10, 10, 10, makecol(255,255,255));

for(x=0;x<SQUARE_NUM_X+1;x++)
for(y=0;y<SQUARE_NUM_Y+1;y++)
{

	bp.points[x][y].x=x*SQUARE_X_SIZE;
	bp.points[x][y].y=y*SQUARE_Y_SIZE;

}

for(c=0;c<2;c++)	
for(x=0;x<SQUARE_NUM_X;x++)
for(y=0;y<SQUARE_NUM_Y;y++)
{
	int c_test=0;


bp.square[x][y].v[0].x=bp.points[x][y].x;
bp.square[x][y].v[0].y=bp.points[x][y].y;
bp.square[x][y].v[0].z=0;
bp.square[x][y].v[0].u=bp.points[x][y].x;
bp.square[x][y].v[0].v=bp.points[x][y].y;
bp.square[x][y].v[0].c=c_test;


bp.square[x][y].v[1].x=bp.points[x][y].x;
bp.square[x][y].v[1].y=bp.points[x][y+1].y;
bp.square[x][y].v[1].z=0;
bp.square[x][y].v[1].u=bp.points[x][y].x;
bp.square[x][y].v[1].v=bp.points[x][y+1].y;
bp.square[x][y].v[1].c=c_test;

bp.square[x][y].v[2].x=bp.points[x+1][y].x;
bp.square[x][y].v[2].y=bp.points[x][y+1].y;
bp.square[x][y].v[2].z=0;
bp.square[x][y].v[2].u=bp.points[x+1][y].x;
bp.square[x][y].v[2].v=bp.points[x][y+1].y;
bp.square[x][y].v[2].c=c_test;

bp.square[x][y].v[3].x=bp.points[x+1][y].x;
bp.square[x][y].v[3].y=bp.points[x][y].y;
bp.square[x][y].v[3].z=0;
bp.square[x][y].v[3].u=bp.points[x+1][y].x;
bp.square[x][y].v[3].v=bp.points[x][y].y;
bp.square[x][y].v[3].c=c_test;

}


level_flag=LEVEL_START;



   /*This is the main game loop*/
file_load_failed=check_level();

    while ((!(key[KEY_ESC]))&&(!(game_flag&GAME_EXIT)) )
    {
                /*this while statement keeps the game at a constant speed*/
            while (speed_counter > 0)
            {
				if(!(pause_flag&PAUSE_GAME))
				{
					

				sounds();
				

				

                input();   /*this function checks for user input*/

				
				

				if (file_load_failed==12) break;
				file_load_failed=check_level();
				if (file_load_failed==12) break;
				
				
				
				if(level_flag&LEVEL_BOSS_ENTER)
					{
						if(level==0||level==1||level==3) update_boss_play_0_1_3();
						if(level==2) update_boss_play_2();
					}
					else update_normal_play();
				}

				else
				{
					paused();
				}
			
                
          speed_counter--; /*The speed counter is subtracted every scan that the
                           speed counter is greater than zero and added by the
                           bps function so that when the speed is subtracted
                           more than the bps function adds the while statement
                           will end and display the graphics*/
          
          
            }


while(anim_counter > 0)
			{
				update_anim();
				anim_counter--;
			}
			
		

			if(file_load_failed==12)break;
             /*This function will draw the background and buffer*/
             display();
             
             /*draws the buffer to the screen after short delay so things
			 that look wrong are not displayed first scan*/
             

			 if(time_left_title<5) clear_to_color(buffer,makecol(0,0,0));
			 masked_stretch_blit(buffer, screen, 0, 0,
                          320, 240,
                          0, 0, SCREEN_W, SCREEN_H);
             
             /*clears the buffer*/
             clear_to_color(buffer,makecol(0,0,0));
			 clear_to_color(buffer_boss,makecol(255,0,255));
			 

             
			 
	}
stop_midi();
stop_stream();
unload_datafile(datafile);
unload_datafile(datafile_background);
unload_datafile(datafile_music);


for(c=0;c<4;c++)
unload_datafile(datafile_boss[c]);


destroy_bitmap(buffer);
destroy_bitmap(buffer_boss);
destroy_bitmap(buffer_boss_scaled);
destroy_bitmap(buffer_boss_show);
destroy_bitmap(player[0].buffer);
destroy_bitmap(player[1].buffer);
destroy_bitmap(boss_ball);


_fcloseall( );

return 0;
}

END_OF_MAIN();
