/***************************************************************************/
/*                                                                         */
/*                             A C T I O N . C P P                         */
/*                             Class Definition                            */
/*                                                                         */
/*     Content : Class Action                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : September 30th, 2012                                */
/*                                                                         */
/*          This file contains the action class used to keep track of      */
/*     combat actions inside the database.                                 */
/*                                                                         */
/***************************************************************************/

#include <grpsys.h>
#include <grpstd.h>
#include <grpsql.h>
#include <grpdbobj.h>
#include <grpinterface.h>

/*-------------------------------------------------------------------------*/
/*-                         Constructor / destructor                      -*/
/*-------------------------------------------------------------------------*/

Action::Action ( void )
{
   strcpy (p_tablename, "action");
   p_actor_type = -1;
   p_actorID = -1;
   p_initiative = -1;
   p_commandID = -1;
   p_targetID = -1;
   p_target_type = -1;
   p_value = -1;
}

Action::Action ( Character &character )
{
   load_character (character);

   strcpy (p_tablename, "action");
}

Action::Action ( Monster &monster )
{
   load_monster (monster);

   strcpy (p_tablename, "action");
}

Action::~Action ( void )
{

}


/*-------------------------------------------------------------------------*/
/*-                         Methods                                       -*/
/*-------------------------------------------------------------------------*/

void Action::load_character ( Character &character)
{
   CClass tmpclass;

   tmpclass.SQLselect ( character.FKcclass() );

   p_actor_type = Action_ACTOR_TYPE_CHARACTER;
   p_actorID = character.primary_key();
   //?? need to use another routine that accumulate all modifiers
   p_initiative = roll_xpypd20( tmpclass.INIT(), character.INTmodifier() );
   p_commandID = -1;
   p_targetID = -1;
   p_target_type = -1;
   p_value = -1;
}

void Action::load_monster ( Monster &monster )
{
   p_actor_type = Action_ACTOR_TYPE_ENNEMY;
   p_actorID = monster.primary_key();
   p_initiative = roll_xpypd20( monster.init() , 0 );
   p_commandID = -1;
   p_targetID = -1;
   p_target_type = -1;
   p_value = -1;

}

int Action::input ( int commandID )
{
   int retval = Action_INPUT_RETVAL_NONE;
   p_commandID = commandID;

   if ( commandID >= 0 && commandID <= CmdProc_COMMANDLIST_SIZE )
   {
      switch ( p_actor_type )
      {
         case Action_ACTOR_TYPE_CHARACTER:
            //printf ("input retval A(%d)\n", retval );
            retval = CmdProc_COMMANDLIST [ commandID ] . proc_input ( *this );
         break;
         case Action_ACTOR_TYPE_ENNEMY:
            retval = CmdProc_COMMANDLIST [ commandID ] . proc_AIinput ( *this );
         break;
      }
      //printf ("input retval B(%d)\n", retval );

   }

   //printf ("input retval C(%d)\n", retval );

   return ( retval );

}

int Action::resolve ( void )
{
   int retval = Action_INPUT_RETVAL_NONE;
   Character tmpactor_char;
   Character tmptarget_char;
   Monster tmpactor_mons;
   Monster tmptarget_mons;
   Opponent *actor;
   Opponent *target;

   if ( p_commandID != -1 )
   {

      switch ( p_actor_type )
      {
      case Action_ACTOR_TYPE_CHARACTER :

         tmpactor_char.SQLselect ( p_actorID );
         actor = &tmpactor_char;

         switch ( p_target_type )
         {
            case Action_TARGET_TYPE_ONEENEMY:
               tmptarget_mons.SQLselect ( p_targetID );
               target = &tmptarget_mons;
            break;
            case Action_TARGET_TYPE_ONECHARACTER:
               tmptarget_char.SQLselect ( p_targetID );
               target = &tmptarget_char;
            break;
         }

      break;
      case Action_ACTOR_TYPE_ENNEMY :

         tmpactor_mons.SQLselect ( p_actorID );
         actor = &tmpactor_mons;

         switch ( p_target_type )
         {
            case Action_TARGET_TYPE_ONEENEMY:
               tmptarget_mons.SQLselect ( p_targetID );
               target = &tmptarget_mons;
            break;
            case Action_TARGET_TYPE_ONECHARACTER:
               tmptarget_char.SQLselect ( p_targetID );
               target = &tmptarget_char;
            break;

         }
      break;
      }


      //float tmpbefore = clock();
      if ( actor->body() == Character_BODY_ALIVE )
         retval = CmdProc_COMMANDLIST [ p_commandID ] . proc_resolve ( *this, actor, target );
      else
         retval = Action_RESOLVE_RETVAL_CANCEL;
      //float tmpafter = clock();
      //tmpafter = ( tmpafter - tmpbefore )  / CLOCKS_PER_SEC;
      //printf ("Resolve proc Time: %f\n", tmpafter);

   }

   return ( retval );
}

void Action::command_str ( char* tmpstr )
{
   //char tmpstr [100] = "";
   //char target

   //impossible to return a tmpstring because considered a local variable.
   //Else would have to use a copy of a string in reference to be modified and return.

   if ( p_commandID != -1)
   {

      sprintf ( tmpstr, "%s", CmdProc_COMMANDLIST [ p_commandID ].name );
   }

   //return ( tmpstr );
}

/*-------------------------------------------------------------------------*/
/*-                         Virtual Methods                               -*/
/*-------------------------------------------------------------------------*/

 void Action::sql_to_obj (void)
 {
   p_primary_key = SQLcolumn_int (0);
   p_actor_type  = SQLcolumn_int (1);
   p_actorID  = SQLcolumn_int (2);
   p_commandID = SQLcolumn_int (3);
   p_initiative = SQLcolumn_int (4);
   p_target_type = SQLcolumn_int (5);
   p_targetID = SQLcolumn_int (6);
   p_value = SQLcolumn_int (7);
 }

 void Action::template_sql_to_obj (void)
 {
    // not used since require function pointers which cannot be located in database.
    // command ID is used instead to point to the commandlist table.
 }

 void Action::obj_to_sqlupdate (void)
 {
    sprintf ( p_querystr, "actor_type=%d, actorid=%d, commandid=%d, initiative=%d, target_type=%d, targetid=%d, value=%d",
    p_actor_type,
    p_actorID,
    p_commandID,
    p_initiative,
    p_target_type,
    p_targetID,
    p_value );

 }

 void Action::obj_to_sqlinsert (void)
 {
    sprintf ( p_querystr, "%d, %d, %d, %d, %d, %d, %d",
    p_actor_type,
    p_actorID,
    p_commandID,
    p_initiative,
    p_target_type,
    p_targetID,
    p_value );
 }



