/*************************************************************************/
/*                                                                       */
/*                              S P E L L . H                            */
/*                             Class Definition                          */
/*                                                                       */
/*     Content: Spell Class                                              */
/*     Programmer: Eric Pietrocupo                                       */
/*     Creation Date: October 31st, 2012                                 */
/*                                                                       */
/*          This class is used to manage spells castable by characters   */
/*     and monsters.                                                     */
/*                                                                       */
/*************************************************************************/

#ifndef SPELL_H_INCLUDED
#define SPELL_H_INCLUDED

#define Spell_WORD_STRLEN 13
#define Spell_NAME_STRLEN 21
#define Spell_NB_PARAM 3


// ------------------------- Constants -------------------------------

#define Spell_CASTABLE_CAMP      1
#defnie Spell_CASTABLE_COMBAT    2
#define Spell_CASTABLE_CAMP-COMBAT  3
#define Spell_CASTABLE_MAZE      4
#define Spell_CASTABLE_CHEST     8
#define Spell_CASTABLE_NPC       16

#define Spell_MONSTER_NO_USE      0
#define Spell_MONSTER_CAN_USE     1

// ------------------------- Class Definition ------------------------------


class Spell : public SQLobject
{
   // --- Properties ---

   private: char *p_word [ Spell_WORD_STRLEN ]; // arcane name
   private: char *p_name [ Spell_NAME_STRLEN]; // spell name
   private: int p_progress; // spell progress required to know the spell
   private: int p_mp_cost; // Mana Required to cast the spell
   private: int p_target; // Nb of people affected by the spell
   private: unsigned int p_castable; // indicate situation when it can be cast
   private: bool p_monster; // true if can be cast by monsters
   private: int p_proc_id; // Procedure to use to resolve spell (probably a procedure set since need AI proc too)
   private: int p_param [Spell_NB_PARAM]; // 1st param of the procedure
   private: unsigned int p_school; // Indicate to which school of magic it belongs to. 1 spell requires all school.
   private: int p_initiative; // Initiative modifier to add to the action.

   // --- Constructor & destructor ---

   public: Spell ( void );
   public: virtual ~Spell ( void );

   // --- Property Methods ---

   public: char *word ( void ) { return ( p_word ); }
   public: char name ( void ) { return ( p_name ); }
   public: int progress ( void ) { return ( p_progress ); }
   public: int mp_cost ( void ) { return ( p_mp_cost ); }
   public: int target ( void ) { return ( p_target ); }
   public: unsigned int castable ( void ) { return ( p_castable ); }
   public: bool monster ( void ) { return ( p_monster ); }
   public: int proc_id ( void ) { return ( p_proc_id ); }
   public: int param ( int param_id ) { return ( p_param [ param_id ] ); }
   public: unsigned int school ( void ) { return ( p_school ); }
   public: int initiative ( void ) { return ( p_initiative ); }

};

#endif // SPELL_H_INCLUDED
