/***************************************************************************/
/*                                                                         */
/*                             A C T I O N . H                             */
/*                             Class Definition                            */
/*                                                                         */
/*     Content : Class Action                                              */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : September 30th, 2012                                */
/*                                                                         */
/*          This file contains the action class used to keep track of      */
/*     combat actions inside the database.                                 */
/*                                                                         */
/***************************************************************************/

#ifndef ACTION_H_INCLUDED
#define ACTION_H_INCLUDED


/*-------------------------------------------------------------------------*/
/*-                            Constants                                  -*/
/*-------------------------------------------------------------------------*/

// --- target type

#define Action_TARGET_TYPE_ONEENEMY   0 // target_ID = table monster ID
#define Action_TARGET_TYPE_GROUPENEMY 1 // target_ID = 1 = front, 2 = back
#define Action_TARGET_TYPE_ALLENEMY   2 // target_ID is ignored
#define Action_TARGET_TYPE_ONECHARACTER  3 // target_ID = PK of character
#define Action_TARGET_TYPE_GROUPCHARACTER 4 // target_ID = 1 = front, 2 = back
#define Action_TARGET_TYPE_ALLCHARACTER  5 // target_ID is ignored.
#define Action_TARGET_TYPE_EVERYBODY  6 // target_ID is ignored.
// note: some actions will assume certain types because there are no other possibilities.


// --- actor type ---

#define Action_ACTOR_TYPE_UNKNOWN   0 // has no effect when resolved.
#define Action_ACTOR_TYPE_CHARACTER 1
#define Action_ACTOR_TYPE_ENNEMY    2

// --- input return value ---

#define Action_INPUT_RETVAL_NONE     0
#define Action_INPUT_RETVAL_PREVIOUS 1
#define Action_INPUT_RETVAL_RETURN   2
#define Action_INPUT_RETVAL_CANCEL   3
#define Action_INPUT_RETVAL_RUN      4

#define Action_RESOLVE_RETVAL_NONE     0
#define Action_RESOLVE_RETVAL_CANCEL   1 // used when a dead actor cannot perform his command.
//#define Action_RESOLVE_RETVAL_SKIPPED  1 //for now, show message showing target is out

/*-------------------------------------------------------------------------*/
/*-                         Class Defintion                               -*/
/*-------------------------------------------------------------------------*/

class Action : public SQLobject
{
   //note: instant actions used outside combat are input and resolved now instead of beign s

  // --- Properties ---

   private: int p_actor_type; // Character/ ennemy or nobody
   private: int p_actorID; // ID number of the person who made the action
   private: int p_commandID; // command ID
   private: int p_initiative; // initiative value + d20 roll
   private: int p_target_type; // target ennemy
   private: int p_targetID; //
   private: int p_value; // value used differently according to the command type

  // --- constructor & destructor ---

   public: Action ( void );
   public: Action ( Character &character );
   public: Action ( Monster &monster );
   public: virtual ~Action ( void );

  // --- Property Methods ---

  // following values have no set method because they are set in constructor and input function.
  public: int actor_type ( void ) { return ( p_actor_type); }
  public: int actorID ( void ) { return ( p_actorID ); }
  public: int commandID ( void ) { return ( p_commandID ); }
  public: int initiative ( void ) { return ( p_initiative ); }

  public: int target_type ( void ) { return ( p_target_type); }
  public: void target_type ( int type ) { p_target_type = type; }
  public: int targetID ( void ) { return ( p_targetID ); }
  public: void targetID ( int ID ) { p_targetID = ID; }
  public: int value ( void ) { return ( p_value ); }
  public: void value ( int val ) { p_value = val; }

  // --- Methods ---

  public: void load_character ( Character &character );
  public: void load_monster ( Monster &monster );
  public: int input ( int commandID ); // called the procedure to handle command input.
                                        // Return false if command cancelled
  public: int resolve ( void ); // call the resolution procedure.
  public: void command_str ( char* tmpstr ); // pass a temporary strong to create the command as a string.


  // --- Virtual Methods ---

  public: void virtual sql_to_obj (void);
  public: void virtual template_sql_to_obj (void);
  public: void virtual obj_to_sqlupdate (void);
  public: void virtual obj_to_sqlinsert (void);

};

#endif // ACTION_H_INCLUDED
