/***************************************************************************/
/*                                                                         */
/*                            M O N S T E R . H                            */
/*                                                                         */
/*                         Class Header Definition                         */
/*                                                                         */
/*     Content : Class MOnster                                             */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : April 26, 2002                                      */
/*                                                                         */
/*          This is some sort of template class for monsters. It does not  */
/*     keep track of current HP and status. This will not be stored in the */
/*     class since that information is not kept in the database            */
/*                                                                         */
/***************************************************************************/


#ifndef MONSTER_H_INCLUDED
#define MONSTER_H_INCLUDED


/*-------------------------------------------------------------------------*/
/*                              Constants                                  */
/*-------------------------------------------------------------------------*/

#define Monster_NAME_STRLEN 33

// Extra Reward Values

#define Monster_REWARD_GOLD_0    0  // 00000000
#define Monster_REWARD_GOLD_D6   1  // 00000001
#define Monster_REWARD_GOLD_D12  2  // 00000010
#define Monster_REWARD_GOLD_D20  3  // 00000011
#define Monster_REWARD_EXP_X2    4  // 00000100
#define Monster_REWARD_EXP_X4    8  // 00001000
#define Monster_REWARD_EXP_X8    12 // 00001100




/*-------------------------------------------------------------------------*/
/*                              Global Variables                           */
/*-------------------------------------------------------------------------*/


//extern int Party_FORMATION_POSITION [ 3 ] [ 6 ] [ 6 ];
extern int Monster_POSITION [ 8 ] [ 8 ];

/*-------------------------------------------------------------------------*/
/*-                         Class Definition                              -*/
/*-------------------------------------------------------------------------*/

class Monster : public Opponent
{

   // --- Properties ---

	private: char p_name	[ Monster_NAME_STRLEN ]; // name of the creature
	private: int p_level; // level
	private: int p_size; // inflence hit die and DMGY
	private: int p_power; // influence MP and MDMGY
	private: int p_wsp; // influence nb of attack
	private: int p_msp_min; // both influence creature spell list
	private: int p_msp_max; //
	private: unsigned int p_magic_type; // type of magic performed
	private: unsigned int p_resistance;
	private: unsigned int p_weakness;
	private: int p_AD;
	private: int p_MD;
	private: int p_PS;
	private: int p_MS;
	private: int p_CS; // final combat skill, no mental or physical
	private: int p_DR;
	private: int p_init;
	private: int p_range; // for basic attack
	private: int p_clumsiness; // for basic attack
	private: int p_target; // for basic attack
	private: unsigned int p_special; // for basic attack
	private: unsigned int p_property; // for basic attack
	private: unsigned int p_action; // special actions allowed like run, call for help, parry, protect, etc.
	private: int p_special_attack_1; // 40%
	private: int p_special_attack_2; // 30%
	private: int p_special_attack_3; // 20%
	private: int p_special_attack_4; // 10%
	private: unsigned int p_extra_reward; // bitfield: extra reward given by defeating creature
	private: int p_pictureID;
	private: int p_position; // a value from 1 to 5 that determine the order of the monster. The value range has no importance
   private: int p_current_HP;
   private: int p_max_HP;
   private: int p_current_MP;
   private: int p_max_MP;
   //private: unsigned int p_health;
   private: int p_body;
   private: int p_location;
   private: int p_rank; // temporaty rank of the monster in the party during battles
   //private: int p_position;
   private: int p_FKcategory;
   private: bool p_identified; // set to true if monsters are identified
   private: char p_uname [ Monster_NAME_STRLEN ];
   //private: char p_nameletter;

   private: static bool p_recompile_ranks;

   // --- Constructor ---

   public: Monster ( void );
   public: virtual ~Monster ( void );

   // --- property method ---

   // there is no set method because I don't think there will be a reason to do that.

   public: char *name ( void );
   public: void name ( const char *str );
	public: int level ( void );
	public: int size ( void );
	public: int power ( void );
	public: int wsp ( void );
	public: int msp_min ( void );
	public: int msp_max ( void );
	public: unsigned int magic_type ( void );
	public: unsigned int resistance ( void );
	public: unsigned int weakness ( void );
	public: int AD ( void );
	public: int MD ( void );
	public: int PS ( void );
	public: int MS ( void );
	public: int CS ( void );
	public: int DR ( void );
	public: int init ( void );
	public: int range ( void );
	public: int clumsiness ( void );
	public: int target ( void );
	public: unsigned int special ( void );
	public: unsigned int property ( void );
	public: unsigned int action ( void );
	public: int special_attack_1 ( void );
	public: int special_attack_2 ( void );
	public: int special_attack_3 ( void );
	public: int special_attack_4 ( void );
	public: unsigned int extra_reward ( void );
	public: int pictureID ( void );
	//public: int like_front ( void );
	public: int current_HP ( void ) { return ( p_current_HP ); }
   public: int max_HP ( void ) { return ( p_max_HP ); }
   public: int current_MP ( void ) { return ( p_current_MP ); }
   public: int max_MP ( void ) { return ( p_max_MP ); }
   //public: unsigned int health ( void ) { return ( p_health ); }
   public: int body ( void ) { return ( p_body ); }
   public: int location ( void ) { return ( p_location ); }
   public: int position ( void ) { return ( p_position ); }
   //public: unsigned int health ( unsigned int value ) { return ( p_health ); }
   public: void body ( int value ) { p_body = value; p_recompile_ranks = true; }
   public: void location ( int value ) { p_location = value; }
   public: void position ( int value ) { p_position = value; }
   public: int rank ( void ) { return ( p_rank ); }
   public: void rank ( int value ) { p_rank = value; }
   public: int FKcategory ( void ) { return ( p_FKcategory ); }
   public: void FKcategory ( int value ) { p_FKcategory = value; }
   public: bool identified ( void ) { return (p_identified ); }
   public: void identified ( bool value ) { p_identified = value; }
   public: char* uname ( void ) { return ( p_uname ); }
   public: void uname ( const char* str ) { strncpy ( p_uname, str, Monster_NAME_STRLEN ); }

   // --- methods ---

   public: void recover_HP ( int value );
   public: void recover_MP ( int value );
   public: void recover_soul ( int value ) {} // monsters has no soul
   public: void lose_HP ( int value );
   public: void lose_MP ( int value );
   public: void lose_soul ( int value ) {} // monsters has no soul

   public: void roll_maxHPMP ( void );

   public: static void compile_ranks ( void );
   public: static void force_recompile_ranks ( void );

   public: char* displayname ( void ); //return name to display during battle.

   // --- Virtual Methods ---

   public: void virtual sql_to_obj (void);
   public: void virtual template_sql_to_obj ( void);
   public: void virtual obj_to_sqlupdate (void);
   public: void virtual obj_to_sqlinsert (void);

   public: void compile_stat ( void );

};



#endif // MONSTER_H_INCLUDED
