/***************************************************************************/
/*                                                                         */
/*                             C M D P R O C . H                           */
/*                             Procedures                                  */
/*                                                                         */
/*     Content : Command Procedures                                        */
/*     Programmer : Eric Pietrocupo                                        */
/*     Starting Date : September 30th, 2012                                */
/*                                                                         */
/*          This file contains the procedures required to resolve the      */
/*     character and monster commands. THere is a procedure for the        */
/*     assignment and the resolution.                                      */
/*                                                                         */
/***************************************************************************/

#include <grpsys.h>
#include <grpstd.h>
#include <grpsql.h>
#include <grpdbobj.h>
#include <grpinterface.h>
#include <grpengine.h>

#include <wdatproc.h>


/* Reminder
// --- target type

#define Action_TARGET_TYPE_ONEENEMY   0 // target_ID = table monster ID
#define Action_TARGET_TYPE_GROUPENEMY 1 // target_ID = 1 = front, 2 = back
#define Action_TARGET_TYPE_ALLENEMY   2 // target_ID is ignored
#define Action_TARGET_TYPE_ONEFRIEND  3 // target_ID = PK of character
#define Action_TARGET_TYPE_GROUPFRIEND 4 // target_ID = 1 = front, 2 = back
#define Action_TARGET_TYPE_ALLFRIEND  5 // target_ID is ignored.
#define Action_TARGET_TYPE_EVERYBODY  6 // target_ID is ignored.
// note: some actions will assume certain types because there are no other possibilities.

// --- actor type ---

#define Action_ACTOR_TYPE_UNKNOWN   0 // has no effect when resolved.
#define Action_ACTOR_TYPE_CHARACTER 1
#define Action_ACTOR_TYPE_ENNEMY    2

// --- input return value ---

#define Action_INPUT_RETVAL_NONE     0
#define Action_INPUT_RETVAL_PREVIOUS 1
#define Action_INPUT_RETVAL_RETURN   2
#define Action_INPUT_RETVAL_CANCEL   3
#define Action_INPUT_RETVAL_RUN      4

#define Action_RESOLVE_RETVAL_NONE   0
*/

/*-------------------------------------------------------------------------*/
/*-                            Prototypes                                 -*/
/*-------------------------------------------------------------------------*/

int CmdProc_input_zap ( Action &action )
{
   int answer;
   int retval = Action_INPUT_RETVAL_NONE;
   Menu mnu_monster ("Choose a target");

   mnu_monster.add_query ("name","monster","WHERE body=0 ORDER BY position");

   WinMenu wmnu_monster ( mnu_monster, 0, 156, false, false, true );

   blit_mazebuffer();
   combat.draw_enemy();
   answer = Window::show_all();

   if ( answer != -1)
   {
      action.targetID ( answer );
      action.target_type ( Action_TARGET_TYPE_ONEENEMY );
      //action.SQLupdate();
      //printf ("Cmdproc: input targetID=%d\n", answer);
   }
   else
   {

      retval =  Action_INPUT_RETVAL_CANCEL;

   }

   return ( retval );
}
int CmdProc_AIinput_zap ( Action &action )
{

}
int CmdProc_resolve_zap ( Action &action, Opponent *actor, Opponent *target  )
{
   int retval;
   //static char tmpactorname [ 40 ];
   //static char tmptargetname [ 40 ];


   if (target->body() == Character_BODY_ALIVE )
   {

      //float tmpfirst = clock();
      //float tmpnow;
      //actor.displayname ( &tmpactorname );
      //actor.displayname ( &tmptargetname );

      system_log.writef ("%s Zap %s", actor->displayname(), target->displayname() );
         //tmpnow = clock();
         //tmpnow = ( tmpnow - tmpfirst )  / CLOCKS_PER_SEC;
         //printf ("Resolve Syslog Time: %f\n", tmpnow);

      target->body (Character_BODY_DEAD);
         //tmpnow = clock();
         //tmpnow = ( tmpnow - tmpfirst )  / CLOCKS_PER_SEC;
         //printf ("Resolve Set body Time: %f\n", tmpnow);

      system_log.writef ("%s is destroyed", target->displayname() );
         //tmpnow = clock();
         //tmpnow = ( tmpnow - tmpfirst )  / CLOCKS_PER_SEC;
         //printf ("Resolve Syslog2 Time: %f\n", tmpnow);

      target->SQLupdate();
         //tmpnow = clock();
         //tmpnow = ( tmpnow - tmpfirst )  / CLOCKS_PER_SEC;
         //printf ("Resolve Update Time: %f\n", tmpnow);


   }
   else
   {
      system_log.writef ("%s's target is out", actor->displayname() );
   }


   return ( Action_RESOLVE_RETVAL_NONE );
}

int CmdProc_input_fight ( Action &action )
{
   Character tmpchar;
   Item tmpitem;
   Monster tmpmonster;
   int nb_monster = 0;
   int max_range = 0;
   int max_rank = 0;
   char tmpstr [ 100 ];
   int answer;
   int retval;
   int inputretval = Action_INPUT_RETVAL_NONE;

   tmpchar.SQLselect ( action.actorID() );

// get attack range of the character.
   retval = tmpitem.SQLpreparef( "WHERE loctype=%d AND lockey=%d AND type=%d", Item_LOCATION_CHARACTER, action.actorID(), Item_TYPE_WEAPON );

   if ( retval == SQLITE_OK)
   {
      retval = tmpitem.SQLstep();

      while ( retval == SQLITE_ROW)
      {
         if ( tmpitem.range() > max_range)
            max_range = tmpitem.range();

         retval = tmpitem.SQLstep();
      }
   }
   else
      tmpitem.SQLerrormsg();

   tmpitem.SQLfinalize();

   // ----- calculate maximum range -----

   switch ( tmpchar.rank())
   {
      case Party_FRONT:
         max_rank = max_range;
      break;
      case Party_BACK:
         max_rank = -1 + max_range;
      break;
   }

   // ----- Select targettable monster -----


   Menu mnu_monster ("Select a target in range");

   retval = tmpmonster.SQLpreparef ("WHERE rank <= %d AND body=0 ORDER BY position", max_rank );

   if ( retval == SQLITE_OK)
   {
      retval = tmpmonster.SQLstep();

      while ( retval == SQLITE_ROW)
      {
         mnu_monster.add_item ( tmpmonster.primary_key(), tmpmonster.displayname() );
         retval = tmpmonster.SQLstep();
      }
   }
   else
      tmpmonster.SQLerrormsg();

   tmpmonster.SQLfinalize();

   //need to do manually if want fakename
   //mnu_monster.add_query ( "name", "monster", tmpstr );

   WinMenu wmnu_monster ( mnu_monster, 0, 156, false, false, true );

   blit_mazebuffer();
   combat.draw_enemy();
   answer = Window::show_all();

   if ( answer != -1)
   {
      action.targetID ( answer );
      action.target_type ( Action_TARGET_TYPE_ONEENEMY );
   }
   else
      inputretval = Action_INPUT_RETVAL_CANCEL;

   return ( inputretval );

}
int CmdProc_AIinput_fight ( Action &action )
{
   Monster tmpmonster;
   Character tmpchar;
   int max_range = 0;
   int max_rank = 0;
   int retval;
   int return_value = Action_INPUT_RETVAL_NONE;

   tmpmonster.SQLselect ( action.actorID());
   max_range = tmpmonster.range();

   switch ( tmpmonster.rank())
   {
      case Party_FRONT:
         max_rank = max_range;
      break;
      case Party_BACK:
         max_rank = -1 + max_range;
      break;
   }

   retval = tmpchar.SQLpreparef ( "WHERE rank <= %d and body=0 ORDER BY random()", max_rank);
   //tmpchar.SQLerrormsg();

   if ( retval == SQLITE_OK )
   {
      retval = tmpchar.SQLstep();
      //printf ("tmpchar: %d\n", tmpchar.name());

      if ( retval == SQLITE_ROW )
      {
         action.targetID ( tmpchar.primary_key() );
         action.target_type ( Action_TARGET_TYPE_ONECHARACTER );
      }
      else
         return_value = Action_INPUT_RETVAL_CANCEL;
   }
   else
      printf ("CmdProc: AIinput_fight: Error: Target character could not be selected\n");

   tmpchar.SQLfinalize ();

   return ( return_value );
}

int CmdProc_resolve_fight ( Action &action, Opponent *actor, Opponent *target  )
{
   int nb_attack;
   int i;
   char tmpstr;
   int attackdamage = 0;
   int totaldamage = 0;
   int finalattackdamage = 0;
   int attackroll = 0;
   int dr_roll = 0;
   int nb_attack_hit;
   int multihitpenalty = 0;
   bool attacksuccessful = false;
   int resolve_value = Action_RESOLVE_RETVAL_NONE;

   system_log.writef ("%s attacks %s", actor->displayname(), target->displayname() );

   if (target->body() == Character_BODY_ALIVE )
   {

      actor->compile_stat();
      target->compile_stat();

      // ----- calculate number of attacks ----

      if ( actor->flatstat( FLAT_CLUMSINESS ) != 0 )
         nb_attack = actor->flatstat( FLAT_WS ) / actor->flatstat( FLAT_CLUMSINESS );

      nb_attack++; // Minimum of 1 attack per round.

      nb_attack_hit = 0;
      for ( i = 0; i < nb_attack; i++)
      {
         attackdamage = 0;
         attackroll = 0;
         dr_roll = 0;

         // ----- Make combat rolls for each attack -----

         attacksuccessful = false;
         attackroll = dice ( 20 );


         //to do: Critical hit / miss

         if ( ( actor->flatstat( FLAT_CS) + attackroll - multihitpenalty ) > target->d20stat ( D20STAT_AD) + 10 )
            attacksuccessful = true;

         if ( attackroll >= 19 ) // roll of 19+ automatically hit, so always 10% chance to hit.
            attacksuccessful = true;

         if ( attackroll <=2 ) //automatic Failure.
            attacksuccessful = false;

         if ( attacksuccessful == true )
         {
            if ( config.get (Config_DETAIL_COMBAT_ROLL) == Config_YES)
               system_log.writef ("Attackroll: Dice=%d + CS %d - MH %d <> AD %d + 10 -> SUCCESS", attackroll, actor->flatstat( FLAT_CS), multihitpenalty, target->d20stat ( D20STAT_AD) );


            nb_attack_hit++;

            // ----- Calculate damage of attack -----

            attackdamage = roll_xdypz ( 1 , actor->xyzstat ( XYZSTAT_DMG, XYZMOD_Y), actor->xyzstat ( XYZSTAT_DMG ) );

            if ( attackroll == 20 ) // critical hit
               attackdamage *= 2;

            // ----- Apply Damage resistance -----

            dr_roll = dice (20);

            finalattackdamage = attackdamage;

            if ( dr_roll <= target->d20stat (D20STAT_DR) || dr_roll <=2 )
               finalattackdamage /= 2;

            if ( dr_roll == 1 ) // critical success
               finalattackdamage /= 2;

            if ( attackdamage == 0)
               finalattackdamage = 1;

            if ( config.get (Config_DETAIL_COMBAT_ROLL) == Config_YES)
               system_log.writef ("Atk Dmg: 1 d%d + %d = %d, Dmg Resist.: DR=%d, roll=%d -> %d Dmg"
                                 , actor->xyzstat ( XYZSTAT_DMG, XYZMOD_Y)
                                 , actor->xyzstat ( XYZSTAT_DMG )
                                 , attackdamage
                                 , target->d20stat (D20STAT_DR)
                                 , dr_roll
                                 , finalattackdamage );

            // ----- Add up the damage of successfull attacks -----

            totaldamage += finalattackdamage;

            // multi hit penalty increased if attack successful
            // disabled since too strong
            //multihitpenalty += actor->flatstat ( FLAT_MULTIHIT );

         }
         else
         {
            if ( config.get (Config_DETAIL_COMBAT_ROLL) == Config_YES)
               system_log.writef ("Attackroll: Dice=%d + CS %d - MH %d <> AD %d + 10 -> FAIL", attackroll, actor->flatstat( FLAT_CS), multihitpenalty, target->d20stat ( D20STAT_AD) );

         }


      }

      if ( nb_attack_hit > 0 )
      {
         target->lose_HP ( totaldamage );
         target->SQLupdate();

         system_log.writef ( "%s made %d attacks, hit %d times for %d damage", actor->displayname(), nb_attack, nb_attack_hit, totaldamage );

         if ( target->body () != Character_BODY_ALIVE )
            system_log.writef ( "%s is killed", target->displayname() );
      }
      else
         system_log.writef ( "%s made %d attacks that missed it's target.", actor->displayname(), nb_attack );

   }
   else
   {
      //system_log.writef ("%s's target is out", actor->name() );
      resolve_value = Action_RESOLVE_RETVAL_CANCEL;
   }

   return ( resolve_value );

}
/*int CmdProc_input_parry ( Action &action )
{

}
int CmdProc_AIinput_parry ( Action &action )
{

}*/
int CmdProc_resolve_parry ( Action &action, Opponent *actor, Opponent *target  )
{
   system_log.writef ("%s parry (not Implemented)", actor->displayname() );
}
int CmdProc_input_protect ( Action &action )
{

}
int CmdProc_AIinput_protect ( Action &action )
{

}
int CmdProc_resolve_protect ( Action &action, Opponent *actor, Opponent *target  )
{
system_log.writef ("%s Protect (not Implemented)", actor->displayname() );
}
int CmdProc_input_run ( Action &action )
{
   return ( Action_INPUT_RETVAL_RUN );
}
int CmdProc_AIinput_run ( Action &action )
{

}
int CmdProc_resolve_run ( Action &action, Opponent *actor, Opponent *target  )
{
   // do nothing
}
int CmdProc_input_arcane ( Action &action )
{

}
int CmdProc_AIinput_arcane ( Action &action )
{

}
int CmdProc_resolve_arcane ( Action &action, Opponent *actor, Opponent *target  )
{
   system_log.writef ("%s Cast Arcane Spells (not Implemented)", actor->displayname() );
}
int CmdProc_input_divine ( Action &action )
{

}
int CmdProc_AIinput_divine ( Action &action )
{

}
int CmdProc_resolve_divine ( Action &action, Opponent *actor, Opponent *target  )
{
   system_log.writef ("%s Cast Divine Spells (not Implemented)", actor->displayname() );
}
int CmdProc_input_alchemy ( Action &action )
{

}
int CmdProc_AIinput_alchemy ( Action &action )
{

}
int CmdProc_resolve_alchemy ( Action &action, Opponent *actor, Opponent *target  )
{
   system_log.writef ("%s Cast Alchemy Spells (not Implemented)", actor->displayname() );
}
int CmdProc_input_psionic ( Action &action )
{

}
int CmdProc_AIinput_psionic ( Action &action )
{

}
int CmdProc_resolve_psionic ( Action &action, Opponent *actor, Opponent *target  )
{
   system_log.writef ("%s Cast Psionic Spells (not Implemented)", actor->displayname() );
}
int CmdProc_input_use_item ( Action &action )
{

}
int CmdProc_AIinput_use_item ( Action &action )
{

}
int CmdProc_resolve_use_item ( Action &action, Opponent *actor, Opponent *target  )
{
   system_log.writef ("%s use item (not Implemented)", actor->displayname() );
}
/*int CmdProc_input_call_help ( Action &action )
{

}
int CmdProc_AIinput_call_help ( Action &action )
{

}*/
int CmdProc_resolve_call_help ( Action &action, Opponent *actor, Opponent *target  )
{
      system_log.writef ("%s Call for help (not Implemented)", actor->displayname() );
}
/*int CmdProc_input_equip ( Action &action )
{

}
int CmdProc_AIinput_equip ( Action &action )
{

}*/
int CmdProc_resolve_equip ( Action &action, Opponent *actor, Opponent *target  )
{

   int i;
   bool asked_for_item = false;
   int error;
   int answer;
   char tmpstr [100];
   Character tmpchar;
   Item tmpitem;
   int nb_hand = 0;
   bool cursed [ 9 ]; // mark which item type is cursed.
   int innerloop;
   int j;

   if ( action.actor_type() == Action_ACTOR_TYPE_CHARACTER )
   // ennemies cannot equip stuff
   // not implemented in action since equip is the only action that does that for now.
   {

      for ( i = 0; i < 8; i++)
         cursed [ i ]  = false;


      tmpchar.SQLselect ( action.actorID() );

      sprintf ( tmpstr, "UPDATE item SET loctype=%d, lockey=%d WHERE loctype=%d AND lockey=%d AND NOT cursed=1", Item_LOCATION_PARTY, party.primary_key(), Item_LOCATION_CHARACTER, tmpchar.primary_key() );

      SQLexec ( tmpstr );

      error = tmpitem.SQLpreparef ( "WHERE loctype=%d AND lockey=%d AND cursed=1", Item_LOCATION_CHARACTER, tmpchar.primary_key() );

      if ( error == SQLITE_OK )
      {
         error = tmpitem.SQLstep();

         while ( error == SQLITE_ROW)
         {
            cursed [ tmpitem.type()] = true;
            nb_hand += tmpitem.hand();
            error = tmpitem.SQLstep();

         }
      }

      tmpitem.SQLfinalize();

   /*SQLerrormsg();
   printf ( "PartyPK=%d, characterPK=%d\r\n", party.primary_key(), character_key);


   // tmpcode to fix databse bug
   sprintf ( tmpstr, "UPDATE item SET loctype=2, lockey=1 WHERE lockey=0" );

   SQLexec ( tmpstr );
SQLerrormsg();*/

      for ( i = 1 ; i <= Item_TYPE_EQUIPABLE; i++ )
      {

         if ( i == Item_TYPE_EXPANDABLE )
            innerloop = 4;
         else
            innerloop = 1;

         for ( j = 0; j < innerloop; j++)
         {
            sprintf ( tmpstr, "Select a %s to equip", STR_ITM_TYPE [ i ] );

            List lst_item ( tmpstr, 11, true);
            lst_item.header ("Name");

            if ( cursed [ i ] == false)
            {
               error = tmpitem.SQLpreparef ( "WHERE type=%d AND loctype=%d AND lockey=%d ORDER BY category",  i, Item_LOCATION_PARTY, party.primary_key() );
               //tmpitem.SQLerrormsg();

               if ( error == SQLITE_OK )
               {
            //printf("pass 1\r\n");
                  error = tmpitem.SQLstep();

                  while ( error == SQLITE_ROW)
                  {
                     if ( tmpchar.is_equipable ( tmpitem.primary_key() ) == true
                        && ( tmpitem.hand() + nb_hand <=2 ) )
                        lst_item.add_itemf ( tmpitem.primary_key(), "%-40s", tmpitem.vname());
            //printf ("character=%s, item=%s, is equipable=%d\r\n", tmpchar.name(), tmpitem.name(), tmpchar.is_equipable ( tmpitem.primary_key()) );
                     error = tmpitem.SQLstep();
                  }
               }
               tmpitem.SQLfinalize();

               if ( lst_item.nb_item() > 0 )
               {
                  lst_item.add_item ( -1, "None");
                  asked_for_item = true;

                  WinData<int> wdat_item ( WDatProc_inspect_item, lst_item.answer(0), WDatProc_POSITION_INSPECT_ITEM );

                  WinList wlst_item ( lst_item, 20, 50 );
                  answer = 0;

                  while ( lst_item.selected() == false)
                  {
                     if ( lst_item.answer() == -1)
                        wdat_item.hide();
                     else
                     {
                        wdat_item.key ( lst_item.answer());
                        wdat_item.unhide();
                     }
                     Window::refresh_all();
                     answer = Window::show_all();

                  //printf("Answer2=%d\r\n", answer2);
                  }

                  if ( answer != -1 )
                  {
                     //printf ( "before: loctype=%d, lockey=%d\r\n", tmpitem.location_type(), tmpitem.location_key());
                     tmpitem.SQLselect ( answer );

                     tmpitem.location ( Item_LOCATION_CHARACTER, tmpchar.primary_key()  );
                     nb_hand += tmpitem.hand();
                     tmpitem.SQLupdate();


                     if ( tmpitem.cursed() == true )
                     {
                        system_log.writef ("Camp: %s equiped %s ( CURSED )", tmpchar.name(), tmpitem.name() );

                        WinMessage wmsg_cursed ("C U R S E D");
                        Window::show_all();
                     }

                     system_log.writef ("Camp: %s equiped %s", tmpchar.name(), tmpitem.name() );


                     //tmpitem.SQLselect( tmpitem.primary_key());
                     //printf ( "before: loctype=%d, lockey=%d\r\n", tmpitem.location_type(), tmpitem.location_key());

                     lst_item.selected( false);
                  }
                  else
                     innerloop = 0;

               }
            }
            else
            {
               sprintf ( tmpstr, "%s is cursed and cannot be replaced", STR_ITM_TYPE [ i ] );
               WinMessage wmsg_error ( tmpstr );
               Window::show_all();
            }

         }


      }

      if ( asked_for_item == false)
      {
         WinMessage wmsg_notavailable ("There is no items your character can equip.");
         Window::show_all();
      }

   }
}
/*int CmdProc_input_read ( Action &action )
{

}
int CmdProc_AIinput_read ( Action &action )
{

}*/
int CmdProc_resolve_read ( Action &action, Opponent *actor, Opponent *target )
{

}

int CmdProc_do_nothing ( Action &action)
{

}

int CmdProc_resolve_nothing ( Action &action, Opponent *actor, Opponent *target )
{

}


int CmdProc_input_previous ( Action &action )
{
   return ( Action_INPUT_RETVAL_PREVIOUS );
}
/*int CmdProc_AIinput_previous ( Action &action )
{

}
int CmdProc_resolve_previous ( Action &action )
{

}*/

int CmdProc_input_return ( Action &action )
{
   return ( Action_INPUT_RETVAL_RETURN );
}
/*int CmdProc_AIinput_return ( Action &action )
{

}
int CmdProc_resolve_return ( Action &action )
{

}*/


/*-------------------------------------------------------------------------*/
/*-                     Global Variables                                  -*/
/*-------------------------------------------------------------------------*/

extern const s_CmdProc_command CmdProc_COMMANDLIST [ CmdProc_COMMANDLIST_SIZE ] =
{
   //name, requirement, value, monster action, available, input, AIinput, resolve
   // 0-15
   { "Zap "                , CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_zap, CmdProc_AIinput_zap, CmdProc_resolve_zap  },
   { "Fight "              , CmdProc_REQUIREMENT_REACH, 0, 0, CmdProc_AVAILABLE_COMBAT, CmdProc_input_fight, CmdProc_AIinput_fight, CmdProc_resolve_fight  },
   { "Parry "              , CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_COMBAT, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_parry  },
   { "Protect "            , CmdProc_REQUIREMENT_NOTALONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_protect, CmdProc_AIinput_protect, CmdProc_resolve_protect  }, // disabled, maybe become a class skill
   { "Run "                , CmdProc_REQUIREMENT_FIRST, 0, 0, CmdProc_AVAILABLE_COMBAT, CmdProc_input_run, CmdProc_AIinput_run, CmdProc_resolve_run  },
   { "Arcane Spell "       , CmdProc_REQUIREMENT_SPELL, CClass_MAGICSCHOOL_ARCANE, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_arcane, CmdProc_AIinput_arcane, CmdProc_resolve_arcane  },
   { "Divine Spell "       , CmdProc_REQUIREMENT_SPELL, CClass_MAGICSCHOOL_DIVINE, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_divine, CmdProc_AIinput_divine, CmdProc_resolve_divine  },
   { "Alchemy Spell "      , CmdProc_REQUIREMENT_SPELL, CClass_MAGICSCHOOL_ALCHEMY, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_alchemy, CmdProc_AIinput_alchemy, CmdProc_resolve_alchemy  },
   { "Psionic Spell "      , CmdProc_REQUIREMENT_SPELL, CClass_MAGICSCHOOL_PSIONIC, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_psionic, CmdProc_AIinput_psionic, CmdProc_resolve_psionic  },
   { "Use Item "           , CmdProc_REQUIREMENT_ITEM, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_input_use_item, CmdProc_AIinput_use_item, CmdProc_resolve_use_item  },
   { "Call for Help "      , CmdProc_REQUIREMENT_NOTFULL, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_call_help  },
   { "Equip "              , CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_CAMP, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_equip  },
   { "Read "               , CmdProc_REQUIREMENT_SPELL, CClass_MAGICSCHOOL_ALL, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_read  },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   // 16 - 31
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   // 32-47
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   // 48 -63
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "?Unknown?           ", CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_NEVER, CmdProc_do_nothing, CmdProc_do_nothing, CmdProc_resolve_nothing },
   { "Previous "           , CmdProc_REQUIREMENT_NOTFIRST, 0, 0, CmdProc_AVAILABLE_COMBAT, CmdProc_input_previous, CmdProc_do_nothing, CmdProc_resolve_nothing  },
   { "Return "             , CmdProc_REQUIREMENT_NONE, 0, 0, CmdProc_AVAILABLE_CAMP, CmdProc_input_return, CmdProc_do_nothing, CmdProc_resolve_nothing  }

};
