/*
 *	+-----------------------------------------------------+
 *	|,888. ,8888 ,8  8. 88888,                      88    |
 *	|88 88 88    88  88 88  88 ,888.  88888, .8888, 88888,|
 *	|88    8888   8888  88888, 88  88 88  88 88  88 88  88|
 *	|88 88 88    88  88 88  88 88888` 88  88 88     88  88|
 *	|88 88 88    88  88 88  88 88     88  88 88  88 88  88|
 *	|`8888 88    `8  8` 88888` `8888  88  88 `8888` 88  88|
 *	+-----------------------------------------------------+
 *
 *      main gfxbench source file.
 */


/*///////////////////////////////////////////////////////////////////////
//
//	GFXBENCH v2.2
//	Optimal graphics card and processor benchmark
//	by Rafal Szyja
//  rafalszyja@poczta.onet.pl
//  http://rafalszyja.republika.pl
//
////////////////////////////////////////////////////////////////////////*/

#include <allegro.h>
#include <io.h>
#include <stdio.h>
#include <load_gif.h>

char *version="2.2";

volatile int timing;
long int pixels;
int opcja=1;
int cpu_caps_old;

BITMAP *logo;
PALETTE pal;

int test(void);
int mainscr(void);
int mainmenu(void);
int info(void);
void end_text(void);

int __logo;



/// smaller size stuff

#ifdef __DJGPP__
BEGIN_COLOR_DEPTH_LIST
COLOR_DEPTH_8
END_COLOR_DEPTH_LIST

BEGIN_GFX_DRIVER_LIST
GFX_DRIVER_VGA
END_GFX_DRIVER_LIST

BEGIN_DIGI_DRIVER_LIST
END_DIGI_DRIVER_LIST

BEGIN_MIDI_DRIVER_LIST
END_MIDI_DRIVER_LIST

BEGIN_JOYSTICK_DRIVER_LIST
END_JOYSTICK_DRIVER_LIST
#endif

///

void _timing()
{
	timing++;
}
END_OF_FUNCTION(_timing);


void _menutimer()
{
	if ((os_type==OSTYPE_WIN3)|(os_type==OSTYPE_WIN95)|(os_type==OSTYPE_WIN98)|(os_type==OSTYPE_WINNT)|(os_type==OSTYPE_WINME)|(os_type==OSTYPE_WINXP)|(os_type==OSTYPE_WIN2000))
		{
#ifdef __DJGPP__
			textout_centre(screen,font,"!!! windows detected !!!",160,190,makecol(rand()%255,55,55));
#elif __WIN32__
			textout_centre(screen,font,"windows version gives false results",160,190,makecol(rand()%255,55,55));
#endif
		}

		if ((mouse_b & 1)||(key[KEY_DOWN]))
			{
				opcja++;
			}

		if ((key[KEY_UP]))
			{
				opcja--;
			}

		if(opcja>3) {opcja=1;}
		if(opcja<1) {opcja=3;}

			text_mode(0);
			textout_centre(screen,font,"Test",160,30,makecol(0,128,255));
			textout_centre(screen,font,"Info",160,40,makecol(0,128,255));
			textout_centre(screen,font,"Exit",160,50,makecol(0,128,255));
			text_mode(-1);

		if(opcja==1)
		{
			textout_centre(screen,font,"Test",160,30,makecol(255,255,255));
		} else if (opcja==2)
		{
			textout_centre(screen,font,"Info",160,40,makecol(255,255,255));
		} else
		{
			textout_centre(screen,font,"Exit",160,50,makecol(255,255,255));
		}

}
END_OF_FUNCTION(_menutimer);


int main(int argc,char *argv[])
{
	allegro_init();
	install_timer();
	install_keyboard();
	install_mouse();
	install_timer();

	set_color_depth(8);
#ifdef __DJGPP__
	if(set_gfx_mode(GFX_VGA,320,200,0,0)!=0)
#else
	if(set_gfx_mode(GFX_AUTODETECT,320,200,0,0)!=0)
#endif
	{
		set_gfx_mode(GFX_TEXT,0,0,0,0);
		printf("Can't init mode VGA 13h (standard 320x200x8)\nCheck your hardware!\n\npress any key\n\n");
		readkey();
		return 2;
	}

	set_palette(pal);
	text_mode(-1);
	clear_to_color(screen,makecol(0,0,0));

	if(argc!=1)
	{

		set_palette(desktop_palette);
		__logo=1;

	}

	if(mainscr()!=0) {end_text(); return 2;}

	cpu_caps_old=cpu_capabilities;

	mainmenu();

	fade_out(5);

	end_text();

	return 1;

}
END_OF_MAIN();

void end_text(void)
{
	set_gfx_mode(GFX_TEXT,0,0,0,0);

	allegro_exit();


	printf("%s%s%s%s%s%s%s%s",
	"+-----------------------------------------------------+\n",
	"|,888. ,8888 ,8  8. 88888,                      88    |\n",
	"|88 88 88    88  88 88  88 ,888.  88888, .8888, 88888,|\n",
	"|88    8888   8888  88888, 88  88 88  88 88  88 88  88|\n",
	"|88 88 88    88  88 88  88 88888` 88  88 88     88  88|\n",
	"|88 88 88    88  88 88  88 88     88  88 88  88 88  88|\n",
	"|`8888 88    `8  8` 88888` `8888  88  88 `8888` 88  88|\n",
	"+-----------------------------------------------------+\n\n");



		printf("GFXBench v%s [built %s %s] \n\n",version,__TIME__,__DATE__);
		printf("http://rafalszyja.republika.pl\n");
		printf("rafalszyja@poczta.onet.pl\n\n");
		printf("+Software used:\n");
		printf("|DJGPP and GCC compiler	www.delorie.com/djgpp\n");
		printf("|Allegro v%s   www.alleg.sf.net\n",ALLEGRO_VERSION_STR);
		printf("|LibGIF (thanks to G.A.Hankiewicz & Paul Bartrum)\n");
		printf("|Adobe Photoshop 5\n");
		printf("|Textpad 4.5\n");

	return;


}

void drawmenu(void)
{
		clear_to_color(screen,makecol(0,0,0));

		textout_right_ex(screen,font,version,310,2,makecol(255,255,255),-1);
		textout_centre(screen,font,"GFXBENCH",161,2,makecol(0,128,0));
		textout_centre(screen,font,"GFXBENCH",159,2,makecol(0,128,0));
		textout_centre(screen,font,"GFXBENCH",161,0,makecol(0,128,0));
		textout_centre(screen,font,"GFXBENCH",159,0,makecol(0,128,0));

		textout_centre(screen,font,"GFXBENCH",160,1,makecol(0,255,0));



		textout_centre(screen,font,"Great perfomance testing utility",160,12,makecol(128,0,0));
		textout_centre(screen,font,"Great perfomance testing utility",162,12,makecol(128,0,0));
		textout_centre(screen,font,"Great perfomance testing utility",160,14,makecol(128,0,0));
		textout_centre(screen,font,"Great perfomance testing utility",162,14,makecol(128,0,0));

		textout_centre(screen,font,"Great perfomance testing utility",161,13,makecol(255,0,0));

	cpu_capabilities=cpu_caps_old;

	if ((cpu_capabilities & CPU_MMX) == CPU_MMX) {textout_centre(screen,font,"MMX",30,70,makecol(255,255,255));}
	else {textout_centre(screen,font,"MMX",30,70,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_SSE) == CPU_SSE) {textout_centre(screen,font,"SSE",80,70,makecol(255,255,255));}
	else {textout_centre(screen,font,"SSE",80,70,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_FPU) == CPU_FPU) {textout_centre(screen,font,"FPU",120,70,makecol(255,255,255));}
	else {textout_centre(screen,font,"FPU",120,70,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_3DNOW) == CPU_3DNOW) {textout_centre(screen,font,"3DNOW",160,70,makecol(255,255,255));}
	else {textout_centre(screen,font,"3DNOW",160,70,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_MMXPLUS) == CPU_MMXPLUS) {textout_centre(screen,font,"MMX+",210,70,makecol(255,255,255));}
	else {textout_centre(screen,font,"MMX+",210,70,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_SSE2) == CPU_SSE2) {textout_centre(screen,font,"SSE2",250,70,makecol(255,255,255));}
	else {textout_centre(screen,font,"SSE2",250,70,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_ENH3DNOW) == CPU_ENH3DNOW) {textout_centre(screen,font,"Enh3dNOW",50,80,makecol(255,255,255));}
	else {textout_centre(screen,font,"Enh3DNOW",50,80,makecol(64,64,64));}
	if ((cpu_capabilities & CPU_CMOV) == CPU_CMOV) {textout_centre(screen,font,"CMOV",110,80,makecol(255,255,255));}
	else {textout_centre(screen,font,"CMOV",110,80,makecol(64,64,64));}

	textout_centre(screen,font,"Created by Rafal Szyja",159, 99,makecol(128,128,128));
	textout_centre(screen,font,"Created by Rafal Szyja",161,101,makecol(128,128,128));
	textout_centre(screen,font,"Created by Rafal Szyja",159,101,makecol(128,128,128));
	textout_centre(screen,font,"Created by Rafal Szyja",161, 99,makecol(128,128,128));
	textout_centre(screen,font,"Created by Rafal Szyja",160,100,makecol(255,255,255));


	cpu_capabilities=0;

	if(__logo==0)
	{
		blit(logo,screen,0,0,0,120,320,43);
	} else
	{
		textout_centre(screen,font,"- LOGO DISABLED -",160,150,makecol(192,192,192));
	}

	hline(screen,0,119,320,makecol(255,255,255));
	hline(screen,0,119+45,320,makecol(255,255,255));

	return;
}


int mainmenu(void)
{
	drawmenu();


	while(!key[KEY_F10])
	{

	install_int_ex(_menutimer,BPS_TO_TIMER(10));

	if ((key[KEY_ENTER])||(mouse_b & 2))
		{
			switch(opcja)
			{
				case 1: {remove_int(_menutimer); test(); break;}
				case 2: {remove_int(_menutimer); info(); break;}
				case 3: {remove_int(_menutimer); return 1;}
			}

		drawmenu();

		}

	}

	return 0;
}

int test(void)
{
	timing=0; // reset the timer
	pixels=0;

	LOCK_VARIABLE(timing);
	LOCK_FUNCTION(_timing);

	clear_to_color(screen,makecol(255,255,255));

	install_int_ex(_timing,SECS_TO_TIMER(1));

	do
	{
		pixels++;
		putpixel(screen,rand()%320,rand()%200,makecol(rand()%255,rand()%255,rand()%255));
	} while (timing<10);


	fade_out(5);
	set_palette(pal);
	clear_to_color(screen,makecol(0,0,0));

        textprintf_centre_ex(screen,font, 160, 1, makecol(0,0,255), makecol(255,255,255),"results of test");
	textprintf_ex(screen,font,1,20, makecol(255,255,255), -1,"pixels (10 secs): %ld",pixels);
	textprintf_ex(screen,font,1,30, makecol(255,255,255), -1,"To compare your PC see docs.");
	textprintf_ex(screen,font,1,50, makecol(255,0,0    ), -1,"If you wish to expand results database");
	textprintf_ex(screen,font,1,60, makecol(255,0,0    ), -1,"see docs for info how to do so!");

	textprintf_ex(screen,font,1,100,makecol(64,255,64), -1  ,"Press any key");

	textprintf_ex(screen,font,1,150, makecol(255,255,255), makecol(255,0,0),"Contact:");
	textprintf_ex(screen,font,1,160, makecol(255,255,255), makecol(128,0,0),"rafalszyja@poczta.onet.pl");
	textprintf_ex(screen,font,1,170, makecol(255,255,255), makecol(64, 0,0),"http:\\\\rafalszyja.republika.pl");

	clear_keybuf();
	readkey();
	fade_out(5);
	set_palette(pal);


	return 1;

}

int info(void)
{
	clear_to_color(screen,makecol(0,0,0));


	textout_centre(screen,font,"INFO",160,1,makecol(128,128,128));
	textout_centre(screen,font,"INFO",161,2,makecol(255,255,255));

	textout_centre(screen,font,"GFXBENCH is designed to test your system",161,10,makecol(255,255,255));
	textout_centre(screen,font,"it uses standard VGA,wo any hardware ",161,18,makecol(255,255,255));
	textout_centre(screen,font,"acceleration.GFXBENCH will help you with",161,26,makecol(255,255,255));
	textout_centre(screen,font,"calculating processor overclocking due",161,33,makecol(255,255,255));
	textout_centre(screen,font,"to high sensitivity of cards to system",161,40,makecol(255,255,255));
	textout_centre(screen,font,"bus.3DNOW,MMX,cooprocessor,",161,48,makecol(255,255,255));
	textout_centre(screen,font,"SSE etc are disabled.",161,56,makecol(255,255,255));
	textout_centre(screen,font,"Symobls under Menu are CPU extensions",160,72,makecol(255,255,255));
	textout_centre(screen,font,"If CPU haven't FPU (old 386sx&486sx)",160,80,makecol(255,255,255));
	textout_centre(screen,font,"the FPU will be gray.If CPU is 486dx2",160,88,makecol(255,255,255));
	textout_centre(screen,font,"or higher,then FPU will be white.Rest",160,96,makecol(255,255,255));
	textout_centre(screen,font,"is similiar :) ",160,104,makecol(255,255,255));

	textout_centre(screen,font,"[ESC] key backs",160,118,makecol(160,160,160));

	textout_centre(screen,font,"MENU: use arrows & ENTER.",160,135,makecol(160,0,0));
	textout_centre(screen,font,"Mouse: Left button cycles,rigth enters",160,146,makecol(160,0,0));

	textout_centre(screen,font,"Good benchmarking! ",160,190,makecol(128,255,55));



	while (!key[KEY_ESC]) {}

	clear_to_color(screen,makecol(0,0,0));
	return 0;
}



int mainscr(void)
{
	RGB black = { 0,  0,  0  };


		if (exists("logo.gfb")!=0)
			logo=load_gif("logo.gfb",pal);
		else
			logo=load_gif("#logo",pal);

		set_palette(pal);
		set_color(0,&black);

		if (__logo==0)
		{
			blit(logo,screen,0,0,0,0,320,200);
			readkey();
			fade_out(5);
		}

		set_palette(pal);
		clear_to_color(screen,makecol(0,0,0));


	return 0;
}
