#ifndef OBJECTS_H
#define OBJECTS_H

typedef struct player {
    int x;
    int y;
    int bx;
    int by;
    int lvl;
    int lives;
    int fside;
    int died;
    int speed;
    int score;
    int counter;
    int max_fuel;
    int cur_fuel;
    int add;
    struct initials {
            char chr1[2];
            char chr2[2];
            char chr3[2];
            char initials[4];
            int update;
    }ini;
} ply;

typedef struct haircross {
    int ID;
    int x;
    int y;
    int speed;
} hrc;

typedef struct character {
    int x;
    int y;
    char val[2];
} chr;

typedef struct bullets {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int live;
} bul;

typedef struct bombs {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int live;
} bom;

typedef struct building {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int live;
    int score;
} bld;

typedef struct alien {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int live;
    int score;
} aln;

typedef struct fuel {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int live;
    int score;
    int fuel;
} ful;

typedef struct comet {
    int x;
    int y;
    int bx;
    int by;
    int speedx;
    int speedy;
    int live;
    int score;
} com;

typedef struct line {
    int x1;
    int y1;
    int x2;
    int y2;
    int speed;
    int live;
} lne;

typedef struct explosion {
    int x;
    int y;
    int radius;
    int size;
    int expanding;
    int speed_r;
    int live;
} xpl;

typedef struct missile {
    int x;
    int y;
    int bx;
    int by;
    int speedx;
    int speedy;
    int fired;
    int live;
    int score;
} mis;

typedef struct ufo {
    int x;
    int y;
    int bx;
    int by;
    int speedx;
    int speedy;
    int live;
    int score;
    int moving_up;
} ufo;

typedef struct laser {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int live;
} las;

typedef struct cannon {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    int score;
    int counter;
    int live;
} can;

typedef struct cannon_ball {
    int x;
    int y;
    int bx;
    int by;
    int speed;
    double angle;
    int live;
} cba;

void nul_obj(aln *aln, can *can, xpl *xpl, lne *lne, bld *bld, bom *bom, 
    bul *bul, mis *mis, ful *ful, ufo *ufo, las *las, cba *cba, com *com, 
    int nbu, int nbo, int nbd, int nln, int nex, int nmi, int nfu, int nfo, 
    int nla, int nba, int nco);

void ini_chr(chr *chr, int s);

void ini_hrc(hrc *hrc);
void move_hrc_right(hrc *hrc);
void move_hrc_left(hrc *hrc);
void move_hrc_down(hrc *hrc);
void move_hrc_up(hrc *hrc);

void upd_ini(chr *chr, hrc *hrc, ply *ply, int s);

void ini_xpl(xpl *xpl, int s);
void spn_xpl(xpl *xpl, int s, int x, int y, int es);
void upd_xpl(xpl *xpl, int s);

void ini_lne(lne *lne, int s);
void spn_lne(lne *lne, int s, int x1, int y1, int x2, int y2);
void upd_lne(lne *lne, int s);
void col_lne_ply(lne *lne, ply *ply, xpl *xpl, int s, int nex);
void col_lne_bul(lne *lne, bul *bul, xpl *xpl, int nln, int nbu, int nex);
void col_lne_bom(lne *lne, bom *bom, xpl *xpl, int nln, int nbo, int nex);
void col_lne_com(lne *lne, com *com, xpl *xpl, int nln, int nco, int nex);
void col_lne_mis(lne *lne, mis *mis, xpl *xpl, int nln, int nmi, int nex);
void col_lne_cba(lne *lne, cba *cba, xpl *xpl, int nln, int nba, int nex);
void col_lne_las(lne *lne, las *las, xpl *xpl, int nln, int nla, int nex);
void col_lne_ufo(lne *lne, ufo *ufo, xpl *xpl, int nln, int nfo);

void ini_ufo(ufo *ufo, int s);
void spn_ufo(ufo *ufo, int s, int x, int y);
void upd_ufo(ufo *ufo, ply *ply, las *las, int s, int nla);
void col_ufo_ply(ufo *ufo, ply *ply, xpl *xpl, int s, int nex);
void col_ufo_bul(ufo *ufo, ply *ply, bul *bul, xpl *xpl, int nfo, int nbu, 
    int nex);
void col_ufo_bom(ufo *ufo, ply *ply, bom *bom, xpl *xpl, int nfo, int nbo, 
    int nex);

void ini_mis(mis *mis, int s);
void spn_mis(mis *mis, int s, int x, int y);
void upd_mis(mis *mis, ply *ply, int s);
void col_mis_ply(mis *mis, ply *ply, xpl *xpl, int s, int nex);
void col_mis_bul(mis *mis, ply *ply, bul *bul, xpl *xpl, int nmi, int nbu, 
    int nex);
void col_mis_bom(mis *mis, ply *ply, bom *bom, xpl *xpl, int nmi, int nbo, 
    int nex);

void ini_ful(ful *ful, int s);
void spn_ful(ful *ful, int s, int x, int y);
void upd_ful(ful *ful, int s);
void col_ful_ply(ful *ful, ply *ply, xpl *xpl, int s, int nex);
void col_ful_bul(ful *ful, ply *ply, bul *bul, xpl *xpl, int nfu, int nbu, 
    int nex);
void col_ful_bom(ful *ful, ply *ply, bom *bom, xpl *xpl, int nfu, int nbo, 
    int nex);
    
void ini_com(com *com, int s);
void spn_com(com *com, int s, int x, int y); 
void upd_com(com *com, int s);
void col_com_ply(com *com, ply *ply, xpl *xpl, int s, int nex);
void col_com_bul(com *com, ply *ply, bul *bul, xpl *xpl, int nco, int nbu, 
    int nex);
void col_com_bom(com *com, ply *ply, bom *bom, xpl *xpl, int nco, int nbo, 
    int nex);
    
void ini_bld(bld *bld, int s);
void spn_bld(bld *bld, int s, int x, int y);
void upd_bld(bld *bld, int s);
void col_bld_ply(bld *bld, ply *ply, xpl *xpl, int s, int nex);
void col_bld_bul(bld *bld, ply *ply, bul *bul, xpl *xpl, int nbd, int nbu, 
    int nex);
void col_bld_bom(bld *bld, ply *ply, bom *bom, xpl *xpl, int nbd, int nbo, 
    int nex);

void ini_cba(cba *cba, int s);
void spn_cba(cba *cba, int s, int sx, int sy, int dx, int dy);
void upd_cba(cba *cba, int s);
void col_cba_ply(cba *cba, ply *ply, xpl *xpl, int s, int nex);

void ini_bom(bom *bom, int s);
void spn_bom(bom *bom, int s, ply *ply);
void upd_bom(bom *bom, int s);

void ini_bul(bul *bul, int s);
void spn_bul(bul *bul, int s, ply *ply);
void upd_bul(bul *bul, int s);

void ini_las(las *las, int s);
void spn_las(las *las, int s, int x, int y);
void upd_las(las *las, int s);
void col_las_ply(las *las, ply *ply, xpl *xpl, int s, int nex);

void ini_can(can *can);
void spn_can(can *can, int x, int y);
void upd_can(can *can, cba *cba, ply *ply, int nba);
void col_can_ply(can *can, ply *ply, xpl *xpl, int nex);
void col_can_bul(can *can, ply *ply, bul *bul, xpl *xpl, int nbu, int nex);
void col_can_bom(can *can, ply *ply, bom *bom, xpl *xpl, int nbo, int nex);

void ini_aln(aln *aln);
void spn_aln(aln *aln, int x, int y);
void upd_aln(aln *aln);
void col_aln_ply(aln *aln, ply *ply, xpl *xpl, int nex);
void col_aln_bul(aln *aln, ply *ply, bul *bul, xpl *xpl, int nbu, int nex);
void col_aln_bom(aln *aln, ply *ply, bom *bom, xpl *xpl, int nbo, int nex);

void ini_ply(ply *ply, int h);
void mov_ply_up(ply *ply);
void mov_ply_down(ply *ply);
void mov_ply_left(ply *ply);
void mov_ply_right(ply *ply);



#endif