#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>
#include <math.h>
#include "objects.h"
#include "collisions.h"
#include "audio.h"

/* Initierar byggnad */
void ini_bld(bld *bld, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        bld[i].bx = 20;
        bld[i].by = 20;
        bld[i].speed = 1;
        bld[i].live = 0;
        bld[i].score = 20;
    }
}

/* Initierar byggnad comet */
void ini_com(com *com, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        com[i].bx = 5;
        com[i].by = 10;
        com[i].speedx = 1;
        com[i].speedy = 3;
        com[i].live = 0;
        com[i].score = 100;
    }
}

/* Initierar alien */
void ini_aln(aln *aln)
{
    aln->bx = 20;
    aln->by = 20;
    aln->speed = 1;
    aln->live = 0;
    aln->score = 100;
}

/* Initierar bränsletank */
void ini_ful(ful *ful, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        ful[i].bx = 20;
        ful[i].by = 20;
        ful[i].speed = 1;
        ful[i].live = 0;
        ful[i].score = 40;
        ful[i].fuel = 30;
    }
}

/* Initierar missiler */
void ini_mis(mis *mis, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        mis[i].bx = 10;
        mis[i].by = 20;
        mis[i].speedx = 1;
        mis[i].speedy = 3;
        mis[i].fired = 0;
        mis[i].live = 0;
        mis[i].score = 50;
    }
}

/* Initierar ufon */
void ini_ufo(ufo *ufo, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        ufo[i].bx = 20;
        ufo[i].by = 10;
        ufo[i].speedx = 1;
        ufo[i].speedy = 2;
        ufo[i].live = 0;
        ufo[i].score = 60;
        ufo[i].moving_up = 1;
    }
}

/* Initierar alla linjer */
void ini_lne(lne *lne, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        lne[i].speed = 1;
        lne[i].live = 0;
    }
}

/* initierar spelaren */
void ini_ply(ply *ply, int h)
{
    ply->x = 20;
    ply->y = h / 2;
    ply->bx = 20;
    ply->by = 10;
    ply->lvl = 1;
    ply->lives = 1;
    ply->fside = 0;
    ply->died = 0;
    ply->speed = 2;
    ply->score = 0;
    ply->counter = 0;
    ply->max_fuel = 100;
    ply->cur_fuel = ply->max_fuel;
    ply->add = 0;
    strcpy(ply->ini.chr1, ".");
    strcpy(ply->ini.chr2, ".");
    strcpy(ply->ini.chr3, ".");
    ply->ini.initials[0] = '\0';
    strcat(ply->ini.initials, ply->ini.chr1);
    strcat(ply->ini.initials, ply->ini.chr2);
    strcat(ply->ini.initials, ply->ini.chr3);
    ply->ini.update = 1;
}

void upd_ini(chr *chr, hrc *hrc, ply *ply, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(chr[i].x == hrc->x && chr[i].y == hrc->y) {
            switch(ply->ini.update) {
                case 1:
                    strcpy(ply->ini.chr1, chr[i].val);
                    break;
                case 2:
                    strcpy(ply->ini.chr2, chr[i].val);
                    break;
                case 3:
                    strcpy(ply->ini.chr3, chr[i].val);

                    break;
            }
        }
    }
    ply->ini.initials[0] = '\0';
    strcat(ply->ini.initials, ply->ini.chr1);
    strcat(ply->ini.initials, ply->ini.chr2);
    strcat(ply->ini.initials, ply->ini.chr3);
}

void ini_hrc(hrc *hrc)
{
    hrc->x = 220;
    hrc->y = 270;
    hrc->speed = 40;
}

void move_hrc_right(hrc *hrc)
{
    hrc->x += hrc->speed;
    if(hrc->x > 580)
        hrc->x = 580;
}
void move_hrc_left(hrc *hrc)
{
    hrc->x -= hrc->speed;
    if(hrc->x < 220)
        hrc->x = 220;
}
void move_hrc_down(hrc *hrc)
{
    hrc->y += hrc->speed;
    if(hrc->y > 350)
        hrc->y = 350;
}
void move_hrc_up(hrc *hrc)
{
    hrc->y -= hrc->speed;
    if(hrc->y < 270)
        hrc->y = 270;
}

void ini_chr(chr *chr, int s)
{
    size_t i;
    int xpos = 220;
    
    for(i = 0; i < s; i++) {
        
        if(i % 10 == 0)
            xpos = 220;
        if(i < 10)
            chr[i].y = 270;
        else if(i >= 10 && i < 20)
            chr[i].y = 310;
        else if(i >= 20 && i < s)
            chr[i].y = 350;
        chr[i].x = xpos;
        xpos += 40;
        switch(i) {
            case 0:
                strcpy(chr[i].val, "a");
                break;
            case 1:
                strcpy(chr[i].val, "b");
                break;
            case 2:
                strcpy(chr[i].val, "c");
                break;
            case 3:
                strcpy(chr[i].val, "d");
                break;
            case 4:
                strcpy(chr[i].val, "e");
                break;
            case 5:
                strcpy(chr[i].val, "f");
                break;
            case 6:
                strcpy(chr[i].val, "g");
                break;
            case 7:
                strcpy(chr[i].val, "h");
                break;
            case 8:
                strcpy(chr[i].val, "i");
                break;    
            case 9:
                strcpy(chr[i].val, "j");
                break;   
            case 10:
                strcpy(chr[i].val, "k");
                break;
            case 11:
                strcpy(chr[i].val, "l");
                break;
            case 12:
                strcpy(chr[i].val, "m");
                break;
            case 13:
                strcpy(chr[i].val, "n");
                break;
            case 14:
                strcpy(chr[i].val, "o");
                break;
            case 15:
                strcpy(chr[i].val, "p");
                break;
            case 16:
                strcpy(chr[i].val, "q");
                break;
            case 17:
                strcpy(chr[i].val, "r");
                break;
            case 18:
                strcpy(chr[i].val, "s");
                break;    
            case 19:
                strcpy(chr[i].val, "t");
                break;           
            case 20:
                strcpy(chr[i].val, "u");
                break;
            case 21:
                strcpy(chr[i].val, "v");
                break;
            case 22:
                strcpy(chr[i].val, "w");
                break;
            case 23:
                strcpy(chr[i].val, "x");
                break;
            case 24:
                strcpy(chr[i].val, "y");
                break;
            case 25:
                strcpy(chr[i].val, "z");
                break;
            case 26:
                strcpy(chr[i].val, ".");
                break;  
            case 27:
                strcpy(chr[i].val, "-");
                break;  
            case 28:
                strcpy(chr[i].val, "?");
                break; 
            case 29:
                strcpy(chr[i].val, ":");
                break;                 
        }
    }
}

/* Initierar kanon */
void ini_can(can *can)
{
    can->bx = 20;
    can->by = 20;
    can->speed = 1;
    can->score = 70;
    can->counter = 0;
    can->live = 0;
}

/* Initerar  spelarens skott */
void ini_bul(bul *bul, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        bul[i].bx = 5;
        bul[i].by = 5;
        bul[i].speed = 5;
        bul[i].live = 0;
    }
}

/* Initerar  kanonens skott */
void ini_cba(cba *cba, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        cba[i].bx = 5;
        cba[i].by = 5;
        cba[i].speed = 4;
        cba[i].live = 0;
    }
}

/* Initerar  ufo skott */
void ini_las(las *las, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        las[i].bx = 10;
        las[i].by = 5;
        las[i].speed = 4;
        las[i].live = 0;
    }
}

/* initierar alla explosioner */
void ini_xpl(xpl *xpl, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        xpl[i].speed_r = 4;
        xpl[i].radius = 1;
        xpl[i].live = 0;
    }
}

/* Initierar alla spelar bomber */
void ini_bom(bom *bom, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        bom[i].bx = 5;
        bom[i].by = 10;
        bom[i].speed = 2;
        bom[i].live = 0;
    }
}

/* Sätter igång en explosion */
void spn_xpl(xpl *xpl, int s, int x, int y, int es)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!xpl[i].live) {
            ply_sound(2);
            xpl[i].x = x;
            xpl[i].y = y;
            xpl[i].size = es;
            xpl[i].expanding = 1;
            xpl[i].live = 1;
            break;
        }
    }
}

/* Sätter ett skott till levande*/
void spn_bul(bul *bul, int s, ply *ply)
{
    int y;
    size_t i;
    
    if(ply->fside) {
        y = ply->y - 7;
        ply->fside = 0;
    } else {
        y = ply->y + 7;
        ply->fside = 1;
    }
    
    for(i = 0; i < s; i++) {
        if(!bul[i].live) {
            ply_sound(1);
            bul[i].x = ply->x + ply->bx;
            bul[i].y = y;
            bul[i].live = 1;
            break;
        }
    }
}

/* Sätter en kanonkula till levande */
void spn_cba(cba *cba, int s, int sx, int sy, int dx, int dy)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!cba[i].live) {
            cba[i].x = sx;
            cba[i].y = sy - 20;
            cba[i].angle = atan2(cba[i].y - dy, cba[i].x - dx);
            cba[i].live = 1;
            ply_sound(1);
            break;
        }
    }
}

/* Sätter en laser till levande */
void spn_las(las *las, int s, int x, int y)
{
    size_t i;
      
    for(i = 0; i < s; i++) {
        if(!las[i].live) {
            ply_sound(4);
            las[i].x = x - las[i].bx;
            las[i].y = y;
            las[i].live = 1;
            break;
        }
    }
}

/* Sätter en bomb till live */
void spn_bom(bom *bom, int s, ply *ply)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!bom[i].live) {
            bom[i].x = ply->x;
            bom[i].y = ply->y + ply->by;
            bom[i].live = 1;
            break;
        }
    }
}

/* Sätter en linje till live */
void spn_lne(lne *lne, int s, int x1, int y1, int x2, int y2)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!lne[i].live) {
            lne[i].x1 = x1;
            lne[i].y1 = y1;
            lne[i].x2 = x2;
            lne[i].y2 = y2;
            lne[i].live = 1;
            break;
        }
    }
}

/* Sätter en byggnad till live */
void spn_bld(bld *bld, int s, int x, int y)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!bld[i].live) {
            bld[i].x = x;
            bld[i].y = y;
            bld[i].live = 1;
            break;
        }
    }
}

/* Sätter en komet till live */
void spn_com(com *com, int s, int x, int y)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!com[i].live) {
            com[i].x = x;
            com[i].y = y;
            com[i].live = 1;
            break;
        }
    }
}

/* Sätter en bränsle behållare till live */
void spn_ful(ful *ful, int s, int x, int y)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!ful[i].live) {
            ful[i].x = x;
            ful[i].y = y;
            ful[i].live = 1;
            break;
        }
    }
}

/* Sätter kanon till live */
void spn_can(can *can, int x, int y)
{
    if(!can->live) {
        can->x = x;
        can->y = y;
        can->live = 1;
    }
}

/* Sätter alien till live */
void spn_aln(aln *aln, int x, int y)
{
    if(!aln->live) {
        aln->x = x;
        aln->y = y;
        aln->live = 1;
    }
}

/* Sätter en missil till live */
void spn_mis(mis *mis, int s, int x, int y)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!mis[i].live) {
            mis[i].x = x;
            mis[i].y = y;
            mis[i].live = 1;
            break;
        }
    }
}

/* Sätter ett ufo till live */
void spn_ufo(ufo *ufo, int s, int x, int y)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(!ufo[i].live) {
            ufo[i].x = x;
            ufo[i].y = y;
            ufo[i].live = 1;
            break;
        }
    }
}

/* Uppdaterar alla explosioner */
void upd_xpl(xpl *xpl, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(xpl[i].live) {
            if(xpl[i].expanding) {
                xpl[i].radius += xpl[i].speed_r;
                if(xpl[i].radius > xpl[i].size)
                    xpl[i].expanding = 0;
            } else {
                xpl[i].radius -= xpl[i].speed_r;
                if(xpl[i].radius <= 0)
                    xpl[i].live = 0;
            }
        }
    }
}

/* Uppdaterar alla spelarbomber */
void upd_bom(bom *bom, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(bom[i].live) {
            bom[i].y += bom[i].speed;
            if(bom[i].y > 600)
                bom[i].live = 0;
        }
    }
}

/* Uppdaterar alla linjer*/
void upd_lne(lne *lne, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(lne[i].live) {
            lne[i].x1 -= lne[i].speed;
            lne[i].x2 -= lne[i].speed;
            if(lne[i].x2 < 0)
                lne[i].live = 0;
        }
    }
}

/* Uppdaterar alla byggnader */
void upd_bld(bld *bld, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(bld[i].live) {
            bld[i].x -= bld[i].speed;
            if(bld[i].x + bld[i].bx < 0)
                bld[i].live = 0;
        }
    }
}

/* Uppdaterar alla kometer */
void upd_com(com *com, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(com[i].live) {
            com[i].x -= com[i].speedx;
            com[i].y += com[i].speedy;
            if(com[i].x + com[i].bx < 0)
                com[i].live = 0;
            
            if(com[i].y - com[i].by > 600)
                com[i].live = 0;
        }
    }
}

/*  Uppdaterar kanon */
void upd_can(can *can, cba *cba, ply *ply, int nba)
{
    if(can->live) {
        if(can->counter == 70) {
            spn_cba(cba, nba, can->x, can->y, ply->x, ply->y);
            can->counter = 0;
        }
        
        can->x -= can->speed;
        if(can->x + can->bx < 0) {
            can->live = 0;
            can->counter = 0;
        }
        can->counter++;
    }
}

/* Uppdaterar comet */
void upd_aln(aln *aln)
{
    aln->x -= aln->speed;
    if(aln->x + aln->bx < 0) {
        aln->live = 0;
    }
}

/* Uppdaterar kanonkula */
void upd_cba(cba *cba, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(cba[i].live) {
            cba[i].x -= cos(cba[i].angle) * cba[i].speed;
            cba[i].y -= sin(cba[i].angle) * cba[i].speed;
            if(cba[i].y < 30 || cba[i].x < 0 || cba[i].x > 800)
                cba[i].live = 0;
        }
    }
}

/* Uppdaterar alla bränslebehållare */
void upd_ful(ful *ful, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(ful[i].live) {
            ful[i].x -= ful[i].speed;
            if(ful[i].x + ful[i].bx < 0)
                ful[i].live = 0;
        }
    }
}

/* uppdaterar alla missiler */
void upd_mis(mis *mis, ply *ply, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(mis[i].live) {
            mis[i].x -= mis[i].speedx;
            
            if(in_rng(mis[i].x, ply->x, 100) && !mis[i].fired) {
                mis[i].fired = 1;
                ply_sound(3);
            }
                
            if(mis[i].fired)
                mis[i].y -= mis[i].speedy;
            
            if(mis[i].y + mis[i].by < 40) {
                mis[i].live = 0;
                mis[i].fired = 0;
            }
            
            if(mis[i].x + mis[i].bx < 0) {
                mis[i].live = 0;
                mis[i].fired = 0;
            }
        }
    }
}

/* uppdaterar alla ufon */
void upd_ufo(ufo *ufo, ply *ply, las *las, int s, int nla)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(ufo[i].live) {
            ufo[i].x -= ufo[i].speedx;
            
            if(ufo[i].moving_up)
                ufo[i].y -= ufo[i].speedy;
            else
                ufo[i].y += ufo[i].speedy;
            
            if(ufo[i].y - ufo[i].by < 30)
                ufo[i].moving_up = 0;
            
            if(ufo[i].y + ufo[i].by > 550)
                ufo[i].moving_up = 1;
            
            if(ufo[i].x + ufo[i].bx < 0)
                ufo[i].live = 0;
                
            if(in_scp(ufo[i].y, ply->y, 40)) {
                if((rand() % 60) == 1)
                    spn_las(las, nla, ufo[i].x, ufo[i].y);
            }
        }
    }
}

/* uppdaterar alla spelarskott */
void upd_bul(bul *bul, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(bul[i].live) {
            bul[i].x += bul[i].speed;
            if(bul[i].x > 800)
                bul[i].live = 0;
        }
    }
}

/* Uppdaterar alla lasrar */
void upd_las(las *las, int s)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(las[i].live) {
            las[i].x -= las[i].speed;
            if(las[i].x + las[i].bx < 0)
                las[i].live = 0;
        }
    }
}

/* Spelare kollision med linje */
void col_lne_ply(lne *lne, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(lne[i].live) {
            if(in_rng(lne[i].x1, ply->x, 50) || in_rng(lne[i].x2, ply->x, 50)) {
                if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                   ply->x, ply->bx, ply->y, ply->by)) {
                    ply->died = 1;
                    ply->counter = 100;
                    spn_xpl(xpl, nex, ply->x, ply->y, 50);
                } 
            }
        }
    }
}

/* Kollision mellan linje och bomb */
void col_lne_bom(lne *lne, bom *bom, xpl *xpl, int nln, int nbo, int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nbo; j++) {
                if(bom[j].live) {
                    if(in_rng(lne[i].x1, bom[j].x, 50) || 
                       in_rng(lne[i].x2, bom[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           bom[j].x, bom[j].bx, bom[j].y, bom[j].by)) {
                            bom[j].live = 0;
                            spn_xpl(xpl, nex, bom[j].x, bom[j].y, 20);
                        }
                    }
                }
            }
        }
    }
}

/* Kollision mellan linje och komet */
void col_lne_com(lne *lne, com *com, xpl *xpl, int nln, int nco, int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nco; j++) {
                if(com[j].live) {
                    if(in_rng(lne[i].x1, com[j].x, 50) || 
                       in_rng(lne[i].x2, com[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           com[j].x, com[j].bx, com[j].y, com[j].by)) {
                            com[j].live = 0;
                            spn_xpl(xpl, nex, com[j].x, com[j].y, 20);
                        }
                    }
                }
            }
        }
    }
}

/* Kollision mellan linje och missil */
void col_lne_mis(lne *lne, mis *mis, xpl *xpl, int nln, int nmi, int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nmi; j++) {
                if(mis[j].live) {
                    if(in_rng(lne[i].x1, mis[j].x, 50) || 
                       in_rng(lne[i].x2, mis[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           mis[j].x, mis[j].bx, mis[j].y, mis[j].by)) {
                            mis[j].live = 0;
                            mis[j].fired = 0;
                            spn_xpl(xpl, nex, mis[j].x, mis[j].y, 50);
                        }
                    }
                }
            }
        }
    }
}

/* Kollision mellan linje och kanonkula */
void col_lne_cba(lne *lne, cba *cba, xpl *xpl, int nln, int nba, int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nba; j++) {
                if(cba[j].live) {
                    if(in_rng(lne[i].x1, cba[j].x, 50) || 
                       in_rng(lne[i].x2, cba[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           cba[j].x, cba[j].bx, cba[j].y, cba[j].by)) {
                            cba[j].live = 0;
                            spn_xpl(xpl, nex, cba[j].x, cba[j].y, 50);
                        }
                    }
                }
            }
        }
    }
}

/* Kollision mellan linje och laser*/
void col_lne_las(lne *lne, las *las, xpl *xpl, int nln, int nla, int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nla; j++) {
                if(las[j].live) {
                    if(in_rng(lne[i].x1, las[j].x, 50) || 
                       in_rng(lne[i].x2, las[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           las[j].x, las[j].bx, las[j].y, las[j].by)) {
                            las[j].live = 0;
                            spn_xpl(xpl, nex, las[j].x, las[j].y, 20);
                        }
                    }
                }
            }
        }
    }
}

/* Kollision mellan linje och ufo */
void col_lne_ufo(lne *lne, ufo *ufo, xpl *xpl, int nln, int nfo)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nfo; j++) {
                if(ufo[j].live) {
                    if(in_rng(lne[i].x1, ufo[j].x, 50) || 
                       in_rng(lne[i].x2, ufo[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           ufo[j].x, ufo[j].bx, ufo[j].y, ufo[j].by)) {
                            if(ufo[j].moving_up)
                                ufo[j].moving_up = 0;
                            else
                                ufo[j].moving_up = 1;
                        }
                    }
                }
            }
        }
    }
}

/* Kollision mellan linje och spelarskott*/
void col_lne_bul(lne *lne, bul *bul, xpl *xpl, int nln, int nbu, int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nln; i++) {
        if(lne[i].live) {
            for(j = 0; j < nbu; j++) {
                if(bul[j].live) {
                    if(in_rng(lne[i].x1, bul[j].x, 50) || 
                       in_rng(lne[i].x2, bul[j].x, 50)) {
                        if(ln_col(lne[i].x1, lne[i].y1, lne[i].x2, lne[i].y2, 
                           bul[j].x, bul[j].bx, bul[j].y, bul[j].by)) {
                            bul[j].live = 0;
                            spn_xpl(xpl, nex, bul[j].x, bul[j].y, 20);
                        }
                    }
                }
            }
        }
    }
}

/* Kollision spelarens bomber med byggnader */
void col_bld_bom(bld *bld, ply *ply, bom *bom, xpl *xpl, int nbd, int nbo, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nbd; i++) {
        if(bld[i].live) {
            for(j = 0; j < nbo; j++) {
                if(bom[j].live && in_rng(bld[i].x, bom[j].x, 60)) {
                    if(bb_col(bld[i].x, bld[i].y, bld[i].bx, bld[i].by, 
                       bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                        bld[i].live = 0;
                        bom[j].live = 0;
                        ply->score += bld[i].score;
                        spn_xpl(xpl, nex, bld[i].x, bld[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens bomber med kometer */
void col_com_bom(com *com, ply *ply, bom *bom, xpl *xpl, int nco, int nbo, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nco; i++) {
        if(com[i].live) {
            for(j = 0; j < nbo; j++) {
                if(bom[j].live && in_rng(com[i].x, bom[j].x, 60)) {
                    if(bb_col(com[i].x, com[i].y, com[i].bx, com[i].by, 
                       bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                        com[i].live = 0;
                        bom[j].live = 0;
                        ply->score += com[i].score;
                        spn_xpl(xpl, nex, com[i].x, com[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens bomber med bränslebehållare */
void col_ful_bom(ful *ful, ply *ply, bom *bom, xpl *xpl, int nfu, int nbo, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nfu; i++) {
        if(ful[i].live) {
            for(j = 0; j < nbo; j++) {
                if(bom[j].live && in_rng(ful[i].x, bom[j].x, 60)) {
                    if(bb_col(ful[i].x, ful[i].y, ful[i].bx, ful[i].by, 
                       bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                        ful[i].live = 0;
                        bom[j].live = 0;
                        ply->score += ful[i].score;
                        ply->cur_fuel += ful[i].fuel;
                        if(ply->cur_fuel > ply->max_fuel)
                            ply->cur_fuel = ply->max_fuel;
                        spn_xpl(xpl, nex, ful[i].x, ful[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens skott med byggnader */
void col_bld_bul(bld *bld, ply *ply, bul *bul, xpl *xpl, int nbd, int nbu, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nbd; i++) {
        if(bld[i].live) {
            for(j = 0; j < nbu; j++) {
                if(bul[j].live && in_rng(bld[i].x, bul[j].x, 60)) {
                    if(bb_col(bld[i].x, bld[i].y, bld[i].bx, bld[i].by, 
                       bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                        bld[i].live = 0;
                        bul[j].live = 0;
                        ply->score += bld[i].score;
                        spn_xpl(xpl, nex, bld[i].x, bld[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens skott med kometer */
void col_com_bul(com *com, ply *ply, bul *bul, xpl *xpl, int nco, int nbu, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nco; i++) {
        if(com[i].live) {
            for(j = 0; j < nbu; j++) {
                if(bul[j].live && in_rng(com[i].x, bul[j].x, 60)) {
                    if(bb_col(com[i].x, com[i].y, com[i].bx, com[i].by, 
                       bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                        bul[j].live = 0;
                        spn_xpl(xpl, nex, com[i].x, com[i].y, 20);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens skott med bränslebehållare */
void col_ful_bul(ful *ful, ply *ply, bul *bul, xpl *xpl, int nfu, int nbu, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nfu; i++) {
        if(ful[i].live) {
            for(j = 0; j < nbu; j++) {
                if(bul[j].live && in_rng(ful[i].x, bul[j].x, 60)) {
                    if(bb_col(ful[i].x, ful[i].y, ful[i].bx, ful[i].by, 
                       bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                        ful[i].live = 0;
                        bul[j].live = 0;
                        ply->score += ful[i].score;
                        ply->cur_fuel += ful[i].fuel;
                        if(ply->cur_fuel > ply->max_fuel)
                            ply->cur_fuel = ply->max_fuel;
                        spn_xpl(xpl, nex, ful[i].x, ful[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelare med byggnader */
void col_bld_ply(bld *bld, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(bld[i].live && in_rng(bld[i].x, ply->x, 60)) {
            if(bb_col(bld[i].x, bld[i].y, bld[i].bx, bld[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                bld[i].live = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
            }
        }
    }
}

/* Kollision spelare med komet */
void col_com_ply(com *com, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(com[i].live && in_rng(com[i].x, ply->x, 60)) {
            if(bb_col(com[i].x, com[i].y, com[i].bx, com[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                com[i].live = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
            }
        }
    }
}

/* Kollision spelare med bränslebehållare */
void col_ful_ply(ful *ful, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(ful[i].live && in_rng(ful[i].x, ply->x, 60)) {
            if(bb_col(ful[i].x, ful[i].y, ful[i].bx, ful[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                ful[i].live = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
                spn_xpl(xpl, nex, ful[i].x, ful[i].y, 50);
            }
        }
    }
}

/* Kollision spelarens bomber med missiler */
void col_mis_bom(mis *mis, ply *ply, bom *bom, xpl *xpl, int nmi, int nbo, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nmi; i++) {
        if(mis[i].live) {
            for(j = 0; j < nbo; j++) {
                if(bom[j].live && in_rng(mis[i].x, bom[j].x, 60)) {
                    if(bb_col(mis[i].x, mis[i].y, mis[i].bx, mis[i].by, 
                       bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                        mis[i].live = 0;
                        mis[i].fired = 0;
                        bom[j].live = 0;
                        ply->score += mis[i].score;
                        spn_xpl(xpl, nex, mis[i].x, mis[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens bomber med ufon */
void col_ufo_bom(ufo *ufo, ply *ply, bom *bom, xpl *xpl, int nfo, int nbo, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nfo; i++) {
        if(ufo[i].live) {
            for(j = 0; j < nbo; j++) {
                if(bom[j].live && in_rng(ufo[i].x, bom[j].x, 60)) {
                    if(bb_col(ufo[i].x, ufo[i].y, ufo[i].bx, ufo[i].by, 
                       bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                        ufo[i].live = 0;
                        bom[j].live = 0;
                        ply->score += ufo[i].score;
                        spn_xpl(xpl, nex, ufo[i].x, ufo[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens skott med missil */
void col_mis_bul(mis *mis, ply *ply, bul *bul, xpl *xpl, int nmi, int nbu, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nmi; i++) {
        if(mis[i].live) {
            for(j = 0; j < nbu; j++) {
                if(bul[j].live && in_rng(mis[i].x, bul[j].x, 60)) {
                    if(bb_col(mis[i].x, mis[i].y, mis[i].bx, mis[i].by, 
                       bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                        mis[i].live = 0;
                        mis[i].fired = 0;
                        bul[j].live = 0;
                        ply->score += mis[i].score;
                        spn_xpl(xpl, nex, mis[i].x, mis[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelarens skott med kanon */
void col_can_bul(can *can, ply *ply, bul *bul, xpl *xpl, int nbu, int nex)
{
    size_t j;
    
    if(can->live) {
        for(j = 0; j < nbu; j++) {
            if(bul[j].live && in_rng(can->x, bul[j].x, 60)) {
                if(bb_col(can->x, can->y, can->bx, can->by, 
                   bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                    can->live = 0;
                    bul[j].live = 0;
                    ply->score += can->score;
                    spn_xpl(xpl, nex, can->x, can->y, 50);
                }
            }
        }
    }
}

/* Kollision spelarens skott med alien */
void col_aln_bul(aln *aln, ply *ply, bul *bul, xpl *xpl, int nbu, int nex)
{
    size_t j;
    
    if(aln->live) {
        for(j = 0; j < nbu; j++) {
            if(bul[j].live && in_rng(aln->x, bul[j].x, 60)) {
                if(bb_col(aln->x, aln->y, aln->bx, aln->by, 
                   bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                    aln->live = 0;
                    bul[j].live = 0;
                    ply->score += aln->score;
                    spn_xpl(xpl, nex, aln->x, aln->y, 50);
                }
            }
        }
    }
}

/* Kollision spelarens bomb med kanon */
void col_can_bom(can *can, ply *ply, bom *bom, xpl *xpl, int nbo, int nex)
{
    size_t j;
    
    if(can->live) {
        for(j = 0; j < nbo; j++) {
            if(bom[j].live && in_rng(can->x, bom[j].x, 60)) {
                if(bb_col(can->x, can->y, can->bx, can->by, 
                   bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                    can->live = 0;
                    bom[j].live = 0;
                    ply->score += can->score;
                    spn_xpl(xpl, nex, can->x, can->y, 50);
                }
            }
        }
    }
}

/* Kollision spelarens bomb med alien */
void col_aln_bom(aln *aln, ply *ply, bom *bom, xpl *xpl, int nbo, int nex)
{
    size_t j;
    
    if(aln->live) {
        for(j = 0; j < nbo; j++) {
            if(bom[j].live && in_rng(aln->x, bom[j].x, 60)) {
                if(bb_col(aln->x, aln->y, aln->bx, aln->by, 
                   bom[j].x, bom[j].y, bom[j].bx, bom[j].by)) {
                    aln->live = 0;
                    bom[j].live = 0;
                    ply->score += aln->score;
                    spn_xpl(xpl, nex, aln->x, aln->y, 50);
                }
            }
        }
    }
}

/* Kollision spelarens skott med ufo */
void col_ufo_bul(ufo *ufo, ply *ply, bul *bul, xpl *xpl, int nfo, int nbu, 
    int nex)
{
    size_t i;
    size_t j;
    
    for(i = 0; i < nfo; i++) {
        if(ufo[i].live) {
            for(j = 0; j < nbu; j++) {
                if(bul[j].live && in_rng(ufo[i].x, bul[j].x, 60)) {
                    if(bb_col(ufo[i].x, ufo[i].y, ufo[i].bx, ufo[i].by, 
                       bul[j].x, bul[j].y, bul[j].bx, bul[j].by)) {
                        ufo[i].live = 0;
                        bul[j].live = 0;
                        ply->score += ufo[i].score;
                        spn_xpl(xpl, nex, ufo[i].x, ufo[i].y, 50);
                    }
                }
            }
        }
    }
}

/* Kollision spelare med missil */
void col_mis_ply(mis *mis, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(mis[i].live && in_rng(mis[i].x, ply->x, 60)) {
            if(bb_col(mis[i].x, mis[i].y, mis[i].bx, mis[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                mis[i].live = 0;
                mis[i].fired = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
            }
        }
    }
}

/* Kollision spelare med kanonkula */
void col_cba_ply(cba *cba, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(cba[i].live && in_rng(cba[i].x, ply->x, 60)) {
            if(bb_col(cba[i].x, cba[i].y, cba[i].bx, cba[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                cba[i].live = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
            }
        }
    }
}

/* Kollision spelare med kanon */
void col_can_ply(can *can, ply *ply, xpl *xpl, int nex)
{
    if(can->live && in_rng(can->x, ply->x, 60)) {
        if(bb_col(can->x, can->y, can->bx, can->by, 
           ply->x, ply->y, ply->bx, ply->by)) {
            can->live = 0;
            ply->died = 1;
            ply->counter = 100;
            spn_xpl(xpl, nex, ply->x, ply->y, 50);
        }
    }
}

/* Kollision spelare med alien */
void col_aln_ply(aln *aln, ply *ply, xpl *xpl, int nex)
{
    if(aln->live && in_rng(aln->x, ply->x, 60)) {
        if(bb_col(aln->x, aln->y, aln->bx, aln->by, 
           ply->x, ply->y, ply->bx, ply->by)) {
            aln->live = 0;
            ply->died = 1;
            ply->counter = 100;
            spn_xpl(xpl, nex, ply->x, ply->y, 50);
        }
    }
}

void col_las_ply(las *las, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(las[i].live && in_rng(las[i].x, ply->x, 60)) {
            if(bb_col(las[i].x, las[i].y, las[i].bx, las[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                las[i].live = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
            }
        }
    }
}

/* Kollision spelare med ufo */
void col_ufo_ply(ufo *ufo, ply *ply, xpl *xpl, int s, int nex)
{
    size_t i;
    
    for(i = 0; i < s; i++) {
        if(ufo[i].live && in_rng(ufo[i].x, ply->x, 60)) {
            if(bb_col(ufo[i].x, ufo[i].y, ufo[i].bx, ufo[i].by, 
               ply->x, ply->y, ply->bx, ply->by)) {
                ufo[i].live = 0;
                ply->died = 1;
                ply->counter = 100;
                spn_xpl(xpl, nex, ply->x, ply->y, 50);
            }
        }
    }
}

/* Dödar alla objekt */
void nul_obj(aln *aln, can *can, xpl *xpl, lne *lne, bld *bld, bom *bom, 
    bul *bul, mis *mis, ful *ful, ufo *ufo, las *las, cba *cba, com *com, 
    int nbu, int nbo, int nbd, int nln, int nex, int nmi, int nfu, int nfo, 
    int nla, int nba, int nco)
{
    size_t i;
    
    can->live = 0;
    can->counter = 0;
    
    aln->live = 0;
    
    for(i = 0; i < nex; i++) {
        xpl[i].live = 0;
    }
    
    for(i = 0; i < nln; i++) {
        lne[i].live = 0;
    }
    
    for(i = 0; i < nbd; i++) {
        bld[i].live = 0;
    }
    
    for(i = 0; i < nbo; i++) {
        bom[i].live = 0;
    }
    
    for(i = 0; i < nbu; i++) {
        bul[i].live = 0;
    }
    
    for(i = 0; i < nmi; i++) {
        mis[i].live = 0;
        mis[i].fired = 0;
    }
    
    for(i = 0; i < nfu; i++) {
        ful[i].live = 0;
    }
    
    for(i = 0; i < nfo; i++) {
        ufo[i].live = 0;
        ufo[i].moving_up = 1;
    }
    
    for(i = 0; i < nla; i++) {
        las[i].live = 0;
    }
    
    for(i = 0; i < nba; i++) {
        cba[i].live = 0;
    }
    
    for(i = 0; i < nco; i++) {
        com[i].live = 0;
    }
}

/* Uppdaterar skeppets y position negativt */
void mov_ply_up(ply *ply)
{
    ply->y -= ply->speed;
    if(ply->y < 40)
        ply->y = 40;
}

/* Uppdaterar skeppets y position positivt */
void mov_ply_down(ply *ply)
{
    ply->y += ply->speed;
    if(ply->y > 580)
        ply->y = 580;
}

/* Uppdaterar skeppets x position negativt */
void mov_ply_left(ply *ply)
{
    ply->x -= ply->speed;
    if(ply->x < 20)
        ply->x = 20;
}

/* Uppdaterar skeppets x position positivt */
void mov_ply_right(ply *ply)
{
    ply->x += ply->speed;
    if(ply->x > 780)
        ply->x = 780;
}