#include <stdio.h>
#include <stddef.h>
#include <allegro5/allegro_primitives.h>
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include "drawings.h"
#include "hiscore.h"


/* Font variabler */
ALLEGRO_FONT *font18;
ALLEGRO_FONT *font36;
ALLEGRO_FONT *font72;

ALLEGRO_COLOR black;
ALLEGRO_COLOR green255;
ALLEGRO_COLOR green125;
ALLEGRO_COLOR green50;

/* Initierar allergo addons */
void ini_allegro_addon()
{
    al_init_primitives_addon();
    al_init_font_addon();
    al_init_ttf_addon();
}

/* Tilldelar fonterna ett värde */
void ini_allegro_colors()
{
    black = al_map_rgb(0, 0, 0);
    green255 = al_map_rgb(0, 255, 0);
    green125 = al_map_rgb(0, 125, 0);
    green50 = al_map_rgb(0, 50, 0);
}

/* Tilldelar fonterna ett värde */
void ini_allegro_fonts()
{
    font18 = al_load_font("phaserbank.ttf", 18, 0);
    font36 = al_load_font("phaserbank.ttf", 36, 0);
    font72 = al_load_font("phaserbank.ttf", 72, 0);
}

/* Ritar game over */
void drw_game_over(int h, int w)
{
    al_draw_text(font72, green50, (w / 2) - 3, 
        (h / 4) - 3, ALLEGRO_ALIGN_CENTRE, "game over");
    al_draw_text(font72, green255, w / 2, 
        h / 4, ALLEGRO_ALIGN_CENTRE, "game over");
    al_draw_text(font18, green50, (w / 2) - 3, 
        497, ALLEGRO_ALIGN_CENTRE, "hit sace bar");
    al_draw_text(font18, green255, w / 2, 
        500, ALLEGRO_ALIGN_CENTRE, "hit sace bar");
}

/* Ritar menyn */
void drw_menu(int w)
{
    int j = 0;
    size_t i;

    hse row;
    
    /* Skriver ut varje rad två ggr för att fåe en skugga */
    al_draw_text(font72, green50, w / 2 - 3, 
        2, ALLEGRO_ALIGN_CENTRE, "scramble");
    al_draw_text(font72, green255, w / 2 , 
        5, ALLEGRO_ALIGN_CENTRE, "scramble");
    al_draw_text(font36, green50, (w / 2) - 3 , 
        97, ALLEGRO_ALIGN_CENTRE, "hiscore table");
    al_draw_text(font36, green255, w / 2 , 
        100, ALLEGRO_ALIGN_CENTRE, "hiscore table");
    al_draw_text(font18, green50, (w / 2) - 3 , 
        377, ALLEGRO_ALIGN_CENTRE, 
        "press 'space' to fire and 'b' to drop a bomb");
    al_draw_text(font18, green255, w / 2 , 
        380, ALLEGRO_ALIGN_CENTRE, 
        "press 'space' to fire and 'b' to drop a bomb");
    al_draw_text(font36, green50, (w / 2) - 3, 
        557, ALLEGRO_ALIGN_CENTRE, "hit space to play");
    al_draw_text(font36, green255, w / 2 , 
        560, ALLEGRO_ALIGN_CENTRE, "hit space to play");
    al_draw_text(font18, green50, 147 , 
        437, ALLEGRO_ALIGN_LEFT, "20 pts");
    al_draw_text(font18, green255, 150 , 
        440, ALLEGRO_ALIGN_LEFT, "20 pts");
    al_draw_text(font18, green50, 397 , 
        437, ALLEGRO_ALIGN_LEFT, "40 pts + fuel");
    al_draw_text(font18, green255, 400 , 
        440, ALLEGRO_ALIGN_LEFT, "40 pts + fuel");
    al_draw_text(font18, green50, 647 , 
        437, ALLEGRO_ALIGN_LEFT, "100 pts");   
    al_draw_text(font18, green255, 650 , 
        440, ALLEGRO_ALIGN_LEFT, "100 pts");
    al_draw_text(font18, green50, 147 , 
        507, ALLEGRO_ALIGN_LEFT, "50 pts");
    al_draw_text(font18, green255, 150 , 
        510, ALLEGRO_ALIGN_LEFT, "50 pts");
    al_draw_text(font18, green50, 397 , 
        507, ALLEGRO_ALIGN_LEFT, "60 pts");
    al_draw_text(font18, green255, 400 , 
        510, ALLEGRO_ALIGN_LEFT, "60 pts");
    al_draw_text(font18, green50, 647 , 
        507, ALLEGRO_ALIGN_LEFT, "70 pts");
    al_draw_text(font18, green255, 650 , 
        510, ALLEGRO_ALIGN_LEFT, "70 pts");
        
    /* Skriver ut hiscore listan */
    for(i = 0; i < 10; i++) {
        /* Hämtar en rad ur hiscore tabellen */
        row = get_entry(i);
        al_draw_textf(font18, green50, (w / 2) - 83 , 
            147 + j, ALLEGRO_ALIGN_LEFT, "%s", row.initials);
        al_draw_textf(font18, green255, (w / 2) - 80 , 
            150 + j, ALLEGRO_ALIGN_LEFT, "%s", row.initials);
        al_draw_textf(font18, green50, (w / 2) + 77 , 
            147 + j, ALLEGRO_ALIGN_LEFT, "%d", row.score); 
        al_draw_textf(font18, green255, (w / 2) + 80 , 
            150 + j, ALLEGRO_ALIGN_LEFT, "%d", row.score);   
        j += 20;
    }
}

void drw_qualify(int w)
{
    al_draw_text(font36, green50, (w / 2) - 3, 
        47, ALLEGRO_ALIGN_CENTRE, "congratulations!");
    al_draw_text(font36, green255, w / 2, 
        50, ALLEGRO_ALIGN_CENTRE, "congratulations!");

    al_draw_text(font18, green50, (w / 2) - 3, 
        97, ALLEGRO_ALIGN_CENTRE, "You've earned a spot among"); 
    al_draw_text(font18, green255, w / 2, 
        100, ALLEGRO_ALIGN_CENTRE, "You've earned a spot among");

    al_draw_text(font18, green50, (w / 2) - 3, 
        117, ALLEGRO_ALIGN_CENTRE, "the top ten scorers");    
    al_draw_text(font18, green255, w / 2, 
        120, ALLEGRO_ALIGN_CENTRE, "the top ten scorers");

    al_draw_text(font36, green50, (w / 2) - 3, 
        197, ALLEGRO_ALIGN_CENTRE, "Enter your initials");    
    al_draw_text(font36, green255, w / 2, 
        200, ALLEGRO_ALIGN_CENTRE, "Enter your initials");

    al_draw_text(font18, green50, (w / 2) - 3, 
        467, ALLEGRO_ALIGN_CENTRE, "press space to select a character");    
    al_draw_text(font18, green255, w / 2,     
        470, ALLEGRO_ALIGN_CENTRE, "press space to select a character");

    al_draw_text(font18, green50, (w / 2) - 3, 
        497, ALLEGRO_ALIGN_CENTRE, "press backspace to deselect a character");
    al_draw_text(font18, green255, w / 2, 
        500, ALLEGRO_ALIGN_CENTRE, "press backspace to deselect a character");
    
    al_draw_text(font18, green50, (w / 2) - 3, 
        527, ALLEGRO_ALIGN_CENTRE, "press enter to finnish");
    al_draw_text(font18, green255, w / 2, 
        530, ALLEGRO_ALIGN_CENTRE, "press enter to finnish");
    al_draw_rectangle(195,255,600,445,green255,1);
}

void drw_ini(int w, char val[])
{
    al_draw_textf(font36, green50, (w / 2) -3, 397, 
        ALLEGRO_ALIGN_CENTRE, "%s", val);
    al_draw_textf(font36, green255, w / 2, 400, 
        ALLEGRO_ALIGN_CENTRE, "%s", val);
}

void drw_chr(int x, int y, char val[])
{
    al_draw_textf(font36, green50, x - 3, y - 3, 
        ALLEGRO_ALIGN_CENTRE, "%s", val);
    al_draw_textf(font36, green255, x, y, ALLEGRO_ALIGN_CENTRE, "%s", val);
}

/* Ritar statestik om spelaren */
void drw_ply_stats(int lives, int score, int mfuel, int cfuel)
{
    al_draw_filled_rectangle(0, 0, 800, 30, black);
    al_draw_textf(font18, green255, 5 , 5, 
        ALLEGRO_ALIGN_LEFT, "lives: %d", lives);
    al_draw_textf(font18, green255, 350 , 5, 
        ALLEGRO_ALIGN_LEFT, "score: %d", score);
    al_draw_text(font18, green255, 630, 5, 
        ALLEGRO_ALIGN_LEFT, "fuel:");
    al_draw_rectangle(693, 5, 798, 25, green255, 1);
    al_draw_filled_rectangle(695, 7, 695 + cfuel, 22, green255);
    al_draw_line(0, 30, 800, 30, green255, 1);
}

void drw_hrc(int x, int y)
{
    al_draw_rectangle(x - 17, y + 2, x + 14, y + 37, green255, 1);
}

/* Visar vilken nivå man kommit till*/
void drw_lvl(int n, int h, int w)
{
    al_draw_textf(font18, green255, w / 2 , h / 2, 
        ALLEGRO_ALIGN_CENTRE, "level: %d", n);
}

/* Ritar upp spelaren */
void drw_ply(int x, int y)
{
    /* Jag utgår från mitten av objektet när jag ritar */
    al_draw_line(x + 20, y - 7, x -10, y - 10, green255, 1);
    al_draw_line(x - 10, y - 10, x - 20, y + 10, green255, 1);
    al_draw_line(x - 20, y + 10, x + 20, y, green255, 1);
    al_draw_line(x + 20, y, x - 20, y - 10, green255, 1);
    al_draw_line(x - 20, y - 10, x - 10, y + 10, green255, 1);
    al_draw_line(x - 10, y + 10, x + 20, y + 7, green255, 1);  
    al_draw_circle(x - 7, y, 3, green255, 1);
    
    /* Ritar ut bounding box 
    al_draw_rectangle(x - 20, y - 10, x + 20, y + 10, 
        al_map_rgb(255,0,255),1);*/
}

/* Ritar alla linjer */
void drw_lne(int x1, int y1, int x2, int y2)
{
    al_draw_line(x1, y1, x2, y2, green255, 1);
}

/* Ritar en kanon kula */
void drw_com(int x, int y)
{
    al_draw_filled_triangle(x - 5, y, x, y - 35, x + 5, y, green50);
    al_draw_filled_triangle(x - 5, y, x, y - 20, x + 5, y, green125);
    al_draw_filled_ellipse(x, y, 5,10, green255);
    
    /* Ritar ut bounding box 
    al_draw_rectangle(x - 5, y - 10, x + 5, y + 10, 
        al_map_rgb(255, 0, 255),1);*/
}

/* Ritar en kanon kula */
void drw_cba(int x, int y)
{
    al_draw_filled_circle(x, y, 3, green255);
}

/* Ritar en explosion */
void drw_xpl(int x, int y, int radius)
{
    int offset = 0; 
    
    offset = (rand() % 10) + 1;
    al_draw_filled_circle(x + offset, y + offset, radius, black);
    al_draw_circle(x + offset, y + offset, radius, green125, 3);
}

/* Ritar en misisl */
void drw_mis(int x, int y, int fired)
{
    if(fired) {
        al_draw_line(x, y - 20, x - 10, y + 20, green255, 1);
        al_draw_line(x - 10, y + 20, x - 10, y, green255, 1);
        al_draw_line(x - 10, y, x, y + 15, green255, 1);
        al_draw_line(x, y + 15, x + 11, y, green255, 1);
        al_draw_line(x + 11, y, x + 10, y + 20, green255, 1);
        al_draw_line(x + 10, y + 20, x, y - 20, green255, 1);
        al_draw_line(x, y + 17, x, y + 27, green125, 1);
        al_draw_line(x, y + 17, x, y + 23, green255, 1);
    } else {
        al_draw_line(x, y - 20, x - 10, y + 20, green255, 1);
        al_draw_line(x - 10, y + 20, x - 10, y, green255, 1);
        al_draw_line(x - 10, y, x, y + 15, green255, 1);
        al_draw_line(x, y + 15, x + 11, y, green255, 1);
        al_draw_line(x + 11, y, x + 10, y + 20, green255, 1);
        al_draw_line(x + 10, y + 20, x, y - 20, green255, 1);
    }
}

/* Ritar spelar bomb */
void drw_bom(int x, int y)
{
    al_draw_ellipse(x, y + 3 ,5 ,7 , green255, 1);
    al_draw_line(x - 1, y - 5, x - 3, y - 10, green255, 1);
    al_draw_line(x + 1, y - 5, x + 3, y - 10, green255, 1);
    al_draw_line(x - 5, y + 5, x + 5, y + 5, green255, 1);
    
    /* Ritar ut bounding box 
    al_draw_rectangle(x - 5, y - 10, x + 5, y + 10, 
        al_map_rgb(255, 0, 255),1);*/
}

/* Ritar spelar skott */
void drw_bul(int x, int y)
{
    al_draw_line(x, y, x - 10, y, green50, 1);
    al_draw_filled_circle(x, y, 2, green125);
    al_draw_pixel(x, y, green255);
    
    /* Ritar ut bounding box */
    //al_draw_rectangle(x - 5, y - 5, x + 5, y + 5, al_map_rgb(255, 0, 255),1);
}

/* Ritar lasrar */
void drw_las(int x, int y)
{
    al_draw_line(x - 10, y, x + 10, y, green50, 1);
    al_draw_line(x - 9, y, x + 5, y, green125, 1);
    al_draw_line(x - 8, y, x, y, green255, 1);
}

/* Ritar en byggnad */
void drw_ful(int x, int y)
{
            al_draw_ellipse(x, y - 5, 20, 15, green255, 1);
            al_draw_line(x - 10, y + 8, x - 15, y + 20, green255, 1);
            al_draw_line(x + 10, y + 8, x + 15, y + 20, green255, 1);
            al_draw_line(x - 5, y - 13, x - 5, y + 5, green255, 1);
            al_draw_line(x - 5, y - 13, x + 5, y - 13, green255, 1);
            al_draw_line(x - 5, y - 3, x, y - 3, green255, 1);

            
            /* Ritar bounding box 
            al_draw_filled_rectangle(x - 20, y - 20,x + 20, y + 20, 
                al_map_rgba_f(.6,0,.6,.6));*/
}

/* Ritar kanon */
void drw_can(int x, int y, int live)
{
    if(live) {
        al_draw_rectangle(x - 20, y - 15, x + 20, y + 20, green255, 1);
        al_draw_line(x, y - 15, x, y - 20, green255, 1);
    }
}

/* Ritar alien */
void drw_aln(int x, int y, int live)
{
    if(live) {
        al_draw_ellipse(x, y - 13, 20, 7, green255, 1);
        al_draw_circle(x - 17, y + 17, 3, green255, 1);
        al_draw_circle(x + 17, y + 17, 3, green255, 1);
        al_draw_circle(x, y + 17, 3, green255, 1);
        al_draw_line(x, y - 6, x, y + 15, green255, 1);
        al_draw_line(x, y + 10, x - 10, y, green255, 1);
        al_draw_line(x, y + 10, x + 10, y, green255, 1);
        al_draw_line(x - 10, y, x - 17, y + 15, green255, 1);
        al_draw_line(x + 10, y, x + 17, y + 15, green255, 1);
        
        /* Ritar bb
        al_draw_filled_rectangle(x - 20, y - 20, x + 20,y + 20, 
            al_map_rgba_f(.6,0,.6,.6)); */
    }
}

/* Ritar ufo */
void drw_ufo(int x, int y)
{
    al_draw_line(x + 20, y, x + 15, y + 10, green255, 1);
    al_draw_line(x + 15, y + 10, x - 15, y + 10, green255, 1);
    al_draw_line(x - 15, y + 10, x - 20, y, green255, 1);
    al_draw_line(x - 20, y, x - 15, y - 10, green255, 1);
    al_draw_line(x - 15, y - 10, x + 15, y - 10, green255, 1);
    al_draw_line(x + 15, y - 10, x + 20, y, green255, 1);
    al_draw_line(x - 20, y, x + 20, y, green255, 1);
    
    /* Ritar bounding box 
    al_draw_filled_rectangle(x - 20, y - 10,x + 20, y + 10, 
        al_map_rgba_f(.6,0,.6,.6));*/
}

/* Ritar byggnad */
void drw_bld(int x, int y)
{
    al_draw_rectangle(x - 20, y - 15, x + 20, y + 15, al_map_rgb(0, 255 ,0), 1);
    al_draw_line(x - 21, y - 15, x - 16, y - 20, green255, 1);
    al_draw_line(x + 20, y - 15, x + 15, y - 20, green255, 1);
    al_draw_line(x - 16, y - 20, x + 15, y - 20, green255, 1);
    al_draw_rectangle(x - 15, y - 5, x - 7, y + 5, green255, 1);
    al_draw_rectangle(x + 7, y - 5, x + 15, y + 5, green255, 1);
    al_draw_rectangle(x - 3, y + 5, x + 3, y + 15, green255, 1);
    al_draw_line(x - 10, y + 15, x - 15, y + 20, green255, 1);
    al_draw_line(x + 10, y + 15, x + 15, y + 20, green255, 1);            
    
    /* Ritar ut bounding box 
    al_draw_rectangle(x - 20, y - 20, x + 20, y + 20, 
        al_map_rgb(255, 0, 255),1); */
}