/*
*===========================================================================
*
*  Title:  Main.cpp
*  Author: Fredrik Beckman
*
*===========================================================================
*/

/*
*--------------------------------------------------------------------------
*- - - - - - - - - - - - - - -Comments- - - - - - - - - - - - - - - - - - -
*--------------------------------------------------------------------------
*/

/*
****************************************************************************
** Runtime include files
****************************************************************************
*/

#include <stdio.h>
#include <math.h>
#include <windows.h>
#pragma comment(lib,"ws2_32.lib")

/*
****************************************************************************
** Allegro include files
****************************************************************************
*/

#include "allegro5/allegro.h"
#include "allegro5/allegro_image.h"
#include "allegro5/allegro_native_dialog.h"
#include <allegro5/allegro_font.h>
#include <allegro5/allegro_ttf.h>
#include <allegro5/allegro_audio.h>
#include <allegro5/allegro_acodec.h>

/*
****************************************************************************
** Global include files
****************************************************************************
*/

/*
****************************************************************************
** Public include files
****************************************************************************
*/

/*
****************************************************************************
** Private include files
****************************************************************************
*/

#include "Main_loc.h"

/*
****************************************************************************
** Other include files
****************************************************************************
*/

/*
*--------------------------------------------------------------------------
*- - - - - - - - - - - - - - - GLOBAL VARIABLES - - - - - - - - - - - - - -
*--------------------------------------------------------------------------
*/

/*
*--------------------------------------------------------------------------
*- - - - - - - - - - - - - - LOCAL STATIC VARIABLES - - - - - - - - - - - -
*--------------------------------------------------------------------------
*/

static int
    level = 0;

/*
*--------------------------------------------------------------------------
*- - - - - - - - - - - - - - - - LOCAL CONSTANTS - - - - - - - - - - - - - 
*--------------------------------------------------------------------------
*/

static const float 
  FPS = 60,
  pi  = 3.14159265,
  TANK_SPEED_P = 1.0,
  TANK_SPEED_E = 0.70,
  BULLET_SPEED = 3;

static const int 
  SCREEN_W = 800,
  SCREEN_H = 600,
  GAME_AREA_W = 625,
  GAME_AREA_H = 525,
  GAME_AREA_OFFSX = 35,
  GAME_AREA_OFFSY = 45,
  GAME_TILE_W = 25,
  GAME_TILE_H = 25,
  TANK_SIZE = 26,
  TANK_OFFS_X = 12,
  TANK_OFFS_Y = 12,
  BULLET_OFFS_X = 2,
  BULLET_OFFS_Y = 2,
  BULLET_COUNT = 60,
  INFO_TEXT_X = 670,
  PLAYER_TEXT_Y = 60,
  ENEMY_TEXT_Y = 150,
  ENEMY_DIST_OFFSET = 25,
  ENEMY_FIRE_OFFSET = 200,
  TANK_HIT_DEACTIVATED = 120,
  TILES_W = (GAME_AREA_W / GAME_TILE_W), /* = 25 */
  TILES_H = (GAME_AREA_H / GAME_TILE_H), /* = 21 */
  OBJ_TYPE_PLTANK = 0,
  OBJ_TYPE_ENTANK = 1,
  OBJ_TYPE_PLBULLET = 10,
  OBJ_TYPE_ENBULLET = 11,
  OBJ_TYPE_WALL = 90,
  OBJ_TYPE_FLOOR = 91;
  

static const int tileMap[5][TILES_H][TILES_W] =
{
  { /* Level 1 */
  /* 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24              */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Row 00 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 01 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 02 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 03 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 04 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 05 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 06 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 07 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0 }, /* Row 08 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 09 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 10 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 11 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 12 */
    { 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 13 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 14 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 15 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 16 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 17 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 18 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 19 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }  /* Row 20 */
  },
  { /* Level 2 */
  /* 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24              */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Row 00 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 01 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 02 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 03 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 04 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 05 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 06 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 07 */
    { 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 08 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 09 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 0 }, /* Row 10 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 11 */
    { 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 12 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 13 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 14 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 15 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 16 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 17 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 18 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 19 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }  /* Row 20 */
  },
  { /* Level 3 */
  /* 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24              */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Row 00 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 01 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 02 */
    { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0 }, /* Row 03 */
    { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0 }, /* Row 04 */
    { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0 }, /* Row 05 */
    { 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 06 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 07 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0 }, /* Row 08 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 09 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 10 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 11 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 12 */
    { 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 13 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 14 */
    { 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0 }, /* Row 15 */
    { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 16 */
    { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 17 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 18 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 19 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }  /* Row 20 */
  },
  { /* Level 4 */
  /* 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24              */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Row 00 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 01 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 02 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 03 */
    { 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 04 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 05 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 06 */
    { 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 07 */
    { 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0 }, /* Row 08 */
    { 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 09 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 10 */
    { 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 11 */
    { 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 12 */
    { 0, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 1, 0 }, /* Row 13 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 14 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 15 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 16 */
    { 0, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0 }, /* Row 17 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 18 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 19 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }  /* Row 20 */
  },
  { /* Level 5 */
  /* 00 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24              */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }, /* Row 00 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 01 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 02 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0 }, /* Row 03 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1, 0 }, /* Row 04 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0 }, /* Row 05 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0 }, /* Row 06 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 0 }, /* Row 07 */
    { 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 0 }, /* Row 08 */
    { 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 09 */
    { 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 10 */
    { 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 0 }, /* Row 11 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 12 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 13 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 14 */
    { 0, 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 1, 0, 1, 1, 1, 1, 1, 0 }, /* Row 15 */
    { 0, 1, 1, 1, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 0, 1, 1, 1, 1, 1, 0 }, /* Row 16 */
    { 0, 1, 1, 0, 0, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 0 }, /* Row 17 */
    { 0, 1, 1, 1, 0, 1, 0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 0 }, /* Row 18 */
    { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, /* Row 19 */
    { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }  /* Row 20 */
  }
};

/*
*--------------------------------------------------------------------------
*- - - - - - - - - - - - - LOCAL FUNCTION PROTOTYPING  - - - - - - - - - -
*--------------------------------------------------------------------------
*/

static bool 
  CollDetectTanks(objCoord_st *objCoord1_p, objCoord_st *objCoord2_p);

static bool 
  CollDetectObject(objectData_st *object_p);

static void 
  ComputeObjectTile(objCoord_st *objCoord_p, tileCoord_st *tileCoord_p);
  
static void
  ComputeObjectPix(tileCoord_st *tileCoord_p, objCoord_st *objCoord_p);

static bool 
  CollDetectShot(objCoord_st *shot_p, objCoord_st *tank_p);

static bool
  CalcWaypoint(objCoord_st *tank1_p, objCoord_st *tank2_p, objCoord_st *wayPoint_p);

static bool
  CalcFreePassage(objCoord_st *tank1_p, objCoord_st *tank2_p);

static bool 
  MoveTank(objectData_st *tank1_p, objectData_st *tank2_p, bool *key_p);

static bool 
  SetEnemyDirectionRight(objectData_st *tank1_p, objCoord_st *tank2_p);

static bool 
  SetEnemyDirectionLeft(objectData_st *tank1_p, objCoord_st *tank2_p);

static bool 
  SetEnemyDirectionFwd(objCoord_st *tank1_p, objCoord_st *tank2_p);

static bool 
  SetEnemyFire(objectData_st *tank1_p, objectData_st *tank2_p);

static bool 
  InitTiles(ALLEGRO_BITMAP *tiles_p[TILES_H][TILES_W], ALLEGRO_DISPLAY *display_p);

static void 
  DestroyTiles(ALLEGRO_BITMAP *tiles_p[TILES_H][TILES_W]);

static void 
  DrawTiles(ALLEGRO_BITMAP *tiles_p[TILES_H][TILES_W], ALLEGRO_DISPLAY *display_p);

static void 
  DestroyAll(ALLEGRO_BITMAP      *playerShot_p,
             ALLEGRO_BITMAP      *playerTank_p,
             ALLEGRO_BITMAP      *enemyShot_p,
             ALLEGRO_BITMAP      *enemyTank_p,
             ALLEGRO_FONT        *font_p,
             ALLEGRO_SAMPLE      *explosion_p,
             ALLEGRO_SAMPLE      *fire_p,
             ALLEGRO_DISPLAY     *display_p,
             ALLEGRO_EVENT_QUEUE *event_queue_p,
             ALLEGRO_TIMER       *timer_p);

/*
*--------------------------------------------------------------------------
*- - - - - - - - - - - - - - - GLOBAL FUNCTIONS - - - - - - - - - - - - - -
*--------------------------------------------------------------------------
*/

/*
===========================================================================
  Main
===========================================================================
Description:
  Main loop.

Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

int 
  main(int argc, char **argv)
{
  ALLEGRO_BITMAP 
    *tiles_p [TILES_H][TILES_W];
    
  ALLEGRO_FONT 
    *font_p = NULL;

  ALLEGRO_SAMPLE 
    *explosion_p = NULL,
    *fire_p = NULL;

  ALLEGRO_SAMPLE_ID 
    en_explosion_id,
    en_fire_id,
    pl_explosion_id,
    pl_fire_id;
    
  ALLEGRO_DISPLAY 
    *display_p = NULL;

  ALLEGRO_EVENT_QUEUE 
    *event_queue_p = NULL;

  ALLEGRO_EVENT 
    ev;

  ALLEGRO_TIMER 
    *timer_p = NULL;

  bool 
    redraw = true,
    key[5] = { false, false, false, false, false },
    enKey[5] = { false, false, false, false, false },
    doexit = false;

  char
    tmpText[255];
    
  int
    oldLevel;

  objCoord_st
    wayPoint;

  objectData_st
    playerShot = 
    {
      NULL,   /* ALLEGRO_BITMAP *bitmap */
      {
        0.0,    /* float x                */
        0.0     /* float y                */
      },
      0.0,    /* float angle            */
      0.0,    /* float angle            */
      BULLET_SPEED,    /* float speed            */
      0,      /* int cnt                */
      0,      /* int fireCnt            */
      0,      /* int points             */
      10,     /* int type               */
      false,  /* bool active            */
      false,  /* bool hit               */
      false
    },
    
    playerTank = 
    {
      NULL,                                        /* ALLEGRO_BITMAP *bitmap */
      {
        (SCREEN_W / 2.0 - TANK_SIZE / 2.0),          /* float x                */
        (4.0 * (SCREEN_H / 5.0) - TANK_SIZE / 2.0)  /* float y                */
      },
      0.0,                                         /* float angle            */
      0.0,                                         /* float angle            */
      TANK_SPEED_P,                                         /* float speed            */
      0,                                           /* int cnt                */
      0,                                           /* int fireCnt            */
      0,                                           /* int points             */
      0,                                           /* int type               */
      true,                                        /* bool active            */
      false,                                       /* bool hit               */
      false
    },

    enemyShot  = 
    {
      NULL,   /* ALLEGRO_BITMAP *bitmap */
      {
        0.0,    /* float x                */
        0.0    /* float y                */
      },
      0.0,    /* float angle            */
      0.0,    /* float angle            */
      BULLET_SPEED,    /* float speed            */
      0,      /* int cnt                */
      0,      /* int cnt                */
      0,      /* int points             */
      11,     /* int type               */
      false,  /* bool active            */ 
      false,  /* bool hit               */
      false
    },
    enemyTank  = 
    {
      NULL,                                       /* ALLEGRO_BITMAP *bitmap */
      {
        (SCREEN_W / 2.0 - TANK_SIZE / 2.0),         /* float x                */
        (1.0 * (SCREEN_H / 5.0) - TANK_SIZE / 2.0) /* float y                */
      },
      pi,                                         /* float angle            */
      pi,                                         /* float angle            */
      TANK_SPEED_E,                                        /* float speed            */
      0,                                          /* int cnt                */
      0,                                          /* int cnt                */
      0,                                          /* int points             */
      1,                                          /* int type               */
      true,                                       /* bool active            */
      false,                                      /* bool hit               */
      false
    };
    
  fprintf(stderr, "Starting!\n");

  /*******************************************/
  /* Init Allegro                            */
  if(!al_init())
  {
    fprintf(stderr, "Failed to initialize allegro!\n");
  }

  /*******************************************/
  /* Create timer                            */
  timer_p = al_create_timer(1.0 / FPS);
  if(!timer_p)
  {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to create timer!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);
                               
    return 0;
  }

  /*******************************************/
  /* Init image addon                        */
  if(!al_init_image_addon()) {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to initialize al_init_image_addon!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);

    return 0;
  }

  /*******************************************/
  /* Start keyboard detection                */
  if(!al_install_keyboard()) {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to initialize the keyboard!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /*******************************************/
  /* Create display                          */
  display_p = al_create_display(SCREEN_W, SCREEN_H);
  if(!display_p)
  {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to create display!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /*******************************************/
  /* Text                                    */
  /* Create the info text                    */

  /* initialize the font addon */
  al_init_font_addon();
  
  /* initialize the ttf (True Type Font) addon */
  al_init_ttf_addon();

  font_p = al_load_ttf_font(".\\data\\pixlkrud.ttf", 18, 0 );

  if (!font_p){
    al_show_native_message_box(display_p, "Error", "Error", "Failed to load 'pixlkrud.ttf'!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /*******************************************/
  /* Background bitmap                       */
  /* Create bitmap picture background        */
  //backGround_p = al_load_bitmap(".\\data\\backGround.png");
  //if(!backGround_p) {
  //  al_show_native_message_box(display_p, "Error", "Error", "Failed to load image 'backGround.png'!",
  //                             NULL, ALLEGRO_MESSAGEBOX_ERROR);

  //  DestroyAll(backGround_p, playerShot.bitmap, playerTank.bitmap,
  //             enemyShot.bitmap, enemyTank.bitmap, font_p,
  //             explosion_p, fire_p, display_p,
  //             event_queue_p, timer_p);
  //  return 0;
  //}

  /*******************************************/
  /* Player bitmaps                          */
  /* Create bitmap picture player playerShot */
  playerShot.bitmap = al_load_bitmap(".\\data\\Bullet.png");
  if(!playerShot.bitmap) {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to load image 'Bullet.png'!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /* Create bitmap picture player tank */
  playerTank.bitmap = al_load_bitmap(".\\data\\TankBlack.png");
  if(!playerTank.bitmap) {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to load image 'TankBlack.png'!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /*******************************************/
  /* Enemy bitmaps                          */
  /* Create bitmap picture enemy playerShot */
  enemyShot.bitmap = al_load_bitmap(".\\data\\Bullet.png");
  if(!enemyShot.bitmap) {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to load image 'Bullet.png'!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /* Create bitmap picture enemy tank */
  enemyTank.bitmap = al_load_bitmap(".\\data\\TankRed.png");
  if(!enemyTank.bitmap) {
    al_show_native_message_box(display_p, "Error", "Error", "Failed to load image 'TankRed.png'!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /*******************************************/
  /* Create bitmap picture tiles */
  if (!InitTiles(tiles_p, display_p))
  {
    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }
  
  /*******************************************/
  if(!al_install_audio()){
    al_show_native_message_box(display_p, "Error", "Error", "Failed to initialize audio!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }
 
  if(!al_init_acodec_addon()){
    al_show_native_message_box(display_p, "Error", "Error", "Failed to initialize audio codecs!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }
 
  if (!al_reserve_samples(4)){
    al_show_native_message_box(display_p, "Error", "Error", "Failed to reserve samples!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }
 
  /*******************************************/
  fire_p = al_load_sample(".\\data\\Fire.wav");
 
  if (!fire_p){
     fprintf(stderr, "Audio clip sample not loaded!\n" ); 

    al_show_native_message_box(display_p, "Error", "Error", "Failed to initialize fire audio!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /*******************************************/
  explosion_p = al_load_sample(".\\data\\Explosion.wav");
 
  if (!explosion_p){
    al_show_native_message_box(display_p, "Error", "Error", "Failed to initialize explosion audio!",
                               NULL, ALLEGRO_MESSAGEBOX_ERROR);

    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /* Clear screen to white */
  al_set_target_bitmap(al_get_backbuffer(display_p));
  al_clear_to_color(al_map_rgb(255, 255, 255));
  al_flip_display();

  /* Create event queue */
  event_queue_p = al_create_event_queue();
  if(!event_queue_p)
  {
    DestroyAll(playerShot.bitmap, playerTank.bitmap,
               enemyShot.bitmap, enemyTank.bitmap, font_p,
               explosion_p, fire_p, display_p,
               event_queue_p, timer_p);
    return 0;
  }

  /* Display event */
  al_register_event_source(event_queue_p, al_get_display_event_source(display_p));

  /* Key event */
  al_register_event_source(event_queue_p, al_get_keyboard_event_source());

  /* Draw window area */
  al_set_target_backbuffer(display_p);
  al_clear_to_color(al_map_rgb(255, 255, 255));

  /* Draw text */
  al_draw_text(font_p, al_map_rgb(200, 0, 0), (SCREEN_W / 2), (SCREEN_H / 2), ALLEGRO_ALIGN_CENTRE, "Press fire when ready");

  al_flip_display();

  /* SPACE released */
  while (true)
  {
    al_wait_for_event(event_queue_p, &ev);
    if ((ev.type == ALLEGRO_EVENT_KEY_UP) && (ev.keyboard.keycode == ALLEGRO_KEY_SPACE))
    {
      break;
    }
  }
  
  /* Start timer */
  al_start_timer(timer_p);

  /* Timer event */
  al_register_event_source(event_queue_p, al_get_timer_event_source(timer_p));

  /*************/
  /* MAIN LOOP */
  
  fprintf(stderr, "Starting main loop\n");
  al_play_sample(explosion_p, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, NULL);

  oldLevel = level;
  
  while(doexit == false)
  {
    al_wait_for_event(event_queue_p, &ev);
    
    /*==========================================================================*/
    /* Timer event - check movement, collision etc                              */
    /*                                                                          */
    if(ev.type == ALLEGRO_EVENT_TIMER)
    {

      if (oldLevel != level)
      {
        /* Destroy old map */
        DestroyTiles(tiles_p);

        /* Create bitmap picture tiles */
        if (!InitTiles(tiles_p, display_p))
        {
          DestroyAll(playerShot.bitmap, playerTank.bitmap,
                     enemyShot.bitmap, enemyTank.bitmap, font_p,
                     explosion_p, fire_p, display_p,
                     event_queue_p, timer_p);
          return 0;
        }
        playerTank.coord.x = SCREEN_W / 2.0 - TANK_SIZE / 2.0;
        playerTank.coord.y = 4.0 * (SCREEN_H / 5.0) - TANK_SIZE / 2.0;

        enemyTank.coord.x = SCREEN_W / 2.0 - TANK_SIZE / 2.0;
        enemyTank.coord.y = 1.0 * (SCREEN_H / 5.0) - TANK_SIZE / 2.0;
  
      }

      oldLevel = level;

      /****************************************************************************/
      /* Handle enemy tank                                                        */
      /*                                                                          */
      /*                                                                          */

      enKey[KEY_LEFT]  = false;
      enKey[KEY_RIGHT]  = false;

      if (CalcFreePassage(&enemyTank.coord, &playerTank.coord) == true)
      {
        /* Enemy tank - checked if turn left */
        if (SetEnemyDirectionLeft(&enemyTank, &playerTank.coord))
        {
          enKey[KEY_LEFT]  = true;
          enKey[KEY_RIGHT]  = false;
        }
        /* Enemy tank - checked if turn right */
        else if (SetEnemyDirectionRight(&enemyTank, &playerTank.coord))
        {
          enKey[KEY_LEFT]  = false;
          enKey[KEY_RIGHT]  = true;
        }

        enKey[KEY_UP]    = SetEnemyDirectionFwd(&enemyTank.coord, &playerTank.coord);
        enKey[KEY_SPACE] = SetEnemyFire(&enemyTank, &playerTank);
      }
      else
      {
        if (CalcWaypoint(&enemyTank.coord, &playerTank.coord, &wayPoint) == true)
        {
          /* Enemy tank - checked if turn left */
          if (SetEnemyDirectionLeft(&enemyTank, &wayPoint))
          {
            enKey[KEY_LEFT]  = true;
            enKey[KEY_RIGHT]  = false;
          }
          /* Enemy tank - checked if turn right */
          else if (SetEnemyDirectionRight(&enemyTank, &wayPoint))
          {
            enKey[KEY_LEFT]  = false;
            enKey[KEY_RIGHT]  = true;
          }

          enKey[KEY_UP]    = SetEnemyDirectionFwd(&enemyTank.coord, &wayPoint);

        }

      }
      enemyTank.active  = MoveTank(&playerTank, &enemyTank,  &key[0]);

      /* Check if enemy FIRE */
      if (enKey[KEY_SPACE] && !enemyShot.active && enemyTank.active)
      {
        /* Shoot! */
        enemyShot.coord.x  = enemyTank.coord.x;
        enemyShot.coord.y  = enemyTank.coord.y;
        enemyShot.movAngle = enemyTank.movAngle;
        enemyShot.rotAngle = enemyTank.movAngle;
        enemyShot.active   = true;
        enemyShot.cnt      = 0;
        fprintf(stderr, "Enemy shoot! playerShot.cnt = %d\n", enemyShot.cnt);
        
        //al_stop_sample(&en_fire_id);
        al_play_sample(fire_p, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, &en_fire_id);
      }

      if (enemyShot.active && enemyShot.cnt < BULLET_COUNT)
      {
        /* Bullet's moving */
        enemyShot.coord.y -= enemyShot.speed * cos(enemyShot.movAngle);
        enemyShot.coord.x += enemyShot.speed * sin(enemyShot.movAngle);
        enemyShot.cnt += 1;
      }
      else if(enemyShot.active)
      {
        /* Bullet reached end */
        enemyShot.cnt = 0;
        enemyShot.active = false;
      }

      /* Collision detection player bullet / enemy tank */
      if (CollDetectShot(&enemyShot.coord, &playerTank.coord) && enemyShot.active)
      {
        /* Collision */
        fprintf(stderr, "Collision (enemy shot - player tank)!\n\n");

        al_stop_sample(&en_fire_id);
        al_play_sample(explosion_p, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, &en_explosion_id);

        enemyShot.active = false;
        enemyTank.active = false;
        enemyTank.points += 1;
        
        playerTank.hit = true;
        playerTank.active = false;
        playerTank.movAngle = enemyShot.movAngle;
        playerTank.speed = BULLET_SPEED;
      }

      /* Collision detection bullet outer walls */
      if (CollDetectObject(&enemyShot) == true)
      {
        enemyShot.active = false;
      }
      
      /* Collision detection tank outer walls */
      (void) CollDetectObject(&enemyTank);
      
      /****************************************************************************/
      /* Handle player tank                                                       */
      /*                                                                          */
      /*                                                                          */

      playerTank.active = MoveTank(&enemyTank,  &playerTank, &enKey[0]);
      
      /* Check if player FIRE */
      if (key[KEY_SPACE] && !playerShot.active && playerTank.active)
      {
        /* Shoot! */
        playerShot.coord.x        = playerTank.coord.x;
        playerShot.coord.y        = playerTank.coord.y;
        playerShot.movAngle = playerTank.movAngle;
        playerShot.rotAngle = playerShot.movAngle;
        playerShot.active   = true;
        playerShot.cnt      = 0;
        fprintf(stderr, "Player shoot! playerShot.cnt = %d\n", playerShot.cnt);
        
        //al_stop_sample(&pl_fire_id);
        al_play_sample(fire_p, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, &pl_fire_id);
      }

      if (playerShot.active && playerShot.cnt < BULLET_COUNT)
      {
        /* Bullet's moving */
        playerShot.coord.y -= playerShot.speed * cos(playerShot.movAngle);
        playerShot.coord.x += playerShot.speed * sin(playerShot.movAngle);
        playerShot.cnt += 1;
      }
      else if(playerShot.active)
      {
        /* Bullet reached end */
        playerShot.cnt = 0;
        playerShot.active = false;
      }

      /* Collision detection player bullet / enemy tank */
      if (CollDetectShot(&playerShot.coord, &enemyTank.coord) && playerShot.active)
      {
        /* Collision */
        fprintf(stderr, "Collision (player shot - enemy tank)!\n\n");

        al_stop_sample(&pl_fire_id);
        al_play_sample(explosion_p, 1.0, 0.0, 1.0, ALLEGRO_PLAYMODE_ONCE, &pl_explosion_id);

        playerShot.active = false;
        playerTank.active = false;
        playerTank.points += 1;

        if (playerTank.points % 5 == 0)
        {
          level++;
          if (level > 5)
          {
            level = 5;
          }
        }
        
        enemyTank.hit = true;
        enemyTank.active = false;
        enemyTank.movAngle = playerShot.movAngle;
        enemyTank.speed = BULLET_SPEED;
      }
      
      /* Collision detection bullet outer walls */
      if (CollDetectObject(&playerShot) == true)
      {
        playerShot.active = false;
      }
      
      /* Collision detection outer walls (Y) */
      (void) CollDetectObject(&playerTank);

      redraw = true;
    }

    /*==========================================================================*/
    /* Close window event - exit main loop                                      */
    /*                                                                          */
    else if(ev.type == ALLEGRO_EVENT_DISPLAY_CLOSE)
    {
      doexit = true;
    }

    /*==========================================================================*/
    /* Keyboard key down event - check which key pressed                        */
    /*                                                                          */
    else if(ev.type == ALLEGRO_EVENT_KEY_DOWN) 
    {
      switch(ev.keyboard.keycode)
      {
        case ALLEGRO_KEY_UP:
          key[KEY_UP] = true;
          playerTank.reverse = false;
          break;

        case ALLEGRO_KEY_DOWN:
          key[KEY_DOWN] = true;
          playerTank.reverse = true;
          break;

        case ALLEGRO_KEY_LEFT: 
          key[KEY_LEFT] = true;
          break;

        case ALLEGRO_KEY_RIGHT:
          key[KEY_RIGHT] = true;
          break;

        case ALLEGRO_KEY_SPACE:
          key[KEY_SPACE] = true;
          break;

        case ALLEGRO_KEY_ESCAPE:
          doexit = true;
          break;
      }
    }

    /*==========================================================================*/
    /* Keyboard key up event - check which key released                         */
    /*                                                                          */
    else if(ev.type == ALLEGRO_EVENT_KEY_UP)
    {
      switch(ev.keyboard.keycode)
      {
        case ALLEGRO_KEY_UP:
          key[KEY_UP] = false;
          break;

        case ALLEGRO_KEY_DOWN:
          key[KEY_DOWN] = false;
          playerTank.reverse = false;
          break;

        case ALLEGRO_KEY_LEFT: 
          key[KEY_LEFT] = false;
          break;

        case ALLEGRO_KEY_RIGHT:
          key[KEY_RIGHT] = false;
          break;

        case ALLEGRO_KEY_SPACE:
          key[KEY_SPACE] = false;
          break;

        case ALLEGRO_KEY_ESCAPE:
          doexit = false;
          break;
      }
    }

    /*==========================================================================*/
    /* Time to redraw game area                                                 */
    /*                                                                          */
    if(redraw && al_is_event_queue_empty(event_queue_p))
    {
      redraw = false;

      /* Draw window area */
      al_set_target_backbuffer(display_p);
      al_clear_to_color(al_map_rgb(255, 255, 255));

      /* Draw text */
      al_draw_text(font_p, al_map_rgb(200, 0, 0), (SCREEN_W / 2), (GAME_AREA_OFFSY / 2), ALLEGRO_ALIGN_CENTRE, "T.A.N.K.S");

      al_draw_text(font_p, al_map_rgb(200, 0, 0), INFO_TEXT_X, PLAYER_TEXT_Y, ALLEGRO_ALIGN_LEFT, "PLAYER");
      sprintf(tmpText, "%d", playerTank.points);
      al_draw_text(font_p, al_map_rgb(200, 0, 0), INFO_TEXT_X, PLAYER_TEXT_Y + al_get_font_line_height(font_p), ALLEGRO_ALIGN_LEFT, tmpText);

      al_draw_text(font_p, al_map_rgb(200, 0, 0), INFO_TEXT_X, ENEMY_TEXT_Y, ALLEGRO_ALIGN_LEFT, "ENEMY");
      sprintf(tmpText, "%d", enemyTank.points);
      al_draw_text(font_p, al_map_rgb(200, 0, 0), INFO_TEXT_X, ENEMY_TEXT_Y + al_get_font_line_height(font_p), ALLEGRO_ALIGN_LEFT, tmpText);

      /* Draw background */
      (void) DrawTiles(tiles_p, display_p);

      /* Draw player */
      al_draw_rotated_bitmap(playerTank.bitmap, TANK_OFFS_X, TANK_OFFS_Y, playerTank.coord.x, playerTank.coord.y, playerTank.rotAngle, 0);
      if (playerShot.active)
      {
        al_draw_rotated_bitmap(playerShot.bitmap, BULLET_OFFS_X, BULLET_OFFS_Y, playerShot.coord.x, playerShot.coord.y, playerShot.rotAngle, 0);
      }
      
      /* Draw enemy */
      al_draw_rotated_bitmap(enemyTank.bitmap, TANK_OFFS_X, TANK_OFFS_Y, enemyTank.coord.x, enemyTank.coord.y, enemyTank.rotAngle, 0);
      if (enemyShot.active)
      {
        al_draw_rotated_bitmap(enemyShot.bitmap, BULLET_OFFS_X, BULLET_OFFS_Y, enemyShot.coord.x, enemyShot.coord.y, enemyShot.rotAngle, 0);
      }
     
     al_flip_display();
    }
  }

  /* Loop exit, program ending, release event, bitmaps, etc */
  DestroyAll(playerShot.bitmap, playerTank.bitmap,
             enemyShot.bitmap, enemyTank.bitmap, font_p,
             explosion_p, fire_p, display_p,
             event_queue_p, timer_p);
  DestroyTiles(tiles_p);
  
  al_uninstall_system();

  return 0;
}

/*
===========================================================================
  CollDetectTanks
===========================================================================
Description:
  Check if tanks collided with each other

Parameters:
  -
  
Return value:
  True if collision detected
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool 
  CollDetectTanks(objCoord_st *objCoord1_p, objCoord_st *objCoord2_p)
{
  bool
    result;
  float
    distance;

	distance = sqrt(pow(fabs(objCoord2_p->x - objCoord1_p->x), 2) + pow(fabs(objCoord2_p->y - objCoord1_p->y), 2));
  result = distance <= 2 * TANK_OFFS_X;
  return (result);
}
  
/*
===========================================================================
  CollDetectObject
===========================================================================
Description:
  Check if tanks collided with objects 

Parameters:
  -
  
Return value:
  True if collision detected
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool 
  CollDetectObject(objectData_st *object_p)
{
  int
    offsetY = 0,
    offsetX = 0;
  bool
    dn = false,   /* Check down-direction active */
    up = false,   /* Check up-direction active */
    lt = false,   /* Check left-direction active */
    rt = false,   /* Check right-direction active */
    result = false,
    done = false;
  tileCoord_st 
    tileCoord;
  objCoord_st 
    objCoord;
  float
    angle;

  if ((object_p->type == 0) ||(object_p->type == 1))
  {
    offsetY = TANK_OFFS_Y;
    offsetX = TANK_OFFS_X;
  }
  else if (((object_p->type == 10) ||(object_p->type == 11)) && (object_p->active == true))
  {
    offsetY = BULLET_OFFS_Y;
    offsetX = BULLET_OFFS_X;
  }

  /* If object is moving backwards... */
  angle = object_p->movAngle;
  if (object_p->reverse == true)
  {
    if (angle <= 0)
    {
      angle += pi;
    }
    else
    {
      angle -= pi;
    }
  }
  
  /* If object->angle:
     -pi   to -pi/2 : Check DOWN and LEFT  tiles
     -pi/2 to 0     : Check UP   and LEFT  tiles
     0     to pi/2  : Check UP   and RIGHT tiles
     pi/2  to pi    : Check DOWN and RIGHT tiles
  */
  
  if ((angle < (-pi / 2)) || (angle > (pi / 2)))
  {
    /* Current direction is down */
    dn = true;

    /* Check left side */
    objCoord.x = object_p->coord.x - offsetX;
    objCoord.y = object_p->coord.y;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y + 1][tileCoord.x] == 0)
    {
      /* Check that not Y-coord will cross limit from above */
      if (object_p->coord.y > ((tileCoord.y + 1) * GAME_TILE_H + GAME_AREA_OFFSY - offsetY - 1))
      {
        object_p->coord.y = (tileCoord.y + 1) * GAME_TILE_H + GAME_AREA_OFFSY - offsetY - 1;
        result = true;
      }
    }

    /* Check right side */
    objCoord.x = object_p->coord.x + offsetX;
    objCoord.y = object_p->coord.y;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y + 1][tileCoord.x] == 0)
    {
      /* Check that not Y-coord will cross limit from above */
      if (object_p->coord.y > ((tileCoord.y + 1) * GAME_TILE_H + GAME_AREA_OFFSY - offsetY - 1))
      {
        object_p->coord.y = (tileCoord.y + 1) * GAME_TILE_H + GAME_AREA_OFFSY - offsetY - 1;
        result = true;
      }
    }
  }
  else if ((angle > (-pi / 2)) && (angle < (pi / 2)))
  {
    /* Current direction is up */
    up = true;

    /* Check left side */
    objCoord.x = object_p->coord.x - offsetX;
    objCoord.y = object_p->coord.y;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y - 1][tileCoord.x] == 0)
    {
      /* Check that not Y-coord will cross limit from below */
      if (object_p->coord.y < (tileCoord.y * GAME_TILE_H + GAME_AREA_OFFSY + offsetY))
      {
        object_p->coord.y = tileCoord.y * GAME_TILE_H + GAME_AREA_OFFSY + offsetY;
        result = true;
      }
    }

    /* Check right side */
    objCoord.x = object_p->coord.x + offsetX;
    objCoord.y = object_p->coord.y;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y - 1][tileCoord.x] == 0)
    {
      /* Check that not Y-coord will cross limit from below */
      if (object_p->coord.y < (tileCoord.y * GAME_TILE_H + GAME_AREA_OFFSY + offsetY))
      {
        object_p->coord.y = tileCoord.y * GAME_TILE_H + GAME_AREA_OFFSY + offsetY;
        result = true;
      }
    }
  }
    
  if ((angle < 0) && (angle > -pi))
  {
    /* Current direction is left */
    lt = true;

    /* Check upper side */
    objCoord.x = object_p->coord.x;
    objCoord.y = object_p->coord.y - offsetY;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y][tileCoord.x - 1] == 0)
    {
      /* Check that not X-coord will cross limit from right */
      if (object_p->coord.x < (tileCoord.x * GAME_TILE_W + GAME_AREA_OFFSX + offsetX + 1))
      {
        object_p->coord.x = tileCoord.x * GAME_TILE_W + GAME_AREA_OFFSX + offsetX + 1;
        result = true;
      }
    }

    /* Check lower side */
    objCoord.x = object_p->coord.x;
    objCoord.y = object_p->coord.y + offsetY;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y][tileCoord.x - 1] == 0)
    {
      /* Check that not X-coord will cross limit from right */
      if (object_p->coord.x < (tileCoord.x * GAME_TILE_W + GAME_AREA_OFFSX + offsetX + 1))
      {
        object_p->coord.x = tileCoord.x * GAME_TILE_W + GAME_AREA_OFFSX + offsetX + 1;
        result = true;
      }
    }
  }
  else if ((angle > 0) && (angle < pi))
  {
    /* Current direction is right */
    rt = true;
    
    /* Check upper side */
    objCoord.x = object_p->coord.x;
    objCoord.y = object_p->coord.y - offsetY;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y][tileCoord.x + 1] == 0)
    {
      /* Check that not X-coord will cross limit from left */
      if (object_p->coord.x > ((tileCoord.x + 1) * GAME_TILE_W + GAME_AREA_OFFSX - offsetX - 1))
      {
        object_p->coord.x = (tileCoord.x + 1) * GAME_TILE_W + GAME_AREA_OFFSX - offsetX - 1;
        result = true;
      }
    }
    
    /* Check lower side */
    objCoord.x = object_p->coord.x;
    objCoord.y = object_p->coord.y + offsetY;
    
    (void) ComputeObjectTile(&objCoord, &tileCoord);
    if (tileMap[level][tileCoord.y][tileCoord.x + 1] == 0)
    {
      /* Check that not X-coord will cross limit from left */
      if (object_p->coord.x > ((tileCoord.x + 1) * GAME_TILE_W + GAME_AREA_OFFSX - offsetX - 1))
      {
        object_p->coord.x = (tileCoord.x + 1) * GAME_TILE_W + GAME_AREA_OFFSX - offsetX - 1;
        result = true;
      }
    }
  }
  
  return (result);
}

/*
===========================================================================
  ComputeObjectTile
===========================================================================
Description:
  Check tile position for object

Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static void
  ComputeObjectTile(objCoord_st *objCoord_p, tileCoord_st *tileCoord_p)
{
  int
    offsetY = 0,
    offsetX = 0;
    
	tileCoord_p->x = (objCoord_p->x - GAME_AREA_OFFSX - offsetX) / GAME_TILE_W;
	tileCoord_p->y = (objCoord_p->y - GAME_AREA_OFFSY - offsetY) / GAME_TILE_H;
	
  return;
}

/*
===========================================================================
  ComputeObjectPix
===========================================================================
Description:
  Check pixel position for object

Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static void
  ComputeObjectPix(tileCoord_st *tileCoord_p, objCoord_st *objCoord_p)
{
  objCoord_p->x = tileCoord_p->x * GAME_TILE_W + GAME_AREA_OFFSX + TANK_OFFS_X;
  objCoord_p->y = tileCoord_p->y * GAME_TILE_H + GAME_AREA_OFFSY + TANK_OFFS_Y;
}

/*
===========================================================================
  CollDetectShot
===========================================================================
Description:
  Check if bullet collided with tank

Parameters:
  -
  
Return value:
  true if collision detected
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  CollDetectShot(objCoord_st *shot_p, objCoord_st *tank_p)
{
  bool
    result;
  float
    distance;

	distance = sqrt(pow(fabs(shot_p->x - tank_p->x), 2) + pow(fabs(shot_p->y - tank_p->y), 2));
  result = distance <= TANK_OFFS_X;
  return (result);

}

/*
===========================================================================
  CalcWaypoint
===========================================================================
Description:
  Calculate waypoint

Parameters:
  -
  
Return value:
  true if waypoint valid
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  CalcWaypoint(objCoord_st *tank1_p, objCoord_st *tank2_p, objCoord_st *wayPoint_p)
{
  tileCoord_st
    waypoint;
  //objCoord_st 
  //  tmpWayPoint;
  bool
    result = false,
    pass1,
    pass2;

  for (waypoint.y = 0; waypoint.y < TILES_H && result == false; waypoint.y++)
  {
    for (waypoint.x = 0; waypoint.x < TILES_W && result == false; waypoint.x++)
    {
      
      (void)ComputeObjectPix(&waypoint, wayPoint_p);
      pass1 = CalcFreePassage(tank1_p, wayPoint_p);
      pass2 = CalcFreePassage(wayPoint_p, tank2_p);

      if ((tileMap[level][waypoint.y][waypoint.x] == 1)
       && (pass1 == true)
       && (pass2 == true))
      {
        result = true;
        //printf("waypoint.x = %d; waypoint.y = %d\n", waypoint.x, waypoint.y);
      }
    }
  }

  return (result);
}

/*
===========================================================================
  CalcFreePassage
===========================================================================
Description:
  Calculate if free passage for bullet (1 waypoint)

Parameters:
  -
  
Return value:
  true if way clear
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  CalcFreePassage(objCoord_st *tank1_p, objCoord_st *tank2_p)
{
  bool
    result = true;
  int
    loopCnt;
  float
    curDist,
    k = 0;
  tileCoord_st 
    tileCoord1,
    tileCoord2,
    deltaCoord;
  objCoord_st 
    objCoord;

  /* Calculate tile coords for tank1 */
  objCoord.x = tank1_p->x;
  objCoord.y = tank1_p->y;
  (void) ComputeObjectTile(&objCoord, &tileCoord1);
  
  /* Calculate tile coords for tank2 */
  objCoord.x = tank2_p->x;
  objCoord.y = tank2_p->y;
  (void) ComputeObjectTile(&objCoord, &tileCoord2);
  
  /* Calculate delta (float) */
  deltaCoord.x = tileCoord2.x - tileCoord1.x;
  deltaCoord.y = tileCoord2.y - tileCoord1.y;
  
  if (abs(deltaCoord.x) > abs(deltaCoord.y))
  {
    /* Loop through distance regarding x */
    if ((deltaCoord.y != 0) && (deltaCoord.x != 0))
    {
      k = (float)deltaCoord.y / (float)deltaCoord.x;
    }
    loopCnt = 0;
    do
    {
      curDist = tileCoord1.y + (float)loopCnt * k;
      if (tileMap[level][(int) floor(curDist)][tileCoord1.x + loopCnt] == 0)
      {
        /* Wall found */
        result = false;
        break;
      }
      
      if (deltaCoord.x < 0)
      {
        loopCnt--;
      }
      else
      {
        loopCnt++;
      }
    }
    while (abs(loopCnt) < abs(deltaCoord.x));
  }
  else
  {
    /* Loop through distance regarding y */
    if ((deltaCoord.y != 0) && (deltaCoord.x != 0))
    {
      k = (float)deltaCoord.x / (float)deltaCoord.y;
    }
    
    loopCnt = 0;
    do
    {
      curDist = tileCoord1.x + (float)loopCnt * k;
      if (tileMap[level][tileCoord1.y + loopCnt][(int) floor(curDist)] == 0)
      {
        /* Wall found */
        result = false;
        break;
      }
      
      if (deltaCoord.y < 0)
      {
        loopCnt--;
      }
      else
      {
        loopCnt++;
      }
    }
    while (abs(loopCnt) < abs(deltaCoord.y));
  }
  return (result);
}

/*
===========================================================================
  MoveTank
===========================================================================
Description:
  Move tank in selected direction. Check if collision with other tank.

Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  MoveTank(objectData_st *tank1_p, objectData_st *tank2_p, bool *key_p)
{
  objCoord_st
    tmpCoord;
    
  if (!tank1_p->hit && tank1_p->active)
  {
    if (key_p[KEY_UP])
    {
      /* Forward */
      tmpCoord.y = tank1_p->coord.y - tank1_p->speed * cos(tank1_p->movAngle);
      tmpCoord.x = tank1_p->coord.x + tank1_p->speed * sin(tank1_p->movAngle);

      if (!CollDetectTanks(&tmpCoord, &tank2_p->coord))
      {
        tank1_p->coord.y = tmpCoord.y;
        tank1_p->coord.x = tmpCoord.x;
      }
    }

    if (key_p[KEY_DOWN])
    {
      /* Reverse */
      tmpCoord.y = tank1_p->coord.y + tank1_p->speed * cos(tank1_p->movAngle);
      tmpCoord.x = tank1_p->coord.x - tank1_p->speed * sin(tank1_p->movAngle);

      if (!CollDetectTanks(&tmpCoord, &tank2_p->coord))
      {
        tank1_p->coord.y = tmpCoord.y;
        tank1_p->coord.x = tmpCoord.x;
      }
    }
    

    if (key_p[KEY_LEFT])
    {
      /* Turn left */
      tank1_p->movAngle -= (pi / 60);
      if (tank1_p->movAngle <= -pi)
      {
        tank1_p->movAngle = pi;
      }
    }

    if (key_p[KEY_RIGHT])
    {
      /* Turn right */
      tank1_p->movAngle += (pi / 60);
      if (tank1_p->movAngle >= pi)
      {
        tank1_p->movAngle = -pi;
      }
    }
    tank1_p->rotAngle = tank1_p->movAngle;
  }
  
  if (tank1_p->hit && tank1_p->cnt < TANK_HIT_DEACTIVATED)
  {
    /* tank rotating */
    tank1_p->rotAngle += (pi / 9);
    if (tank1_p->rotAngle >= pi)
    {
      tank1_p->rotAngle = -pi;
    }
    
    /* tank moving */
    if (tank1_p->cnt < (TANK_HIT_DEACTIVATED / 2))
    {
      tank1_p->coord.y -= tank1_p->speed * cos(tank1_p->movAngle);
      tank1_p->coord.x += tank1_p->speed * sin(tank1_p->movAngle);
    }
    
    tank1_p->cnt += 1;
  }
  else if(tank1_p->hit)
  {
    /* enemyTank reached end */
    tank1_p->cnt = 0;
    tank1_p->active = true;
    tank1_p->hit = false;
    if (tank1_p->type == OBJ_TYPE_PLTANK)
    {
      tank1_p->speed = TANK_SPEED_P;
    }
    else if (tank1_p->type == OBJ_TYPE_ENTANK)
    {
      tank1_p->speed = TANK_SPEED_E;
    }
    tank1_p->movAngle = tank1_p->rotAngle;
  }
  return (!tank1_p->hit);
  
}
  
/*
===========================================================================
  SetEnemyDirectionRight
===========================================================================
Description:
  Check if enemy tank will turn right

Parameters:
  -
  
Return value:
  True if shorter to turn right than left
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  SetEnemyDirectionRight(objectData_st *tank1_p, objCoord_st *tank2_p)
{
  bool
    result;
    
  float
    angle;

	angle = atan2(tank1_p->coord.y - tank2_p->y, tank1_p->coord.x - tank2_p->x) - pi / 2;

  if (angle <= -pi)
  {
    angle += (2 * pi);
  }

  angle -= tank1_p->movAngle;
  result = ((angle > 0) && (angle < pi)) || (angle < -pi);
  
  //result &= CalcFreePassage(&tank1_p->coord, tank2_p);

  return (result);
}
  
/*
===========================================================================
  SetEnemyDirectionLeft
===========================================================================
Description:
  Check if enemy tank will turn left

Parameters:
  -
  
Return value:
  True if shorter to turn left than right
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  SetEnemyDirectionLeft(objectData_st *tank1_p, objCoord_st *tank2_p)
{
  bool
    result;
    
  float
    angle;

	angle = atan2(tank1_p->coord.y - tank2_p->y, tank1_p->coord.x - tank2_p->x) - pi / 2;

  if (angle <= -pi)
  {
    angle += (2 * pi);
  }

  angle -= tank1_p->movAngle;
  result = ((angle < 0) && (angle > -pi)) || (angle > pi);
  
  //result &= CalcFreePassage(&tank1_p->coord, tank2_p);

  return (result);
}
  
/*
===========================================================================
  SetEnemyDirectionFwd
===========================================================================
Description:
  Check if other tank is within shooting distance
  
Parameters:
  -
  
Return value:
  True if other tank is outside distance
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  SetEnemyDirectionFwd(objCoord_st *tank1_p, objCoord_st *tank2_p)
{
  bool
    result = false;
  float
    distance;

  distance = sqrt(pow(fabs(tank2_p->x - tank1_p->x), 2) + pow(fabs(tank2_p->y - tank1_p->y), 2));
  //result = distance > BULLET_COUNT * BULLET_SPEED - TANK_OFFS_X - ENEMY_DIST_OFFSET;
  result = distance > TANK_OFFS_X;

  //result &= CalcFreePassage(tank1_p, tank2_p);

  return (result);
}  

/*
===========================================================================
  SetEnemyFire
===========================================================================
Description:
  Check if other tank is within shooting distance and fire counter has
  reached end
  
Parameters:
  -
  
Return value:
  True if enemy will shoot
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  SetEnemyFire(objectData_st *tank1_p, objectData_st *tank2_p)
{
  bool
    result;
  int
    tmpInt;
  float
    distance;

  tank1_p->fireCnt += 1;
  
  distance = sqrt(pow(fabs(tank2_p->coord.x - tank1_p->coord.x), 2) + pow(fabs(tank2_p->coord.y - tank1_p->coord.y), 2));
  result = distance <= BULLET_COUNT * BULLET_SPEED - TANK_OFFS_X - ENEMY_DIST_OFFSET;
  
  tmpInt = tank1_p->points * 10;
  if (tmpInt > ENEMY_FIRE_OFFSET)
  {
    tmpInt = ENEMY_FIRE_OFFSET;
  }

  //result &= CalcFreePassage(&tank1_p->coord, &tank2_p->coord);
  result &= (tank1_p->fireCnt >= (ENEMY_FIRE_OFFSET - tmpInt));

  if (result == true)
  {
    tank1_p->fireCnt = 0;
  }
  
  return (result);
}    
  
/*
===========================================================================
  InitTiles
===========================================================================
Description:
  -
  
Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static bool
  InitTiles(ALLEGRO_BITMAP *tiles_p[TILES_H][TILES_W], ALLEGRO_DISPLAY *display_p)
{
  bool
    result;
  int
    loopCntX,
    loopCntY;
    
  result = true;
  for (loopCntY = 0; loopCntY < TILES_H; loopCntY++)
  {
    for (loopCntX = 0; loopCntX < TILES_W; loopCntX++)
    {
      /*******************************************/
      /* Tile bitmap                             */
      /* Create bitmap picture tiles             */
      if (tileMap[level][loopCntY][loopCntX] == 0)
      {
        tiles_p[loopCntY][loopCntX] = al_load_bitmap(".\\data\\TileWall.png");
      }
      else
      {
        tiles_p[loopCntY][loopCntX] = al_load_bitmap(".\\data\\TileFloor.png");
      }

      if(!tiles_p[loopCntY][loopCntX]) {
        al_show_native_message_box(display_p, "Error", "Error", "Failed to load image 'TileWall.png'!",
                                   NULL, ALLEGRO_MESSAGEBOX_ERROR);

        DestroyTiles(tiles_p);
        result = false;
      }
    }
  }
  return (result);
}    

/*
===========================================================================
  DestroyTiles
===========================================================================
Description:
  -
  
Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static void
  DestroyTiles(ALLEGRO_BITMAP *tiles_p[TILES_H][TILES_W])
{
  int
    loopCntX,
    loopCntY;
    
  for (loopCntY = 0; loopCntY < TILES_H; loopCntY++)
  {
    for (loopCntX = 0; loopCntX < TILES_W; loopCntX++)
    {
      al_destroy_bitmap(tiles_p[loopCntY][loopCntX]);
    }
  }
  return;
}    

/*
===========================================================================
  DrawTiles
===========================================================================
Description:
  -
  
Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static void
  DrawTiles(ALLEGRO_BITMAP *tiles_p[TILES_H][TILES_W], ALLEGRO_DISPLAY *display_p)
{
  int
    loopCntX,
    loopCntY;
  float
    x,
    y;
    
  x = GAME_AREA_OFFSX;
  y = GAME_AREA_OFFSY;
  
  for (loopCntY = 0; loopCntY < TILES_H; loopCntY++)
  {
    for (loopCntX = 0; loopCntX < TILES_W; loopCntX++)
    {
      /* Draw background */
      al_draw_bitmap(tiles_p[loopCntY][loopCntX], x, y, 0);
      x += GAME_TILE_W;
    }
    x = GAME_AREA_OFFSX;
    y += GAME_TILE_H;
  }
  return;
}    

/*
===========================================================================
  DestroyAll
===========================================================================
Description:
  -
  
Parameters:
  -
  
Return value:
  -
  
Notes:
  -

Function:
  -

===========================================================================
*/

static void
  DestroyAll(ALLEGRO_BITMAP      *playerShot_p,
             ALLEGRO_BITMAP      *playerTank_p,
             ALLEGRO_BITMAP      *enemyShot_p,
             ALLEGRO_BITMAP      *enemyTank_p,
             ALLEGRO_FONT        *font_p,
             ALLEGRO_SAMPLE      *explosion_p,
             ALLEGRO_SAMPLE      *fire_p,
             ALLEGRO_DISPLAY     *display_p,
             ALLEGRO_EVENT_QUEUE *event_queue_p,
             ALLEGRO_TIMER       *timer_p)
{
  if (event_queue_p)
  {
    al_destroy_event_queue(event_queue_p);
  }      

  if (explosion_p)
  {
    al_destroy_sample(explosion_p);
  }      

  if (fire_p)
  {
    al_destroy_sample(fire_p);
  }      

  if (playerShot_p)
  {
    al_destroy_bitmap(playerShot_p);
  }      

  if (playerTank_p)
  {
    al_destroy_bitmap(playerTank_p);
  }      

  if (enemyShot_p)
  {
    al_destroy_bitmap(enemyShot_p);
  }      

  if (enemyTank_p)
  {
    al_destroy_bitmap(enemyTank_p);
  }      

  if (font_p)
  {
    al_destroy_font(font_p);
  }      

  if (display_p)
  {
    al_destroy_display(display_p);
  }      

  if (timer_p)
  {
    al_destroy_timer(timer_p);
  }      

  return;
}    
