#ifndef _UNIT_H_
#define _UNIT_H_

//---------------------------------------------------------------------------
//flaguri pt variabila alive
#define FLAG_ALIVE              1       //unitatea e vie
#define FLAG_DEAD               2       //unitatea a murit dar mai exista pentru ZOMBIE_TIME pt a fi consemnat faptul
#define FLAG_BUILT              3       //unitatea este construita

//selectata sau nu?
#define FLAG_SELECTED           1       //selectata

#define MAX_UNIT_TYPES          64
#define MAX_WEAPON_TYPES        32 
#define MAX_ORDER_TYPES         32
#define MAX_BUILD_TYPES         32
#define MAX_UPGRADE_TYPES       32

#define MAX_UNITS               4096
#define MAX_ORDERS              8       //cate ordine poate accepta in stiva
#define MAX_BUILDS              5       //cate unitati poate tine in stiva de constructie
#define MAX_UPGRADES            1
#define ZOMBIE_TIME             2000    //cat sta o unitate in starea de zombie
#define ROT_TIME                16      //la cati pasi o unitate corecteaza rotatia
#define CHECK_TIME              32      //la cati pasi verifica perimetrul
#define SLOW_AMOUNT             20.0    //viteza de incetinire
#define ROT_AMOUNT              8       //viteza de rotatie

#define ORD_STOP                0
#define ORD_HOLD                1
#define ORD_MOVE                2
#define ORD_ATTACK              3
#define ORD_PATROL              4
#define ORD_EXTRACT             5
#define ORD_DIE					100

//parametrii ordinelor
#define ORD_PARAM_NONE          0
#define ORD_PARAM_LOCATION      1
#define ORD_PARAM_UNIT          2
#define ORD_PARAM_LOCUNIT       3

#define WPN_TYPE_BULLET         0
#define WPN_TYPE_MISSILE        1
#define WPN_TYPE_FLASH          2
#define WPN_TYPE_KAMIKAZE       3

//---------------------------------------------------------------------------
typedef struct UNIT_PROP                    //proprietatile unitatilor
    {
     char   name[256];                      //numele
     int    supply;                         //cat supply consuma
     int    aluminium;                      //masa de aluminiu
     int    steel;                          //masa de otel
     int    gold;                           //masa de aur
     int    life;                           //viata
     int    mana;                           //magie
     int    shield;                         //scut
     int    armour;                         //armura
     int    speed;                          //viteza de deplasare
     int    agressivity;                    //cum raspunde la atac
     int    radar_range;                    //raza de vedere
     int    radar_type;                     //tipul radarului: 0-normal, 1- nivelul de detectie
     int    cloaking_type;                  //daca are dispozitiv de invizibilitate 0-nu, 1- nivelul de ascundere
     int    rot_speed;                      //viteza de rotatie
     int    weapon;                         //cu ce arma este dotata

     int    order_count;                    //cate ordine sunt definite mai jos
     int    order[MAX_ORDER_TYPES];			//ce ordine accepta

     int    build_count;                    //
     int    build[MAX_BUILD_TYPES];			//ce poate construi

	 int    upgrade_count;
     int    upgrade[MAX_UPGRADE_TYPES];		//ce upgrade-uri accepta
     int    upgrade_level[MAX_UPGRADE_TYPES];//nivelele upgrade-urilor

     int    prerequiste[MAX_UNIT_TYPES];    //ce este necesar inainte de a o putea construi
     int    prerequiste_count;              //

     scScript script;                       //scriptul

     struct ANIM *anim;                     //animatia
     struct ANIM *icon;                     //iconita de selectare
    } UNIT_PROP;

typedef struct WEAPON_PROP                  //proprietatile armelor
    {
     char   name[256];                      //numele
     int    bullet_type;                    //tipul armei - bullet, missile, flash
     int    damage;                         //cat damage face
     int    rate;                           //cat de repede trage
     int    splash;                         //face damage si pe langa
     int    range;                          //raza de actiune
     int    speed;                          //viteza glontului

     struct ANIM *anim;                     //animatia
    } WEAPON_PROP;

typedef struct ORDER_PROP                   //proprietatile ordinelor
    {
     char   name[256];                      //numele
     int    params;                         //este incarcat din order_type la rulare
     char   key;                            //shortcut

     struct ANIM *icon;                     //iconita
    } ORDER_PROP;

typedef struct BUILD_PROP                   //proprietatile ordinelor
    {
     char   name[256];                      //numele
	 int	unit;							//unitatea construita
     int    time;                           //timpul de constructie
     int    aluminium;                      //cat aluminiu necesita la constructie
     int    steel;                          //este defapt masa navei+rezidurile
     int    gold;
     int    supply;                         //cat supply produce - acesta este o copie din UNIT_PROP

     char   key;                            //shortcut

     struct ANIM *icon;                     //iconita
    } BUILD_PROP;

typedef struct UPGRADE_PROP                 //proprietatile upgrade-urilor
    {
     char   name[256];                      //numele
     int    time;
     int    aluminium;
     int    aluminium_factor;
     int    steel;
     int    steel_factor;
     int    gold;
     int    gold_factor;

     char   key;

     struct ANIM *icon;
    } UPGRADE_PROP;

typedef struct ORDER                        //ordin
    {
     int    order;                          //ordinul propriuzis
     int    flag;                           //folosit de ordin intern

     float  x, y;                           //parametrii: - locatie

     struct UNIT    *target;                //            - tinta
     struct UNIT    *temp_target;           //tinta temporara

     int    i0,  i1,  i2,  i3, i4;          //variabile interne
     float  f0,  f1,  f2,  f3, _f4;
    } ORDER;

typedef struct BUILD
    {
     int    build;                          //ce construieste
     int    flag;                           //folosit intern
     int    time;                           //cat timp s-a scurs din constructie

     struct UNIT    *unit;                  //unitatea construita
     int    i0,  i1,  i2,  i3, i4;          //variabile interne
     float  f0,  f1,  f2,  f3, _f4;
    } BUILD;

typedef struct UPGRADE
    {
     int    upgrade;                        //ce upgrade?
     int    flag;                           //folosit intern
     int    time;

     int    i0,  i1,  i2,  i3, i4;          //variabile interne
     float  f0,  f1,  f2,  f3, _f4;
    } UPGRADE;

typedef struct UNIT
    {
     int    type;                           //tipul unitatii
     int    nr;                             //numarul ei - poate fi identificata doar prin acest numar

     int    alive;                          //unitatea este vie, moarta, construita
     int    selected;                       //unitatea este selectata
     int    mark;                           //marcaj

     float  x, y;                           //pozitia.
     float  dx, dy;                         //incrementul pe fiecare directie
     int    rally_x, rally_y;               //rally point

     int    load;                           //incarcatura
     int    aluminium;                      //masa de metal
     int    steel;
     int    gold;

     float  life;                           //viata curenta
     float  mana;                           //magia curenta
     float  shield;                         //scutul curent
     float  speed;                          //viteza actuala
     float  acc;                            //acceleratia actuala
     int    kills;                          //cate nave a omorat

     int    bullet_timer;                   //cat timp s-a scurs de la ultimul bullet
     int    bullet_count;                   //cate gloante sunt in bullets
     struct BULLET *bullets;                //gloante

     ORDER      orders[MAX_ORDERS];         //stiva cu ordine
     BUILD      builds[MAX_BUILDS];         //stiva cu constructii
     UPGRADE    upgrades[MAX_UPGRADES];     //upgrade-ul curent

     struct ANIM   *anim, *icon;            //animatia, icoana si explozia
     struct PLAYER *player;                 //jucatorul parinte
     struct UNIT   *attacker;               //unitatea cara ataca

     int    _init_;                         //adresele procedurilor
     int    _shutdown_;
     int    _die_;
     int    _damage_;
     int    _draw_;
     int    _process_;
     int    _process_ai_;

     scInstance *prog;                      //instanta scriptului

     struct UNIT *next, *prev;
    }  UNIT;

//---------------------------------------------------------------------------
int             unit_types;
UNIT_PROP       unit_prop[MAX_UNIT_TYPES];

int             weapon_types;
WEAPON_PROP     weapon_prop[MAX_WEAPON_TYPES];

int             order_types;
ORDER_PROP      order_prop[MAX_ORDER_TYPES];

int             build_types;
BUILD_PROP      build_prop[MAX_BUILD_TYPES];

int             upgrade_types;
UPGRADE_PROP    upgrade_prop[MAX_UPGRADE_TYPES];

//---------------------------------------------------------------------------
UNIT *add_unit(struct PLAYER *p, int nr, char *name, int x, int y);
void link_unit(struct PLAYER *p, UNIT *u);
void remove_unit(UNIT *u);

UNIT *nr2unit(struct PLAYER *p, int nr);
int  unit2nr(UNIT *u);
struct PLAYER *unit2player(UNIT *u);

void damage(UNIT *v, UNIT *a);

float get_unit2unit_dist(struct UNIT *u1, struct UNIT *u2);
float get_point2unit_dist(int x, int y, UNIT *u);

int  get_units(struct PLAYER *p, int rel, int type, int x, int y, int w, int h, UNIT **l, int max);
void draw_units(struct PLAYER *p);
void process_units(struct PLAYER *p);

int  add_unit_order(UNIT *unit, ORDER *order, int add);
int  add_order(struct PLAYER *p, ORDER *order, int add);

int  add_unit_build(UNIT *unit, BUILD *build, int add);
int  add_build(struct PLAYER *p, BUILD  *b, int add);
void remove_unit_build(UNIT *unit, int nr);

int  add_upgrade(struct PLAYER *p, UPGRADE  *u, int add);
void remove_unit_upgrade(UNIT *unit, int nr);

//---------------------------------------------------------------------------
#endif
