/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Unit code. Orders, upgrades and building code
 */

#include "standard.h"
#include "unit.h"

#include "radar.h"
#include "script.h"
#include "bullet.h"
#include "alliance.h"
#include "player.h"
#include "gfx.h"
#include "map.h"
#include "misc.h"
#include "particle.h"
#include "file.h"
#include "gui.h"
#include "panel.h"
#include "netint.h"
//#include "gfx/gfx.h"

int order_param[MAX_ORDER_TYPES]={
    ORD_PARAM_NONE,
    ORD_PARAM_NONE,
    ORD_PARAM_LOCUNIT,
    ORD_PARAM_LOCUNIT,
    ORD_PARAM_LOCATION,
    ORD_PARAM_UNIT,
    ORD_PARAM_NONE,
    ORD_PARAM_NONE,
    ORD_PARAM_NONE
};

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
UNIT *nr2unit(PLAYER *p, int nr)
{
 UNIT *temp;

 if (p==NULL || nr<0) return NULL;

 temp=p->units;
 while (temp)
    {
     if (temp->nr==nr) break;

     temp=temp->next;
    }

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int unit2nr(UNIT *u)
{
 if (!u) return -1;
 else return u->nr;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
PLAYER *unit2player(UNIT *u)
{
 if (!u) return NULL;
 else return u->player;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
float get_unit2unit_dist(UNIT *u1, UNIT *u2)
{
 float dist;

 dist=get_dist(u1->x, u1->y, u2->x, u2->y);
 dist-=MAX(u1->anim->w, u1->anim->h)/4;
 dist-=MAX(u2->anim->w, u2->anim->h)/4;

 return dist;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
float get_point2unit_dist(int x, int y, UNIT *u)
{
 float dist;

 dist=get_dist(x, y, u->x, u->y);
 dist-=MAX(u->anim->w, u->anim->h)/4;

 return dist;
}
/*****************************************************************************

    Function: get_units_callback

    Description: functie ajutatoare pt sortarea listei
    Parameters:
    Return:

*****************************************************************************/
int get_units_callback(const void *e1, const void *e2)
{
 UNIT *u1=(*(UNIT **)e1);
 UNIT *u2=(*(UNIT **)e2);

 return u1->orders[0]._f4 - u2->orders[0]._f4;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int get_player_units(PLAYER *p, PLAYER *p1, int type, int x, int y, int w, int h, UNIT **l, int max)
{
 UNIT *temp;
 int ux, uy, uw, uh;
 int x1, y1, x2, y2;
 int index=0;

 for (temp=p1->last_unit; temp && index<max; temp=temp->prev)
  if ((temp->alive==FLAG_ALIVE) && get_unit_visibility(p, temp) && ((temp->type==type) || (type<0)))
    {
     uw=temp->anim->w/2;
     uh=temp->anim->h/2;
     ux=temp->x;
     uy=temp->y;

     x1=x-uw/2;
     y1=y-uh/2;
     x2=x1+w+uw;
     y2=y1+h+uh;

     if (ux>x1 && ux<x2 && uy>y1 && uy<y2)
        {
         temp->orders[0]._f4=get_dist(x, y, ux, uy);
         if (temp->orders[0]._f4<16) temp->orders[0]._f4=0;

         l[index]=temp;

         index++;
        }
    }

 return index;
}
/*****************************************************************************

    Function: get_units

    Description: returneaza o lista cu unitatile ce ating zona (x, y, w, h).
                 Lista este sortata crescator.
    Parameters: (p)          - player-ul care apeleaza
                (rel)        - in ce relatie cu unitatile sa fie
                (type)       - ce tip de unitati
                (x, y, w, h) - zona
                (l)          - lista de pointeri in care se va baga rezultatul
                (max)        - dimensiunea maxima a listei
    Return: cate unitati ating punctul

*****************************************************************************/
int get_units(PLAYER *p, int rel, int type, int x, int y, int w, int h, UNIT **l, int max)
{
 PLAYER *temp;
 int index=0;

 //verifica intai unitatile mele
 if ((rel&relations[p->nr][me->nr]) || (rel<0)) index=get_player_units(p, me, type, x, y, w, h, l, max);

 //apoi celelalte unitati
 temp=players;
 while (temp && index<max)
  if (temp!=me && ((rel&relations[p->nr][temp->nr]) || rel<0))
    {
     index+=get_player_units(p, temp, type, x, y, w, h, &l[index], max-index);

     temp=temp->next;
    }
  else temp=temp->next;

 qsort(l, index, sizeof(UNIT *), get_units_callback);

 return index;
}
/*****************************************************************************

    Function: add_unit_order

    Description: pune un ordin in stiva de ordine
    Parameters: (unit)  - unitatea afectata
                (order) - ordinul
                (add)   - daca este 1 atunci ordinul este adaugat in stiva
                          daca e 0 atunci sunt sterse toate ordinele precedente
    Return: nivelul stivei de ordine
            -1 daca nu mai e loc
            -2 daca unitatea nu accepta astfel de ordine si nici nu poate fi
               transformat in move

*****************************************************************************/
int add_unit_order(UNIT *unit, ORDER *order, int add)
{
 int i=0;
 ORDER new_order;//daca modifica ordinul, nu trebuie sa il modifice pe *order
                 //deoarece vor fi afectate si celelalte unitati selectate

 for (i=0;i<order_types;i++)    if (unit_prop[unit->type].order[i]==order->order) break;
 if (i>=order_types)//unitatea nu accepta ordinul - il transform in move
    {
     memcpy(&new_order, order, sizeof(ORDER));
     order=&new_order;

     if (order_prop[order->order].params==ORD_PARAM_LOCATION ||
         order_prop[order->order].params==ORD_PARAM_UNIT ||
         order_prop[order->order].params==ORD_PARAM_LOCUNIT) order->order=ORD_MOVE;
     else return -2;
    }

 for (i=0;i<order_types;i++)    if (unit_prop[unit->type].order[i]==order->order) break;
 if (i>=order_types) return -2;//unitatea nu accepta ordinul initial si nici move

 if (add==0)
    {
     for (i=0;i<MAX_ORDERS;i++) unit->orders[i].order=ORD_STOP;
     memcpy(&unit->orders[0], order, sizeof(ORDER));

     i=0;
    }
 else
    {
     for (i=0;i<MAX_ORDERS;i++)
      if (unit->orders[i].order==ORD_STOP)
        {
         memcpy(&unit->orders[i], order, sizeof(ORDER));

         break;
        }

     if (i>=MAX_ORDERS) i=-1;
    }

 return i;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int add_order(PLAYER *p, ORDER  *o, int add)
{
 UNIT *unit;
 int w, h;
 int cx, cy, x1, y1, x2, y2, ox, oy;
 int i;

 if (p->selected==0) return -1;

 if (order_prop[o->order].params==ORD_PARAM_LOCATION ||
    (order_prop[o->order].params==ORD_PARAM_LOCUNIT && o->target==NULL))
    {
     x1=99999; y1=99999;
     x2=-99999; y2=-99999;
     for (i=0;i<MAX_SELECTED;i++)
      if (p->selection[i]!=NULL)
        {
         unit=p->selection[i];
         w=unit->anim->w/2;
         h=unit->anim->h/2;

         if (unit->x-w<x1) x1=unit->x-w;
         if (unit->x+w>x2) x2=unit->x+w;
         if (unit->y-h<y1) y1=unit->y-h;
         if (unit->y+h>y2) y2=unit->y+h;
        }

     if (x1==99999) return -1;

     cx=x1+(x2-x1)/2;
     cy=y1+(y2-y1)/2;

     ox=o->x;
     oy=o->y;

     for (i=0;i<MAX_SELECTED;i++)
      if (p->selection[i]!=NULL)
        {
         unit=p->selection[i];
         if (!(relations[me->nr][unit->player->nr]&REL_ME)) continue;

         o->x=ox;
         o->y=oy;

         if (ox<x1 || ox>x2 || oy<y1 || oy>y2)
            {
             o->x+=(unit->x-cx);
             o->y+=(unit->y-cy);
             fix_map_coords_centre_f(&o->x, &o->y, unit->anim->w,   unit->anim->h);
            }

         add_unit_order(unit, o, add);
        }
    }
 else
    {
     for (i=0;i<MAX_SELECTED;i++)
      if (p->selection[i]!=NULL)
        {
         unit=p->selection[i];
         if (!(relations[me->nr][unit->player->nr]&REL_ME)) continue;

         add_unit_order(unit, o, add);
        }
    }

 if (p==me && me->selected==1 && command_opt==VIEW_ORDER) REDRAW(panel_dialog, SELECTION_OBJ);
 if (p==me && me->selected==1) REDRAW(panel_dialog, COMMAND_OBJ);

 return 0;
}
/*****************************************************************************

    Function: remove_order

    Description: sterge un ordin din lista
    Parameters: (unit) - unitatea afectata
                (nr)   - numarul ordinului
    Return: N/A

*****************************************************************************/
void remove_unit_order(UNIT *unit, int nr)
{
 int i;

 for (i=nr;i<MAX_ORDERS-1;i++) memcpy(&unit->orders[i], &unit->orders[i+1], sizeof(ORDER));

 memset(&unit->orders[i], 0, sizeof(ORDER));
 unit->orders[i].order=ORD_STOP;

 if (me->selected==1 && command_opt==VIEW_ORDER) REDRAW(panel_dialog, SELECTION_OBJ);
 if (me->selected==1) REDRAW(panel_dialog, COMMAND_OBJ);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int add_unit_build(UNIT *unit, BUILD *build, int add)
{
 int i=0;
 int req_aluminium, req_steel, req_gold;

 for (i=0;i<build_types;i++) if (unit_prop[unit->type].build[i]==build->build) break;
 if (i>=build_types) return -2;

 req_aluminium=build_prop[build->build].aluminium;
 req_steel=build_prop[build->build].steel;
 req_gold=build_prop[build->build].gold;

 if (unit->player->aluminium<req_aluminium ||
     unit->player->steel<req_steel ||
     unit->player->gold<req_gold) return -3;

 if (add==0)
    {
     charge_player(unit->player, build_prop[build->build].aluminium,    build_prop[build->build].steel, build_prop[build->build].gold);

     for (i=0;i<MAX_BUILDS;i++) unit->builds[i].build=0;
     memcpy(&unit->builds[0], build, sizeof(BUILD));

     i=0;
    }
 else
    {
     for (i=0;i<MAX_BUILDS;i++)
      if (unit->builds[i].build==0)
        {
         charge_player(unit->player, build_prop[build->build].aluminium,    build_prop[build->build].steel, build_prop[build->build].gold);

         memcpy(&unit->builds[i], build, sizeof(BUILD));

         break;
        }

     if (i>=MAX_BUILDS) i=-1;
    }

 return i;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int add_build(PLAYER *p, BUILD  *b, int add)
{
 UNIT *unit;
 int i;

 for (i=0;i<MAX_SELECTED;i++)
  if (p->selection[i]!=NULL)
    {
     unit=p->selection[i];

     add_unit_build(unit, b, add);
    }

 if (p==me && me->selected==1 && command_opt==VIEW_BUILD) REDRAW(panel_dialog, SELECTION_OBJ);

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void remove_unit_build(UNIT *unit, int nr)
{
 int i;

 //verifica daca se construia unitatea
 if (unit->builds[nr].unit) if (unit->builds[nr].unit->alive==FLAG_BUILT)
    {
     charge_player(unit->player, -build_prop[unit->builds[nr].build].aluminium,
                                 -build_prop[unit->builds[nr].build].steel,
                                 -build_prop[unit->builds[nr].build].gold);

     remove_unit(unit->builds[nr].unit);
    }

 for (i=nr;i<MAX_BUILDS-1;i++) memcpy(&unit->builds[i], &unit->builds[i+1], sizeof(BUILD));

 memset(&unit->builds[i], 0, sizeof(BUILD));
 unit->builds[i].build=0;

 if (me->selected==1 && command_opt==VIEW_BUILD) REDRAW(panel_dialog, SELECTION_OBJ);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int add_upgrade(PLAYER *p, UPGRADE  *u, int add)
{
 UNIT *unit;
 int i;

 for (i=0;i<MAX_SELECTED;i++)
  if (p->selection[i]!=NULL)
    {
     unit=p->selection[i];

     if (unit->upgrades[0].upgrade==0) memcpy(&unit->upgrades[0], u, sizeof(UPGRADE));
    }

 if (p==me && me->selected==1 &&  command_opt==VIEW_UPGRADE) REDRAW(panel_dialog, SELECTION_OBJ);

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void remove_unit_upgrade(UNIT *unit, int nr)
{
 memset(&unit->upgrades[0], 0, sizeof(UPGRADE));
 unit->upgrades[0].upgrade=0;

 if (me->selected==1 && command_opt==VIEW_UPGRADE) REDRAW(panel_dialog, SELECTION_OBJ);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void order_stop(UNIT *unit)
{
 ORDER *order=&unit->orders[0];

 if (order->flag==0)//incetineste in caz ca se misca
    {
     if (unit->speed>0)
        {
         unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
         if (unit->speed < 0) unit->speed=0;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;
        }
     else
        {
         anim_flags(unit->anim, ANIM_STOP_FLAG);
         order->flag=1;
        }

     order->i0=(rand()%100)-20;
     unit->attacker=NULL;
    }
 else if (order->flag==1)//unitatea a oprit
    {
     if (unit->attacker)
        {
         if (unit->attacker->alive==FLAG_DEAD) unit->attacker=NULL;//gfx atacatorul a murit

         if (unit_prop[unit->type].agressivity==0 || !get_unit_visibility(unit->player, unit->attacker))
            {
             if (relations[unit->player->nr][unit->attacker->player->nr]&REL_ENEMY)
                {
                 int x, y;
                 int rot;
                 ORDER o;
        
                 rot=get_rot(unit->x, unit->y, unit->attacker->x, unit->attacker->y);
        
                 rot+=(rand()%32-16)%256;
                 x=unit->x-fixtof(fixcos(itofix(rot)))*unit_prop[unit->attacker->type].radar_range*2;
                 y=unit->y-fixtof(fixsin(itofix(rot)))*unit_prop[unit->attacker->type].radar_range*2;
        
                 fix_map_coords_centre(&x, &y, unit->anim->w, unit->anim->h);
        
                 memset(&o, 0, sizeof(ORDER));
                 o.order=ORD_MOVE;
                 o.x=x;
                 o.y=y;
            
                 add_unit_order(unit, &o, 0);
                }
            }
         else if (unit_prop[unit->type].agressivity>=1)
            {
             if (relations[unit->player->nr][unit->attacker->player->nr]&REL_ENEMY)
                {
                 ORDER o;
        
                 memset(&o, 0, sizeof(ORDER));
                 o.order=ORD_ATTACK;
                 o.target=unit->attacker;
        
                 add_unit_order(unit, &o, 0);
                }
            }
		}
	 if (unit_prop[unit->type].agressivity>1 && !(order->i0%32))
        {
         int sel;
         int w=unit_prop[unit->type].radar_range*2;
         int h=unit_prop[unit->type].radar_range*2;
         int x=unit->x - w/2;
         int y=unit->y - h/2;
         UNIT *u[8];
    
         sel=get_units(unit->player, REL_ENEMY, -1, x, y, w, h, u, 8);
    
         if (sel)
            {
             ORDER o;
    
             memset(&o, 0, sizeof(ORDER));
             o.order=ORD_ATTACK;
             o.target=u[0];
    
             add_unit_order(unit, &o, 0);
            }
        }

     if (!(order->i0%10))//varifica mai rar pt a nu lua din viteza
        {
         UNIT *u;

         u=get_trace(unit->x, unit->y, unit);
         if (u!=unit)
            {
             int rot;
             float dx, dy;

             assert(u);
             assert(unit);

             rot=get_rot(unit->x, unit->y, u->x, u->y);

             rot+=(rand()%16-8)%256;
             dx=-fixtof(fixcos(itofix(rot)));
             dy=-fixtof(fixsin(itofix(rot)));
             unit->x+=dx;
             unit->y+=dy;

             fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);
            }
        }

     draw_trace(unit->x, unit->y, unit);

     if (order->i0==0)
        {
         unit->x--;//face unitatea sa se miste sus/jos
         unit->y--;
        }
     else if (order->i0==40)
        {
         unit->x++;
         unit->y++;
        }

     order->i0++;
     if (order->i0>80) order->i0=-rand()%20;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void order_hold(UNIT *unit)
{
 ORDER *order=&unit->orders[0];

 if (order->flag==0)//incetineste in caz ca se misca
    {
     if (unit->speed>0)
        {
         unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
         if (unit->speed < 0) unit->speed=0;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;
        }
     else
        {
         anim_flags(unit->anim, ANIM_STOP_FLAG);
         order->flag=1;
        }

     order->i0=(rand()%100)-20;
     unit->attacker=NULL;
    }
 else if (order->flag==1)//unitatea a oprit
    {
     if (!(order->i0%10))//varifica mai rar pt a nu lua din viteza
        {
         UNIT *u;

         u=get_trace(unit->x, unit->y, unit);
         if (u!=unit)
            {
             int rot;
             float dx, dy;

             assert(u);
             assert(unit);

             rot=get_rot(unit->x, unit->y, u->x, u->y);

             rot+=(rand()%16-8)%256;
             dx=-fixtof(fixcos(itofix(rot)));
             dy=-fixtof(fixsin(itofix(rot)));
             unit->x+=dx;
             unit->y+=dy;

             fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);
            }
        }

     draw_trace(unit->x, unit->y, unit);

     if (order->i0==0)
        {
         unit->x--;//face unitatea sa se miste sus/jos
         unit->y--;
        }
     else if (order->i0==40)
        {
         unit->x++;
         unit->y++;
        }

     order->i0++;
     if (order->i0>80) order->i0=-rand()%20;
    }
}
/*****************************************************************************

    Function:

    Description: i0 este folosit intai pt a retine unghiul initial de rotatie
                 si pt a corecta acest unghi din 32 in 32 pasi;

    Parameters:
    Return:

*****************************************************************************/
void order_move(UNIT *unit)
{
 ORDER *order=&unit->orders[0];

 if (order->target==NULL)//unitatea se deplaseaza la o locatie
    {
     if (order->flag==0)
        {
         fix_map_coords_centre_f(&order->x, &order->y, unit->anim->w,   unit->anim->h);

         order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

         order->flag=1;
        }
     if (order->flag==1)
        {
         rotate(&unit->anim->rot, order->i0, unit_prop[unit->type].rot_speed);

         if (unit->anim->rot==order->i0)
            {
             unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
             unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

             anim_flags(unit->anim, ANIM_MOVE_FLAG);
             order->i0=ROT_TIME;
             order->flag=2;
            }
        }
     if (order->flag==2)
        {
         unit->speed+=0.2;
         if (unit->speed > unit_prop[unit->type].speed) unit->speed=unit_prop[unit->type].speed;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         order->i0--;
         if (order->i0<=0)
            {
             unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
             unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
             unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

             order->i0=ROT_TIME;
            }

         if (ABS(unit->x-order->x)<32 && ABS(unit->y-order->y)<32) order->flag=3;
        }
     if (order->flag==3)
        {
         unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
         if (unit->speed < 0) unit->speed=0;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);

         if (unit->speed<=0)
            {
             anim_flags(unit->anim, ANIM_STOP_FLAG);
             remove_unit_order(unit, 0);
            }
        }
    }
 else //unitatea urmareste o alta unitate
    {
     UNIT *target=(UNIT *)order->target;

     if (target==unit || target->alive==FLAG_DEAD)
        {
         remove_unit_order(unit, 0);
         if (unit->player==me && me->selected==1 && me->selection[0]==unit) REDRAW(panel_dialog, SELECTION_OBJ);

         return;
        }

     order->x=target->x;
     order->y=target->y;

     if (get_point2unit_dist(unit->x, unit->y, target)>unit_prop[unit->type].radar_range) //daca distanta e mare
        {
         if (order->flag==0)
            {
             fix_map_coords_centre_f(&order->x, &order->y, unit->anim->w, unit->anim->h);

             order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

             order->i4=0;
             order->flag=1;
            }
         if (order->flag==1)
            {
             rotate(&unit->anim->rot, order->i0, unit_prop[unit->type].rot_speed);

             if (unit->anim->rot==order->i0)
                {
                 unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
                 unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

                 anim_flags(unit->anim, ANIM_MOVE_FLAG);
                 order->i0=ROT_TIME/4;
                 order->flag=2;
                }
            }
         if (order->flag==2)
            {
             unit->speed+=0.2;
             if (unit->speed > unit_prop[unit->type].speed) unit->speed=unit_prop[unit->type].speed;

             unit->x+=unit->dx*unit->speed;
             unit->y+=unit->dy*unit->speed;

             order->i0--;
             if (order->i0<=0)
                {
                 unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
                 unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
                 unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

                 order->i0=ROT_TIME/4;
                }
            }
        }
     else if (unit->speed>0)//cand a ajuns, incetineste
        {
         order->flag=0;

         unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
         if (unit->speed < 0) unit->speed=0;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);\
        }
     else //face un truc murdar pt a nu sta unitatile una peste alta
        {
         order->flag=order->i4;

         order_hold(unit);

         order->i4=order->flag;
         order->flag=0;
        }
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void order_attack(UNIT *unit)
{
 ORDER *order=&unit->orders[0];

 /*
  * ordinul ATTACK LOCATION se foloseste de ATTACK UNIT si de aceea trebuie sa
  * retina order->flag-ul acestuia in i4;
  * i0 este folosit pt a retine unghiul initial si pt a-l corecta din 32 in 32;
  * i1 este folosit pt a verifica perimetrul din 8 in 8 pasi;
  */
 if (order->target==NULL)//unitatea ataca tot ce gaseste pe drum pana la o locatie
    {
     if (order->flag==0) //verifica coordonatele tinta si calculeaza rotatia
        {
         fix_map_coords_centre_f(&order->x, &order->y, unit->anim->w,   unit->anim->h);

         order->flag=1;
        }
     if (order->flag==1)//cauta o unitate apropiata si o ataca
        {
         int sel, x, y, w, h;
         UNIT *u[8];

         if (order->temp_target==NULL)
            {
             w=unit_prop[unit->type].radar_range*2;
             h=unit_prop[unit->type].radar_range*2;
             x=unit->x - w/2;
             y=unit->y - h/2;

             sel=get_units(unit->player, REL_ENEMY, -1, x, y, w, h, u, 8);

             if (sel)
                {
                 order->i4=0;
                 order->temp_target=u[0];//a gasit o tinta
                 if (unit->player==me && me->selected==1 && me->selection[0]==unit) REDRAW(panel_dialog, SELECTION_OBJ);
                }
             else
                {
                 order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

                 order->flag=2;//nu a gasit, merge mai departe
                }
            }
         else
            {
             UNIT *target=(UNIT *)order->temp_target;

             if (target->alive==FLAG_DEAD) order->temp_target=NULL;//tinta a murit
             else
                {
                 order->target=target;
                 order->flag=order->i4;
                 x=order->x;
                 y=order->y;

                 order_attack(unit);          //se foloseste de ordinul ATTACK UNIT

                 order->target=NULL;
                 order->i4=order->flag;
                 order->flag=1;
                 order->x=x;
                 order->y=y;
                }
            }
        }
    if (order->flag==2) //roteste unitatea
        {
         rotate(&unit->anim->rot, order->i0, unit_prop[unit->type].rot_speed);

         if (unit->anim->rot==order->i0)
            {
             unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
             unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

             anim_flags(unit->anim, ANIM_MOVE_FLAG);
             order->i0=ROT_TIME;
             order->i1=CHECK_TIME;
             order->flag=3;
            }
        }
    if (order->flag==3) //misca unitatea si din 32 in 32 pasi si ultimii 16 pasi recalculeaza rotatia
        {
         unit->speed+=0.2;
         if (unit->speed > unit_prop[unit->type].speed) unit->speed=unit_prop[unit->type].speed;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         order->i0--;
         if (order->i0<=0)
            {
             unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
             unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
             unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

             order->i0=ROT_TIME;
            }
         order->i1--;
         if (order->i1<=0)
            {
             order->flag=1;

             order->i1=CHECK_TIME;
            }

         if (ABS(unit->x-order->x)<16 && ABS(unit->y-order->y)<16) order->flag=4;
        }
    if (order->flag==4)//incetineste
        {
         unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
         if (unit->speed < 0) unit->speed=0;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);\

         if (unit->speed<=0)
            {
             anim_flags(unit->anim, ANIM_STOP_FLAG);
             remove_unit_order(unit, 0);
            }
        }
    }
 else //unitatea ataca o alta unitate
    {
     UNIT *target=order->target;

     if (target==unit || target->alive==FLAG_DEAD)
        {
         remove_unit_order(unit, 0);
         if (unit->player==me && me->selected==1 && me->selection[0]==unit) REDRAW(panel_dialog, SELECTION_OBJ);

         return;
        }

     order->x=target->x;
     order->y=target->y;

     if (order->flag==0)//apelul initial
        {
         fix_map_coords_centre_f(&order->x, &order->y, unit->anim->w,   unit->anim->h);

         order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

         order->flag=1;
        }
     if (order->flag==1) //roteste unitatea
        {
         rotate(&unit->anim->rot, order->i0, unit_prop[unit->type].rot_speed);

         if (unit->anim->rot==order->i0)
            {
             unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
             unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

             order->i0=ROT_TIME;
             order->flag=2;
            }
        }
    if (order->flag==2)//dupa rotatia initiala
        {
         if (get_point2unit_dist(unit->x, unit->y, target)>weapon_prop[unit_prop[unit->type].weapon].range) //daca distanta e mare
            {
             anim_flags(unit->anim, ANIM_MOVE_FLAG);

             unit->speed+=0.2;
             if (unit->speed > unit_prop[unit->type].speed) unit->speed=unit_prop[unit->type].speed;

             unit->x+=unit->dx*unit->speed;
             unit->y+=unit->dy*unit->speed;

             order->i0--;
             if (order->i0<=0)
                {
                 unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
                 unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
                 unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

                 order->i0=ROT_TIME;
                }
            }
         else if (unit->speed>0)//cand a ajuns, incetineste
            {
             order->flag=0;

             unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
             if (unit->speed < 0) unit->speed=0;

             unit->x+=unit->dx*unit->speed;
             unit->y+=unit->dy*unit->speed;

             fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);

             add_bullet(unit, order->target, -1, unit_prop[unit->type].weapon);
            }
         else//s-a oprit. Incepe sa traga si se roteste dupa tinta
            {
             anim_flags(unit->anim, ANIM_STOP_FLAG);

             order->i0=0;
             unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;

             add_bullet(unit, order->target, -1, unit_prop[unit->type].weapon);
            }
        }
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void order_patrol(UNIT *unit)
{
 ORDER *order=&unit->orders[0];

 /*
  * ordinul PATROL se foloseste de ATTACK UNIT si de aceea trebuie sa retina
  * order->flag-ul acestuia in i4;
  * i0 este folosit pt a retine unghiul initial si pt a-l corecta din 32 in 32;
  * i1 este folosit pt a verifica perimetrul din 8 in 8 pasi;
  * Verificarea perimetrului incepe doar dupa ce ajunge la tinta; pt asta se
  * foloseste i2;
  */

 if (order->flag==0) //retine coordonatele originale
    {
     order->f0=order->x;
     order->f1=order->y;

     order->flag=1;
    }
 if (order->flag==1) //verifica coordonatele tinta si calculeaza rotatia
    {
     fix_map_coords_centre_f(&order->x, &order->y, unit->anim->w,   unit->anim->h);

     order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

     order->flag=2;
    }
 if (order->flag==2)//cauta o unitate apropiata si o ataca
    {
     int sel, x, y, w, h;
     UNIT *u[8];

     if (order->i2==0)
        {
         order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

         order->flag=3; //cauta doar dupa ce a ajuns la locatia tinta
        }
     else
        {
         if (order->temp_target==NULL)
            {
             w=unit_prop[unit->type].radar_range*2;
             h=unit_prop[unit->type].radar_range*2;
             x=unit->x - w/2;
             y=unit->y - h/2;

             sel=get_units(unit->player, REL_ENEMY, -1, x, y, w, h, u, 8);

             if (sel)
                {
                 order->i4=0;
                 order->temp_target=u[0];//a gasit o tinta
                 if (unit->player==me && me->selected==1 && me->selection[0]==unit) REDRAW(panel_dialog, SELECTION_OBJ);
                }
             else
                {
                 order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

                 order->flag=3;//nu a gasit, merge mai departe
                }
            }
         else
            {
             UNIT *target=(UNIT *)order->temp_target;

             if (target->alive==FLAG_DEAD) order->temp_target=NULL;//tinta a murit
             else
                {
                 order->target=target;
                 order->flag=order->i4;
                 x=order->x;
                 y=order->y;

                 order_attack(unit);          //se foloseste de ordinul ATTACK UNIT

                 order->target=NULL;
                 order->i4=order->flag;
                 order->flag=2;
                 order->x=x;
                 order->y=y;
                }
            }
        }
    }
 if (order->flag==3) //roteste unitatea
    {
     rotate(&unit->anim->rot, order->i0, unit_prop[unit->type].rot_speed);

     if (unit->anim->rot==order->i0)
        {
         unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
         unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

         anim_flags(unit->anim, ANIM_MOVE_FLAG);
         order->i0=ROT_TIME;
         order->i1=CHECK_TIME;
         order->flag=4;
        }
    }
 if (order->flag==4) //misca unitatea si din 4 in 4 pasi si ultimii 16 pasi recalculeaza rotatia
    {
     unit->speed+=0.2;
     if (unit->speed > unit_prop[unit->type].speed) unit->speed=unit_prop[unit->type].speed;

     unit->x+=unit->dx*unit->speed;
     unit->y+=unit->dy*unit->speed;

     order->i0--;
     if (order->i0<=0)
        {
         unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
         unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
         unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

         order->i0=ROT_TIME;
        }
     order->i1--;
     if (order->i1<=0)
        {
         order->flag=2;

         order->i1=CHECK_TIME;
        }

     if (ABS(unit->x-order->x)<32 && ABS(unit->y-order->y)<32) order->flag=5;
    }
 if (order->flag==5)//incetineste
    {
     unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
     if (unit->speed < 0) unit->speed=0;

     unit->x+=unit->dx*unit->speed;
     unit->y+=unit->dy*unit->speed;

     fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);\

     if (unit->speed<=0)
        {
         anim_flags(unit->anim, ANIM_STOP_FLAG);
         order->i0=32;
         order->i2=1;//a ajuns; incepe sa caute
         order->flag=6;
        }
    }
 if (order->flag==6)//calculeaza noi coordonate tinta
    {
     int range=unit_prop[unit->type].radar_range;

     order->i0--;//asteapta putin
     if (order->i0<0)
        {
         order->x=order->f0+((rand()%range*2)-range);
         order->y=order->f1+((rand()%range*2)-range);

         order->flag=1;
        }
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void order_extract(UNIT *unit)
{
 ORDER *order=&unit->orders[0], o;
 UNIT *target=order->target;
 int w, h, total_mass;
 float f;

 if (target==unit || target->alive==FLAG_DEAD)
    {
     remove_unit_order(unit, 0);

     return;
    }

 order->x=target->x;
 order->y=target->y;

 if (order->flag==0)//apelul initial
    {
     fix_map_coords_centre_f(&order->x, &order->y, unit->anim->w,   unit->anim->h);

     order->i0=(int)(get_rot(unit->x, unit->y, order->x, order->y)+192)%256;

     order->flag=1;
    }
 if (order->flag==1) //roteste unitatea
    {
     rotate(&unit->anim->rot, order->i0, unit_prop[unit->type].rot_speed);

     if (unit->anim->rot==order->i0)
        {
         unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
         unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

         order->i0=ROT_TIME;
         order->flag=2;
        }
    }
 if (order->flag==2)//dupa rotatia initiala
    {
     if (get_point2unit_dist(unit->x, unit->y, target)>unit_prop[unit->type].radar_range) //daca distanta e mare
        {
         anim_flags(unit->anim, ANIM_MOVE_FLAG);

         unit->speed+=0.2;
         if (unit->speed > unit_prop[unit->type].speed) unit->speed=unit_prop[unit->type].speed;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         order->i0--;
         if (order->i0<=0)
            {
             unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
             unit->dx=fixtof(fixcos(ftofix(unit->anim->rot-192)));
             unit->dy=fixtof(fixsin(ftofix(unit->anim->rot-192)));

             order->i0=ROT_TIME;
            }
        }
     else if (unit->speed>0)//cand a ajuns, incetineste
        {
         order->flag=0;

         unit->speed-=(float)unit_prop[unit->type].speed/SLOW_AMOUNT;
         if (unit->speed < 0) unit->speed=0;

         unit->x+=unit->dx*unit->speed;
         unit->y+=unit->dy*unit->speed;

         fix_map_coords_centre_f(&unit->x, &unit->y, unit->anim->w, unit->anim->h);
        }
     else//s-a oprit. Incepe sa traga si se roteste dupa tinta
        {
         anim_flags(unit->anim, ANIM_STOP_FLAG);
         unit->anim->rot=get_rot(unit->x, unit->y, order->x, order->y)+192;
         order->i0=0;

         order->i1--;
         if (order->i1<=0)
            {
             order->i1=24+rand()%16;

             w=target->anim->w/1.4;
             h=target->anim->h/1.4;

             if (get_unit_visibility(me, unit))
                {
                 add_particle(20, target->x+(rand()%w)-w/2, target->y+(rand()%h)-h/2, unit->x, unit->y, 4, 0.1, 0);
                 add_particle(20, target->x+(rand()%w)-w/2, target->y+(rand()%h)-h/2, unit->x, unit->y, 4, 0.1, 0);
                }

             target->attacker=unit;

             total_mass=target->aluminium+target->steel+target->gold;
             if (total_mass<=0 || target->life<=0)
                {
				 o.order=ORD_DIE;
				 add_unit_order(target, &o, 0);
                 unit->kills++;
                }
             else
                {
                 f=1.0/(float)total_mass;
                 target->life-=(f*(float)target->life);
                }

             if (target->aluminium)
                {
                 unit->player->aluminium++;
                 target->aluminium--;
                 if (target->aluminium<0) target->aluminium=0;
                }
             if (target->steel)
                {
                 unit->player->steel++;
                 target->steel--;
                 if (target->steel<0) target->steel=0;
                }
             if (target->gold)
                {
                 unit->player->gold++;
                 target->gold--;
                 if (target->gold<0) target->gold=0;
                }

             REDRAW(panel_dialog, SELECTION_OBJ);
            }
        }
    }
}
/*****************************************************************************

    Function: process_orders

    Description: proceseaza ordinele
    Parameters: (unit) - unitatea de procesat
    Return: N/A

*****************************************************************************/
void order_die(UNIT *unit)
{
 int i, j;

 unit->alive=FLAG_DEAD;
 unit->life=ZOMBIE_TIME;

 for (i=0;i<MAX_SELECTED;i++)
    {
     if (me->selection[i]==unit) deselect(me, i);

     for (j=0;j<MAX_GROUPS;j++)
      if (me->group[j].selection[i]==unit)
        {
         me->group[j].selection[i]=NULL;
         me->group[j].selected--;
        }
    }

 unit->player->supply+=(-unit_prop[unit->type].supply);

 CALL_SCRIPT1(unit, die, unit);
 if (get_unit_visibility(me, unit)) anim_flags(unit->anim, ANIM_DIE_FLAG);

 remove_unit_order(unit, 0);
}
/*****************************************************************************

    Function: process_orders

    Description: proceseaza ordinele
    Parameters: (unit) - unitatea de procesat
    Return: N/A

*****************************************************************************/
void process_orders(UNIT *unit)
{
 switch (unit->orders[0].order)
    {
     case ORD_STOP:
        order_stop(unit);
        break;

     case ORD_HOLD:
        order_hold(unit);
        break;

     case ORD_MOVE:
        order_move(unit);
        break;

     case ORD_ATTACK:
        order_attack(unit);
        break;

     case ORD_PATROL:
        order_patrol(unit);
        break;

     case ORD_EXTRACT:
        order_extract(unit);
        break;

     case ORD_DIE:
        order_die(unit);
        break;

     default:
        remove_unit_order(unit, 0);
        break;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void build_units(UNIT *unit)
{
 BUILD *build=&unit->builds[0];

 if (build->flag==0)//cauta un loc sa puna noua unitate
    {
     build->unit=add_unit(unit->player, -1, unit_prop[build_prop[build->build].unit].name, unit->x+120, unit->y);
     build->unit->alive=FLAG_BUILT;

     build->flag=1;
    }
 if (build->flag==1)
    {
     build->time++;
     if (build->time>=1)//build_prop[build->build].time)
        {
         build->unit->alive=FLAG_ALIVE;
         remove_unit_build(unit, 0);
		 REDRAW(panel_dialog, COMMAND_OBJ);
        }

     if (unit->alive==FLAG_DEAD) remove_unit_build(unit, 0);

     if (me->selected==1 && command_opt==VIEW_BUILD && !(build->time%5)) REDRAW(panel_dialog, SELECTION_OBJ);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_builds(UNIT *unit)
{
 if (unit->builds[0].build==0) return;
 else build_units(unit);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_upgrades(UNIT *unit)
{
 UPGRADE *upgrade=&unit->upgrades[0];

 if (upgrade->upgrade==0) return;

 if (upgrade->flag==0)//cauta un loc sa puna noua unitate
    {
     upgrade->flag=1;
    }
 if (upgrade->flag==1)
    {
     upgrade->time++;
     if (upgrade->time>=upgrade_prop[upgrade->upgrade].time)
        {
         remove_unit_upgrade(unit, 0);
        }

     if (me->selected==1 && command_opt==VIEW_UPGRADE   && !(upgrade->time%5)) REDRAW(panel_dialog, SELECTION_OBJ);
    }
}
/*****************************************************************************

    Function: add_unit

    Description: adauga o unitate la lista
    Parameters: (player)- cui apartine
                (nr)    - numarul unitatii - -1 ca sa aloce singur un numar
                (type)  - tipul unitatii
                (x, y)  - pozitia pe harta

    Return: pointer la unitate daca ok
            NULL daca erroare

*****************************************************************************/
UNIT *add_unit(PLAYER *p, int nr, char *name, int x, int y)
{
 UNIT *temp;
 int i, type;

 for (i=0;i<unit_types;i++)
  if (!stricmp(name, unit_prop[i].name)) break;

 if (i>=unit_types) return NULL;
 type=i;

 temp=alloc_mem(sizeof(UNIT));
 if (!temp) return NULL;

 temp->alive=FLAG_ALIVE;
 temp->type=type;
 if (nr<0) temp->nr=global_object_nr++;
 else temp->nr=nr;
 temp->x=x;
 temp->y=y;
 temp->life     =unit_prop[type].life;
 temp->shield   =unit_prop[type].shield;
 temp->mana     =unit_prop[type].mana;
 temp->aluminium=unit_prop[type].aluminium;
 temp->steel    =unit_prop[type].steel;
 temp->gold     =unit_prop[type].gold;
 temp->player   =p;

 if (unit_prop[type].script)
    {
     temp->prog=scCreate_Instance(unit_prop[type].script, "");
     if (!temp->prog) goto ERROR;

     temp->_init_=scGet_Symbol(temp->prog, "init");
     temp->_shutdown_=scGet_Symbol(temp->prog, "shutdown");
     temp->_die_=scGet_Symbol(temp->prog, "kill");
     temp->_damage_=scGet_Symbol(temp->prog, "damage");
     temp->_draw_=scGet_Symbol(temp->prog, "draw");
     temp->_process_=scGet_Symbol(temp->prog, "process");
     temp->_process_ai_=scGet_Symbol(temp->prog, "process_ai");
    }

 temp->anim=animdup(unit_prop[type].anim);
 temp->icon=animdup(unit_prop[type].icon);

 fix_map_coords_centre_f(&temp->x, &temp->y, temp->anim->w, temp->anim->h);

 link_unit(p, temp);

 return temp;

ERROR:
 if (temp->prog)
    {
     scKill_Instance(temp->prog);
     scFree_Instance(temp->prog);
    }

 destroy_anim(temp->icon);
 destroy_anim(temp->anim);
 free_mem(temp);

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void link_unit(struct PLAYER *p, UNIT *u)
{
 u->player=p;

 if (p->units==NULL) p->units=u;
 else
    {
     u->prev=p->last_unit;
     p->last_unit->next=u;
    }
 p->last_unit=u;

 CALL_SCRIPT1(u, init, u);
}
/*****************************************************************************

    Function: remove_unit

    Description: sterge o unitate din lista
    Parameters: pointer la unitate
    Return: N/A

*****************************************************************************/
void remove_unit(UNIT *u)
{
 assert(u);

 if (u->player->units==u)
    {
     u->player->units=u->next;
     if (u->next) u->next->prev=NULL;
    }
 else
    {
     if (u->prev) u->prev->next=u->next;
     if (u->next) u->next->prev=u->prev;
    }

 if (u->player->last_unit==u) u->player->last_unit=u->prev;

 CALL_SCRIPT1(u, shutdown, u);
 if (u->prog) scFree_Instance(u->prog);

 while (u->bullets) remove_bullet(u->bullets);

 destroy_anim(u->icon);
 destroy_anim(u->anim);

 free_mem(u);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void damage_unit(UNIT *v, UNIT *a, int damage)
{
 int i;
 int armour;
 ORDER o;

 v->attacker=a;

 armour=unit_prop[v->type].armour*10;//armura opreste 'armour' % din damage
 if (damage<0) damage=weapon_prop[unit_prop[a->type].weapon].damage;

 v->shield-=damage;

 if (v->shield<0)
    {
     damage=-v->shield;
     damage-=((float)damage*(float)armour/100.0);
     if (damage<1) damage=1;

     v->life-=damage;
     v->shield=0;
    }

 if (v->life<=0)
    {
	 o.order=ORD_DIE;
     add_unit_order(v, &o, 0);
     a->kills++;
    }

 CALL_SCRIPT1(v, damage, v);

 for (i=0;i<MAX_SELECTED;i++)
  if (me->selection[i]==v)
    {
     REDRAW(panel_dialog, SELECTION_OBJ);
     break;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void damage(UNIT *v, UNIT *a)
{
 UNIT   *u[32];
 int    sel, splash, i, damage;
 float  dist;

 damage_unit(v, a, -1);

 splash=weapon_prop[unit_prop[a->type].weapon].splash;
 if (splash>10)
    {
     sel=get_units(me, -1, -1, v->x-splash, v->y-splash, splash*2, splash*2, u, 32);
     if (sel>0) for (i=0;i<sel;i++)
        {
         if (u[i]!=v && u[i]!=a)
            {
             dist=get_dist(v->x, v->y, u[i]->x, u[i]->y);

             damage=(1-dist/(float)splash)*weapon_prop[unit_prop[a->type].weapon].damage;
             if (damage>weapon_prop[unit_prop[a->type].weapon].damage-1) damage=weapon_prop[unit_prop[a->type].weapon].damage-1;

             if (damage>0) damage_unit(u[i], a, damage);
            }
        }
    }
}
/*****************************************************************************

    Function: draw_units

    Description: deseneaza navele
    Parameters: (player) - playerul
    Return: N/A

*****************************************************************************/
void draw_units(PLAYER *p)
{
 UNIT *temp;
 int xs, ys;
 int w, h, c;

 for (temp=p->units; temp; temp=temp->next)
    {
     if (!temp->anim) continue;

     xs=temp->x-camera_x;
     ys=temp->y-camera_y;

     if (temp->alive==FLAG_ALIVE)
        {
         if (temp->anim->trans<255)
            {
             draw_anim_centre(camera, temp->anim, xs, ys);
             draw_anim_lights_centre(camera, temp->anim, xs, ys);

             if (temp->selected && (p==me || temp==me->selection[0]))
                {
                 w=((BITMAP *)gfx[temp->anim->sprite].dat)->w;
                 h=((BITMAP *)gfx[temp->anim->sprite].dat)->h;
            
                 if (p==me) c=makecol(64, 64, 255);
                 else if (relations[me->nr][p->nr]&REL_ENEMY) c=makecol(255,    0, 0);
                 else c=makecol(255, 255, 0);
            
                 draw_target_centre(camera, xs, ys, w/4+2, h/4+2, MIN(w, h)/4+2, c, itofix(temp->anim->rot));
                }

             add_camera_dirty_centre(xs, ys, temp->anim->w+2, temp->anim->h+2, 2);
            }
    
         draw_bullets(temp);
        }
     else if (temp->alive==FLAG_DEAD)
        {
         if (temp->anim->trans<255)
            {
             draw_anim_centre(camera, temp->anim, xs, ys);
             draw_anim_lights_centre(camera, temp->anim, xs, ys);

             add_camera_dirty_centre(xs, ys, temp->anim->w+2, temp->anim->h+2, 2);
            }
    
         draw_bullets(temp);
        }
     else if (temp->alive==FLAG_BUILT)
        {
         if (temp->anim->trans<255)
            {
             set_trans_blend(0, 0, 0, rand()%255);
             draw_trans_anim_centre(camera, temp->anim, xs, ys);
    
             add_camera_dirty_centre(xs, ys, temp->anim->w, temp->anim->h, 2);
            }
        }

     CALL_SCRIPT1(temp, draw, temp);

     temp->anim->lit=0;
    }
}
/*****************************************************************************

    Function: process_units

    Description: proceseaza navele
    Parameters: (player) - playerul
    Return: N/A

*****************************************************************************/
void process_units(PLAYER *p)
{
 UNIT *temp, *temp1;
 int s;

 p->unit_count=0;
 temp=p->units;
 while (temp)
    {
     temp1=temp->next;

	 p->tech_tree[temp->type]=1;

//   temp->anim->add=255;

     temp->shield+=0.015;
     if (temp->shield>unit_prop[temp->type].shield+0.015) temp->shield=unit_prop[temp->type].shield;
     else if (p==me && temp->selected==1)
        {
         s=temp->shield*100;
         if (s%10==0) REDRAW(panel_dialog, SELECTION_OBJ);
        }

     temp->mana+=0.015;
     if (temp->mana>unit_prop[temp->type].mana+0.015) temp->mana=unit_prop[temp->type].mana;
     else if (p==me && temp->selected==1)
        {
         s=temp->mana*100;
         if (s%10==0) REDRAW(panel_dialog, SELECTION_OBJ);
        }

     if (temp->attacker) if (temp->attacker->alive==FLAG_DEAD) temp->attacker=NULL;

     CALL_SCRIPT1(temp, process, temp);
     if (p->type==PLAYER_COMPUTER) CALL_SCRIPT1(temp, process_ai, temp);

     if (temp->alive==FLAG_ALIVE)
        {
         if (p==me) temp->anim->trans=0;
         else if (relations[p->nr][me->nr]&REL_VISION) temp->anim->trans=0;
         else
            {
             if (get_unit_visibility(me, temp))
                {
                 if (temp->anim->trans<6) temp->anim->trans=6;
                 temp->anim->trans-=6;
                }
             else
                {
                 if (temp->anim->trans>249) temp->anim->trans=249;
                 temp->anim->trans+=6;
                }
            }

         if (unit_prop[temp->type].cloaking_type>0 && temp->anim->trans<112) temp->anim->trans=112;

         process_anim(temp->anim);
         process_bullets(temp);

         if (unit_prop[temp->type].order_count>0) process_orders(temp);
         if (unit_prop[temp->type].build_count>0) process_builds(temp);
         if (unit_prop[temp->type].upgrade_count>0) process_upgrades(temp);
        }
     else if (temp->alive==FLAG_BUILT)
        {
         process_anim(temp->anim);
        }
     else if (temp->alive==FLAG_DEAD)
        {
         if (temp->anim->trans>243) temp->anim->trans=243;
         temp->anim->trans+=12;

         process_anim(temp->anim);
         process_bullets(temp);

         temp->life-=UPDATE_TIME;
         if (temp->life<0) remove_unit(temp);
        }

     p->unit_count++;
     temp=temp1;
    }
}
