/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	The main script header file is included here
 */

#include "standard.h"
#include "script.h"

#include "gfx.h"
#include "file.h"
#include "alliance.h"
#include "player.h"
#include "unit.h"
#include "misc.h"
#include "map.h"
#include "particle.h"
#include "panel.h"
#include "sys/stat.h"

char internal_header[]=
"#define MAX_VARS                        8                                                                                  \n"
"                                                                                                                           \n"
"#define RES_MAX_W                       640                                                                                \n"
"#define RES_MAX_H                       480                                                                                \n"
"#define DIRTY_DIV                       8                                                                                  \n"
"#define DIRTY_DIV_BITS                  3                                                                                  \n"
"#define CAMERA_X                        0                                                                                  \n"
"#define CAMERA_Y                        0                                                                                  \n"
"#define CAMERA_W                        640                                                                                \n"
"#define CAMERA_H                        342                                                                                \n"
"                                                                                                                           \n"
"#define GFX_FLAG_INITIALIZED            1                                                                                  \n"
"#define GFX_FLAG_VSYNC                  1024                                                                               \n"
"#define GFX_FLAG_AALIASING              2048                                                                               \n"
"#define GFX_FLAG_PRECACHE               4096                                                                               \n"
"                                                                                                                           \n"
"#define ANIM_STOP_FLAG                  1                                                                                  \n"
"#define ANIM_MOVE_FLAG                  2                                                                                  \n"
"#define ANIM_BUILD_FLAG                 4                                                                                  \n"
"#define ANIM_DIE_FLAG                   8                                                                                  \n"
"#define ANIM_FIRE_FLAG                  16                                                                                 \n"
"#define ANIM_FOCUS_FLAG                 32                                                                                 \n"
"#define ANIM_DOUBLE_FLAG                64                                                                                 \n"
"                                                                                                                           \n"
"#define MAX_LOCATIONS                   12                                                                                 \n"
"                                                                                                                           \n"
"//----------------------------------------------------------------------                                                   \n"
"typedef struct ANIM                                                                                                        \n"
"        {                                                                                                                  \n"
"         int    w, h;                                                                                                      \n"
"         int    x, y;                       //pozitia vechii afisari                                                       \n"
"                                                                                                                           \n"
"         int    _init_;                     //adresele procedurilor                                                        \n"
"         int    _shutdown_;                                                                                                \n"
"         int    _draw_;                                                                                                    \n"
"         int    _flags_;                                                                                                   \n"
"         int    _process_;                                                                                                 \n"
"                                                                                                                           \n"
"         void   *prog;                      //instructiunile de prelucrare a frame-urilor                                  \n"
"                                                                                                                           \n"
"         int    flags;                                                                                                     \n"
"         int    lx[MAX_LOCATIONS];          //x                                                                            \n"
"         int    ly[MAX_LOCATIONS];          //y                                                                            \n"
"         int    ls[MAX_LOCATIONS];          //sprite-ul din locatie                                                        \n"
"         int    wx[MAX_LOCATIONS];          //x                                                                            \n"
"         int    wy[MAX_LOCATIONS];          //y                                                                            \n"
"         int    ws[MAX_LOCATIONS];          //sprite-ul din locatie                                                        \n"
"         float  timer;                                                                                                     \n"
"         int    sprite;                     //sprite-ul de afisat                                                          \n"
"         float  speed;                                                                                                     \n"
"         int    dir;                                                                                                       \n"
"         int    trans;                      //transparenta                                                                 \n"
"         int    add;                        //add                                                                          \n"
"         int    lit, lit_r, lit_g, lit_b;   //lit                                                                          \n"
"         int    aaliasing;                  //cu antialiasing sau nu                                                       \n"
"         int    rot_flag;                   //rotatia (dez)activata                                                        \n"
"         int    rot;                        //rotatia frame-ului                                                           \n"
"         int    done;                       //1 - s-a terminat                                                             \n"
"        } ANIM;                                                                                                            \n"
"                                                                                                                           \n"
"//----------------------------------------------------------------------                                                   \n"
"#define PLAYER_LOCAL        0                                                                                              \n"
"#define PLAYER_COMPUTER     1                                                                                              \n"
"#define PLAYER_NET          2                                                                                              \n"
"                                                                                                                           \n"
"#define MAX_PLAYERS         8                                                                                              \n"
"#define MAX_SELECTED        12                                                                                             \n"
"#define MAX_GROUPS          10                                                                                             \n"
"                                                                                                                           \n"
"#define REL_ME              1                                                                                              \n"
"#define REL_ENEMY           2                                                                                              \n"
"#define REL_ALLIES          4                                                                                              \n"
"#define REL_NEUTRAL         8                                                                                              \n"
"#define REL_VISION          16                                                                                             \n"
"                                                                                                                           \n"
"//----------------------------------------------------------------------                                                   \n"
"typedef struct GROUP                                                                                                       \n"
"{                                                                                                                          \n"
"	int		 selected;                                                                                                      \n"
"   void	 *selection[MAX_SELECTED];                                                                                      \n"
"} GROUP;                                                                                                                   \n"
"                                                                                                                           \n"
"typedef struct PLAYER                                                                                                      \n"
"{                                                                                                                          \n"
"     int    flags;                      //                                                                                 \n"
"     int    type;                       //local sau net                                                                    \n"
"     int    nr;                         //numarul                                                                          \n"
"                                                                                                                           \n"
"     char   name[32];                   //numele                                                                           \n"
"     int    color;                      //culoarea                                                                         \n"
"     int    aluminium;                  //cat aluminiu are                                                                 \n"
"     int    steel;                      //cat otel are                                                                     \n"
"     int    gold;                       //    aur                                                                          \n"
"     int    supply;                     //supply                                                                           \n"
"                                                                                                                           \n"
"	  int	 tech_tree[256];				//ce unitati au fost construite                                                 \n"
"                                                                                                                           \n"
"     void   *radar;              //fiecare player are un radar                                                             \n"
"                                                                                                                           \n"
"     int    unit_count;                 //cate unitati are                                                                 \n"
"     void   *units, *last_unit;    //lista cu unitati                                                                      \n"
"                                                                                                                           \n"
"     int    selected;                   //cate unitati am selectat                                                         \n"
"     void   *selection[MAX_SELECTED];                                                                                      \n"
"                                                                                                                           \n"
"	  GROUP	group[MAX_GROUPS];                                                                                              \n"
"                                                                                                                           \n"
"     //AI stuff                                                                                                            \n"
"     int    _init_;                     //adresele procedurilor                                                            \n"
"     int    _shutdown_;                                                                                                    \n"
"     int    _draw_;                                                                                                        \n"
"     int    _process_;                                                                                                     \n"
"                                                                                                                           \n"
"     void   *prog;                  //instanta master                                                                      \n"
"                                                                                                                           \n"
"     void   *prev, *next;                                                                                                  \n"
"} PLAYER;                                                                                                                  \n"
"                                                                                                                           \n"
"//----------------------------------------------------------------------                                                   \n"
"#define FLAG_ALIVE              1       //unitatea e vie                                                                   \n"
"#define FLAG_DEAD               2       //unitatea a murit dar mai exist                                                   \n"
"#define FLAG_BUILT              3       //unitatea este construita                                                         \n"
"                                                                                                                           \n"
"//selectata sau nu?                                                                                                        \n"
"#define FLAG_SELECTED           1       //selectata                                                                        \n"
"                                                                                                                           \n"
"#define MAX_UNIT_TYPES          64                                                                                         \n"
"#define MAX_WEAPON_TYPES        32                                                                                         \n"
"#define MAX_ORDER_TYPES         32                                                                                         \n"
"#define MAX_BUILD_TYPES         32                                                                                         \n"
"#define MAX_UPGRADE_TYPES       32                                                                                         \n"
"                                                                                                                           \n"
"#define MAX_UNITS               4096    //maximul de unitati                                                               \n"
"#define MAX_ORDERS              8       //cate ordine poate accepta in s                                                   \n"
"#define MAX_BUILDS              5       //cate unitati poate tine in sti                                                   \n"
"#define MAX_UPGRADES            1                                                                                          \n"
"#define ZOMBIE_TIME             2000    //cat sta o unitate in starea de                                                   \n"
"#define ROT_TIME                16      //la cati pasi o unitate corecte                                                   \n"
"#define CHECK_TIME              32      //la cati pasi verifica perimetr                                                   \n"
"#define SLOW_AMOUNT             20.0    //viteza de incetinire                                                             \n"
"#define ROT_AMOUNT              8       //viteza de rotatie                                                                \n"
"                                                                                                                           \n"
"#define ORD_STOP                0                                                                                          \n"
"#define ORD_HOLD                1                                                                                          \n"
"#define ORD_MOVE                2                                                                                          \n"
"#define ORD_ATTACK              3                                                                                          \n"
"#define ORD_PATROL              4                                                                                          \n"
"#define ORD_EXTRACT             5                                                                                          \n"
"#define ORD_DIE                 100                                                                                        \n"
"                                                                                                                           \n"
"//parametrii ordinelor                                                                                                     \n"
"#define ORD_PARAM_NONE          0                                                                                          \n"
"#define ORD_PARAM_LOCATION      1                                                                                          \n"
"#define ORD_PARAM_UNIT          2                                                                                          \n"
"#define ORD_PARAM_LOCUNIT       3                                                                                          \n"
"                                                                                                                           \n"
"#define WPN_TYPE_BULLET         0                                                                                          \n"
"#define WPN_TYPE_MISSILE        1                                                                                          \n"
"#define WPN_TYPE_FLASH          2                                                                                          \n"
"#define WPN_TYPE_KAMIKAZE       3                                                                                          \n"
"                                                                                                                           \n"
"//----------------------------------------------------------------------                                                   \n"
"typedef struct UNIT_PROP                    //proprietatile unitatilor                                                     \n"
"    {                                                                                                                      \n"
"     char   name[256];                      //numele                                                                       \n"
"     int    supply;                         //cat supply consuma                                                           \n"
"     int    aluminium;                      //masa de aluminiu                                                             \n"
"     int    steel;                          //masa de otel                                                                 \n"
"     int    gold;                           //masa de aur                                                                  \n"
"     int    life;                           //viata                                                                        \n"
"     int    mana;                           //magie                                                                        \n"
"     int    shield;                         //scut                                                                         \n"
"     int    armour;                         //armura                                                                       \n"
"     int    speed;                          //viteza de deplasare                                                          \n"
"     int    agressivity;                    //cum raspunde la atac                                                         \n"
"     int    radar_range;                    //raza de vedere                                                               \n"
"     int    radar_type;                     //tipul radarului: 0-normal, 1- nivelul de detectie                            \n"
"     int    cloaking_type;                  //daca are dispozitiv de invizibilitate 0-nu, 1- nivelul de ascundere          \n"
"     int    rot_speed;                      //viteza de rotatie                                                            \n"
"     int    weapon;                         //cu ce arma este dotata                                                       \n"
"                                                                                                                           \n"
"     int    order_count;                    //cate ordine sunt definite mai jos                                            \n"
"     int    order[MAX_ORDER_TYPES];			//ce ordine accepta                                                         \n"
"                                                                                                                           \n"
"     int    build_count;                    //                                                                             \n"
"     int    build[MAX_BUILD_TYPES];			//ce poate construi                                                         \n"
"                                                                                                                           \n"
"	  int    upgrade_count;                                                                                                 \n"
"     int    upgrade[MAX_UPGRADE_TYPES];		//ce upgrade-uri accepta                                                    \n"
"     int    upgrade_level[MAX_UPGRADE_TYPES];//nivelele upgrade-urilor                                                     \n"
"                                                                                                                           \n"
"     int    prerequiste[MAX_UNIT_TYPES];    //ce este necesar inainte de a o putea construi                                \n"
"     int    prerequiste_count;              //                                                                             \n"
"                                                                                                                           \n"
"     char   *_script;                       //scriptul                                                                     \n"
"                                                                                                                           \n"
"     void   *anim;                     //animatia                                                                          \n"
"     void   *icon;                     //iconita de selectare                                                              \n"
"    } UNIT_PROP;                                                                                                           \n"
"                                                                                                                           \n"
"typedef struct WEAPON_PROP                  //proprietatile armelor                                                        \n"
"    {                                                                                                                      \n"
"     char   name[256];                      //numele                                                                       \n"
"     int    bullet_type;                    //tipul armei - bullet, miss                                                   \n"
"     int    damage;                         //cat damage face                                                              \n"
"     int    rate;                           //cat de repede trage                                                          \n"
"     int    splash;                         //face damage si pe langa                                                      \n"
"     int    range;                          //raza de actiune                                                              \n"
"     int    speed;                          //viteza glontului                                                             \n"
"                                                                                                                           \n"
"     void   *anim;                          //animatia                                                                     \n"
"    } WEAPON_PROP;                                                                                                         \n"
"                                                                                                                           \n"
"typedef struct ORDER_PROP                   //proprietatile ordinelor                                                      \n"
"    {                                                                                                                      \n"
"     char   name[256];                      //numele                                                                       \n"
"     int    params;                         //este incarcat din order_ty                                                   \n"
"     char   key;                            //shortcut                                                                     \n"
"                                                                                                                           \n"
"     void   *icon;                          //iconita                                                                      \n"
"    } ORDER_PROP;                                                                                                          \n"
"                                                                                                                           \n"
"typedef struct BUILD_PROP                   //proprietatile ordinelor                                                      \n"
"    {                                                                                                                      \n"
"     char   name[256];                      //numele                                                                       \n"
"     int    unit;																											\n"
"     int    time;                           //timpul de constructie                                                        \n"
"     int    aluminium;                      //cat aluminiu necesita la c                                                   \n"
"     int    steel;                          //este defapt masa navei+rez                                                   \n"
"     int    gold;                                                                                                          \n"
"     int    supply;                         //cat supply produce - acest                                                   \n"
"                                                                                                                           \n"
"     char   key;                            //shortcut                                                                     \n"
"                                                                                                                           \n"
"     void   *icon;                          //iconita                                                                      \n"
"    } BUILD_PROP;                                                                                                          \n"
"                                                                                                                           \n"
"typedef struct UPGRADE_PROP                 //proprietatile upgrade-uril                                                   \n"
"    {                                                                                                                      \n"
"     char   name[256];                      //numele                                                                       \n"
"     int    time;                                                                                                          \n"
"     int    aluminium;                                                                                                     \n"
"     int    aluminium_factor;                                                                                              \n"
"     int    steel;                                                                                                         \n"
"     int    steel_factor;                                                                                                  \n"
"     int    gold;                                                                                                          \n"
"     int    gold_factor;                                                                                                   \n"
"                                                                                                                           \n"
"     char   key;                                                                                                           \n"
"                                                                                                                           \n"
"     void   *icon;                                                                                                         \n"
"    } UPGRADE_PROP;                                                                                                        \n"
"                                                                                                                           \n"
"typedef struct ORDER                        //ordin                                                                        \n"
"    {                                                                                                                      \n"
"     int    order;                          //ordinul propriuzis                                                           \n"
"     int    flag;                           //folosit de ordin intern                                                      \n"
"                                                                                                                           \n"
"     float  x, y;                           //parametrii: - locatie                                                        \n"
"                                                                                                                           \n"
"     void   *target;                        //            - tinta                                                          \n"
"     void   *temp_target;                   //tinta temporara                                                              \n"
"                                                                                                                           \n"
"     int    i0,  i1,  i2,  i3, i4;          //variabile interne                                                            \n"
"     float  f0,  f1,  f2,  f3, _f4;                                                                                        \n"
"    } ORDER;                                                                                                               \n"
"                                                                                                                           \n"
"typedef struct BUILD                                                                                                       \n"
"    {                                                                                                                      \n"
"     int    build;                          //ce construieste                                                              \n"
"     int    flag;                           //folosit intern                                                               \n"
"     int    time;                           //cat timp s-a scurs din con                                                   \n"
"                                                                                                                           \n"
"     void   *unit;                          //unitatea construita                                                          \n"
"     int    i0,  i1,  i2,  i3, i4;          //variabile interne                                                            \n"
"     float  f0,  f1,  f2,  f3, _f4;                                                                                        \n"
"    } BUILD;                                                                                                               \n"
"                                                                                                                           \n"
"typedef struct UPGRADE                                                                                                     \n"
"    {                                                                                                                      \n"
"     int    upgrade;                        //ce upgrade?                                                                  \n"
"     int    flag;                           //folosit intern                                                               \n"
"     int    time;                                                                                                          \n"
"                                                                                                                           \n"
"     int    i0,  i1,  i2,  i3, i4;          //variabile interne                                                            \n"
"     float  f0,  f1,  f2,  f3, _f4;                                                                                        \n"
"    } UPGRADE;                                                                                                             \n"
"                                                                                                                           \n"
"typedef struct UNIT                                                                                                        \n"
"    {                                                                                                                      \n"
"     int    type;                           //tipul unitatii                                                               \n"
"     int    nr;                             //numarul ei - poate fi identificata doar prin acest numar                     \n"
"                                                                                                                           \n"
"     int    alive;                          //unitatea este vie, moarta, construita                                        \n"
"     int    selected;                       //unitatea este selectata                                                      \n"
"     int    mark;                           //marcaj                                                                       \n"
"                                                                                                                           \n"
"     float  x, y;                           //pozitia.                                                                     \n"
"     float  dx, dy;                         //incrementul pe fiecare directie                                              \n"
"     int    rally_x, rally_y;               //rally point                                                                  \n"
"                                                                                                                           \n"
"     int    load;                           //incarcatura                                                                  \n"
"     int    aluminium;                      //masa de metal                                                                \n"
"     int    steel;                                                                                                         \n"
"     int    gold;                                                                                                          \n"
"                                                                                                                           \n"
"     float  life;                           //viata curenta                                                                \n"
"     float  mana;                           //magia curenta                                                                \n"
"     float  shield;                         //scutul curent                                                                \n"
"     float  speed;                          //viteza actuala                                                               \n"
"     float  acc;                            //acceleratia actuala                                                          \n"
"     int    kills;                          //cate nave a omorat                                                           \n"
"                                                                                                                           \n"
"     int    bullet_timer;                   //cat timp s-a scurs de la ultimul bullet                                      \n"
"     int    bullet_count;                   //cate gloante sunt in bullets                                                 \n"
"     void   *bullets;                //gloante                                                                             \n"
"                                                                                                                           \n"
"     ORDER      orders[MAX_ORDERS];         //stiva cu ordine                                                              \n"
"     BUILD      builds[MAX_BUILDS];         //stiva cu constructii                                                         \n"
"     UPGRADE    upgrades[MAX_UPGRADES];     //upgrade-ul curent                                                            \n"
"                                                                                                                           \n"
"     void   *anim, *icon;            //animatia, icoana si explozia                                                        \n"
"     void   *player;                 //jucatorul parinte                                                                   \n"
"     void   *attacker;               //unitatea cara ataca                                                                 \n"
"                                                                                                                           \n"
"     int    _init_;                         //adresele procedurilor                                                        \n"
"     int    _shutdown_;                                                                                                    \n"
"     int    _die_;                                                                                                         \n"
"     int    _damage_;                                                                                                      \n"
"     int    _draw_;                                                                                                        \n"
"     int    _process_;                                                                                                     \n"
"     int    _process_ai_;                                                                                                  \n"
"                                                                                                                           \n"
"     void   *prog;                      //instanta scriptului                                                              \n"
"                                                                                                                           \n"
"     void   *next, *prev;                                                                                                  \n"
"    }  UNIT;                                                                                                               \n"
"//---------------------------------------------------------------------------                                              \n"
"#define MAX_PARTICLES           32          //numarul maxim de definitii de particule                                      \n"
"                                                                                                                           \n"
"//---------------------------------------------------------------------------                                              \n"
"typedef struct PARTICLE                                                                                                    \n"
"    {                                                                                                                      \n"
"     int    type;                                                                                                          \n"
"     int    flags;                                                                                                         \n"
"                                                                                                                           \n"
"     float  x, y;                                                                                                          \n"
"     float  dx, dy;                                                                                                        \n"
"     float  x2, y2;                 //destinatia                                                                           \n"
"     float  max_speed;              //viteza maxima                                                                        \n"
"     float  speed;                  //vitaza actuala                                                                       \n"
"     float  acc;                    //acceleratia                                                                          \n"
"     int    rep;                    //de cate ori se repeta aniatia                                                        \n"
"                                                                                                                           \n"
"     int    i0, i1, i2, i3;                                                                                                \n"
"                                                                                                                           \n"
"     void   *anim;                                                                                                         \n"
"                                                                                                                           \n"
"     void   *next, *prev;                                                                                                  \n"
"    } PARTICLE;                                                                                                            \n"
"                                                                                                                           \n"
"//----------------------------------------------------------------------                                                   \n"
" //simboluri importate                                                                                                     \n"
"                                                                                                                           \n"
"#define ABS(a) ((a)>=0?(a):-(a))                                                                                           \n"
"                                                                                                                           \n"
" import float   _sin(int a);                                                                                               \n"
" import float   _cos(int a);                                                                                               \n"
" import void    LOG(const char *format, ...);                                                                              \n"
" import void    *alloc_mem(int size);                                                                                      \n"
" import void    *memset(void *buffer, int ch, int num);                                                                    \n"
" import char    *strdup(const char *source);                                                                               \n"
" import int     rand();                                                                                                    \n"
" import int     rand_lim(int min, int max);                                                                                \n"
" import int     get_rotated_pos(int *x, int *y, int a);                                                                    \n"
" import void    get_anim_point_pos(ANIM *anim, int *x, int *y);                                                            \n"
" import int     get_rot(int x1, int y1, int x2, int y2);                                                                   \n"
" import int     get_dist(int x1, int y1, int x2, int y2);                                                                  \n"
" import int     get_symbol_address(char *name);                                                                            \n"
" import void    rotate(int *src, int dest, int step);                                                                      \n"
"                                                                                                                           \n"
" import int     get_units(PLAYER *player, int rel, int type, int x, int y, int w, int h, UNIT **l, int max);               \n"
" import UNIT    *get_mark_unit(PLAYER *player, int mark, UNIT *unit, int not_this_type);                                   \n"
" import UNIT    *get_unmark_unit(PLAYER *player, int mark, UNIT *unit, int not_this_type);                                 \n"
"                                                                                                                           \n"
" import int     get_best_build(int aluminium, int steel, int gold, int supply, int i1, int i2);                            \n"
"                                                                                                                           \n"
" import int     add_unit_order(UNIT *unit, ORDER *order, int add);                                                         \n"
" import int     add_order(PLAYER *p, ORDER *order, int add);                                                               \n"
" import int     add_unit_build(UNIT *unit, BUILD *build, int add);                                                         \n"
" import int     add_build(PLAYER *p, BUILD  *b, int add);                                                                  \n"
"                                                                                                                           \n"
" import int     select(PLAYER *pl, void *p, int add);                                                                      \n"
" import void    deselect(PLAYER *pl, int nr);                                                                              \n"
" import void    clear_selection(PLAYER *p);                                                                                \n"
" import void    store_group(PLAYER *pl, int nr);                                                                           \n"
" import void    recall_group(PLAYER *pl, int nr);                                                                          \n"
"                                                                                                                           \n"
" import int     create_empty_map(int width, int height);                                                                   \n"
" import void    destroy_map();                                                                                             \n"
"                                                                                                                           \n"
" import PLAYER  *add_player(char *name, int nr, int color, int type);                                                      \n"
" import UNIT    *add_unit(PLAYER *p, int nr, char *name, int x, int y);                                                    \n"
" import PARTICLE *add_particle(int type, float x, float y, float x1, float x2, float max_speed, float acc, int rep);       \n"
"                                                                                                                           \n"
" import float camera_x;                                                                                                    \n"
" import float camera_y;                                                                                                    \n"
" import float camera_tx;                                                                                                   \n"
" import float camera_ty;                                                                                                   \n"
"                                                                                                                           \n"
" import int             unit_types;                                                                                        \n"
" import UNIT_PROP       unit_prop[MAX_UNIT_TYPES];                                                                         \n"
" import int             weapon_types;                                                                                      \n"
" import WEAPON_PROP     weapon_prop[MAX_WEAPON_TYPES];                                                                     \n"
" import int             order_types;                                                                                       \n"
" import ORDER_PROP      order_prop[MAX_ORDER_TYPES];                                                                       \n"
" import int             build_types;                                                                                       \n"
" import BUILD_PROP      build_prop[MAX_BUILD_TYPES];                                                                       \n"
" import int             upgrade_types;                                                                                     \n"
" import UPGRADE_PROP    upgrade_prop[MAX_UPGRADE_TYPES];                                                                   \n"
"                                                                                                                           \n"
" import PLAYER  *me;                                                                                                       \n"
" import char    relations[MAX_PLAYERS][MAX_PLAYERS];//relatiile dintre playeri                                             \n"
" import void    init_relations();                                                                                          \n"
" import void    set_relation(PLAYER *p1, PLAYER *p2, int rel);                                                             \n"
;

/*
 * FUNCTII EXTERNE PENTRU SCRIPT
 *
 *
 *
 */

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int get_best_build(int aluminium, int steel, int gold, int supply, int i1, int i2)
{
 int i;
 int req_aluminium, req_steel, req_gold;

 i2=i2>build_types?build_types:i2;

 for (i=i1;i<i2;i++)
    {
     req_aluminium=build_prop[i].aluminium;
     req_steel=build_prop[i].steel;
     req_gold=build_prop[i].gold;

     if (req_aluminium<=aluminium &&
         req_steel<=steel &&
         req_gold<=gold) return i;
//       build_prop[i].supply<=supply) return i;
    }

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
UNIT *get_mark_unit(PLAYER *player, int mark, UNIT *unit, int not_this_type)
{
 UNIT *temp;

 temp=player->units;
 while (temp)
  if (temp!=unit && (not_this_type?temp->type!=unit->type:1) && (temp->mark&mark))
    {
     if ((temp->alive&FLAG_ALIVE) && !(temp->selected&FLAG_SELECTED)) return temp;

     temp=temp->next;
    }
  else temp=temp->next;

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
UNIT *get_unmark_unit(PLAYER *player, int mark, UNIT *unit, int not_this_type)
{
 UNIT *temp;

 temp=player->units;
 while (temp)
  if (temp!=unit && (not_this_type?temp->type!=unit->type:1) && !(temp->mark&mark))
    {
     if (temp->alive&FLAG_ALIVE) return temp;

     temp=temp->next;
    }
  else temp=temp->next;

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void get_anim_point_pos(ANIM *anim, int *x, int *y)
{
 if (!anim) return;

 get_rotated_pos(x, y, anim->rot);

 (*x)+=anim->x+((BITMAP *)gfx[anim->sprite].dat)->w/2;
 (*y)+=anim->y+((BITMAP *)gfx[anim->sprite].dat)->h/2;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int get_symbol_address(char *name)
{
 return scGet_Symbol(scActual_Instance, name);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int rand_lim(int min, int max)
{
 if (min<0) min=0;
 if (max<1) max=1;
 return (rand()%(max-min))+min;
}
/* 61
 * GATA CU FUNCTIILE EXTERNE
 *
 *
 *
 */
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
scInstance *compile_file(char *path, char *filename)
{
 scScript script;
 scInstance *prog;
 char source_name[256];
 char compiled_name[256];
 char compiled_dir[256];
 FILE *f;
 int size;

 error_flag=0;

 if (!stricmp(filename, "none")) return NULL;

 sprintf(source_name, "%s\\%s%s", game_dir, path, filename);
 sprintf(compiled_name, "%s\\%scompiled\\%s", game_dir, path, filename);
 sprintf(compiled_dir, "%s\\%scompiled", game_dir, path);

 mkdir(compiled_dir);

 //incearca sa incarce versiunea compilata
 if (compare_file_time(source_name, compiled_name) || rebuild) goto COMPILE;

 f=fopen(compiled_name, "rb");
 if (!f) goto COMPILE;

 if (fgeti(f)!=scSeeR_Get(scSeeR_StackSize))
    {
     fclose(f);
     goto COMPILE;
    }

 size=fgeti(f);
 script=alloc_mem(size+1);
 if (!script)
    {
     fclose(f);
     goto COMPILE;
    }

 fread(script, size, 1, f);
 script[size]=0;

 fclose(f);

 goto SCRIPT_OK;

 //incearca sa compileze
COMPILE:
 if (!exists(source_name))
    {
     error_flag=1;
     sprintf(error_msg, "Could not find '%s'", source_name);

     return NULL;
    }

 script=scCompile_File(source_name);
 if (scErrorNo!=scOK)
    {
     error_flag=1;
     sprintf(error_msg, "%s: %s", filename, scErrorMsg);

     return NULL;
    }

 size=scGet_Script_Size(script);

 f=fopen(compiled_name, "wb");
 if (!f) goto SCRIPT_OK;

 fputi(scSeeR_Get(scSeeR_StackSize), f);
 fputi(size, f);
 fwrite(script, size, 1, f);
 fclose(f);

 set_file_time(compiled_name, get_file_time(source_name));

SCRIPT_OK:
 prog=scCreate_Instance(script, "");
 if (scErrorNo!=scOK)
    {
     error_flag=1;
     sprintf(error_msg, "%s: %s", filename, scErrorMsg);

     return NULL;
    }

 return prog;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void init_externals()
{
 scAddExtSym(LOG);
 scAddExtSym(alloc_mem);
 scAddExtSym(memset);
 scAddExtSym(strdup);
 scAddExtSym(rand);
 scAddExtSym(rand_lim);
 scAddExtSym(get_rotated_pos);
 scAddExtSym(get_anim_point_pos);
 scAddExtSym(get_rot);
 scAddExtSym(get_dist);
 scAddExtSym(get_symbol_address);
 scAddExtSym(rotate);

 scAddExtSym(get_units);
 scAddExtSym(get_mark_unit);
 scAddExtSym(get_unmark_unit);

 scAddExtSym(get_best_build);

 scAddExtSym(add_unit_order);
 scAddExtSym(add_order);
 scAddExtSym(add_unit_build);
 scAddExtSym(add_build);

 scAddExtSym(select);
 scAddExtSym(deselect);
 scAddExtSym(clear_selection);
 scAddExtSym(store_group);
 scAddExtSym(recall_group);

 scAddExtSym(create_empty_map);
 scAddExtSym(destroy_map);

 scAddExtSym(add_player);
 scAddExtSym(add_unit);
 scAddExtSym(add_particle);

 scAdd_External_Symbol("camera_x", &camera_x);
 scAdd_External_Symbol("camera_y", &camera_y);
 scAdd_External_Symbol("camera_tx", &camera_tx);
 scAdd_External_Symbol("camera_ty", &camera_ty);

 scAdd_External_Symbol("unit_types", &unit_types);
 scAdd_External_Symbol("unit_prop", &unit_prop);
 scAdd_External_Symbol("weapon_types", &weapon_types);
 scAdd_External_Symbol("weapon_prop", &weapon_prop);
 scAdd_External_Symbol("order_types", &order_types);
 scAdd_External_Symbol("order_prop", &order_prop);
 scAdd_External_Symbol("upgrade_types", &upgrade_types);
 scAdd_External_Symbol("upgrade_prop", &upgrade_prop);

 scAdd_External_Symbol("me", &me);
 scAdd_External_Symbol("relations", &relations);
 scAddExtSym(init_relations);
 scAddExtSym(set_relation);

 scAdd_Internal_Header("header", internal_header);
}
/*****************************************************************************

    Function: ai_init

    Description: compileaza scripturi-le pt unitati, grupuri, si brain-ul
    Parameters:
    Return:

*****************************************************************************/
int init_script()
{
 if (open_config_file("config.ini")<0)
    {
     strcpy(error_msg, "Error opening 'config.ini'");
     error_flag=1;

     return -1;
    }

 scInit_SeeR();
 init_externals();

 anim_stack_size=_get_config_int("scripting", "anim stack size", 512);
 _set_config_int("scripting", "anim stack size", anim_stack_size);
 LOG("\n\tAnimation stack size: %d", anim_stack_size);

 ai_stack_size=_get_config_int("scripting", "ai stack size", 4096);
 _set_config_int("scripting", "ai stack size", ai_stack_size);
 LOG("\n\tAI stack size: %d", ai_stack_size);

 map_stack_size=_get_config_int("scripting", "map stack size", 4096);
 _set_config_int("scripting", "map stack size", map_stack_size);
 LOG("\n\tMap stack size: %d", map_stack_size);

 scSeeR_Set(scSeeR_ExprOpcode, 0);
 //scSeeR_Set(scSeeR_OpenDebug, "seer.log");
 //scSeeR_Set(scSeeR_Debugging, 1);

 close_config_file();

 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void shutdown_script()
{
}
