/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Every player has a radar used to determine unit visibility. Here is the code
 */

#include "standard.h"
#include "radar.h"

//#include "gfx.h"
//#include "alliance.h"
//#include "gui.h"
//#include "guiproc.h"
#include "map.h"
#include "unit.h"
#include "player.h"
#include "file.h"
#include "misc.h"
//#include "particle.h"
//#include "netint.h"

/*****************************************************************************

    Function: radar_proc

    Description: procedura handler
    Parameters:
    Return:

*****************************************************************************/
void put_in_radar(BITMAP *radar, int x, int y, int radius, char level)
{
 int cx, cy;
 int df;
 int d_e;
 int d_se;
 int x1, x2;
 unsigned char *d, *e;

 x=(float)x*radar_x_ratio;
 y=(float)y*radar_y_ratio;
 radius=(float)radius*MIN(radar_x_ratio, radar_y_ratio);                        

 cx=0;
 cy=radius;
 df=1-radius;
 d_e=3;
 d_se=-2*radius+5;

 do
    {
     x1=x-cy+1;
     x2=cy*2;

     if (x1<0)
        {
         x2=x2+x1;
         x1=0;
        }
     if (x1+x2>=128) x2=128-x1;

     if (x1<128 && x2>0)
        {
         if (y-cx>=0 && y-cx<128)
            {
             d=radar->line[y-cx]+x1;
             e=d+x2;
             for (;d<e;d++) if (*d<level) *d=level;
            }
    
         if (y+cx>=0 && y+cx<128)
            {
             d=radar->line[y+cx]+x1;
             e=d+x2;
             for (;d<e;d++) if (*d<level) *d=level;
            }
        }

     if (df < 0)
        {
	     df += d_e;
         d_e += 2;
	     d_se += 2;
        }
     else
        {
	     if (cx != cy)
            {
             x1=x-cx+1;
             x2=cx*2;
    
             if (x1<0)
                {
                 x2=x2+x1;
                 x1=0;
                }
             if (x1+x2>=128) x2=128-x1;

             if (x1<128 && x2>0)
                {
                 if (y-cy>=0 && y-cy<128)
                    {
                     d=radar->line[y-cy]+x1;
                     e=d+x2;
                     for (;d<e;d++) if (*d<level) *d=level;
                    }

                 if (y+cy>=0 && y+cy<128)
                    {
                     d=radar->line[y+cy]+x1;
                     e=d+x2;
                     for (;d<e;d++) if (*d<level) *d=level;
                    }
                }
	        }

	     df += d_se;
	     d_e += 2;
	     d_se += 4;
	     cy--;
        }

     cx++;

    } while (cx <= cy);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int get_unit_visibility(PLAYER *player, UNIT *unit)
{
 int v;

 if (relations[unit->player->nr][player->nr]&REL_VISION) return 1;

 v=player->radar->pages[player->radar->ready_page]->line[(int)(unit->y*radar_y_ratio)][(int)(unit->x*radar_x_ratio)];

 if (v>=1+unit_prop[unit->type].cloaking_type) return 1;
 else return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void init_radar()
{
 radar_x_ratio=128.0/(float)map.w;
 radar_y_ratio=128.0/(float)map.h;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void shutdown_radar()
{
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
RADAR *add_radar()
{
 RADAR *temp;

 temp=alloc_mem(sizeof(RADAR));
 if (!temp) return NULL;

 temp->pages[0]=create_bitmap_ex(8, 128, 128);
 temp->pages[1]=create_bitmap_ex(8, 128, 128);
 if (!temp->pages[0] || !temp->pages[1]) goto ERROR;

 return temp;

ERROR:
 if (temp->pages[0]) destroy_bitmap(temp->pages[0]);
 if (temp->pages[1]) destroy_bitmap(temp->pages[1]);

 free_mem(temp);

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void remove_radar(RADAR *r)
{
 assert(r);

 destroy_bitmap(r->pages[0]);
 destroy_bitmap(r->pages[1]);

 free_mem(r);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_radar(struct PLAYER *player)
{
 PLAYER *p;
 UNIT *u;
 int i;

 i=0;
 for (u=player->radar->last_unit; u && i<40; u=u->next)
  if (u->alive==FLAG_ALIVE)
    {
     put_in_radar(player->radar->pages[(int)(!player->radar->ready_page)], u->x, u->y, unit_prop[u->type].radar_range, (char)(unit_prop[u->type].radar_type+1));
     i++;
    }

 if (!u)//a terminat unitatile player-ului
    {
     if (!player->radar->last_unit) p=players;
     else p=player->radar->last_unit->player->next;

     for (; p; p=p->next)//cauta un nou player cu vision
      if (relations[p->nr][player->nr]&REL_VISION)
        {
         player->radar->last_unit=p->units;
         break;
        }

     if (!p)//a terminat playerii - schimba bufferul
        {
		 player->radar->ready=1;
         player->radar->last_unit=NULL;
         player->radar->ready_page=!player->radar->ready_page;
         clear(player->radar->pages[!player->radar->ready_page]);
        }
    }
 else player->radar->last_unit=u;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_radar(struct PLAYER *player)
{
 if (player->radar->last_unit) if (player->radar->last_unit->alive==FLAG_DEAD) player->radar->last_unit=NULL;
}
