#ifndef _PLAYER_H_
#define _PLAYER_H_

//---------------------------------------------------------------------------
#define PLAYER_LOCAL				0
#define PLAYER_COMPUTER				1
#define PLAYER_NET					2

#define MAX_PLAYERS					8
#define MAX_SELECTED				12
#define MAX_GROUPS					10

#define REL_ME						1
#define REL_ENEMY					2
#define REL_ALLIES					4
#define REL_NEUTRAL					8
#define REL_VISION					16

//---------------------------------------------------------------------------
typedef struct GROUP
{
	int		selected;
    struct UNIT	*selection[MAX_SELECTED];
} GROUP;

typedef struct PLAYER
{
     int    flags;                      //
     int    type;                       //local sau net
     int    nr;                         //numarul

     char   name[32];                   //numele
     int    color;                      //culoarea
     int    aluminium;                  //cat aluminiu are
     int    steel;                      //cat otel are
     int    gold;                       //    aur
     int    supply;                     //supply

	 int	tech_tree[256];				//ce unitati au fost construite

     struct RADAR  *radar;              //fiecare player are un radar

     int    unit_count;                 //cate unitati are
     struct UNIT *units, *last_unit;    //lista cu unitati

     int    selected;                   //cate unitati am selectat
     struct UNIT *selection[MAX_SELECTED];

	 GROUP	group[MAX_GROUPS];

     //AI stuff
     int    _init_;                     //adresele procedurilor
     int    _shutdown_;
     int    _draw_;
     int    _process_;

     scInstance *prog;                  //instanta master
//     int    stage, strategy, ok, used_groups;
//     int    i[MAX_VARS];
//     float  f[MAX_VARS];
     //AI stuff

     struct PLAYER *prev, *next;
} PLAYER;

//---------------------------------------------------------------------------
scScript    brain_script;               //scriptul master

int player_count;                       //cati playeri sunt
PLAYER *players, *last_player, *me;     //lista cu playeri
PLAYER *current_player;
char relations[MAX_PLAYERS][MAX_PLAYERS];//relatiile dintre playeri

int player_color[MAX_PLAYERS];          //culorile

//---------------------------------------------------------------------------
int  charge_player(PLAYER *p, int aluminium, int steel, int gold);
int  select(PLAYER *pl, struct UNIT *p, int add);
void deselect(PLAYER *pl, int nr);
void clear_selection(PLAYER *pl);
void store_group(PLAYER *pl, int nr);
void recall_group(PLAYER *pl, int nr);

PLAYER *add_player(char *name, int nr, int color, int type);
void link_player(PLAYER *p);
void remove_player(PLAYER *p);
PLAYER *nr2player(int nr);
int  player2nr(PLAYER *p);
void draw_players();
void process_players();

void init_relations();
void set_relation(PLAYER *p1, PLAYER *p2, int rel);

//---------------------------------------------------------------------------
#endif

