/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Player handling functions - includes selection
 */

#include "standard.h"
#include "player.h"

#include "radar.h"
#include "alliance.h"
#include "gfx.h"
#include "unit.h"
#include "file.h"
#include "panel.h"
#include "gui.h"
#include "map.h"
#include "netint.h"
#include "script.h"
#include "misc.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
PLAYER *nr2player(int nr)
{
 PLAYER *temp;

 if (nr<0) return NULL;

 temp=players;
 while (temp)
    {
     if (temp->nr==nr) break;

     temp=temp->next;
    }

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int player2nr(PLAYER *p)
{
 if (!p) return -1;
 else return p->nr;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int charge_player(PLAYER *p, int aluminium, int steel, int gold)
{
 int req_aluminium, req_steel, req_gold;

 req_aluminium=aluminium;
 req_steel=steel;
 req_gold=gold;

 if (req_aluminium<0 || req_steel<0 || req_gold<0)//adaug sau scad???
    {
     p->aluminium-=req_aluminium;
     p->steel-=req_steel;
     p->gold-=req_gold;
    }
 else
    {
     if (req_aluminium>p->aluminium || req_steel>p->steel || req_gold>p->gold) return -1;

     p->aluminium-=req_aluminium;
     p->steel-=req_steel;
     p->gold-=req_gold;
    }

 return 0;
}
/*****************************************************************************

    Function: select_unit

    Description: adauga o unitate la lista de selectate
    Parameters: (unit) - pointer la unitate
                (add)  - daca este 1 unitatea este adaugata pe langa celelalte
                         daca este 0 unitatea este selectata singura
    Return: indexul din lista
            -1 daca lista e plina

*****************************************************************************/
int select(PLAYER *player, UNIT *p, int add)
{
 int i;

 if (add==0)
    {
     for (i=0;i<MAX_SELECTED;i++)
      if (player->selection[i]!=NULL)
        {
         player->selection[i]->selected=0;
         player->selection[i]=NULL;
        }

     player->selection[0]=p;
     p->selected=FLAG_SELECTED;
     player->selected=1;

     i=0;
    }
 else
    {
     for (i=0;i<MAX_SELECTED;i++)
      if (player->selection[i]==p)
        {
         if (add==1) deselect(player, i);
   
         return -1;
        }                       

     for (i=0;i<MAX_SELECTED;i++)
      if (player->selection[i]==NULL)
        {
         player->selection[i]=p;
         p->selected=FLAG_SELECTED;

         break;
        }

     if (i>=MAX_SELECTED) i=-1;
     else player->selected++;
    }

 if (i>=0) REDRAW(panel_dialog, SELECTION_OBJ);
 if (i>=0) REDRAW(panel_dialog, COMMAND_OBJ);

 return i;
}
/*****************************************************************************

    Function: deselect_unit

    Description: deselecteaza o unitate
    Parameters: pointer la unitate
    Return: N/A

*****************************************************************************/
void deselect(PLAYER *pl, int nr)
{
 int i;

 if (pl->selection[nr]!=NULL) pl->selection[nr]->selected=0;

 for (i=nr;i<MAX_SELECTED-1;i++) pl->selection[i]=pl->selection[i+1];

 pl->selection[MAX_SELECTED-1]=NULL;
 pl->selected--;

 if (pl==me)
    {
     REDRAW(panel_dialog, SELECTION_OBJ);
     REDRAW(panel_dialog, COMMAND_OBJ);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void clear_selection(PLAYER *pl)
{
 while (pl->selected) deselect(pl, 0);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void store_group(PLAYER *pl, int nr)
{
 if (nr<0 || nr>=MAX_GROUPS) return;
 if (!pl->selected) return;

 pl->group[nr].selected=pl->selected;
 memcpy(pl->group[nr].selection, pl->selection, sizeof(UNIT *)*MAX_SELECTED);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void recall_group(PLAYER *pl, int nr)
{
 int i, j, same;
 int x, y;
 int x1, y1, x2, y2;

 if (nr<0 || nr>=MAX_GROUPS) return;
 if (!pl->group[nr].selected) return;

 same=1;
 x1=99999; x2=-99999;
 y1=99999; y2=-99999;
 x=1000000; y=1000000;
 for (i=0;i<MAX_SELECTED;i++)
    {
     if (pl->selection[i]!=pl->group[nr].selection[i]) same=0;

     if (pl->group[nr].selection[i]!=NULL)
        {
         x=pl->group[nr].selection[i]->x;
         y=pl->group[nr].selection[i]->y;

         if (x<x1) x1=x;
         if (x>x2) x2=x;
         if (y<y1) y1=y;
         if (y>y2) y2=y;
        }
    }

 if (same && x1!=99999)
    {
     camera_tx=x1+(x2-x1)/2-CAMERA_W/2;
     camera_ty=y1+(y2-y1)/2-CAMERA_H/2;

     fix_map_coords_f(&camera_tx, &camera_ty, CAMERA_W, CAMERA_H);

     return;
    }

 for (j=0, i=0;i<MAX_SELECTED;i++)
    {
     if (pl->group[nr].selection[i]!=NULL)
        {
         select(pl, pl->group[nr].selection[i], j);

         j=1;
        }
    }

 pl->group[nr].selected=pl->selected;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_relation(PLAYER *p1, PLAYER *p2, int rel)
{
 if (p1->nr>=0 && p1->nr<MAX_PLAYERS && p2->nr>=0 && p2->nr<MAX_PLAYERS)
 relations[p1->nr][p2->nr]=rel;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void init_relations()
{
 int i, j;

 for (j=0;j<MAX_PLAYERS;j++)
 for (i=0;i<MAX_PLAYERS;i++)
    {
     if (i==j) relations[i][j]=REL_ME | REL_VISION;
     else relations[i][j]=REL_ENEMY;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
PLAYER *add_player(char *name, int nr, int color, int type)
{
 PLAYER *temp;
// int i;

 temp=alloc_mem(sizeof(PLAYER));
 if (!temp) return NULL;

 temp->flags=FLAG_ALIVE;
 temp->nr=nr;
 temp->color=color;
 strcpy(temp->name, name);
 temp->type=type;
 temp->aluminium=50;
 temp->steel=50;
 temp->gold=50;

 temp->radar=add_radar();
 if (!temp->radar) goto ERROR;

 if (temp->type==PLAYER_LOCAL)
    {
     if (me) goto ERROR;
     me=temp;
    }

 if (temp->type==PLAYER_COMPUTER && brain_script)
    {
     temp->prog=scCreate_Instance(brain_script, "");
     if (!temp->prog) goto ERROR;

     temp->_init_=scGet_Symbol(temp->prog, "init");
     temp->_shutdown_=scGet_Symbol(temp->prog, "shutdown");
     temp->_draw_=scGet_Symbol(temp->prog, "draw");
     temp->_process_=scGet_Symbol(temp->prog, "process");
    }

 link_player(temp);

 return temp;

ERROR:
 if (temp->radar) remove_radar(temp->radar);
 if (temp->prog) scFree_Instance(temp->prog);

 free_mem(temp);

 return NULL;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void link_player(PLAYER *p)
{
 if (players==NULL)
    {
     me=p;
     players=p;
    }
 else
    {
     p->prev=last_player;
     last_player->next=p;
    }
 last_player=p;

 if (p->type==PLAYER_COMPUTER) CALL_SCRIPT1(p, init, p);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void remove_player(PLAYER *p)
{
 //int i;

 assert(p);

 if (players==p)
    {
     players=p->next;
     me=players;
     if (p->next) p->next->prev=NULL;
    }
 else
    {
     if (p->prev) p->prev->next=p->next;
     if (p->next) p->next->prev=p->prev;
    }

 if (last_player==p) last_player=p->prev;
 if (me==p)
    {
     clear_selection(me);
     me=NULL;
    }

 while (p->units) remove_unit(p->units);
 
 if (p->type==PLAYER_COMPUTER) CALL_SCRIPT1(p, shutdown, p);
 if (p->prog) scFree_Instance(p->prog);

 remove_radar(p->radar);

 free_mem(p);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_players()
{
 PLAYER *temp;

 temp=last_player;
 while (temp)
    {
	 current_player=temp;

     if (temp!=me)
        {
         draw_radar(temp);
         draw_units(temp);

         if (temp->type==PLAYER_COMPUTER) CALL_SCRIPT1(temp, draw, temp);
        }

     temp=temp->prev;
    }

 current_player=me;
 draw_radar(me);
 draw_units(me);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_computer_player(PLAYER *p)
{
 process_units(p);

 if (p->type==PLAYER_COMPUTER) CALL_SCRIPT1(p, process, p);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_net_player(PLAYER *p)
{
 process_units(p);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_local_player(PLAYER *p)
{
 memset(p->tech_tree, 0, MAX_UNIT_TYPES*4);

 process_units(p);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_players()
{
 PLAYER *temp;

 player_count=0;
 temp=players;
 while (temp)
    {
	 current_player=temp;

     process_radar(temp);

     if (temp->type==PLAYER_COMPUTER) process_computer_player(temp);
     else if (temp->type==PLAYER_NET) process_net_player(temp);
     else if (temp->type==PLAYER_LOCAL) process_local_player(temp);

     player_count++;
     temp=temp->next;
    }
}

