#ifndef _PARTICLE_H_
#define _PARTICLE_H_

//---------------------------------------------------------------------------
#define MAX_PARTICLES           32          //numarul maxim de definitii de particule

//---------------------------------------------------------------------------
typedef struct PARTICLE_PROP
    {
     struct ANIM *anim;
    } PARTICLE_PROP;

typedef struct PARTICLE
    {
     int    type;
     int    flags;

     float  x, y;
     float  dx, dy;
     float  x2, y2;                 //destinatia
     float  max_speed;              //viteza maxima
     float  speed;                  //vitaza actuala
     float  acc;                    //acceleratia
     int    rep;                    //de cate ori se repeta aniatia

     int    i0, i1, i2, i3;

     struct ANIM *anim;

     struct PARTICLE *next, *prev;
    } PARTICLE;
//---------------------------------------------------------------------------
int particle_types;
PARTICLE_PROP particle_prop[MAX_PARTICLES];

int particle_count;
PARTICLE *particles;

//---------------------------------------------------------------------------
PARTICLE *add_particle(int type, float x, float y, float x1, float x2, float max_speed, float acc, int rep);
void link_particle(PARTICLE *p);
void draw_particles();
void process_particles();

//---------------------------------------------------------------------------
#endif