/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Particle code.
 */

#include "standard.h"
#include "particle.h"

#include "alliance.h"
#include "gfx.h"
#include "panel.h"
#include "misc.h"
#include "script.h"
#include "file.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
PARTICLE *add_particle(int type, float x, float y, float x2, float y2, float max_speed, float acc, int rep)
{
 PARTICLE *temp;

 temp=alloc_mem(sizeof(PARTICLE));
 if (!temp) return NULL;

 temp->type=type;
 temp->x=x;
 temp->y=y;
 temp->x2=acc?x2:x;
 temp->y2=acc?y2:y;
 temp->max_speed=max_speed;
 temp->acc=acc;
 temp->rep=rep;

 temp->anim=animdup(particle_prop[type].anim);

 if (temp->x2!=temp->x || temp->y2!=temp->y)
    {
     temp->anim->rot=get_rot(x, y, x2, y2)+192;
     temp->dx=fixtof(fixcos(ftofix(temp->anim->rot-192)));
     temp->dy=fixtof(fixsin(ftofix(temp->anim->rot-192)));
    }

 link_particle(temp);

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void link_particle(PARTICLE *p)
{
 if (particles==NULL) particles=p;
 else
    {
     p->next=particles;
     particles->prev=p;
     particles=p;
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return: N/A

*****************************************************************************/
void remove_particle(PARTICLE *p)
{
 if (!p) return;

 if (particles==p)
    {
     particles=p->next;
     if (p->next) p->next->prev=NULL;
    }
 else
    {
     if (p->prev) p->prev->next=p->next;
     if (p->next) p->next->prev=p->prev;
    }

 destroy_anim(p->anim);
 free_mem(p);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void draw_particles()
{
 PARTICLE *temp;
 int xs, ys;

 for (temp=particles; temp; temp=temp->next)
    {
     if (!temp->anim) continue;

     xs=temp->x - camera_x;
     ys=temp->y - camera_y;

     draw_anim_centre(camera, temp->anim, xs, ys);
     add_camera_dirty_centre(xs, ys, temp->anim->w, temp->anim->h, 2);
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_particles()
{
 PARTICLE *temp, *temp1;

 particle_count=0;
 temp=particles;
 while (temp)
    {
     temp1=temp->next;

     if (process_anim(temp->anim) && temp->rep>0)
        {
         CALL_SCRIPT1(temp->anim, init, temp->anim);
         temp->rep--;
        }

     if (temp->x2!=temp->x || temp->y2!=temp->y)
        {
         temp->speed+=temp->acc;
         if (temp->speed>temp->max_speed) temp->speed=temp->max_speed;

         temp->i0--;
         if (temp->i0<=0)
            {
             temp->i0=16;

             temp->anim->rot=get_rot(temp->x, temp->y, temp->x2, temp->y2)+192;
             temp->dx=fixtof(fixcos(ftofix(temp->anim->rot-192)));
             temp->dy=fixtof(fixsin(ftofix(temp->anim->rot-192)));
            }

         temp->x+=temp->dx*temp->speed;
         temp->y+=temp->dy*temp->speed;
        }

     if (ABS(temp->x2-temp->x)<=temp->speed*2 && ABS(temp->y2-temp->y)<=temp->speed*2)
        {
         if (temp->rep<=0) remove_particle(temp);
         else
            {
             temp->x=temp->x2;
             temp->y=temp->y2;
            }
        }

     particle_count++;
     temp=temp1;
    }
}
