#ifndef _PANEL_H_
#define _PANEL_H_

//---------------------------------------------------------------------------
#define STATUS_OK                       0
#define STATUS_WAIT_PARAMS              1
#define STATUS_ORDER_OK                 2

//command_opt
#define VIEW_ORDER                      0
#define VIEW_BUILD                      1
#define VIEW_UPGRADE                    2

//radar_opt
#define VIEW_EVERYTHING                 3
#define VIEW_ALLIES                     4
#define VIEW_ENEMIES                    5

#define RADAR_OBJ                      0
#define SELECTION_OBJ                  1
#define COMMAND_OBJ                    2
#define DISPLAY_OBJ                    3
#define RADAR_BTN_OBJ                  4
#define COMMAND_BTN_OBJ                5

#define PUT_IN_RADAR(_x, _y, c)                                         \
    {                                                                   \
     int __x, __y;                                                      \
                                                                        \
     __x=(_x)*radar_x_ratio*radar_zoom-radar_x+panel_dialog[RADAR_OBJ].x;\
     __y=(_y)*radar_y_ratio*radar_zoom-radar_y+panel_dialog[RADAR_OBJ].y;\
                                                                        \
     putpixel(background, __x,   __y,   (c));                           \
     putpixel(background, __x,   __y-1, (c));                           \
     putpixel(background, __x,   __y+1, (c));                           \
     putpixel(background, __x-1, __y,   (c));                           \
     putpixel(background, __x+1, __y,   (c));                           \
    }

//---------------------------------------------------------------------------
extern struct CS_DIALOG panel_dialog[];
struct CS_DIALOG_PLAYER *panel_player;

int     istatus;

int     command_opt, command_pos;
int     radar_opt;
float   radar_zoom;
int     radar_x, radar_y, radar_w, radar_h;

float   slide_speed;
int     slide_dir;

struct ANIM *cursor0, *cursor1;
int     font0, font1, font2, font3, font4, radar_btn, order_btn;
int     resources0, resources1, bord;

//---------------------------------------------------------------------------
void show_tip(char *text, int x, int y, int x1, int y1, int x2, int y2);
void show_resource_tip(char *text, int aluminium, int steel, int gold, int supply, int x, int y, int x1, int y1, int x2, int y2);
void set_params(int x, int y);

int init_panel();
void shutdown_panel();
void process_panel();
void draw_panel();

//---------------------------------------------------------------------------
#endif
