/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.	 
 *
 *	Command panel code - object functions (radar handle func, selection etc)
 */

#include "standard.h"
#include "panel.h"

#include "radar.h"
#include "gfx.h"
#include "alliance.h"
#include "gui.h"
#include "guiproc.h"
#include "map.h"
#include "unit.h"
#include "player.h"
#include "file.h"
#include "misc.h"
#include "particle.h"
#include "netint.h"

struct ORDER order;//deoarece unele ordine accepta parametri, trebuie sa le retinem aici

/*****************************************************************************

    Function: radar_proc

    Description: procedura handler
    Parameters:
    Return:

*****************************************************************************/
int radar_proc(CS_DIALOG *d, int msg, int c)
{
 static long timer=0;
 int mx, my;
 int x, y;
 int i, j, k;
 int x1, y1, x2, y2;
 static float camera_vx=-1, camera_vy=-1;
 static int ready_page=-1;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 switch (msg)
    {
     case MSG_INIT:
         radar_opt=VIEW_EVERYTHING;
         break;

     case MSG_MOUSE_RELEASED:
         x=(float)(mx-d->x+radar_x)/radar_x_ratio/radar_zoom;
         y=(float)(my-d->y+radar_y)/radar_y_ratio/radar_zoom;

         if (c==1)
            {
             if (istatus==STATUS_OK)//misc harta
                {
                 camera_tx=x-CAMERA_W/2;
                 camera_ty=y-CAMERA_H/2;
    
                 fix_map_coords_f(&camera_tx, &camera_ty, CAMERA_W, CAMERA_H);
                }
             else if (istatus==STATUS_WAIT_PARAMS)//daca avem un ordin cu parametri
                {
                 if (order_prop[order.order].params==ORD_PARAM_LOCATION ||
                     order_prop[order.order].params==ORD_PARAM_LOCUNIT)
                    {
                     order.x=x;
                     order.y=y;

                     istatus=STATUS_ORDER_OK;
                    }
                 else
                    {
                     add_msg(font, 50, makecol(255, 255, 0), "Invalid target - must target a unit");
                     istatus=STATUS_OK;
                    }
                }
            }
         else
            {
             memset(&order, 0, sizeof(ORDER));

             order.order=ORD_MOVE;
             order.x=x;
             order.y=y;

             istatus=STATUS_ORDER_OK;
            }
         break;

     case MSG_DRAW:
         if (d->flags&FLAG_DIRTY)
            {
             PLAYER *p;
//             BUILDING *b;
             UNIT *u;
             unsigned short *ptr1;
             unsigned char  *ptr2;
             fixed fix_radar_zoom;

             d->flags&=~FLAG_DIRTY;

             radar_w=map.w*radar_x_ratio*radar_zoom;
             radar_h=map.w*radar_x_ratio*radar_zoom;
             radar_x=camera_x*radar_x_ratio*radar_zoom-64+CAMERA_W*radar_x_ratio/2*radar_zoom;
             radar_y=camera_y*radar_y_ratio*radar_zoom-64+CAMERA_H*radar_y_ratio/2*radar_zoom;
    
             if (radar_x>radar_w-128) radar_x=radar_w-128;
             if (radar_y>radar_h-128) radar_y=radar_h-128;
             if (radar_x<0) radar_x=0;
             if (radar_y<0) radar_y=0;
    
             x1=d->x+camera_x*radar_x_ratio*radar_zoom-radar_x;
             y1=d->y+camera_y*radar_y_ratio*radar_zoom-radar_y;
             x2=x1+CAMERA_W*radar_x_ratio*radar_zoom-1;
             y2=y1+CAMERA_H*radar_y_ratio*radar_zoom-1;

             fix_radar_zoom=ftofix(radar_zoom);
             for (j=0;j<128;j++)
                {
                 ptr1=(unsigned short *)background->line[d->y+j]+d->x;
                 ptr2=me->radar->pages[me->radar->ready_page]->line[fixdiv((j+radar_y)<<16, fix_radar_zoom)>>16];
                 for (i=0;i<128;i++)
                    {
                     k=ptr2[fixdiv((i+radar_x)<<16, fix_radar_zoom)>>16];
                     if (k) ptr1[i]=k*5+11;
                     else ptr1[i]=0;
                    }
                }

             set_clip(background, d->x, d->y, d->x+d->w-1, d->y+d->h-1);

//             for (b=buildings; b; b=b->next) PUT_IN_RADAR(b->x, b->y, makecol(64, 64, 128));

             if (radar_opt==VIEW_ALLIES)
                {
                 for (p=players; p; p=p->next)
                  if (p!=me && relations[me->nr][p->nr]&REL_ALLIES)
                   {
                    for (u=p->units; u; u=u->next)
                    if (u->alive==FLAG_ALIVE && get_unit_visibility(me, u)) PUT_IN_RADAR(u->x, u->y, player_color[p->color]);
                   }
                }
             else if (radar_opt==VIEW_ENEMIES)
                {
                 for (p=players; p; p=p->next)
                  if (p!=me && relations[me->nr][p->nr]&REL_ENEMY)
                   {
                    for (u=p->units; u; u=u->next)
                    if (u->alive==FLAG_ALIVE && get_unit_visibility(me, u)) PUT_IN_RADAR(u->x, u->y, player_color[p->color]);
                   }
                }
             else
                {
                 for (p=players; p; p=p->next)
                  if (p!=me)
                   {
                    for (u=p->units; u; u=u->next)
                    if (u->alive==FLAG_ALIVE && get_unit_visibility(me, u)) PUT_IN_RADAR(u->x, u->y, player_color[p->color]);
                   }
                }

             for (u=me->units; u; u=u->next)
              if (u->alive==FLAG_ALIVE) PUT_IN_RADAR(u->x, u->y, player_color[me->color]);

             drawing_mode(DRAW_MODE_TRANS, 0, 0, 0);
             set_add_blend(0, 0, 0, 255);
             rect(background, x1, y1, x2, y2, makecol(200, 200, 200));
             drawing_mode(DRAW_MODE_SOLID, 0, 0, 0);

             textprintf(background, font, d->x+101, d->y+115, 0, "%0.2fx", radar_zoom);
             textprintf(background, font, d->x+100, d->y+114, makecol(32, 32, 200), "%0.2fx", radar_zoom);

             set_clip(background, 0, 0, 639, 479);
             add_dirty(d->x, d->y, 128, 128, 2);
            }
        break;

     case MSG_PROCESS:
        if (game_count-timer>160 && me->radar->ready)
            {
             d->flags|=FLAG_DIRTY;
             timer=game_count;
             me->radar->ready=0;
            }
        else if ((camera_x!=camera_vx || camera_y!=camera_vy) && game_count-timer>40 && me->radar->ready)
            {
             d->flags|=FLAG_DIRTY;
             timer=game_count;
             camera_vx=camera_x;
             camera_vy=camera_y;
             me->radar->ready=0;
            }
        break;

    }

 return D_O_K;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int radar_btn_proc(CS_DIALOG *d,  int msg, int c)
{
 int mx, my;

 c=c;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 switch (msg)
    {
     case MSG_INIT:
         radar_opt=0;
         radar_zoom=1;
        break;

     case MSG_MOUSE_OVER:
         d->flags|=FLAG_DIRTY;

         if (mx>d->x+2 && mx<d->x+14 && my>d->y+1  && my<d->y+21) show_tip("Show everything", mx, my-32, 0, 0, SCREEN_W, d->y+1);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+23 && my<d->y+43) show_tip("Show allies", mx, my-32, 0, 0, SCREEN_W, d->y+23);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+45 && my<d->y+65) show_tip("Show enemies", mx, my-32, 0, 0, SCREEN_W, d->y+45);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+75 && my<d->y+85) show_tip("Zoom in", mx, my-32, 0, 0, SCREEN_W, d->y+65);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+85 && my<d->y+95) show_tip("Zoom out", mx, my-32, 0, 0, SCREEN_W, d->y+75);
        break;

     case MSG_DRAW:
         if (!(d->flags&FLAG_DIRTY)) break;

         d->flags&=~FLAG_DIRTY;

         add_dirty(d->x, d->y, 12, 96, 2);

         if ((radar_opt==VIEW_EVERYTHING) || (mx>d->x+2 && mx<d->x+14 && my>d->y+1  && my<d->y+21)) blit(gfx[radar_btn].dat, background, 17, 0, d->x, d->y, 12, 20);
         else blit(gfx[radar_btn].dat, background, 0, 0, d->x, d->y, 12, 20);

         if ((radar_opt==VIEW_ALLIES) || (mx>d->x+2 && mx<d->x+14 && my>d->y+23 && my<d->y+43)) blit(gfx[radar_btn].dat, background, 17, 22, d->x, d->y+22, 12, 20);
         else blit(gfx[radar_btn].dat, background, 0, 22, d->x, d->y+22, 12, 20);

         if ((radar_opt==VIEW_ENEMIES) || (mx>d->x+2 && mx<d->x+14 && my>d->y+45 && my<d->y+65)) blit(gfx[radar_btn].dat, background, 17, 44, d->x, d->y+44, 12, 20);
         else blit(gfx[radar_btn].dat, background, 0, 44, d->x, d->y+44, 12, 20);

         if (mx>d->x+2 && mx<d->x+14 && my>d->y+75 && my<d->y+85) blit(gfx[radar_btn].dat, background, 17, 76, d->x, d->y+76, 12, 10);
         else blit(gfx[radar_btn].dat, background, 0, 76, d->x, d->y+76, 12, 10);

         if (mx>d->x+2 && mx<d->x+14 && my>d->y+85 && my<d->y+95) blit(gfx[radar_btn].dat, background, 17, 86, d->x, d->y+86, 12, 10);
         else blit(gfx[radar_btn].dat, background, 0, 86, d->x, d->y+86, 12, 10);
        break;

     case MSG_DCLICK:
     case MSG_MOUSE_PRESSED:
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+1  && my<d->y+21)
            {
             radar_opt=VIEW_EVERYTHING;
             REDRAW(panel_dialog, RADAR_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+23 && my<d->y+43)
            {
             radar_opt=VIEW_ALLIES;
             REDRAW(panel_dialog, RADAR_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+45 && my<d->y+65)
            {
             radar_opt=VIEW_ENEMIES;
             REDRAW(panel_dialog, RADAR_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+75 && my<d->y+85 && radar_zoom<3)
            {
             radar_zoom+=0.003;
             REDRAW(panel_dialog, RADAR_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+85 && my<d->y+95 && radar_zoom>1)
            {
             radar_zoom-=0.003;
             REDRAW(panel_dialog, RADAR_OBJ);
            }
        break;
    }

 return D_O_K;
}
/*****************************************************************************

    Function: selection_proc

    Description: procedura handler
    Parameters:
    Return:

*****************************************************************************/
int selection_proc(CS_DIALOG *d,  int msg, int c)
{
 int i;
 int mx, my, x, y, w, h;
 int life, shield, mana, full_life, full_shield, full_mana;
 int armour, speed, damage, range;
 UNIT *unit, *target;
 ANIM *anim;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 switch (msg)
    {
     case MSG_MOUSE_OVER:
         if (me->selected==1)
            {
             if (mx>d->x+4 && mx<d->x+68 && my>d->y+4 && my<d->y+68)
                {
                 unit=me->selection[0];
                 show_tip(unit_prop[unit->type].name, mx, my-32, 0, 0, SCREEN_W, d->y+4);
                }
            }
         else
            {
             for (i=0;i<MAX_SELECTED;i++)
                {
                 x=(i%6)*35, y=(i/6)*50;
                 if (mx>d->x+4+x && mx<d->x+36+x && my>d->y+4+y && my<d->y+36+y) break;
                }

             if (i<MAX_SELECTED) if (me->selection[i]!=NULL)
                {
                 unit=me->selection[i];
                 show_tip(unit_prop[unit->type].name, mx, my-32, 0, 0, SCREEN_W, d->y+4+i/6*50);
                }
            }
        break;

     case MSG_MOUSE_RELEASED:
         if (me->selected==1)//o singura unitate este selectata
            {
             unit=me->selection[0];

             //click pe icoana
             if (mx>d->x+4 && mx<d->x+68 && my>d->y+4 && my<d->y+68)
                {
                 camera_tx=unit->x-CAMERA_W/2;
                 camera_ty=unit->y-CAMERA_H/2;
                }

             if (command_opt==VIEW_ORDER)
                {
                 //click pe icoana tintei
                 if (mx>d->x+76 && mx<d->x+108 && my>d->y+6 && my<d->y+38)
                    {
                     UNIT *target=unit->orders[0].target;
    
                     if (!target) target=unit->orders[0].temp_target;//aici poate fi tinta temporara in cazul ATTACK LOCATION sau PATROL
                     if (target)
                        {
                         if (c==1) select(me, target, 0);
                         else
                            {
                             camera_tx=target->x-CAMERA_W/2;
                             camera_ty=target->y-CAMERA_H/2;
                            }
                        }
                     else if (unit->orders[0].x!=0 || unit->orders[0].x!=0)
                            {
                             camera_tx=unit->orders[0].x-CAMERA_W/2;
                             camera_ty=unit->orders[0].y-CAMERA_H/2;
                            }
                    }

                 fix_map_coords_f(&camera_tx, &camera_ty, CAMERA_W, CAMERA_H);
                }
             else if (command_opt==VIEW_BUILD)
                {
                 //click pe icoana build-ului curent
                 if (mx>d->x+76 && mx<d->x+108 && my>d->y+4 && my<d->y+36) remove_unit_build(unit, 0);
                 else
                    {
                     for (i=0;i<MAX_BUILDS-1;i++)
                      if (mx>d->x+76+i*35 && mx<d->x+108+i*35 && my>d->y+42 && my<d->y+74) break;

                     if (i<MAX_BUILDS-1) remove_unit_build(unit, i+1);
                    }
                }
             else if (command_opt==VIEW_UPGRADE)
                {
                 //click pe icoana upgrade-ului curent
                 if (mx>d->x+76 && mx<d->x+108 && my>d->y+4 && my<d->y+36) remove_unit_upgrade(unit, 0);
                }
            }
         else//mai multe unitati
            {
             for (i=0;i<MAX_SELECTED;i++)
                {
                 int x=i%6, y=i/6;

                 if (mx>d->x+4+x*35 && mx<d->x+36+x*35 && my>d->y+4+y*50 && my<d->y+36+y*50)
                  break;
                }

             if (i<MAX_SELECTED) if (me->selection[i]!=NULL) select(me, me->selection[i], key_shifts&KB_SHIFT_FLAG);
            }
        break;

     case MSG_DRAW:
         if (!(d->flags&FLAG_DIRTY)) break;

         d->flags&=~FLAG_DIRTY;

         rectfill(background, d->x, d->y, d->x+d->w, d->y+d->h, 0);
         add_dirty(d->x, d->y, d->w, d->h, 2);

         if (!me->selected) break;

         life = shield = mana = full_life = full_shield = full_mana =   0;
         damage = armour = speed = range = 0;
         unit = NULL;
         anim = NULL;

         unit=me->selection[0];
         anim=unit->icon;

         life       += unit->life;
         shield     += unit->shield;
         mana       += unit->mana;
         full_life  += unit_prop[unit->type].life;
         full_shield+= unit_prop[unit->type].shield;
         full_mana  += unit_prop[unit->type].mana;
         damage     += weapon_prop[unit_prop[unit->type].weapon].damage;
         armour     += unit_prop[unit->type].armour;
         speed      += unit_prop[unit->type].speed;
         range      += unit_prop[unit->type].radar_range;

         if (anim)
            {
             if (me->selected==1)
                {
                 anim_flags(anim, ANIM_DOUBLE_FLAG);
                 w=h=64;
                }
             else
                {
                 anim_flags(anim, 0);
                 w=h=32;
                }

             draw_anim(background, anim, d->x+4, d->y+4);

             if (relations[me->nr][me->selection[0]->player->nr]&REL_ME)
                {
                 draw_quantity(background, unit->life,   unit_prop[unit->type].life,   d->x+4, d->y+6+h,  w, 1, makecol(0, 0, 255));
                 draw_quantity(background, unit->shield, unit_prop[unit->type].shield, d->x+4, d->y+9+h,  w, 1, makecol(0, 0, 255));
                 draw_quantity(background, unit->mana,   unit_prop[unit->type].mana,   d->x+4, d->y+12+h, w, 1, makecol(0, 0, 255));
                }
            }

         for (i=1;i<MAX_SELECTED;i++)
          if (me->selection[i]!=NULL)
            {
             int x=i%6, y=i/6;

             anim=NULL;

             unit=me->selection[i];
             anim=unit->icon;

             life       += unit->life;
             shield     += unit->shield;
             mana       += unit->mana;
             full_life  += unit_prop[unit->type].life;
             full_shield+= unit_prop[unit->type].shield;
             full_mana  += unit_prop[unit->type].mana;
             damage     += weapon_prop[unit_prop[unit->type].weapon].damage;
             armour     += unit_prop[unit->type].armour;
             speed      += unit_prop[unit->type].speed;
             range      += unit_prop[unit->type].radar_range;

             if (anim)
                {
                 anim_flags(anim, 0);
                 draw_anim(background, anim, d->x+4+x*35, d->y+4+y*50);

                 if (relations[me->nr][me->selection[0]->player->nr]&REL_ME)
                    {
                     draw_quantity(background, unit->life,   unit_prop[unit->type].life,   d->x+4+x*35, d->y+38+y*50, 32, 1, makecol(0, 0, 255));
                     draw_quantity(background, unit->shield, unit_prop[unit->type].shield, d->x+4+x*35, d->y+41+y*50, 32, 1, makecol(0, 0, 255));
                     draw_quantity(background, unit->mana,   unit_prop[unit->type].mana,   d->x+4+x*35, d->y+44+y*50, 32, 1, makecol(0, 0, 255));
                    }
                }
            }

         if (me->selected>0 && (relations[me->nr][me->selection[0]->player->nr]&REL_ME))//daca sunt selectate  mai multe unitati
            {
             textprintf_centre(background, font, d->x+270, d->y+4,  makecol(64, 64, 255), "Selected: %d", me->selected);
             hline(background, d->x+240, d->y+17, d->x+300, makecol(0, 0, 100));
             textprintf_centre(background, font, d->x+270, d->y+18, makecol(32, 32, 200), "Life: %d/%d", life/me->selected, full_life/me->selected);
             textprintf_centre(background, font, d->x+270, d->y+28, makecol(32, 32, 200), "Shield: %d/%d", shield/me->selected, full_shield/me->selected);
             textprintf_centre(background, font, d->x+270, d->y+38, makecol(32, 32, 200), "Mana: %d/%d", mana/me->selected, full_mana/me->selected);
             hline(background, d->x+240, d->y+51, d->x+300, makecol(0, 0, 100));
             textprintf_centre(background, font, d->x+270, d->y+52, makecol(32, 32, 200), "Damage: %d", damage/me->selected);
             textprintf_centre(background, font, d->x+270, d->y+62, makecol(32, 32, 200), "Armour: %d", armour/me->selected);
             textprintf_centre(background, font, d->x+270, d->y+72, makecol(32, 32, 200), "Speed: %d", speed/me->selected);
             textprintf_centre(background, font, d->x+270, d->y+82, makecol(32, 32, 200), "Range: %d", range/me->selected);
            }

         if (me->selected==1)//este selectata o singura unitate - afiseaza info despre ea
            {
             textprintf_centre(background, font, d->x+4+unit->icon->w/2, d->y+16+unit->icon->h, makecol(48, 48, 255), "%s", unit_prop[unit->type].name);

             if (relations[me->nr][me->selection[0]->player->nr]&REL_ME)
                {
                 if (command_opt==VIEW_ORDER)
                    {
                     char *radar_names[]={"Basic radar", "Sonar", "IR radar", "Anti-stealth radar"};
                     char *cloak_names[]={"Visible", "Silence mode", "Heat reduction", "Stealth"};

                     if ((int)unit->orders[0].x==0 && (int)unit->orders[0].y==0) textprintf(background, font, d->x+112, d->y+4,  makecol(32, 32, 200), "Order: %s", order_prop[unit->orders[0].order].name);
                     else textprintf(background, font, d->x+112, d->y+4,  makecol(32, 32, 200), "Order: %s (%d, %d)", order_prop[unit->orders[0].order].name, (int)unit->orders[0].x, (int)unit->orders[0].y);
                     textprintf(background, font, d->x+112, d->y+14, makecol(32, 32, 200), "Kills: %d", unit->kills);
                     textprintf(background, font, d->x+112, d->y+30, makecol(32, 32, 200), "Aluminium: %d", unit->aluminium);
                     textprintf(background, font, d->x+112, d->y+40, makecol(32, 32, 200), "Steel: %d", unit->steel);
                     textprintf(background, font, d->x+112, d->y+50, makecol(32, 32, 200), "Gold: %d",  unit->gold);
                     textprintf(background, font, d->x+112, d->y+66, makecol(32, 32, 200), "Radar: %s", radar_names[unit_prop[unit->type].radar_type]);
                     textprintf(background, font, d->x+112, d->y+76, makecol(32, 32, 200), "Trace: %s", cloak_names[unit_prop[unit->type].cloaking_type]);
    
                     anim=NULL;
    
                     target=unit->orders[0].target;
                     if (!target) target=unit->orders[0].temp_target;//aici poate fi tinta temporara in cazul ATTACK LOCATION sau PATROL
                     if (target) anim=target->icon;
        
                     if (anim)
                        {
                         anim_flags(anim, 0);
                         draw_anim(background, anim, d->x+76, d->y+4);
                        }
                     else if (unit->orders[0].x || unit->orders[0].y)
                        {
                         int a=get_object(gfx, "ICON039");
                         draw_sprite(background, gfx[a].dat, d->x+76, d->y+4);
                        }
                    }
                 else if (command_opt==VIEW_BUILD)
                    {
                     textprintf(background, font, d->x+112, d->y+4, makecol(32, 32, 255), "Building: %s", build_prop[unit->builds[0].build].name);
                     draw_quantity(background, unit->builds[0].time, build_prop[unit->builds[0].build].time, d->x+112, d->y+22, 100, 8, makecol(0, 0, 255));
    
                     anim=build_prop[unit->builds[0].build].icon;
    
                     anim_flags(anim, 0);
                     draw_anim(background, anim, d->x+76, d->y+4);
    
                     for (i=0;i<MAX_BUILDS-1;i++)
                        {
                         anim=build_prop[unit->builds[i+1].build].icon;
    
                         anim_flags(anim, 0);
                         draw_anim(background, anim, d->x+76+i*35, d->y+40);
                        }
                    }
                 else if (command_opt==VIEW_UPGRADE)
                    {
                     textprintf(background, font, d->x+112, d->y+4, makecol(32, 32, 255), "Upgrading: %s", upgrade_prop[unit->upgrades[0].upgrade].name);
                     draw_quantity(background, unit->upgrades[0].time, upgrade_prop[unit->upgrades[0].upgrade].time, d->x+112, d->y+22, 100, 8, makecol(0, 0, 255));
    
                     anim=upgrade_prop[unit->upgrades[0].upgrade].icon;
    
                     anim_flags(anim, 0);
                     draw_anim(background, anim, d->x+76, d->y+4);
    
                     for (i=0;i<4;i++)
                        {
                         anim=upgrade_prop[i+1].icon;
    
                         anim_flags(anim, 0);
                         draw_anim(background, anim, d->x+76+i*35, d->y+40);
                        }
                    }
                }
             else//unitate inamica
                {
                 textprintf_centre(background,  font, d->x+192, d->y+30, makecol(32, 32, 200), "Aluminium: %d", unit->aluminium);
                 textprintf_centre(background,  font, d->x+192, d->y+40, makecol(32, 32, 200), "Steel: %d", unit->steel);
                 textprintf_centre(background,  font, d->x+192, d->y+50, makecol(32, 32, 200), "Gold: %d",  unit->gold);
                }
            }
        break;

     case MSG_PROCESS:
         for (i=0;i<MAX_SELECTED;i++)
          if (me->selection[i]!=NULL) process_anim(me->selection[i]->icon);
        break;
    }

 return D_O_K;
}
/*****************************************************************************

    Function: order_proc

    Description: procedura handler
    Parameters:
    Return:

*****************************************************************************/
int command_proc(CS_DIALOG *d,    int msg, int c)
{
 int i, j, k, l, found, pos;
 int mx, my, x, y;
 char ch;
 char buf[256];
 static int o_btn[9], b_btn[9], u_btn[9];
 UNIT *unit;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 switch (msg)
    {
     case MSG_INIT:
         for (i=0;i<9;i++)
            {
             o_btn[i]=-1;
             b_btn[i]=-1;
             u_btn[i]=-1;
            }
        break;

     case MSG_MOUSE_OVER:
         if (command_opt==VIEW_ORDER)
            {
             for (i=0;i<9;i++)
                {
                 if (mx>d->x+(i%3)*40 && mx<d->x+(i%3)*40+32 &&
                     my>d->y+8+(i/3)*40 && my<d->y+40+(i/3)*40 &&
                     o_btn[i]>=0) break;

                }

             if (i<9)
                {
                 d->flags|=FLAG_DIRTY;

                 sprintf(buf, "%s (%c)", order_prop[o_btn[i]].name, order_prop[o_btn[i]].key);
                 show_tip(buf, mx, my-32, 0, 0, SCREEN_W, d->y+8+(i/3)*40);
                }
            }
         else if (command_opt==VIEW_BUILD)
            {
             for (i=0;i<9;i++)
                {
                 if (mx>d->x+(i%3)*40 && mx<d->x+(i%3)*40+32 &&
                     my>d->y+8+(i/3)*40 && my<d->y+40+(i/3)*40 &&
                     b_btn[i]>=0) break;
    
                }

             if (i<9)
                {
//               d->flags|=FLAG_DIRTY;

                 sprintf(buf, "Build %s (%c)", build_prop[b_btn[i]].name, build_prop[b_btn[i]].key);
                 show_resource_tip(buf,
                        build_prop[b_btn[i]].aluminium,
                        build_prop[b_btn[i]].steel,
                        build_prop[b_btn[i]].gold,
                        build_prop[b_btn[i]].supply, mx, my-32, 0, 0, SCREEN_W, d->y+8+(i/3)*40);
                }
            }
         else if (command_opt==VIEW_UPGRADE)
            {
             for (i=0;i<9;i++)
                {
                 if (mx>d->x+(i%3)*40 && mx<d->x+(i%3)*40+32 &&
                     my>d->y+8+(i/3)*40 && my<d->y+40+(i/3)*40 &&
                     u_btn[i]>=0) break;

                }

             if (i<9)
                {
                 d->flags|=FLAG_DIRTY;

                 sprintf(buf, "Upgrade %s (%c)", upgrade_prop[u_btn[i]].name, upgrade_prop[u_btn[i]].key);
                 show_resource_tip(buf,
                        upgrade_prop[b_btn[i]].aluminium,
                        upgrade_prop[b_btn[i]].steel,
                        upgrade_prop[b_btn[i]].gold,
                        0, mx, my-32, 0, 0, SCREEN_W, d->y+8+(i/3)*40);
                }
            }
        break;

     case MSG_DRAW:
         if (!(d->flags&FLAG_DIRTY))  break;

         d->flags&=~FLAG_DIRTY;

         rectfill(background, d->x, d->y, d->x+d->w, d->y+d->h, 0);
         add_dirty(d->x, d->y, d->w, d->h, 2);

         if (command_opt==VIEW_ORDER)
            {
             for (i=0;i<9;i++) o_btn[i]=-1;

             //pt fiecare ordin posibil
             found=pos=0;
             for (i=0;i<order_types && pos<9;i++)
             for (j=0;j<MAX_SELECTED;j++)
              if (me->selection[j]!=NULL)
                {
                 unit=me->selection[j];
                 if (!(relations[me->nr][unit->player->nr]&REL_ME)) continue;
    
                 //verifica daca poate executa ordinul
                 for (k=0;k<unit_prop[unit->type].order_count;k++)
                  if (unit_prop[unit->type].order[k]==i)
                    {
                     if (found>=command_pos)
                        {
                         x=d->x+(pos%3)*40;
                         y=d->y+8+(pos/3)*40;
    
                         if ((unit->orders[0].order==i && me->selected==1) || (mx>x && mx<x+32 && my>y && my<y+32)) anim_flags(order_prop[i].icon, ANIM_FOCUS_FLAG);
                         else anim_flags(order_prop[i].icon, 0);

                         draw_anim(background, order_prop[i].icon, x, y);

                         o_btn[pos]=i;//ca sa stie ce ordine sunt afisate in caz de click
                         pos++;   //trece la urmatoarea pozitie
                        }
    
                     found++;
                     j=999;   //nu mai are rost sa verificam unitatile urmatoare pt ca am afisat deja
                     break;
                    }
                }

             if (pos==0 && command_pos>0)
                {
                 command_pos-=9;
                 d->flags|=FLAG_DIRTY;
                }
            }
         else if (command_opt==VIEW_BUILD)
            {
             for (i=0;i<9;i++) b_btn[i]=-1;

             //pt fiecare constructie posibila
             found=pos=0;
             for (i=0;i<build_types && pos<9;i++)
             for (j=0;j<MAX_SELECTED;j++)
               if (me->selection[j]!=NULL)
                {
                 unit=me->selection[j];
                 if (!(relations[me->nr][unit->player->nr]&REL_ME)) continue;
    
                 //verifica daca poate executa ordinul
                 for (k=0;k<unit_prop[unit->type].build_count;k++)
                  if (unit_prop[unit->type].build[k]==i)
                    {
					 //verifica daca au fost indeplinite pre-requisties-urile
					 for (l=0;l<unit_prop[build_prop[i].unit].prerequiste_count;l++) if (me->tech_tree[unit_prop[build_prop[i].unit].prerequiste[l]]==0) break;
					 if (l>=unit_prop[build_prop[i].unit].prerequiste_count)
						{
						 if (found>=command_pos)
							{
							 x=d->x+(pos%3)*40;
							 y=d->y+8+(pos/3)*40;
    
							 anim_flags(build_prop[i].icon, 0);

							 draw_anim(background, build_prop[i].icon, x, y);

							 b_btn[pos]=i;//ca sa stie ce ordine sunt afisate in caz de click
							 pos++;   //trece la urmatoarea pozitie
							}
    
						 found++;
						 j=999;   //nu mai are rost sa verificam unitatile urmatoare pt ca am afisat deja
						 break;
						}
					}
                }

             if (pos==0 && command_pos>0)
                {
                 command_pos-=9;
                 d->flags|=FLAG_DIRTY;
                }
            }
         else if (command_opt==VIEW_UPGRADE)
            {
             for (i=0;i<9;i++) u_btn[i]=-1;

             //pt fiecare upgrade posibil
             found=pos=0;
             for (i=0;i<upgrade_types && pos<9;i++)
             for (j=0;j<MAX_SELECTED;j++)
               if (me->selection[j]!=NULL)
                {
                 unit=me->selection[j];
                 if (!(relations[me->nr][unit->player->nr]&REL_ME)) continue;
    
                 //verifica daca poate executa ordinul
                 for (k=0;k<unit_prop[unit->type].upgrade_count;k++)
                  if (unit_prop[unit->type].upgrade[k]==i)
                    {
                     if (found>=command_pos)
                        {
                         x=d->x+(pos%3)*40;
                         y=d->y+8+(pos/3)*40;
    
                         anim_flags(upgrade_prop[i].icon, 0);

                         draw_anim(background, upgrade_prop[i].icon, x, y);
    
                         u_btn[pos]=i;//ca sa stie ce ordine sunt afisate in caz de click
                         pos++;   //trece la urmatoarea pozitie
                        }
    
                     found++;
                     j=999;   //nu mai are rost sa verificam unitatile urmatoare pt ca am afisat deja
                     break;
                    }
                }

             if (pos==0 && command_pos>0)
                {
                 command_pos-=9;
                 d->flags|=FLAG_DIRTY;
                }
            }
        break;

     case MSG_KEY_RELEASED:
         //este selectata o unitate inamica
         if (me->selected==1) if (!(relations[me->nr][me->selection[0]->player->nr]&REL_ME)) return D_O_K;

         ch=scancode_to_ascii(c);
         if (ch>0)
            {
             if (command_opt==VIEW_ORDER)
                {
                 for (i=0;i<9;i++)
                  if (o_btn[i]>=0) if (order_prop[o_btn[i]].key==ch) break;
    
                 if (i<9)
                    {
                     memset(&order, 0, sizeof(ORDER));
                     order.order=o_btn[i];
    
                     //verifica daca ordinul accepta parametri
                     if (order_prop[order.order].params==ORD_PARAM_NONE) istatus=STATUS_ORDER_OK;
                     else
                        {
                         istatus=STATUS_WAIT_PARAMS;
    
                         add_msg(font, 100, makecol(32, 48, 192), "Select target");
                        }
                    }
                }
             else if (command_opt==VIEW_BUILD)
                {
                 for (i=0;i<build_types;i++) if (build_prop[i].key==ch) break;
    
                 if (i<build_types)
                    {
                     BUILD build;

                     memset(&build, 0, sizeof(BUILD));
                     build.build=i;

                     add_build(me, &build, 1);
                     add_build(me, &build, 1);
                     add_build(me, &build, 1);
                     add_build(me, &build, 1);
                    }
                }
             else if (command_opt==VIEW_UPGRADE)
                {
                 for (i=0;i<upgrade_types;i++) if (upgrade_prop[i].key==ch) break;
    
                 if (i<upgrade_types)
                    {
                     UPGRADE upgrade;

                     memset(&upgrade, 0, sizeof(UPGRADE));
                     upgrade.upgrade=i;

                     add_upgrade(me, &upgrade, 1);
                    }
                }
            }
        break;

     case MSG_DCLICK:
     case MSG_MOUSE_RELEASED:
         //este selecteta o unitate inamica
         if (me->selected==1) if (!(relations[me->nr][me->selection[0]->player->nr]&REL_ME)) return D_O_K;

         if (command_opt==VIEW_ORDER)
            {
             for (i=0;i<9;i++)
                {
                 if (mx>d->x+(i%3)*40 && mx<d->x+(i%3)*40+32 &&
                     my>d->y+8+(i/3)*40 && my<d->y+40+(i/3)*40 &&
                     o_btn[i]>=0) break;
                }
    
             if (o_btn[i]<0) break;

             memset(&order, 0, sizeof(ORDER));
             order.order=o_btn[i];
    
             //verifica daca ordinul accepta parametri
             if (order_prop[order.order].params==ORD_PARAM_NONE) istatus=STATUS_ORDER_OK;
             else
                {
                 istatus=STATUS_WAIT_PARAMS;
    
                 add_msg(font, 100, makecol(32, 48, 192), "Select target");
                }
            }
         else if (command_opt==VIEW_BUILD)
            {
             BUILD build;

             for (i=0;i<9;i++)
                {
                 if (mx>d->x+(i%3)*40 && mx<d->x+(i%3)*40+32 &&
                     my>d->y+8+(i/3)*40 && my<d->y+40+(i/3)*40 &&
                     b_btn[i]>=0) break;
                }
    
             if (i>=9) break;

             memset(&build, 0, sizeof(BUILD));
             build.build=b_btn[i];

             add_build(me, &build, 1);
            }
         else if (command_opt==VIEW_UPGRADE)
            {
             UPGRADE upgrade;

             for (i=0;i<9;i++)
                {
                 if (mx>d->x+(i%3)*40 && mx<d->x+(i%3)*40+32 &&
                     my>d->y+8+(i/3)*40 && my<d->y+40+(i/3)*40 &&
                     u_btn[i]>=0) break;
                }
    
             if (i>=9) break;

             memset(&upgrade, 0, sizeof(UPGRADE));
             upgrade.upgrade=u_btn[i];

             add_upgrade(me, &upgrade, 1);
            }

        break;

     case MSG_PROCESS:
         if (command_opt==VIEW_ORDER)
            {
             for (i=0;i<9;i++)
              if (o_btn[i]>=0) process_anim(order_prop[o_btn[i]].icon);
            }
         else if (command_opt==VIEW_BUILD)
            {
             for (i=0;i<9;i++)
              if (b_btn[i]>=0) process_anim(build_prop[b_btn[i]].icon);
            }
         else if (command_opt==VIEW_UPGRADE)
            {
             for (i=0;i<9;i++)
              if (u_btn[i]>=0) process_anim(build_prop[u_btn[i]].icon);
            }

         //daca avem un ordin gata il trimitem unitatilor selectate
         if (istatus==STATUS_ORDER_OK)
            {
             if (order.target) add_particle(10, order.target->x, order.target->y, 0, 0, 0, 0, 1);
             else add_particle(10, order.x, order.y, 0, 0, 0, 0, 1);

             add_order(me, &order, key_shifts&KB_SHIFT_FLAG);

             istatus=STATUS_OK;
            }
        break;
    }

 return D_O_K;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int command_btn_proc(CS_DIALOG *d,  int msg, int c)
{
 int mx, my;

 c=c;

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 switch (msg)
    {
     case MSG_MOUSE_OVER:
         d->flags|=FLAG_DIRTY;

         if (mx>d->x+2 && mx<d->x+14 && my>d->y+1  && my<d->y+21) show_tip("Orders", mx, my-32, 0, 0, SCREEN_W, d->y+1);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+23 && my<d->y+43) show_tip("Build", mx, my-32, 0, 0, SCREEN_W, d->y+23);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+45 && my<d->y+65) show_tip("Upgrades", mx, my-32, 0, 0, SCREEN_W, d->y+45);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+75 && my<d->y+85) show_tip("Up", mx, my-32, 0, 0, SCREEN_W, d->y+75);
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+85 && my<d->y+95) show_tip("Down", mx, my-32, 0, 0, SCREEN_W, d->y+85);
        break;

     case MSG_DRAW:
         if (!(d->flags&FLAG_DIRTY)) break;

         d->flags&=~FLAG_DIRTY;

         add_dirty(d->x, d->y, 12, 96, 2);

         if ((command_opt==VIEW_ORDER) ||   (mx>d->x+2 && mx<d->x+14 && my>d->y+1  && my<d->y+21)) blit(gfx[order_btn].dat, background, 17, 0, d->x, d->y, 12, 20);
         else blit(gfx[order_btn].dat, background, 0, 0, d->x, d->y, 12, 20);

         if ((command_opt==VIEW_BUILD) ||   (mx>d->x+2 && mx<d->x+14 && my>d->y+23 && my<d->y+43)) blit(gfx[order_btn].dat, background, 17, 22, d->x, d->y+22, 12, 20);
         else blit(gfx[order_btn].dat, background, 0, 22, d->x, d->y+22, 12, 20);

         if ((command_opt==VIEW_UPGRADE) || (mx>d->x+2 && mx<d->x+14 && my>d->y+45 && my<d->y+65)) blit(gfx[order_btn].dat, background, 17, 44, d->x, d->y+44, 12, 20);
         else blit(gfx[order_btn].dat, background, 0, 44, d->x, d->y+44, 12, 20);

         if (mx>d->x+2 && mx<d->x+14 && my>d->y+75 && my<d->y+85) blit(gfx[order_btn].dat, background, 17, 76, d->x, d->y+76, 12, 10);
         else blit(gfx[order_btn].dat, background, 0, 76, d->x, d->y+76, 12, 10);

         if (mx>d->x+2 && mx<d->x+14 && my>d->y+85 && my<d->y+95) blit(gfx[order_btn].dat, background, 17, 86, d->x, d->y+86, 12, 10);
         else blit(gfx[order_btn].dat, background, 0, 86, d->x, d->y+86, 12, 10);
        break;

     case MSG_DCLICK:

     case MSG_MOUSE_RELEASED:
         if (mx>d->x+2 && mx<d->x+14 && my>d->y+1  && my<d->y+21)
            {
             command_opt=VIEW_ORDER;
             command_pos=0;
             if (me->selected==1) REDRAW(panel_dialog, SELECTION_OBJ);
             REDRAW(panel_dialog, COMMAND_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+23 && my<d->y+43)
            {
             command_opt=VIEW_BUILD;
             command_pos=0;
             if (me->selected==1) REDRAW(panel_dialog, SELECTION_OBJ);
             REDRAW(panel_dialog, COMMAND_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+45 && my<d->y+65)
            {
             command_opt=VIEW_UPGRADE;
             command_pos=0;
             if (me->selected==1) REDRAW(panel_dialog, SELECTION_OBJ);
             REDRAW(panel_dialog, COMMAND_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+75 && my<d->y+85 && command_pos>0)
            {
             command_pos-=9;
             REDRAW(panel_dialog, COMMAND_OBJ);
            }
         else if (mx>d->x+2 && mx<d->x+14 && my>d->y+85 && my<d->y+95)
            {
             command_pos+=9;
             REDRAW(panel_dialog, COMMAND_OBJ);
            }
        break;
    }

 return D_O_K;
}
/*****************************************************************************

    Function: display_proc

    Description: procedura handler
    Parameters:
    Return:

*****************************************************************************/
int display_proc(CS_DIALOG  *d, int msg, int c)
{
 static int x1=-1, y1=-1;
 static int rot, timer;
 static float speed=0;
 int mx, my, sel, flag, i;
 int sx, sy, sw, sh;
 UNIT *u[MAX_SELECTED];
 char str[256];

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 switch (msg)
    {
     case MSG_KEY_RELEASED:
         if (c==KEY_1) (key_shifts&KB_CTRL_FLAG)?store_group(me, 1):recall_group(me, 1);
         if (c==KEY_2) (key_shifts&KB_CTRL_FLAG)?store_group(me, 2):recall_group(me, 2);
         if (c==KEY_3) (key_shifts&KB_CTRL_FLAG)?store_group(me, 3):recall_group(me, 3);
         if (c==KEY_4) (key_shifts&KB_CTRL_FLAG)?store_group(me, 4):recall_group(me, 4);
         if (c==KEY_5) (key_shifts&KB_CTRL_FLAG)?store_group(me, 5):recall_group(me, 5);
         if (c==KEY_6) (key_shifts&KB_CTRL_FLAG)?store_group(me, 6):recall_group(me, 6);
         if (c==KEY_7) (key_shifts&KB_CTRL_FLAG)?store_group(me, 7):recall_group(me, 7);
         if (c==KEY_8) (key_shifts&KB_CTRL_FLAG)?store_group(me, 8):recall_group(me, 8);
         if (c==KEY_9) (key_shifts&KB_CTRL_FLAG)?store_group(me, 9):recall_group(me, 9);
         if (c==KEY_0) (key_shifts&KB_CTRL_FLAG)?store_group(me, 0):recall_group(me, 0);

//         if (c==KEY_HOME) max_sprite_cache_size+=1024000;
//         if (c==KEY_END && max_sprite_cache_size>=1024000) max_sprite_cache_size-=1024000;

         if (c==KEY_DEL)
            {
			 ORDER o;

			 o.order=ORD_DIE;
             for (i=0;i<MAX_SELECTED;i++)
              if (me->selection[i]!=NULL) add_unit_order(me->selection[i], &o, 0);
            }

         if (c==KEY_F12)
            {
             BITMAP *temp;
             char *filename, name[256];

             temp=create_sub_bitmap(screen, 0, 0, 640, 480);
             if (temp)
                {
                 filename=tempnam(".", "sc");
                 sprintf(name, "%s.pcx", filename);

                 save_bitmap(name, temp, NULL);
                 add_msg(font, 200, makecol(32, 48, 192), "Screen saved to '%s'.", name);

                 free(filename);
                 destroy_bitmap(temp);
                }
            }
 
         if (c==KEY_PAUSE)
            {
             game_flags^=GAME_FLAG_PAUSED;
             add_msg(font, 200, makecol(32, 48, 192), "%s", game_flags&GAME_FLAG_PAUSED?"Game paused":"Game resumed");
            }
 
         if (c==KEY_0_PAD)
            {
             set_gfx_flags(gfx_flags^GFX_FLAG_AALIASING);
             add_msg(font, 200, makecol(32, 48, 192), "Antialiasing - %s", gfx_flags&GFX_FLAG_AALIASING?"on":"off");
            }
         if (c==KEY_1_PAD)
            {
             gfx_flags^=GFX_FLAG_VSYNC;
             add_msg(font, 200, makecol(32, 48, 192), "Vertical syncronization - %s", gfx_flags&GFX_FLAG_VSYNC?"on":"off");
            }
           
         if (c==KEY_PGUP)
            {
             save_game("aaa.sav");
             add_msg(font, 300, makecol(32, 48, 192), "Saved game to 'aaa.sav'");
            }
         if (c==KEY_PGDN)
            {
             if (load_game("aaa.sav")<0) add_msg(font, 100, makecol(32, 48, 192), "ERROR: %s", error_msg);
             else add_msg(font, 300,  makecol(32, 48, 192), "Loaded game from 'aaa.sav'");
            }

         if (c==KEY_F1)
            {
             clear_selection(me);

             me=me->next;
             if (me==NULL) me=players;
             me->radar->last_unit=NULL;

             add_msg(font, 100, makecol(32, 48, 192), "Current player: %s", me->name);
            }

         if (c==KEY_L)
            {
             if (load_map("level1.map")<0) add_msg(font, 300, makecol(32, 48, 192), "ERROR: %s", error_msg);
             else add_msg(font, 300,  makecol(32, 48, 192), "Loaded 'level1.map'");
            }

         if (c==KEY_ENTER)
            {
             me->aluminium+=1000;
             me->steel+=1000;
             me->gold+=1000;
            }

        break;

     case MSG_MOUSE_PRESSED:
         if (c==1 && x1<0 && !(key_shifts&KB_CTRL_FLAG))
            {
             x1=mx;
             y1=my;
            }
        break;

     case MSG_MOUSE_RELEASED:
         if (c==1 && (key_shifts&KB_CTRL_FLAG)) display_proc(d, MSG_DCLICK, 1);
         else if (c==1)
            {
             sx=MIN(x1, mx);
             sy=MIN(y1, my);
             sw=ABS(mx-x1);
             sh=ABS(my-y1);

             if (istatus==STATUS_OK)//daca selectez ceva
                {
                 sel=get_units(me, REL_ME, -1, sx+camera_x, sy+camera_y, sw, sh, u, MAX_SELECTED);
                 if (sel)
                    {
                     if (me->selected>0)
                        {
//                         if (me->selection[0]->player!=me) clear_selection(me);
                        }

                     select(me, u[0], key_shifts&KB_SHIFT_FLAG);

                     if (sw>8 || sh>8) for (i=1;i<sel;i++) select(me, u[i], 1);
                    }
                 else
                    {
                     sel=get_units(me, -1, -1, sx+camera_x, sy+camera_y, sw, sh, u, MAX_SELECTED);
                     if (sel) select(me, u[0], 0);
                    }
                }
             else if (istatus==STATUS_WAIT_PARAMS)//daca avem un ordin cu parametri
                {
                 set_params(mx+camera_x, my+camera_y);
                }

             x1=-1;
             y1=-1;
            }
         else if (c==2)
            {
             sel=get_units(me, -1, -1, mx+camera_x, my+camera_y, 8, 8, u, MAX_SELECTED);

             if (sel)
                {
                 if (relations[me->nr][u[0]->player->nr]&REL_ENEMY)
                    {
                     memset(&order, 0, sizeof(ORDER));

                     order.order=ORD_ATTACK;
                     order.target=u[0];

                     istatus=STATUS_ORDER_OK;
                    }
                 else
                    {
                     memset(&order, 0, sizeof(ORDER));

                     order.order=ORD_MOVE;
                     order.target=u[0];

                     istatus=STATUS_ORDER_OK;
                    }
                }
             else
                {
                 memset(&order, 0, sizeof(ORDER));

                 order.order=ORD_MOVE;
                 order.x=mx+camera_x;
                 order.y=my+camera_y;

                 istatus=STATUS_ORDER_OK;
                }
            }
        break;

     case MSG_DCLICK:
         if (c==1)
            {
             sel=get_units(me, REL_ME, -1, mx+camera_x, my+camera_y, 8, 8, u, MAX_SELECTED);
             if (sel)
                {
                 if (!(key_shifts&KB_SHIFT_FLAG)) select(me, u[0], 0);
                 else select(me, u[0], 1);

                 sel=get_units(me, REL_ME, u[0]->type, camera_x, camera_y, CAMERA_W, CAMERA_H, u, MAX_SELECTED);
                 if (sel) for (i=0;i<sel;i++) select(me, u[i], 2);
                }
            }
         break;

     case MSG_DRAW:
         set_add_blend(0, 0, 0, 255);
         draw_trans_rle_sprite(buffer, gfx[resources0].dat, 2, 2);

         textprintf(buffer, font, 22,  6, me->aluminium<100?makecol(255, 32, 32):makecol(192, 192, 224), "%d",    me->aluminium);
         textprintf(buffer, font, 76,  6, me->steel<100    ?makecol(255, 32, 32):makecol(192, 192, 224), "%d",    me->steel);
         textprintf(buffer, font, 136, 6, me->gold<100     ?makecol(255, 32, 32):makecol(192, 192, 224), "%d",    me->gold);
         textprintf(buffer, font, 188, 6, me->supply<0     ?makecol(255, 32, 32):makecol(192, 192, 224), "%d:%d", me->unit_count, me->supply);

         add_dirty(0, 0, 236, 16, 2);

         if (x1>=0)
            {
             drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
             trans_rectfill(camera, x1, y1, mx, my, makecol(0, 0, 64));
             rect(camera, x1, y1, mx, my, makecol(32, 32, 255));

//           add_camera_dirty(MIN(x1, mx), y1-1, MAX(x1, mx), y1+1, 2);
//           add_camera_dirty(MIN(x1, mx), my-1, MAX(x1, mx), my+1, 2);
//           add_camera_dirty(x1-1, MIN(y1, my), x1+1, MAX(y1, my), 2);
//           add_camera_dirty(mx-1, MIN(y1, my), mx+1, MAX(y1, my), 2);

             add_camera_dirty(MIN(x1, mx), MIN(y1, my), MAX(x1, mx), MAX(y1, my), 2);
             drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
            }

         if (x1>0 || (mx>d->x && mx<d->x+d->w && my>d->y && my<d->y+d->h))
            {
             if (x1>=0)
                {
                 sx=MIN(x1, mx);
                 sy=MIN(y1, my);
                 sw=ABS(mx-x1);
                 sh=ABS(my-y1);
                }
             else
                {
                 sx=mx;
                 sy=my;
                 sw=1;
                 sh=1;
                }

             sel=get_units(me, REL_ME, -1, sx+camera_x, sy+camera_y, sw, sh, u, MAX_SELECTED);
             if (sel)
                {
                 if (sw<=8 && sh<=8) sel=1;
                 for (i=0;i<sel;i++)
                    {
                     u[i]->anim->lit=100;

                     u[i]->anim->lit_r=63;
                     u[i]->anim->lit_g=63;
                     u[i]->anim->lit_b=255;
                    }
                }
             else
                 {
                  sel=get_units(me, -1, -1, sx+camera_x, sy+camera_y, sw, sh, u, MAX_SELECTED);
                  if (sel)
                     {
                      sel=1;
                      u[0]->anim->lit=100;
                      if (relations[me->nr][u[0]->player->nr]&REL_ENEMY)
                         {
                          u[0]->anim->lit_r=255;
                          u[0]->anim->lit_g=0;
                          u[0]->anim->lit_b=0;
                         }
                      else
                         {
                          u[0]->anim->lit_r=255;
                          u[0]->anim->lit_g=255;
                          u[0]->anim->lit_b=0;
                         }
                     }
                 }

             sprintf(str, "Selected: %d", sel);
             i=text_length(font, str);
             if (sh>10 && sw>i+2)
                {
                 textout_centre(camera, font, str, sx+sw/2, sy+sh/2-6, 0);
                 textout_centre(camera, font, str, sx+sw/2+2, sy+sh/2-6, 0);
                 textout_centre(camera, font, str, sx+sw/2+1, sy+sh/2-7, 0);
                 textout_centre(camera, font, str, sx+sw/2+1, sy+sh/2-5, 0);
                 textout_centre(camera, font, str, sx+sw/2+1, sy+sh/2-6, makecol(255, 255, 255));
                }
            }

         while (game_count-timer>0)
            {
             timer+=2;
             flag=0;
             if (mx<=0 || mx>=639 || my<=0 || my>=479)
                {
                 if (mx<=0)
                    {
                     if (my<=0) rot=160;
                     else if (my>=479) rot=96;
                     else rot=128;
                    }
                 else if (mx>=639)
                    {
                     if (my<=0) rot=224;
                     else if (my>=479) rot=32;
                     else rot=0;
                    }
                 else
                    {
                     if (my<=0) rot=192;
                     else if (my>=479) rot=64;
                    }

                 flag=1;
                }

             if (camera_tx!=camera_x || camera_ty!=camera_y)
                {
                 camera_x=camera_tx;
                 camera_y=camera_ty;
    
                 flag=1;
                }

             if (flag) speed+=0.02;
             else speed-=0.02;
             speed=MID(0, speed, 2);

             if (speed>0)
                {
                 camera_x+=fixtof(fixmul(fixcos(itofix(rot)), ftofix(speed)));
                 camera_y+=fixtof(fixmul(fixsin(itofix(rot)), ftofix(speed)));
                 camera_tx+=fixtof(fixmul(fixcos(itofix(rot)), ftofix(speed)));
                 camera_ty+=fixtof(fixmul(fixsin(itofix(rot)), ftofix(speed)));

                 fix_map_coords_f(&camera_x, &camera_y, CAMERA_W, CAMERA_H);
                 fix_map_coords_f(&camera_tx, &camera_ty, CAMERA_W, CAMERA_H);
                }
            }
        break;

     case MSG_PROCESS:
        break;
    }

 return D_O_K;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void show_tip(char *str, int x, int y, int x1, int y1, int x2, int y2)
{
 int w=text_length(font, str)+4;
 int h=text_height(font);

 if (x<x1) x=x1+1;
 if (y<y1) y=y1+1;
 if (x+w>=x2) x=x2-w-1;
 if (y+h>=y2) y=y2-h-1;

 drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
 trans_rectfill(buffer, x, y, x+w, y+h, makecol(32, 32, 128));
 rect(buffer, x, y, x+w, y+h, makecol(32, 32, 255));
 drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

 textout(buffer, font, str, x+2, y, makecol(255, 255, 255));

 add_dirty(x, y, w, h, 2);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void show_resource_tip(char *str, int aluminium,   int steel, int gold, int supply, int x, int y, int x1, int y1, int x2, int y2)
{
 int h=text_height(font);
 BITMAP *temp1, *temp2;
 char buf[32];
 int pos;

 show_tip(str, x, y, x1, y1, x2, y2-h);

 y+=h;

 temp1=create_bitmap(128, h+1);
 if (!temp1)    return;
 clear_sprite(temp1);

 temp2=create_bitmap(128, h+4);
 if (!temp2)    return;
 clear_sprite(temp2);

 pos=0;
 if (aluminium)
    {
     circlefill(temp1, pos+6, 7, 5, 0);
     masked_blit(gfx[resources1].dat, temp1, 0, 0, pos+2, 1, 10, 10);
    
     sprintf(buf, "%d", aluminium);
     textout(temp2, font, buf, pos+14, 0, -1);

     pos+=(16+text_length(font, buf));
    }
 if (steel)
    {
     circlefill(temp1, pos+6, 7, 5, 0);
     masked_blit(gfx[resources1].dat,   temp1, 10, 0, pos+1, 1, 10, 10);

     sprintf(buf, "%d", steel);
     textout(temp2, font, buf, pos+14, 0, -1);

     pos+=(16+text_length(font, buf));
    }
 if (gold)
    {
     circlefill(temp1, pos+6, 7, 5, 0);
     masked_blit(gfx[resources1].dat,   temp1, 20, 0, pos+2, 1, 10, 10);

     sprintf(buf, "%d", gold);
     textout(temp2, font, buf, pos+14, 0, -1);

     pos+=(16+text_length(font, buf));
    }
 if (supply)
    {
     circlefill(temp1, pos+6, 7, 5, 0);
     masked_blit(gfx[resources1].dat,   temp1, 30, 0, pos+1, 1, 10, 10);

     sprintf(buf, "%d", supply);
     textout(temp2, font, buf, pos+14, 0, -1);

     pos+=(16+text_length(font, buf));
    }

 pos+=2;

 if (x<x1) x=x1+1;
 if (y<y1) y=y1+1;
 if (x+pos>=x2) x=x2-pos;
 if (y+h>=y2) y=y2-h-1;

 set_add_blend(0, 0, 0, 255);
 drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);

 trans_rectfill(buffer, x, y, x+pos, y+h, makecol(32, 32, 128));
 rect(buffer, x, y, x+pos, y+h, makecol(32, 32, 255));

 masked_blit(temp2, buffer, 0, 0, x, y, pos, h);

 //set_add_blend(0, 0, 0, 255);
 draw_sprite(buffer, temp1, x, y);

 add_dirty(x, y, pos, h, 2);

 drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);

 destroy_bitmap(temp1);
 destroy_bitmap(temp2);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void set_params(int x, int y)
{
 UNIT *u[MAX_SELECTED];
 int sel;

 if (order_prop[order.order].params==ORD_PARAM_LOCATION)
    {
     order.x=x;
     order.y=y;

     istatus=STATUS_ORDER_OK;
    }
 else if (order_prop[order.order].params==ORD_PARAM_UNIT)
    {
     sel=get_units(me, -1, -1, x, y, 8, 8, u, MAX_SELECTED);

     //unitate
     if (sel)
        {
         order.target=u[0];

         istatus=STATUS_ORDER_OK;
        }
     else
        {
         add_msg(font, 50, makecol(255, 255, 0), "Invalid target - must target a unit");
         istatus=STATUS_OK;
        }
    }
 else if (order_prop[order.order].params==ORD_PARAM_LOCUNIT)
    {
     sel=get_units(me, -1, -1, x, y, 8, 8, u, MAX_SELECTED);

     //locatie sau unitate
     if (sel)
        {
         order.target=u[0];

         istatus=STATUS_ORDER_OK;
        }
     else
        {
         order.x=x;
         order.y=y;

         istatus=STATUS_ORDER_OK;
        }
    }
}
/*****************************************************************************

    Function: interface_init

    Description: initializeaza interfata
    Parameters: N/A
    Return:  0 daca totul ok
            -1 daca eroare

*****************************************************************************/
 //proc             x       y       w       h       fg      bg  flags   d1      d2      dp      dp2     dp3
CS_DIALOG panel_dialog[]={
  {radar_proc,      7,      347,    128,    128},
  {selection_proc,  160,    372,    318,    100},
  {command_proc,    512,    347,    120,    128},
  {display_proc,    0,      0,      640,    342},
  {radar_btn_proc,  140,    378,    14,     96},
  {command_btn_proc,486,    378,    14,     96},
//  {cs_box_proc,     100,    100,    300,    164},
//  {cs_button_proc,  200,    220,    0,      0,      0,      0,  0,      0,      0,      "Ok", "asta e un tip"},
//  {cs_button_proc,  280,    220,    0,      0,      0,      0,  0,      0,      0,      "Cancel", "asta e un tip"},
  {NULL,            0,      0,      0,      0}};

int init_panel()
{
 camera_x=0;
 camera_y=0;

 radar_opt=0;
 radar_zoom=0;
 command_opt=0;
 command_pos=0;
 istatus=STATUS_OK;

 camera_x=0;
 camera_y=0;
 camera_tx=0;
 camera_ty=0;

 radar_btn=get_object(gfx, "RADAR_BTN"); if (radar_btn<0) return -1;
 order_btn=get_object(gfx, "ORDER_BTN"); if (order_btn<0) return -1;
 font0=get_object(gfx, "FONT0"); if (font0<0) return -1;
 font1=get_object(gfx, "FONT1"); if (font1<0) return -1;
 font2=get_object(gfx, "FONT2"); if (font2<0) return -1;
 font3=get_object(gfx, "FONT3"); if (font3<0) return -1;
 font4=get_object(gfx, "FONT4"); if (font4<0) return -1;
 resources0=get_object(gfx, "RESOURCES"); if (resources0<0) return -1;
 resources1=get_object(gfx, "RES2"); if (resources1<0) return -1;
 bord=get_object(gfx, "BORD1"); if (bord<0) return -1;
 cursor0=compile_animation("cursor0.anm"); if (error_flag) return -1;
 cursor1=compile_animation("cursor1.anm"); if (error_flag) return -1;

 blit(gfx[bord].dat, background, 0, 0,  0, 0, 640, 480);
 add_dirty(0, 0, 640, 480, 2);

 panel_player=init_cs_dialog(panel_dialog);

 return 0;
}
/*****************************************************************************

    Function: interface_shutdown

    Description: dezaloca interfata
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void shutdown_panel()
{
 shutdown_cs_dialog(panel_player);
}
/*****************************************************************************

    Function: draw_interface

    Description: deseneaza interfata
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void draw_panel()
{
 static int vmx, vmy;
 int mx, my;

 draw_cs_dialog(panel_player);
 draw_msgs();

 textprintf(buffer, font, 260, 8, makecol(255, 0, 255), "fps:%d", fps);//, cache:%dk, max_cache:%dk", fps, sprite_cache_size/1024, max_sprite_cache_size/1024);
 add_dirty(260, 8, 200, 16, 1);

 get_mem_info();
 textprintf(buffer, font, 160, 42, makecol(255, 0, 255), "free mem %.03fMb, free virtual %.03fMb", (float)(free_phisical/1048576.0), ((float)free_virtual/1048576.0));
 add_dirty(160,   42, 400, 12, 1);

 my=mouse_pos;
 mx=my>>16;
 my=my-(mx<<16);

 if (fps>80)
    {
     mx=(mx+vmx)/2;
     my=(my+vmy)/2;
    }

 vmx=mx; vmy=my;

 if (istatus==STATUS_WAIT_PARAMS)
    {
     draw_anim_centre(buffer, cursor1, mx, my);
     add_dirty_centre(mx, my, cursor1->w, cursor1->h, 2);
    }
 else
    {
     draw_anim_centre(buffer, cursor0, mx, my);
     add_dirty_centre(mx-1, my, cursor0->w, cursor0->h, 2);
    }       
}
/*****************************************************************************

    Function: process_interface

    Description: proceseaza interfata
    Parameters: N/A
    Return: N/A

*****************************************************************************/
void process_panel()
{
 process_cs_dialog(panel_player);
 process_msgs();

 process_anim(cursor0);
 process_anim(cursor1);
}

