#ifndef _NETINT_H_
#define _NETINT_H_

//--------------------------------------------------------------------------
#define NET_LOOPBACK                    1
#define NET_IPX                         2

#define MAX_PACK_SIZE                   8192

#define PACK_ORDER                      300
#define PACK_REMOVE_ORDER               301
#define PACK_BUILD                      400
#define PACK_REMOVE_BUILD               401
#define PACK_UPGRADE                    500
#define PACK_REMOVE_UPGRADE             501
#define PACK_UNIT_POS                   700
#define PACK_ADD_UNIT                   800
#define PACK_END                        9998
#define PACK_SYNCROIZE                  9999

#define SEND_PACK_ORDER(unit, i, order)                                 \
    {                                                                   \
     begin_net_pack(PACK_ORDER);                                        \
        add_net_packs(2, (short)unit2nr(unit), (short)i);               \
        add_net_packp(sizeof(ORDER), order);                            \
     end_net_pack();                                                    \
    }

#define SEND_PACK_REMOVE_ORDER(unit, i)                                 \
    {                                                                   \
     begin_net_pack(PACK_REMOVE_ORDER);                                 \
        add_net_packs(2, (short)unit2nr(unit), (short)i);               \
     end_net_pack();                                                    \
    }

#define SEND_PACK_BUILD(unit, i, build);                                \
    {                                                                   \
     begin_net_pack(PACK_BUILD);                                        \
        add_net_packs(2, (short)unit2nr(unit), (short)i);               \
        add_net_packp(sizeof(BUILD), build);                            \
        add_net_packs(1, (short)unit2nr(build->unit));                  \
        add_net_packf(1, (float)game_count-build->time);                \
     end_net_pack();                                                    \
    }

#define SEND_PACK_REMOVE_BUILD(unit, i)                                 \
    {                                                                   \
     begin_net_pack(PACK_REMOVE_BUILD);                                 \
        add_net_packs(2, (short)unit2nr(unit), (short)i);               \
     end_net_pack();                                                    \
    }

#define SEND_PACK_UPGRADE(unit, i, upgrade);                            \
    {                                                                   \
     begin_net_pack(PACK_UPGRADE);                                      \
        add_net_packs(2, (short)unit2nr(unit), (short)i);               \
        add_net_packp(sizeof(BUILD), upgrade);                          \
        add_net_packf(1, (float)game_count-upgrade->time);              \
     end_net_pack();                                                    \
    }

#define SEND_PACK_REMOVE_UPGRADE(unit, i)                               \
    {                                                                   \
     begin_net_pack(PACK_REMOVE_UPGRADE);                               \
        add_net_packs(2, (short)unit2nr(unit), (short)i);               \
     end_net_pack();                                                    \
    }

#define SEND_PACK_UNIT_POS(unit)                                        \
    {                                                                   \
     begin_net_pack(PACK_UNIT_POS);                                     \
        add_net_packs(1, (short)unit2nr(unit));                         \
        add_net_packf(2, (float)unit->x, (float)unit->y);               \
     end_net_pack();                                                    \
    }

#define SEND_PACK_ADD_UNIT(unit)                                        \
    {                                                                   \
     begin_net_pack(PACK_ADD_UNIT);                                     \
        add_net_packs(1, (short)unit2nr(unit));                         \
        add_net_packc(1, (char)unit->type);                             \
        add_net_packf(2, (float)unit->x, (float)unit->y);               \
     end_net_pack();                                                    \
    }

#define EXECUTE_PACK_ORDER(b)                                           \
    {                                                                   \
     UNIT *unit;                                                        \
     int i, nr1, nr2;                                                   \
                                                                        \
     unit=nr2unit(me->next, *(short *)&p[0]);                           \
     i=*(short *)&p[2];                                                 \
                                                                        \
     memcpy(&unit->orders[i], &p[4], sizeof(ORDER));                    \
                                                                        \
     if (order_prop[unit->orders[i].order].params==ORD_PARAM_UNIT ||    \
         order_prop[unit->orders[i].order].params==ORD_PARAM_LOCUNIT)   \
        {                                                               \
         nr1=*(short *)&p[4+sizeof(ORDER)];                             \
         nr2=*(short *)&p[6+sizeof(ORDER)];                             \
         unit->orders[i].target=nr2unit(nr2player(nr1), nr2);           \
                                                                        \
         nr1=*(short *)&p[8+sizeof(ORDER)];                             \
         nr2=*(short *)&p[10+sizeof(ORDER)];                            \
         unit->orders[i].temp_target=nr2unit(nr2player(nr1), nr2);      \
        }                                                               \
    }

#define EXECUTE_PACK_UNIT_POS(b)                                        \
    {                                                                   \
     UNIT *unit;                                                        \
     float x, y;                                                        \
                                                                        \
     unit   =nr2unit(me->next, *(short *)&p[0]);                        \
     x      =*(float *)&p[2];                                           \
     y      =*(float *)&p[6];                                           \
                                                                        \
     unit->x=x;                                                         \
     unit->y=y;                                                         \
    }

#define EXECUTE_PACK_ADD_UNIT(b)                                        \
    {                                                                   \
     int nr, type;                                                      \
     float x, y;                                                        \
                                                                        \
     nr     =*(short *)&p[0];                                           \
     type   =*(char *) &p[2];                                           \
     x      =*(float *)&p[3];                                           \
     y      =*(float *)&p[7];                                           \
                                                                        \
     add_unit(me->next, nr, type, x, y);                                \
    }

//--------------------------------------------------------------------------
typedef struct NET_PACK
    {
     int    type;
     long   time;
     int    size;
     void   *p;

     struct NET_PACK *next, *prev;
    } NET_PACK;

//--------------------------------------------------------------------------
NET_PACK *net_out, *net_in, *net_pack;
int net_driver;
int net_flow, net_flow_count;

//---------------------------------------------------------------------------
int init_net();
void shutdown_net();

int create_game();
int join_game();

int begin_net_pack(int type);
int end_net_pack();
int add_net_packp(int size, void *p);
int add_net_packf(int nr,...);
int add_net_packs(int nr,...);
int add_net_packc(int nr,...);

NET_PACK *get_net_pack();
void process_net(void *p);
void process_loopback(void *p);

//---------------------------------------------------------------------------
#endif