/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Network code
 */

#include "standard.h"
#include "netint.h"

#include "unit.h"
#include "file.h"
#include "alliance.h"
#include "player.h"
#include "misc.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int create_game()
{
 NLsocket sock;
 NLaddress addr;
 NLbyte      string[NL_MAX_STRING_LENGTH];
 int line=0;

 sock=nlOpen(16000, NL_RELIABLE);
 if (sock==NL_INVALID) allegro_message("S: error opening socket");

 if (nlListen(sock)!=NL_TRUE) allegro_message("S: listen error");

 nlGetLocalAddr(sock, &addr);
 //textprintf(screen, font, 0, line+=16, 255, "Server address is %s\n", nlAddrToString(&addr, string));
 allegro_message("S: address: %s", nlAddrToString(&addr, string));

 while(1)
	{
     NLint   i;
     NLbyte  buffer[128];

     /* check for a new client */
     NLsocket newsock = nlAcceptConnection(sock);

     if(newsock != NL_INVALID)
        {
         NLaddress   addr;

         nlGetRemoteAddr(newsock, &addr);
         //textprintf(screen, font, 0, line+=16, 255, "Client connected from %s\n", nlAddrToString(&addr, string));
		 allegro_message("S: client connected from: %s", nlAddrToString(&addr, string));
        }
     else
        {
         if(nlGetError() == NL_SOCKET_ERROR)
            {
             //alert("Fatal error:", "accept error", "Try restarting...", "Oh shit!", NULL, 0, 0);
			 allegro_message("S: accept error"); 
            }
        }
    }

}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int join_game()
{
 NLsocket sock;
 NLaddress addr;
 NLbyte      string[NL_MAX_STRING_LENGTH];
 int line=0;

 sock=nlOpen(16001, NL_RELIABLE);
 if (sock==NL_INVALID) allegro_message("C: error opening socket");

 nlGetLocalAddr(sock, &addr);
 //textprintf(screen, font, 0, line+=16, 255, "our address is %s\n", nlAddrToString(&addr, string));
 allegro_message("C: address: %s", nlAddrToString(&addr, string));

 nlStringToAddr("127.0.0.1:16000", &addr);
 if (nlConnect(sock, &addr)!=NL_TRUE) allegro_message("C: connect error");

 while(1)
	{
    }
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int init_net()
{
 if (nlInit()!=NL_TRUE) 
	{
	 sprintf(error_msg, "%s", nlGetErrorStr(nlGetError()));
	 error_flag=1;

	 return -1;
	}

 LOG("\n\tNetwork types found: %s", nlGetString(NL_NETWORK_TYPES));

 if(nlSelectNetwork(NL_IP)!=NL_TRUE) 
	{
	 LOG("\n\tTCP/IP not avaiable! Network disabled.");

	 return 0;
	}
 else LOG("\n\tUsing TCP/IP.");
 LOG("\n\tConnection types: %s", nlGetString(NL_CONNECTION_TYPES));
   
 return 0;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void shutdown_net()
{
 nlShutdown();
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void process_net(void *player)
{
}

