/*
 *  Alliance - just a strategy game...
 *
 *  by Vasile Catalin
 *
 *  forestierul@yahoo.com
 *  www.geocities.com/forestierul
 *
 *  See readme.txt for copyright information.
 *
 *	Miscelaneous functions. Math, memory management etc...
 */

#include "standard.h"
#include "misc.h"

#include "alliance.h"
#include "gfx.h"
#include "file.h"

/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int get_rot(int x1, int y1, int x2, int y2)
{
 float dx, dy, d, rot;

 dx=x2 - x1;
 dy=y2 - y1;
 //if (dx==0 && dy==0) return 0;

 d=hypot(dx, dy);
 if (d==0) d=0.1;

 rot=fixtof(fixasin(ftofix(dy/d)));

 if (dx<0) rot=128-rot;
 else if (dy<0) rot=256+rot;

 return rot;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
int get_dist(int x1, int y1, int x2, int y2)
{
 float dx, dy;

 dx=x2-x1;
 dy=y2-y1;

 return hypot(dx, dy);
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
float _cos(int a) {return fixtof(fixcos(itofix(a)));}
float _sin(int a) {return fixtof(fixsin(itofix(a)));}

void get_rotated_dim(int *w, int *h, int a)
{
 float fw, fh;
 int rot1, rot2;
 float m;

 if (a==0) return;

 fw=(float)*w;
 fh=(float)*h;
 m=MAX(fw, fh)*1.4;
 rot1=get_rot(fw/2, fh/2, fw, fh);//diagonala principala    /
 rot2=get_rot(fw/2, fh/2, 0, fh); //diagonala secundara

 *w=MAX(ABS(_cos(a+rot1)), ABS(_cos(a+rot2)))*m;
 *h=MAX(ABS(_sin(a+rot1)), ABS(_sin(a+rot2)))*m;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void get_rotated_pos(int *x, int *y, int a)
{
 int rot, dist;

 rot=get_rot(0, 0, *x, *y)+a+1;
 dist=get_dist(0, 0, *x, *y);

 *x=fixtof(fixcos(itofix(rot%256)))*dist;
 *y=fixtof(fixsin(itofix(rot%256)))*dist;
}
/*****************************************************************************

    Function: rotate

    Description: roteste in sistemul 0-255 (0-360)
    Parameters: (src) - sursa de rotit
                (dest)- rotatia destinatie
                (step)- pasul rotatiei
    Return: N/A

*****************************************************************************/
void rotate(int *src, int dest, int step)
{
 int s=(*src)%256;

 dest%=256;

 if (ABS(s-dest)<128)
    {
     if (s<dest)
        {
         s+=step;
         if (s>dest) s=dest;
        }
     else if (s>dest)
        {
         s-=step;
         if (s<dest) s=dest;
        }
    }
 else
    {
     if (s<dest)
        {
         s-=step;
         if (s>dest) s=dest;
        }
     else if (s>dest)
        {
         s+=step;
         if (s<dest) s=dest;
        }
    }

 while (s<0) s+=256;

 (*src)=s;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void *alloc_mem(int size)
{
 int count=0;
 void *temp;

 temp=NULL;
 while (count<4 && !temp)
    {
     temp=malloc(size);

     count++;
    }

 if (temp) memset(temp, 0, size);

 return temp;
}
/*****************************************************************************

    Function:

    Description:
    Parameters:
    Return:

*****************************************************************************/
void _free_mem(void *p)
{
 assert(p);

 free(p);
 p=NULL;

 return;
}

